/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.LabelPair;
import org.igoweb.util.swing.SingletonWindow;

public class NumberingWindow
extends DFrame
implements ActionListener {
    private final JButton okBut;
    private final JButton removeBut;
    private final ATextField start;
    private final ATextField end;
    private final JCheckBox twoDigits;
    private final GamePanel parent;
    private static final NumberFormat normalFormat = NumberFormat.getNumberInstance();
    private static final NumberFormat forceZero = NumberFormat.getNumberInstance();
    private final EventListener treeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (event.type == 7) {
                NumberingWindow.this.dispose();
            }
        }
    };

    public NumberingWindow(GamePanel parent) {
        super(Defs.getString(-451068490), parent);
        this.parent = parent;
        parent.stopAutoPlay();
        LabelPair.Group group = new LabelPair.Group();
        this.start = new ATextField(normalFormat.format(1L));
        this.getMainPanel().add("xGrow=t", new LabelPair(Defs.getString(-451068482), this.start, group));
        this.end = new ATextField(normalFormat.format(parent.getSgfTree().getActiveNode().getMoveNum()));
        this.getMainPanel().add("x=0", new LabelPair(Defs.getString(-451068505), this.end, group));
        this.twoDigits = new JCheckBox(Defs.getString(-451068478));
        this.getMainPanel().add("x=0", this.twoDigits);
        this.okBut = this.addButton(Defs.getString(1436228518), this);
        this.removeBut = this.addButton(Defs.getString(-451068488), this);
        this.addButton(Defs.getString(1436228510), this);
        parent.getSgfTree().addListener(this.treeListener);
        this.pack(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okBut) {
            ParsePosition parsePos;
            int min = 0;
            int max = 0;
            String errStr = this.start.getText().trim();
            Number parseOut = normalFormat.parse(errStr, parsePos = new ParsePosition(0));
            if (parseOut != null) {
                min = parseOut.intValue();
                if (parsePos.getIndex() == errStr.length() && (parseOut = normalFormat.parse(errStr = this.end.getText().trim(), parsePos = new ParsePosition(0))) != null) {
                    max = parseOut.intValue();
                    if (parsePos.getIndex() == errStr.length()) {
                        errStr = null;
                    }
                }
            }
            if (errStr != null) {
                new Errout(Defs.getString(-451068510, errStr), this);
                return;
            }
            Node node = this.parent.getSgfTree().root;
            while (true) {
                int moveNum;
                Prop move;
                if ((move = node.findProp(14)) != null && move.getLoc() != Loc.PASS && (moveNum = node.getMoveNum()) >= min && moveNum <= max) {
                    NumberFormat formatter = normalFormat;
                    if (this.twoDigits.isSelected() && moveNum > 99) {
                        moveNum %= 100;
                        formatter = forceZero;
                    }
                    this.parent.addProp(new Prop(19, move.getLoc(), formatter.format(moveNum)));
                }
                if (node != this.parent.getSgfTree().getActiveNode()) {
                    node = node.getActiveChild();
                    continue;
                }
                break;
            }
        } else if (event.getSource() == this.removeBut) {
            ArrayList<Prop> paramsToRm = new ArrayList<Prop>();
            for (Prop param : this.parent.getSgfTree().getActiveNode()) {
                if (param.type != 19 || !Character.isDigit(param.getText().charAt(0))) continue;
                paramsToRm.add(param);
            }
            Iterator<Prop> it = paramsToRm.iterator();
            while (it.hasNext()) {
                this.parent.removeProp(it.next());
            }
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        this.parent.getSgfTree().removeListener(this.treeListener);
        super.dispose();
    }

    public static JMenuItem createMenuItem(final GamePanel gamePanel) {
        JMenuItem mi = new JMenuItem(Defs.getString(-451068490));
        mi.addActionListener(new ActionListener(){
            private final SingletonWindow win = new SingletonWindow();

            @Override
            public void actionPerformed(ActionEvent event) {
                this.win.dispose();
                this.win.setWindow(new NumberingWindow(gamePanel));
            }
        });
        return mi;
    }

    static {
        forceZero.setMinimumIntegerDigits(2);
        normalFormat.setParseIntegerOnly(true);
    }
}

