/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import javax.sound.sampled.AudioFormat;
import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.NbDecoder;
import org.xiph.speex.SbDecoder;
import org.xiph.speex.spi.FilteredAudioInputStream;

public class Speex2PcmAudioInputStream
extends FilteredAudioInputStream {
    private int sampleRate;
    private int channelCount;
    private float[] decodedData;
    private byte[] outputData;
    private Bits bits = new Bits();
    private Decoder decoder;
    private int frameSize;
    private int framesPerPacket;
    private int streamSerialNumber;
    private int packetsPerOggPage;
    private int packetCount;
    private byte[] packetSizes = new byte[256];
    private boolean first = true;

    public Speex2PcmAudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l) {
        this(inputStream, audioFormat, l, 2048);
    }

    public Speex2PcmAudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l, int n) {
        super(inputStream, audioFormat, l, n);
    }

    protected void initDecoder() throws IOException {
        if (!new String(this.prebuf, 0, 4).equals("OggS")) {
            throw new StreamCorruptedException("The given stream does not appear to be Ogg.");
        }
        this.streamSerialNumber = Speex2PcmAudioInputStream.readInt(this.prebuf, 14);
        if (!new String(this.prebuf, 28, 8).equals("Speex   ")) {
            throw new StreamCorruptedException("The given stream does not appear to be Ogg Speex.");
        }
        this.sampleRate = Speex2PcmAudioInputStream.readInt(this.prebuf, 64);
        this.channelCount = Speex2PcmAudioInputStream.readInt(this.prebuf, 76);
        this.framesPerPacket = Speex2PcmAudioInputStream.readInt(this.prebuf, 92);
        int n = Speex2PcmAudioInputStream.readInt(this.prebuf, 68);
        switch (n) {
            case 0: {
                this.decoder = new NbDecoder();
                ((NbDecoder)this.decoder).nbinit();
                break;
            }
            case 1: {
                this.decoder = new SbDecoder();
                ((SbDecoder)this.decoder).wbinit();
                break;
            }
            case 2: {
                this.decoder = new SbDecoder();
                ((SbDecoder)this.decoder).uwbinit();
                break;
            }
        }
        this.decoder.setPerceptualEnhancement(true);
        this.frameSize = this.decoder.getFrameSize();
        this.decodedData = new float[this.framesPerPacket * this.frameSize * this.channelCount];
        this.outputData = new byte[2 * this.framesPerPacket * this.frameSize * this.channelCount];
        this.bits.init();
    }

    protected void fill() throws IOException {
        int n;
        int n2;
        this.makeSpace();
        while (true) {
            if ((n2 = this.in.read(this.prebuf, this.precount, this.prebuf.length - this.precount)) < 0) {
                if (this.first) {
                    throw new StreamCorruptedException("Incomplete Ogg Headers");
                }
                while (this.prepos < this.precount) {
                    if (this.packetCount >= this.packetsPerOggPage) {
                        this.readOggPageHeader();
                    }
                    if (this.precount - this.prepos < (n2 = this.packetSizes[this.packetCount++])) {
                        throw new StreamCorruptedException("Incompleted last Speex packet");
                    }
                    this.decode(this.prebuf, this.prepos, n2);
                    this.prepos += n2;
                    while (this.buf.length - this.count < this.outputData.length) {
                        n = this.buf.length * 2;
                        byte[] byArray = new byte[n];
                        System.arraycopy(this.buf, 0, byArray, 0, this.count);
                        this.buf = byArray;
                    }
                    System.arraycopy(this.outputData, 0, this.buf, this.count, this.outputData.length);
                    this.count += this.outputData.length;
                }
                return;
            }
            if (n2 <= 0) continue;
            this.precount += n2;
            if (this.first) {
                if (this.decoder == null && this.precount >= 108) {
                    this.initDecoder();
                }
                if (this.decoder != null && this.precount >= 135) {
                    this.packetsPerOggPage = 0xFF & this.prebuf[134];
                    if (this.precount >= 135 + this.packetsPerOggPage) {
                        n = 0;
                        for (int i = 0; i < this.packetsPerOggPage; ++i) {
                            n += 0xFF & this.prebuf[135 + i];
                        }
                        if (this.precount >= 135 + this.packetsPerOggPage + n) {
                            this.prepos = 135 + this.packetsPerOggPage + n;
                            this.packetsPerOggPage = 0;
                            this.packetCount = 255;
                            this.first = false;
                        }
                    }
                }
            }
            if (this.first) continue;
            if (this.packetCount >= this.packetsPerOggPage) {
                this.readOggPageHeader();
            }
            if (this.packetCount < this.packetsPerOggPage && this.precount - this.prepos >= this.packetSizes[this.packetCount]) break;
        }
        while (this.precount - this.prepos >= this.packetSizes[this.packetCount] && this.packetCount < this.packetsPerOggPage) {
            n2 = this.packetSizes[this.packetCount++];
            this.decode(this.prebuf, this.prepos, n2);
            this.prepos += n2;
            while (this.buf.length - this.count < this.outputData.length) {
                n = this.buf.length * 2;
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, 0, byArray, 0, this.count);
                this.buf = byArray;
            }
            System.arraycopy(this.outputData, 0, this.buf, this.count, this.outputData.length);
            this.count += this.outputData.length;
            if (this.packetCount < this.packetsPerOggPage) continue;
            this.readOggPageHeader();
        }
        System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
        this.precount -= this.prepos;
        this.prepos = 0;
    }

    protected void decode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        this.bits.read_from(byArray, n, n2);
        for (int i = 0; i < this.framesPerPacket; ++i) {
            int n4;
            this.decoder.decode(this.bits, this.decodedData);
            if (this.channelCount == 2) {
                this.decoder.decodeStereo(this.decodedData, this.frameSize);
            }
            for (n4 = 0; n4 < this.frameSize * this.channelCount; ++n4) {
                if (this.decodedData[n4] > 32767.0f) {
                    this.decodedData[n4] = 32767.0f;
                    continue;
                }
                if (!(this.decodedData[n4] < -32768.0f)) continue;
                this.decodedData[n4] = -32768.0f;
            }
            for (n4 = 0; n4 < this.frameSize * this.channelCount; ++n4) {
                short s = this.decodedData[n4] > 0.0f ? (short)((double)this.decodedData[n4] + 0.5) : (short)((double)this.decodedData[n4] - 0.5);
                this.outputData[n3++] = (byte)(s & 0xFF);
                this.outputData[n3++] = (byte)(s >> 8 & 0xFF);
            }
        }
    }

    public synchronized int available() throws IOException {
        int n = super.available();
        if (this.packetCount < this.packetsPerOggPage) {
            int n2 = this.precount - this.prepos + this.in.available();
            byte by = this.packetSizes[this.packetCount];
            int n3 = 0;
            while (by < n2 && this.packetCount + n3 < this.packetsPerOggPage) {
                n2 -= by;
                n += 2 * this.frameSize * this.framesPerPacket;
                by = this.packetSizes[this.packetCount + ++n3];
            }
        }
        return n;
    }

    private void readOggPageHeader() throws IOException {
        int n = 1;
        if (this.precount - this.prepos >= 28) {
            if (!new String(this.prebuf, this.prepos, 4).equals("OggS")) {
                throw new StreamCorruptedException("Lost Ogg Sync");
            }
            if (this.streamSerialNumber != Speex2PcmAudioInputStream.readInt(this.prebuf, this.prepos + 14)) {
                throw new StreamCorruptedException("Ogg Stream Serial Number mismatch");
            }
            n = 0xFF & this.prebuf[this.prepos + 26];
        }
        if (this.precount - this.prepos >= 27 + n) {
            System.arraycopy(this.prebuf, this.prepos + 27, this.packetSizes, 0, n);
            this.packetCount = 0;
            this.prepos += 27 + n;
            this.packetsPerOggPage = n;
        }
    }

    private static int readInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }
}

