/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.UIManager;

public class TagIcon
implements Icon {
    private static final float TAG_W = 0.05f;
    private static final float TAG_HALF_HEIGHT = 0.35f;
    private static final float TAG_NOSE_WIDTH = 0.25f;
    private static final double NOSE_ANGLE = Math.atan(1.4f);
    private static final float NOSE_INSET = 0.05f / (float)Math.sin(NOSE_ANGLE);
    private static final float NOSE_SHOULDER_X = 0.25f + 0.05f / (float)Math.cos(NOSE_ANGLE);
    private static final float WRITE_A_X = NOSE_SHOULDER_X + 0.05f;
    private static final float WRITE_A_Y = 0.75f;
    private static final float WRITE_WIDTH = 1.0f - (0.1f + WRITE_A_X);
    private static final float WRITE_HEIGHT = 0.5f;
    private static final float WRITE_I_X = WRITE_A_X + (WRITE_WIDTH - 0.05f) * 0.5f;
    private static final float WRITE_D_X = WRITE_A_X + (WRITE_WIDTH + 0.05f) * 0.5f;
    private static final float WRITE_D_Y = 0.25f;
    private static final float WRITE_ANGLE = (float)(Math.atan((WRITE_D_X - WRITE_A_X) / 0.5f) + Math.asin((double)0.05f / Math.sqrt((WRITE_D_X - WRITE_A_X) * (WRITE_D_X - WRITE_A_X) + 0.25f)));
    private static final float WRITE_I_Y = 0.75f - (float)Math.tan(1.5707963267948966 - (double)WRITE_ANGLE) * (WRITE_I_X - WRITE_A_X);
    private static final float WRITE_Y_OFFSET = (float)((double)0.05f / Math.tan(WRITE_ANGLE));
    private static final GeneralPath BASE_SHAPE = TagIcon.buildBaseShape();

    @Override
    public int getIconHeight() {
        return UIManager.getInt("org.igoweb.fontH");
    }

    @Override
    public int getIconWidth() {
        return UIManager.getInt("org.igoweb.fontH");
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (c.isEnabled()) {
            g2d.setColor(c.getForeground());
        } else {
            g2d.setColor(UIManager.getColor("org.igoweb.stdBg").darker());
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.transform(AffineTransform.getTranslateInstance(x, y));
        double size = (double)UIManager.getInt("org.igoweb.fontH") * 0.922778056559;
        g2d.transform(AffineTransform.getScaleInstance(size, size));
        g2d.fill(BASE_SHAPE);
        g2d.dispose();
    }

    public static GeneralPath buildBaseShape() {
        GeneralPath path = new GeneralPath(1, 8);
        path.moveTo(0.0f, 0.5f);
        path.lineTo(0.25f, 0.15f);
        path.lineTo(1.0f, 0.15f);
        path.lineTo(1.0f, 0.85f);
        path.lineTo(0.25f, 0.85f);
        path.closePath();
        path.moveTo(NOSE_INSET, 0.5f);
        path.lineTo(NOSE_SHOULDER_X, 0.8f);
        path.lineTo(0.95f, 0.8f);
        path.lineTo(0.95f, 0.2f);
        path.lineTo(NOSE_SHOULDER_X, 0.2f);
        path.closePath();
        path.moveTo(WRITE_A_X, 0.75f);
        path.lineTo(WRITE_A_X, 0.75f - WRITE_Y_OFFSET);
        path.lineTo(WRITE_D_X, 0.25f);
        path.lineTo(WRITE_D_X, 1.0f - WRITE_I_Y);
        path.lineTo(0.9f, 0.25f);
        path.lineTo(0.9f, 0.25f + WRITE_Y_OFFSET);
        path.lineTo(WRITE_I_X, 0.75f);
        path.lineTo(WRITE_I_X, WRITE_I_Y);
        path.closePath();
        AffineTransform af = AffineTransform.getRotateInstance(-0.3141592653589793, 0.5, 0.5);
        path.transform(af);
        return path;
    }
}

