/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.apollo.broker.transport.TransportFactory;
import org.apache.activemq.apollo.util.IntrospectionSupport;
import org.apache.activemq.apollo.util.URISupport;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.UdpTransport;
import org.fusesource.hawtdispatch.transport.UdpTransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpTransportFactory
implements TransportFactory.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransportFactory.class);

    @Override
    public TransportServer bind(String location) throws Exception {
        URI uri = new URI(location);
        HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParamters((URI)uri));
        UdpTransportServer server = this.createUdpTransportServer(uri, options);
        if (server == null) {
            return null;
        }
        HashMap<String, String> copy = new HashMap<String, String>(options);
        IntrospectionSupport.setProperties((Object)server, new HashMap<String, String>(options));
        return server;
    }

    @Override
    public Transport connect(String location) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected UdpTransportServer createUdpTransportServer(URI location, final Map<String, String> options) throws IOException, URISyntaxException, Exception {
        if (!location.getScheme().equals("udp")) {
            return null;
        }
        return new UdpTransportServer(location){

            protected UdpTransport createTransport() {
                UdpTransport transport = super.createTransport();
                IntrospectionSupport.setProperties((Object)transport, new HashMap(options));
                return transport;
            }
        };
    }
}

