/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Popup {
    public void show() {
    }

    public void hide() {
    }

    protected Popup(Component owner, Component contents, int x, int y) {
        if (contents == null) {
            throw new IllegalArgumentException();
        }
    }

    protected Popup() {
    }

    static class LightweightPopup
    extends Popup {
        Component owner;
        Component contents;
        int x;
        int y;
        private JPanel panel;

        public void show() {
            JRootPane rootPane = SwingUtilities.getRootPane(this.owner);
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(null);
            }
            this.panel.add(this.contents);
            this.panel.setSize(this.contents.getSize());
            Point layeredPaneLoc = layeredPane.getLocationOnScreen();
            this.panel.setLocation(this.x - layeredPaneLoc.x, this.y - layeredPaneLoc.y);
            layeredPane.add((Component)this.panel, JLayeredPane.POPUP_LAYER);
        }

        public void hide() {
            JRootPane rootPane = SwingUtilities.getRootPane(this.owner);
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            layeredPane.remove(this.panel);
        }

        public LightweightPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
            this.owner = owner;
            this.contents = contents;
            this.x = x;
            this.y = y;
        }
    }

    static class JWindowPopup
    extends Popup {
        JWindow window;
        private Component contents;

        public void show() {
            this.window.setSize(this.contents.getSize());
            this.window.show();
        }

        public void hide() {
            this.window.dispose();
        }

        public JWindowPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
            this.contents = contents;
            this.window = new JWindow();
            this.window.getContentPane().add(contents);
            this.window.setLocation(x, y);
            this.window.setFocusableWindowState(false);
        }
    }
}

