/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.SingletonWindow;

public class VarLabelWindow
extends DFrame
implements ActionListener {
    private final JButton okBut;
    private final JComboBox<String> combo = new JComboBox();
    private final GamePanel parent;
    private final EventListener treeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (event.type == 7) {
                VarLabelWindow.this.dispose();
            }
        }
    };

    public VarLabelWindow(GamePanel parent) {
        super(Defs.getString(-451068498), parent);
        this.parent = parent;
        this.getMainPanel().add(new JLabel(Defs.getString(-451068499)));
        this.getMainPanel().add("x=0", this.combo);
        this.combo.addItem(Defs.getString(-451068491));
        this.combo.addItem(Defs.getString(-451068476));
        this.combo.addItem(Defs.getString(-451068517));
        this.combo.setSelectedIndex(1);
        this.okBut = this.addButton(Defs.getString(1436228518), this);
        this.addButton(Defs.getString(1436228510), this);
        parent.getSgfTree().addListener(this.treeListener);
        this.pack(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okBut) {
            int mode = this.combo.getSelectedIndex();
            Node.NodeIterator nodes = this.parent.getSgfTree().nodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (node.countChildren() <= 0) continue;
                if (mode == 0 || mode == 1 && node.countChildren() == 1) {
                    this.unlabelChildren(node);
                    continue;
                }
                this.labelChildren(node);
            }
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        this.parent.getSgfTree().removeListener(this.treeListener);
        super.dispose();
    }

    private void labelChildren(Node node) {
        String letters = Defs.getString(-451068475);
        int letter = 0;
        for (Node child : node.children()) {
            Prop param = child.findProp(14);
            if (param == null) continue;
            if (param.getLoc() != Loc.PASS && !this.hasMarkAt(node, param.getLoc())) {
                this.parent.addProp(node, new Prop(19, param.getLoc(), letters.substring(letter, letter + 1)));
            }
            if (letter + 1 >= letters.length()) continue;
            ++letter;
        }
    }

    private boolean hasMarkAt(Node node, Loc loc) {
        for (Prop param : node) {
            if (!param.isMark() || !param.getLoc().equals(loc)) continue;
            return true;
        }
        return false;
    }

    private void unlabelChildren(Node node) {
        String letters = Defs.getString(-451068475);
        int letter = 0;
        for (Node child : node.children()) {
            Prop param = child.findProp(14);
            if (param == null) continue;
            Prop oldLabel = node.findProp(19, param.getLoc());
            if (oldLabel != null && oldLabel.getText().equals(letters.substring(letter, letter + 1))) {
                this.parent.removeProp(node, oldLabel);
            }
            if (letter + 1 >= letters.length()) continue;
            ++letter;
        }
    }

    public static JMenuItem createMenuItem(final GamePanel gameWin) {
        JMenuItem mi = new JMenuItem(Defs.getString(-451068498));
        mi.addActionListener(new ActionListener(){
            private final SingletonWindow win = new SingletonWindow();

            @Override
            public void actionPerformed(ActionEvent event) {
                this.win.dispose();
                this.win.setWindow(new VarLabelWindow(gameWin));
            }
        });
        return mi;
    }
}

