/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.speex;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.OutputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.igoweb.util.Emitter;
import org.igoweb.util.speex.BitIoError;
import org.igoweb.util.speex.BitOutputStream;
import org.igoweb.util.swing.Prefs;
import org.xiph.speex.NbEncoder;

public class StreamRecorder
extends Emitter
implements Runnable {
    public static final String GAIN_PREF = "oQa_B$t;";
    private float rmsSum;
    private int numRmsSamples;
    private static final int EVENT_BASE = 3;
    public static final int CANT_GET_LINE_EVENT = 3;
    public static final int ERROR_READING_DATA_EVENT = 4;
    public static final int IO_ERROR_EVENT = 5;
    public static final int CANT_CLOSE_MIC_EVENT = 6;
    public static final int MIC_IN_USE_EVENT = 7;
    public static final int EVENT_LIMIT = 8;
    public static final int BYTES_PER_SAMPLE = 2;
    private final float VBR_QUALITY = 3.0f;
    private boolean stopRequested = true;
    private boolean isStopped = true;
    private OutputStream byteOut;
    private final int framesPerPacket;
    private volatile float gain;
    private volatile boolean muted = false;
    private static TargetDataLine mic;
    private static Object globalLock;
    private static boolean micThreadActive;

    public StreamRecorder(OutputStream out, int framesPerPacket) {
        this(framesPerPacket);
        this.setOutput(out);
    }

    protected StreamRecorder(int framesPerPacket) {
        this.framesPerPacket = framesPerPacket;
        int maxBitsPerFrame = 0;
        this.rmsSum = 0.0f;
        this.numRmsSamples = 0;
        for (int i = 0; i < 16; ++i) {
            if (NbEncoder.NB_FRAME_SIZE[i] <= maxBitsPerFrame) continue;
            maxBitsPerFrame = NbEncoder.NB_FRAME_SIZE[i];
        }
        this.gain = StreamRecorder.getGain();
        Prefs.addListener(GAIN_PREF, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                StreamRecorder.this.gainChanged();
            }
        });
    }

    protected void setOutput(OutputStream out) {
        this.byteOut = out;
    }

    public static void setGain(float newGain) {
        Prefs.putFloat(GAIN_PREF, newGain);
    }

    public static float getGain() {
        return Prefs.getFloat(GAIN_PREF, 1.0f);
    }

    public void setMuted(boolean newMuted) {
        this.muted = newMuted;
    }

    public boolean isMuted() {
        return this.muted;
    }

    private void gainChanged() {
        this.gain = Prefs.getFloat(GAIN_PREF, this.gain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean weGotMic = false;
        StreamRecorder streamRecorder = this;
        synchronized (streamRecorder) {
            if (!this.stopRequested) {
                return;
            }
            while (!this.isStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException excep) {
                    throw new RuntimeException();
                }
                if (this.stopRequested) continue;
                return;
            }
            Object object = globalLock;
            synchronized (object) {
                if (!micThreadActive) {
                    micThreadActive = true;
                    weGotMic = true;
                }
            }
            if (weGotMic) {
                this.stopRequested = false;
                this.isStopped = false;
                new Thread((Runnable)this, "Audio Input").start();
            }
        }
        if (!weGotMic) {
            this.emit(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(int waitInMs) {
        StreamRecorder streamRecorder = this;
        synchronized (streamRecorder) {
            this.stopRequested = true;
            if (waitInMs > 0) {
                try {
                    long now;
                    long giveUpTime = System.currentTimeMillis() + (long)waitInMs;
                    while (!this.isStopped && (now = System.currentTimeMillis()) < giveUpTime) {
                        this.wait(giveUpTime - now);
                    }
                }
                catch (InterruptedException excep) {
                    throw new RuntimeException();
                }
            }
            return this.isStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean eventEmitted = false;
        try {
            NbEncoder encoder = new NbEncoder();
            encoder.nbinit();
            encoder.setVbr(true);
            encoder.setVbrQuality(3.0f);
            encoder.setDtx(true);
            BitOutputStream bitOut = new BitOutputStream(this.byteOut);
            if (mic == null) {
                AudioFormat format = new AudioFormat(encoder.getSamplingRate(), 16, 1, true, false);
                mic = this.getMicLine(format);
                mic.open();
            }
            AudioFormat micFormat = mic.getFormat();
            int numChannels = micFormat.getChannels();
            int bresByteSkip = (int)micFormat.getSampleRate() / encoder.getSamplingRate() * numChannels * 2;
            int bresExtraOffsetRate = (int)micFormat.getSampleRate() % encoder.getSamplingRate();
            int bresOffset = 0;
            int bresOffsetLimit = encoder.getSamplingRate();
            mic.flush();
            mic.start();
            int floatFrameSize = encoder.getFrameSize();
            int byteFrameSize = floatFrameSize * (int)micFormat.getSampleRate() * numChannels * 2 / encoder.getSamplingRate();
            byte[] byteBuf = new byte[byteFrameSize * this.framesPerPacket];
            float[] floatBuf = new float[floatFrameSize];
            int numFramesEncoded = 0;
            int bufStart = 0;
            int bufLen = 0;
            block13: while (true) {
                int amtRead;
                if (bufLen > byteBuf.length / 2) {
                    if (bufLen - bufStart > 0) {
                        System.arraycopy(byteBuf, bufStart, byteBuf, 0, bufLen - bufStart);
                    }
                    bufLen -= bufStart;
                    bufStart = 0;
                }
                if ((amtRead = mic.read(byteBuf, bufLen, byteBuf.length - bufLen)) < 0) {
                    this.emit(4);
                    return;
                }
                if (this.muted) {
                    Arrays.fill(byteBuf, bufLen, amtRead, (byte)0);
                }
                bufLen += amtRead;
                while (true) {
                    if (bufLen - bufStart < byteFrameSize) continue block13;
                    float totalGain = this.gain / (float)numChannels;
                    float rmsSubtotal = 0.0f;
                    for (int i = 0; i < floatFrameSize; ++i) {
                        float floatPcmValue = 0.0f;
                        for (int j = 0; j < numChannels; floatPcmValue += (float)(byteBuf[bufStart + j * 2] & 0xFF | byteBuf[bufStart + j * 2 + 1] << 8), ++j) {
                        }
                        floatBuf[i] = floatPcmValue *= totalGain;
                        rmsSubtotal += floatPcmValue * floatPcmValue;
                        bufStart += bresByteSkip;
                        if ((bresOffset += bresExtraOffsetRate) < bresOffsetLimit) continue;
                        bresOffset -= bresOffsetLimit;
                        bufStart += numChannels * 2;
                    }
                    StreamRecorder streamRecorder = this;
                    synchronized (streamRecorder) {
                        this.rmsSum += rmsSubtotal;
                        this.numRmsSamples += floatFrameSize;
                    }
                    this.processPcmData(floatBuf);
                    encoder.encode(bitOut, floatBuf);
                    if (++numFramesEncoded != this.framesPerPacket) continue;
                    bitOut.flushAndSync();
                    if (this.stopRequested) {
                        return;
                    }
                    numFramesEncoded = 0;
                    continue;
                    break;
                }
                break;
            }
        }
        catch (BitIoError excep) {
            this.emit(5, excep.toString());
            eventEmitted = true;
            return;
        }
        catch (LineUnavailableException excep) {
            this.emit(3);
            eventEmitted = true;
            return;
        }
        catch (IllegalArgumentException excep) {
            this.emit(3);
            eventEmitted = true;
            return;
        }
        finally {
            this.finishRun(eventEmitted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRun(boolean eventEmitted) {
        try {
            if (mic != null) {
                mic.stop();
            }
        }
        catch (RuntimeException excep) {
            this.emit(6);
            throw excep;
        }
        catch (Error err) {
            this.emit(6);
            throw err;
        }
        finally {
            StreamRecorder streamRecorder = this;
            synchronized (streamRecorder) {
                this.isStopped = true;
                this.notifyAll();
                Object object = globalLock;
                synchronized (object) {
                    micThreadActive = false;
                }
            }
            if (!eventEmitted && !this.stopRequested) {
                this.emit(5, "Unknown Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRmsAmplitude(boolean clear) {
        int oldSamples;
        float oldSum;
        StreamRecorder streamRecorder = this;
        synchronized (streamRecorder) {
            oldSum = this.rmsSum;
            oldSamples = this.numRmsSamples;
            if (clear) {
                this.rmsSum = 0.0f;
                this.numRmsSamples = 0;
            }
        }
        return oldSamples == 0 ? -1.0f : (float)Math.sqrt(oldSum / (float)oldSamples);
    }

    protected void processPcmData(float[] floatPcmData) {
    }

    private TargetDataLine getMicLine(AudioFormat format) throws LineUnavailableException {
        int numUnspecifiedFields = 0;
        while (true) {
            AudioFormat req = new AudioFormat(numUnspecifiedFields < 1 ? format.getSampleRate() : (float)(numUnspecifiedFields < 3 ? -1 : 44100), 16, numUnspecifiedFields < 2 ? 1 : 2, true, false);
            try {
                return (TargetDataLine)AudioSystem.getLine(new DataLine.Info(TargetDataLine.class, req));
            }
            catch (IllegalArgumentException excep) {
                if (++numUnspecifiedFields <= 3) continue;
                throw excep;
            }
            break;
        }
    }

    static {
        globalLock = new Object();
        micThreadActive = false;
    }
}

