/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.FriendsGroup;
import org.igoweb.igoweb.client.swing.UserList;
import org.igoweb.igoweb.client.swing.UserRenderer;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.Multicaster;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.SizeLimitDoc;
import org.igoweb.util.swing.TBlock;

public class EditableUserList
extends JPanel
implements ActionListener {
    private static final int EVENT_BASE = 135;
    public static final int NAME_ADDED_EVENT = 135;
    public static final int NAME_AND_NOTES_ADDED_EVENT = 136;
    public static final int USER_REMOVED_EVENT = 137;
    public static final int EVENT_LIMIT = 138;
    private EventListener listener = null;
    private final JTextField nameIn = new JTextField("", 10);
    private final JTextField notesIn = new ATextField("", 50);
    private final EUList userList;
    private final FriendsGroup friendsGroup;

    public EditableUserList(Client client) {
        this(client, null, -1);
    }

    public EditableUserList(Client client, String description) {
        this(client, description, -1);
    }

    public EditableUserList(Client client, String description, int friendType) {
        super(new GCLayout());
        FriendsGroup friendsGroup = this.friendsGroup = friendType < 0 ? null : client.getFriendsGroup(friendType);
        if (description != null) {
            this.add("xSpan=2,xGrow=f", description.startsWith("<html>") ? new TBlock(description, 10) : new JLabel(description));
        }
        this.userList = new EUList(client, this.friendsGroup);
        this.add("x=0,xSpan=2,yGrow=t,xGrow=f", this.userList);
        this.add("x=0,xSpan=1,yGrow=f", new JLabel(Defs.getString(-903340805)));
        this.add("xGrow=t", this.nameIn);
        if (this.friendsGroup == null) {
            this.nameIn.addActionListener(this);
        } else {
            this.add("x=0,xGrow=f", new JLabel(Defs.getString(-903340672)));
            this.notesIn.setDocument(new SizeLimitDoc(50));
            this.add("xGrow=t", this.notesIn);
            this.notesIn.addActionListener(this);
        }
    }

    protected void addPressed(String name, String notes) {
        if (User.nameValid(name = name.trim())) {
            if (notes == null) {
                this.emit(135, name);
            } else {
                this.emit(136, new String[]{name, notes});
                this.notesIn.setText("");
            }
            this.nameIn.setText("");
        }
    }

    public void add(User user) {
        this.userList.add(user);
        this.userList.sortNow();
    }

    public void remove(User user) {
        this.userList.remove(user);
        this.userList.sortNow();
    }

    public void clear() {
        this.userList.getInnerList().clearSelection();
        this.userList.clear();
    }

    public void addAll(Collection<User> coll) {
        this.userList.clear();
        if (coll == null) {
            return;
        }
        Iterator<User> iter = coll.iterator();
        while (iter.hasNext()) {
            this.userList.add(iter.next());
        }
        this.userList.sortNow();
    }

    public void addListener(EventListener newListener) {
        this.listener = Multicaster.add(this.listener, newListener);
    }

    public void removeListener(EventListener victim) {
        this.listener = Multicaster.remove(this.listener, victim);
    }

    protected void emit(int type, Object arg) {
        if (this.listener != null) {
            this.listener.handleEvent(new Event(this, type, arg));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.nameIn) {
            this.addPressed(this.nameIn.getText().trim(), null);
        } else if (src == this.notesIn) {
            this.addPressed(this.nameIn.getText().trim(), this.notesIn.getText());
        } else {
            this.emit(137, this.userList.getMenuTarget());
        }
    }

    public void setAddText(String text) {
        if (this.nameIn.getText().length() == 0) {
            this.nameIn.setText(text);
        }
    }

    @Override
    public void setEnabled(boolean val) {
        super.setEnabled(val);
        this.nameIn.setEnabled(val);
        this.userList.setEnabled(val);
    }

    private class EUList
    extends UserList {
        public final JMenuItem rmMI;

        public EUList(Client client, FriendsGroup friendsGroup) {
            super(client, friendsGroup, null);
            this.rmMI = new JMenuItem(Defs.getString(-903340625));
            this.addMenuItem(this.rmMI);
            this.rmMI.addActionListener(EditableUserList.this);
        }

        @Override
        protected void prepUserPop(User user) {
            this.rmMI.setEnabled(user != null && user != UserRenderer.BUDDY_BAR);
            super.prepUserPop(user);
        }

        @Override
        protected void handleClick(Object clickedUser) {
            if (EditableUserList.this.friendsGroup != null && clickedUser != null && clickedUser instanceof User && clickedUser != UserRenderer.BUDDY_BAR) {
                User u = (User)clickedUser;
                EditableUserList.this.nameIn.setText(u.name);
                String notes = EditableUserList.this.friendsGroup.getNotes(u);
                EditableUserList.this.notesIn.setText(notes == null ? "" : notes);
            } else {
                super.handleClick(clickedUser);
            }
        }
    }
}

