/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.sun.media.Log;
import com.sun.media.renderer.audio.device.AudioOutput;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundOutput
implements AudioOutput {
    static Mixer mixer = null;
    static Object initSync = new Object();
    protected SourceDataLine dataLine;
    protected FloatControl gc;
    protected FloatControl rc;
    protected BooleanControl mc;
    protected boolean paused = true;
    protected int bufSize;
    protected AudioFormat format;
    long lastPos = 0L;
    long originPos = 0L;
    long totalCount = 0L;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public boolean initialize(AudioFormat format, int bufSize) {
        Object object = initSync;
        synchronized (object) {
            javax.sound.sampled.AudioFormat afmt = JavaSoundOutput.convertFormat(format);
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JavaSoundOutput.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, afmt, bufSize);
            try {
                if (!AudioSystem.isLineSupported(info)) {
                    Log.warning("DataLine not supported: " + format);
                    boolean bl = false;
                    return bl;
                }
                this.dataLine = (SourceDataLine)AudioSystem.getLine(info);
                this.dataLine.open(afmt, bufSize);
            }
            catch (Exception e2) {
                Log.warning("Cannot open audio device: " + e2);
                boolean bl = false;
                return bl;
            }
            this.format = format;
            this.bufSize = bufSize;
            if (this.dataLine == null) {
                Log.warning("JavaSound unsupported format: " + format);
                boolean e2 = false;
                return e2;
            }
            try {
                this.gc = (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                this.mc = (BooleanControl)this.dataLine.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception e3) {
                Log.warning("JavaSound: No gain control");
            }
            try {
                this.rc = (FloatControl)this.dataLine.getControl(FloatControl.Type.SAMPLE_RATE);
            }
            catch (Exception e4) {
                Log.warning("JavaSound: No rate control");
            }
            boolean bl = true;
            return bl;
        }
    }

    public void dispose() {
        this.dataLine.close();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void pause() {
        if (this.dataLine != null) {
            this.dataLine.stop();
        }
        this.paused = true;
    }

    public void resume() {
        if (this.dataLine != null) {
            this.dataLine.start();
        }
        this.paused = false;
    }

    public void drain() {
        this.dataLine.drain();
    }

    public void flush() {
        this.dataLine.flush();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getMediaNanoseconds() {
        if (this.dataLine == null || this.format == null) {
            return 0L;
        }
        long pos = this.dataLine.getFramePosition();
        if (pos < this.lastPos) {
            this.totalCount += this.lastPos - this.originPos;
            this.originPos = pos;
        }
        this.lastPos = pos;
        return (long)((double)((this.totalCount + pos - this.originPos) * 1000L) / this.format.getSampleRate() * 1000000.0);
    }

    public void setGain(double g2) {
        if (this.gc != null) {
            this.gc.setValue((float)g2);
        }
    }

    public double getGain() {
        return this.gc != null ? (double)this.gc.getValue() : 0.0;
    }

    public void setMute(boolean m2) {
        if (this.mc != null) {
            this.mc.setValue(m2);
        }
    }

    public boolean getMute() {
        return this.mc != null ? this.mc.getValue() : false;
    }

    public float setRate(float r) {
        if (this.rc == null) {
            return 1.0f;
        }
        float rate = (float)((double)r * this.format.getSampleRate());
        if (rate > this.rc.getMaximum() || rate < this.rc.getMinimum()) {
            return this.getRate();
        }
        this.rc.setValue(rate);
        return r;
    }

    public float getRate() {
        if (this.rc == null) {
            return 1.0f;
        }
        return (float)((double)this.rc.getValue() / this.format.getSampleRate());
    }

    public int bufferAvailable() {
        return this.dataLine.available();
    }

    public int write(byte[] data, int off, int len) {
        return this.dataLine.write(data, off, len);
    }

    public static boolean isOpen() {
        Mixer mixer = AudioSystem.getMixer(null);
        Line[] lines = mixer.getSourceLines();
        return lines != null && lines.length > 0;
    }

    public static AudioFormat convertFormat(javax.sound.sampled.AudioFormat fmt) {
        AudioFormat.Encoding type = fmt.getEncoding();
        String encoding = type == AudioFormat.Encoding.PCM_SIGNED || type == AudioFormat.Encoding.PCM_UNSIGNED ? "LINEAR" : (type == AudioFormat.Encoding.ALAW ? "alaw" : (type == AudioFormat.Encoding.ULAW ? "ULAW" : null));
        return new AudioFormat(encoding, fmt.getSampleRate(), fmt.getSampleSizeInBits(), fmt.getChannels(), fmt.isBigEndian() ? 1 : 0, type == AudioFormat.Encoding.PCM_SIGNED ? 1 : 0);
    }

    public static javax.sound.sampled.AudioFormat convertFormat(AudioFormat fmt) {
        return new javax.sound.sampled.AudioFormat(fmt.getSampleRate() == -1.0 ? 8000.0f : (float)fmt.getSampleRate(), fmt.getSampleSizeInBits() == -1 ? 16 : fmt.getSampleSizeInBits(), fmt.getChannels() == -1 ? 1 : fmt.getChannels(), fmt.getSigned() == 1, fmt.getEndian() == 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

