/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import java.util.ArrayList;

class ZabbixItem {
    private String key = null;
    private String keyId = null;
    private ArrayList<String> args = null;

    ZabbixItem(String string) {
        if (null == string) {
            throw new IllegalArgumentException("key must not be null");
        }
        int n = string.indexOf(91);
        if (-1 != n) {
            if (']' != string.charAt(string.length() - 1)) {
                throw new IllegalArgumentException("no terminating ']' in key: '" + string + "'");
            }
            this.keyId = string.substring(0, n);
            this.args = this.parseArguments(string.substring(n + 1, string.length() - 1));
        } else {
            this.keyId = string;
        }
        if (0 == this.keyId.length()) {
            throw new IllegalArgumentException("key ID is empty in key: '" + string + "'");
        }
        for (int i = 0; i < this.keyId.length(); ++i) {
            if (this.isValidKeyIdChar(this.keyId.charAt(i))) continue;
            throw new IllegalArgumentException("bad key ID char '" + this.keyId.charAt(i) + "' in key: '" + string + "'");
        }
        this.key = string;
    }

    String getKey() {
        return this.key;
    }

    String getKeyId() {
        return this.keyId;
    }

    String getArgument(int n) {
        if (null == this.args || 1 > n || n > this.args.size()) {
            throw new IndexOutOfBoundsException("bad argument index for key '" + this.key + "': " + n);
        }
        return this.args.get(n - 1);
    }

    int getArgumentCount() {
        return null == this.args ? 0 : this.args.size();
    }

    private ArrayList<String> parseArguments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n;
            if (0 == string.length()) {
                arrayList.add("");
                break;
            }
            if (' ' == string.charAt(0)) {
                string = string.substring(1);
                continue;
            }
            if ('\"' == string.charAt(0)) {
                for (n = 1; n < string.length() && ('\"' != string.charAt(n) || '\\' == string.charAt(n - 1)); ++n) {
                }
                if (n == string.length()) {
                    throw new IllegalArgumentException("quoted argument not terminated: '" + this.key + "'");
                }
                arrayList.add(string.substring(1, n).replace("\\\"", "\""));
                ++n;
                while (n < string.length() && ' ' == string.charAt(n)) {
                    ++n;
                }
                if (n == string.length()) break;
                if (',' != string.charAt(n)) {
                    throw new IllegalArgumentException("quoted argument not followed by comma: '" + this.key + "'");
                }
                string = string.substring(n + 1);
                continue;
            }
            for (n = 0; n < string.length() && ',' != string.charAt(n); ++n) {
            }
            arrayList.add(string.substring(0, n));
            if (n == string.length()) break;
            string = string.substring(n + 1);
        }
        return arrayList;
    }

    private boolean isValidKeyIdChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || -1 != "._-".indexOf(c);
    }
}

