/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class TextureTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new TextureTabbedPaneUI();
    }

    protected void installComponents() {
        this.simpleButtonBorder = true;
        super.installComponents();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        ColorUIResource c = AbstractLookAndFeel.getTheme().getSelectionBackgroundColorDark();
        return new Color[]{this.getLoBorderColor(0), c, c, c, ColorHelper.darker(c, 10.0)};
    }

    protected Color getLoBorderColor(int tabIndex) {
        if (tabIndex == this.tabPane.getSelectedIndex() && this.tabPane.getBackgroundAt(tabIndex) instanceof ColorUIResource && AbstractLookAndFeel.getTheme().isDarkTexture()) {
            return ColorHelper.darker(super.getLoBorderColor(tabIndex), 20.0);
        }
        return AbstractLookAndFeel.getFrameColor();
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected int getTexture() {
        return 1;
    }

    protected int getSelectedTexture() {
        return 3;
    }

    protected int getUnSelectedTexture(int tabIndex) {
        if (tabIndex == this.rolloverIndex && this.tabPane.isEnabledAt(tabIndex)) {
            return 4;
        }
        return 2;
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        int sepHeight;
        int ht;
        int wt;
        int yt;
        int xt;
        int textureType = TextureUtils.getTextureType(this.tabPane);
        int tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        int tabAreaWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
        if (this.tabPane.isOpaque()) {
            xt = tabPlacement == 4 ? w - tabAreaWidth : 0;
            yt = tabPlacement == 3 ? h - tabAreaHeight : 0;
            wt = tabPlacement == 1 || tabPlacement == 3 ? w : tabAreaWidth;
            ht = tabPlacement == 2 || tabPlacement == 4 ? h : tabAreaHeight;
            g.setColor(this.tabAreaBackground);
            g.fillRect(xt, yt, wt, ht);
        }
        if (this.isContentOpaque()) {
            xt = tabPlacement == 2 ? tabAreaWidth : 0;
            yt = tabPlacement == 1 ? tabAreaHeight : 0;
            wt = tabPlacement == 2 || tabPlacement == 4 ? w - tabAreaWidth : w;
            ht = tabPlacement == 1 || tabPlacement == 3 ? h - tabAreaHeight : h;
            TextureUtils.fillComponent(g, this.tabPane, xt, yt, wt, ht, textureType);
        }
        if ((sepHeight = this.tabAreaInsets.bottom) > 0) {
            Insets bi = new Insets(0, 0, 0, 0);
            if (this.tabPane.getBorder() != null) {
                bi = this.tabPane.getBorder().getBorderInsets(this.tabPane);
            }
            switch (tabPlacement) {
                case 1: {
                    TextureUtils.fillComponent(g, this.tabPane, x, y + tabAreaHeight - sepHeight + bi.top, w, sepHeight, this.getSelectedTexture());
                    if (textureType != 7) break;
                    Graphics2D g2D = (Graphics2D)g;
                    Composite saveComposite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                    g2D.setComposite(alpha);
                    g2D.setColor(Color.black);
                    g2D.drawLine(x, y, w, y);
                    g2D.drawLine(w, y, w, y + tabAreaHeight - sepHeight);
                    alpha = AlphaComposite.getInstance(3, 0.2f);
                    g2D.setComposite(alpha);
                    g2D.setColor(Color.white);
                    g2D.drawLine(x, y + tabAreaHeight - sepHeight, w, y + tabAreaHeight - sepHeight);
                    alpha = AlphaComposite.getInstance(3, 0.1f);
                    g2D.setComposite(alpha);
                    g2D.drawLine(x, y + 1, x, y + tabAreaHeight - sepHeight - 1);
                    g2D.setComposite(saveComposite);
                    break;
                }
                case 2: {
                    TextureUtils.fillComponent(g, this.tabPane, x + tabAreaWidth - sepHeight + bi.left, y, sepHeight, h, this.getSelectedTexture());
                    break;
                }
                case 3: {
                    TextureUtils.fillComponent(g, this.tabPane, x, y + h - tabAreaHeight - bi.bottom, w, sepHeight, this.getSelectedTexture());
                    break;
                }
                case 4: {
                    TextureUtils.fillComponent(g, this.tabPane, x + w - tabAreaWidth - bi.right, y, sepHeight, h, this.getSelectedTexture());
                }
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource) || !AbstractLookAndFeel.getTheme().isDarkTexture()) {
            super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            return;
        }
        if (this.isTabOpaque() || isSelected) {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            Shape savedClip = g.getClip();
            Area orgClipArea = new Area(savedClip);
            int d = 10;
            switch (tabPlacement) {
                default: {
                    if (isSelected) {
                        Area clipArea = new Area(new RoundRectangle2D.Double(x, y, w, h + 4, d, d));
                        Area rectArea = new Area(new Rectangle2D.Double(x, y, w, h + 1));
                        clipArea.intersect(rectArea);
                        clipArea.intersect(orgClipArea);
                        g2D.setClip(clipArea);
                        TextureUtils.fillRect(g, this.tabPane, x, y, w, h + 4, this.getSelectedTexture());
                        g2D.setClip(savedClip);
                        break;
                    }
                    Area clipArea = new Area(new RoundRectangle2D.Double(x, y, w, h + 4, d, d));
                    Area rectArea = new Area(new Rectangle2D.Double(x, y, w, h));
                    clipArea.intersect(rectArea);
                    clipArea.intersect(orgClipArea);
                    g2D.setClip(clipArea);
                    TextureUtils.fillRect(g, this.tabPane, x, y, w, h + 4, this.getUnSelectedTexture(tabIndex));
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                    g2D.setComposite(alpha);
                    Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
                    JTattooUtilities.fillHorGradient(g, colors, x, y, w, h + 4);
                    g2D.setComposite(savedComposite);
                    g2D.setClip(savedClip);
                    break;
                }
                case 2: {
                    if (isSelected) {
                        TextureUtils.fillComponent(g, this.tabPane, x + 1, y + 1, w, h - 1, this.getSelectedTexture());
                        break;
                    }
                    TextureUtils.fillComponent(g, this.tabPane, x + 1, y + 1, w - 1, h - 1, this.getUnSelectedTexture(tabIndex));
                    break;
                }
                case 3: {
                    if (isSelected) {
                        Area clipArea = new Area(new RoundRectangle2D.Double(x, y - 4, w, h + 4, d, d));
                        Area rectArea = new Area(new Rectangle2D.Double(x, y - 1, w, h + 1));
                        clipArea.intersect(rectArea);
                        clipArea.intersect(orgClipArea);
                        g2D.setClip(clipArea);
                        TextureUtils.fillRect(g, this.tabPane, x, y - 4, w, h + 4, this.getSelectedTexture());
                        g2D.setClip(savedClip);
                        break;
                    }
                    Area clipArea = new Area(new RoundRectangle2D.Double(x, y - 4, w, h + 4, d, d));
                    Area rectArea = new Area(new Rectangle2D.Double(x, y, w, h));
                    clipArea.intersect(rectArea);
                    clipArea.intersect(orgClipArea);
                    g2D.setClip(clipArea);
                    TextureUtils.fillRect(g, this.tabPane, x, y - 4, w, h + 4, this.getUnSelectedTexture(tabIndex));
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                    g2D.setComposite(alpha);
                    Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
                    JTattooUtilities.fillHorGradient(g, colors, x, y - 4, w, h + 4);
                    g2D.setComposite(savedComposite);
                    g2D.setClip(savedClip);
                    break;
                }
                case 4: {
                    if (isSelected) {
                        TextureUtils.fillComponent(g, this.tabPane, x, y + 1, w, h - 1, this.getSelectedTexture());
                        break;
                    }
                    TextureUtils.fillComponent(g, this.tabPane, x, y + 1, w, h - 1, this.getUnSelectedTexture(tabIndex));
                }
            }
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource) || !AbstractLookAndFeel.getTheme().isDarkTexture()) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    ColorUIResource titleColor = AbstractLookAndFeel.getTabSelectionForegroundColor();
                    if (ColorHelper.getGrayValue(titleColor) > 164) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
                    g.setColor(titleColor);
                    Graphics2D g2D = (Graphics2D)g;
                    Shape savedClip = g2D.getClip();
                    Area clipArea = new Area(new Rectangle2D.Double(textRect.x, textRect.y, textRect.width, textRect.height / 2 + 1));
                    clipArea.intersect(new Area(savedClip));
                    g2D.setClip(clipArea);
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                    clipArea = new Area(new Rectangle2D.Double(textRect.x, textRect.y + textRect.height / 2 + 1, textRect.width, textRect.height));
                    clipArea.intersect(new Area(savedClip));
                    g2D.setClip(clipArea);
                    g2D.setColor(ColorHelper.darker(titleColor, 20.0));
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                    g2D.setClip(savedClip);
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                }
            } else {
                Graphics2D g2D = (Graphics2D)g;
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                g2D.setComposite(alpha);
                g.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent() + 1);
                g2D.setComposite(savedComposite);
                g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }
}

