/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopySqlPartCommandBase;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyWhereStatementCommand
extends TableCopySqlPartCommandBase
implements ICommand {
    private JTable _table;

    public TableCopyWhereStatementCommand(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        this._table = table;
    }

    @Override
    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (selRows.length != 0 && selCols.length != 0) {
            StringBuffer buf = new StringBuffer("WHERE ");
            for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                if (1 < nbrSelCols) {
                    if (0 < rowIdx) {
                        buf.append("OR (");
                    } else {
                        buf.append("(");
                    }
                } else if (0 < rowIdx) {
                    buf.append("OR ");
                }
                boolean firstCol = true;
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
                    ColumnDisplayDefinition colDef = null;
                    if (!(col instanceof ExtTableColumn)) continue;
                    colDef = ((ExtTableColumn)col).getColumnDisplayDefinition();
                    if (firstCol) {
                        firstCol = false;
                    } else {
                        buf.append(" AND ");
                    }
                    Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    buf.append(colDef.getColumnName()).append(this.getData(colDef, cellObj, TableCopySqlPartCommandBase.StatType.WHERE));
                }
                if (1 < nbrSelCols) {
                    buf.append(")\n");
                    continue;
                }
                if (100 < buf.length() - buf.toString().lastIndexOf("\n")) {
                    buf.append("\n");
                    continue;
                }
                buf.append(" ");
            }
            StringSelection ss = new StringSelection(buf.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }
}

