/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.builders.IUIFactoryListener;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactoryAdapter;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactoryComponentCreatedEvent;
import net.sourceforge.squirrel_sql.client.plugin.DefaultPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.LAFFontsTab;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPluginResources;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferencesTab;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.MetalLookAndFeelController;

public class LAFPlugin
extends DefaultPlugin {
    private static final ILogger s_log = LoggerController.createLogger(LAFPlugin.class);
    static final String OLD_USER_PREFS_FILE_NAME = "LAFPrefs.xml";
    static final String USER_PREFS_FILE_NAME = "LAFPreferences.xml";
    private LAFPluginResources _resources;
    private LAFPreferences _lafPrefs;
    private LAFRegister _lafRegister;
    private FileWrapper _lafFolder;
    private FileWrapper _userSettingsFolder;
    private FileWrapper _userExtraLAFFolder;
    private final XMLObjectCache<LAFPreferences> _settingsCache = new XMLObjectCache();

    public String getInternalName() {
        return "laf";
    }

    public String getDescriptiveName() {
        return "Look & Feel Plugin";
    }

    public String getVersion() {
        return "1.1.1";
    }

    public String getAuthor() {
        return "Colin Bell";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licences.html";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        this._resources = new LAFPluginResources((IPlugin)this);
        FileWrapper pluginAppFolder = null;
        try {
            pluginAppFolder = this.getPluginAppSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this._lafFolder = this.fileWrapperFactory.create(pluginAppFolder, "lafs");
        if (!this._lafFolder.exists()) {
            this._lafFolder.mkdir();
        }
        try {
            this._userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this._userExtraLAFFolder = this.fileWrapperFactory.create(this._userSettingsFolder, "extralafs");
        this.createEmptyRequiredUserFiles();
        this.loadPrefs();
        this._lafRegister = new LAFRegister(app, this);
        UIFactory.getInstance().addListener((IUIFactoryListener)new UIFactoryListener());
        this._lafRegister.updateStatusBarFont();
    }

    public void unload() {
        try {
            this.savePrefs(this.fileWrapperFactory.create(this._userSettingsFolder, USER_PREFS_FILE_NAME));
        }
        catch (IOException ex) {
            s_log.error((Object)"Error occurred writing to preferences file: LAFPreferences.xml", (Throwable)ex);
        }
        catch (XMLException ex) {
            s_log.error((Object)"Error occurred writing to preferences file: LAFPreferences.xml", (Throwable)ex);
        }
        super.unload();
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[]{new LAFPreferencesTab(this, this._lafRegister), new LAFFontsTab(this, this._lafRegister)};
    }

    FileWrapper getLookAndFeelFolder() {
        return this._lafFolder;
    }

    FileWrapper getUsersExtraLAFFolder() {
        return this._userExtraLAFFolder;
    }

    LAFPreferences getLAFPreferences() {
        return this._lafPrefs;
    }

    PluginResources getResources() {
        return this._resources;
    }

    public XMLObjectCache<LAFPreferences> getSettingsCache() {
        return this._settingsCache;
    }

    private void loadPrefs() {
        block11: {
            FileWrapper oldPrefsFile = this.fileWrapperFactory.create(this._userSettingsFolder, OLD_USER_PREFS_FILE_NAME);
            FileWrapper newPrefsFile = this.fileWrapperFactory.create(this._userSettingsFolder, USER_PREFS_FILE_NAME);
            boolean oldExists = oldPrefsFile.exists();
            boolean newExists = newPrefsFile.exists();
            try {
                if (oldExists) {
                    this.loadOldPrefs(oldPrefsFile);
                    try {
                        this._settingsCache.add((IHasIdentifier)this._lafPrefs);
                    }
                    catch (DuplicateObjectException ex) {
                        s_log.error((Object)"LAFPreferences object already in cache", (Throwable)ex);
                    }
                    this.savePrefs(newPrefsFile);
                    if (!oldPrefsFile.delete()) {
                        s_log.error((Object)"Unable to delete old LAF preferences file");
                    }
                    break block11;
                }
                if (newExists) {
                    this.loadNewPrefs(newPrefsFile);
                }
            }
            catch (IOException ex) {
                s_log.error((Object)"Error occurred in preferences file", (Throwable)ex);
            }
            catch (XMLException ex) {
                s_log.error((Object)"Error occurred in preferences file", (Throwable)ex);
            }
        }
        if (this._lafPrefs == null) {
            this._lafPrefs = new LAFPreferences(IdentifierFactory.getInstance().createIdentifier());
            this._lafPrefs.setLookAndFeelClassName(MetalLookAndFeelController.METAL_LAF_CLASS_NAME);
            try {
                this._settingsCache.add((IHasIdentifier)this._lafPrefs);
            }
            catch (DuplicateObjectException ex) {
                s_log.error((Object)"LAFPreferences object already in cache", (Throwable)ex);
            }
        }
    }

    private void loadOldPrefs(FileWrapper oldPrefsFile) throws XMLException {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            doc.load(oldPrefsFile, ((Object)((Object)this)).getClass().getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                this._lafPrefs = (LAFPreferences)it.next();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void loadNewPrefs(FileWrapper newPrefsFile) throws XMLException {
        try {
            try {
                this._settingsCache.load(newPrefsFile.getPath(), ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (DuplicateObjectException ex) {
                s_log.error((Object)"Cache should have been empty", (Throwable)ex);
            }
            Iterator it = this._settingsCache.getAllForClass(LAFPreferences.class);
            if (it.hasNext()) {
                this._lafPrefs = (LAFPreferences)it.next();
            } else {
                s_log.error((Object)"LAFPreferences object not loaded");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void savePrefs(FileWrapper prefsFile) throws IOException, XMLException {
        this._settingsCache.save(prefsFile.getPath());
    }

    private void createEmptyRequiredUserFiles() {
        this._userExtraLAFFolder.mkdirs();
        FileWrapper file = this.fileWrapperFactory.create(this._userExtraLAFFolder, "extralafs.properties");
        try {
            boolean result = file.createNewFile();
            if (!result) {
                s_log.warn((Object)"Failed to create empty required user files");
            }
        }
        catch (IOException ex) {
            s_log.error((Object)("Error creating file " + file.getAbsolutePath()), (Throwable)ex);
        }
    }

    private static class UIFactoryListener
    extends UIFactoryAdapter {
        private UIFactoryListener() {
        }

        public void tabbedPaneCreated(UIFactoryComponentCreatedEvent evt) {
            JTabbedPane pnl = (JTabbedPane)evt.getComponent();
            pnl.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        }
    }
}

