/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Color;
import java.util.StringTokenizer;

public class RgbColorConverter
extends ColorConverter {
    @Override
    public String toString(Object object, ConverterContext context) {
        if (object instanceof Color) {
            Color color = (Color)object;
            StringBuffer colorText = new StringBuffer();
            colorText.append(color.getRed()).append(", ");
            colorText.append(color.getGreen()).append(", ");
            colorText.append(color.getBlue());
            return new String(colorText);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        String s;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(string, ",; ");
        int r = 0;
        int g = 0;
        int b = 0;
        if (token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                r = Integer.parseInt(s, 10) % 256;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                g = Integer.parseInt(s, 10) % 256;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                b = Integer.parseInt(s, 10) % 256;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new Color(r, g, b);
    }
}

