/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.geometry;

import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;
import net.sourceforge.napkinlaf.util.NapkinRandom;

public class Point
extends Point2D.Double {
    public Point(double x, double y) {
        super(x, y);
    }

    public Point(Point2D clone) {
        super(clone.getX(), clone.getY());
    }

    public Point(Point2D start, double distance, double angle) {
        this(new StraightLine(start, distance, angle).getP2());
    }

    public Point magnify(double scaleFactor) {
        return new Point(this.x * scaleFactor, this.y * scaleFactor);
    }

    public static Point random(Point2D start, double stdev) {
        return new Point(start).random(stdev);
    }

    private Point random(double stdev) {
        double dist = NapkinRandom.gaussian(stdev);
        double angle = NapkinRandom.nextDouble(Math.PI) - 1.5707963267948966;
        return new Point(this, dist, angle);
    }

    public float floatX() {
        return (float)this.x;
    }

    public float floatY() {
        return (float)this.y;
    }

    public static Point midpoint(Point2D p1, Point2D p2) {
        return new StraightLine(p1, p2).midpoint();
    }
}

