/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.types.Revision;

public class ExternalItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String targetDir;
    private String url;
    private Revision revision;
    private Revision pegRevision;

    public ExternalItem(String string, String string2, Revision revision, Revision revision2) throws SubversionException {
        this(false, string, string2, revision, revision2);
        ExternalItem.validateRevision(revision, "revision");
        ExternalItem.validateRevision(revision2, "pegRevision");
    }

    private ExternalItem(boolean bl, String string, String string2, Revision revision, Revision revision2) {
        this.targetDir = string;
        this.url = string2;
        this.pegRevision = revision2 != null ? revision2 : Revision.HEAD;
        this.revision = revision != null ? revision : this.pegRevision;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public Revision getPegRevision() {
        return this.pegRevision;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExternalItem)) {
            return false;
        }
        ExternalItem externalItem = (ExternalItem)object;
        return this.targetDir.equals(externalItem.targetDir) && this.url.equals(externalItem.url) && this.revision.equals(externalItem.revision) && this.pegRevision.equals(externalItem.pegRevision);
    }

    public int hashCode() {
        int n = 17;
        n = n * 33 + (null != this.targetDir ? this.targetDir.hashCode() : 0);
        n = n * 33 + (null != this.url ? this.url.hashCode() : 0);
        n = n * 33 + (null != this.revision ? this.revision.hashCode() : 0);
        n = n * 33 + (null != this.pegRevision ? this.pegRevision.hashCode() : 0);
        return n;
    }

    private static void validateRevision(Revision revision, String string) throws SubversionException {
        if (revision != null && revision.getKind() != Revision.Kind.number && revision.getKind() != Revision.Kind.date && revision.getKind() != Revision.Kind.head) {
            throw new BadRevisionKindException(string);
        }
    }

    private static class BadRevisionKindException
    extends SubversionException {
        private static final long serialVersionUID = 1L;

        public BadRevisionKindException(String string) {
            super("the '" + string + "' constructor argument must be a date, a number, or Revision.HEAD");
        }
    }
}

