/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.ApplicationListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolderState;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListModel;
import net.sourceforge.squirrel_sql.client.gui.db.EditAliasFolderDlg;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasTreeInterface;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandler;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class JTreeAliasesListImpl
implements IAliasesList,
IAliasTreeInterface {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(JTreeAliasesListImpl.class);
    private static final ILogger s_log = LoggerController.createLogger(JTreeAliasesListImpl.class);
    private TreeDnDHandler _treeDnDHandler;
    JTree _tree = new JTree(){

        @Override
        public String getToolTipText(MouseEvent event) {
            return JTreeAliasesListImpl.this.getToolTipText(event);
        }
    };
    private JScrollPane _comp = new JScrollPane(this._tree);
    private IApplication _app;
    private AliasesListModel _aliasesListModel;
    private TreePath[] _pathsToPaste;
    private PasteMode _pasteMode;
    private boolean _dontReactToAliasAdd = false;

    public JTreeAliasesListImpl(IApplication app, AliasesListModel aliasesListModel) {
        this._app = app;
        this._aliasesListModel = aliasesListModel;
        this._tree.setRootVisible(false);
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        root.removeAllChildren();
        this._tree.getSelectionModel().setSelectionMode(2);
        this._tree.setToolTipText("init");
        this.initRenderer();
        this.initDnD();
        this._aliasesListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                JTreeAliasesListImpl.this.onAliasAdded(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JTreeAliasesListImpl.this.onAliasRemoved(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                JTreeAliasesListImpl.this.onAliasChanged(e);
            }
        });
        this._app.addApplicationListener(new ApplicationListener(){

            @Override
            public void saveApplicationState() {
                JTreeAliasesListImpl.this.onSaveApplicationState();
            }
        });
        this.initTree();
    }

    private void initRenderer() {
        DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return JTreeAliasesListImpl.this.modifyRenderer(super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus), value);
            }
        };
        this._tree.setCellRenderer(treeCellRenderer);
        AbstractAction cancelCutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != JTreeAliasesListImpl.this._pathsToPaste && PasteMode.CUT.equals((Object)JTreeAliasesListImpl.this._pasteMode)) {
                    JTreeAliasesListImpl.access$502(JTreeAliasesListImpl.this, null);
                    JTreeAliasesListImpl.this._tree.repaint();
                }
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._tree.getInputMap(1).put(escapeStroke, "cancelCutAction");
        this._tree.getInputMap(2).put(escapeStroke, "cancelCutAction");
        this._tree.getInputMap(0).put(escapeStroke, "cancelCutAction");
        this._tree.getActionMap().put("cancelCutAction", cancelCutAction);
    }

    private Component modifyRenderer(Component component, Object node) {
        JLabel ret = (JLabel)component;
        ret.setEnabled(true);
        if (null != this._pathsToPaste && PasteMode.CUT.equals((Object)this._pasteMode)) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
            boolean found = false;
            for (TreePath treePath : this._pathsToPaste) {
                if (treePath.getLastPathComponent() != dmtn) continue;
                found = true;
                break;
            }
            ret.setEnabled(!found);
            ret.setDisabledIcon(ret.getIcon());
        }
        return component;
    }

    private void initDnD() {
        TreeDnDHandlerCallback treeDnDHandlerCallback = new TreeDnDHandlerCallback(){

            @Override
            public boolean nodeAcceptsKids(DefaultMutableTreeNode selNode) {
                return JTreeAliasesListImpl.this.onNodeAcceptsKids(selNode);
            }

            @Override
            public void dndExecuted() {
            }

            @Override
            public ArrayList<DefaultMutableTreeNode> createPasteTreeNodesFromExternalTransfer(DropTargetDropEvent dtde, TreePath targetPath) {
                return null;
            }
        };
        this._treeDnDHandler = new TreeDnDHandler(this._tree, treeDnDHandlerCallback);
    }

    private boolean onNodeAcceptsKids(DefaultMutableTreeNode selNode) {
        return false == selNode.isLeaf();
    }

    private void initTree() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        root.removeAllChildren();
        File file = new ApplicationFiles().getDatabaseAliasesTreeStructureFile();
        if (!this.readTreeStructureFile(root, file)) {
            for (int i = 0; i < this._aliasesListModel.size(); ++i) {
                root.add(new DefaultMutableTreeNode(this._aliasesListModel.get(i)));
            }
            treeModel.nodeStructureChanged(root);
        }
    }

    private boolean readTreeStructureFile(DefaultMutableTreeNode root, File file) {
        boolean result = false;
        try {
            if (file.exists() && file.length() > 0L) {
                XMLBeanReader rdr = new XMLBeanReader();
                rdr.load(file);
                AliasFolderState rootState = (AliasFolderState)rdr.iterator().next();
                this.applyAliasFolderState(root, rootState);
                result = true;
            }
        }
        catch (Exception e) {
            s_log.error("Unexpected exception while applying Aliases tree structure from file: " + file.getAbsolutePath(), e);
        }
        return result;
    }

    private void applyAliasFolderState(DefaultMutableTreeNode rootNode, AliasFolderState rootState) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        for (AliasFolderState aliasFolderState : rootState.getKids()) {
            aliasFolderState.applyNodes(rootNode, this._aliasesListModel);
        }
        ArrayList<SQLAlias> unknownAliases = new ArrayList<SQLAlias>();
        for (int i = 0; i < this._aliasesListModel.size(); ++i) {
            SQLAlias sqlAlias = (SQLAlias)this._aliasesListModel.get(i);
            if (null != this.findNode(sqlAlias, rootNode)) continue;
            unknownAliases.add(sqlAlias);
        }
        for (SQLAlias alias : unknownAliases) {
            rootNode.add(new DefaultMutableTreeNode(alias));
        }
        treeModel.nodeStructureChanged(rootNode);
        for (AliasFolderState aliasFolderState : rootState.getKids()) {
            aliasFolderState.applyExpansionAndSelection(this._tree);
        }
    }

    private void onSaveApplicationState() {
        try {
            DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            AliasFolderState state = new AliasFolderState(root, this._tree);
            XMLBeanWriter wrt = new XMLBeanWriter(state);
            wrt.save(new ApplicationFiles().getDatabaseAliasesTreeStructureFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onAliasChanged(ListDataEvent e) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        SQLAlias changedAlias = (SQLAlias)this._aliasesListModel.get(e.getIndex0());
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode node = this.findNode(changedAlias, root);
        treeModel.nodeChanged(node);
    }

    private DefaultMutableTreeNode findNode(SQLAlias sqlAlias, DefaultMutableTreeNode tn) {
        if (sqlAlias.equals(tn.getUserObject())) {
            return tn;
        }
        for (int i = 0; i < tn.getChildCount(); ++i) {
            DefaultMutableTreeNode ret = this.findNode(sqlAlias, (DefaultMutableTreeNode)tn.getChildAt(i));
            if (null == ret) continue;
            return ret;
        }
        return null;
    }

    private void onAliasRemoved(ListDataEvent e) {
        if (this._aliasesListModel.isBeingSortedForListImpl()) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        ArrayList<DefaultMutableTreeNode> delNodes = this.findRemovedNodes();
        if (0 == delNodes.size()) {
            return;
        }
        DefaultMutableTreeNode toSelectNextTo = delNodes.get(delNodes.size() - 1);
        DefaultMutableTreeNode nextToSel = toSelectNextTo.getNextSibling();
        if (null == nextToSel) {
            nextToSel = toSelectNextTo.getPreviousSibling();
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)toSelectNextTo.getParent();
        for (DefaultMutableTreeNode delNode : delNodes) {
            treeModel.removeNodeFromParent(delNode);
        }
        if (null != nextToSel) {
            this._tree.setSelectionPath(new TreePath(nextToSel.getPath()));
        } else if (parent != this._tree.getModel().getRoot()) {
            this._tree.setSelectionPath(new TreePath(parent.getPath()));
        }
    }

    private ArrayList<DefaultMutableTreeNode> findRemovedNodes() {
        ArrayList<SQLAlias> buf = new ArrayList<SQLAlias>();
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        this.fillAllAliasesFrom(root, buf);
        ArrayList<DefaultMutableTreeNode> ret = new ArrayList<DefaultMutableTreeNode>();
        for (SQLAlias sqlAlias : buf) {
            if (-1 != this._aliasesListModel.getIndex(sqlAlias)) continue;
            ret.add(this.findNode(sqlAlias, root));
        }
        return ret;
    }

    private void fillAllAliasesFrom(DefaultMutableTreeNode node, ArrayList<SQLAlias> toFill) {
        if (node.getUserObject() instanceof SQLAlias) {
            toFill.add((SQLAlias)node.getUserObject());
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.fillAllAliasesFrom((DefaultMutableTreeNode)node.getChildAt(i), toFill);
            }
        }
    }

    private void onAliasAdded(ListDataEvent e) {
        if (this._dontReactToAliasAdd || this._aliasesListModel.isBeingSortedForListImpl()) {
            return;
        }
        SQLAlias newAlias = (SQLAlias)this._aliasesListModel.get(e.getIndex0());
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newAlias);
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        TreePath selPath = this._tree.getSelectionPath();
        if (null == selPath) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            root.add(newNode);
        } else {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (selNode.getUserObject() instanceof SQLAlias) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selPath.getParentPath().getLastPathComponent();
                int formerSilblingIx = treeModel.getIndexOfChild(parentNode, selNode);
                treeModel.insertNodeInto(newNode, parentNode, formerSilblingIx + 1);
            } else {
                selNode.add(newNode);
            }
        }
        treeModel.nodeStructureChanged((DefaultMutableTreeNode)treeModel.getRoot());
        this._tree.setSelectionPath(new TreePath(treeModel.getPathToRoot(newNode)));
    }

    @Override
    public SQLAlias getSelectedAlias(MouseEvent evt) {
        TreePath path = this._tree.getSelectionPath();
        if (null == path) {
            return null;
        }
        if (!(path.getLastPathComponent() instanceof DefaultMutableTreeNode)) {
            return null;
        }
        if (null != evt && !this._tree.getPathBounds(path).contains(evt.getPoint())) {
            return null;
        }
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(tn.getUserObject() instanceof ISQLAlias)) {
            return null;
        }
        return (SQLAlias)tn.getUserObject();
    }

    @Override
    public void sortAliases() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        AliasFolderState state = new AliasFolderState(root, this._tree);
        state.sort();
        root.removeAllChildren();
        this.applyAliasFolderState(root, state);
    }

    @Override
    public void requestFocus() {
        this._tree.requestFocus();
    }

    @Override
    public void deleteSelected() {
        TreePath[] selectionPaths = this._tree.getSelectionPaths();
        if (1 == selectionPaths.length) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selectionPaths[0].getLastPathComponent();
            TreeNode parent = selNode.getParent();
            if (selNode.getUserObject() instanceof SQLAlias) {
                SQLAlias toDel = (SQLAlias)selNode.getUserObject();
                if (Dialogs.showYesNo(this._app.getMainFrame(), s_stringMgr.getString("JTreeAliasesListImpl.confirmDelete", toDel.getName()))) {
                    this.removeAlias(toDel);
                }
            } else if (Dialogs.showYesNo(this._app.getMainFrame(), s_stringMgr.getString("JTreeAliasesListImpl.confirmDeleteFolder", selNode.getUserObject()))) {
                this.removeAllAliasesFromNode(selNode);
                DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
                int indexOfChild = dtm.getIndexOfChild(parent, selNode);
                selNode.removeFromParent();
                dtm.nodesWereRemoved(parent, new int[]{indexOfChild}, new Object[]{selNode});
            }
        } else if (1 < selectionPaths.length && Dialogs.showYesNo(this._app.getMainFrame(), s_stringMgr.getString("JTreeAliasesListImpl.confirmDeleteMultible"))) {
            final HashSet<TreeNode> parentsRemovedFrom = new HashSet<TreeNode>();
            for (TreePath selectionPath : selectionPaths) {
                DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                parentsRemovedFrom.add(selNode.getParent());
                if (selNode.getUserObject() instanceof SQLAlias) {
                    SQLAlias toDel = (SQLAlias)selNode.getUserObject();
                    this.removeAlias(toDel);
                    continue;
                }
                this.removeAllAliasesFromNode(selNode);
                selNode.removeFromParent();
            }
            final DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (TreeNode node : parentsRemovedFrom) {
                        dtm.nodeStructureChanged(node);
                    }
                }
            });
        }
    }

    @Override
    public void modifySelected() {
        TreePath selPath = this._tree.getSelectionPath();
        if (null == selPath) {
            return;
        }
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        if (selNode.getUserObject() instanceof SQLAlias) {
            this._app.getWindowManager().showModifyAliasInternalFrame((ISQLAlias)selNode.getUserObject());
        } else {
            String title = s_stringMgr.getString("JTreeAliasesListImpl.EditAliasFolderDlgTitle");
            String text = s_stringMgr.getString("JTreeAliasesListImpl.EditAliasFolderDlgText");
            EditAliasFolderDlg dlg = new EditAliasFolderDlg(this._app.getMainFrame(), title, text, selNode.getUserObject().toString());
            GUIUtils.centerWithinParent(dlg);
            dlg.setVisible(true);
            String folderName = dlg.getFolderName();
            if (null == folderName) {
                return;
            }
            selNode.setUserObject(folderName);
            DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
            treeModel.nodeChanged(selNode);
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._aliasesListModel.getSize();
    }

    private void removeAllAliasesFromNode(DefaultMutableTreeNode selNode) {
        if (selNode.getUserObject() instanceof SQLAlias) {
            SQLAlias toDel = (SQLAlias)selNode.getUserObject();
            this.removeAlias(toDel);
        } else {
            ArrayList<DefaultMutableTreeNode> buf = new ArrayList<DefaultMutableTreeNode>();
            for (int i = 0; i < selNode.getChildCount(); ++i) {
                buf.add((DefaultMutableTreeNode)selNode.getChildAt(i));
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode : buf) {
                this.removeAllAliasesFromNode(defaultMutableTreeNode);
            }
        }
    }

    private void removeAlias(SQLAlias toDel) {
        this._aliasesListModel.remove(this._aliasesListModel.getIndex(toDel));
        this._app.getDataCache().removeAlias(toDel);
    }

    @Override
    public void selectListEntryAtPoint(Point point) {
        TreePath path = this._tree.getPathForLocation(point.x, point.y);
        if (null != path) {
            this._tree.setSelectionPath(path);
        }
    }

    @Override
    public JComponent getComponent() {
        return this._comp;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this._tree.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this._tree.removeMouseListener(mouseListener);
    }

    public String getToolTipText(MouseEvent evt) {
        TreePath path = this._tree.getPathForLocation(evt.getPoint().x, evt.getPoint().y);
        if (null == path) {
            return null;
        }
        if (!(path.getLastPathComponent() instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (!(userObj instanceof ISQLAlias)) {
            return null;
        }
        return ((ISQLAlias)userObj).getName();
    }

    @Override
    public void createNewFolder() {
        String title = s_stringMgr.getString("JTreeAliasesListImpl.NewAliasFolderDlgTitle");
        String text = s_stringMgr.getString("JTreeAliasesListImpl.NewAliasFolderDlgText");
        EditAliasFolderDlg dlg = new EditAliasFolderDlg(this._app.getMainFrame(), title, text, null);
        GUIUtils.centerWithinParent(dlg);
        dlg.setVisible(true);
        String folderName = dlg.getFolderName();
        if (null == folderName) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        TreePath selPath = this._tree.getSelectionPath();
        DefaultMutableTreeNode newFolder = GUIUtils.createFolderNode(folderName);
        if (null != selPath) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (tn.isLeaf()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tn.getParent();
                int childIndex = parent.getIndex(tn) + 1;
                parent.insert(newFolder, childIndex);
                treeModel.nodesWereInserted(parent, new int[]{childIndex});
            } else {
                tn.add(newFolder);
                treeModel.nodeStructureChanged(tn);
            }
        } else {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
            int[] childIndices = new int[]{root.getChildCount()};
            root.add(newFolder);
            treeModel.nodesWereInserted(root, childIndices);
        }
        this._tree.setSelectionPath(new TreePath(newFolder.getPath()));
    }

    @Override
    public void cutSelected() {
        this._pathsToPaste = this._tree.getSelectionPaths();
        this._pasteMode = PasteMode.CUT;
        this._tree.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void pasteSelected() {
        try {
            if (null == this._pathsToPaste) {
                return;
            }
            switch (this._pasteMode) {
                case COPY: {
                    this.execCopyToPaste(this._pathsToPaste, this._tree.getSelectionPath());
                    return;
                }
                case CUT: {
                    this._treeDnDHandler.execCut(this._pathsToPaste, this._tree.getSelectionPath());
                    return;
                }
            }
            return;
        }
        finally {
            this._pathsToPaste = null;
        }
    }

    private void execCopyToPaste(TreePath[] pathsToPaste, TreePath targetPath) {
        int i;
        DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode[] copiedNodes = new DefaultMutableTreeNode[pathsToPaste.length];
        for (int i2 = 0; i2 < pathsToPaste.length; ++i2) {
            copiedNodes[i2] = this.createCopy((DefaultMutableTreeNode)pathsToPaste[i2].getLastPathComponent());
        }
        if (null == targetPath) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            for (i = 0; i < copiedNodes.length; ++i) {
                root.add(copiedNodes[i]);
            }
            dtm.nodeStructureChanged(root);
        } else {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
            if (selNode.isLeaf()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
                for (int i3 = 0; i3 < copiedNodes.length; ++i3) {
                    parent.insert(copiedNodes[i3], parent.getIndex(selNode) + 1);
                }
                dtm.nodeStructureChanged(parent);
            } else {
                for (int i4 = 0; i4 < copiedNodes.length; ++i4) {
                    selNode.add(copiedNodes[i4]);
                }
                dtm.nodeStructureChanged(selNode);
            }
        }
        TreePath[] newSelPaths = new TreePath[copiedNodes.length];
        for (i = 0; i < newSelPaths.length; ++i) {
            newSelPaths[i] = new TreePath(copiedNodes[i].getPath());
        }
        this._tree.setSelectionPaths(newSelPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultMutableTreeNode createCopy(DefaultMutableTreeNode nodeToCopy) {
        try {
            if (nodeToCopy.getUserObject() instanceof SQLAlias) {
                SQLAlias source = (SQLAlias)nodeToCopy.getUserObject();
                IIdentifierFactory factory = IdentifierFactory.getInstance();
                SQLAlias newAlias = this._app.getDataCache().createAlias(factory.createIdentifier());
                newAlias.assignFrom(source, false);
                try {
                    this._dontReactToAliasAdd = true;
                    this._app.getDataCache().addAlias(newAlias);
                }
                finally {
                    this._dontReactToAliasAdd = false;
                }
                return new DefaultMutableTreeNode(newAlias);
            }
            DefaultMutableTreeNode ret = GUIUtils.createFolderNode((String)nodeToCopy.getUserObject());
            for (int i = 0; i < nodeToCopy.getChildCount(); ++i) {
                ret.add(this.createCopy((DefaultMutableTreeNode)nodeToCopy.getChildAt(i)));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copyToPasteSelected() {
        this._pathsToPaste = this._tree.getSelectionPaths();
        this._pasteMode = PasteMode.COPY;
    }

    @Override
    public void collapseAll() {
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            this._tree.collapseRow(i);
        }
    }

    @Override
    public void expandAll() {
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            this._tree.expandRow(i);
        }
    }

    static /* synthetic */ TreePath[] access$502(JTreeAliasesListImpl x0, TreePath[] x1) {
        x0._pathsToPaste = x1;
        return x1;
    }

    private static enum PasteMode {
        COPY,
        CUT;

    }
}

