/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import net.infonode.util.Writable;

public class Enum
implements Serializable,
Writable {
    private static final long serialVersionUID = 1L;
    private static final HashMap VALUE_MAP = new HashMap();
    private int value;
    private transient String name;

    protected Enum(int n, String string) {
        this.value = n;
        this.name = string;
        HashMap<Integer, Enum> hashMap = (HashMap<Integer, Enum>)VALUE_MAP.get(this.getClass());
        if (hashMap == null) {
            hashMap = new HashMap<Integer, Enum>();
            VALUE_MAP.put(this.getClass(), hashMap);
        }
        hashMap.put(new Integer(n), this);
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeObject(objectOutputStream);
    }

    protected static Object getObject(Class clazz, int n) throws IOException {
        HashMap hashMap = (HashMap)VALUE_MAP.get(clazz);
        if (hashMap == null) {
            throw new IOException("Invalid enum class '" + clazz + "'!");
        }
        Object v = hashMap.get(new Integer(n));
        if (v == null) {
            throw new IOException("Invalid enum value '" + n + "'!");
        }
        return v;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.value = objectInputStream.readShort();
    }

    protected static Object decode(Class clazz, ObjectInputStream objectInputStream) throws IOException {
        return Enum.getObject(clazz, objectInputStream.readShort());
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return Enum.getObject(this.getClass(), this.getValue());
        }
        catch (IOException iOException) {
            return this;
        }
    }
}

