/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nimrod;

import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import net.sf.nimrod.NimRODBorders;
import net.sf.nimrod.NimRODLookAndFeel;
import net.sf.nimrod.NimRODUtils;

public class NimRODToggleButtonUI
extends MetalToggleButtonUI {
    protected MiListener miml;
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setBorder(NimRODBorders.getButtonBorder());
        this.selectColor = UIManager.getColor("ScrollBar.thumb");
    }

    @Override
    public void uninstallDefaults(AbstractButton button) {
        super.uninstallDefaults(button);
        button.setBorder(MetalBorders.getButtonBorder());
    }

    @Override
    public void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.miml = new MiListener(b);
        b.addMouseListener(this.miml);
        b.addPropertyChangeListener(this.miml);
        b.addFocusListener(this.miml);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.miml);
        b.removePropertyChangeListener(this.miml);
        b.removeFocusListener(this.miml);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.oldOpaque = c.isOpaque();
        if (c.getParent() instanceof JToolBar) {
            super.update(g, c);
        } else {
            c.setOpaque(false);
            super.update(g, c);
            c.setOpaque(this.oldOpaque);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!this.oldOpaque) {
            return;
        }
        if (b.isContentAreaFilled()) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(NimRODUtils.getColorAlfa(this.selectColor, 100));
            RoundRectangle2D.Float boton = this.hazBoton(b);
            g2D.fill(boton);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted() || !this.oldOpaque) {
            return;
        }
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        NimRODUtils.paintFocus(g, 3, 3, b.getWidth() - 6, b.getHeight() - 6, 2, 2, NimRODLookAndFeel.getFocusColor());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ButtonModel mod = ((AbstractButton)c).getModel();
        if (this.oldOpaque) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Float boton = this.hazBoton(c);
            g2D.clip(boton);
            g2D.setColor(NimRODLookAndFeel.getControl());
            g2D.fill(boton);
            if (c.getParent() instanceof JToolBar) {
                if (mod.isRollover() || mod.isPressed() || mod.isSelected()) {
                    c.setBorder(NimRODBorders.getGenBorder());
                } else {
                    c.setBorder(NimRODBorders.getEmptyGenBorder());
                }
                if (mod.isPressed() || mod.isSelected()) {
                    g2D.setColor(NimRODLookAndFeel.getFocusColor());
                    g2D.fill(boton);
                }
            } else {
                GradientPaint grad = null;
                grad = mod.isPressed() || mod.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODUtils.getSombra(), 0.0f, c.getHeight(), NimRODUtils.getBrillo()) : new GradientPaint(0.0f, 0.0f, NimRODUtils.getBrillo(), 0.0f, c.getHeight(), NimRODUtils.getSombra());
                g2D.setPaint(grad);
                g2D.fill(boton);
                if (mod.isRollover()) {
                    g2D.setColor(NimRODUtils.getRolloverColor());
                    g2D.fill(boton);
                }
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        super.paint(g, c);
    }

    private RoundRectangle2D.Float hazBoton(JComponent c) {
        RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
        boton.x = 0.0f;
        boton.y = 0.0f;
        boton.width = c.getWidth();
        boton.height = c.getHeight();
        boton.arcwidth = 8.0f;
        boton.archeight = 8.0f;
        return boton;
    }

    public class MiListener
    extends MouseInputAdapter
    implements PropertyChangeListener,
    FocusListener {
        private AbstractButton papi;

        MiListener(AbstractButton b) {
            this.papi = b;
        }

        public void refresh() {
            if (this.papi != null && this.papi.getParent() != null) {
                this.papi.getParent().repaint(this.papi.getX() - 5, this.papi.getY() - 5, this.papi.getWidth() + 10, this.papi.getHeight() + 10);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.papi.getModel().setRollover(true);
            this.refresh();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.papi.getModel().setRollover(false);
            this.refresh();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.papi.getModel().setRollover(false);
            this.refresh();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.papi.getModel().setRollover(false);
            this.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.refresh();
        }
    }
}

