require 'test/unit'

module Borges; end
#require 'Borges/Extensions/Array'
require 'Borges/Extensions/Numeric'
#require 'Borges/Extensions/Object'
#require 'Borges/Extensions/Proc'
require 'Borges/Extensions/String'

module Print
  def print(obj)
    str = ''
    obj.print_html_on str
    return str
  end
end

class NumericTest < Test::Unit::TestCase

  include Print

  def test_print_html_on
    assert_equal "1", print(1)
    assert_equal "1.1", print(1.1)
  end

  def test_to_cents
    assert_equal "$1.00", 1.to_cents
    assert_equal "$1.00", 1.0.to_cents

    assert_equal "$0.00", 0.to_cents
    assert_equal "$0.00", 0.0.to_cents

    assert_equal "$0.10", 0.1.to_cents
  end

end # class NumericTest

class StringTest < Test::Unit::TestCase

  include Print

  def test_print_html_on
    assert_equal "text", print("text")
  end

end # class StringTest

