/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.AbstractDockable;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class CompoundDemo
extends JPanel
implements DockingConstants {
    private JLabel titlebar;
    private Dockable dockableImpl;

    public CompoundDemo(String title) {
        this.titlebar = this.createTitlebar(" " + title);
        this.add(this.titlebar);
        this.setBorder(new LineBorder(Color.black));
        this.dockableImpl = new DockableImpl();
    }

    private JLabel createTitlebar(String title) {
        JLabel lbl = new JLabel(title);
        lbl.setForeground(Color.white);
        lbl.setBackground(Color.blue);
        lbl.setOpaque(true);
        return lbl;
    }

    public String getTitle() {
        return this.titlebar.getText().trim();
    }

    public void doLayout() {
        Insets in = this.getInsets();
        this.titlebar.setBounds(in.left, in.top, this.getWidth() - in.left - in.right, 25);
    }

    private Dockable getDockable() {
        return this.dockableImpl;
    }

    private static JPanel createContentPane() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)CompoundDemo.buildDockingPort("North"), "North");
        p.add((Component)CompoundDemo.buildDockingPort("South"), "South");
        p.add((Component)CompoundDemo.buildDockingPort("East"), "East");
        p.add((Component)CompoundDemo.buildDockingPort("West"), "West");
        p.add((Component)CompoundDemo.createDockingPort(), "Center");
        return p;
    }

    private static DefaultDockingPort buildDockingPort(String desc) {
        DefaultDockingPort port = CompoundDemo.createDockingPort();
        CompoundDemo cd = new CompoundDemo(desc);
        DockingManager.registerDockable(cd.getDockable());
        port.dock(cd.getDockable(), "CENTER");
        return port;
    }

    private static DefaultDockingPort createDockingPort() {
        DefaultDockingPort port = new DefaultDockingPort();
        port.setBackground(Color.gray);
        port.setPreferredSize(new Dimension(100, 100));
        return port;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Compound Docking Demo");
        f.setContentPane(CompoundDemo.createContentPane());
        f.setSize(600, 400);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
    }

    private class DockableImpl
    extends AbstractDockable {
        private DockableImpl() {
            super("dockable." + CompoundDemo.this.getTitle());
            this.getDragSources().add(CompoundDemo.this.titlebar);
            this.setTabText(CompoundDemo.this.getTitle());
        }

        public Component getComponent() {
            return CompoundDemo.this;
        }
    }
}

