/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.AbstractWhereClausePart;

public class ParameterWhereClausePart
extends AbstractWhereClausePart {
    private IDataTypeComponent dataTypeComponent;
    private Object parameterValue;

    public ParameterWhereClausePart(ColumnDisplayDefinition columnDef, Object parameterValue, IDataTypeComponent dataTypeComponent) {
        super(columnDef);
        this.setDataTypeComponent(dataTypeComponent);
        this.setParameterValue(parameterValue);
        this.setWhereClause(this.getColumn() + " = ?");
    }

    protected void setParameterValue(Object parameterValue) {
        if (parameterValue == null) {
            throw new IllegalArgumentException("The parameterValue must not be null");
        }
        this.parameterValue = parameterValue;
    }

    private void setDataTypeComponent(IDataTypeComponent dataTypeComponent) {
        if (dataTypeComponent == null) {
            throw new IllegalArgumentException("column must be not empty");
        }
        this.dataTypeComponent = dataTypeComponent;
    }

    public Object getParameterValue() {
        return this.parameterValue;
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int position) throws SQLException {
        this.dataTypeComponent.setPreparedStatementValue(pstmt, this.parameterValue, position);
    }

    @Override
    public boolean isParameterUsed() {
        return true;
    }

    @Override
    public Object getParamValue() {
        return this.parameterValue;
    }
}

