/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel.completions;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Completion;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParserLogger;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLColumn;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatement;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLTable;

public class SQLModifyingStatement
extends SQLStatement {
    private SQLTable m_table;
    private int updateListStart = -1;
    private int updateListEnd = -1;

    public SQLModifyingStatement(int start) {
        super(start);
    }

    @Override
    public List<SQLSchema.Table> getTables(String catalog, String schema, String name) {
        if (name != null || this.m_table == null) {
            return super.getTables(catalog, schema, name);
        }
        List<SQLSchema.Table> tables = super.getTables(this.m_table.catalog, this.m_table.schema, this.m_table.name);
        ArrayList<SQLSchema.Table> result = new ArrayList<SQLSchema.Table>();
        for (SQLSchema.Table table : tables) {
            if (!table.matches(catalog, schema, name)) continue;
            result.add(table);
        }
        return result;
    }

    @Override
    public void addTable(SQLTable table) {
        super.addTable(table);
        this.m_table = table;
    }

    @Override
    public SQLSchema.Table getTable() {
        return this.getTable(this.m_table.catalog, this.m_table.schema, this.m_table.name);
    }

    @Override
    public boolean setTable(String catalog, String schema, String name, String alias) {
        return super.setTable(catalog, schema, name, alias);
    }

    public void setUpdateListStart(int position) {
        ParserLogger.log("updateListStart: " + position);
        this.updateListStart = position;
        this.updateListEnd = 99999;
    }

    public void setUpdateListEnd(int position) {
        this.updateListEnd = position;
    }

    @Override
    public Completion getCompletion(int position) {
        Completion c = super.getCompletion(position);
        if (c == null && position >= this.updateListStart && position <= this.updateListEnd) {
            SQLColumn col = new SQLColumn(this, position);
            col.setRepeatable(false);
            return col;
        }
        return c;
    }
}

