/*  Xsqlmenu
 *  Copyright (C) 1996-2000 Kees Lemmens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"
#include "Recorddefs.h"

void RecordInsert(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;
   int   y;
   char  query[MAXQUERY];
 
   sprintf(query,INSERT,I->Table);

   for(y=0;y<I->Numflds;y++)
   {
      TypeConvert(query + strlen(query),
		  fl_get_input(fd_Rec->Inputs[y]),I->Fields[y].type);

      if(y< I->Numflds - 1)
	strcat(query,",");
   }
   strcat(query,")");
   
#ifndef FORMS081   
   if(fl_show_question("Insert this record ?",1))
#else
     if(fl_show_question("Insert this record ?","",""))
#endif
     if (! ExecuteQuery(I,query))
     Info(I->Xsql,"Record inserted");
}

void XsqlInsert(FL_OBJECT *ob, long parent)
{
   FD_Xsql *Xsql = (FD_Xsql *)parent;
   Info_t  *I    = (Info_t *) Xsql->vdata;

   if(CheckTableSelected(Xsql) < 0)
     return;

   BuildRecordForm(I,"Insert Record",INSBUT);
}
