/*=============================================================================
author        :Walter Schreppers
filename      :executer.h
description   :Execute a parse tree.
bugreport(log):/
=============================================================================*/

#ifndef EXECUTER_H
#define EXECUTER_H

#include "treenode.h"
#include <iostream>
#include <string>
#include <map>
#include <stack>
#include <fstream>
#include <vector>

#include <stdio.h>

typedef map<unsigned int, Number* > symtable;
typedef map<string,TreeNode*> functable;

//using namespace std;

class Executer{
  
  public:
  
    //constructor
    //===========
    Executer(TreeNode* tree, int argc=0, char** args=0 );
    
    //public members
    //==============
    void run();  
  
  
  private:

    //private members
    //===============
    void runError( const string&, TreeNode* );
    void execute ( TreeNode* );  

    Number* getId( TreeNode* );
    
    void execBlock      ( TreeNode* );
    void execFor        ( TreeNode* );
    void execForEach    ( TreeNode* );
    void execWhile      ( TreeNode* );
    void execIf         ( TreeNode* );
    void execPrint      ( TreeNode* );
    void execInput      ( TreeNode* );
    void doAssign       ( TreeNode*, Number*   );
    void execAssign     ( TreeNode* );
    void execId         ( TreeNode* );
    void execInputArg   ( TreeNode* );
    void execArgCount   ( TreeNode* );
    void execConstant   ( TreeNode* );
    void execStrConstant( TreeNode* );
    
    void execFunction   ( TreeNode* );
    void execRetFunction( TreeNode* );
    void execReturn     ( TreeNode* );
    void execBreak      ( TreeNode* );

    void execAdd  ( TreeNode* );
    void execMul  ( TreeNode* );
    void execDiv  ( TreeNode* );
    void execSub  ( TreeNode* );
    void execNot  ( TreeNode* );

    void execGE   ( TreeNode* );
    void execGT   ( TreeNode* );
    void execLE   ( TreeNode* );
    void execLT   ( TreeNode* );
    void execNE   ( TreeNode* );
    void execEQ   ( TreeNode* );
    
    void execAnd   ( TreeNode* );
    void execOr    ( TreeNode* );
    void execMinus ( TreeNode* );

    void execRun    ( TreeNode* );
    void execCommand( TreeNode* );
    void execWrite  ( TreeNode* );
    
    void execLeft   ( TreeNode* );       
    void execRight  ( TreeNode* );      
    void execMid    ( TreeNode* );
    void execMod    ( TreeNode* );        
    void execLen    ( TreeNode* );        
    void execAsc    ( TreeNode* );        
    void execChr    ( TreeNode* );        
    void execRan    ( TreeNode* );        
    void execRead   ( TreeNode* );       
    void execRestore( TreeNode* );    
    void execData   ( TreeNode* );       
    void execStr    ( TreeNode* );
    void execVal    ( TreeNode* );
    
    string runCommand( const string& );
        
    //private locals
    //==============
    TreeNode* tree;
    stack<symtable> symbolTables;
    functable       functionTable;  //keep track of functionNode's
    stack<Number*>  runStack;       //stores parameters and return value of functions
    
    bool bReturn;  //used for return statements
    bool bBreak;   //used for break statement
    
    int     argc;
    char**  args;
    
    vector<Number> fData;
    vector<Number>::const_iterator fDataPointer;
};


#endif

