/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <assert.h>
#include <vsync/atomic.h>
#define BYTE_WIDTH 8U
/*****************************************************************************
 * UnitTest: vatomicsz_read
 *****************************************************************************/
static inline void
ut_atomic_sz_read(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_read_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_read_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read_acq(&obj);
    assert(val == (vsize_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_read_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_read_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read_rlx(&obj);
    assert(val == (vsize_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_init
 *****************************************************************************/
static inline void
ut_atomic_sz_init(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vatomicsz_init(&obj, SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_write
 *****************************************************************************/
static inline void
ut_atomic_sz_write(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vatomicsz_write(&obj, SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_write_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_write_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vatomicsz_write_rel(&obj, SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_write_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_write_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vatomicsz_write_rlx(&obj, SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xchg
 *****************************************************************************/
static inline void
ut_atomic_sz_xchg(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vsize_t old = vatomicsz_xchg(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xchg_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_xchg_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vsize_t old = vatomicsz_xchg_acq(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xchg_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_xchg_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vsize_t old = vatomicsz_xchg_rel(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_xchg_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t val     = vatomicsz_read(&obj);
    assert(val == (vsize_t)1);
    vsize_t old = vatomicsz_xchg_rlx(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_cmpxchg
 *****************************************************************************/
static inline void
ut_atomic_sz_cmpxchg(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    /* test failure */
    vsize_t old = vatomicsz_cmpxchg(&obj, SIZE_MAX, (vsize_t)1);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicsz_cmpxchg(&obj, (vsize_t)1, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_cmpxchg_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_cmpxchg_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    /* test failure */
    vsize_t old = vatomicsz_cmpxchg_acq(&obj, SIZE_MAX, (vsize_t)1);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicsz_cmpxchg_acq(&obj, (vsize_t)1, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_cmpxchg_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_cmpxchg_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    /* test failure */
    vsize_t old = vatomicsz_cmpxchg_rel(&obj, SIZE_MAX, (vsize_t)1);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicsz_cmpxchg_rel(&obj, (vsize_t)1, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_cmpxchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_cmpxchg_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    /* test failure */
    vsize_t old = vatomicsz_cmpxchg_rlx(&obj, SIZE_MAX, (vsize_t)1);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicsz_cmpxchg_rlx(&obj, (vsize_t)1, SIZE_MAX);
    assert(old == (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val, old);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_add
 * ****************************************************************************/
static inline void
ut_atomic_sz_add(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_add(&obj, v);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_add_rel
 * ****************************************************************************/
static inline void
ut_atomic_sz_add_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_add_rel(&obj, v);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_add_rlx
 * ****************************************************************************/
static inline void
ut_atomic_sz_add_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_add_rlx(&obj, v);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_add
 *****************************************************************************/
static inline void
ut_atomic_sz_get_add(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_add(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_add_get
 *****************************************************************************/
static inline void
ut_atomic_sz_add_get(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_add_get(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_add_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_add_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_add_acq(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_add_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_add_get_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_add_get_acq(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_add_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_add_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_add_rel(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_add_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_add_get_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_add_get_rel(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_add_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_add_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_add_rlx(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_add_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_add_get_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_add_get_rlx(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_inc
 * ****************************************************************************/
static inline void
ut_atomic_sz_inc(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_inc(&obj);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_inc_rel
 * ****************************************************************************/
static inline void
ut_atomic_sz_inc_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_inc_rel(&obj);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_inc_rlx
 * ****************************************************************************/
static inline void
ut_atomic_sz_inc_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_inc_rlx(&obj);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_inc
 *****************************************************************************/
static inline void
ut_atomic_sz_get_inc(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_inc(&obj);
        assert(old == ref);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_inc_get
 *****************************************************************************/
static inline void
ut_atomic_sz_inc_get(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref++;
        cur = vatomicsz_inc_get(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_inc_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_inc_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_inc_acq(&obj);
        assert(old == ref);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_inc_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_inc_get_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref++;
        cur = vatomicsz_inc_get_acq(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_inc_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_inc_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_inc_rel(&obj);
        assert(old == ref);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_inc_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_inc_get_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref++;
        cur = vatomicsz_inc_get_rel(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_inc_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_inc_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_inc_rlx(&obj);
        assert(old == ref);
        ref++;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_inc_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_inc_get_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref++;
        cur = vatomicsz_inc_get_rlx(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_sub
 * ****************************************************************************/
static inline void
ut_atomic_sz_sub(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_sub(&obj, v);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_sub_rel
 * ****************************************************************************/
static inline void
ut_atomic_sz_sub_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_sub_rel(&obj, v);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_sub_rlx
 * ****************************************************************************/
static inline void
ut_atomic_sz_sub_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_sub_rlx(&obj, v);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_sub
 *****************************************************************************/
static inline void
ut_atomic_sz_get_sub(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_sub(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_sub_get
 *****************************************************************************/
static inline void
ut_atomic_sz_sub_get(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_sub_get(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_sub_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_sub_acq(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_sub_acq(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_sub_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_sub_get_acq(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_sub_get_acq(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_sub_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_sub_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_sub_rel(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_sub_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_sub_get_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_sub_get_rel(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_sub_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_sub_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t old     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_sub_rlx(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_sub_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_sub_get_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;
    vsize_t cur     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        cur = vatomicsz_sub_get_rlx(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_dec
 * ****************************************************************************/
static inline void
ut_atomic_sz_dec(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_dec(&obj);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_dec_rel
 * ****************************************************************************/
static inline void
ut_atomic_sz_dec_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_dec_rel(&obj);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomicsz_dec_rlx
 * ****************************************************************************/
static inline void
ut_atomic_sz_dec_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        vatomicsz_dec_rlx(&obj);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_dec
 *****************************************************************************/
static inline void
ut_atomic_sz_get_dec(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t old     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_dec(&obj);
        assert(old == ref);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_dec_get
 *****************************************************************************/
static inline void
ut_atomic_sz_dec_get(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref--;
        cur = vatomicsz_dec_get(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_dec_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_dec_acq(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t old     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_dec_acq(&obj);
        assert(old == ref);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_dec_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_dec_get_acq(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref--;
        cur = vatomicsz_dec_get_acq(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_dec_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_dec_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t old     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_dec_rel(&obj);
        assert(old == ref);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_dec_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_dec_get_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref--;
        cur = vatomicsz_dec_get_rel(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_dec_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_dec_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t old     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        old = vatomicsz_get_dec_rlx(&obj);
        assert(old == ref);
        ref--;
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_dec_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_dec_get_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t max     = (vsize_t)1 + (vsize_t)10;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t val     = 0;

    for (vsize_t v = (vsize_t)1; v <= max; v++) {
        ref--;
        cur = vatomicsz_dec_get_rlx(&obj);
        assert(cur == ref);
        val = vatomicsz_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max
 *****************************************************************************/
static inline void
ut_atomic_sz_max(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vatomicsz_max(&obj, SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    vatomicsz_max(&obj, (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_max_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vatomicsz_max_rel(&obj, SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    vatomicsz_max_rel(&obj, (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_max_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vatomicsz_max_rlx(&obj, SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    vatomicsz_max_rlx(&obj, (vsize_t)1);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_max
 *****************************************************************************/
static inline void
ut_atomic_sz_get_max(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t old = vatomicsz_get_max(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    old = vatomicsz_get_max(&obj, (vsize_t)1);
    assert(old == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max_get
 *****************************************************************************/
static inline void
ut_atomic_sz_max_get(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t cur = vatomicsz_max_get(&obj, SIZE_MAX);
    assert(cur == SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    cur = vatomicsz_max_get(&obj, (vsize_t)1);
    assert(cur == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_max_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_max_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t old = vatomicsz_get_max_acq(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    old = vatomicsz_get_max_acq(&obj, (vsize_t)1);
    assert(old == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_max_get_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t cur = vatomicsz_max_get_acq(&obj, SIZE_MAX);
    assert(cur == SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    cur = vatomicsz_max_get_acq(&obj, (vsize_t)1);
    assert(cur == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_max_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_max_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t old = vatomicsz_get_max_rel(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    old = vatomicsz_get_max_rel(&obj, (vsize_t)1);
    assert(old == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_max_get_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t cur = vatomicsz_max_get_rel(&obj, SIZE_MAX);
    assert(cur == SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    cur = vatomicsz_max_get_rel(&obj, (vsize_t)1);
    assert(cur == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_max_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t old = vatomicsz_get_max_rlx(&obj, SIZE_MAX);
    assert(old == (vsize_t)1);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    old = vatomicsz_get_max_rlx(&obj, (vsize_t)1);
    assert(old == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_max_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_max_get_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};

    /* test write */
    vsize_t cur = vatomicsz_max_get_rlx(&obj, SIZE_MAX);
    assert(cur == SIZE_MAX);
    vsize_t val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    /* test no write */
    cur = vatomicsz_max_get_rlx(&obj, (vsize_t)1);
    assert(cur == SIZE_MAX);
    val = vatomicsz_read(&obj);
    assert(val == SIZE_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and
 *****************************************************************************/
static inline void
ut_atomic_sz_and(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomicsz_and(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_and_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomicsz_and_rel(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_and_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomicsz_and_rlx(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_and
 *****************************************************************************/
static inline void
ut_atomic_sz_get_and(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomicsz_get_and(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and_get
 *****************************************************************************/
static inline void
ut_atomic_sz_and_get(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomicsz_and_get(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_and_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_and_acq(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomicsz_get_and_acq(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_and_get_acq(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomicsz_and_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_and_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_and_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomicsz_get_and_rel(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_and_get_rel(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomicsz_and_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_and_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomicsz_get_and_rlx(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_and_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_and_get_rlx(void)
{
    vatomicsz_t obj = {SIZE_MAX};
    vsize_t mask    = SIZE_MAX;
    vsize_t ref     = SIZE_MAX;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomicsz_and_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or
 *****************************************************************************/
static inline void
ut_atomic_sz_or(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomicsz_or(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_or_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomicsz_or_rel(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_or_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomicsz_or_rlx(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_or
 *****************************************************************************/
static inline void
ut_atomic_sz_get_or(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        old  = vatomicsz_get_or(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get
 *****************************************************************************/
static inline void
ut_atomic_sz_or_get(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomicsz_or_get(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_or_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_or_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        old  = vatomicsz_get_or_acq(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_or_get_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomicsz_or_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_or_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_or_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        old  = vatomicsz_get_or_rel(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_or_get_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomicsz_or_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_or_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        old  = vatomicsz_get_or_rlx(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_or_get_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomicsz_or_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xor
 *****************************************************************************/
static inline void
ut_atomic_sz_xor(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomicsz_xor(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_xor_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomicsz_xor_rel(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_xor_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomicsz_xor_rlx(&obj, mask);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_xor
 *****************************************************************************/
static inline void
ut_atomic_sz_get_xor(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomicsz_get_xor(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get
 *****************************************************************************/
static inline void
ut_atomic_sz_xor_get(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomicsz_xor_get(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_xor_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_get_xor_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomicsz_get_xor_acq(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_sz_xor_get_acq(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomicsz_xor_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_get_xor_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomicsz_get_xor_rel(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_sz_xor_get_rel(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomicsz_xor_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_get_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_get_xor_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0x33;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;
    vsize_t old     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomicsz_get_xor_rlx(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomicsz_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_sz_xor_get_rlx(void)
{
    vatomicsz_t obj = {(vsize_t)1};
    vsize_t mask    = 0xFF;
    vsize_t ref     = (vsize_t)1;
    vsize_t cur     = 0;

    for (vsize_t i = 0; i < sizeof(vsize_t); i++) {
        mask = (vsize_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomicsz_xor_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomicsz_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    ut_atomic_sz_read();
    ut_atomic_sz_read_acq();
    ut_atomic_sz_read_rlx();

    ut_atomic_sz_init();

    ut_atomic_sz_write();
    ut_atomic_sz_write_rel();
    ut_atomic_sz_write_rlx();

    ut_atomic_sz_xchg();
    ut_atomic_sz_xchg_acq();
    ut_atomic_sz_xchg_rel();
    ut_atomic_sz_xchg_rlx();

    ut_atomic_sz_cmpxchg();
    ut_atomic_sz_cmpxchg_acq();
    ut_atomic_sz_cmpxchg_rel();
    ut_atomic_sz_cmpxchg_rlx();

    ut_atomic_sz_add();
    ut_atomic_sz_add_rel();
    ut_atomic_sz_add_rlx();
    ut_atomic_sz_get_add();
    ut_atomic_sz_add_get();
    ut_atomic_sz_get_add_acq();
    ut_atomic_sz_add_get_acq();
    ut_atomic_sz_get_add_rel();
    ut_atomic_sz_add_get_rel();
    ut_atomic_sz_get_add_rlx();
    ut_atomic_sz_add_get_rlx();

    ut_atomic_sz_inc();
    ut_atomic_sz_inc_rel();
    ut_atomic_sz_inc_rlx();
    ut_atomic_sz_get_inc();
    ut_atomic_sz_inc_get();
    ut_atomic_sz_get_inc_acq();
    ut_atomic_sz_inc_get_acq();
    ut_atomic_sz_get_inc_rel();
    ut_atomic_sz_inc_get_rel();
    ut_atomic_sz_get_inc_rlx();
    ut_atomic_sz_inc_get_rlx();

    ut_atomic_sz_sub();
    ut_atomic_sz_sub_rel();
    ut_atomic_sz_sub_rlx();
    ut_atomic_sz_get_sub();
    ut_atomic_sz_sub_get();
    ut_atomic_sz_get_sub_acq();
    ut_atomic_sz_sub_get_acq();
    ut_atomic_sz_get_sub_rel();
    ut_atomic_sz_sub_get_rel();
    ut_atomic_sz_get_sub_rlx();
    ut_atomic_sz_sub_get_rlx();

    ut_atomic_sz_dec();
    ut_atomic_sz_dec_rel();
    ut_atomic_sz_dec_rlx();
    ut_atomic_sz_get_dec();
    ut_atomic_sz_dec_get();
    ut_atomic_sz_get_dec_acq();
    ut_atomic_sz_dec_get_acq();
    ut_atomic_sz_get_dec_rel();
    ut_atomic_sz_dec_get_rel();
    ut_atomic_sz_get_dec_rlx();
    ut_atomic_sz_dec_get_rlx();

    ut_atomic_sz_max();
    ut_atomic_sz_max_rel();
    ut_atomic_sz_max_rlx();
    ut_atomic_sz_get_max();
    ut_atomic_sz_max_get();
    ut_atomic_sz_get_max_acq();
    ut_atomic_sz_max_get_acq();
    ut_atomic_sz_get_max_rel();
    ut_atomic_sz_max_get_rel();
    ut_atomic_sz_get_max_rlx();
    ut_atomic_sz_max_get_rlx();

    ut_atomic_sz_and();
    ut_atomic_sz_and_rel();
    ut_atomic_sz_and_rlx();
    ut_atomic_sz_get_and();
    ut_atomic_sz_and_get();
    ut_atomic_sz_get_and_acq();
    ut_atomic_sz_and_get_acq();
    ut_atomic_sz_get_and_rel();
    ut_atomic_sz_and_get_rel();
    ut_atomic_sz_get_and_rlx();
    ut_atomic_sz_and_get_rlx();

    ut_atomic_sz_or();
    ut_atomic_sz_or_rel();
    ut_atomic_sz_or_rlx();
    ut_atomic_sz_get_or();
    ut_atomic_sz_or_get();
    ut_atomic_sz_get_or_acq();
    ut_atomic_sz_or_get_acq();
    ut_atomic_sz_get_or_rel();
    ut_atomic_sz_or_get_rel();
    ut_atomic_sz_get_or_rlx();
    ut_atomic_sz_or_get_rlx();

    ut_atomic_sz_xor();
    ut_atomic_sz_xor_rel();
    ut_atomic_sz_xor_rlx();
    ut_atomic_sz_get_xor();
    ut_atomic_sz_xor_get();
    ut_atomic_sz_get_xor_acq();
    ut_atomic_sz_xor_get_acq();
    ut_atomic_sz_get_xor_rel();
    ut_atomic_sz_xor_get_rel();
    ut_atomic_sz_get_xor_rlx();
    ut_atomic_sz_xor_get_rlx();
    return 0;
}
