/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <pthread.h>
#include <assert.h>
#include <vsync/atomic.h>
/* keep number of threads even */
#define IT            10
#define V_DOUBLE(_v_) ((_v_)*2)
#define MAX_THREADS   10
#define VUINT32_VAL   ((((vuint32_t)0xF) << 16U) | ((vuint32_t)VUINT16_MAX))
#ifndef IS_EVEN
    #define IS_EVEN(_v_) (((_v_)&1U) == 0U)
#endif
vatomic32_t g_shared;
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_eq
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_eq_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    (void)vatomic32_await_eq(&g_shared, (VUINT32_VAL + (vuint32_t)tid));
    vatomic32_write(&g_shared, (VUINT32_VAL + (vuint32_t)tid + 1U));
    return NULL;
}
static inline void
mt_atomic_u32_await_eq(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_eq_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    assert(cur == (VUINT32_VAL + MAX_THREADS));
    V_UNUSED(cur);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_eq_add
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_eq_add_run(void *args)
{
    vsize_t tid         = (vsize_t)(vuintptr_t)args;
    vuint32_t await_val = (VUINT32_VAL + (vuint32_t)tid);
    vuint32_t new_val   = (1);
    (void)vatomic32_await_eq_add(&g_shared, await_val, new_val);
    return NULL;
}
static inline void
mt_atomic_u32_await_eq_add(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_eq_add_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    assert(cur == (VUINT32_VAL + MAX_THREADS));
    V_UNUSED(cur);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_eq_set
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_eq_set_run(void *args)
{
    vsize_t tid         = (vsize_t)(vuintptr_t)args;
    vuint32_t await_val = (VUINT32_VAL + (vuint32_t)tid);
    vuint32_t new_val   = ((VUINT32_VAL + (vuint32_t)tid + 1));
    (void)vatomic32_await_eq_set(&g_shared, await_val, new_val);
    return NULL;
}
static inline void
mt_atomic_u32_await_eq_set(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_eq_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    assert(cur == (VUINT32_VAL + MAX_THREADS));
    V_UNUSED(cur);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_eq_sub
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_eq_sub_run(void *args)
{
    vsize_t tid        = (vsize_t)(vuintptr_t)args;
    vuint32_t wait_val = (VUINT32_VAL + MAX_THREADS) - (vuint32_t)tid;
    (void)vatomic32_await_eq_sub(&g_shared, wait_val, 1);
    return NULL;
}
static inline void
mt_atomic_u32_await_eq_sub(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL + MAX_THREADS);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_eq_sub_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    assert(cur == VUINT32_VAL);
    V_UNUSED(cur);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_gt
 *****************************************************************************/
static inline void
mt_atomic_u32_await_gt_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_gt(&g_shared, (VUINT32_VAL + i));
    }
}
static inline void
mt_atomic_u32_await_gt_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_gt_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_gt_waiter();
    } else {
        mt_atomic_u32_await_gt_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_gt(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_gt_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = (VUINT32_VAL + (MAX_THREADS * IT));
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_ge
 *****************************************************************************/
static inline void
mt_atomic_u32_await_ge_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_ge(&g_shared, (VUINT32_VAL + i));
    }
}
static inline void
mt_atomic_u32_await_ge_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_ge_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_ge_waiter();
    } else {
        mt_atomic_u32_await_ge_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_ge(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_ge_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = (VUINT32_VAL + (MAX_THREADS * IT));
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_neq
 *****************************************************************************/
static inline void
mt_atomic_u32_await_neq_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_neq(&g_shared, (VUINT32_VAL + i));
    }
}
static inline void
mt_atomic_u32_await_neq_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_neq_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_neq_waiter();
    } else {
        mt_atomic_u32_await_neq_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_neq(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_neq_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = (VUINT32_VAL + (MAX_THREADS * IT));
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_lt
 *****************************************************************************/
static inline void
mt_atomic_u32_await_lt_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_lt(&g_shared, (VUINT32_VAL - i));
    }
}
static inline void
mt_atomic_u32_await_lt_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_dec(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_lt_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_lt_waiter();
    } else {
        mt_atomic_u32_await_lt_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_lt(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_lt_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = (VUINT32_VAL - (MAX_THREADS * IT));
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_gt_add
 *****************************************************************************/
static inline void
mt_atomic_u32_await_gt_add_waiter(void)
{
    vuint32_t await_val = 0;
    for (vuint32_t i = 0; i < IT; i++) {
        await_val = (VUINT32_VAL + i) + 1;
        (void)vatomic32_await_gt_add(&g_shared, await_val, 1);
    }
}
static inline void
mt_atomic_u32_await_gt_add_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_gt_add_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_gt_add_waiter();
    } else {
        mt_atomic_u32_await_gt_add_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_gt_add(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_gt_add_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL + (MAX_THREADS * IT)) + ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_ge_add
 *****************************************************************************/
static inline void
mt_atomic_u32_await_ge_add_waiter(void)
{
    vuint32_t await_val = 0;
    for (vuint32_t i = 0; i < IT; i++) {
        await_val = (VUINT32_VAL + i) + 1;
        (void)vatomic32_await_ge_add(&g_shared, await_val, 1);
    }
}
static inline void
mt_atomic_u32_await_ge_add_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_ge_add_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_ge_add_waiter();
    } else {
        mt_atomic_u32_await_ge_add_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_ge_add(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_ge_add_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL + (MAX_THREADS * IT)) + ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_neq_add
 *****************************************************************************/
static inline void
mt_atomic_u32_await_neq_add_waiter(void)
{
    vuint32_t await_val = 0;
    for (vuint32_t i = 0; i < IT; i++) {
        await_val = (VUINT32_VAL + i) + 1;
        (void)vatomic32_await_neq_add(&g_shared, await_val, 1);
    }
}
static inline void
mt_atomic_u32_await_neq_add_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_neq_add_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_neq_add_waiter();
    } else {
        mt_atomic_u32_await_neq_add_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_neq_add(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_neq_add_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL + (MAX_THREADS * IT)) + ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_lt_add
 *****************************************************************************/
static inline void
mt_atomic_u32_await_lt_add_waiter(void)
{
    vuint32_t await_val = 0;
    for (vuint32_t i = 0; i < IT; i++) {
        await_val = (VUINT32_VAL - i) - 1;
        (void)vatomic32_await_lt_add(&g_shared, await_val, 1);
    }
}
static inline void
mt_atomic_u32_await_lt_add_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_dec(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_lt_add_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_lt_add_waiter();
    } else {
        mt_atomic_u32_await_lt_add_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_lt_add(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_lt_add_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL - (MAX_THREADS * IT)) + ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_gt_sub
 *****************************************************************************/
static inline void
mt_atomic_u32_await_gt_sub_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_gt_sub(&g_shared, VUINT32_VAL + i + 1, 1);
    }
}
static inline void
mt_atomic_u32_await_gt_sub_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_gt_sub_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_gt_sub_waiter();
    } else {
        mt_atomic_u32_await_gt_sub_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_gt_sub(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_gt_sub_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL + (MAX_THREADS * IT)) - ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_ge_sub
 *****************************************************************************/
static inline void
mt_atomic_u32_await_ge_sub_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_ge_sub(&g_shared, VUINT32_VAL + i + 1, 1);
    }
}
static inline void
mt_atomic_u32_await_ge_sub_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_ge_sub_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_ge_sub_waiter();
    } else {
        mt_atomic_u32_await_ge_sub_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_ge_sub(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_ge_sub_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL + (MAX_THREADS * IT)) - ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_neq_sub
 *****************************************************************************/
static inline void
mt_atomic_u32_await_neq_sub_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_neq_sub(&g_shared, VUINT32_VAL + i + 1, 1);
    }
}
static inline void
mt_atomic_u32_await_neq_sub_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_inc(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_neq_sub_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_neq_sub_waiter();
    } else {
        mt_atomic_u32_await_neq_sub_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_neq_sub(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_neq_sub_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL + (MAX_THREADS * IT)) - ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_lt_sub
 *****************************************************************************/
static inline void
mt_atomic_u32_await_lt_sub_waiter(void)
{
    for (vuint32_t i = 0; i < IT; i++) {
        (void)vatomic32_await_lt_sub(&g_shared, VUINT32_VAL - (i - 1), 1);
    }
}
static inline void
mt_atomic_u32_await_lt_sub_writer(void)
{
    for (vuint32_t i = 0; i < V_DOUBLE(IT); i++) {
        vatomic32_dec(&g_shared);
    }
}
static inline void *
mt_atomic_u32_await_lt_sub_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        mt_atomic_u32_await_lt_sub_waiter();
    } else {
        mt_atomic_u32_await_lt_sub_writer();
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_lt_sub(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_lt_sub_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur = vatomic32_read(&g_shared);
    vuint32_t expected =
        (VUINT32_VAL - (MAX_THREADS * IT)) - ((MAX_THREADS / 2) * IT);
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_gt_set
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_gt_set_run(void *args)
{
    vsize_t tid        = (vsize_t)(vuintptr_t)args;
    vuint32_t wait_val = VUINT32_VAL + (vuint32_t)tid;
    vuint32_t set_val  = wait_val + 2;
    (void)vatomic32_await_gt_set(&g_shared, wait_val, set_val);
    return NULL;
}
static inline void
mt_atomic_u32_await_gt_set(void)
{
    vuint32_t init_val = VUINT32_VAL + 1;
    vatomic32_init(&g_shared, init_val);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_gt_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = init_val + (vuint32_t)MAX_THREADS;
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_ge_set
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_ge_set_run(void *args)
{
    vsize_t tid        = (vsize_t)(vuintptr_t)args;
    vuint32_t wait_val = VUINT32_VAL + (vuint32_t)tid;
    vuint32_t set_val  = wait_val + 1;
    (void)vatomic32_await_ge_set(&g_shared, wait_val, set_val);
    return NULL;
}
static inline void
mt_atomic_u32_await_ge_set(void)
{
    vuint32_t init_val = VUINT32_VAL;
    vatomic32_init(&g_shared, init_val);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_ge_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = init_val + (vuint32_t)MAX_THREADS;
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_lt_set
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_lt_set_run(void *args)
{
    vsize_t tid        = (vsize_t)(vuintptr_t)args;
    vuint32_t wait_val = VUINT32_VAL - (vuint32_t)tid;
    vuint32_t set_val  = wait_val - 2;
    (void)vatomic32_await_lt_set(&g_shared, wait_val, set_val);
    return NULL;
}
static inline void
mt_atomic_u32_await_lt_set(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL - 1);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_lt_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = (VUINT32_VAL - 1) - (vuint32_t)MAX_THREADS;
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Multi-thread Test: vatomic32_await_neq_set
 *****************************************************************************/
static inline void *
mt_atomic_u32_await_neq_set_run(void *args)
{
    vsize_t tid = (vsize_t)(vuintptr_t)args;
    if (IS_EVEN(tid)) {
        (void)vatomic32_await_neq_set(&g_shared, VUINT32_VAL, VUINT32_VAL);
    } else {
        (void)vatomic32_await_neq_set(&g_shared, ~VUINT32_VAL, ~VUINT32_VAL);
    }
    return NULL;
}
static inline void
mt_atomic_u32_await_neq_set(void)
{
    vatomic32_init(&g_shared, VUINT32_VAL);
    pthread_t t[MAX_THREADS];
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_create(&t[i], 0, mt_atomic_u32_await_neq_set_run, (void *)i);
    for (vsize_t i = 0; i < MAX_THREADS; i++)
        pthread_join(t[i], 0);
    vuint32_t cur      = vatomic32_read(&g_shared);
    vuint32_t expected = VUINT32_VAL;
    assert(cur == expected);
    V_UNUSED(cur, expected);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    mt_atomic_u32_await_gt();
    mt_atomic_u32_await_ge();
    mt_atomic_u32_await_lt();
    mt_atomic_u32_await_eq();
    mt_atomic_u32_await_neq();

    mt_atomic_u32_await_gt_add();
    mt_atomic_u32_await_ge_add();
    mt_atomic_u32_await_lt_add();
    mt_atomic_u32_await_eq_add();
    mt_atomic_u32_await_neq_add();

    mt_atomic_u32_await_gt_sub();
    mt_atomic_u32_await_ge_sub();
    mt_atomic_u32_await_lt_sub();
    mt_atomic_u32_await_eq_sub();
    mt_atomic_u32_await_neq_sub();

    mt_atomic_u32_await_gt_set();
    mt_atomic_u32_await_ge_set();
    mt_atomic_u32_await_lt_set();
    mt_atomic_u32_await_eq_set();
    mt_atomic_u32_await_neq_set();

    return 0;
}
