/* @(#)utfio.c	1.6 */

#include <config.h>

#include <stdio.h>
#include <utf.h>

#include <utftools.h>

/*
 * fputr(f, fp):
 *
 * The fputr() function writes the rune r to the stream fp. It returns
 * EOF if an error occurs, otherwise it returns r.
 */
long
fputr(Rune r, FILE *fp)
{
	char s[UTFmax];
	int i, n;

	n = runetochar(s, &r);
	for (i = 0; i < n; ++i)
		if (fputc(s[i], fp) == EOF)
			return EOF;
	return r;
}

/*
 * fgetr(fp):
 *
 * The fgetr() function reads rune from the stream fp. If an error
 * occurs, it returns EOF; if a bad rune it read, it returns Runeerror
 * (from utf.h); otherwise it returns the rune.
 */
long
fgetr(FILE *fp)
{
	Rune r;
	char s[UTFmax];
	int c, i;

	i = 0;
	do {
		if (i == UTFmax)
			return Runeerror;
		if ((c = fgetc(fp)) == EOF)
			return EOF;
		s[i++] = c;
	} while (!fullrune(s, i));
	chartorune(&r, s);
	return r;
}
