/* timing.c 
	vi:ts=3 sw=3:
 */

/* $Id: timing.c,v 1.1 1996/04/12 16:31:32 espie Exp espie $
 * $Log: timing.c,v $
 * Revision 1.1  1996/04/12 16:31:32  espie
 * Initial revision
 *
 */

#include "defs.h"
#include "timing.h"
     
ID("$Id: timing.c,v 1.1 1996/04/12 16:31:32 espie Exp espie $")

/* TIME_SCALE is one microsecond. Hence an unsigned long is enough
 * for a little over one hour */
#define TIME_SCALE 1000000

char *time2string(char *buffer, unsigned long t)
   {
   int s;

	t +=  TIME_SCALE/2;
	t /= TIME_SCALE;
   s = t % 60;
   t /= 60;
   sprintf(buffer, "%3d:%02d", (int)t, s);
   return buffer;
   }

unsigned long ratio2time(int n, int p)
	{
	return (unsigned long)n * TIME_SCALE / (unsigned long)p;
	}
