/*
 *
 * Copyright  2024 Ace Husky <acehusky12@gmail.com>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Ace Husky not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Ace Husky makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * ACE HUSKY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL ACE HUSKY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/* Apple standard colormaps.
 * Used when there is no mechanism for setting the colormap.
 */
const uint8_t apple8_cmap[256 * 3] = {
	0x0, 0x0, 0x0,
	0x0, 0x0, 0x33,
	0x0, 0x0, 0x66,
	0x0, 0x0, 0x99,
	0x0, 0x0, 0xcc,
	0x0, 0x0, 0xff,
	0x0, 0x33, 0x0,
	0x0, 0x33, 0x33,
	0x0, 0x33, 0x66,
	0x0, 0x33, 0x99,
	0x0, 0x33, 0xcc,
	0x0, 0x33, 0xff,
	0x0, 0x66, 0x0,
	0x0, 0x66, 0x33,
	0x0, 0x66, 0x66,
	0x0, 0x66, 0x99,
	0x0, 0x66, 0xcc,
	0x0, 0x66, 0xff,
	0x0, 0x99, 0x0,
	0x0, 0x99, 0x33,
	0x0, 0x99, 0x66,
	0x0, 0x99, 0x99,
	0x0, 0x99, 0xcc,
	0x0, 0x99, 0xff,
	0x0, 0xcc, 0x0,
	0x0, 0xcc, 0x33,
	0x0, 0xcc, 0x66,
	0x0, 0xcc, 0x99,
	0x0, 0xcc, 0xcc,
	0x0, 0xcc, 0xff,
	0x0, 0xff, 0x0,
	0x0, 0xff, 0x33,
	0x0, 0xff, 0x66,
	0x0, 0xff, 0x99,
	0x0, 0xff, 0xcc,
	0x0, 0xff, 0xff,
	0x33, 0x0, 0x0,
	0x33, 0x0, 0x33,
	0x33, 0x0, 0x66,
	0x33, 0x0, 0x99,
	0x33, 0x0, 0xcc,
	0x33, 0x0, 0xff,
	0x33, 0x33, 0x0,
	0x33, 0x33, 0x33,
	0x33, 0x33, 0x66,
	0x33, 0x33, 0x99,
	0x33, 0x33, 0xcc,
	0x33, 0x33, 0xff,
	0x33, 0x66, 0x0,
	0x33, 0x66, 0x33,
	0x33, 0x66, 0x66,
	0x33, 0x66, 0x99,
	0x33, 0x66, 0xcc,
	0x33, 0x66, 0xff,
	0x33, 0x99, 0x0,
	0x33, 0x99, 0x33,
	0x33, 0x99, 0x66,
	0x33, 0x99, 0x99,
	0x33, 0x99, 0xcc,
	0x33, 0x99, 0xff,
	0x33, 0xcc, 0x0,
	0x33, 0xcc, 0x33,
	0x33, 0xcc, 0x66,
	0x33, 0xcc, 0x99,
	0x33, 0xcc, 0xcc,
	0x33, 0xcc, 0xff,
	0x33, 0xff, 0x0,
	0x33, 0xff, 0x33,
	0x33, 0xff, 0x66,
	0x33, 0xff, 0x99,
	0x33, 0xff, 0xcc,
	0x33, 0xff, 0xff,
	0x66, 0x0, 0x0,
	0x66, 0x0, 0x33,
	0x66, 0x0, 0x66,
	0x66, 0x0, 0x99,
	0x66, 0x0, 0xcc,
	0x66, 0x0, 0xff,
	0x66, 0x33, 0x0,
	0x66, 0x33, 0x33,
	0x66, 0x33, 0x66,
	0x66, 0x33, 0x99,
	0x66, 0x33, 0xcc,
	0x66, 0x33, 0xff,
	0x66, 0x66, 0x0,
	0x66, 0x66, 0x33,
	0x66, 0x66, 0x66,
	0x66, 0x66, 0x99,
	0x66, 0x66, 0xcc,
	0x66, 0x66, 0xff,
	0x66, 0x99, 0x0,
	0x66, 0x99, 0x33,
	0x66, 0x99, 0x66,
	0x66, 0x99, 0x99,
	0x66, 0x99, 0xcc,
	0x66, 0x99, 0xff,
	0x66, 0xcc, 0x0,
	0x66, 0xcc, 0x33,
	0x66, 0xcc, 0x66,
	0x66, 0xcc, 0x99,
	0x66, 0xcc, 0xcc,
	0x66, 0xcc, 0xff,
	0x66, 0xff, 0x0,
	0x66, 0xff, 0x33,
	0x66, 0xff, 0x66,
	0x66, 0xff, 0x99,
	0x66, 0xff, 0xcc,
	0x66, 0xff, 0xff,
	0x99, 0x0, 0x0,
	0x99, 0x0, 0x33,
	0x99, 0x0, 0x66,
	0x99, 0x0, 0x99,
	0x99, 0x0, 0xcc,
	0x99, 0x0, 0xff,
	0x99, 0x33, 0x0,
	0x99, 0x33, 0x33,
	0x99, 0x33, 0x66,
	0x99, 0x33, 0x99,
	0x99, 0x33, 0xcc,
	0x99, 0x33, 0xff,
	0x99, 0x66, 0x0,
	0x99, 0x66, 0x33,
	0x99, 0x66, 0x66,
	0x99, 0x66, 0x99,
	0x99, 0x66, 0xcc,
	0x99, 0x66, 0xff,
	0x99, 0x99, 0x0,
	0x99, 0x99, 0x33,
	0x99, 0x99, 0x66,
	0x99, 0x99, 0x99,
	0x99, 0x99, 0xcc,
	0x99, 0x99, 0xff,
	0x99, 0xcc, 0x0,
	0x99, 0xcc, 0x33,
	0x99, 0xcc, 0x66,
	0x99, 0xcc, 0x99,
	0x99, 0xcc, 0xcc,
	0x99, 0xcc, 0xff,
	0x99, 0xff, 0x0,
	0x99, 0xff, 0x33,
	0x99, 0xff, 0x66,
	0x99, 0xff, 0x99,
	0x99, 0xff, 0xcc,
	0x99, 0xff, 0xff,
	0xcc, 0x0, 0x0,
	0xcc, 0x0, 0x33,
	0xcc, 0x0, 0x66,
	0xcc, 0x0, 0x99,
	0xcc, 0x0, 0xcc,
	0xcc, 0x0, 0xff,
	0xcc, 0x33, 0x0,
	0xcc, 0x33, 0x33,
	0xcc, 0x33, 0x66,
	0xcc, 0x33, 0x99,
	0xcc, 0x33, 0xcc,
	0xcc, 0x33, 0xff,
	0xcc, 0x66, 0x0,
	0xcc, 0x66, 0x33,
	0xcc, 0x66, 0x66,
	0xcc, 0x66, 0x99,
	0xcc, 0x66, 0xcc,
	0xcc, 0x66, 0xff,
	0xcc, 0x99, 0x0,
	0xcc, 0x99, 0x33,
	0xcc, 0x99, 0x66,
	0xcc, 0x99, 0x99,
	0xcc, 0x99, 0xcc,
	0xcc, 0x99, 0xff,
	0xcc, 0xcc, 0x0,
	0xcc, 0xcc, 0x33,
	0xcc, 0xcc, 0x66,
	0xcc, 0xcc, 0x99,
	0xcc, 0xcc, 0xcc,
	0xcc, 0xcc, 0xff,
	0xcc, 0xff, 0x0,
	0xcc, 0xff, 0x33,
	0xcc, 0xff, 0x66,
	0xcc, 0xff, 0x99,
	0xcc, 0xff, 0xcc,
	0xcc, 0xff, 0xff,
	0xff, 0x0, 0x0,
	0xff, 0x0, 0x33,
	0xff, 0x0, 0x66,
	0xff, 0x0, 0x99,
	0xff, 0x0, 0xcc,
	0xff, 0x0, 0xff,
	0xff, 0x33, 0x0,
	0xff, 0x33, 0x33,
	0xff, 0x33, 0x66,
	0xff, 0x33, 0x99,
	0xff, 0x33, 0xcc,
	0xff, 0x33, 0xff,
	0xff, 0x66, 0x0,
	0xff, 0x66, 0x33,
	0xff, 0x66, 0x66,
	0xff, 0x66, 0x99,
	0xff, 0x66, 0xcc,
	0xff, 0x66, 0xff,
	0xff, 0x99, 0x0,
	0xff, 0x99, 0x33,
	0xff, 0x99, 0x66,
	0xff, 0x99, 0x99,
	0xff, 0x99, 0xcc,
	0xff, 0x99, 0xff,
	0xff, 0xcc, 0x0,
	0xff, 0xcc, 0x33,
	0xff, 0xcc, 0x66,
	0xff, 0xcc, 0x99,
	0xff, 0xcc, 0xcc,
	0xff, 0xcc, 0xff,
	0xff, 0xff, 0x0,
	0xff, 0xff, 0x33,
	0xff, 0xff, 0x66,
	0xff, 0xff, 0x99,
	0xff, 0xff, 0xcc,
	0x11, 0xff, 0xff,
	0x22, 0xff, 0xff,
	0x44, 0xff, 0xff,
	0x55, 0xff, 0xff,
	0x77, 0xff, 0xff,
	0x88, 0xff, 0xff,
	0xaa, 0xff, 0xff,
	0xbb, 0xff, 0xff,
	0xdd, 0xff, 0xff,
	0xee, 0xff, 0xff,
	0xff, 0x11, 0xff,
	0xff, 0x22, 0xff,
	0xff, 0x44, 0xff,
	0xff, 0x55, 0xff,
	0xff, 0x77, 0xff,
	0xff, 0x88, 0xff,
	0xff, 0xaa, 0xff,
	0xff, 0xbb, 0xff,
	0xff, 0xdd, 0xff,
	0xff, 0xee, 0xff,
	0xff, 0xff, 0x11,
	0xff, 0xff, 0x22,
	0xff, 0xff, 0x44,
	0xff, 0xff, 0x55,
	0xff, 0xff, 0x77,
	0xff, 0xff, 0x88,
	0xff, 0xff, 0xaa,
	0xff, 0xff, 0xbb,
	0xff, 0xff, 0xdd,
	0xff, 0xff, 0xee,
	0x11, 0x11, 0x11,
	0x22, 0x22, 0x22,
	0x44, 0x44, 0x44,
	0x55, 0x55, 0x55,
	0x77, 0x77, 0x77,
	0x88, 0x88, 0x88,
	0xaa, 0xaa, 0xaa,
	0xbb, 0xbb, 0xbb,
	0xdd, 0xdd, 0xdd,
	0xee, 0xee, 0xee,
	0xff, 0xff, 0xff,
};

const uint8_t apple4_cmap[16 * 3] = {
	0xff, 0xff, 0xff, /* white */
	0xff, 0xff, 0x00, /* yellow */
	0xff, 0x9c, 0x9c, /* orange */
	0xff, 0x00, 0x00, /* red */
	0xff, 0x7f, 0x7f, /* pink */
	0xff, 0x00, 0xff, /* purple */
	0x00, 0x00, 0x7f, /* blue */
	0x00, 0xff, 0xff, /* cyan */ 
	0x00, 0xff, 0x00, /* light green */  
	0x00, 0x7f, 0x00, /* green */
	0x7f, 0x7f, 0x00, /* brown */
	0xff, 0xff, 0x00, /* lt. brown */
	0x3c, 0x3c, 0x3c, /* dark white */
	0x7f, 0x7f, 0x7f, /* lt. gray */
	0x92, 0x92, 0x92, /* dark gray */
	0x00, 0x00, 0x00, /* black */
};

