/*
 * The RIPper... interposes on the connection and handles RIP sequences
 */
#include <sys/stat.h>

#if defined(_MSC_VER)
 #define _USE_MATH_DEFINES // for C
#endif
#include <bitmap_con.h>
#include <ciolib.h>
#include <datewrap.h>
#include <dirwrap.h>
#include <gen_defs.h>
#include <genwrap.h>
#include <math.h>
#include <sockwrap.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strwrap.h>
#include <time.h>
#if defined(__unix__)
 #include <unistd.h>
#endif
#include <time.h>
#include <vidmodes.h>
#include <xpbeep.h>

#include "amigafont.h"
#include "conn.h"
#include "ripper.h"
#include "sexyz.h"
#include "syncterm.h"
#include "term.h"
#include "window.h"

// TODO: Output parsing... (yech)
// TODO: Actually make the graphics viewport work properly

bool rip_did_reinit;

#ifdef HAS_VSTAT

enum rip_state {
	RIP_STATE_BOL  // Beginning of the line
	,
	RIP_STATE_MOL  // Middle of the line
	,
	RIP_STATE_BANG // Got a bang (or CTRL-A or CTRL-B)

        // The following four groups must remain in this order and all must coincide

/*3*/,
	RIP_STATE_PIPE               // Got a pipe
	,
	RIP_STATE_LEVEL              // Got a level
	,
	RIP_STATE_SUBLEVEL           // Got a sub-level
	,
	RIP_STATE_CMD                // Got a command... parsing parameters
	,
	RIP_STATE_ENDED              // In unspecified text at the end of a command... look for pipes

/*8*/,
	RIP_STATE_BACKSLASH_PIPE     // Got a backslash... either an escape or a continue
	,
	RIP_STATE_BACKSLASH_LEVEL    // Got a backslash... either an escape or a continue
	,
	RIP_STATE_BACKSLASH_SUBLEVEL // Got a backslash... either an escape or a continue
	,
	RIP_STATE_BACKSLASH_CMD      // Got a backslash... either an escape or a continue
	,
	RIP_STATE_BACKSLASH_ENDED    // Got a backslash... either an escape or a continue

/*13*/,
	RIP_STATE_CONT_PIPE          // Got a \ continuation char in pipe state
	,
	RIP_STATE_CONT_LEVEL         // Got a \ continuation char in level state
	,
	RIP_STATE_CONT_SUBLEVEL      // Got a \ continuation char in sublevel state
	,
	RIP_STATE_CONT_CMD           // Got a \ continuation char in cmd state
	,
	RIP_STATE_CONT_ENDED         // Got a \ continuation char in ended state

        // Back to normal state definitions

/*18*/,
	RIP_STATE_CR         // Got a CR
	,
	RIP_STATE_ESC        // Got an ESC
	,
	RIP_STATE_CSI        // Got a CSI
	,
	RIP_STATE_CSINUM     // Got a CSI followed by a single digit
	,
	RIP_STATE_SKYPIX     // Got a CSI followed numbers and semi-colons
	,
	RIP_STATE_SKYPIX_STR // Got a SkyPix that requires a ! string at end.
	,
	RIP_STATE_FLUSHING   // Magical state
};

enum ansi_state {
	ANSI_STATE_NONE,
	ANSI_STATE_GOT_ESC,
	ANSI_STATE_GOT_CSI,
	ANSI_STATE_GOT_STRING,
	ANSI_STATE_GOT_LIMITED_STRING,
	ANSI_STATE_GOT_ESC_IN_STRING,
	ANSI_STATE_GOT_ESC_IN_LIMITED_STRING,
	ANSI_STATE_GOT_IB
};

enum rip_line_thickness {
	RIP_LINE_THICK_THIN = 1
	,
	RIP_LINE_THICK_THICK = 3
};

enum rip_write_modes {
	RIP_WRITE_MODE_COPY
	,
	RIP_WRITE_MODE_XOR
};

struct builtin_rip_variable {
	const char * const name;

	char             * (*func)(const char *var, const void * const data);

	const void * const data;
};

static char               *pending = NULL;
static size_t              pending_len = 0;
static size_t              pending_size = 0;

static BYTE               *moredata = NULL;
static size_t              moredata_len = 0;
static size_t              moredata_size = 0;

static uint8_t            *ripbuf = NULL;
static size_t              ripbuf_size = 0;
static size_t              ripbuf_pos = 0;
static size_t              ripbufpos = 0;
static bool                rip_suspended = false;

static struct mouse_field *rip_pressed = NULL;

struct rip_button_style {
	enum {
		LABEL_LOC_ABOVE,
		LABEL_LOC_LEFT,
		LABEL_LOC_CENTER,
		LABEL_LOC_RIGHT,
		LABEL_LOC_BELOW
	} label_location;
	enum {
		BUTTON_TYPE_ICON,
		BUTTON_TYPE_CLIPBOARD,
		BUTTON_TYPE_PLAIN,
		BUTTON_TYPE_COUNT
	} button;

	int width;
	int height;
	int bevel_size;
	int cfore;
	int cdshadow;
	int chighlight;
	int cshadow;
	int csurface;
	int culine;
	int ccorner;
	int group;

	struct {
		bool invertable    : 1;
		bool resetafter    : 1;
		bool chisel        : 1;
		bool recessed      : 1;
		bool dropshadow    : 1;
		bool autostamp     : 1;
		bool bevel         : 1;
		bool mouse         : 1;
		bool underlinehk   : 1;
		bool hot           : 1;
		bool vadjust       : 1;
		bool radiogroup    : 1;
		bool sunken        : 1;
		bool cbgroup       : 1;
		bool highlighthk   : 1;
		bool explode       : 1;
		bool left_justify  : 1;
		bool right_justify : 1;
	} flags;

        // Everything box and later is not part of defaults.
	struct {
		int x1, y1, x2, y2;
	} box;

	char                    *icon;
	char                    *label;
	char                    *command;
	int                      bflags;
	uint8_t                  hotkey;
	struct rip_button_style *next;
};

#define BUTTON_FLAG1_CLIPBOARD (1 << 0)
#define BUTTON_FLAG1_INVERTABLE (1 << 1)
#define BUTTON_FLAG1_RESETAFTER (1 << 2)
#define BUTTON_FLAG1_CHISEL (1 << 3)
#define BUTTON_FLAG1_RECESSED (1 << 4)
#define BUTTON_FLAG1_DROPSHADOW (1 << 5)
#define BUTTON_FLAG1_AUTOSTAMP (1 << 6)
#define BUTTON_FLAG1_ICON (1 << 7)
#define BUTTON_FLAG1_PLAIN (1 << 8)
#define BUTTON_FLAG1_BEVEL (1 << 9)
#define BUTTON_FLAG1_MOUSE (1 << 10)
#define BUTTON_FLAG1_UNDERLINEHK (1 << 11)
#define BUTTON_FLAG1_HOT (1 << 12)
#define BUTTON_FLAG1_VADJUST (1 << 13)
#define BUTTON_FLAG1_RADIOGROUP (1 << 14)
#define BUTTON_FLAG1_SUNKEN (1 << 15)

#define BUTTON_FLAG2_CBGROUP (1 << 0)
#define BUTTON_FLAG2_HIGHLIGHTHK (1 << 1)
#define BUTTON_FLAG2_EXPLODE (1 << 2)
#define BUTTON_FLAG2_LEFT_JUSTIFY (1 << 3)
#define BUTTON_FLAG2_RIGHT_JUSTIFY (1 << 4)

struct hot_mouse {
	struct {
		int x1, y1, x2, y2;
	} box;

	bool  invertable;
	bool  resetafter;
	char *command;
};

enum mouse_field_type {
	MOUSE_FIELD_BUTTON,
	MOUSE_FIELD_HOT
};

struct mouse_field {
	struct mouse_field   *next;
	enum mouse_field_type type;

	union {
		struct rip_button_style *button;
		struct hot_mouse        *hot;
	} data;
};

struct popup_option {
	char *resp;
	char *text;
	int   width;
	char  hk;
};

static struct {
	enum rip_state          state;
	enum rip_state          newstate;
	bool                    enabled;
	int                     version;
	int                     x;
	int                     y;

	struct {
		int sx;
		int sy;
		int ex;
		int ey;
	} viewport;

	int                     color;

	struct {
		int  num;
		bool vertical;
		int  size;
	} font;

	bool                    xor;
	int                     fill_color;
	uint8_t                 fill_pattern[8];
	struct rip_button_style bstyle;
	uint16_t                line_pattern;
	int                     line_width;
	struct mouse_field     *mfields;
	char                   *graphics_click;
	char                   *text_click;
	char                   *templates[36];
	struct ciolib_pixels   *clipboard;
	int                     lchars;
	int                     curstype;
	int                     x_dim;
	int                     y_dim;
	int                     x_max;
	int                     y_max;
	bool                    borders;
	int                    *xmap;
	int                    *ymap;
	int                    *xunmap;
	int                    *yunmap;
	bool                    text_disabled;
	enum ansi_state         ansi_state;
	int                     clipx;
	int                     clipy;
	struct mouse_field     *saved_mfields;

	struct {
		int sx, sy, ex, ey, xpos, ypos;
	} text_region;

	struct bbslist         *bbs;
	void *default_font;
	int   default_font_width;
	int   default_font_height;
} rip = {
	RIP_STATE_BOL,
	RIP_STATE_FLUSHING,
	true,
	3,
	0,
	0,
	{0, 0, 639, 349},
	15,
	{0, 0, 1},
	false,
	15,
	"\xff\xff\xff\xff\xff\xff\xff\xff",
	{0},
	0xFFFF,
	1,
	NULL,
	NULL,
	NULL,
	{NULL},
	NULL,
	0,
	_NORMALCURSOR,
	640,
	350,
	640,
	350,
	true,
	NULL, NULL,
	NULL, NULL,
	false,
	ANSI_STATE_NONE,
	0, 0,
	NULL,
	{0, 0, 0, 0, 0, 0},
	NULL,
	NULL,
	8,
	8,
};

static const uint16_t      rip_line_patterns[4] = {
	0xffff, 0x3333, 0x1E3F, 0x1F1F
};

static const uint8_t       rip_fill_patterns[12][8] = {
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // Background fill
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, // Forground fill
	{0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00}, // Line fill
	{0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80}, // Light slash fill
	{0xe0, 0xc1, 0x83, 0x07, 0x0e, 0x1c, 0x38, 0x70}, // Normal Slash fill
	{0xf0, 0x78, 0x3c, 0x1e, 0x0f, 0x87, 0xc3, 0xe1}  // Normal Backslash fill
	,                                                 // {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01},  // Light
                                                          // Backslash fill (as expected)
	{0xa5, 0xd2, 0x69, 0xb4, 0x5a, 0x2d, 0x96, 0x4b}, // Light Backshash fill (as documented)
	{0xff, 0x88, 0x88, 0x88, 0xff, 0x88, 0x88, 0x88}, // Light Hatch fill
	{0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81}, // Heavy Cross Hatch fill
	{0xcc, 0x33, 0xcc, 0x33, 0xcc, 0x33, 0xcc, 0x33}, // Interleaving Line fill
	{0x80, 0x00, 0x08, 0x00, 0x80, 0x00, 0x08, 0x00}, // Widely Spaced Dot fill
	{0x88, 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00}  // Closely Spaced Dot fill
	,
};

static const uint16_t      ega_palette[64][3] = {
	{0, 0, 0},
	{0, 0, 0xaaaa},
	{0, 0xaaaa, 0},
	{0, 0xaaaa, 0xaaaa},
	{0xaaaa, 0, 0},
	{0xaaaa, 0, 0xaaaa},
	{0xaaaa, 0xaaaa, 0},
	{0xaaaa, 0xaaaa, 0xaaaa},
	{0, 0, 0x5555},
	{0, 0, 0xffff},
	{0, 0xaaaa, 0x5555},            // 10
	{0, 0xaaaa, 0xffff},
	{0xaaaa, 0, 0x5555},
	{0xaaaa, 0, 0xffff},
	{0xaaaa, 0xaaaa, 0x5555},
	{0xaaaa, 0xaaaa, 0xffff},
	{0, 0x5555, 0},
	{0, 0x5555, 0xaaaa},
	{0, 0xffff, 0},
	{0, 0xffff, 0xaaaa},
	{0xaaaa, 0x5555, 0},            // 20
	{0xaaaa, 0x5555, 0xaaaa},
	{0xaaaa, 0xffff, 0},
	{0xaaaa, 0xffff, 0xaaaa},
	{0, 0x5555, 0x5555},
	{0, 0x5555, 0xffff},
	{0, 0xffff, 0x5555},
	{0, 0xffff, 0xffff},
	{0xaaaa, 0x5555, 0x5555},
	{0xaaaa, 0x5555, 0xffff},
	{0xaaaa, 0xffff, 0x5555},       // 30
	{0xaaaa, 0xffff, 0xffff},
	{0x5555, 0, 0},
	{0x5555, 0, 0xaaaa},
	{0x5555, 0xaaaa, 0},
	{0x5555, 0xaaaa, 0xaaaa},
	{0xffff, 0, 0},
	{0xffff, 0, 0xaaaa},
	{0xffff, 0xaaaa, 0},
	{0xffff, 0xaaaa, 0xaaaa},
	{0x5555, 0, 0x5555},            // 40
	{0x5555, 0, 0xffff},
	{0x5555, 0xaaaa, 0x5555},
	{0x5555, 0xaaaa, 0xffff},
	{0xffff, 0, 0x5555},
	{0xffff, 0, 0xffff},
	{0xffff, 0xaaaa, 0x5555},
	{0xffff, 0xaaaa, 0xffff},
	{0x5555, 0x5555, 0},
	{0x5555, 0x5555, 0xaaaa},
	{0x5555, 0xffff, 0},            // 50
	{0x5555, 0xffff, 0xaaaa},
	{0xffff, 0x5555, 0},
	{0xffff, 0x5555, 0xaaaa},
	{0xffff, 0xffff, 0},
	{0xffff, 0xffff, 0xaaaa},
	{0x5555, 0x5555, 0x5555},
	{0x5555, 0x5555, 0xffff},
	{0x5555, 0xffff, 0x5555},
	{0x5555, 0xffff, 0xffff},
	{0xffff, 0x5555, 0x5555},       // 60
	{0xffff, 0x5555, 0xffff},
	{0xffff, 0xffff, 0x5555},
	{0xffff, 0xffff, 0xffff}
};

static const uint8_t       default_mapped[256][3] = {
	{0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42},
	{42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63},
	{63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {0, 0, 0}, {4, 4, 4},
	{8, 8, 8}, {13, 13, 13}, {17, 17, 17}, {21, 21, 21}, {25, 25, 25}, {29, 29, 29},
	{34, 34, 34}, {38, 38, 38}, {42, 42, 42}, {46, 46, 46}, {50, 50, 50}, {55, 55, 55},
	{59, 59, 59}, {63, 63, 63}, {0, 0, 0}, {0, 0, 21}, {0, 0, 42}, {0, 0, 63},
	{0, 9, 0}, {0, 9, 21}, {0, 9, 42}, {0, 9, 63}, {0, 18, 0}, {0, 18, 21},
	{0, 18, 42}, {0, 18, 63}, {0, 27, 0}, {0, 27, 21}, {0, 27, 42}, {0, 27, 63},
	{0, 36, 0}, {0, 36, 21}, {0, 36, 42}, {0, 36, 63}, {0, 45, 0}, {0, 45, 21},
	{0, 45, 42}, {0, 45, 63}, {0, 54, 0}, {0, 54, 21}, {0, 54, 42}, {0, 54, 63},
	{0, 63, 0}, {0, 63, 21}, {0, 63, 42}, {0, 63, 63}, {10, 0, 0}, {10, 0, 21},
	{10, 0, 42}, {10, 0, 63}, {10, 9, 0}, {10, 9, 21}, {10, 9, 42}, {10, 9, 63},
	{10, 18, 0}, {10, 18, 21}, {10, 18, 42}, {10, 18, 63}, {10, 27, 0}, {10, 27, 21},
	{10, 27, 42}, {10, 27, 63}, {10, 36, 0}, {10, 36, 21}, {10, 36, 42}, {10, 36, 63},
	{10, 45, 0}, {10, 45, 21}, {10, 45, 42}, {10, 45, 63}, {10, 54, 0}, {10, 54, 21},
	{10, 54, 42}, {10, 54, 63}, {10, 63, 0}, {10, 63, 21}, {10, 63, 42}, {10, 63, 63},
	{21, 0, 0}, {21, 0, 21}, {21, 0, 42}, {21, 0, 63}, {21, 9, 0}, {21, 9, 21},
	{21, 9, 42}, {21, 9, 63}, {21, 18, 0}, {21, 18, 21}, {21, 18, 42}, {21, 18, 63},
	{21, 27, 0}, {21, 27, 21}, {21, 27, 42}, {21, 27, 63}, {21, 36, 0}, {21, 36, 21},
	{21, 36, 42}, {21, 36, 63}, {21, 45, 0}, {21, 45, 21}, {21, 45, 42}, {21, 45, 63},
	{21, 54, 0}, {21, 54, 21}, {21, 54, 42}, {21, 54, 63}, {21, 63, 0}, {21, 63, 21},
	{21, 63, 42}, {21, 63, 63}, {31, 0, 0}, {31, 0, 21}, {31, 0, 42}, {31, 0, 63},
	{31, 9, 0}, {31, 9, 21}, {31, 9, 42}, {31, 9, 63}, {31, 18, 0}, {31, 18, 21},
	{31, 18, 42}, {31, 18, 63}, {31, 27, 0}, {31, 27, 21}, {31, 27, 42}, {31, 27, 63},
	{31, 36, 0}, {31, 36, 21}, {31, 36, 42}, {31, 36, 63}, {31, 45, 0}, {31, 45, 21},
	{31, 45, 42}, {31, 45, 63}, {31, 54, 0}, {31, 54, 21}, {31, 54, 42}, {31, 54, 63},
	{31, 63, 0}, {31, 63, 21}, {31, 63, 42}, {31, 63, 63}, {42, 0, 0}, {42, 0, 21},
	{42, 0, 42}, {42, 0, 63}, {42, 9, 0}, {42, 9, 21}, {42, 9, 42}, {42, 9, 63},
	{42, 18, 0}, {42, 18, 21}, {42, 18, 42}, {42, 18, 63}, {42, 27, 0}, {42, 27, 21},
	{42, 27, 42}, {42, 27, 63}, {42, 36, 0}, {42, 36, 21}, {42, 36, 42}, {42, 36, 63},
	{42, 45, 0}, {42, 45, 21}, {42, 45, 42}, {42, 45, 63}, {42, 54, 0}, {42, 54, 21},
	{42, 54, 42}, {42, 54, 63}, {42, 63, 0}, {42, 63, 21}, {42, 63, 42}, {42, 63, 63},
	{52, 0, 0}, {52, 0, 21}, {52, 0, 42}, {52, 0, 63}, {52, 9, 0}, {52, 9, 21},
	{52, 9, 42}, {52, 9, 63}, {52, 18, 0}, {52, 18, 21}, {52, 18, 42}, {52, 18, 63},
	{52, 27, 0}, {52, 27, 21}, {52, 27, 42}, {52, 27, 63}, {52, 36, 0}, {52, 36, 21},
	{52, 36, 42}, {52, 36, 63}, {52, 45, 0}, {52, 45, 21}, {52, 45, 42}, {52, 45, 63},
	{52, 54, 0}, {52, 54, 21}, {52, 54, 42}, {52, 54, 63}, {52, 63, 0}, {52, 63, 21},
	{52, 63, 42}, {52, 63, 63}, {63, 0, 0}, {63, 0, 21}, {63, 0, 42}, {63, 0, 63},
	{63, 9, 0}, {63, 9, 21}, {63, 9, 42}, {63, 9, 63}, {63, 18, 0}, {63, 18, 21},
	{63, 18, 42}, {63, 18, 63}, {63, 27, 0}, {63, 27, 21}, {63, 27, 42}, {63, 27, 63},
	{63, 36, 0}, {63, 36, 21}, {63, 36, 42}, {63, 36, 63}, {63, 45, 0}, {63, 45, 21},
	{63, 45, 42}, {63, 45, 63}, {63, 54, 0}, {63, 54, 21}, {63, 54, 42}, {63, 54, 63},
	{63, 63, 0}, {63, 63, 21}, {63, 63, 42}, {63, 63, 63}
};

static uint8_t             curr_ega_palette[16] = {
	0, 1, 2, 3, 4, 5, 20, 7, 56, 57, 58, 59, 60, 61, 62, 63
};

static const uint8_t       default_ega_palette[16] = {
	0, 1, 2, 3, 4, 5, 20, 7, 56, 57, 58, 59, 60, 61, 62, 63
};

static uint32_t            ega_colours[16] = {
	0x10, 0x14, 0x12, 0x16, 0x11, 0x15, 0x13, 0x17,
	0x18, 0x1c, 0x1a, 0x1e, 0x19, 0x1d, 0x1b, 0x1f
};

static unsigned char       ripfnt7x8[2048] = /* binary data included from 7x8 */
{
	0, 0, 0, 0, 0, 0, 0, 0, 124, 130, 170, 130, 186, 146, 130, 124, 124, 254, 214, 254, 198, 238, 254, 124, 68, 238,
	254,
	254, 124, 56, 16, 0, 16, 56, 124, 254, 124, 56, 16, 0, 56, 56, 146, 254, 214, 16, 56, 0, 16, 56, 124,
	254, 124, 16, 56, 0, 0, 0, 48, 120, 120, 48, 0, 0, 254, 254, 238, 198, 198, 238, 254, 254, 0, 56, 68,
	68, 68, 56, 0, 0, 254, 198, 186, 186, 186, 198, 254, 254, 14, 6, 26, 120, 204, 204, 204, 120, 120,
	204, 204, 204, 120, 48, 252, 48, 124, 100, 124, 96, 96, 224, 192, 0, 62, 102, 126, 102, 102, 108,
	236, 192, 214, 214, 56, 238, 238, 56, 214, 214, 128, 224, 240, 252, 240, 224, 128, 0, 4, 28, 60, 252,
	60, 28, 4, 0, 32, 112, 248, 32, 32, 248, 112, 32, 108, 108, 108, 108, 108, 0, 108, 0, 126, 214, 214,
	118, 22, 22, 22, 0, 60, 102, 56, 108, 108, 56, 204, 120, 0, 0, 0, 0, 124, 124, 124, 0, 16, 56, 124, 16,
	124, 56, 16, 254, 48, 120, 252, 48, 48, 48, 48, 0, 48, 48, 48, 48, 252, 120, 48, 0, 0, 48, 24, 252, 24,
	48, 0, 0, 0, 48, 96, 252, 96, 48, 0, 0, 0, 0, 192, 192, 252, 0, 0, 0, 0, 40, 108, 254, 108, 40, 0, 0, 0, 0,
	48, 120, 252, 252, 0, 0, 0, 0, 252, 252, 120, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 120, 120, 120, 48, 0,
	48, 0, 108, 108, 108, 0, 0, 0, 0, 0, 72, 72, 252, 72, 252, 72, 72, 0, 48, 124, 192, 120, 12, 248, 48, 0,
	192, 204, 24, 48, 96, 204, 12, 0, 56, 108, 56, 112, 220, 200, 116, 0, 48, 48, 96, 0, 0, 0, 0, 0, 24, 48,
	96, 96, 96, 48, 24, 0, 48, 24, 12, 12, 12, 24, 48, 0, 0, 72, 48, 252, 48, 72, 0, 0, 0, 48, 48, 252, 48,
	48, 0, 0, 0, 0, 0, 0, 0, 24, 24, 48, 0, 0, 0, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 0, 4, 12, 24, 48, 96,
	192, 128, 0, 120, 204, 204, 204, 204, 204, 120, 0, 48, 112, 48, 48, 48, 48, 252, 0, 120, 204, 12, 24,
	48, 96, 252, 0, 120, 204, 12, 56, 12, 204, 120, 0, 28, 60, 108, 204, 254, 12, 12, 0, 252, 192, 248,
	12, 12, 204, 120, 0, 56, 96, 192, 248, 204, 204, 120, 0, 252, 196, 12, 24, 48, 48, 48, 0, 120, 204,
	204, 120, 204, 204, 120, 0, 120, 204, 204, 124, 12, 24, 112, 0, 0, 48, 48, 0, 0, 48, 48, 0, 0, 48, 48, 0,
	0, 48, 48, 96, 24, 48, 96, 192, 96, 48, 24, 0, 0, 0, 252, 0, 0, 252, 0, 0, 96, 48, 24, 12, 24, 48, 96, 0,
	120, 204, 12, 24, 48, 0, 48, 0, 120, 196, 220, 220, 220, 192, 120, 0, 48, 120, 204, 204, 252, 204,
	204, 0, 248, 204, 204, 248, 204, 204, 248, 0, 120, 204, 192, 192, 192, 204, 120, 0, 240, 216, 204,
	204, 204, 216, 240, 0, 252, 192, 192, 248, 192, 192, 252, 0, 252, 192, 192, 248, 192, 192, 192, 0,
	120, 204, 192, 220, 204, 204, 124, 0, 204, 204, 204, 252, 204, 204, 204, 0, 120, 48, 48, 48, 48, 48,
	120, 0, 60, 24, 24, 24, 216, 216, 112, 0, 204, 216, 240, 240, 216, 204, 204, 0, 192, 192, 192, 192,
	192, 192, 252, 0, 132, 204, 252, 252, 204, 204, 204, 0, 204, 204, 236, 252, 220, 204, 204, 0, 120,
	204, 204, 204, 204, 204, 120, 0, 248, 204, 204, 248, 192, 192, 192, 0, 120, 204, 204, 204, 204, 220,
	120, 12, 248, 204, 204, 248, 204, 204, 204, 0, 120, 204, 96, 48, 24, 204, 120, 0, 252, 48, 48, 48, 48,
	48, 48, 0, 204, 204, 204, 204, 204, 204, 120, 0, 204, 204, 204, 204, 204, 120, 48, 0, 204, 204, 204,
	252, 252, 204, 132, 0, 204, 204, 120, 48, 120, 204, 204, 0, 204, 204, 204, 120, 48, 48, 48, 0, 252,
	12, 24, 48, 96, 192, 252, 0, 60, 48, 48, 48, 48, 48, 60, 0, 128, 192, 96, 48, 24, 12, 4, 0, 60, 12, 12,
	12, 12, 12, 60, 0, 0, 48, 120, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 48, 48, 24, 0, 0, 0, 0, 0, 0, 0,
	120, 12, 124, 140, 124, 0, 192, 192, 248, 204, 204, 204, 184, 0, 0, 0, 120, 204, 192, 204, 120, 0, 12,
	12, 124, 204, 204, 220, 116, 0, 0, 0, 120, 204, 252, 192, 124, 0, 60, 96, 248, 96, 96, 96, 96, 0, 0, 0,
	124, 204, 204, 124, 12, 120, 192, 192, 248, 204, 204, 204, 204, 0, 48, 0, 112, 48, 48, 48, 120, 0, 24,
	0, 56, 24, 24, 24, 24, 240, 192, 192, 204, 216, 240, 216, 204, 0, 112, 48, 48, 48, 48, 48, 120, 0, 0,
	0, 200, 252, 212, 212, 212, 0, 0, 0, 184, 204, 204, 204, 204, 0, 0, 0, 120, 204, 204, 204, 120, 0, 0,
	0, 248, 204, 204, 236, 216, 192, 0, 0, 124, 204, 204, 220, 108, 12, 0, 0, 108, 112, 96, 96, 96, 0, 0,
	0, 120, 192, 120, 12, 248, 0, 96, 96, 248, 96, 96, 96, 56, 0, 0, 0, 204, 204, 204, 204, 116, 0, 0, 0,
	204, 204, 204, 120, 48, 0, 0, 0, 132, 132, 180, 252, 72, 0, 0, 0, 204, 120, 48, 120, 204, 0, 0, 0, 204,
	204, 220, 108, 12, 120, 0, 0, 252, 24, 48, 96, 252, 0, 28, 48, 48, 224, 48, 48, 28, 0, 48, 48, 48, 0, 48,
	48, 48, 0, 96, 48, 48, 28, 48, 48, 96, 0, 0, 116, 216, 0, 0, 0, 0, 0, 48, 120, 204, 204, 204, 204, 252,
	0, 120, 204, 192, 204, 120, 24, 12, 120, 0, 216, 0, 216, 216, 216, 124, 0, 28, 0, 120, 204, 252,
	192, 120, 0, 124, 130, 56, 12, 60, 76, 58, 0, 204, 0, 112, 24, 120, 152, 108, 0, 224, 0, 112, 24, 120,
	152, 116, 0, 48, 48, 112, 24, 120, 216, 116, 0, 0, 0, 120, 204, 192, 112, 24, 112, 124, 130, 56, 108,
	124, 96, 56, 0, 216, 0, 112, 216, 248, 192, 112, 0, 112, 0, 56, 100, 124, 96, 56, 0, 204, 0, 112, 48,
	48, 48, 120, 0, 120, 132, 112, 48, 48, 48, 120, 0, 224, 0, 112, 48, 48, 48, 120, 0, 204, 48, 120, 204,
	252, 204, 204, 0, 48, 48, 0, 120, 204, 252, 204, 0, 28, 0, 252, 96, 120, 96, 252, 0, 0, 0, 126, 12, 126,
	204, 126, 0, 60, 120, 216, 252, 216, 216, 220, 0, 120, 132, 0, 120, 204, 204, 120, 0, 0, 204, 0, 120,
	204, 204, 120, 0, 0, 224, 0, 120, 204, 204, 120, 0, 120, 132, 0, 216, 216, 216, 108, 0, 0, 224, 0, 216,
	216, 216, 108, 0, 0, 204, 0, 204, 204, 124, 12, 248, 204, 48, 120, 204, 204, 120, 48, 0, 204, 0, 204,
	204, 204, 204, 120, 0, 24, 24, 124, 192, 192, 124, 24, 24, 56, 108, 100, 240, 96, 236, 248, 0, 204,
	204, 120, 252, 48, 252, 48, 48, 240, 216, 216, 244, 206, 220, 204, 198, 28, 54, 48, 120, 48, 176,
	240, 96, 56, 0, 112, 24, 120, 216, 116, 0, 56, 0, 112, 48, 48, 48, 120, 0, 0, 28, 0, 120, 204, 204, 120,
	0, 0, 56, 0, 216, 216, 216, 116, 0, 0, 248, 0, 184, 204, 204, 204, 0, 252, 0, 204, 236, 252, 220,
	204, 0, 120, 216, 216, 124, 0, 252, 0, 0, 56, 108, 108, 56, 0, 124, 0, 0, 48, 0, 48, 96, 192, 204, 120,
	0, 0, 0, 0, 252, 192, 192, 0, 0, 0, 0, 0, 252, 12, 12, 0, 0, 140, 152, 176, 108, 214, 132, 8, 30, 198,
	204, 216, 54, 110, 218, 158, 6, 48, 0, 48, 48, 120, 120, 48, 0, 0, 54, 108, 216, 108, 54, 0, 0, 0, 216,
	108, 54, 108, 216, 0, 0, 34, 136, 34, 136, 34, 136, 34, 136, 84, 168, 84, 168, 84, 168, 84, 168, 218,
	182, 218, 108, 218, 182, 218, 108, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 48, 48, 48, 48,
	48, 240, 48, 240, 48, 48, 48, 108, 108, 108, 108, 236, 108, 108, 108, 0, 0, 0, 0, 252, 108, 108, 108,
	0, 0, 240, 48, 240, 48, 48, 48, 108, 108, 236, 12, 236, 108, 108, 108, 108, 108, 108, 108, 108,
	108, 108, 108, 0, 0, 252, 12, 236, 108, 108, 108, 108, 108, 236, 12, 252, 0, 0, 0, 108, 108, 108, 108,
	252, 0, 0, 0, 48, 48, 240, 48, 240, 0, 0, 0, 0, 0, 0, 0, 240, 48, 48, 48, 48, 48, 48, 48, 62, 0, 0, 0, 48,
	48, 48, 48, 254, 0, 0, 0, 0, 0, 0, 0, 254, 48, 48, 48, 48, 48, 48, 48, 62, 48, 48, 48, 0, 0, 0, 0, 254, 0,
	0, 0, 48, 48, 48, 48, 254, 48, 48, 48, 48, 48, 62, 48, 62, 48, 48, 48, 108, 108, 108, 108, 110, 108,
	108, 108, 108, 108, 110, 96, 126, 0, 0, 0, 0, 0, 126, 96, 110, 108, 108, 108, 108, 108, 238, 0, 254, 0,
	0, 0, 0, 0, 254, 0, 238, 108, 108, 108, 108, 108, 110, 96, 110, 108, 108, 108, 0, 0, 254, 0, 254, 0,
	0, 0, 108, 108, 238, 0, 238, 108, 108, 108, 48, 48, 254, 0, 254, 0, 0, 0, 108, 108, 108, 108, 254, 0,
	0, 0, 0, 0, 254, 0, 254, 48, 48, 48, 0, 0, 0, 0, 254, 108, 108, 108, 108, 108, 108, 108, 126, 0, 0, 0,
	48, 48, 62, 48, 62, 0, 0, 0, 0, 0, 62, 48, 62, 48, 48, 48, 0, 0, 0, 0, 126, 108, 108, 108, 108, 108, 108,
	108, 254, 108, 108, 108, 48, 48, 254, 48, 254, 48, 48, 48, 48, 48, 48, 48, 240, 0, 0, 0, 0, 0, 0, 0, 62,
	48, 48, 48, 254, 254, 254, 254, 254, 254, 254, 254, 0, 0, 0, 0, 254, 254, 254, 254, 224, 224, 224,
	224, 224, 224, 224, 224, 14, 14, 14, 14, 14, 14, 14, 14, 254, 254, 254, 254, 0, 0, 0, 0, 0, 0, 108, 216,
	208, 216, 108, 0, 0, 120, 204, 248, 204, 248, 192, 192, 0, 252, 204, 192, 192, 192, 192, 0, 0, 254,
	108, 108, 108, 108, 108, 0, 252, 204, 96, 48, 96, 204, 252, 0, 0, 0, 124, 216, 216, 216, 112, 0, 0,
	108, 108, 108, 108, 120, 96, 192, 0, 108, 184, 48, 48, 48, 48, 0, 252, 48, 120, 204, 204, 120, 48,
	252, 48, 120, 204, 252, 204, 120, 48, 0, 56, 108, 198, 198, 108, 108, 238, 0, 28, 48, 24, 124, 204,
	204, 120, 0, 0, 0, 124, 214, 214, 124, 0, 0, 4, 8, 124, 214, 214, 124, 32, 64, 28, 48, 96, 124, 96, 48,
	28, 0, 56, 108, 108, 108, 108, 108, 108, 0, 0, 252, 0, 252, 0, 252, 0, 0, 48, 48, 252, 48, 48, 0, 252,
	0, 96, 48, 24, 48, 96, 0, 252, 0, 24, 48, 96, 48, 24, 0, 252, 0, 12, 30, 18, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 144, 240, 96, 48, 48, 0, 252, 0, 48, 48, 0, 0, 108, 216, 0, 108, 216, 0, 0, 56, 108, 108,
	56, 0, 0, 0, 0, 0, 0, 0, 48, 48, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 14, 12, 12, 12, 236, 108, 60, 28, 120,
	108, 108, 108, 108, 0, 0, 0, 112, 24, 48, 96, 120, 0, 0, 0, 0, 0, 56, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0
};
unsigned char              ripfnt7x14[3584] = /* binary data included from 7x14 */
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 195, 129, 129, 165, 165, 129, 129, 189, 189, 153, 129, 195, 126,
	126, 255, 255, 255,
	219, 219, 255, 255, 195, 195, 231, 255, 255, 126, 0, 68, 238, 238, 254, 254, 254, 124, 124, 56, 56,
	16, 0, 0, 16, 56, 56, 124, 124, 254, 254, 124, 124, 56, 56, 16, 0, 0, 0, 60, 126, 24, 90, 219, 255,
	219, 90, 24, 60, 60, 0, 0, 0, 24, 60, 60, 126, 126, 255, 255, 126, 24, 60, 60, 0, 0, 0, 0, 0, 0, 60, 126,
	126, 126, 126, 60, 0, 0, 0, 0, 255, 255, 255, 255, 195, 129, 129, 129, 129, 195, 255, 255, 255, 255,
	0, 0, 0, 60, 102, 66, 66, 66, 102, 60, 0, 0, 0, 0, 255, 255, 255, 195, 153, 189, 189, 189, 153, 195,
	255, 255, 255, 255, 0, 127, 7, 15, 29, 121, 253, 204, 204, 204, 252, 120, 0, 0, 0, 60, 126, 102, 102,
	126, 60, 24, 126, 126, 24, 24, 0, 0, 0, 62, 50, 62, 48, 48, 48, 48, 48, 112, 240, 96, 0, 0, 0, 63, 127,
	99, 99, 127, 127, 99, 99, 103, 239, 230, 192, 0, 219, 219, 219, 60, 60, 231, 231, 231, 231, 60, 60,
	219, 219, 219, 0, 192, 224, 240, 248, 252, 254, 252, 248, 240, 224, 192, 0, 0, 0, 6, 14, 30, 62, 126,
	254, 126, 62, 30, 14, 6, 0, 0, 0, 24, 60, 126, 126, 24, 24, 24, 126, 126, 60, 24, 0, 0, 0, 108, 108, 108,
	108, 108, 108, 108, 0, 0, 108, 108, 0, 0, 0, 127, 255, 219, 219, 251, 123, 27, 27, 27, 27, 27, 0, 0, 0,
	28, 62, 99, 99, 56, 108, 68, 108, 56, 140, 204, 120, 0, 0, 0, 0, 0, 0, 0, 126, 126, 126, 126, 126, 126,
	0, 0, 0, 24, 60, 126, 126, 24, 24, 126, 126, 60, 24, 0, 255, 255, 0, 24, 60, 126, 255, 24, 24, 24, 24,
	24, 24, 24, 0, 0, 0, 24, 24, 24, 24, 24, 24, 24, 255, 126, 60, 24, 0, 0, 0, 0, 0, 48, 24, 12, 254, 254,
	12, 24, 48, 0, 0, 0, 0, 0, 0, 24, 48, 96, 254, 254, 96, 48, 24, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 192,
	254, 254, 0, 0, 0, 0, 0, 0, 0, 36, 102, 66, 255, 255, 66, 102, 36, 0, 0, 0, 0, 0, 16, 16, 56, 56, 124, 124,
	254, 254, 254, 0, 0, 0, 0, 0, 0, 254, 254, 254, 124, 124, 56, 56, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 24, 60, 60, 60, 60, 24, 24, 0, 24, 60, 24, 0, 0, 0, 102, 102, 102, 102, 102, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 108, 108, 108, 254, 254, 108, 254, 254, 108, 108, 108, 0, 0, 0, 48, 48, 120, 204, 192,
	120, 12, 204, 120, 48, 48, 0, 0, 0, 198, 204, 12, 24, 24, 48, 48, 96, 96, 198, 134, 0, 0, 0, 56, 108,
	108, 56, 112, 122, 222, 204, 204, 254, 114, 0, 0, 0, 56, 56, 24, 16, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 24,
	56, 48, 112, 112, 112, 48, 56, 24, 12, 0, 0, 0, 96, 48, 56, 24, 28, 28, 28, 24, 56, 48, 96, 0, 0, 0, 0, 0,
	198, 108, 56, 254, 254, 56, 108, 198, 0, 0, 0, 0, 0, 0, 24, 24, 24, 126, 126, 24, 24, 24, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 56, 56, 24, 24, 48, 32, 0, 0, 0, 0, 0, 0, 0, 126, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	16, 56, 16, 0, 0, 0, 6, 14, 12, 28, 24, 56, 48, 112, 96, 224, 192, 0, 0, 0, 124, 254, 198, 198, 214,
	214, 214, 198, 198, 254, 124, 0, 0, 0, 48, 112, 240, 240, 48, 48, 48, 48, 48, 252, 252, 0, 0, 0, 56,
	124, 238, 198, 14, 28, 56, 112, 230, 254, 254, 0, 0, 0, 124, 254, 198, 6, 14, 60, 14, 6, 198, 254, 124,
	0, 0, 0, 6, 14, 30, 54, 102, 198, 254, 254, 6, 6, 6, 0, 0, 0, 254, 254, 192, 192, 252, 254, 6, 6, 198,
	254, 124, 0, 0, 0, 28, 60, 112, 224, 252, 254, 198, 198, 198, 254, 124, 0, 0, 0, 254, 254, 198, 198,
	12, 12, 24, 24, 48, 48, 48, 0, 0, 0, 124, 254, 198, 198, 198, 124, 198, 198, 198, 254, 124, 0, 0, 0,
	124, 254, 198, 198, 198, 254, 126, 14, 28, 120, 112, 0, 0, 0, 0, 0, 16, 56, 16, 0, 0, 16, 56, 16, 0, 0, 0,
	0, 0, 0, 16, 56, 16, 0, 0, 56, 56, 24, 48, 96, 0, 0, 0, 14, 28, 56, 112, 224, 112, 56, 28, 14, 0, 0, 0, 0,
	0, 0, 126, 126, 0, 0, 0, 126, 126, 0, 0, 0, 0, 0, 0, 224, 112, 56, 28, 14, 28, 56, 112, 224, 0, 0, 0, 0,
	60, 126, 102, 102, 14, 28, 24, 24, 0, 24, 24, 0, 0, 0, 124, 254, 198, 198, 222, 222, 222, 192, 192,
	254, 126, 0, 0, 0, 16, 56, 124, 238, 198, 198, 254, 254, 198, 198, 198, 0, 0, 0, 252, 254, 198, 198,
	198, 252, 198, 198, 198, 254, 252, 0, 0, 0, 124, 254, 198, 198, 192, 192, 192, 198, 198, 254, 124, 0,
	0, 0, 248, 252, 206, 198, 198, 198, 198, 198, 206, 252, 248, 0, 0, 0, 254, 254, 192, 192, 192, 252,
	192, 192, 192, 254, 254, 0, 0, 0, 254, 254, 192, 192, 252, 252, 192, 192, 192, 192, 192, 0, 0, 0, 124,
	254, 198, 192, 192, 206, 206, 198, 198, 254, 126, 0, 0, 0, 198, 198, 198, 198, 254, 254, 198, 198,
	198, 198, 198, 0, 0, 0, 120, 120, 48, 48, 48, 48, 48, 48, 48, 120, 120, 0, 0, 0, 30, 30, 12, 12, 12, 12,
	12, 204, 204, 252, 120, 0, 0, 0, 194, 198, 206, 220, 248, 240, 248, 220, 206, 198, 194, 0, 0, 0, 192,
	192, 192, 192, 192, 192, 192, 192, 192, 254, 254, 0, 0, 0, 130, 198, 238, 254, 254, 214, 214, 198,
	198, 198, 198, 0, 0, 0, 198, 230, 230, 246, 246, 222, 222, 206, 206, 198, 198, 0, 0, 0, 124, 254, 198,
	198, 198, 198, 198, 198, 198, 254, 124, 0, 0, 0, 252, 254, 198, 198, 198, 254, 252, 192, 192, 192,
	192, 0, 0, 0, 124, 254, 198, 198, 198, 198, 198, 214, 206, 254, 124, 6, 0, 0, 252, 254, 198, 198, 198,
	252, 254, 198, 198, 198, 198, 0, 0, 0, 124, 254, 198, 192, 240, 124, 30, 6, 198, 254, 124, 0, 0, 0,
	252, 252, 48, 48, 48, 48, 48, 48, 48, 48, 48, 0, 0, 0, 198, 198, 198, 198, 198, 198, 198, 198, 198,
	254, 124, 0, 0, 0, 198, 198, 198, 198, 198, 198, 198, 238, 124, 56, 16, 0, 0, 0, 198, 198, 198, 198,
	198, 214, 254, 254, 238, 198, 130, 0, 0, 0, 198, 198, 238, 108, 124, 56, 124, 108, 238, 198, 198, 0,
	0, 0, 195, 195, 195, 231, 126, 60, 24, 24, 24, 24, 24, 0, 0, 0, 254, 254, 6, 14, 28, 56, 112, 224,
	192, 254, 254, 0, 0, 0, 60, 60, 48, 48, 48, 48, 48, 48, 48, 60, 60, 0, 0, 0, 192, 224, 96, 112, 48, 56,
	24, 28, 12, 14, 6, 0, 0, 0, 60, 60, 12, 12, 12, 12, 12, 12, 12, 60, 60, 0, 0, 0, 0, 16, 56, 124, 238, 198,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 56, 56, 48, 16, 8, 0, 0, 0, 0, 0, 0, 0,
	0,
	0, 0, 0, 0, 124, 126, 6, 126, 254, 198, 254, 118, 0, 0, 0, 192, 192, 192, 252, 254, 198, 198, 198,
	198, 254, 220, 0, 0, 0, 0, 0, 0, 124, 254, 198, 192, 192, 198, 254, 124, 0, 0, 0, 6, 6, 6, 126, 254, 198,
	198, 198, 198, 254, 118, 0, 0, 0, 0, 0, 0, 124, 254, 198, 254, 254, 192, 254, 126, 0, 0, 0, 30, 62, 48,
	124, 124, 48, 48, 48, 48, 48, 48, 0, 0, 0, 0, 0, 0, 126, 254, 198, 198, 198, 206, 254, 118, 6, 124, 0,
	192, 192, 192, 220, 254, 230, 198, 198, 198, 198, 198, 0, 0, 0, 24, 24, 0, 56, 56, 24, 24, 24, 24, 60,
	60, 0, 0, 0, 24, 24, 0, 56, 56, 24, 24, 24, 24, 24, 248, 112, 0, 0, 192, 192, 204, 204, 216, 216, 240,
	240, 216, 204, 204, 0, 0, 0, 56, 56, 24, 24, 24, 24, 24, 24, 24, 60, 60, 0, 0, 0, 0, 0, 0, 196, 238, 254,
	254, 214, 198, 198, 198, 0, 0, 0, 0, 0, 0, 220, 254, 230, 198, 198, 198, 198, 198, 0, 0, 0, 0, 0, 0, 124,
	254, 198, 198, 198, 198, 254, 124, 0, 0, 0, 0, 0, 0, 220, 254, 230, 198, 198, 198, 254, 220, 192, 192,
	0, 0, 0, 0, 118, 254, 206, 198, 198, 198, 254, 118, 6, 6, 0, 0, 0, 0, 220, 254, 230, 192, 192, 192,
	192, 192, 0, 0, 0, 0, 0, 0, 124, 254, 192, 252, 126, 6, 254, 124, 0, 0, 0, 16, 48, 48, 124, 124, 48, 48,
	48, 48, 60, 28, 0, 0, 0, 0, 0, 0, 198, 198, 198, 198, 198, 198, 254, 118, 0, 0, 0, 0, 0, 0, 198, 198,
	198, 198, 238, 124, 56, 16, 0, 0, 0, 0, 0, 0, 198, 198, 198, 198, 214, 254, 254, 108, 0, 0, 0, 0, 0, 0,
	198, 238, 124, 56, 56, 124, 238, 198, 0, 0, 0, 0, 0, 0, 198, 198, 198, 198, 206, 206, 254, 118, 6, 124,
	0, 0, 0, 0, 252, 252, 28, 56, 112, 224, 252, 252, 0, 0, 0, 14, 28, 24, 24, 24, 112, 24, 24, 24, 28, 14,
	0, 0, 0, 24, 24, 24, 24, 24, 0, 24, 24, 24, 24, 24, 0, 0, 0, 112, 56, 24, 24, 24, 14, 24, 24, 24, 56,
	112, 0, 0, 0, 0, 118, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 56, 124, 238, 198, 198, 198, 198, 198, 254,
	254, 0, 0, 0, 0, 124, 254, 198, 192, 198, 254, 124, 28, 14, 126, 124, 0, 0, 204, 204, 0, 204, 204, 204,
	204, 204, 204, 254, 118, 0, 0, 0, 14, 28, 0, 124, 254, 198, 254, 254, 192, 254, 126, 0, 0, 0, 124, 198,
	0, 124, 126, 6, 126, 254, 198, 254, 118, 0, 0, 0, 102, 102, 0, 124, 126, 6, 126, 254, 198, 254, 118,
	0, 0, 0, 112, 56, 0, 124, 126, 6, 126, 254, 198, 254, 118, 0, 0, 0, 48, 48, 0, 124, 126, 6, 126, 254,
	198, 254, 118, 0, 0, 0, 0, 0, 0, 124, 254, 198, 198, 192, 192, 252, 126, 14, 60, 0, 124, 198, 0, 124,
	254, 198, 254, 254, 192, 254, 126, 0, 0, 0, 102, 102, 0, 124, 254, 198, 254, 254, 192, 254, 126, 0, 0,
	0, 112, 56, 0, 124, 254, 198, 254, 254, 192, 254, 126, 0, 0, 0, 204, 204, 0, 112, 112, 48, 48, 48,
	48, 120, 120, 0, 0, 0, 124, 198, 0, 56, 56, 24, 24, 24, 24, 60, 60, 0, 0, 0, 224, 112, 0, 112, 112, 48,
	48, 48, 48, 120, 120, 0, 0, 0, 198, 198, 0, 16, 56, 124, 238, 198, 254, 198, 198, 0, 0, 0, 48, 48, 0,
	16, 56, 124, 238, 198, 254, 198, 198, 0, 0, 0, 14, 28, 0, 254, 254, 96, 124, 124, 96, 254, 254, 0, 0,
	0, 0, 0, 0, 127, 127, 12, 127, 255, 204, 255, 111, 0, 0, 0, 62, 126, 236, 204, 204, 254, 204, 204,
	204, 206, 206, 0, 0, 0, 124, 198, 0, 124, 254, 198, 198, 198, 198, 254, 124, 0, 0, 0, 102, 102, 0, 124,
	254, 198, 198, 198, 198, 254, 124, 0, 0, 0, 112, 56, 0, 124, 254, 198, 198, 198, 198, 254, 124, 0, 0,
	0, 124, 198, 0, 198, 198, 198, 198, 198, 198, 254, 118, 0, 0, 0, 112, 56, 0, 198, 198, 198, 198,
	198, 198, 254, 118, 0, 0, 0, 198, 198, 0, 198, 198, 198, 198, 198, 206, 254, 118, 6, 124, 0, 198, 214,
	56, 124, 238, 198, 198, 238, 124, 56, 16, 0, 0, 0, 198, 198, 0, 198, 198, 198, 198, 198, 198, 254,
	118, 0, 0, 0, 0, 24, 24, 126, 254, 192, 192, 254, 126, 24, 24, 0, 0, 0, 56, 124, 100, 100, 96, 240, 96,
	98, 230, 254, 252, 0, 0, 0, 204, 204, 204, 120, 120, 48, 252, 48, 252, 48, 48, 0, 0, 0, 248, 252, 204,
	204, 252, 250, 194, 198, 207, 198, 198, 198, 195, 0, 14, 31, 27, 27, 24, 24, 60, 24, 24, 216, 216,
	248, 112, 0, 14, 28, 0, 124, 126, 6, 126, 254, 198, 254, 118, 0, 0, 0, 28, 56, 0, 56, 56, 24, 24, 24, 24,
	60, 60, 0, 0, 0, 14, 28, 0, 124, 254, 198, 198, 198, 198, 254, 124, 0, 0, 0, 14, 28, 0, 198, 198, 198,
	198, 198, 198, 254, 118, 0, 0, 0, 116, 92, 0, 220, 254, 230, 198, 198, 198, 198, 198, 0, 0, 0, 254, 0,
	134, 198, 230, 246, 254, 222, 206, 198, 194, 0, 0, 0, 0, 60, 126, 102, 102, 102, 126, 54, 0, 126, 126,
	0, 0, 0, 0, 60, 126, 102, 102, 126, 60, 0, 0, 126, 126, 0, 0, 0, 24, 24, 0, 24, 24, 120, 224, 198, 198,
	254, 124, 0, 0, 0, 0, 0, 0, 0, 126, 126, 96, 96, 96, 96, 0, 0, 0, 0, 0, 0, 0, 0, 126, 126, 6, 6, 6, 6, 0, 0, 0,
	0, 198, 198, 204, 204, 24, 24, 48, 48, 102, 105, 194, 196, 143, 0, 198, 198, 204, 204, 24, 24, 49,
	51, 101, 105, 223, 193, 129, 0, 24, 60, 24, 0, 24, 24, 60, 60, 60, 60, 24, 0, 0, 0, 0, 0, 0, 27, 54, 108,
	216, 108, 54, 27, 0, 0, 0, 0, 0, 0, 0, 216, 108, 54, 27, 54, 108, 216, 0, 0, 0, 34, 136, 34, 136, 34, 136,
	34, 136, 34, 136, 34, 136, 34, 136, 85, 170, 85, 170, 85, 170, 85, 170, 85, 170, 85, 170, 85, 170,
	221, 119, 221, 119, 221, 119, 221, 119, 221, 119, 221, 119, 221, 119, 24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248,
	248, 24, 24, 248, 248, 24, 24, 24, 24, 54, 54, 54, 54, 54, 54, 246, 246, 54, 54, 54, 54, 54, 54, 0, 0, 0,
	0, 0, 0, 254, 254, 54, 54, 54, 54, 54, 54, 0, 0, 0, 0, 248, 248, 24, 24, 248, 248, 24, 24, 24, 24, 54,
	54, 54, 54, 246, 246, 6, 6, 246, 246, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
	54, 54, 0, 0, 0, 0, 254, 254, 6, 6, 246, 246, 54, 54, 54, 54, 54, 54, 54, 54, 246, 246, 6, 6, 254, 254,
	0, 0, 0, 0, 54, 54, 54, 54, 54, 54, 254, 254, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 248, 248, 24, 24, 248,
	248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 31, 31, 0, 0, 0,
	0, 0, 0, 24, 24, 24, 24, 24, 24, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24, 31, 31, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 0,
	0, 24, 24, 24, 24, 24, 24, 255, 255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 31, 31, 24, 24, 31, 31,
	24, 24, 24, 24, 54, 54, 54, 54, 54, 54, 55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 48, 48,
	63, 63, 0, 0, 0, 0, 0, 0, 0, 0, 63, 63, 48, 48, 55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 247, 247, 0, 0,
	255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 247, 247, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 48, 48,
	55, 55, 54, 54, 54, 54, 0, 0, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0, 0, 0, 54, 54, 54, 54, 247, 247, 0, 0,
	247, 247, 54, 54, 54, 54, 24, 24, 24, 24, 255, 255, 0, 0, 255, 255, 0, 0, 0, 0, 54, 54, 54, 54, 54, 54,
	255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 255, 255, 24, 24, 24, 24, 0, 0, 0, 0, 0, 0, 255, 255,
	54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 63, 63, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 31, 31, 24, 24,
	31, 31, 0, 0, 0, 0, 0, 0, 0, 0, 31, 31, 24, 24, 31, 31, 24, 24, 24, 24, 0, 0, 0, 0, 0, 0, 63, 63, 54, 54, 54,
	54, 54, 54, 54, 54, 54, 54, 54, 54, 255, 255, 54, 54, 54, 54, 54, 54, 24, 24, 24, 24, 255, 255, 24, 24,
	255, 255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 31, 24,
	24, 24, 24, 24, 24, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
	0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
	240, 240, 240, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 255, 255, 255, 255, 255, 255,
	255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 254, 204, 204, 204, 204, 254, 118, 0, 0, 0, 30, 63, 51, 115, 98,
	254, 227, 227, 227, 255, 222, 192, 0, 0, 0, 254, 254, 198, 198, 192, 192, 192, 192, 192, 192, 0, 0, 0,
	0, 254, 254, 108, 108, 108, 108, 108, 108, 108, 108, 0, 0, 0, 252, 252, 204, 224, 112, 56, 56, 112,
	224, 204, 252, 252, 0, 0, 0, 0, 0, 126, 254, 204, 204, 204, 204, 252, 120, 0, 0, 0, 0, 102, 102, 102,
	102, 102, 102, 102, 110, 124, 120, 240, 224, 0, 0, 50, 126, 220, 152, 24, 24, 24, 24, 24, 24, 0, 0, 0,
	252, 252, 48, 120, 252, 204, 204, 204, 252, 120, 48, 252, 252, 0, 56, 124, 238, 198, 198, 254, 198,
	198, 238, 124, 56, 0, 0, 0, 16, 56, 124, 238, 198, 198, 198, 108, 108, 238, 238, 0, 0, 0, 28, 60, 48,
	48, 24, 124, 252, 204, 204, 204, 252, 120, 0, 0, 0, 0, 0, 108, 254, 214, 214, 214, 214, 254, 108, 0,
	0, 0, 4, 12, 8, 124, 254, 214, 214, 214, 214, 254, 124, 32, 96, 0, 60, 124, 96, 224, 192, 240, 240,
	192, 224, 96, 124, 60, 0, 0, 60, 126, 102, 102, 102, 102, 102, 102, 102, 102, 102, 0, 0, 0, 0, 0, 0,
	254, 254, 0, 254, 254, 0, 254, 254, 0, 0, 0, 24, 24, 24, 126, 126, 24, 24, 24, 0, 126, 126, 0, 0, 0, 0,
	48, 24, 12, 6, 12, 24, 48, 0, 126, 126, 0, 0, 0, 0, 12, 24, 48, 96, 48, 24, 12, 0, 126, 126, 0, 0, 0, 14,
	31, 27, 27, 27, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 216, 216, 216, 248,
	112, 0, 0, 0, 24, 24, 0, 126, 126, 0, 24, 24, 0, 0, 0, 0, 0, 0, 0, 118, 220, 0, 118, 220, 0, 0, 0, 0, 0, 0,
	60, 126, 102, 102, 126, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 24, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 24, 24, 0, 0, 0, 0, 0, 0, 15, 15, 12, 12, 12, 12, 236, 108, 108, 124, 60, 28, 12, 0, 108, 126, 118,
	102, 102, 102, 0, 0, 0, 0, 0, 0, 0, 0, 60, 102, 76, 24, 48, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 60, 60,
	60, 60, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char              ripfnt16x14[7168] = /* binary data included from 16x14 */
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 252, 112, 14, 224, 7,
	192, 3, 204, 51, 204, 51, 192, 3, 192, 3, 207, 243, 199, 227, 195,
	195, 224, 7, 112, 14, 63, 252, 63, 252, 127, 254, 255, 255, 255, 255, 243, 207, 243, 207, 255, 255,
	255, 255, 240, 15, 248, 31, 252, 63, 255, 255, 127, 254, 63, 252, 0, 0, 48, 48, 120, 120, 252, 252,
	255, 252, 255, 252, 127, 248, 63, 240, 31, 224, 15, 192, 7, 128, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 128, 7,
	192, 15, 224, 31, 240, 63, 248, 31, 240, 15, 224, 7, 192, 3, 128, 1, 0, 0, 0, 0, 0, 3, 192, 15, 240, 31,
	248, 7, 224, 49, 140, 121, 158, 255, 255, 121, 158, 49, 140, 1, 128, 7, 224, 15, 240, 0, 0, 0, 0, 0, 0,
	3, 128, 7, 192, 15, 224, 31, 240, 63, 248, 63, 248, 63, 248, 31, 240, 3, 128, 7, 192, 15, 224, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 192, 15, 240, 31, 248, 31, 248, 15, 240, 3, 192, 0, 0, 0, 0, 0, 0, 0, 0,
	255, 255, 255, 255, 255, 255, 255, 255, 252, 63, 240, 15, 224, 7, 224, 7, 240, 15, 252, 63, 255, 255,
	255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 15, 240, 31, 248, 60, 60, 56, 28, 56, 28, 56, 28, 60, 60, 31,
	248, 15, 240, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 240, 15, 224, 7, 195, 195, 199, 227, 199, 227, 199,
	227, 195, 195, 224, 7, 240, 15, 255, 255, 255, 255, 255, 255, 0, 0, 3, 254, 0, 62, 0, 126, 0, 246, 63,
	230, 127, 198, 224, 224, 192, 96, 224, 224, 127, 192, 63, 128, 0, 0, 0, 0, 0, 0, 15, 224, 63, 248, 120,
	60, 120, 60, 63, 248, 15, 224, 3, 128, 63, 248, 63, 248, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 15, 252, 14,
	12, 14, 12, 15, 252, 14, 0, 14, 0, 14, 0, 126, 0, 254, 0, 252, 0, 112, 0, 0, 0, 0, 0, 0, 0, 15, 252, 31,
	252, 60, 28, 56, 28, 63, 252, 63, 252, 56, 28, 56, 28, 56, 124, 120, 248, 240, 240, 224, 0, 0, 0, 243,
	207, 243, 207, 243, 207, 15, 240, 15, 240, 252, 63, 252, 63, 252, 63, 252, 63, 15, 240, 15, 240, 243,
	207, 243, 207, 243, 207, 0, 0, 48, 0, 60, 0, 63, 0, 63, 192, 63, 240, 63, 252, 63, 240, 63, 192, 63, 0,
	60, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 240, 3, 240, 15, 240, 63, 240, 255, 240, 63, 240, 15, 240, 3,
	240, 0, 240, 0, 48, 0, 0, 0, 0, 3, 0, 7, 128, 15, 192, 31, 224, 63, 240, 7, 128, 7, 128, 7, 128, 63, 240,
	31, 224, 15, 192, 7, 128, 3, 0, 0, 0, 0, 0, 24, 96, 60, 240, 60, 240, 60, 240, 60, 240, 24, 96, 24, 96,
	0, 0, 24, 96, 60, 240, 24, 96, 0, 0, 0, 0, 0, 0, 31, 252, 127, 252, 227, 156, 227, 156, 127, 156, 31,
	156, 3, 156, 3, 156, 3, 156, 3, 156, 3, 156, 0, 0, 0, 0, 0, 0, 3, 224, 15, 248, 28, 60, 14, 12, 15, 192,
	24, 96, 48, 48, 24, 96, 15, 192, 0, 224, 113, 192, 63, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31,
	248, 31, 248, 31, 248, 31, 248, 31, 248, 31, 248, 0, 0, 0, 0, 0, 0, 1, 128, 3, 192, 7, 224, 15, 240, 1,
	128, 1, 128, 15, 240, 7, 224, 3, 192, 1, 128, 0, 0, 255, 255, 255, 255, 0, 0, 1, 0, 3, 128, 7, 192, 15,
	224, 31, 240, 63, 248, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 3, 128, 3, 128, 3, 128,
	3, 128, 3, 128, 3, 128, 63, 248, 31, 240, 15, 224, 7, 192, 3, 128, 1, 0, 0, 0, 0, 0, 0, 0, 6, 0, 7, 128,
	7, 224, 255, 248, 255, 254, 255, 248, 7, 224, 7, 128, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 3, 192,
	15, 192, 63, 254, 255, 254, 63, 254, 15, 192, 3, 192, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	240, 0, 240, 0, 240, 0, 240, 0, 255, 248, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 64, 12, 96, 24, 48, 48,
	24, 127, 252, 255, 254, 127, 252, 48, 24, 24, 48, 12, 96, 4, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3,
	128, 7, 192, 15, 224, 31, 240, 63, 248, 127, 252, 127, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 252,
	127, 252, 63, 248, 31, 240, 15, 224, 7, 192, 3, 128, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 192, 7, 224, 7, 224, 7, 224, 3, 192, 3, 192, 1,
	128, 0, 0, 3, 192, 7, 224, 3, 192, 0, 0, 0, 0, 24, 48, 60, 120, 28, 56, 12, 24, 24, 48, 48, 96, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 112, 28, 112, 28, 112, 255, 254, 255, 254, 28, 112, 255,
	254, 255, 254, 28, 112, 28, 112, 28, 112, 0, 0, 0, 0, 7, 128, 7, 128, 63, 240, 112, 56, 96, 24, 112, 0,
	63, 240, 0, 56, 96, 24, 112, 56, 63, 240, 7, 128, 7, 128, 0, 0, 0, 0, 0, 56, 48, 112, 120, 224, 49, 192,
	3, 128, 7, 0, 14, 0, 28, 48, 56, 120, 112, 48, 96, 0, 0, 0, 0, 0, 0, 0, 15, 192, 28, 224, 28, 224, 15,
	192, 31, 0, 59, 12, 113, 152, 224, 240, 240, 224, 127, 248, 63, 12, 0, 0, 0, 0, 0, 0, 7, 0, 7, 128, 1,
	128, 3, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 1, 128, 3, 0, 7, 0, 6, 0, 14, 0, 14,
	0,
	14, 0, 6, 0, 7, 0, 3, 0, 1, 128, 0, 192, 0, 0, 12, 0, 6, 0, 3, 0, 3, 128, 1, 128, 1, 192, 1, 192, 1, 192, 1,
	128, 3, 128, 3, 0, 6, 0, 12, 0, 0, 0, 0, 0, 0, 0, 96, 48, 48, 96, 24, 192, 13, 128, 255, 248, 255, 248, 13,
	128, 24, 192, 48, 96, 96, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 3, 128, 63, 248, 63, 248, 3,
	128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 15, 128, 3, 128, 3,
	128,
	7, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 252, 63, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 15, 128, 15, 128, 7, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 56, 0,
	112, 0, 224, 1, 192, 3, 128, 7, 0, 14, 0, 28, 0, 56, 0, 48, 0, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240, 120, 120,
	112, 248, 113, 184, 115, 56, 118, 56, 124, 56, 120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 3, 0, 7, 0,
	15, 0, 31, 0, 63, 0, 7, 0, 7, 0, 7, 0, 7, 0, 63, 224, 127, 240, 0, 0, 0, 0, 0, 0, 31, 192, 127, 240, 248,
	120, 96, 56, 0, 240, 3, 224, 15, 128, 62, 0, 120, 48, 255, 248, 255, 240, 0, 0, 0, 0, 0, 0, 63, 240, 127,
	248, 112, 120, 0, 120, 0, 240, 7, 224, 0, 240, 0, 120, 112, 120, 127, 248, 63, 240, 0, 0, 0, 0, 0, 0, 0,
	56, 0, 248, 3, 248, 7, 184, 30, 56, 56, 56, 63, 248, 63, 248, 0, 56, 0, 56, 0, 56, 0, 0, 0, 0, 0, 0, 255,
	248, 255, 248, 224, 0, 224, 0, 255, 192, 255, 240, 0, 120, 0, 56, 112, 120, 127, 240, 63, 192, 0, 0, 0,
	0, 0, 0, 1, 240, 7, 240, 31, 0, 60, 0, 127, 224, 127, 240, 120, 120, 112, 56, 120, 120, 63, 240, 31,
	224, 0, 0, 0, 0, 0, 0, 127, 248, 127, 248, 112, 56, 112, 56, 0, 112, 0, 224, 1, 192, 3, 128, 7, 128, 7,
	128, 7, 128, 0, 0, 0, 0, 0, 0, 31, 192, 120, 240, 240, 120, 240, 120, 120, 240, 31, 192, 120, 240, 240,
	120, 240, 120, 120, 240, 31, 192, 0, 0, 0, 0, 0, 0, 15, 224, 63, 248, 120, 60, 112, 28, 120, 60, 63,
	252, 15, 252, 0, 120, 1, 240, 63, 224, 63, 128, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 15, 192, 15, 192, 3, 0, 0, 0,
	3, 0, 15, 192, 15, 192, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 15, 192, 15, 192, 3, 0, 0, 0, 7, 128, 7,
	192, 1, 192, 1, 192, 3, 128, 6, 0, 0, 0, 0, 0, 0, 0, 0, 120, 1, 224, 7, 128, 30, 0, 120, 0, 30, 0, 7, 128, 1,
	224, 0, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 248, 63, 248, 0, 0, 0, 0, 0, 0, 63, 248, 63, 248, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 15, 0, 3, 192, 0, 240, 0, 60, 0, 240, 3, 192, 15, 0, 60, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 7, 224, 31, 248, 60, 60, 56, 60, 0, 248, 1, 224, 3, 192, 3, 192, 0, 0, 3, 192, 3, 192, 0, 0, 0,
	0, 0, 0, 15, 192, 63, 240, 120, 120, 112, 56, 113, 184, 115, 248, 113, 240, 112, 0, 120, 0, 63, 248,
	15, 248, 0, 0, 0, 0, 0, 0, 3, 0, 15, 192, 63, 240, 124, 248, 112, 56, 112, 56, 127, 248, 127, 248, 112,
	56, 112, 56, 112, 56, 0, 0, 0, 0, 0, 0, 127, 224, 127, 248, 112, 124, 112, 60, 112, 120, 127, 224,
	112, 120, 112, 60, 112, 124, 127, 248, 127, 224, 0, 0, 0, 0, 0, 0, 31, 224, 63, 240, 120, 120, 112, 56,
	112, 0, 112, 0, 112, 0, 112, 56, 120, 120, 63, 240, 31, 224, 0, 0, 0, 0, 0, 0, 127, 128, 127, 224, 112,
	240, 112, 120, 112, 56, 112, 56, 112, 56, 112, 120, 112, 240, 127, 224, 127, 128, 0, 0, 0, 0, 0, 0,
	127, 248, 127, 248, 112, 0, 112, 0, 112, 0, 127, 224, 112, 0, 112, 0, 112, 0, 127, 248, 127, 248, 0, 0,
	0, 0, 0, 0, 127, 248, 127, 248, 112, 0, 112, 0, 127, 224, 127, 224, 112, 0, 112, 0, 112, 0, 112, 0,
	112, 0, 0, 0, 0, 0, 0, 0, 31, 240, 63, 248, 56, 56, 112, 0, 112, 0, 112, 248, 112, 248, 112, 56, 56, 56,
	63, 248, 31, 248, 0, 0, 0, 0, 0, 0, 112, 56, 112, 56, 112, 56, 112, 56, 127, 248, 127, 248, 112, 56,
	112, 56, 112, 56, 112, 56, 112, 56, 0, 0, 0, 0, 0, 0, 63, 192, 63, 192, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
	15, 0, 15, 0, 63, 192, 63, 192, 0, 0, 0, 0, 0, 0, 3, 248, 3, 248, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
	112, 224, 121, 224, 63, 192, 31, 128, 0, 0, 0, 0, 0, 0, 120, 24, 120, 120, 121, 248, 127, 224, 127,
	128, 127, 0, 127, 128, 127, 224, 121, 248, 120, 120, 120, 24, 0, 0, 0, 0, 0, 0, 112, 0, 112, 0, 112, 0,
	112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 127, 248, 127, 248, 0, 0, 0, 0, 0, 0, 96, 24, 112, 56,
	120, 120, 124, 248, 127, 248, 119, 184, 115, 56, 112, 56, 112, 56, 112, 56, 112, 56, 0, 0, 0, 0, 0, 0,
	112, 56, 120, 56, 124, 56, 126, 56, 127, 56, 119, 184, 115, 248, 113, 248, 112, 248, 112, 120, 112,
	56, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240, 120, 120, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 120,
	120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 127, 192, 127, 240, 112, 120, 112, 56, 112, 120, 127, 240,
	127, 192, 112, 0, 112, 0, 112, 0, 112, 0, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240, 120, 120, 112, 56, 112, 56,
	112, 56, 112, 56, 115, 56, 120, 248, 63, 240, 15, 224, 0, 60, 0, 0, 0, 0, 127, 192, 127, 240, 112, 120,
	112, 56, 112, 112, 127, 224, 127, 240, 112, 112, 112, 56, 112, 56, 112, 56, 0, 0, 0, 0, 0, 0, 31, 224,
	63, 240, 120, 120, 120, 0, 63, 0, 31, 224, 3, 240, 0, 120, 120, 120, 63, 240, 31, 224, 0, 0, 0, 0, 0, 0,
	127, 240, 127, 240, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 112, 56, 112, 56,
	112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 112,
	56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 60, 240, 31, 224, 15, 192, 7, 128, 3, 0, 0, 0, 0, 0,
	0, 0, 112, 56, 112, 56, 112, 56, 112, 56, 115, 56, 119, 184, 127, 248, 127, 248, 124, 248, 120,
	120, 112, 56, 0, 0, 0, 0, 0, 0, 96, 24, 112, 56, 120, 120, 60, 240, 31, 224, 15, 192, 31, 224, 60, 240,
	120, 120, 112, 56, 96, 24, 0, 0, 0, 0, 0, 0, 112, 28, 112, 28, 120, 60, 60, 120, 30, 240, 15, 224, 7,
	192, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 127, 248, 127, 248, 0, 240, 1, 224, 3, 192, 7, 128,
	15, 0, 30, 0, 60, 0, 127, 248, 127, 248, 0, 0, 0, 0, 0, 0, 15, 192, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
	0, 14, 0, 14, 0, 14, 0, 15, 192, 0, 0, 0, 0, 0, 0, 112, 0, 120, 0, 60, 0, 30, 0, 15, 0, 7, 128, 3, 192, 1,
	224, 0, 240, 0, 120, 0, 56, 0, 0, 0, 0, 0, 0, 7, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
	224, 0, 224, 0, 224, 7, 224, 0, 0, 0, 0, 0, 0, 1, 0, 7, 192, 31, 240, 124, 124, 48, 24, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
	255,
	255, 0, 0, 3, 128, 7, 128, 7, 0, 3, 0, 1, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0,
	0, 63, 192, 63, 240, 0, 120, 31, 248, 63, 248, 112, 120, 63, 248, 31, 184, 0, 0, 0, 0, 0, 0, 112, 0,
	112, 0, 112, 0, 119, 192, 127, 240, 120, 120, 112, 56, 112, 56, 120, 120, 127, 240, 119, 192, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240, 120, 56, 112, 0, 112, 0, 120, 56, 63, 240, 15, 192, 0, 0, 0,
	0, 0, 0, 0, 56, 0, 56, 0, 56, 15, 184, 63, 248, 120, 120, 112, 56, 112, 56, 120, 120, 63, 248, 15,
	216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240, 112, 56, 127, 248, 127, 248, 112, 0, 63, 240,
	15, 240, 0, 0, 0, 0, 0, 0, 7, 248, 15, 248, 14, 0, 63, 224, 63, 224, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 248, 63, 248, 120, 56, 112, 56, 112, 56, 120, 120, 63, 248,
	15, 184, 0, 56, 63, 240, 0, 0, 56, 0, 56, 0, 56, 0, 59, 192, 63, 240, 62, 120, 60, 56, 56, 56, 56, 56,
	56, 56, 56, 56, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 0, 0, 15, 128, 15, 128, 3, 128, 3, 128, 3, 128, 3, 128,
	15, 224, 15, 224, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 0, 0, 15, 128, 15, 128, 3, 128, 3, 128, 3, 128, 3,
	128, 7, 128, 127, 0, 62, 0, 0, 0, 0, 0, 56, 0, 56, 0, 56, 112, 56, 224, 57, 192, 59, 128, 63, 0, 63, 0, 59,
	128, 57, 192, 56, 224, 0, 0, 0, 0, 0, 0, 15, 128, 15, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
	3, 128, 15, 224, 15, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 96, 120, 240, 125, 240, 127, 240,
	119, 112, 114, 112, 112, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 192, 127, 224, 124, 240,
	120, 112, 112, 112, 112, 112, 112, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240,
	120, 120, 112, 56, 112, 56, 120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 192, 127,
	240, 120, 120, 112, 56, 112, 56, 120, 120, 127, 240, 119, 192, 112, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	15, 184, 63, 248, 120, 120, 112, 56, 112, 56, 120, 120, 63, 248, 15, 184, 0, 56, 0, 56, 0, 0, 0, 0, 0,
	0, 0, 0, 119, 224, 127, 240, 124, 112, 120, 0, 112, 0, 112, 0, 112, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 31, 240, 63, 248, 56, 0, 63, 240, 31, 248, 0, 56, 63, 248, 31, 240, 0, 0, 0, 0, 0, 0, 2, 0, 6, 0,
	14, 0, 31, 224, 63, 224, 14, 0, 14, 0, 14, 0, 14, 0, 7, 224, 3, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112,
	56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 248, 15, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	56, 56, 56, 56, 56, 56, 60, 120, 30, 240, 15, 224, 7, 192, 3, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112,
	56, 112, 56, 112, 56, 115, 56, 119, 184, 127, 248, 60, 240, 24, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	112, 112, 56, 224, 29, 192, 15, 128, 15, 128, 29, 192, 56, 224, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 112, 56, 112, 56, 112, 56, 112, 56, 112, 120, 120, 248, 63, 248, 15, 184, 0, 56, 63, 240, 0, 0, 0,
	0, 0, 0, 0, 0, 127, 224, 127, 192, 3, 128, 7, 0, 14, 0, 28, 0, 63, 224, 127, 224, 0, 0, 0, 0, 0, 0, 0,
	240, 1, 192, 3, 128, 3, 128, 3, 128, 15, 0, 3, 128, 3, 128, 3, 128, 1, 192, 0, 240, 0, 0, 0, 0, 0, 0, 3,
	128, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 15, 0,
	3, 128, 1, 192, 1, 192, 1, 192, 0, 240, 1, 192, 1, 192, 1, 192, 3, 128, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30,
	24, 51, 48, 97, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 7, 128, 15, 192, 31,
	224, 60, 240, 120, 120, 112, 56, 112, 56, 112, 56, 127, 248, 127, 248, 0, 0, 0, 0, 0, 0, 0, 0, 31, 224,
	63, 240, 120, 56, 112, 0, 120, 56, 63, 240, 31, 224, 3, 240, 0, 120, 31, 240, 31, 224, 0, 0, 0, 0, 112,
	56, 112, 56, 0, 0, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 248, 15, 184, 0, 0, 0, 0,
	0, 0, 1, 248, 7, 224, 0, 0, 15, 192, 63, 240, 112, 56, 127, 248, 127, 248, 112, 0, 63, 240, 15, 240,
	0, 0, 0, 0, 0, 0, 63, 240, 96, 24, 0, 0, 63, 192, 63, 240, 0, 120, 31, 248, 63, 248, 112, 120, 63, 248,
	31, 184, 0, 0, 0, 0, 0, 0, 56, 56, 56, 56, 0, 0, 63, 192, 63, 240, 0, 120, 31, 248, 63, 248, 112, 120,
	63, 248, 31, 184, 0, 0, 0, 0, 0, 0, 31, 128, 7, 224, 0, 0, 63, 192, 63, 240, 0, 120, 31, 248, 63, 248,
	112, 120, 63, 248, 31, 184, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 0, 0, 63, 192, 63, 240, 0, 120, 31, 248, 63,
	248, 112, 120, 63, 248, 31, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 192, 63, 240, 120, 120, 112, 56,
	112, 0, 120, 0, 63, 192, 15, 224, 0, 112, 15, 224, 0, 0, 63, 240, 96, 24, 0, 0, 15, 192, 63, 240, 112,
	56, 127, 248, 127, 248, 112, 0, 63, 240, 15, 240, 0, 0, 0, 0, 0, 0, 28, 56, 28, 56, 0, 0, 15, 192, 63,
	240, 112, 56, 127, 248, 127, 248, 112, 0, 63, 240, 15, 240, 0, 0, 0, 0, 0, 0, 31, 128, 7, 224, 0, 0, 15,
	192, 63, 240, 112, 56, 127, 248, 127, 248, 112, 0, 63, 240, 15, 240, 0, 0, 0, 0, 0, 0, 112, 224, 112,
	224, 0, 0, 15, 0, 15, 0, 7, 0, 7, 0, 7, 0, 7, 0, 31, 192, 31, 192, 0, 0, 0, 0, 0, 0, 63, 240, 96, 24, 0, 0, 7,
	128, 7, 128, 3, 128, 3, 128, 3, 128, 3, 128, 15, 224, 15, 224, 0, 0, 0, 0, 0, 0, 63, 0, 15, 192, 0, 0, 15,
	0, 15, 0, 7, 0, 7, 0, 7, 0, 7, 0, 31, 192, 31, 192, 0, 0, 0, 0, 0, 0, 112, 56, 115, 56, 7, 128, 15, 192,
	28, 224, 56, 112, 112, 56, 127, 248, 127, 248, 112, 56, 112, 56, 0, 0, 0, 0, 7, 128, 7, 128, 0, 0, 7,
	128, 15, 192, 28, 224, 56, 112, 112, 56, 127, 248, 127, 248, 112, 56, 112, 56, 0, 0, 0, 0, 0, 0, 1, 240,
	7, 192, 0, 0, 127, 248, 127, 248, 28, 0, 31, 224, 31, 224, 28, 0, 127, 248, 127, 248, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 31, 254, 31, 254, 0, 224, 31, 254, 63, 254, 113, 224, 63, 254, 30, 254, 0, 0, 0, 0, 0,
	0, 15, 252, 31, 252, 56, 224, 112, 224, 112, 224, 127, 252, 112, 224, 112, 224, 112, 224, 112,
	252, 112, 252, 0, 0, 0, 0, 0, 0, 63, 240, 96, 24, 0, 0, 15, 192, 63, 240, 120, 120, 112, 56, 112, 56,
	120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 56, 112, 56, 112, 0, 0, 15, 192, 63, 240, 120, 120, 112,
	56, 112, 56, 120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 31, 128, 7, 224, 0, 0, 15, 192, 63, 240, 120,
	120, 112, 56, 112, 56, 120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 63, 240, 96, 24, 0, 0, 112, 56, 112,
	56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 248, 15, 184, 0, 0, 0, 0, 0, 0, 31, 128, 7, 224, 0, 0, 112,
	56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 248, 15, 184, 0, 0, 0, 0, 0, 0, 112, 56, 112, 56,
	0, 0, 112, 56, 112, 56, 112, 56, 112, 56, 112, 120, 120, 248, 63, 248, 15, 184, 0, 56, 63, 240, 0, 0,
	96, 24, 103, 152, 15, 192, 28, 224, 56, 112, 48, 48, 48, 48, 56, 112, 28, 224, 15, 192, 7, 128, 0, 0,
	0, 0, 0, 0, 112, 56, 112, 56, 0, 0, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 248,
	15, 184, 0, 0, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 31, 240, 63, 248, 112, 0, 112, 0, 63, 248, 31, 240, 3,
	128, 3, 128, 0, 0, 0, 0, 0, 0, 3, 192, 15, 224, 30, 112, 28, 48, 28, 0, 127, 0, 28, 0, 28, 24, 28, 56, 127,
	240, 127, 224, 0, 0, 0, 0, 0, 0, 96, 48, 112, 112, 56, 224, 29, 192, 15, 128, 7, 0, 127, 240, 7, 0, 127,
	240, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 127, 128, 127, 192, 112, 224, 112, 224, 127, 192, 127, 8, 112, 24,
	112, 56, 112, 124, 112, 56, 112, 56, 112, 56, 112, 28, 0, 0, 0, 240, 1, 248, 1, 220, 3, 140, 3, 128, 3,
	128, 15, 224, 3, 128, 3, 128, 99, 128, 119, 0, 63, 0, 30, 0, 0, 0, 1, 248, 7, 224, 0, 0, 63, 192, 63, 240,
	0, 120, 31, 248, 63, 248, 112, 120, 63, 248, 31, 184, 0, 0, 0, 0, 0, 0, 3, 240, 15, 192, 0, 0, 7, 128,
	7, 128, 3, 128, 3, 128, 3, 128, 3, 128, 15, 224, 15, 224, 0, 0, 0, 0, 0, 0, 3, 240, 15, 192, 0, 0, 15,
	192, 63, 240, 120, 120, 112, 56, 112, 56, 120, 120, 63, 240, 15, 192, 0, 0, 0, 0, 0, 0, 3, 240, 15, 192,
	0, 0, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 120, 120, 63, 248, 15, 184, 0, 0, 0, 0, 0, 0, 15,
	48, 25, 224, 0, 0, 119, 192, 127, 240, 124, 120, 120, 56, 112, 56, 112, 56, 112, 56, 112, 56, 0, 0, 0,
	0, 0, 0, 63, 240, 0, 0, 56, 112, 60, 112, 62, 112, 63, 112, 63, 240, 59, 240, 57, 240, 56, 240, 56,
	112, 0, 0, 0, 0, 0, 0, 0, 0, 7, 192, 15, 240, 28, 56, 28, 56, 28, 120, 15, 248, 7, 216, 0, 0, 31, 248, 31,
	248, 0, 0, 0, 0, 0, 0, 0, 0, 3, 192, 15, 240, 28, 56, 28, 56, 15, 240, 3, 192, 0, 0, 0, 0, 31, 248, 31, 248,
	0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 0, 0, 3, 128, 7, 128, 15, 0, 60, 0, 120, 56, 120, 120, 63, 240, 15,
	192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 248, 63, 248, 56, 0, 56, 0, 56, 0, 56, 0, 0, 0, 0, 0, 0, 0,
	0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 240, 63, 240, 0, 112, 0, 112, 0, 112, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 56, 24,
	24, 56, 24, 112, 60, 224, 1, 192, 3, 128, 7, 0, 14, 124, 28, 198, 56, 28, 112, 112, 96, 254, 0, 0, 0, 0,
	56, 24, 24, 56, 24, 112, 60, 224, 1, 192, 3, 140, 7, 28, 14, 60, 28, 108, 56, 254, 112, 12, 96, 12, 0,
	0, 0, 0, 3, 192, 7, 224, 3, 192, 0, 0, 1, 128, 3, 192, 3, 192, 7, 224, 7, 224, 7, 224, 3, 192, 0, 0, 0, 0,
	0, 0, 0, 0, 7, 28, 14, 56, 28, 112, 56, 224, 113, 192, 56, 224, 28, 112, 14, 56, 7, 28, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 113, 192, 56, 224, 28, 112, 14, 56, 7, 28, 14, 56, 28, 112, 56, 224, 113, 192, 0, 0, 0, 0,
	0, 0, 34, 34, 136, 136, 34, 34, 136, 136, 34, 34, 136, 136, 34, 34, 136, 136, 34, 34, 136, 136, 34,
	34, 136, 136, 34, 34, 136, 136, 85, 85, 170, 170, 85, 85, 170, 170, 85, 85, 170, 170, 85, 85, 170,
	170, 85, 85, 170, 170, 85, 85, 170, 170, 85, 85, 170, 170, 221, 221, 119, 119, 221, 221, 119, 119,
	221, 221, 119, 119, 221, 221, 119, 119, 221, 221, 119, 119, 221, 221, 119, 119, 221, 221, 119, 119,
	3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
	3, 128, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 255, 192, 255, 192, 1, 192, 1, 192, 1, 192, 1,
	192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 255, 192, 255, 192, 1, 192, 1, 192, 255, 192, 255,
	192, 1, 192, 1, 192, 1, 192, 1, 192, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 254, 56, 254, 56,
	14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 248, 255, 248, 14,
	56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 0, 0, 0, 0, 0, 0, 0, 0, 255, 192, 255, 192, 1, 192, 1, 192,
	255, 192, 255, 192, 1, 192, 1, 192, 1, 192, 1, 192, 14, 56, 14, 56, 14, 56, 14, 56, 254, 56, 254, 56, 0,
	56, 0, 56, 254, 56, 254, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14,
	56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 0, 0, 0, 0, 0, 0, 0, 0, 255, 248, 255,
	248, 0, 56, 0, 56, 254, 56, 254, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 254,
	56, 254, 56, 0, 56, 0, 56, 255, 248, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 14, 56, 14, 56, 14, 56, 14, 56, 14,
	56, 14, 56, 255, 248, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 192, 1, 192, 1, 192, 1, 192, 255,
	192, 255, 192, 1, 192, 1, 192, 255, 192, 255, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	255, 192, 255, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1,
	192, 1, 192, 1, 255, 1, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1,
	192, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
	255, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1,
	255, 1, 255, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
	255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 255, 255, 255,
	255, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 255, 1, 255, 1,
	192, 1, 192, 1, 255, 1, 255, 1, 192, 1, 192, 1, 192, 1, 192, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14,
	56, 14, 63, 14, 63, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14,
	63, 14, 63, 14, 0, 14, 0, 15, 255, 15, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 15, 255,
	14, 0, 14, 0, 14, 63, 14, 63, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 254, 63,
	254, 63, 0, 0, 0, 0, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
	0, 0, 0, 0, 254, 63, 254, 63, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 63,
	14, 63, 14, 0, 14, 0, 14, 63, 14, 63, 14, 56, 14, 56, 14, 56, 14, 56, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
	255, 255, 0, 0, 0, 0, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 14, 56, 14, 56, 14, 56, 14, 56, 254, 63,
	254, 63, 0, 0, 0, 0, 254, 63, 254, 63, 14, 56, 14, 56, 14, 56, 14, 56, 3, 128, 3, 128, 3, 128, 3, 128,
	255, 255, 255, 255, 0, 0, 0, 0, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 14, 56, 14, 56, 14, 56, 14, 56,
	14, 56, 14, 56, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
	255, 255, 0, 0, 0, 0, 255, 255, 255, 255, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	255, 255, 255, 255, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14,
	56, 14, 56, 15, 255, 15, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 3, 128, 3, 128, 3, 255, 3,
	255, 3, 128, 3, 128, 3, 255, 3, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 255, 3, 255, 3, 128, 3,
	128, 3, 255, 3, 255, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 15, 255,
	14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 255,
	255, 255, 255, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 14, 56, 1, 192, 1, 192, 1, 192, 1, 192, 255, 255,
	255, 255, 1, 192, 1, 192, 255, 255, 255, 255, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1,
	192, 1, 192, 1, 192, 255, 192, 255, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	1, 255, 1, 255, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0,
	255, 0, 255, 0, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0,
	255, 0, 255, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 56, 63, 240, 121, 224, 112, 192, 112, 192, 121,
	224, 63, 240, 15, 56, 0, 0, 0, 0, 0, 0, 1, 240, 7, 252, 31, 30, 60, 14, 56, 28, 127, 240, 120, 28, 120,
	14, 124, 30, 127, 252, 119, 248, 112, 0, 0, 0, 0, 0, 0, 0, 127, 248, 127, 248, 112, 56, 112, 56, 112,
	0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 248, 127, 248, 28, 224, 28, 224,
	28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 0, 0, 0, 0, 0, 0, 127, 224, 127, 224, 112, 96,
	56, 0, 28, 0, 14, 0, 28, 0, 56, 0, 112, 96, 127, 224, 127, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 248,
	63, 248, 121, 192, 112, 224, 112, 224, 121, 224, 63, 192, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 56, 28, 56,
	28, 56, 28, 56, 28, 56, 28, 120, 28, 240, 29, 224, 31, 192, 31, 128, 127, 0, 126, 0, 0, 0, 0, 0, 15, 24,
	63, 248, 115, 240, 99, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 127, 240,
	127, 240, 7, 0, 31, 192, 63, 224, 120, 240, 112, 112, 120, 240, 63, 224, 31, 192, 7, 0, 127, 240, 127,
	240, 0, 0, 15, 192, 63, 240, 120, 120, 112, 56, 112, 56, 127, 248, 112, 56, 112, 56, 120, 120, 63,
	240, 15, 192, 0, 0, 0, 0, 0, 0, 15, 192, 31, 224, 60, 240, 112, 56, 96, 24, 96, 24, 112, 56, 56, 112, 24,
	96, 120, 120, 120, 120, 0, 0, 0, 0, 0, 0, 1, 192, 7, 224, 14, 0, 7, 0, 3, 128, 15, 192, 63, 224, 120,
	224, 112, 224, 121, 224, 63, 192, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 112, 62, 248, 115, 156, 97, 12,
	97, 12, 115, 156, 62, 248, 28, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 64, 28, 240, 63, 248, 115, 156, 97,
	12, 97, 12, 115, 156, 63, 248, 30, 112, 4, 0, 4, 0, 0, 0, 3, 240, 15, 240, 31, 0, 60, 0, 56, 0, 63, 128,
	63, 128, 56, 0, 60, 0, 31, 0, 15, 240, 3, 240, 0, 0, 0, 0, 3, 192, 15, 240, 30, 120, 28, 56, 28, 56, 28,
	56, 28, 56, 28, 56, 28, 56, 28, 56, 28, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 248, 127, 248, 0, 0,
	127, 248, 127, 248, 0, 0, 127, 248, 127, 248, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 3, 128, 63, 248, 63, 248,
	3, 128, 3, 128, 3, 128, 0, 0, 63, 248, 63, 248, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 7, 128, 1, 224, 0, 112, 1,
	224, 7, 128, 30, 0, 0, 0, 63, 248, 63, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 1, 224, 7, 128, 30, 0, 7, 128, 1,
	224, 0, 120, 0, 0, 63, 252, 63, 252, 0, 0, 0, 0, 0, 0, 0, 120, 1, 254, 3, 239, 3, 199, 3, 199, 3, 192, 3,
	192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
	192, 3, 192, 3, 192, 227, 192, 227, 192, 247, 192, 127, 128, 30, 0, 0, 0, 0, 0, 3, 0, 7, 128, 3, 0, 0, 0,
	127, 248, 127, 248, 0, 0, 3, 0, 7, 128, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 24, 27, 48, 49, 224, 0, 0, 14,
	24, 27, 48, 49, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 192, 15, 240, 28, 56, 28, 56, 15, 240, 3, 192, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 192, 3, 192, 3, 192, 0, 0, 0, 0, 0,
	0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	254,
	0, 254, 0, 224, 0, 224, 0, 224, 0, 224, 124, 224, 28, 224, 14, 224, 7, 224, 3, 224, 1, 224, 0, 224, 0,
	0, 29, 224, 31, 240, 30, 120, 28, 56, 28, 56, 28, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15,
	224, 28, 112, 0, 224, 3, 128, 15, 0, 31, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	15, 240, 15, 240, 15, 240, 15, 240, 15, 240, 15, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
static const unsigned char Triplex[16677] = /* binary data included from TRIP.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 84,
	82, 73, 80, 165, 64, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 24, 0, 249, 0, 0, 0, 0, 0, 0, 0, 4, 0, 60, 0, 96, 0, 116, 0, 222, 0, 28, 1,
	164, 1, 208, 1, 4, 2, 56, 2, 120, 2, 148, 2, 190, 2, 206, 2, 238, 2, 254, 2, 90, 3, 132, 3, 244, 3, 126, 4,
	166, 4, 6, 5, 136, 5, 206, 5, 86, 6, 216, 6, 20, 7, 92, 7, 102, 7, 130, 7, 140, 7, 234, 7, 86, 8, 138, 8, 8,
	9, 80, 9, 180, 9, 36, 10, 136, 10, 240, 10, 96, 11, 152, 11, 228, 11, 68, 12, 142, 12, 230, 12, 30,
	13, 132, 13, 224, 13, 110, 14, 238, 14, 68, 15, 148, 15, 220, 15, 14, 16, 94, 16, 170, 16, 240, 16,
	44, 17, 64, 17, 72, 17, 92, 17, 106, 17, 114, 17, 132, 17, 232, 17, 58, 18, 124, 18, 212, 18, 32, 19,
	98, 19, 4, 20, 102, 20, 166, 20, 236, 20, 66, 21, 112, 21, 6, 22, 104, 22, 190, 22, 32, 23, 124, 23,
	192, 23, 16, 24, 54, 24, 124, 24, 170, 24, 236, 24, 48, 25, 112, 25, 172, 25, 250, 25, 2, 26, 80, 26,
	104, 26, 122, 26, 232, 26, 102, 27, 212, 27, 66, 28, 222, 28, 100, 29, 228, 29, 72, 30, 158, 30, 34,
	31, 144, 31, 246, 31, 46, 32, 126, 32, 230, 32, 50, 33, 200, 33, 120, 34, 0, 35, 94, 35, 234, 35, 96,
	36, 176, 36, 24, 37, 142, 37, 42, 38, 168, 38, 10, 39, 130, 39, 240, 39, 112, 40, 230, 40, 108, 41,
	188, 41, 50, 42, 154, 42, 16, 43, 82, 43, 186, 43, 16, 44, 110, 44, 128, 44, 146, 44, 2, 45, 80, 45,
	136, 45, 152, 45, 168, 45, 168, 46, 164, 48, 208, 50, 216, 50, 228, 50, 244, 50, 4, 51, 18, 51, 32, 51,
	52, 51, 64, 51, 80, 51, 96, 51, 110, 51, 124, 51, 134, 51, 144, 51, 158, 51, 172, 51, 184, 51, 192,
	51, 204, 51, 220, 51, 236, 51, 252, 51, 12, 52, 32, 52, 52, 52, 72, 52, 84, 52, 112, 52, 130, 52, 146,
	52, 164, 52, 180, 52, 194, 52, 208, 52, 222, 52, 236, 52, 252, 52, 12, 53, 22, 53, 32, 53, 110, 53,
	184, 53, 226, 53, 12, 54, 86, 54, 170, 54, 250, 54, 24, 55, 70, 55, 88, 55, 174, 55, 10, 56, 76, 56,
	176, 56, 28, 57, 152, 57, 242, 57, 126, 58, 224, 58, 246, 58, 60, 59, 94, 59, 128, 59, 160, 59, 192,
	59, 238, 59, 28, 60, 98, 60, 142, 60, 214, 60, 240, 60, 6, 61, 60, 61, 152, 61, 206, 61, 16, 7, 14, 18,
	17, 21, 22, 7, 11, 10, 13, 21, 21, 21, 9, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 7, 7, 20, 21, 20,
	16, 24, 19, 20, 18, 20, 19, 18, 20, 22, 10, 14, 20, 16, 24, 22, 19, 20, 19, 20, 17, 18, 22, 19, 23, 19,
	21, 17, 7, 14, 8, 19, 17, 6, 17, 19, 16, 18, 16, 12, 17, 21, 10, 12, 20, 10, 32, 21, 17, 19, 17, 15, 14,
	15, 21, 17, 23, 18, 18, 15, 10, 4, 9, 14, 17, 18, 21, 16, 19, 17, 17, 17, 16, 18, 16, 16, 13, 18, 10, 21,
	19, 19, 29, 28, 19, 17, 17, 21, 21, 18, 19, 22, 17, 20, 19, 29, 21, 17, 10, 17, 21, 21, 22, 17, 17, 16,
	17, 17, 23, 23, 7, 22, 22, 14, 16, 24, 4, 12, 12, 20, 20, 13, 21, 20, 20, 20, 20, 12, 12, 8, 16, 16, 8,
	16, 16, 8, 16, 16, 16, 24, 24, 16, 16, 24, 16, 16, 16, 16, 16, 8, 8, 16, 24, 16, 12, 8, 16, 16, 8, 17, 16,
	24, 17, 16, 18, 20, 25, 22, 21, 18, 20, 20, 18, 30, 17, 20, 23, 21, 22, 22, 22, 14, 14, 21, 19, 17, 6, 6,
	21, 22, 11, 12, 144, 0, 0, 0, 130, 10, 131, 146, 131, 148, 130, 149, 130, 135, 129, 135, 129, 149,
	128, 148, 128, 146, 129, 138, 129, 21, 130, 149, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128,
	131, 129, 131, 130, 130, 131, 129, 131, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 135, 0, 0, 0,
	129, 21, 128, 148, 128, 142, 129, 20, 128, 142, 129, 21, 130, 148, 128, 142, 138, 21, 137, 148, 137,
	142, 138, 20, 137, 142, 138, 21, 139, 148, 137, 142, 142, 0, 0, 0, 136, 21, 129, 249, 142, 21, 135,
	249, 129, 10, 143, 138, 128, 4, 142, 132, 146, 0, 0, 0, 133, 25, 133, 252, 137, 25, 137, 252, 141, 16,
	141, 145, 140, 145, 140, 143, 142, 143, 142, 145, 141, 147, 140, 148, 137, 149, 133, 149, 130, 148,
	128, 146, 128, 143, 129, 141, 132, 139, 138, 137, 140, 136, 141, 134, 141, 131, 140, 129, 129, 15,
	130, 141, 132, 140, 138, 138, 140, 137, 141, 135, 130, 20, 129, 146, 129, 144, 130, 142, 132, 141,
	138, 139, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130, 129, 129, 130,
	128, 132, 128, 134, 130, 134, 130, 132, 129, 132, 129, 133, 145, 0, 0, 0, 146, 21, 128, 128, 133, 21,
	135, 147, 135, 145, 134, 143, 132, 142, 130, 142, 128, 144, 128, 146, 129, 148, 131, 149, 133, 149,
	135, 148, 138, 147, 141, 147, 144, 148, 146, 149, 142, 7, 140, 134, 139, 132, 139, 130, 141, 128,
	143, 128, 145, 129, 146, 131, 146, 133, 144, 135, 142, 135, 149, 0, 0, 0, 146, 12, 146, 141, 145,
	141, 145, 139, 147, 139, 147, 141, 146, 142, 145, 142, 144, 141, 143, 139, 141, 134, 139, 131, 137,
	129, 135, 128, 131, 128, 129, 129, 128, 131, 128, 134, 129, 136, 135, 140, 137, 142, 138, 144, 138,
	146, 137, 148, 135, 149, 133, 148, 132, 146, 132, 143, 133, 140, 135, 137, 139, 132, 142, 129, 144,
	128, 146, 128, 147, 130, 147, 131, 130, 1, 129, 131, 129, 134, 130, 136, 131, 137, 137, 14, 138,
	146, 138, 16, 137, 148, 133, 20, 132, 144, 133, 13, 135, 138, 139, 133, 142, 130, 144, 129, 133, 0,
	131, 129, 130, 131, 130, 134, 131, 136, 135, 140, 132, 18, 133, 142, 136, 138, 140, 133, 143, 130,
	145, 129, 146, 129, 147, 130, 150, 0, 0, 0, 131, 19, 130, 146, 129, 146, 128, 147, 128, 148, 129,
	149, 130, 149, 131, 148, 131, 145, 130, 143, 128, 142, 129, 20, 129, 147, 130, 147, 130, 148, 129,
	148, 130, 18, 131, 145, 131, 19, 130, 143, 135, 0, 0, 0, 135, 25, 133, 151, 131, 148, 129, 144, 128,
	139, 128, 135, 129, 130, 131, 254, 133, 251, 135, 249, 131, 19, 130, 144, 129, 140, 129, 134, 130,
	130, 131, 255, 133, 23, 132, 149, 131, 146, 130, 140, 130, 134, 131, 128, 132, 253, 133, 251, 139,
	0, 0, 0, 128, 25, 130, 151, 132, 148, 134, 144, 135, 139, 135, 135, 134, 130, 132, 254, 130, 251,
	128, 249, 132, 19, 133, 144, 134, 140, 134, 134, 133, 130, 132, 255, 130, 23, 131, 149, 132, 146,
	133, 140, 133, 134, 132, 128, 131, 253, 130, 251, 138, 0, 0, 0, 133, 21, 132, 148, 134, 138, 133,
	137, 133, 21, 133, 137, 133, 21, 134, 148, 132, 138, 133, 137, 128, 18, 129, 146, 137, 140, 138,
	140, 128, 18, 138, 140, 128, 18, 128, 145, 138, 141, 138, 140, 138, 18, 137, 146, 129, 140, 128,
	140, 138, 18, 128, 140, 138, 18, 138, 145, 128, 141, 128, 140, 141, 0, 0, 0, 136, 18, 136, 129, 137,
	129, 136, 18, 137, 146, 137, 129, 128, 10, 145, 138, 145, 137, 128, 10, 128, 137, 145, 137, 149, 0,
	0, 0, 130, 125, 131, 129, 130, 128, 129, 128, 128, 129, 128, 130, 129, 131, 130, 131, 131, 130,
	131, 255, 130, 253, 128, 252, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 130, 0, 131, 255, 149,
	0, 0, 0, 128, 10, 145, 138, 145, 137, 128, 10, 128, 137, 145, 137, 149, 0, 0, 0, 129, 3, 128, 130,
	128, 129, 129, 128, 130, 128, 131, 129, 131, 130, 130, 131, 129, 131, 129, 2, 129, 129, 130, 129,
	130, 130, 129, 130, 137, 0, 0, 0, 146, 25, 128, 249, 129, 249, 146, 25, 147, 153, 129, 249, 149, 0, 0,
	0, 134, 21, 131, 148, 129, 145, 128, 140, 128, 137, 129, 132, 131, 129, 134, 128, 136, 128, 139,
	129, 141, 132, 142, 137, 142, 140, 141, 145, 139, 148, 136, 149, 134, 149, 132, 148, 131, 146, 130,
	141, 130, 136, 131, 131, 132, 129, 134, 128, 131, 19, 130, 145, 129, 141, 129, 136, 130, 132, 131,
	130, 139, 2, 140, 132, 141, 136, 141, 141, 140, 145, 139, 147, 136, 0, 138, 129, 139, 131, 140, 136,
	140, 141, 139, 146, 138, 148, 136, 149, 149, 0, 0, 0, 134, 19, 134, 128, 135, 19, 135, 129, 131, 17,
	133, 146, 136, 149, 136, 128, 130, 0, 140, 128, 134, 1, 132, 128, 134, 2, 133, 128, 136, 2, 137, 128,
	136, 1, 138, 128, 146, 0, 149, 0, 0, 0, 129, 17, 129, 144, 130, 144, 130, 145, 129, 145, 129, 18, 130,
	146, 131, 145, 131, 144, 130, 143, 129, 143, 128, 144, 128, 145, 129, 147, 130, 148, 133, 149, 137,
	149, 140, 148, 141, 147, 142, 145, 142, 143, 141, 141, 138, 139, 133, 137, 131, 136, 129, 134, 128,
	131, 128, 128, 140, 19, 141, 145, 141, 143, 140, 141, 137, 21, 139, 148, 140, 145, 140, 143, 139,
	141, 137, 139, 133, 137, 128, 2, 129, 131, 131, 131, 136, 130, 140, 130, 142, 131, 142, 133, 142, 3,
	141, 129, 140, 128, 136, 128, 131, 131, 136, 129, 140, 129, 141, 130, 149, 0, 0, 0, 129, 17, 129,
	144, 130, 144, 130, 145, 129, 145, 129, 18, 130, 146, 131, 145, 131, 144, 130, 143, 129, 143, 128,
	144, 128, 145, 129, 147, 130, 148, 133, 149, 137, 149, 140, 148, 141, 146, 141, 143, 140, 141, 137,
	140, 139, 139, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130, 129, 129,
	130, 128, 132, 128, 133, 129, 134, 130, 134, 131, 133, 131, 132, 130, 131, 129, 131, 139, 20, 140,
	146, 140, 143, 139, 141, 136, 21, 138, 148, 139, 146, 139, 143, 138, 141, 136, 140, 138, 139, 139,
	138, 140, 135, 140, 132, 139, 129, 137, 128, 134, 12, 137, 140, 140, 9, 141, 135, 141, 132, 140,
	130, 129, 5, 129, 132, 130, 132, 130, 133, 129, 133, 149, 0, 0, 0, 137, 18, 137, 128, 138, 19, 138,
	129, 144, 6, 128, 134, 139, 149, 139, 128, 134, 0, 142, 128, 137, 1, 135, 128, 137, 2, 136, 128, 139,
	2, 140, 128, 139, 1, 141, 128, 149, 0, 0, 0, 130, 20, 138, 148, 140, 149, 130, 149, 128, 139, 130,
	141, 133, 142, 136, 142, 139, 141, 141, 139, 142, 136, 142, 134, 141, 131, 139, 129, 136, 128, 133,
	128, 130, 129, 129, 130, 128, 132, 128, 133, 129, 134, 130, 134, 131, 133, 131, 132, 130, 131, 129,
	131, 140, 11, 141, 137, 141, 133, 140, 131, 136, 14, 138, 141, 139, 140, 140, 137, 140, 133, 139,
	130, 138, 129, 136, 128, 129, 5, 129, 132, 130, 132, 130, 133, 129, 133, 130, 19, 134, 147, 138,
	148, 149, 0, 0, 0, 139, 18, 139, 145, 140, 145, 140, 146, 139, 146, 140, 19, 139, 147, 138, 146, 138,
	145, 139, 144, 140, 144, 141, 145, 141, 146, 140, 148, 138, 149, 135, 149, 132, 148, 130, 146, 129,
	144, 128, 140, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142,
	135, 141, 138, 139, 140, 136, 141, 134, 141, 132, 140, 131, 139, 130, 137, 131, 18, 130, 144, 129,
	140, 129, 134, 130, 131, 131, 130, 140, 3, 141, 133, 141, 136, 140, 138, 135, 21, 133, 148, 132,
	147, 131, 145, 130, 141, 130, 134, 131, 131, 132, 129, 134, 128, 136, 0, 138, 129, 139, 130, 140,
	133, 140, 136, 139, 139, 138, 140, 136, 141, 149, 0, 0, 0, 128, 21, 128, 143, 138, 18, 133, 147, 131,
	147, 129, 146, 128, 145, 129, 147, 131, 149, 133, 149, 138, 146, 140, 146, 141, 147, 142, 149, 142,
	146, 141, 143, 137, 138, 136, 136, 135, 132, 135, 128, 133, 128, 133, 132, 134, 135, 136, 138, 141,
	143, 136, 9, 135, 135, 134, 132, 134, 128, 130, 19, 131, 148, 133, 148, 135, 147, 149, 0, 0, 0, 133,
	21, 130, 148, 129, 146, 129, 143, 130, 141, 133, 140, 137, 140, 140, 141, 141, 143, 141, 146, 140,
	148, 137, 149, 133, 149, 132, 148, 131, 146, 131, 143, 132, 141, 133, 140, 130, 139, 129, 138, 128,
	136, 128, 132, 129, 130, 130, 129, 133, 128, 137, 128, 140, 129, 141, 130, 142, 132, 142, 136, 141,
	138, 140, 139, 137, 140, 138, 141, 139, 143, 139, 146, 138, 148, 137, 149, 131, 20, 130, 146, 130,
	143, 131, 141, 139, 13, 140, 143, 140, 146, 139, 148, 130, 10, 129, 136, 129, 132, 130, 130, 140, 2,
	141, 132, 141, 136, 140, 138, 133, 12, 131, 139, 130, 136, 130, 132, 131, 129, 133, 128, 137, 0,
	139, 129, 140, 132, 140, 136, 139, 139, 137, 140, 149, 0, 0, 0, 130, 4, 130, 131, 131, 131, 131, 132,
	130, 132, 140, 12, 139, 138, 138, 137, 136, 136, 134, 136, 131, 137, 129, 139, 128, 142, 128, 143,
	129, 146, 131, 148, 134, 149, 136, 149, 139, 148, 141, 146, 142, 143, 142, 137, 141, 133, 140, 131,
	138, 129, 135, 128, 132, 128, 130, 129, 129, 131, 129, 132, 130, 133, 131, 133, 132, 132, 132, 131,
	131, 130, 130, 130, 130, 11, 129, 141, 129, 144, 130, 146, 139, 19, 140, 146, 141, 143, 141, 137,
	140, 133, 139, 131, 134, 8, 132, 137, 131, 138, 130, 141, 130, 144, 131, 147, 132, 148, 134, 149,
	136, 21, 138, 148, 139, 146, 140, 143, 140, 136, 139, 132, 138, 130, 137, 129, 135, 128, 149, 0, 0,
	0, 129, 14, 128, 141, 128, 140, 129, 139, 130, 139, 131, 140, 131, 141, 130, 142, 129, 142, 129,
	13, 129, 140, 130, 140, 130, 141, 129, 141, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131,
	129, 131, 130, 130, 131, 129, 131, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 135, 0, 0, 0, 129,
	14, 128, 141, 128, 140, 129, 139, 130, 139, 131, 140, 131, 141, 130, 142, 129, 142, 129, 13, 129,
	140, 130, 140, 130, 141, 129, 141, 131, 1, 130, 128, 129, 128, 128, 129, 128, 130, 129, 131, 130,
	131, 131, 130, 131, 255, 130, 253, 128, 252, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 130, 0,
	131, 255, 131, 1, 130, 253, 135, 0, 0, 0, 144, 18, 128, 137, 144, 128, 148, 0, 0, 0, 128, 14, 145, 142,
	145, 141, 128, 14, 128, 141, 145, 141, 128, 6, 145, 134, 145, 133, 128, 6, 128, 133, 145, 133, 149,
	0, 0, 0, 128, 18, 144, 137, 128, 128, 148, 0, 0, 0, 129, 16, 129, 145, 130, 145, 130, 143, 128, 143,
	128, 145, 129, 147, 130, 148, 132, 149, 136, 149, 139, 148, 140, 147, 141, 145, 141, 143, 140, 141,
	139, 140, 135, 138, 134, 138, 134, 135, 135, 135, 135, 138, 139, 19, 140, 146, 140, 142, 139, 141,
	136, 21, 138, 148, 139, 146, 139, 142, 138, 140, 137, 139, 134, 3, 133, 130, 133, 129, 134, 128,
	135, 128, 136, 129, 136, 130, 135, 131, 134, 131, 134, 2, 134, 129, 135, 129, 135, 130, 134, 130,
	144, 0, 0, 0, 143, 13, 142, 143, 140, 144, 137, 144, 135, 143, 134, 142, 133, 139, 133, 136, 134,
	134, 136, 133, 139, 133, 141, 134, 142, 136, 142, 134, 144, 133, 146, 133, 148, 135, 149, 138, 149,
	140, 148, 143, 147, 145, 145, 147, 143, 148, 140, 149, 137, 149, 134, 148, 132, 147, 130, 145, 129,
	143, 128, 140, 128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137, 128, 140, 128, 143, 129, 145,
	130, 146, 131, 137, 16, 135, 142, 134, 139, 134, 136, 135, 134, 136, 133, 144, 5, 143, 134, 143,
	136, 144, 144, 143, 144, 142, 136, 152, 0, 0, 0, 137, 21, 130, 129, 136, 18, 142, 128, 137, 18, 143,
	128, 137, 21, 144, 128, 132, 6, 141, 134, 128, 0, 134, 128, 139, 0, 146, 128, 130, 1, 129, 128, 130,
	1, 132, 128, 142, 1, 140, 128, 142, 2, 141, 128, 143, 2, 145, 128, 147, 0, 0, 0, 131, 21, 131, 128,
	132, 20, 132, 129, 133, 21, 133, 128, 128, 21, 140, 149, 143, 148, 144, 147, 145, 145, 145, 143,
	144, 141, 143, 140, 140, 139, 143, 19, 144, 145, 144, 143, 143, 141, 140, 21, 142, 148, 143, 146,
	143, 142, 142, 140, 140, 139, 133, 11, 140, 139, 143, 138, 144, 137, 145, 135, 145, 132, 144, 130,
	143, 129, 140, 128, 128, 128, 143, 9, 144, 135, 144, 132, 143, 130, 140, 11, 142, 138, 143, 136,
	143, 131, 142, 129, 140, 128, 129, 21, 131, 148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133,
	148, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 148, 0, 0, 0, 142, 18,
	143, 149, 143, 143, 142, 146, 140, 148, 138, 149, 135, 149, 132, 148, 130, 146, 129, 144, 128, 141,
	128, 136, 129, 133, 130, 131, 132, 129, 135, 128, 138, 128, 140, 129, 142, 131, 143, 133, 131, 18,
	130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 135, 21, 133, 148, 131, 145, 130, 141, 130, 136,
	131, 132, 133, 129, 135, 128, 146, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128,
	128, 21, 138, 149, 141, 148, 143, 146, 144, 144, 145, 141, 145, 136, 144, 133, 143, 131, 141, 129,
	138, 128, 128, 128, 142, 18, 143, 144, 144, 141, 144, 136, 143, 133, 142, 131, 138, 21, 140, 148,
	142, 145, 143, 141, 143, 136, 142, 132, 140, 129, 138, 128, 129, 21, 131, 148, 130, 21, 131, 147,
	134, 21, 133, 147, 135, 21, 133, 148, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1,
	135, 128, 148, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128, 128, 21, 144, 149,
	144, 143, 143, 149, 133, 11, 139, 139, 139, 15, 139, 135, 138, 139, 139, 143, 128, 0, 144, 128, 144,
	134, 143, 128, 129, 21, 131, 148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133, 148, 139, 21,
	144, 148, 141, 21, 144, 147, 142, 21, 144, 146, 139, 13, 137, 139, 139, 137, 139, 12, 135, 139, 139,
	138, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 139, 0, 144, 129, 141, 0,
	144, 130, 142, 0, 144, 131, 147, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128,
	128, 21, 144, 149, 144, 143, 133, 11, 139, 139, 139, 15, 139, 135, 128, 0, 136, 128, 129, 21, 131,
	148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133, 148, 139, 21, 144, 148, 141, 21, 144, 147,
	142, 21, 144, 146, 143, 21, 144, 143, 139, 15, 138, 139, 139, 135, 139, 13, 137, 139, 139, 137, 139,
	12, 135, 139, 139, 138, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 146,
	0, 0, 0, 142, 18, 143, 149, 143, 143, 142, 146, 140, 148, 138, 149, 135, 149, 132, 148, 130, 146,
	129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 135, 128, 138, 128, 140, 129, 142, 129,
	143, 128, 143, 136, 131, 18, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 135, 21, 133, 148,
	131, 145, 130, 141, 130, 136, 131, 132, 133, 129, 135, 128, 142, 7, 142, 130, 141, 8, 141, 130, 140,
	129, 138, 8, 146, 136, 139, 8, 141, 135, 140, 8, 141, 134, 144, 8, 143, 134, 145, 8, 143, 135, 148, 0,
	0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128, 143, 21, 143, 128, 144, 20, 144,
	129, 145, 21, 145, 128, 128, 21, 136, 149, 140, 21, 148, 149, 133, 11, 143, 139, 128, 0, 136, 128,
	140, 0, 148, 128, 129, 21, 131, 148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133, 148, 141,
	21, 143, 148, 142, 21, 143, 147, 146, 21, 145, 147, 147, 21, 145, 148, 131, 1, 129, 128, 131, 2,
	130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 143, 1, 141, 128, 143, 2, 142, 128, 145, 2, 146, 128,
	145, 1, 147, 128, 150, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128, 128, 21, 136,
	149, 128, 0, 136, 128, 129, 21, 131, 148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133, 148,
	131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 138, 0, 0, 0, 135, 21, 135,
	132, 134, 129, 133, 128, 136, 20, 136, 132, 135, 129, 137, 21, 137, 132, 136, 129, 133, 128, 131,
	128, 129, 129, 128, 131, 128, 133, 129, 134, 130, 134, 131, 133, 131, 132, 130, 131, 129, 131, 129,
	5, 129, 132, 130, 132, 130, 133, 129, 133, 132, 21, 140, 149, 133, 21, 135, 148, 134, 21, 135,
	147, 138, 21, 137, 147, 139, 21, 137, 148, 142, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133,
	21, 133, 128, 144, 20, 133, 137, 136, 11, 143, 128, 137, 11, 144, 128, 137, 13, 145, 128, 128, 21,
	136, 149, 141, 21, 147, 149, 128, 0, 136, 128, 140, 0, 147, 128, 129, 21, 131, 148, 130, 21, 131,
	147, 134, 21, 133, 147, 135, 21, 133, 148, 143, 21, 144, 148, 146, 21, 144, 148, 131, 1, 129, 128,
	131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 143, 2, 141, 128, 143, 2, 146, 128, 148, 0, 0, 0,
	131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128, 128, 21, 136, 149, 128, 0, 143, 128, 143,
	134, 129, 21, 131, 148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133, 148, 131, 1, 129, 128,
	131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 138, 0, 143, 129, 140, 0, 143, 130, 141, 0, 143,
	131, 142, 0, 143, 134, 144, 0, 0, 0, 131, 21, 131, 129, 131, 21, 138, 128, 132, 21, 138, 131, 133, 21,
	139, 131, 145, 21, 138, 128, 145, 21, 145, 128, 146, 20, 146, 129, 147, 21, 147, 128, 128, 21, 133,
	149, 145, 21, 150, 149, 128, 0, 134, 128, 142, 0, 150, 128, 129, 21, 131, 148, 148, 21, 147, 147,
	149, 21, 147, 148, 131, 1, 129, 128, 131, 1, 133, 128, 145, 1, 143, 128, 145, 2, 144, 128, 147, 2,
	148, 128, 147, 1, 149, 128, 152, 0, 0, 0, 131, 21, 131, 129, 131, 21, 145, 128, 132, 21, 144, 131,
	133, 21, 145, 131, 145, 20, 145, 128, 128, 21, 133, 149, 142, 21, 148, 149, 128, 0, 134, 128, 129,
	21, 131, 148, 143, 21, 145, 148, 147, 21, 145, 148, 131, 1, 129, 128, 131, 1, 133, 128, 150, 0, 0, 0,
	135, 21, 132, 148, 130, 146, 129, 144, 128, 140, 128, 137, 129, 133, 130, 131, 132, 129, 135, 128,
	137, 128, 140, 129, 142, 131, 143, 133, 144, 137, 144, 140, 143, 144, 142, 146, 140, 148, 137, 149,
	135, 149, 131, 18, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 141, 3, 142, 133, 143, 136,
	143, 141, 142, 144, 141, 146, 135, 21, 133, 148, 131, 145, 130, 141, 130, 136, 131, 132, 133, 129,
	135, 128, 137, 0, 139, 129, 141, 132, 142, 136, 142, 141, 141, 145, 139, 148, 137, 149, 147, 0, 0, 0,
	131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128, 128, 21, 140, 149, 143, 148, 144, 147, 145,
	145, 145, 142, 144, 140, 143, 139, 140, 138, 133, 138, 143, 19, 144, 145, 144, 142, 143, 140, 140,
	21, 142, 148, 143, 146, 143, 141, 142, 139, 140, 138, 128, 0, 136, 128, 129, 21, 131, 148, 130, 21,
	131, 147, 134, 21, 133, 147, 135, 21, 133, 148, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128,
	133, 1, 135, 128, 148, 0, 0, 0, 135, 21, 132, 148, 130, 146, 129, 144, 128, 140, 128, 137, 129, 133,
	130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 133, 144, 137, 144, 140, 143, 144,
	142, 146, 140, 148, 137, 149, 135, 149, 131, 18, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131,
	141, 3, 142, 133, 143, 136, 143, 141, 142, 144, 141, 146, 135, 21, 133, 148, 131, 145, 130, 141,
	130, 136, 131, 132, 133, 129, 135, 128, 137, 0, 139, 129, 141, 132, 142, 136, 142, 141, 141, 145,
	139, 148, 137, 149, 132, 3, 133, 133, 135, 134, 136, 134, 138, 133, 139, 131, 140, 253, 141, 251,
	143, 251, 144, 253, 144, 255, 140, 127, 141, 253, 142, 252, 143, 252, 139, 3, 141, 254, 142, 253,
	143, 253, 144, 254, 147, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 133, 21, 133, 128, 128, 21,
	140, 149, 143, 148, 144, 147, 145, 145, 145, 143, 144, 141, 143, 140, 140, 139, 133, 139, 143, 19,
	144, 145, 144, 143, 143, 141, 140, 21, 142, 148, 143, 146, 143, 142, 142, 140, 140, 139, 137, 11,
	139, 138, 140, 136, 142, 130, 143, 128, 145, 128, 146, 130, 146, 132, 142, 4, 143, 130, 144, 129,
	145, 129, 139, 10, 140, 137, 143, 131, 144, 130, 145, 130, 146, 131, 128, 0, 136, 128, 129, 21, 131,
	148, 130, 21, 131, 147, 134, 21, 133, 147, 135, 21, 133, 148, 131, 1, 129, 128, 131, 2, 130, 128,
	133, 2, 134, 128, 133, 1, 135, 128, 148, 0, 0, 0, 141, 18, 142, 149, 142, 143, 141, 146, 139, 148,
	136, 149, 133, 149, 130, 148, 128, 146, 128, 143, 129, 141, 132, 139, 138, 137, 140, 136, 141, 134,
	141, 131, 140, 129, 129, 15, 130, 141, 132, 140, 138, 138, 140, 137, 141, 135, 130, 20, 129, 146,
	129, 144, 130, 142, 132, 141, 138, 139, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128,
	134, 128, 131, 129, 129, 131, 128, 134, 128, 128, 129, 131, 145, 0, 0, 0, 128, 21, 128, 143, 135, 21,
	135, 128, 136, 20, 136, 129, 137, 21, 137, 128, 144, 21, 144, 143, 128, 21, 144, 149, 132, 0, 140,
	128, 129, 21, 128, 143, 130, 21, 128, 146, 131, 21, 128, 147, 133, 21, 128, 148, 139, 21, 144, 148,
	141, 21, 144, 147, 142, 21, 144, 146, 143, 21, 144, 143, 135, 1, 133, 128, 135, 2, 134, 128, 137, 2,
	138, 128, 137, 1, 139, 128, 146, 0, 0, 0, 131, 21, 131, 134, 132, 131, 134, 129, 137, 128, 139, 128,
	142, 129, 144, 131, 145, 134, 145, 148, 132, 20, 132, 133, 133, 131, 133, 21, 133, 133, 134, 130,
	135, 129, 137, 128, 128, 21, 136, 149, 142, 21, 148, 149, 129, 21, 131, 148, 130, 21, 131, 147, 134,
	21, 133, 147, 135, 21, 133, 148, 143, 21, 145, 148, 147, 21, 145, 148, 150, 0, 0, 0, 130, 21, 137,
	128, 131, 21, 137, 131, 137, 128, 132, 21, 138, 131, 144, 20, 137, 128, 128, 21, 135, 149, 140, 21,
	146, 149, 129, 21, 131, 147, 133, 21, 132, 147, 134, 21, 132, 148, 142, 21, 144, 148, 145, 21, 144,
	148, 147, 0, 0, 0, 131, 21, 135, 128, 132, 21, 135, 133, 135, 128, 133, 21, 136, 133, 139, 21, 136,
	133, 135, 128, 139, 21, 143, 128, 140, 21, 143, 133, 143, 128, 141, 21, 144, 133, 147, 20, 144, 133,
	143, 128, 128, 21, 136, 149, 139, 21, 141, 149, 144, 21, 150, 149, 129, 21, 132, 148, 130, 21, 132,
	147, 134, 21, 133, 147, 135, 21, 133, 148, 145, 21, 147, 148, 149, 21, 147, 148, 151, 0, 0, 0, 130,
	21, 142, 128, 131, 21, 143, 128, 132, 21, 144, 128, 143, 20, 131, 129, 128, 21, 135, 149, 140, 21,
	146, 149, 128, 0, 134, 128, 139, 0, 146, 128, 129, 21, 132, 147, 133, 21, 132, 147, 134, 21, 132,
	148, 141, 21, 143, 148, 145, 21, 143, 148, 131, 1, 129, 128, 131, 1, 133, 128, 142, 1, 140, 128, 142,
	2, 141, 128, 142, 2, 145, 128, 147, 0, 0, 0, 130, 21, 137, 138, 137, 128, 131, 21, 138, 138, 138,
	129, 132, 21, 139, 138, 139, 128, 145, 20, 139, 138, 128, 21, 135, 149, 142, 21, 148, 149, 134, 0,
	142, 128, 129, 21, 131, 148, 134, 21, 132, 148, 143, 21, 145, 148, 147, 21, 145, 148, 137, 1, 135,
	128, 137, 2, 136, 128, 139, 2, 140, 128, 139, 1, 141, 128, 149, 0, 0, 0, 142, 21, 128, 149, 128, 143,
	140, 21, 128, 128, 141, 21, 129, 128, 142, 21, 130, 128, 128, 0, 142, 128, 142, 134, 129, 21, 128,
	143, 130, 21, 128, 146, 131, 21, 128, 147, 133, 21, 128, 148, 137, 0, 142, 129, 139, 0, 142, 130,
	140, 0, 142, 131, 141, 0, 142, 134, 145, 0, 0, 0, 128, 19, 128, 255, 129, 19, 129, 255, 128, 19, 133,
	147, 128, 127, 133, 255, 135, 0, 0, 0, 128, 21, 142, 253, 142, 0, 0, 0, 132, 19, 132, 255, 133, 19,
	133, 255, 128, 19, 133, 147, 128, 127, 133, 255, 136, 0, 0, 0, 128, 14, 136, 147, 144, 142, 136, 146,
	128, 142, 147, 0, 0, 0, 128, 121, 144, 249, 145, 0, 0, 0, 130, 21, 129, 148, 128, 146, 128, 144, 129,
	143, 130, 144, 129, 145, 134, 0, 0, 0, 130, 11, 130, 140, 131, 140, 131, 138, 129, 138, 129, 140,
	130, 141, 132, 142, 136, 142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 138, 12,
	139, 138, 139, 131, 140, 129, 136, 14, 137, 141, 138, 139, 138, 131, 139, 129, 142, 128, 143, 128,
	138, 9, 137, 136, 132, 135, 129, 134, 128, 132, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129,
	138, 131, 130, 6, 129, 132, 129, 131, 130, 129, 137, 8, 133, 135, 131, 134, 130, 132, 130, 131, 131,
	129, 132, 128, 145, 0, 0, 0, 131, 21, 131, 128, 132, 129, 134, 129, 132, 20, 132, 130, 128, 21, 133,
	149, 133, 129, 133, 11, 134, 141, 136, 142, 138, 142, 141, 141, 143, 139, 144, 136, 144, 134, 143,
	131, 141, 129, 138, 128, 136, 128, 134, 129, 133, 131, 142, 11, 143, 137, 143, 133, 142, 131, 138,
	14, 140, 141, 141, 140, 142, 137, 142, 133, 141, 130, 140, 129, 138, 128, 129, 21, 131, 148, 130,
	21, 131, 147, 147, 0, 0, 0, 140, 10, 140, 139, 139, 139, 139, 137, 141, 137, 141, 139, 139, 141,
	137, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128,
	139, 129, 141, 131, 130, 11, 129, 137, 129, 133, 130, 131, 134, 14, 132, 141, 131, 140, 130, 137,
	130, 133, 131, 130, 132, 129, 134, 128, 144, 0, 0, 0, 139, 21, 139, 128, 144, 128, 140, 20, 140, 129,
	136, 21, 141, 149, 141, 128, 139, 11, 138, 141, 136, 142, 134, 142, 131, 141, 129, 139, 128, 136,
	128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 138, 129, 139, 131, 130, 11, 129, 137, 129, 133,
	130, 131, 134, 14, 132, 141, 131, 140, 130, 137, 130, 133, 131, 130, 132, 129, 134, 128, 137, 21,
	139, 148, 138, 21, 139, 147, 141, 2, 142, 128, 141, 1, 143, 128, 146, 0, 0, 0, 130, 8, 141, 136, 141,
	138, 140, 140, 139, 141, 136, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131,
	129, 134, 128, 136, 128, 139, 129, 141, 131, 140, 9, 140, 138, 139, 140, 130, 11, 129, 137, 129,
	133, 130, 131, 139, 8, 139, 139, 138, 141, 136, 142, 134, 14, 132, 141, 131, 140, 130, 137, 130,
	133, 131, 130, 132, 129, 134, 128, 144, 0, 0, 0, 138, 19, 138, 148, 137, 148, 137, 146, 139, 146,
	139, 148, 138, 149, 135, 149, 133, 148, 132, 147, 131, 144, 131, 128, 133, 19, 132, 144, 132, 129,
	135, 21, 134, 148, 133, 146, 133, 128, 128, 14, 137, 142, 128, 0, 136, 128, 131, 1, 129, 128, 131, 2,
	130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 140, 0, 0, 0, 141, 13, 142, 140, 143, 141, 142, 142,
	141, 142, 139, 141, 138, 140, 134, 14, 132, 141, 131, 140, 130, 138, 130, 136, 131, 134, 132, 133,
	134, 132, 136, 132, 138, 133, 139, 134, 140, 136, 140, 138, 139, 140, 138, 141, 136, 142, 134, 142,
	132, 12, 131, 138, 131, 136, 132, 134, 138, 6, 139, 136, 139, 138, 138, 140, 134, 14, 133, 141, 132,
	139, 132, 135, 133, 133, 134, 132, 136, 4, 137, 133, 138, 135, 138, 139, 137, 141, 136, 142, 131, 6,
	130, 133, 129, 131, 129, 130, 130, 128, 131, 255, 134, 254, 138, 254, 141, 253, 142, 252, 131, 0,
	134, 255, 138, 255, 141, 254, 129, 2, 130, 129, 133, 128, 138, 128, 141, 255, 142, 253, 142, 252,
	141, 250, 138, 249, 132, 249, 129, 250, 128, 252, 128, 253, 129, 255, 132, 128, 132, 121, 130, 250,
	129, 252, 129, 253, 130, 255, 132, 128, 145, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 128, 21,
	133, 149, 133, 128, 133, 10, 134, 140, 135, 141, 137, 142, 140, 142, 142, 141, 143, 140, 144, 137,
	144, 128, 142, 12, 143, 137, 143, 129, 140, 14, 141, 141, 142, 138, 142, 128, 128, 0, 136, 128, 139,
	0, 147, 128, 129, 21, 131, 148, 130, 21, 131, 147, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134,
	128, 133, 1, 135, 128, 142, 1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 144, 1, 146, 128, 149, 0,
	0, 0, 131, 21, 131, 147, 133, 147, 133, 149, 131, 149, 132, 21, 132, 147, 131, 20, 133, 148, 131,
	14, 131, 128, 132, 13, 132, 129, 128, 14, 133, 142, 133, 128, 128, 0, 136, 128, 129, 14, 131, 141,
	130, 14, 131, 140, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 138, 0, 0,
	0, 134, 21, 134, 147, 136, 147, 136, 149, 134, 149, 135, 21, 135, 147, 134, 20, 136, 148, 134, 14,
	134, 253, 133, 250, 132, 249, 135, 13, 135, 254, 134, 251, 131, 14, 136, 142, 136, 254, 135, 251,
	134, 250, 132, 249, 129, 249, 128, 250, 128, 252, 130, 252, 130, 250, 129, 250, 129, 251, 132, 14,
	134, 141, 133, 14, 134, 140, 140, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 128, 21, 133, 149,
	133, 128, 142, 13, 133, 132, 137, 8, 144, 128, 137, 7, 143, 128, 136, 7, 142, 128, 139, 14, 146, 142,
	128, 0, 136, 128, 139, 0, 146, 128, 129, 21, 131, 148, 130, 21, 131, 147, 140, 14, 142, 141, 145, 14,
	142, 141, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 142, 2, 140, 128,
	141, 2, 145, 128, 148, 0, 0, 0, 131, 21, 131, 128, 132, 20, 132, 129, 128, 21, 133, 149, 133, 128,
	128, 0, 136, 128, 129, 21, 131, 148, 130, 21, 131, 147, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2,
	134, 128, 133, 1, 135, 128, 138, 0, 0, 0, 131, 14, 131, 128, 132, 13, 132, 129, 128, 14, 133, 142,
	133, 128, 133, 10, 134, 140, 135, 141, 137, 142, 140, 142, 142, 141, 143, 140, 144, 137, 144, 128,
	142, 12, 143, 137, 143, 129, 140, 14, 141, 141, 142, 138, 142, 128, 144, 10, 145, 140, 146, 141,
	148, 142, 151, 142, 153, 141, 154, 140, 155, 137, 155, 128, 153, 12, 154, 137, 154, 129, 151, 14,
	152, 141, 153, 138, 153, 128, 128, 0, 136, 128, 139, 0, 147, 128, 150, 0, 158, 128, 129, 14, 131,
	141, 130, 14, 131, 140, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 142,
	1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 144, 1, 146, 128, 153, 1, 151, 128, 153, 2, 152,
	128, 155, 2, 156, 128, 155, 1, 157, 128, 160, 0, 0, 0, 131, 14, 131, 128, 132, 13, 132, 129, 128, 14,
	133, 142, 133, 128, 133, 10, 134, 140, 135, 141, 137, 142, 140, 142, 142, 141, 143, 140, 144, 137,
	144, 128, 142, 12, 143, 137, 143, 129, 140, 14, 141, 141, 142, 138, 142, 128, 128, 0, 136, 128, 139,
	0, 147, 128, 129, 14, 131, 141, 130, 14, 131, 140, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134,
	128, 133, 1, 135, 128, 142, 1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 144, 1, 146, 128, 149, 0,
	0, 0, 134, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128,
	139, 129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 136, 142, 134, 142, 130, 11, 129, 137,
	129, 133, 130, 131, 140, 3, 141, 133, 141, 137, 140, 139, 134, 14, 132, 141, 131, 140, 130, 137,
	130, 133, 131, 130, 132, 129, 134, 128, 136, 0, 138, 129, 139, 130, 140, 133, 140, 137, 139, 140,
	138, 141, 136, 142, 145, 0, 0, 0, 131, 14, 131, 249, 132, 13, 132, 250, 128, 14, 133, 142, 133, 249,
	133, 11, 134, 141, 136, 142, 138, 142, 141, 141, 143, 139, 144, 136, 144, 134, 143, 131, 141, 129,
	138, 128, 136, 128, 134, 129, 133, 131, 142, 11, 143, 137, 143, 133, 142, 131, 138, 14, 140, 141,
	141, 140, 142, 137, 142, 133, 141, 130, 140, 129, 138, 128, 128, 121, 136, 249, 129, 14, 131, 141,
	130, 14, 131, 140, 131, 122, 129, 249, 131, 123, 130, 249, 133, 123, 134, 249, 133, 122, 135, 249,
	147, 0, 0, 0, 139, 13, 139, 249, 140, 12, 140, 250, 138, 13, 140, 141, 141, 142, 141, 249, 139, 11,
	138, 141, 136, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128,
	136, 128, 138, 129, 139, 131, 130, 11, 129, 137, 129, 133, 130, 131, 134, 14, 132, 141, 131, 140,
	130, 137, 130, 133, 131, 130, 132, 129, 134, 128, 136, 121, 144, 249, 139, 122, 137, 249, 139, 123,
	138, 249, 141, 123, 142, 249, 141, 122, 143, 249, 145, 0, 0, 0, 131, 14, 131, 128, 132, 13, 132, 129,
	128, 14, 133, 142, 133, 128, 140, 12, 140, 141, 139, 141, 139, 139, 141, 139, 141, 141, 140, 142,
	138, 142, 136, 141, 134, 139, 133, 136, 128, 0, 136, 128, 129, 14, 131, 141, 130, 14, 131, 140, 131,
	1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 143, 0, 0, 0, 138, 12, 139, 142,
	139, 138, 138, 140, 137, 141, 135, 142, 131, 142, 129, 141, 128, 140, 128, 138, 129, 136, 131, 135,
	136, 134, 138, 133, 139, 130, 129, 13, 128, 138, 129, 9, 131, 136, 136, 135, 138, 134, 139, 5, 138,
	129, 128, 12, 129, 138, 131, 137, 136, 136, 138, 135, 139, 133, 139, 130, 138, 129, 136, 128, 132,
	128, 130, 129, 129, 130, 128, 132, 128, 128, 129, 130, 142, 0, 0, 0, 135, 0, 134, 129, 133, 132, 133,
	149, 131, 147, 131, 133, 132, 130, 133, 129, 135, 128, 137, 128, 139, 129, 140, 131, 132, 19, 132,
	132, 133, 130, 128, 14, 137, 142, 143, 0, 0, 0, 131, 14, 131, 133, 132, 130, 133, 129, 135, 128, 138,
	128, 140, 129, 141, 130, 142, 132, 132, 13, 132, 132, 133, 130, 128, 14, 133, 142, 133, 132, 134,
	129, 135, 128, 142, 14, 142, 128, 147, 128, 143, 13, 143, 129, 139, 14, 144, 142, 144, 128, 129, 14,
	131, 141, 130, 14, 131, 140, 144, 2, 145, 128, 144, 1, 146, 128, 149, 0, 0, 0, 130, 14, 136, 128, 131,
	14, 136, 130, 132, 14, 137, 130, 142, 13, 137, 130, 136, 128, 128, 14, 135, 142, 138, 14, 144, 142,
	129, 14, 132, 140, 134, 14, 132, 141, 140, 14, 142, 141, 143, 14, 142, 141, 145, 0, 0, 0, 131, 14,
	135, 128, 132, 14, 135, 131, 133, 14, 136, 131, 139, 14, 136, 131, 135, 128, 139, 14, 143, 128, 140,
	14, 143, 131, 139, 14, 141, 142, 144, 131, 147, 13, 144, 131, 143, 128, 128, 14, 136, 142, 144, 14,
	150, 142, 129, 14, 132, 141, 135, 14, 133, 141, 145, 14, 147, 141, 149, 14, 147, 141, 151, 0, 0, 0,
	130, 14, 140, 128, 131, 14, 141, 128, 132, 14, 142, 128, 141, 13, 131, 129, 128, 14, 135, 142, 138,
	14, 144, 142, 128, 0, 134, 128, 137, 0, 144, 128, 129, 14, 131, 141, 134, 14, 132, 141, 139, 14,
	141, 141, 143, 14, 141, 141, 131, 1, 129, 128, 131, 1, 133, 128, 140, 1, 138, 128, 141, 1, 143, 128,
	146, 0, 0, 0, 131, 14, 137, 128, 132, 14, 137, 130, 133, 14, 138, 130, 143, 13, 138, 130, 135, 252,
	133, 250, 131, 249, 129, 249, 128, 250, 128, 252, 130, 252, 130, 250, 129, 250, 129, 251, 129, 14,
	136, 142, 139, 14, 145, 142, 130, 14, 133, 140, 135, 14, 133, 141, 141, 14, 143, 141, 144, 14, 143,
	141, 146, 0, 0, 0, 138, 14, 128, 128, 139, 14, 129, 128, 140, 14, 130, 128, 140, 14, 128, 142, 128,
	138, 128, 0, 140, 128, 140, 132, 129, 14, 128, 138, 130, 14, 128, 139, 131, 14, 128, 140, 133, 14,
	128, 141, 135, 0, 140, 129, 137, 0, 140, 130, 138, 0, 140, 131, 139, 0, 140, 132, 143, 0, 0, 0, 133,
	25, 131, 152, 130, 151, 129, 149, 129, 147, 130, 145, 131, 144, 132, 142, 132, 140, 130, 138, 131,
	24, 130, 150, 130, 148, 131, 146, 132, 145, 133, 143, 133, 141, 132, 139, 128, 137, 132, 135, 133,
	133, 133, 131, 132, 129, 131, 128, 130, 254, 130, 252, 131, 250, 130, 8, 132, 134, 132, 132, 131,
	130, 130, 129, 129, 255, 129, 253, 130, 251, 131, 250, 133, 249, 138, 0, 0, 0, 128, 21, 128, 128,
	132, 0, 0, 0, 128, 25, 130, 152, 131, 151, 132, 149, 132, 147, 131, 145, 130, 144, 129, 142, 129,
	140, 131, 138, 130, 24, 131, 150, 131, 148, 130, 146, 129, 145, 128, 143, 128, 141, 129, 139, 133,
	137, 129, 135, 128, 133, 128, 131, 129, 129, 130, 128, 131, 254, 131, 252, 130, 250, 131, 8, 129,
	134, 129, 132, 130, 130, 131, 129, 132, 255, 132, 253, 131, 251, 130, 250, 128, 249, 137, 0, 0, 0,
	143, 21, 138, 143, 133, 146, 128, 145, 133, 149, 138, 145, 143, 149, 138, 144, 133, 147, 128, 145,
	142, 0, 0, 0, 128, 6, 128, 128, 140, 128, 140, 136, 134, 145, 128, 136, 128, 134, 145, 0, 0, 0, 142,
	19, 143, 150, 143, 144, 142, 147, 140, 149, 138, 150, 135, 150, 132, 149, 130, 147, 129, 145, 128,
	142, 128, 137, 129, 134, 130, 132, 132, 130, 135, 129, 138, 129, 140, 130, 142, 132, 143, 134, 131,
	19, 130, 145, 129, 142, 129, 137, 130, 134, 131, 132, 135, 22, 133, 149, 131, 146, 130, 142, 130,
	137, 131, 133, 133, 130, 135, 129, 135, 255, 136, 255, 140, 253, 140, 251, 139, 250, 137, 249, 139,
	251, 139, 253, 138, 254, 136, 1, 136, 255, 137, 121, 132, 249, 130, 251, 130, 253, 132, 253, 132,
	251, 131, 251, 131, 252, 146, 0, 0, 0, 131, 14, 131, 133, 132, 130, 133, 129, 135, 128, 138, 128,
	140, 129, 141, 130, 142, 132, 132, 13, 132, 132, 133, 130, 128, 14, 133, 142, 133, 132, 134, 129,
	135, 128, 142, 14, 142, 128, 147, 128, 143, 13, 143, 129, 139, 14, 144, 142, 144, 128, 129, 14, 131,
	141, 130, 14, 131, 140, 144, 2, 145, 128, 144, 1, 146, 128, 133, 20, 132, 147, 132, 146, 133, 145,
	134, 145, 135, 146, 135, 147, 134, 148, 133, 148, 133, 19, 133, 146, 134, 146, 134, 147, 133, 147,
	140, 20, 139, 147, 139, 146, 140, 145, 141, 145, 142, 146, 142, 147, 141, 148, 140, 148, 140, 19,
	140, 146, 141, 146, 141, 147, 140, 147, 149, 0, 0, 0, 130, 8, 141, 136, 141, 138, 140, 140, 139, 141,
	136, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128,
	139, 129, 141, 131, 140, 9, 140, 138, 139, 140, 130, 11, 129, 137, 129, 133, 130, 131, 139, 8, 139,
	139, 138, 141, 136, 142, 134, 14, 132, 141, 131, 140, 130, 137, 130, 133, 131, 130, 132, 129, 134,
	128, 138, 22, 137, 149, 136, 149, 135, 150, 135, 151, 136, 152, 137, 152, 138, 151, 138, 148, 134,
	145, 136, 23, 136, 150, 137, 150, 137, 151, 136, 151, 137, 21, 138, 148, 144, 0, 0, 0, 132, 11, 132,
	140, 133, 140, 133, 138, 131, 138, 131, 140, 132, 141, 134, 142, 138, 142, 140, 141, 141, 140, 142,
	138, 142, 131, 143, 129, 144, 128, 145, 128, 140, 12, 141, 138, 141, 131, 142, 129, 138, 14, 139,
	141, 140, 139, 140, 131, 141, 129, 144, 128, 140, 9, 139, 136, 134, 135, 131, 134, 130, 132, 130,
	131, 131, 129, 134, 128, 137, 128, 139, 129, 140, 131, 132, 6, 131, 132, 131, 131, 132, 129, 139, 8,
	135, 135, 133, 134, 132, 132, 132, 131, 133, 129, 134, 128, 128, 17, 136, 150, 144, 145, 136, 149,
	128, 145, 147, 0, 0, 0, 130, 11, 130, 140, 131, 140, 131, 138, 129, 138, 129, 140, 130, 141, 132,
	142, 136, 142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 143, 128, 138, 12, 139,
	138, 139, 131, 140, 129, 136, 14, 137, 141, 138, 139, 138, 131, 139, 129, 142, 128, 138, 9, 137,
	136, 132, 135, 129, 134, 128, 132, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129, 138, 131, 130,
	6, 129, 132, 129, 131, 130, 129, 137, 8, 133, 135, 131, 134, 130, 132, 130, 131, 131, 129, 132,
	128, 130, 20, 129, 147, 129, 146, 130, 145, 131, 145, 132, 146, 132, 147, 131, 148, 130, 148, 130,
	19, 130, 146, 131, 146, 131, 147, 130, 147, 137, 20, 136, 147, 136, 146, 137, 145, 138, 145, 139,
	146, 139, 147, 138, 148, 137, 148, 137, 19, 137, 146, 138, 146, 138, 147, 137, 147, 145, 0, 0, 0,
	130, 11, 130, 140, 131, 140, 131, 138, 129, 138, 129, 140, 130, 141, 132, 142, 136, 142, 138, 141,
	139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 143, 128, 138, 12, 139, 138, 139, 131, 140, 129,
	136, 14, 137, 141, 138, 139, 138, 131, 139, 129, 142, 128, 138, 9, 137, 136, 132, 135, 129, 134,
	128, 132, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129, 138, 131, 130, 6, 129, 132, 129, 131,
	130, 129, 137, 8, 133, 135, 131, 134, 130, 132, 130, 131, 131, 129, 132, 128, 131, 22, 132, 149,
	133, 149, 134, 150, 134, 151, 133, 152, 132, 152, 131, 151, 131, 148, 135, 145, 133, 23, 133, 150,
	132, 150, 132, 151, 133, 151, 132, 21, 131, 148, 145, 0, 0, 0, 130, 11, 130, 140, 131, 140, 131, 138,
	129, 138, 129, 140, 130, 141, 132, 142, 136, 142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129,
	142, 128, 143, 128, 138, 12, 139, 138, 139, 131, 140, 129, 136, 14, 137, 141, 138, 139, 138, 131,
	139, 129, 142, 128, 138, 9, 137, 136, 132, 135, 129, 134, 128, 132, 128, 131, 129, 129, 132, 128,
	135, 128, 137, 129, 138, 131, 130, 6, 129, 132, 129, 131, 130, 129, 137, 8, 133, 135, 131, 134, 130,
	132, 130, 131, 131, 129, 132, 128, 134, 20, 133, 147, 133, 146, 134, 145, 135, 145, 136, 146, 136,
	147, 135, 148, 134, 148, 134, 19, 134, 146, 135, 146, 135, 147, 134, 147, 145, 0, 0, 0, 131, 125,
	131, 252, 132, 252, 132, 254, 130, 254, 130, 252, 132, 250, 137, 250, 139, 252, 139, 254, 138, 255,
	136, 128, 134, 128, 134, 130, 132, 131, 131, 132, 130, 135, 130, 137, 131, 140, 132, 141, 134, 142,
	131, 141, 129, 139, 128, 136, 129, 133, 131, 131, 134, 130, 136, 130, 139, 131, 141, 133, 130, 11,
	129, 137, 129, 135, 130, 133, 140, 10, 140, 139, 139, 139, 139, 137, 141, 137, 141, 139, 139, 141,
	137, 142, 134, 142, 138, 127, 140, 254, 140, 252, 139, 251, 137, 250, 144, 0, 0, 0, 131, 8, 142, 136,
	142, 138, 141, 140, 140, 141, 137, 142, 135, 142, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131,
	132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 141, 9, 141, 138, 140, 140, 131, 11, 130, 137,
	130, 133, 131, 131, 140, 8, 140, 139, 139, 141, 137, 142, 135, 14, 133, 141, 132, 140, 131, 137,
	131, 133, 132, 130, 133, 129, 135, 128, 128, 17, 136, 150, 144, 145, 136, 149, 128, 145, 146, 0, 0,
	0, 130, 8, 141, 136, 141, 138, 140, 140, 139, 141, 136, 142, 134, 142, 131, 141, 129, 139, 128,
	136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 140, 9, 140, 138, 139,
	140, 130, 11, 129, 137, 129, 133, 130, 131, 139, 8, 139, 139, 138, 141, 136, 142, 134, 14, 132, 141,
	131, 140, 130, 137, 130, 133, 131, 130, 132, 129, 134, 128, 131, 21, 130, 148, 130, 147, 131, 146,
	132, 146, 133, 147, 133, 148, 132, 149, 131, 149, 131, 20, 131, 147, 132, 147, 132, 148, 131, 148,
	138, 21, 137, 148, 137, 147, 138, 146, 139, 146, 140, 147, 140, 148, 139, 149, 138, 149, 138, 20,
	138, 147, 139, 147, 139, 148, 138, 148, 144, 0, 0, 0, 130, 8, 141, 136, 141, 138, 140, 140, 139, 141,
	136, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128,
	139, 129, 141, 131, 140, 9, 140, 138, 139, 140, 130, 11, 129, 137, 129, 133, 130, 131, 139, 8, 139,
	139, 138, 141, 136, 142, 134, 14, 132, 141, 131, 140, 130, 137, 130, 133, 131, 130, 132, 129, 134,
	128, 132, 22, 133, 149, 134, 149, 135, 150, 135, 151, 134, 152, 133, 152, 132, 151, 132, 148, 136,
	145, 134, 23, 134, 150, 133, 150, 133, 151, 134, 151, 133, 21, 132, 148, 144, 0, 0, 0, 132, 14, 132,
	128, 133, 13, 133, 129, 129, 14, 134, 142, 134, 128, 129, 0, 137, 128, 130, 14, 132, 141, 131, 14,
	132, 140, 132, 1, 130, 128, 132, 2, 131, 128, 134, 2, 135, 128, 134, 1, 136, 128, 129, 20, 128, 147,
	128, 146, 129, 145, 130, 145, 131, 146, 131, 147, 130, 148, 129, 148, 129, 19, 129, 146, 130, 146,
	130, 147, 129, 147, 136, 20, 135, 147, 135, 146, 136, 145, 137, 145, 138, 146, 138, 147, 137, 148,
	136, 148, 136, 19, 136, 146, 137, 146, 137, 147, 136, 147, 141, 0, 0, 0, 135, 14, 135, 128, 136, 13,
	136, 129, 132, 14, 137, 142, 137, 128, 132, 0, 140, 128, 133, 14, 135, 141, 134, 14, 135, 140, 135,
	1, 133, 128, 135, 2, 134, 128, 137, 2, 138, 128, 137, 1, 139, 128, 128, 17, 136, 150, 144, 145,
	136, 149, 128, 145, 146, 0, 0, 0, 131, 14, 131, 128, 132, 13, 132, 129, 128, 14, 133, 142, 133, 128,
	128, 0, 136, 128, 129, 14, 131, 141, 130, 14, 131, 140, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2,
	134, 128, 133, 1, 135, 128, 128, 22, 129, 149, 130, 149, 131, 150, 131, 151, 130, 152, 129, 152,
	128, 151, 128, 148, 132, 145, 130, 23, 130, 150, 129, 150, 129, 151, 130, 151, 129, 21, 128, 148,
	138, 0, 0, 0, 144, 0, 137, 149, 130, 129, 129, 128, 136, 18, 142, 128, 137, 18, 143, 128, 132, 6, 141,
	134, 128, 0, 134, 128, 139, 0, 146, 128, 130, 1, 132, 128, 142, 1, 140, 128, 142, 2, 141, 128, 143, 2,
	145, 128, 133, 27, 132, 154, 132, 153, 133, 152, 134, 152, 135, 153, 135, 154, 134, 155, 133, 155,
	133, 26, 133, 153, 134, 153, 134, 154, 133, 154, 140, 27, 139, 154, 139, 153, 140, 152, 141, 152,
	142, 153, 142, 154, 141, 155, 140, 155, 140, 26, 140, 153, 141, 153, 141, 154, 140, 154, 149, 0, 0,
	0, 144, 0, 137, 149, 130, 129, 129, 128, 136, 18, 142, 128, 137, 18, 143, 128, 132, 6, 141, 134,
	128, 0, 134, 128, 139, 0, 146, 128, 130, 1, 132, 128, 142, 1, 140, 128, 142, 2, 141, 128, 143, 2, 145,
	128, 136, 27, 135, 154, 135, 153, 136, 152, 137, 152, 138, 153, 138, 154, 137, 155, 136, 155, 136,
	26, 136, 153, 137, 153, 137, 154, 136, 154, 147, 0, 0, 0, 128, 0, 144, 128, 144, 131, 142, 128, 131,
	1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 139, 0, 144, 129, 141, 0, 144,
	130, 128, 14, 144, 142, 144, 138, 143, 142, 129, 14, 131, 141, 130, 14, 131, 140, 134, 14, 133, 140,
	135, 14, 133, 141, 139, 14, 144, 141, 141, 14, 144, 140, 142, 14, 144, 139, 131, 0, 131, 142, 132, 1,
	132, 142, 133, 0, 133, 142, 144, 4, 144, 131, 143, 128, 144, 132, 133, 7, 139, 135, 139, 11, 139,
	131, 138, 135, 139, 139, 139, 9, 137, 135, 139, 133, 139, 8, 135, 135, 139, 134, 139, 22, 138, 149,
	137, 149, 136, 150, 136, 151, 137, 152, 138, 152, 139, 151, 139, 148, 135, 145, 137, 23, 137, 150,
	138, 150, 138, 151, 137, 151, 138, 21, 139, 148, 147, 0, 0, 0, 130, 11, 130, 140, 131, 140, 131, 138,
	129, 138, 129, 140, 130, 141, 132, 142, 136, 142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129,
	142, 128, 148, 128, 151, 129, 153, 131, 138, 12, 139, 138, 139, 131, 140, 129, 136, 14, 137, 141,
	138, 139, 138, 131, 139, 129, 142, 128, 138, 9, 137, 136, 132, 135, 129, 134, 128, 132, 128, 131,
	129, 129, 132, 128, 135, 128, 137, 129, 138, 131, 130, 6, 129, 132, 129, 131, 130, 129, 137, 8, 133,
	135, 131, 134, 130, 132, 130, 131, 131, 129, 132, 128, 146, 14, 148, 142, 151, 141, 152, 140, 153,
	138, 153, 136, 142, 136, 142, 137, 143, 140, 144, 141, 146, 142, 143, 141, 141, 139, 140, 136, 148,
	14, 150, 141, 151, 139, 151, 136, 150, 13, 151, 140, 152, 138, 152, 136, 140, 6, 141, 131, 143,
	129, 146, 128, 142, 11, 141, 137, 141, 133, 142, 131, 142, 8, 142, 133, 143, 130, 144, 129, 142, 1,
	144, 128, 157, 0, 0, 0, 152, 21, 153, 143, 153, 149, 137, 149, 130, 129, 129, 128, 132, 6, 141, 134,
	128, 0, 134, 128, 130, 1, 132, 128, 140, 0, 140, 149, 138, 21, 140, 148, 139, 21, 140, 147, 141, 20,
	141, 129, 142, 21, 142, 128, 143, 21, 142, 147, 142, 11, 148, 139, 148, 15, 148, 135, 147, 139, 148,
	143, 148, 10, 144, 139, 148, 140, 147, 12, 146, 139, 147, 138, 144, 21, 142, 148, 148, 21, 153, 148,
	137, 0, 153, 128, 153, 132, 142, 2, 143, 128, 142, 1, 144, 128, 140, 2, 139, 128, 138, 0, 140, 129,
	152, 0, 153, 133, 153, 134, 152, 128, 153, 133, 148, 0, 153, 129, 151, 0, 153, 131, 150, 0, 153, 130,
	151, 21, 153, 146, 150, 21, 153, 147, 156, 0, 0, 0, 135, 14, 132, 141, 130, 139, 129, 136, 129, 134,
	130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 134, 143, 136, 142, 139, 140, 141,
	137, 142, 135, 142, 133, 141, 132, 140, 131, 137, 131, 133, 132, 130, 133, 129, 135, 128, 131, 11,
	130, 137, 130, 133, 131, 131, 141, 3, 142, 133, 142, 137, 141, 139, 137, 0, 139, 129, 140, 130, 141,
	133, 141, 137, 140, 140, 139, 141, 137, 142, 128, 17, 136, 150, 144, 145, 136, 149, 128, 145, 147,
	0, 0, 0, 134, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128,
	139, 129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 136, 142, 134, 142, 132, 141, 131, 140,
	130, 137, 130, 133, 131, 130, 132, 129, 134, 128, 130, 11, 129, 137, 129, 133, 130, 131, 140, 3,
	141, 133, 141, 137, 140, 139, 136, 0, 138, 129, 139, 130, 140, 133, 140, 137, 139, 140, 138, 141,
	136, 142, 131, 20, 130, 147, 130, 146, 131, 145, 132, 145, 133, 146, 133, 147, 132, 148, 131, 148,
	131, 19, 131, 146, 132, 146, 132, 147, 131, 147, 138, 20, 137, 147, 137, 146, 138, 145, 139, 145,
	140, 146, 140, 147, 139, 148, 138, 148, 138, 19, 138, 146, 139, 146, 139, 147, 138, 147, 145, 0, 0,
	0, 134, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139,
	129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 136, 142, 134, 142, 132, 141, 131, 140, 130,
	137, 130, 133, 131, 130, 132, 129, 134, 128, 130, 11, 129, 137, 129, 133, 130, 131, 140, 3, 141,
	133, 141, 137, 140, 139, 136, 0, 138, 129, 139, 130, 140, 133, 140, 137, 139, 140, 138, 141, 136,
	142, 132, 22, 133, 149, 134, 149, 135, 150, 135, 151, 134, 152, 133, 152, 132, 151, 132, 148, 136,
	145, 134, 23, 134, 150, 133, 150, 133, 151, 134, 151, 133, 21, 132, 148, 145, 0, 0, 0, 131, 14, 131,
	133, 132, 130, 133, 129, 135, 128, 138, 128, 140, 129, 141, 130, 142, 132, 132, 13, 132, 132, 133,
	130, 128, 14, 133, 142, 133, 132, 134, 129, 135, 128, 142, 14, 142, 128, 147, 128, 143, 13, 143,
	129, 139, 14, 144, 142, 144, 128, 129, 14, 131, 141, 130, 14, 131, 140, 144, 2, 145, 128, 144, 1,
	146, 128, 128, 17, 136, 150, 144, 145, 136, 149, 128, 145, 149, 0, 0, 0, 131, 14, 131, 133, 132, 130,
	133, 129, 135, 128, 138, 128, 140, 129, 141, 130, 142, 132, 132, 13, 132, 132, 133, 130, 128, 14,
	133, 142, 133, 132, 134, 129, 135, 128, 142, 14, 142, 128, 147, 128, 143, 13, 143, 129, 139, 14,
	144, 142, 144, 128, 129, 14, 131, 141, 130, 14, 131, 140, 144, 2, 145, 128, 144, 1, 146, 128, 133,
	22, 134, 149, 135, 149, 136, 150, 136, 151, 135, 152, 134, 152, 133, 151, 133, 148, 137, 145, 135,
	23, 135, 150, 134, 150, 134, 151, 135, 151, 134, 21, 133, 148, 149, 0, 0, 0, 131, 14, 137, 128, 132,
	14, 137, 130, 133, 14, 138, 130, 135, 252, 133, 250, 131, 249, 129, 249, 128, 250, 128, 252, 130,
	252, 130, 250, 129, 250, 129, 251, 141, 14, 143, 141, 138, 130, 129, 14, 136, 142, 139, 14, 145,
	142, 130, 14, 133, 140, 135, 14, 133, 141, 144, 14, 143, 141, 133, 20, 132, 147, 132, 146, 133, 145,
	134, 145, 135, 146, 135, 147, 134, 148, 133, 148, 133, 19, 133, 146, 134, 146, 134, 147, 133, 147,
	140, 20, 139, 147, 139, 146, 140, 145, 141, 145, 142, 146, 142, 147, 141, 148, 140, 148, 140, 19,
	140, 146, 141, 146, 141, 147, 140, 147, 146, 0, 0, 0, 135, 21, 132, 148, 130, 146, 129, 144, 128,
	140, 128, 137, 129, 133, 130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 133, 144,
	137, 144, 140, 143, 144, 142, 146, 140, 148, 137, 149, 135, 149, 133, 148, 131, 145, 130, 141, 130,
	136, 131, 132, 133, 129, 135, 128, 131, 18, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 141,
	3, 142, 133, 143, 136, 143, 141, 142, 144, 141, 146, 137, 0, 139, 129, 141, 132, 142, 136, 142,
	141, 141, 145, 139, 148, 137, 149, 132, 27, 131, 154, 131, 153, 132, 152, 133, 152, 134, 153, 134,
	154, 133, 155, 132, 155, 132, 26, 132, 153, 133, 153, 133, 154, 132, 154, 139, 27, 138, 154, 138,
	153, 139, 152, 140, 152, 141, 153, 141, 154, 140, 155, 139, 155, 139, 26, 139, 153, 140, 153, 140,
	154, 139, 154, 147, 0, 0, 0, 131, 21, 131, 134, 132, 131, 134, 129, 137, 128, 139, 128, 142, 129,
	144, 131, 145, 134, 145, 148, 143, 149, 132, 20, 132, 133, 133, 131, 133, 21, 133, 133, 134, 130,
	135, 129, 137, 128, 128, 21, 136, 149, 142, 21, 148, 149, 129, 21, 131, 148, 130, 21, 131, 147, 134,
	21, 133, 147, 135, 21, 133, 148, 147, 21, 145, 148, 134, 27, 133, 154, 133, 153, 134, 152, 135,
	152, 136, 153, 136, 154, 135, 155, 134, 155, 134, 26, 134, 153, 135, 153, 135, 154, 134, 154, 141,
	27, 140, 154, 140, 153, 141, 152, 142, 152, 143, 153, 143, 154, 142, 155, 141, 155, 141, 26, 141,
	153, 142, 153, 142, 154, 141, 154, 150, 0, 0, 0, 134, 14, 131, 141, 129, 139, 128, 136, 128, 134,
	129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141,
	136, 142, 134, 142, 132, 141, 131, 140, 130, 137, 130, 133, 131, 130, 132, 129, 134, 128, 130, 11,
	129, 137, 129, 133, 130, 131, 140, 3, 141, 133, 141, 137, 140, 139, 136, 0, 138, 129, 139, 130, 140,
	133, 140, 137, 139, 140, 138, 141, 136, 142, 140, 17, 142, 145, 131, 253, 129, 253, 140, 145, 141,
	17, 130, 253, 145, 0, 0, 0, 133, 2, 134, 128, 133, 1, 135, 128, 131, 2, 130, 130, 130, 131, 128, 131,
	128, 130, 129, 129, 131, 128, 131, 144, 132, 146, 134, 148, 139, 148, 141, 146, 141, 145, 139, 145,
	139, 146, 137, 147, 133, 0, 133, 144, 134, 146, 135, 147, 132, 1, 132, 144, 133, 146, 134, 147, 139,
	147, 140, 146, 140, 145, 130, 2, 129, 131, 129, 130, 131, 128, 141, 128, 142, 129, 142, 131, 139,
	128, 138, 0, 140, 130, 140, 131, 142, 131, 141, 129, 128, 12, 128, 138, 129, 139, 135, 139, 136,
	138, 137, 138, 137, 139, 136, 140, 128, 140, 129, 2, 130, 129, 131, 129, 136, 11, 137, 138, 148, 0,
	0, 0, 135, 21, 132, 148, 130, 146, 129, 144, 128, 140, 128, 137, 129, 133, 130, 131, 132, 129,
	135, 128, 137, 128, 140, 129, 142, 131, 143, 133, 144, 137, 144, 140, 143, 144, 142, 146, 140, 148,
	137, 149, 135, 149, 133, 148, 131, 145, 130, 141, 130, 136, 131, 132, 133, 129, 135, 128, 131, 18,
	130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 141, 3, 142, 133, 143, 136, 143, 141, 142, 144,
	141, 146, 137, 0, 139, 129, 141, 132, 142, 136, 142, 141, 141, 145, 139, 148, 137, 149, 143, 24,
	144, 152, 129, 253, 128, 253, 143, 152, 147, 0, 0, 0, 128, 24, 140, 152, 143, 151, 144, 150, 145,
	148, 145, 145, 144, 143, 143, 142, 140, 141, 133, 141, 143, 22, 144, 148, 144, 145, 143, 143, 140,
	24, 142, 151, 143, 149, 143, 144, 142, 142, 140, 141, 129, 24, 131, 151, 130, 24, 131, 150, 134,
	24, 133, 150, 135, 24, 133, 151, 131, 24, 131, 128, 133, 128, 133, 152, 132, 23, 132, 129, 131, 2,
	130, 128, 133, 2, 134, 128, 128, 0, 136, 128, 131, 1, 129, 128, 133, 1, 135, 128, 145, 16, 145, 133,
	146, 130, 147, 129, 149, 128, 148, 129, 147, 132, 147, 146, 145, 144, 154, 3, 153, 129, 151, 128,
	149, 128, 146, 16, 146, 132, 147, 130, 142, 11, 151, 139, 157, 0, 0, 0, 134, 122, 135, 251, 136, 253,
	136, 141, 138, 13, 138, 253, 137, 251, 135, 249, 130, 249, 128, 251, 128, 252, 130, 252, 130, 251,
	132, 250, 137, 13, 137, 253, 136, 251, 135, 250, 130, 250, 129, 251, 129, 252, 136, 1, 136, 145,
	137, 147, 139, 149, 144, 149, 146, 147, 146, 146, 144, 146, 144, 147, 142, 148, 138, 1, 138, 145,
	139, 147, 140, 148, 137, 2, 137, 145, 138, 147, 139, 148, 144, 148, 145, 147, 145, 146, 141, 7, 141,
	137, 140, 136, 134, 136, 133, 137, 132, 137, 132, 136, 133, 135, 141, 135, 137, 8, 137, 135, 136, 7,
	138, 135, 133, 8, 132, 137, 149, 0, 0, 0, 130, 11, 130, 140, 131, 140, 131, 138, 129, 138, 129, 140,
	130, 141, 132, 142, 136, 142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 143, 128,
	138, 12, 139, 138, 139, 131, 140, 129, 136, 14, 137, 141, 138, 139, 138, 131, 139, 129, 142, 128,
	138, 9, 137, 136, 132, 135, 129, 134, 128, 132, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129,
	138, 131, 130, 6, 129, 132, 129, 131, 130, 129, 137, 8, 133, 135, 131, 134, 130, 132, 130, 131, 131,
	129, 132, 128, 137, 22, 136, 149, 135, 149, 134, 150, 134, 151, 135, 152, 136, 152, 137, 151, 137,
	148, 133, 145, 135, 23, 135, 150, 136, 150, 136, 151, 135, 151, 136, 21, 137, 148, 145, 0, 0, 0, 131,
	14, 131, 128, 132, 13, 132, 129, 128, 14, 133, 142, 133, 128, 128, 0, 136, 128, 129, 14, 131, 141,
	130, 14, 131, 140, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128, 133, 1, 135, 128, 134, 22,
	133, 149, 132, 149, 131, 150, 131, 151, 132, 152, 133, 152, 134, 151, 134, 148, 130, 145, 132, 23,
	132, 150, 133, 150, 133, 151, 132, 151, 133, 21, 134, 148, 138, 0, 0, 0, 134, 14, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 136,
	141, 139, 139, 141, 136, 142, 134, 142, 132, 141, 131, 140, 130, 137, 130, 133, 131, 130, 132, 129,
	134, 128, 130, 11, 129, 137, 129, 133, 130, 131, 140, 3, 141, 133, 141, 137, 140, 139, 136, 0, 138,
	129, 139, 130, 140, 133, 140, 137, 139, 140, 138, 141, 136, 142, 138, 22, 137, 149, 136, 149, 135,
	150, 135, 151, 136, 152, 137, 152, 138, 151, 138, 148, 134, 145, 136, 23, 136, 150, 137, 150, 137,
	151, 136, 151, 137, 21, 138, 148, 145, 0, 0, 0, 131, 14, 131, 133, 132, 130, 133, 129, 135, 128, 138,
	128, 140, 129, 141, 130, 142, 132, 132, 13, 132, 132, 133, 130, 128, 14, 133, 142, 133, 132, 134,
	129, 135, 128, 142, 14, 142, 128, 147, 128, 143, 13, 143, 129, 139, 14, 144, 142, 144, 128, 129, 14,
	131, 141, 130, 14, 131, 140, 144, 2, 145, 128, 144, 1, 146, 128, 140, 22, 139, 149, 138, 149, 137,
	150, 137, 151, 138, 152, 139, 152, 140, 151, 140, 148, 136, 145, 138, 23, 138, 150, 139, 150, 139,
	151, 138, 151, 139, 21, 140, 148, 149, 0, 0, 0, 131, 14, 131, 128, 132, 13, 132, 129, 128, 14, 133,
	142, 133, 128, 133, 10, 134, 140, 135, 141, 137, 142, 140, 142, 142, 141, 143, 140, 144, 137, 144,
	128, 142, 12, 143, 137, 143, 129, 140, 14, 141, 141, 142, 138, 142, 128, 128, 0, 136, 128, 139, 0,
	147, 128, 129, 14, 131, 141, 130, 14, 131, 140, 131, 1, 129, 128, 131, 2, 130, 128, 133, 2, 134, 128,
	133, 1, 135, 128, 142, 1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 144, 1, 146, 128, 143, 23,
	138, 145, 133, 148, 128, 147, 133, 151, 138, 147, 143, 151, 138, 146, 133, 149, 128, 147, 149, 0, 0,
	0, 143, 21, 145, 148, 145, 128, 131, 149, 131, 129, 129, 128, 132, 21, 144, 131, 128, 21, 133,
	149, 145, 131, 142, 21, 148, 149, 128, 0, 134, 128, 129, 21, 131, 148, 147, 21, 145, 148, 131, 1,
	133, 128, 146, 30, 141, 152, 136, 155, 131, 154, 136, 158, 141, 154, 146, 158, 141, 153, 136, 156,
	131, 154, 150, 0, 0, 0, 130, 18, 130, 147, 131, 147, 131, 145, 129, 145, 129, 147, 130, 148, 132,
	149, 136, 149, 138, 148, 139, 147, 140, 145, 140, 138, 141, 136, 142, 135, 143, 135, 138, 19, 139,
	145, 139, 138, 140, 136, 136, 21, 137, 148, 138, 146, 138, 138, 139, 136, 142, 135, 138, 16, 137,
	143, 132, 142, 129, 141, 128, 139, 128, 138, 129, 136, 132, 135, 135, 135, 137, 136, 138, 138, 130,
	13, 129, 139, 129, 138, 130, 136, 137, 15, 133, 142, 131, 141, 130, 139, 130, 138, 131, 136, 132,
	135, 128, 0, 143, 128, 145, 0, 0, 0, 128, 15, 129, 140, 131, 138, 134, 137, 136, 137, 139, 138, 141,
	140, 142, 143, 141, 146, 139, 148, 136, 149, 134, 149, 131, 148, 129, 146, 128, 143, 130, 18, 129,
	144, 129, 142, 130, 140, 140, 12, 141, 142, 141, 144, 140, 146, 134, 21, 132, 148, 131, 147, 130,
	144, 130, 142, 131, 139, 132, 138, 134, 137, 136, 9, 138, 138, 139, 139, 140, 142, 140, 144, 139,
	147, 138, 148, 136, 149, 128, 0, 142, 128, 145, 0, 0, 0, 140, 5, 140, 132, 139, 132, 139, 134, 141,
	134, 141, 132, 140, 130, 139, 129, 137, 128, 133, 128, 130, 129, 129, 130, 128, 132, 128, 134, 129,
	136, 130, 137, 134, 139, 135, 139, 135, 142, 134, 142, 134, 139, 130, 2, 129, 131, 129, 135, 130,
	136, 133, 0, 131, 129, 130, 131, 130, 135, 131, 137, 132, 138, 135, 18, 136, 147, 136, 148, 135,
	149, 134, 149, 133, 148, 133, 147, 134, 146, 135, 146, 135, 19, 135, 148, 134, 148, 134, 147, 135,
	147, 144, 0, 0, 0, 128, 0, 128, 135, 140, 135, 140, 132, 131, 132, 131, 128, 128, 128, 145, 0, 0, 0,
	140, 0, 140, 135, 128, 135, 128, 132, 137, 132, 137, 128, 140, 128, 145, 0, 0, 0, 131, 19, 131, 138,
	128, 17, 130, 146, 133, 149, 133, 138, 131, 11, 129, 138, 135, 138, 133, 139, 131, 12, 130, 138,
	133, 12, 134, 138, 132, 19, 132, 138, 145, 21, 129, 128, 137, 0, 137, 131, 138, 133, 140, 134, 145,
	135, 146, 136, 146, 138, 145, 139, 141, 139, 139, 138, 139, 137, 141, 11, 139, 138, 137, 2, 138,
	131, 139, 131, 141, 128, 144, 128, 145, 129, 146, 131, 146, 133, 146, 3, 144, 130, 142, 130, 139,
	131, 142, 129, 144, 129, 145, 130, 146, 9, 145, 136, 140, 134, 143, 134, 146, 135, 146, 136, 141, 6,
	142, 134, 151, 0, 0, 0, 131, 19, 131, 138, 128, 17, 130, 146, 133, 149, 133, 138, 131, 11, 129, 138,
	135, 138, 133, 139, 131, 12, 130, 138, 133, 12, 134, 138, 132, 19, 132, 138, 141, 10, 141, 128, 137,
	0, 145, 128, 140, 1, 138, 128, 140, 2, 139, 128, 142, 2, 143, 128, 142, 1, 144, 128, 145, 4, 135,
	132, 142, 139, 142, 128, 140, 9, 140, 128, 146, 21, 146, 149, 128, 128, 151, 0, 0, 0, 130, 11, 131,
	131, 131, 129, 130, 128, 130, 142, 129, 142, 129, 128, 128, 129, 128, 131, 129, 139, 129, 0, 130,
	128, 129, 18, 128, 147, 128, 148, 129, 149, 130, 149, 131, 148, 131, 147, 130, 146, 129, 146, 129,
	19, 129, 148, 130, 148, 130, 147, 129, 147, 135, 0, 0, 0, 137, 17, 128, 138, 137, 132, 146, 17, 137,
	138, 146, 132, 150, 0, 0, 0, 137, 17, 146, 138, 137, 132, 128, 17, 137, 138, 128, 132, 150, 0, 0, 0,
	128, 18, 130, 146, 130, 144, 128, 144, 128, 146, 129, 18, 129, 144, 128, 12, 130, 140, 130, 138,
	128, 138, 128, 140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129,
	132, 128, 0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254, 132, 21, 134, 149, 134, 147,
	132, 147, 132, 149, 133, 21, 133, 147, 132, 15, 134, 143, 134, 141, 132, 141, 132, 143, 133, 15,
	133, 141, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133, 135, 132, 3, 134, 131, 134,
	129, 132, 129, 132, 131, 133, 3, 133, 129, 136, 18, 138, 146, 138, 144, 136, 144, 136, 146, 137, 18,
	137, 144, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138, 136, 6, 138, 134, 138,
	132, 136, 132, 136, 134, 137, 6, 137, 132, 136, 0, 138, 128, 138, 254, 136, 254, 136, 128, 137, 0,
	137, 254, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21, 141, 147, 140, 15, 142, 143,
	142, 141, 140, 141, 140, 143, 141, 15, 141, 141, 140, 9, 142, 137, 142, 135, 140, 135, 140, 137,
	141, 9, 141, 135, 140, 3, 142, 131, 142, 129, 140, 129, 140, 131, 141, 3, 141, 129, 132, 125, 134,
	253, 134, 251, 132, 251, 132, 253, 133, 125, 133, 251, 140, 125, 142, 253, 142, 251, 140, 251, 140,
	253, 141, 125, 141, 251, 142, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128, 144, 128, 146, 129, 18, 129,
	144, 128, 12, 130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132,
	128, 132, 128, 134, 129, 6, 129, 132, 128, 0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129,
	254, 130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131, 147, 130, 15, 132, 143, 132,
	141, 130, 141, 130, 143, 131, 15, 131, 141, 130, 9, 132, 137, 132, 135, 130, 135, 130, 137, 131, 9,
	131, 135, 130, 3, 132, 131, 132, 129, 130, 129, 130, 131, 131, 3, 131, 129, 132, 18, 134, 146, 134,
	144, 132, 144, 132, 146, 133, 18, 133, 144, 132, 12, 134, 140, 134, 138, 132, 138, 132, 140, 133,
	12, 133, 138, 132, 6, 134, 134, 134, 132, 132, 132, 132, 134, 133, 6, 133, 132, 132, 0, 134, 128,
	134, 254, 132, 254, 132, 128, 133, 0, 133, 254, 134, 21, 136, 149, 136, 147, 134, 147, 134, 149,
	135, 21, 135, 147, 134, 15, 136, 143, 136, 141, 134, 141, 134, 143, 135, 15, 135, 141, 134, 9, 136,
	137, 136, 135, 134, 135, 134, 137, 135, 9, 135, 135, 134, 3, 136, 131, 136, 129, 134, 129, 134, 131,
	135, 3, 135, 129, 136, 18, 138, 146, 138, 144, 136, 144, 136, 146, 137, 18, 137, 144, 136, 12, 138,
	140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138, 136, 6, 138, 134, 138, 132, 136, 132, 136,
	134, 137, 6, 137, 132, 136, 0, 138, 128, 138, 254, 136, 254, 136, 128, 137, 0, 137, 254, 138, 21,
	140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139, 147, 138, 15, 140, 143, 140, 141, 138, 141,
	138, 143, 139, 15, 139, 141, 138, 9, 140, 137, 140, 135, 138, 135, 138, 137, 139, 9, 139, 135, 138,
	3, 140, 131, 140, 129, 138, 129, 138, 131, 139, 3, 139, 129, 140, 18, 142, 146, 142, 144, 140,
	144, 140, 146, 141, 18, 141, 144, 140, 12, 142, 140, 142, 138, 140, 138, 140, 140, 141, 12, 141,
	138, 140, 6, 142, 134, 142, 132, 140, 132, 140, 134, 141, 6, 141, 132, 140, 0, 142, 128, 142, 254,
	140, 254, 140, 128, 141, 0, 141, 254, 142, 21, 144, 149, 144, 147, 142, 147, 142, 149, 143, 21, 143,
	147, 142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 143, 15, 143, 141, 142, 9, 144, 137, 144, 135,
	142, 135, 142, 137, 143, 9, 143, 135, 142, 3, 144, 131, 144, 129, 142, 129, 142, 131, 143, 3, 143,
	129, 130, 125, 132, 253, 132, 251, 130, 251, 130, 253, 131, 125, 131, 251, 134, 125, 136, 253, 136,
	251, 134, 251, 134, 253, 135, 125, 135, 251, 138, 125, 140, 253, 140, 251, 138, 251, 138, 253, 139,
	125, 139, 251, 142, 125, 144, 253, 144, 251, 142, 251, 142, 253, 143, 125, 143, 251, 144, 0, 0, 0,
	128, 21, 130, 149, 130, 147, 128, 147, 128, 149, 129, 21, 129, 147, 130, 21, 132, 149, 132, 147,
	130, 147, 130, 149, 131, 21, 131, 147, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21,
	139, 147, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21, 141, 147, 148, 21, 150, 149,
	150, 147, 148, 147, 148, 149, 149, 21, 149, 147, 150, 21, 152, 149, 152, 147, 150, 147, 150, 149,
	151, 21, 151, 147, 132, 17, 134, 145, 134, 143, 132, 143, 132, 145, 133, 17, 133, 143, 134, 17, 136,
	145, 136, 143, 134, 143, 134, 145, 135, 17, 135, 143, 136, 17, 138, 145, 138, 143, 136, 143, 136,
	145, 137, 17, 137, 143, 128, 13, 130, 141, 130, 139, 128, 139, 128, 141, 129, 13, 129, 139, 130, 13,
	132, 141, 132, 139, 130, 139, 130, 141, 131, 13, 131, 139, 138, 13, 140, 141, 140, 139, 138, 139,
	138, 141, 139, 13, 139, 139, 140, 13, 142, 141, 142, 139, 140, 139, 140, 141, 141, 13, 141, 139,
	148, 13, 150, 141, 150, 139, 148, 139, 148, 141, 149, 13, 149, 139, 150, 13, 152, 141, 152, 139,
	150, 139, 150, 141, 151, 13, 151, 139, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143,
	135, 144, 9, 146, 137, 146, 135, 144, 135, 144, 137, 145, 9, 145, 135, 146, 9, 148, 137, 148, 135,
	146, 135, 146, 137, 147, 9, 147, 135, 128, 5, 130, 133, 130, 131, 128, 131, 128, 133, 129, 5, 129,
	131, 130, 5, 132, 133, 132, 131, 130, 131, 130, 133, 131, 5, 131, 131, 138, 5, 140, 133, 140, 131,
	138, 131, 138, 133, 139, 5, 139, 131, 140, 5, 142, 133, 142, 131, 140, 131, 140, 133, 141, 5, 141,
	131, 148, 5, 150, 133, 150, 131, 148, 131, 148, 133, 149, 5, 149, 131, 150, 5, 152, 133, 152, 131,
	150, 131, 150, 133, 151, 5, 151, 131, 132, 1, 138, 129, 138, 255, 132, 255, 132, 129, 133, 1, 133,
	255, 135, 1, 135, 255, 137, 1, 137, 255, 128, 125, 130, 253, 130, 251, 128, 251, 128, 253, 129, 125,
	129, 251, 130, 125, 132, 253, 132, 251, 130, 251, 130, 253, 131, 125, 131, 251, 138, 125, 142, 253,
	142, 251, 138, 251, 138, 253, 139, 125, 139, 251, 141, 125, 141, 251, 148, 125, 152, 253, 152, 251,
	148, 251, 148, 253, 149, 125, 149, 251, 151, 125, 151, 251, 146, 17, 148, 145, 148, 143, 146, 143,
	146, 145, 147, 17, 147, 143, 148, 17, 150, 145, 150, 143, 148, 143, 148, 145, 149, 17, 149, 143,
	150, 17, 152, 145, 152, 143, 150, 143, 150, 145, 151, 17, 151, 143, 128, 9, 130, 137, 130, 135, 128,
	135, 128, 137, 129, 9, 129, 135, 130, 9, 132, 137, 132, 135, 130, 135, 130, 137, 131, 9, 131, 135,
	132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133, 135, 146, 1, 152, 129, 152, 255, 146,
	255, 146, 129, 147, 1, 147, 255, 149, 1, 149, 255, 151, 1, 151, 255, 136, 1, 136, 255, 134, 1, 134,
	255, 148, 1, 148, 255, 150, 1, 150, 255, 150, 125, 150, 251, 140, 125, 140, 251, 152, 0, 0, 0, 128,
	21, 128, 249, 132, 0, 0, 0, 136, 121, 136, 149, 128, 4, 136, 132, 140, 0, 0, 0, 136, 21, 136, 249,
	128, 10, 136, 138, 128, 4, 136, 132, 140, 0, 0, 0, 136, 121, 136, 149, 128, 4, 136, 132, 144, 121,
	144, 149, 148, 0, 0, 0, 128, 4, 144, 132, 144, 249, 136, 4, 136, 249, 148, 0, 0, 0, 128, 10, 136, 138,
	136, 249, 128, 4, 136, 132, 141, 0, 0, 0, 128, 4, 136, 132, 136, 249, 144, 121, 144, 149, 128, 10,
	136, 138, 136, 149, 149, 0, 0, 0, 136, 121, 136, 149, 144, 121, 144, 149, 148, 0, 0, 0, 128, 10, 144,
	138, 144, 249, 128, 4, 136, 132, 136, 249, 148, 0, 0, 0, 128, 4, 144, 132, 144, 149, 128, 10, 136,
	138, 136, 149, 148, 0, 0, 0, 128, 10, 144, 138, 144, 149, 136, 10, 136, 149, 148, 0, 0, 0, 128, 4, 136,
	132, 136, 149, 128, 10, 136, 138, 140, 0, 0, 0, 128, 4, 136, 132, 136, 249, 140, 0, 0, 0, 136, 10, 128,
	138, 128, 149, 136, 0, 0, 0, 128, 10, 136, 138, 136, 149, 144, 10, 136, 138, 144, 0, 0, 0, 128, 4, 136,
	132, 136, 249, 144, 4, 136, 132, 144, 0, 0, 0, 128, 121, 128, 149, 136, 4, 128, 132, 136, 0, 0, 0, 128,
	4, 144, 132, 144, 0, 0, 0, 136, 121, 136, 149, 128, 4, 144, 132, 144, 0, 0, 0, 128, 21, 128, 249,
	136, 10, 128, 138, 136, 4, 128, 132, 136, 0, 0, 0, 136, 121, 136, 149, 144, 4, 136, 132, 128, 121,
	128, 149, 144, 0, 0, 0, 144, 4, 128, 132, 128, 149, 144, 10, 136, 138, 136, 149, 144, 0, 0, 0, 144, 10,
	128, 138, 128, 249, 144, 4, 136, 132, 136, 249, 144, 0, 0, 0, 128, 4, 152, 132, 128, 10, 136, 138,
	136, 149, 144, 21, 144, 138, 152, 138, 152, 0, 0, 0, 128, 10, 152, 138, 128, 4, 136, 132, 136, 249,
	144, 121, 144, 132, 152, 132, 152, 0, 0, 0, 144, 4, 136, 132, 136, 249, 128, 121, 128, 149, 144, 10,
	136, 138, 136, 149, 144, 0, 0, 0, 128, 4, 144, 132, 128, 10, 144, 138, 144, 0, 0, 0, 128, 4, 136, 132,
	136, 249, 128, 10, 136, 138, 136, 149, 144, 21, 144, 138, 152, 138, 144, 121, 144, 132, 152, 132,
	152, 0, 0, 0, 128, 10, 136, 138, 136, 149, 144, 10, 136, 138, 128, 4, 144, 132, 144, 0, 0, 0, 128, 10,
	144, 138, 134, 21, 134, 138, 142, 21, 142, 138, 144, 0, 0, 0, 128, 4, 136, 132, 136, 249, 144, 4, 136,
	132, 128, 10, 144, 138, 144, 0, 0, 0, 128, 4, 144, 132, 134, 121, 134, 132, 142, 121, 142, 132, 144,
	0, 0, 0, 144, 10, 128, 138, 128, 149, 136, 10, 136, 149, 144, 0, 0, 0, 136, 4, 128, 132, 128, 149,
	136, 10, 128, 138, 136, 0, 0, 0, 136, 10, 128, 138, 128, 249, 136, 4, 128, 132, 136, 0, 0, 0, 144, 4,
	128, 132, 128, 249, 136, 4, 136, 249, 144, 0, 0, 0, 136, 121, 136, 149, 128, 4, 152, 132, 144, 121,
	144, 149, 152, 0, 0, 0, 136, 21, 136, 249, 128, 10, 144, 138, 128, 4, 144, 132, 144, 0, 0, 0, 128, 10,
	136, 138, 136, 149, 140, 0, 0, 0, 136, 4, 128, 132, 128, 249, 136, 0, 0, 0, 128, 21, 144, 149, 144,
	128, 128, 128, 128, 149, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128,
	133, 0, 133, 149, 134, 21, 134, 128, 135, 21, 135, 128, 136, 21, 136, 128, 137, 21, 137, 128, 138, 0,
	138, 149, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142, 21, 142, 128, 143, 21, 143,
	128, 128, 11, 144, 139, 144, 0, 0, 0, 144, 0, 128, 128, 128, 139, 144, 139, 144, 128, 129, 11, 129,
	128, 130, 11, 130, 128, 131, 11, 131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134, 11, 134, 128,
	135, 11, 135, 128, 136, 11, 136, 128, 137, 11, 137, 128, 138, 11, 138, 128, 139, 11, 139, 128, 140,
	11, 140, 128, 141, 11, 141, 128, 142, 11, 142, 128, 143, 11, 143, 128, 144, 0, 0, 0, 128, 0, 128,
	149, 136, 149, 136, 128, 128, 128, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21,
	132, 128, 133, 0, 133, 149, 134, 21, 134, 128, 135, 21, 135, 128, 136, 0, 0, 0, 137, 0, 137, 149, 145,
	149, 145, 128, 137, 128, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128,
	142, 0, 142, 149, 143, 21, 143, 128, 144, 21, 144, 128, 145, 0, 0, 0, 144, 10, 128, 138, 128, 149,
	144, 149, 144, 138, 129, 21, 129, 138, 130, 21, 130, 138, 131, 21, 131, 138, 132, 21, 132, 138, 133,
	21, 133, 138, 134, 21, 134, 138, 135, 21, 135, 138, 136, 21, 136, 138, 137, 21, 137, 138, 138, 21,
	138, 138, 139, 21, 139, 138, 140, 21, 140, 138, 141, 21, 141, 138, 142, 21, 142, 138, 143, 21, 143,
	138, 144, 0, 0, 0, 134, 0, 132, 129, 131, 130, 130, 133, 130, 137, 131, 140, 132, 141, 134, 142, 131,
	141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 149,
	142, 147, 142, 139, 130, 138, 129, 136, 128, 136, 14, 138, 141, 139, 140, 147, 128, 149, 128, 141,
	139, 139, 141, 136, 142, 134, 142, 130, 11, 129, 137, 129, 133, 130, 131, 148, 0, 140, 139, 148, 14,
	139, 129, 152, 0, 0, 0, 130, 1, 139, 129, 141, 131, 141, 134, 139, 136, 141, 138, 141, 142, 139, 144,
	130, 144, 128, 142, 128, 255, 130, 255, 130, 141, 132, 143, 138, 143, 140, 141, 140, 139, 138, 137,
	130, 137, 128, 0, 128, 254, 130, 254, 130, 255, 130, 8, 138, 136, 140, 134, 140, 131, 139, 130, 130,
	130, 131, 16, 129, 142, 129, 254, 130, 14, 132, 144, 139, 15, 140, 142, 140, 10, 139, 137, 145, 0, 0,
	0, 128, 0, 128, 143, 140, 143, 140, 140, 138, 140, 138, 141, 130, 141, 130, 128, 128, 128, 139,
	13, 139, 142, 129, 142, 129, 128, 144, 0, 0, 0, 131, 14, 131, 128, 133, 128, 133, 142, 138, 142,
	138, 128, 140, 128, 140, 142, 142, 142, 142, 144, 128, 144, 128, 142, 131, 142, 128, 15, 142, 143,
	139, 15, 139, 128, 132, 15, 132, 128, 131, 0, 133, 128, 146, 0, 0, 0, 144, 3, 144, 128, 128, 128, 135,
	139, 128, 149, 144, 149, 144, 146, 148, 0, 0, 0, 134, 0, 132, 129, 131, 130, 130, 133, 131, 136, 132,
	137, 134, 138, 139, 141, 151, 141, 152, 142, 140, 142, 131, 137, 129, 135, 128, 133, 128, 132, 131,
	129, 134, 128, 136, 128, 139, 129, 142, 132, 142, 133, 141, 135, 139, 137, 136, 138, 134, 138, 131,
	137, 139, 142, 140, 142, 136, 0, 138, 129, 139, 130, 140, 133, 139, 136, 138, 137, 136, 138, 130, 7,
	129, 133, 130, 131, 140, 3, 141, 133, 140, 135, 153, 0, 0, 0, 131, 14, 131, 133, 132, 130, 133, 129,
	135, 128, 138, 128, 140, 129, 141, 130, 142, 132, 132, 13, 132, 132, 133, 130, 128, 14, 133, 142,
	133, 132, 134, 129, 135, 128, 142, 14, 142, 128, 147, 128, 143, 13, 143, 129, 139, 14, 144, 142,
	144, 128, 129, 14, 131, 141, 130, 14, 131, 140, 144, 2, 145, 128, 144, 1, 146, 128, 132, 2, 132, 252,
	128, 248, 131, 248, 134, 251, 134, 129, 133, 1, 133, 251, 130, 248, 132, 123, 130, 249, 150, 0, 0, 0,
	136, 124, 136, 138, 134, 140, 131, 140, 130, 139, 130, 136, 128, 136, 128, 140, 130, 142, 133, 142,
	137, 140, 138, 138, 138, 252, 136, 252, 129, 9, 129, 140, 130, 141, 133, 141, 135, 140, 137, 138,
	137, 252, 130, 12, 130, 139, 138, 8, 144, 142, 146, 142, 138, 135, 138, 136, 145, 142, 138, 6, 146,
	142, 149, 0, 0, 0, 134, 14, 131, 141, 129, 139, 128, 137, 128, 136, 131, 133, 134, 132, 136, 132,
	139, 133, 142, 136, 142, 137, 141, 139, 139, 141, 136, 142, 134, 142, 132, 141, 131, 140, 130, 137,
	131, 134, 132, 133, 134, 132, 136, 4, 138, 133, 139, 134, 140, 137, 139, 140, 138, 141, 136, 142,
	130, 11, 129, 137, 130, 135, 140, 7, 141, 137, 140, 139, 128, 21, 128, 148, 142, 148, 142, 149, 128,
	149, 135, 20, 135, 142, 135, 4, 135, 254, 128, 126, 142, 254, 142, 253, 128, 253, 128, 254, 146, 0,
	0, 0, 135, 21, 132, 148, 130, 146, 129, 144, 128, 140, 128, 137, 129, 133, 130, 131, 132, 129,
	135, 128, 137, 128, 140, 129, 142, 131, 143, 133, 144, 137, 144, 140, 143, 144, 142, 146, 140, 148,
	137, 149, 135, 149, 133, 148, 131, 145, 130, 141, 130, 136, 131, 132, 133, 129, 135, 128, 131, 18,
	130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 141, 3, 142, 133, 143, 136, 143, 141, 142, 144,
	141, 146, 137, 0, 139, 129, 141, 132, 142, 136, 142, 141, 141, 145, 139, 148, 137, 149, 130, 12,
	142, 140, 130, 11, 142, 139, 148, 0, 0, 0, 130, 8, 130, 141, 131, 145, 133, 148, 135, 149, 132, 148,
	130, 146, 129, 144, 128, 140, 128, 137, 129, 136, 129, 141, 130, 144, 131, 146, 141, 18, 142, 144,
	143, 141, 143, 137, 141, 136, 138, 133, 138, 129, 139, 0, 139, 133, 141, 135, 143, 136, 144, 137,
	144, 140, 143, 144, 142, 146, 140, 148, 137, 149, 135, 149, 139, 1, 144, 129, 144, 128, 137, 128,
	137, 133, 140, 136, 142, 137, 142, 141, 141, 145, 139, 148, 137, 149, 143, 10, 143, 137, 129, 9,
	131, 136, 134, 133, 134, 129, 133, 0, 133, 133, 131, 135, 129, 136, 133, 1, 128, 129, 128, 128, 135,
	128, 135, 133, 132, 136, 130, 137, 148, 0, 0, 0, 134, 10, 131, 137, 129, 135, 128, 133, 128, 132,
	131, 129, 134, 128, 136, 128, 139, 129, 142, 132, 142, 133, 141, 135, 139, 137, 136, 138, 134, 138,
	132, 137, 131, 136, 130, 133, 131, 130, 132, 129, 134, 128, 136, 0, 138, 129, 139, 130, 140, 133,
	139, 136, 138, 137, 136, 138, 128, 149, 142, 148, 142, 149, 128, 149, 130, 7, 129, 133, 130, 131,
	140, 3, 141, 133, 140, 135, 137, 10, 130, 148, 141, 148, 139, 9, 129, 149, 146, 0, 0, 0, 134, 10, 131,
	137, 129, 135, 128, 133, 128, 132, 131, 129, 134, 128, 136, 128, 139, 129, 142, 132, 142, 133, 141,
	135, 139, 137, 136, 138, 134, 138, 132, 137, 131, 136, 130, 133, 131, 130, 132, 129, 134, 128, 136,
	0, 138, 129, 139, 130, 140, 133, 139, 136, 138, 137, 136, 138, 130, 7, 129, 133, 130, 131, 140, 3,
	141, 133, 140, 135, 146, 10, 143, 137, 141, 135, 140, 133, 140, 132, 143, 129, 146, 128, 148, 128,
	151, 129, 154, 132, 154, 133, 153, 135, 151, 137, 148, 138, 146, 138, 144, 137, 143, 136, 142, 133,
	143, 130, 144, 129, 146, 128, 148, 0, 150, 129, 151, 130, 152, 133, 151, 136, 150, 137, 148, 138,
	142, 7, 141, 133, 142, 131, 152, 3, 153, 133, 152, 135, 158, 0, 0, 0, 134, 14, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 136,
	141, 139, 139, 141, 136, 142, 134, 142, 132, 141, 131, 140, 130, 137, 130, 133, 131, 130, 132, 129,
	134, 128, 130, 11, 129, 137, 129, 133, 130, 131, 140, 3, 141, 133, 141, 137, 140, 139, 136, 0, 138,
	129, 139, 130, 140, 133, 140, 137, 139, 140, 138, 141, 136, 142, 140, 17, 142, 145, 131, 253, 129,
	253, 140, 145, 141, 17, 130, 253, 145, 0, 0, 0, 144, 21, 131, 149, 128, 147, 128, 139, 135, 139, 144,
	0, 131, 128, 128, 130, 128, 139, 148, 0, 0, 0, 131, 0, 131, 143, 132, 146, 134, 148, 137, 149, 139,
	149, 142, 148, 144, 146, 145, 143, 145, 129, 143, 128, 132, 1, 132, 144, 133, 146, 133, 0, 133, 144,
	134, 147, 135, 148, 137, 149, 128, 0, 136, 128, 142, 0, 148, 128, 129, 0, 131, 129, 130, 0, 131, 130,
	134, 0, 133, 130, 135, 0, 133, 129, 147, 0, 145, 129, 151, 0, 0, 0, 128, 9, 145, 137, 145, 136, 128,
	136, 128, 137, 128, 14, 145, 142, 145, 141, 128, 141, 128, 142, 128, 4, 145, 132, 145, 131, 128,
	131, 128, 132, 149, 0, 0, 0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 136, 21, 136, 132, 137,
	132, 137, 149, 136, 149, 128, 13, 145, 141, 145, 140, 128, 140, 128, 141, 150, 0, 0, 0, 128, 1, 145,
	129, 145, 128, 128, 128, 128, 129, 129, 21, 145, 141, 145, 140, 129, 132, 128, 132, 144, 140, 144,
	141, 128, 149, 129, 149, 150, 0, 0, 0, 145, 1, 128, 129, 128, 128, 145, 128, 145, 129, 144, 21, 128,
	141, 128, 140, 144, 132, 145, 132, 129, 140, 129, 141, 145, 149, 144, 149, 150, 0, 0, 0, 132, 20,
	131, 147, 130, 145, 130, 249, 128, 249, 128, 145, 129, 147, 131, 149, 136, 149, 138, 147, 138, 146,
	136, 146, 136, 147, 134, 148, 129, 121, 129, 145, 130, 147, 131, 148, 136, 148, 137, 147, 137, 146,
	142, 0, 0, 0, 134, 122, 135, 251, 136, 253, 136, 149, 138, 149, 138, 253, 137, 251, 135, 249, 130,
	249, 128, 251, 128, 252, 130, 252, 130, 251, 132, 250, 137, 21, 137, 253, 136, 251, 135, 250, 130,
	250, 129, 251, 129, 252, 142, 0, 0, 0, 128, 11, 145, 139, 145, 138, 128, 138, 128, 139, 136, 21, 135,
	148, 135, 147, 136, 146, 137, 146, 138, 147, 138, 148, 137, 149, 136, 149, 136, 20, 136, 147, 137,
	147, 137, 148, 136, 148, 136, 3, 135, 130, 135, 129, 136, 128, 137, 128, 138, 129, 138, 130, 137,
	131, 136, 131, 136, 2, 136, 129, 137, 129, 137, 130, 136, 130, 149, 0, 0, 0, 143, 16, 138, 138, 133,
	141, 128, 140, 133, 144, 138, 140, 143, 144, 138, 139, 133, 142, 128, 140, 143, 9, 138, 131, 133,
	134, 128, 133, 133, 137, 138, 133, 143, 137, 138, 132, 133, 135, 128, 133, 147, 0, 0, 0, 134, 21,
	131, 148, 129, 146, 128, 144, 128, 143, 131, 140, 134, 139, 136, 139, 139, 140, 142, 143, 142, 144,
	141, 146, 139, 148, 136, 149, 134, 149, 132, 148, 131, 147, 130, 144, 131, 141, 132, 140, 134, 139,
	136, 11, 138, 140, 139, 141, 140, 144, 139, 147, 138, 148, 136, 149, 130, 18, 129, 144, 130, 142,
	140, 14, 141, 144, 140, 146, 145, 0, 0, 0, 128, 4, 131, 132, 131, 128, 128, 128, 128, 132, 129, 4,
	129, 128, 130, 4, 130, 128, 128, 2, 131, 130, 134, 0, 0, 0, 131, 0, 128, 128, 128, 130, 131, 130, 131,
	128, 130, 2, 130, 128, 129, 2, 129, 128, 134, 0, 0, 0, 128, 11, 128, 137, 136, 128, 136, 149, 146,
	149, 146, 146, 144, 146, 144, 147, 138, 147, 138, 128, 136, 128, 136, 132, 128, 139, 128, 136, 136,
	3, 128, 138, 136, 130, 137, 21, 137, 128, 137, 20, 146, 148, 145, 20, 145, 146, 128, 10, 136, 129,
	149, 0, 0, 0, 128, 21, 133, 149, 133, 139, 134, 137, 133, 17, 134, 147, 135, 148, 137, 149, 140, 149,
	142, 148, 143, 147, 144, 144, 144, 139, 145, 137, 142, 19, 143, 144, 143, 137, 140, 21, 141, 148,
	142, 145, 142, 139, 141, 137, 129, 21, 131, 148, 130, 21, 131, 147, 131, 21, 131, 139, 130, 137,
	132, 20, 132, 137, 128, 9, 136, 137, 139, 9, 147, 137, 131, 10, 129, 137, 133, 10, 135, 137, 142, 10,
	140, 137, 144, 9, 144, 138, 146, 137, 150, 0, 0, 0, 128, 19, 129, 148, 130, 148, 131, 147, 130, 146,
	129, 146, 128, 147, 128, 148, 129, 149, 135, 149, 136, 148, 136, 147, 135, 146, 129, 144, 128, 142,
	128, 140, 129, 141, 130, 141, 132, 140, 134, 140, 136, 142, 134, 141, 130, 141, 129, 19, 130, 147,
	139, 0, 0, 0, 128, 0, 128, 139, 136, 139, 136, 128, 128, 128, 129, 11, 129, 128, 130, 11, 130, 128,
	131, 11, 131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134, 11, 134, 128, 135, 11, 135, 128, 140,
	0, 0, 0
};
static const unsigned char Small[5131] = /* binary data included from LITT.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 76,
	73, 84, 84, 139, 19, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 7, 0, 254, 0, 0, 0, 0, 0, 0, 0, 4, 0, 16, 0, 20, 0, 42, 0, 74, 0, 102, 0, 148,
	0, 158, 0, 170, 0, 182, 0, 202, 0, 214, 0, 236, 0, 244, 0, 2, 1, 10, 1, 32, 1, 48, 1, 66, 1, 102, 1, 114,
	1, 138, 1, 162, 1, 176, 1, 214, 1, 240, 1, 8, 2, 36, 2, 46, 2, 58, 2, 68, 2, 88, 2, 118, 2, 136, 2, 170,
	2, 190, 2, 208, 2, 224, 2, 240, 2, 8, 3, 24, 3, 40, 3, 58, 3, 74, 3, 84, 3, 98, 3, 110, 3, 132, 3, 150, 3,
	178, 3, 200, 3, 228, 3, 240, 3, 0, 4, 14, 4, 28, 4, 40, 4, 58, 4, 74, 4, 86, 4, 94, 4, 106, 4, 116, 4, 124,
	4, 132, 4, 152, 4, 172, 4, 188, 4, 206, 4, 228, 4, 248, 4, 14, 5, 32, 5, 52, 5, 68, 5, 84, 5, 98, 5, 120,
	5, 134, 5, 156, 5, 174, 5, 192, 5, 208, 5, 228, 5, 246, 5, 4, 6, 14, 6, 32, 6, 46, 6, 68, 6, 80, 6, 102,
	6, 110, 6, 132, 6, 144, 6, 160, 6, 194, 6, 216, 6, 242, 6, 12, 7, 40, 7, 64, 7, 94, 7, 124, 7, 152, 7,
	182, 7, 208, 7, 228, 7, 246, 7, 6, 8, 34, 8, 64, 8, 84, 8, 122, 8, 148, 8, 176, 8, 206, 8, 232, 8, 252, 8,
	14, 9, 44, 9, 74, 9, 98, 9, 124, 9, 144, 9, 170, 9, 198, 9, 226, 9, 250, 9, 10, 10, 36, 10, 54, 10, 76,
	10, 96, 10, 120, 10, 146, 10, 166, 10, 176, 10, 186, 10, 218, 10, 244, 10, 0, 11, 16, 11, 32, 11, 68,
	11, 114, 11, 160, 11, 168, 11, 180, 11, 196, 11, 212, 11, 226, 11, 240, 11, 4, 12, 16, 12, 32, 12, 48,
	12, 62, 12, 76, 12, 86, 12, 96, 12, 110, 12, 124, 12, 136, 12, 144, 12, 156, 12, 172, 12, 188, 12,
	204, 12, 220, 12, 240, 12, 4, 13, 24, 13, 36, 13, 64, 13, 80, 13, 96, 13, 112, 13, 128, 13, 142, 13,
	156, 13, 170, 13, 184, 13, 200, 13, 216, 13, 226, 13, 236, 13, 10, 14, 36, 14, 54, 14, 72, 14, 98, 14,
	122, 14, 146, 14, 158, 14, 174, 14, 192, 14, 218, 14, 240, 14, 4, 15, 42, 15, 72, 15, 100, 15, 130, 15,
	168, 15, 194, 15, 214, 15, 230, 15, 246, 15, 6, 16, 20, 16, 34, 16, 48, 16, 62, 16, 90, 16, 110, 16,
	132, 16, 146, 16, 160, 16, 174, 16, 188, 16, 204, 16, 6, 2, 5, 6, 6, 7, 6, 4, 5, 5, 6, 6, 6, 6, 4, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 5, 5, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6,
	6, 5, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 5, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 3, 6, 6,
	6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 6, 6, 6, 9, 10, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 7, 8, 7, 6, 4, 6, 6, 6,
	6, 6,
	6, 6, 6, 6, 7, 7, 2, 6, 6, 9, 8, 9, 1, 4, 4, 6, 6, 4, 6, 6, 6, 6, 6, 4, 0, 2, 4, 4, 2, 6, 4, 2, 4, 4, 4, 6, 6,
	4, 6,
	6, 4, 4, 4, 4, 4, 2, 2, 4, 6, 4, 4, 2, 4, 4, 2, 4, 4, 7, 5, 5, 7, 6, 7, 6, 7, 6, 6, 6, 5, 8, 6, 5, 6, 6, 6, 6,
	6, 5,
	5, 5, 5, 5, 3, 3, 6, 6, 4, 4, 134, 0, 0, 0, 128, 2, 128, 135, 128, 1, 128, 128, 130, 0, 0, 0, 133, 0, 0, 0,
	129, 0, 129, 134, 131, 6, 131, 128, 128, 4, 131, 132, 132, 132, 128, 2, 132, 130, 134, 0, 0, 0, 128, 1,
	129, 128, 131, 128, 132, 129, 132, 130, 131, 131, 129, 131, 128, 132, 128, 133, 129, 134, 131, 134,
	132, 133, 130, 6, 130, 128, 134, 0, 0, 0, 128, 1, 133, 134, 128, 6, 128, 135, 129, 135, 129, 134, 128,
	134, 132, 0, 132, 129, 133, 129, 133, 128, 132, 128, 135, 0, 0, 0, 132, 0, 131, 129, 130, 128, 129,
	128, 128, 129, 128, 130, 129, 131, 128, 132, 128, 133, 129, 134, 130, 134, 131, 133, 131, 132, 131,
	132, 130, 131, 131, 130, 131, 129, 132, 3, 131, 130, 129, 3, 130, 131, 134, 0, 0, 0, 129, 7, 129, 133,
	128, 132, 132, 0, 0, 0, 130, 0, 128, 130, 128, 132, 130, 134, 133, 0, 0, 0, 128, 0, 130, 130, 130, 132,
	128, 134, 133, 0, 0, 0, 128, 5, 132, 129, 128, 1, 132, 133, 128, 3, 132, 131, 130, 1, 130, 133, 134, 0,
	0, 0, 128, 3, 132, 131, 130, 5, 130, 129, 134, 0, 0, 0, 129, 127, 130, 128, 130, 129, 129, 129, 129,
	128, 130, 128, 129, 255, 129, 127, 128, 254, 134, 0, 0, 0, 128, 3, 132, 131, 134, 0, 0, 0, 128, 0, 128,
	129, 129, 129, 129, 128, 128, 128, 132, 0, 0, 0, 128, 0, 132, 132, 134, 0, 0, 0, 128, 5, 129, 134, 131,
	134, 132, 133, 132, 129, 131, 128, 129, 128, 128, 129, 128, 133, 134, 0, 0, 0, 129, 0, 130, 128, 130,
	134, 129, 133, 130, 0, 131, 128, 134, 0, 0, 0, 132, 0, 128, 128, 132, 132, 132, 133, 131, 134, 129,
	134, 128, 133, 134, 0, 0, 0, 128, 5, 129, 134, 131, 134, 132, 133, 132, 132, 132, 132, 132, 132, 132,
	132, 131, 131, 130, 131, 131, 131, 132, 130, 132, 129, 131, 128, 129, 128, 128, 129, 134, 0, 0, 0,
	131, 0, 131, 134, 128, 131, 132, 131, 134, 0, 0, 0, 132, 6, 128, 134, 128, 131, 130, 132, 131, 132,
	132, 131, 132, 129, 131, 128, 129, 128, 128, 129, 134, 0, 0, 0, 132, 6, 130, 133, 128, 131, 128, 129,
	129, 128, 131, 128, 132, 129, 132, 130, 131, 131, 128, 131, 134, 0, 0, 0, 128, 6, 132, 134, 132, 133,
	128, 129, 128, 128, 134, 0, 0, 0, 128, 5, 129, 134, 131, 134, 132, 133, 132, 132, 131, 131, 132, 130,
	132, 129, 131, 128, 129, 128, 128, 129, 128, 130, 129, 131, 128, 132, 128, 133, 129, 3, 131, 131,
	134, 0, 0, 0, 128, 1, 129, 128, 131, 128, 132, 129, 132, 133, 131, 134, 129, 134, 128, 133, 128, 132,
	129, 131, 132, 131, 134, 0, 0, 0, 128, 4, 129, 132, 129, 131, 128, 131, 128, 132, 128, 1, 129, 129,
	129, 128, 128, 128, 128, 129, 133, 0, 0, 0, 128, 3, 128, 132, 129, 132, 129, 131, 128, 131, 128, 1,
	129, 129, 129, 128, 128, 255, 129, 0, 128, 128, 128, 129, 133, 0, 0, 0, 131, 0, 128, 131, 131, 134,
	134, 0, 0, 0, 128, 2, 132, 130, 128, 4, 132, 132, 134, 0, 0, 0, 128, 0, 131, 131, 128, 134, 133, 0, 0, 0,
	128, 5, 129, 134, 131, 134, 132, 133, 132, 132, 130, 130, 130, 1, 130, 128, 134, 0, 0, 0, 131, 2, 131,
	131, 130, 131, 130, 130, 131, 130, 132, 131, 132, 133, 131, 134, 129, 134, 128, 133, 128, 129, 129,
	128, 132, 128, 134, 0, 0, 0, 128, 0, 128, 132, 130, 134, 132, 132, 132, 128, 132, 131, 128, 131, 134,
	0, 0, 0, 128, 6, 128, 128, 131, 128, 132, 129, 132, 130, 131, 131, 128, 131, 128, 131, 128, 131,
	128, 131, 131, 131, 132, 132, 132, 133, 131, 134, 128, 134, 134, 0, 0, 0, 132, 5, 131, 134, 129, 134,
	128, 133, 128, 129, 129, 128, 131, 128, 132, 129, 134, 0, 0, 0, 128, 6, 128, 128, 131, 128, 132, 129,
	132, 133, 131, 134, 128, 134, 134, 0, 0, 0, 132, 6, 128, 134, 128, 128, 132, 128, 128, 3, 130, 131,
	134, 0, 0, 0, 132, 6, 128, 134, 128, 131, 130, 131, 128, 131, 128, 128, 134, 0, 0, 0, 132, 5, 131, 134,
	129, 134, 128, 133, 128, 129, 129, 128, 131, 128, 132, 129, 132, 131, 130, 131, 134, 0, 0, 0, 128, 6,
	128, 128, 128, 131, 132, 131, 132, 134, 132, 128, 134, 0, 0, 0, 128, 6, 130, 134, 129, 134, 129, 128,
	128, 128, 130, 128, 133, 0, 0, 0, 132, 6, 130, 134, 131, 134, 131, 129, 130, 128, 129, 128, 128, 129,
	134, 0, 0, 0, 128, 6, 128, 128, 128, 130, 132, 134, 129, 131, 132, 128, 134, 0, 0, 0, 128, 6, 128, 128,
	132, 128, 134, 0, 0, 0, 128, 0, 128, 134, 130, 132, 132, 134, 132, 128, 134, 0, 0, 0, 128, 0, 128, 134,
	132, 128, 132, 134, 134, 0, 0, 0, 131, 6, 129, 134, 128, 133, 128, 129, 129, 128, 131, 128, 132, 129,
	132, 133, 131, 134, 134, 0, 0, 0, 128, 0, 128, 134, 131, 134, 132, 133, 132, 131, 131, 130, 128, 130,
	134, 0, 0, 0, 132, 1, 132, 133, 131, 134, 129, 134, 128, 133, 128, 129, 129, 128, 131, 128, 130, 2,
	132, 128, 131, 0, 132, 129, 134, 0, 0, 0, 128, 0, 128, 134, 131, 134, 132, 133, 132, 131, 131, 130,
	128, 130, 130, 2, 132, 128, 134, 0, 0, 0, 132, 5, 131, 134, 129, 134, 128, 133, 128, 132, 129, 131,
	131, 131, 132, 130, 132, 129, 131, 128, 129, 128, 128, 129, 134, 0, 0, 0, 128, 6, 132, 134, 130, 134,
	130, 128, 134, 0, 0, 0, 128, 6, 128, 129, 129, 128, 131, 128, 132, 129, 132, 134, 134, 0, 0, 0, 128, 6,
	128, 130, 130, 128, 132, 130, 132, 134, 134, 0, 0, 0, 128, 6, 128, 128, 130, 130, 132, 128, 132, 134,
	134, 0, 0, 0, 128, 6, 132, 128, 132, 6, 128, 128, 134, 0, 0, 0, 128, 6, 128, 133, 130, 131, 132, 133,
	132, 134, 130, 3, 130, 128, 134, 0, 0, 0, 128, 6, 132, 134, 132, 133, 128, 129, 128, 128, 132, 128,
	134, 0, 0, 0, 130, 0, 128, 128, 128, 134, 130, 134, 133, 0, 0, 0, 132, 0, 128, 132, 134, 0, 0, 0, 128, 0,
	130, 128, 130, 134, 128, 134, 133, 0, 0, 0, 128, 3, 130, 133, 132, 131, 134, 0, 0, 0, 128, 127, 132,
	255, 134, 0, 0, 0, 128, 5, 130, 131, 134, 0, 0, 0, 129, 4, 131, 132, 132, 131, 132, 128, 129, 128, 128,
	129, 129, 130, 132, 130, 134, 0, 0, 0, 128, 6, 128, 128, 131, 128, 132, 129, 132, 130, 132, 131, 131,
	132, 128, 132, 134, 0, 0, 0, 132, 4, 129, 132, 128, 131, 128, 129, 129, 128, 132, 128, 134, 0, 0, 0,
	132, 6, 132, 128, 129, 128, 128, 129, 128, 131, 129, 132, 132, 132, 134, 0, 0, 0, 131, 0, 129, 128,
	128, 129, 128, 131, 129, 132, 131, 132, 132, 131, 132, 130, 128, 130, 134, 0, 0, 0, 129, 0, 129, 133,
	129, 131, 128, 131, 130, 131, 129, 131, 129, 133, 130, 134, 133, 0, 0, 0, 130, 126, 131, 254, 132,
	255, 132, 132, 129, 132, 128, 131, 128, 129, 129, 128, 132, 128, 134, 0, 0, 0, 128, 6, 128, 128, 128,
	131, 129, 132, 131, 132, 132, 131, 132, 128, 134, 0, 0, 0, 128, 0, 130, 128, 129, 128, 129, 132, 128,
	132, 129, 6, 129, 6, 129, 134, 133, 0, 0, 0, 128, 126, 129, 254, 130, 255, 130, 132, 130, 6, 130, 134,
	134, 0, 0, 0, 128, 0, 128, 134, 128, 2, 131, 132, 128, 2, 131, 128, 134, 0, 0, 0, 128, 0, 130, 128, 129,
	128, 129, 134, 128, 134, 133, 0, 0, 0, 128, 0, 128, 132, 129, 132, 130, 131, 130, 128, 130, 131, 131,
	132, 132, 131, 132, 128, 134, 0, 0, 0, 128, 0, 128, 132, 131, 132, 132, 131, 132, 128, 134, 0, 0, 0,
	129, 0, 131, 128, 132, 129, 132, 131, 131, 132, 129, 132, 128, 131, 128, 129, 129, 128, 134, 0, 0, 0,
	128, 126, 128, 132, 131, 132, 132, 131, 132, 129, 131, 128, 128, 128, 134, 0, 0, 0, 132, 126, 132,
	132, 129, 132, 128, 131, 128, 129, 129, 128, 132, 128, 134, 0, 0, 0, 128, 4, 128, 128, 128, 130, 129,
	131, 130, 132, 131, 132, 134, 0, 0, 0, 128, 0, 131, 128, 132, 129, 131, 130, 129, 130, 128, 131, 129,
	132, 132, 132, 134, 0, 0, 0, 129, 5, 129, 132, 128, 132, 130, 132, 129, 132, 129, 129, 130, 128, 133,
	0, 0, 0, 128, 4, 128, 129, 129, 128, 132, 128, 132, 132, 134, 0, 0, 0, 128, 4, 130, 128, 132, 132,
	134, 0, 0, 0, 128, 4, 128, 129, 129, 128, 130, 129, 131, 128, 132, 129, 132, 132, 134, 0, 0, 0, 128, 4,
	132, 128, 130, 130, 132, 132, 128, 128, 134, 0, 0, 0, 128, 4, 128, 129, 129, 128, 132, 128, 132, 255,
	131, 254, 130, 254, 132, 0, 132, 132, 134, 0, 0, 0, 128, 4, 132, 132, 128, 128, 132, 128, 134, 0, 0, 0,
	131, 6, 130, 134, 129, 133, 129, 132, 128, 131, 129, 130, 129, 129, 130, 128, 131, 128, 134, 0, 0, 0,
	128, 6, 128, 128, 131, 0, 0, 0, 128, 6, 129, 134, 130, 133, 130, 132, 131, 131, 130, 130, 130, 129,
	129, 128, 128, 128, 134, 0, 0, 0, 128, 5, 129, 134, 131, 134, 132, 135, 134, 0, 0, 0, 128, 2, 128, 128,
	132, 128, 132, 130, 130, 133, 128, 130, 134, 0, 0, 0, 132, 6, 131, 135, 129, 135, 128, 134, 128, 130,
	129, 129, 131, 129, 132, 130, 130, 1, 130, 128, 131, 255, 130, 254, 129, 254, 128, 255, 128, 128,
	134, 0, 0, 0, 128, 4, 128, 129, 129, 128, 132, 128, 132, 132, 129, 6, 129, 135, 131, 6, 131, 135, 134,
	0, 0, 0, 131, 0, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 132, 131, 132, 130, 128, 130,
	129, 6, 131, 135, 134, 0, 0, 0, 129, 4, 131, 132, 132, 131, 132, 128, 129, 128, 128, 129, 129, 130,
	132, 130, 128, 6, 130, 136, 132, 134, 134, 0, 0, 0, 129, 4, 131, 132, 132, 131, 132, 128, 129, 128,
	128, 129, 129, 130, 132, 130, 129, 7, 129, 134, 132, 6, 132, 135, 134, 0, 0, 0, 129, 4, 131, 132, 132,
	131, 132, 128, 129, 128, 128, 129, 129, 130, 132, 130, 129, 7, 131, 134, 134, 0, 0, 0, 129, 4, 131,
	132, 132, 131, 132, 128, 129, 128, 128, 129, 129, 130, 132, 130, 130, 7, 129, 134, 130, 133, 131,
	134, 130, 135, 134, 0, 0, 0, 131, 4, 129, 132, 128, 131, 128, 130, 129, 129, 131, 129, 130, 1, 130,
	128, 131, 255, 130, 254, 129, 254, 128, 255, 128, 128, 134, 0, 0, 0, 131, 0, 129, 128, 128, 129, 128,
	131, 129, 132, 131, 132, 132, 131, 132, 130, 128, 130, 128, 6, 130, 136, 132, 134, 134, 0, 0, 0, 131,
	0, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 132, 131, 132, 130, 128, 130, 131, 6, 131,
	135, 129, 6, 129, 135, 134, 0, 0, 0, 131, 0, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 132,
	131, 132, 130, 128, 130, 129, 7, 131, 134, 134, 0, 0, 0, 128, 0, 129, 128, 129, 132, 128, 132, 128, 7,
	128, 134, 130, 7, 130, 134, 133, 0, 0, 0, 129, 0, 130, 128, 130, 132, 129, 132, 128, 6, 130, 136, 132,
	134, 133, 0, 0, 0, 129, 0, 130, 128, 130, 132, 129, 132, 128, 7, 130, 134, 133, 0, 0, 0, 128, 0, 128,
	132, 130, 134, 132, 132, 132, 131, 128, 131, 132, 3, 132, 128, 129, 8, 129, 137, 131, 8, 131, 137,
	134, 0, 0, 0, 128, 0, 128, 132, 130, 134, 132, 132, 132, 131, 128, 131, 132, 3, 132, 128, 130, 9, 129,
	136, 130, 135, 131, 136, 130, 137, 134, 0, 0, 0, 132, 4, 128, 132, 128, 128, 132, 128, 128, 2, 130,
	130, 129, 6, 131, 135, 134, 0, 0, 0, 129, 4, 131, 132, 132, 131, 132, 130, 129, 130, 128, 129, 129,
	128, 132, 128, 132, 130, 136, 130, 136, 131, 135, 132, 133, 132, 132, 131, 132, 1, 133, 128, 135,
	128, 137, 0, 0, 0, 128, 0, 128, 132, 130, 134, 132, 132, 132, 134, 136, 134, 128, 3, 134, 131, 136, 0,
	132, 128, 132, 132, 138, 0, 0, 0, 129, 0, 131, 128, 132, 129, 132, 131, 131, 132, 129, 132, 128, 131,
	128, 129, 129, 128, 128, 6, 130, 136, 132, 134, 134, 0, 0, 0, 129, 0, 131, 128, 132, 129, 132, 131,
	131, 132, 129, 132, 128, 131, 128, 129, 129, 128, 129, 7, 129, 134, 131, 7, 131, 134, 134, 0, 0, 0,
	129, 0, 131, 128, 132, 129, 132, 131, 131, 132, 129, 132, 128, 131, 128, 129, 129, 128, 129, 7, 131,
	134, 134, 0, 0, 0, 128, 4, 128, 129, 129, 128, 132, 128, 132, 132, 128, 6, 130, 136, 132, 134, 134, 0,
	0, 0, 128, 4, 128, 129, 129, 128, 132, 128, 132, 132, 129, 7, 131, 134, 134, 0, 0, 0, 128, 4, 128,
	129, 129, 128, 132, 128, 132, 255, 131, 254, 130, 254, 132, 0, 132, 132, 129, 7, 129, 134, 131, 7,
	131, 134, 134, 0, 0, 0, 131, 6, 129, 134, 128, 133, 128, 129, 129, 128, 131, 128, 132, 129, 132, 133,
	131, 134, 129, 9, 129, 136, 131, 9, 131, 136, 134, 0, 0, 0, 128, 6, 128, 129, 129, 128, 131, 128, 132,
	129, 132, 134, 129, 9, 129, 136, 131, 9, 131, 136, 134, 0, 0, 0, 129, 0, 131, 128, 132, 129, 132, 131,
	131, 132, 129, 132, 128, 131, 128, 129, 129, 128, 128, 0, 132, 132, 134, 0, 0, 0, 131, 5, 130, 133,
	129, 132, 129, 128, 132, 128, 133, 129, 128, 3, 130, 131, 136, 0, 0, 0, 132, 6, 130, 134, 129, 133,
	129, 129, 130, 128, 132, 128, 133, 129, 133, 133, 132, 134, 128, 0, 134, 134, 135, 0, 0, 0, 128, 0,
	128, 135, 131, 135, 132, 134, 132, 132, 131, 131, 128, 131, 133, 4, 133, 129, 134, 128, 132, 3, 134,
	131, 136, 0, 0, 0, 128, 127, 129, 254, 130, 254, 131, 255, 131, 131, 134, 5, 133, 134, 132, 134, 131,
	133, 131, 129, 130, 2, 132, 130, 135, 0, 0, 0, 129, 4, 131, 132, 132, 131, 132, 128, 129, 128, 128,
	129, 129, 130, 132, 130, 129, 6, 131, 135, 134, 0, 0, 0, 128, 0, 129, 128, 129, 132, 128, 132, 128, 6,
	130, 135, 132, 0, 0, 0, 129, 0, 131, 128, 132, 129, 132, 131, 131, 132, 129, 132, 128, 131, 128, 129,
	129, 128, 129, 6, 131, 135, 134, 0, 0, 0, 128, 4, 128, 129, 129, 128, 132, 128, 132, 132, 129, 6, 131,
	135, 134, 0, 0, 0, 128, 0, 128, 132, 131, 132, 132, 131, 132, 128, 128, 6, 129, 135, 131, 135, 132,
	136, 134, 0, 0, 0, 128, 0, 128, 134, 132, 128, 132, 134, 128, 7, 129, 136, 131, 136, 132, 137, 134, 0,
	0, 0, 129, 6, 131, 134, 132, 133, 132, 130, 129, 130, 128, 131, 129, 132, 132, 132, 128, 0, 132,
	128, 134, 0, 0, 0, 129, 3, 131, 131, 132, 132, 132, 133, 131, 134, 129, 134, 128, 133, 128, 132, 129,
	131, 128, 0, 132, 128, 134, 0, 0, 0, 132, 1, 131, 128, 129, 128, 128, 129, 128, 130, 130, 132, 130, 5,
	130, 134, 134, 0, 0, 0, 128, 0, 128, 130, 132, 130, 134, 0, 0, 0, 132, 0, 132, 130, 128, 130, 134, 0, 0,
	0, 128, 5, 129, 134, 129, 131, 128, 3, 130, 131, 131, 2, 131, 131, 132, 131, 133, 131, 133, 130,
	131, 128, 133, 128, 133, 6, 128, 128, 135, 0, 0, 0, 128, 5, 129, 134, 129, 131, 128, 3, 130, 131, 133,
	6, 128, 128, 133, 1, 130, 129, 132, 131, 132, 128, 135, 0, 0, 0, 128, 5, 128, 128, 128, 6, 128, 135,
	130, 0, 0, 0, 130, 5, 128, 131, 130, 129, 132, 5, 130, 131, 132, 129, 134, 0, 0, 0, 130, 5, 132, 131,
	130, 129, 128, 5, 130, 131, 128, 129, 134, 0, 0, 0, 128, 6, 128, 254, 134, 254, 134, 135, 128, 135,
	128, 134, 131, 7, 131, 254, 128, 4, 137, 132, 128, 1, 137, 129, 134, 7, 137, 135, 137, 254, 134, 254,
	137, 0, 0, 0, 128, 7, 136, 135, 136, 255, 128, 255, 128, 135, 128, 5, 136, 133, 128, 3, 136, 131, 128,
	1, 136, 129, 130, 7, 130, 254, 132, 7, 132, 254, 134, 7, 134, 254, 128, 127, 128, 254, 136, 254,
	136, 255, 136, 0, 0, 0, 128, 7, 137, 135, 137, 254, 128, 254, 128, 135, 128, 4, 131, 135, 137, 129,
	134, 254, 128, 132, 128, 2, 133, 135, 128, 0, 135, 135, 137, 133, 130, 254, 128, 128, 128, 126, 137,
	135, 132, 126, 137, 131, 137, 0, 0, 0, 128, 6, 128, 255, 129, 0, 0, 0, 128, 2, 130, 130, 130, 6, 130,
	255, 132, 0, 0, 0, 128, 3, 130, 131, 128, 2, 130, 130, 130, 6, 130, 255, 132, 0, 0, 0, 128, 2, 130, 130,
	130, 6, 130, 255, 132, 6, 132, 255, 134, 0, 0, 0, 128, 2, 132, 130, 132, 255, 130, 2, 130, 255, 134, 0,
	0, 0, 128, 3, 130, 131, 130, 255, 128, 2, 130, 130, 132, 0, 0, 0, 128, 2, 130, 130, 130, 255, 132, 6,
	132, 255, 128, 3, 130, 131, 130, 134, 134, 0, 0, 0, 130, 6, 130, 255, 132, 6, 132, 255, 134, 0, 0, 0,
	128, 3, 132, 131, 132, 255, 128, 2, 130, 130, 130, 255, 134, 0, 0, 0, 128, 2, 132, 130, 132, 134, 128,
	3, 130, 131, 130, 134, 134, 0, 0, 0, 128, 3, 132, 131, 132, 134, 130, 3, 130, 134, 134, 0, 0, 0, 128,
	2, 130, 130, 130, 134, 128, 3, 130, 131, 132, 0, 0, 0, 128, 3, 130, 131, 130, 255, 128, 0, 0, 0, 130,
	2, 128, 130, 128, 134, 130, 0, 0, 0, 128, 2, 130, 130, 130, 134, 132, 2, 130, 130, 132, 0, 0, 0, 128,
	3, 130, 131, 130, 255, 132, 3, 130, 131, 132, 0, 0, 0, 130, 2, 128, 130, 128, 6, 128, 255, 130, 0, 0,
	0, 128, 2, 134, 130, 134, 0, 0, 0, 128, 2, 132, 130, 130, 6, 130, 255, 132, 0, 0, 0, 130, 3, 128, 131,
	130, 2, 128, 130, 128, 6, 128, 255, 130, 0, 0, 0, 132, 2, 130, 130, 130, 6, 130, 255, 128, 6, 128, 255,
	132, 0, 0, 0, 132, 2, 128, 130, 128, 134, 132, 3, 130, 131, 130, 134, 132, 0, 0, 0, 132, 3, 128, 131,
	128, 255, 132, 2, 130, 130, 130, 255, 132, 0, 0, 0, 128, 2, 134, 130, 130, 6, 130, 131, 128, 131, 132,
	6, 132, 131, 134, 131, 134, 0, 0, 0, 128, 3, 134, 131, 130, 127, 130, 130, 128, 130, 134, 2, 132,
	130, 132, 255, 134, 0, 0, 0, 132, 2, 130, 130, 130, 255, 128, 6, 128, 255, 132, 3, 130, 131, 130, 134,
	132, 0, 0, 0, 128, 2, 134, 130, 128, 3, 134, 131, 134, 0, 0, 0, 128, 2, 130, 130, 130, 255, 128, 3, 130,
	131, 130, 134, 132, 6, 132, 131, 134, 131, 132, 127, 132, 130, 134, 130, 134, 0, 0, 0, 128, 2, 132,
	130, 128, 3, 132, 131, 130, 6, 130, 131, 132, 0, 0, 0, 128, 3, 132, 131, 129, 6, 129, 131, 131, 6, 131,
	131, 132, 0, 0, 0, 128, 3, 132, 131, 128, 2, 132, 130, 130, 127, 130, 130, 132, 0, 0, 0, 128, 2, 132,
	130, 129, 127, 129, 130, 131, 127, 131, 130, 132, 0, 0, 0, 132, 3, 128, 131, 128, 134, 130, 3, 130,
	134, 132, 0, 0, 0, 130, 2, 128, 130, 128, 134, 130, 3, 128, 131, 130, 0, 0, 0, 130, 3, 128, 131, 128,
	255, 130, 2, 128, 130, 130, 0, 0, 0, 132, 2, 128, 130, 128, 255, 130, 2, 130, 255, 132, 0, 0, 0, 128, 2,
	134, 130, 130, 6, 130, 255, 132, 6, 132, 255, 134, 0, 0, 0, 128, 2, 132, 130, 130, 6, 130, 255, 128, 3,
	132, 131, 132, 0, 0, 0, 128, 2, 130, 130, 130, 134, 132, 0, 0, 0, 130, 3, 128, 131, 128, 255, 130, 0, 0,
	0, 128, 6, 132, 134, 132, 128, 128, 128, 128, 134, 129, 6, 129, 128, 130, 6, 130, 128, 131, 6, 131,
	128, 128, 3, 132, 131, 132, 0, 0, 0, 132, 0, 128, 128, 128, 131, 132, 131, 132, 128, 131, 3, 131, 128,
	130, 3, 130, 128, 129, 3, 129, 128, 132, 0, 0, 0, 128, 0, 128, 134, 130, 134, 130, 128, 128, 128, 129,
	6, 129, 128, 130, 0, 0, 0, 130, 0, 130, 134, 132, 134, 132, 128, 130, 128, 131, 6, 131, 128, 132, 0,
	0, 0, 132, 3, 128, 131, 128, 134, 132, 134, 132, 131, 131, 6, 131, 131, 130, 6, 130, 131, 129, 6,
	129, 131, 132, 0, 0, 0, 133, 4, 132, 130, 130, 132, 129, 132, 128, 131, 128, 129, 129, 128, 130, 128,
	132, 130, 133, 128, 135, 0, 0, 0, 130, 3, 131, 131, 132, 132, 131, 133, 128, 133, 128, 255, 131, 3,
	132, 130, 131, 129, 128, 129, 133, 0, 0, 0, 128, 0, 128, 132, 131, 132, 131, 131, 133, 0, 0, 0, 129, 4,
	129, 128, 132, 4, 132, 128, 128, 4, 133, 132, 135, 0, 0, 0, 132, 1, 132, 128, 128, 128, 130, 131, 128,
	134, 132, 134, 132, 133, 134, 0, 0, 0, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131, 129, 131,
	130, 130, 131, 129, 131, 130, 132, 133, 132, 135, 0, 0, 0, 129, 3, 129, 129, 130, 128, 131, 128, 132,
	129, 132, 131, 129, 1, 129, 255, 128, 254, 134, 0, 0, 0, 128, 2, 128, 131, 129, 132, 130, 132, 131,
	131, 131, 255, 131, 2, 133, 132, 135, 0, 0, 0, 128, 6, 132, 134, 129, 4, 131, 132, 132, 131, 132, 130,
	131, 129, 129, 129, 128, 130, 128, 131, 129, 132, 130, 4, 130, 134, 130, 1, 130, 255, 128, 127, 132,
	255, 134, 0, 0, 0, 129, 6, 128, 133, 128, 129, 129, 128, 131, 128, 132, 129, 132, 133, 131, 134, 129,
	134, 128, 4, 129, 131, 131, 131, 132, 132, 134, 0, 0, 0, 128, 0, 129, 128, 129, 130, 128, 131, 128,
	133, 129, 134, 131, 134, 132, 133, 132, 131, 131, 130, 131, 128, 132, 128, 134, 0, 0, 0, 129, 3, 128,
	130, 128, 129, 129, 128, 130, 128, 131, 129, 131, 130, 130, 131, 129, 131, 130, 3, 128, 134, 131,
	134, 131, 133, 133, 0, 0, 0, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131, 129, 131, 130, 130,
	131, 129, 131, 131, 1, 132, 128, 133, 128, 134, 129, 134, 130, 133, 131, 132, 131, 131, 130, 136, 0,
	0, 0, 129, 0, 131, 128, 132, 129, 132, 131, 131, 132, 129, 132, 128, 131, 128, 129, 129, 128, 128,
	0, 132, 132, 134, 0, 0, 0, 131, 6, 129, 134, 128, 133, 128, 129, 129, 128, 131, 128, 128, 3, 130,
	131, 133, 0, 0, 0, 128, 0, 128, 133, 129, 134, 131, 134, 132, 133, 132, 128, 134, 0, 0, 0, 128, 3, 132,
	131, 128, 1, 132, 129, 132, 5, 128, 133, 134, 0, 0, 0, 128, 0, 132, 128, 128, 4, 132, 132, 130, 6, 130,
	130, 134, 0, 0, 0, 128, 0, 132, 128, 128, 6, 132, 132, 128, 130, 134, 0, 0, 0, 132, 0, 128, 128, 132, 6,
	128, 132, 132, 130, 134, 0, 0, 0, 131, 5, 130, 134, 129, 134, 128, 133, 128, 254, 133, 0, 0, 0, 128,
	127, 129, 254, 130, 254, 131, 255, 131, 134, 133, 0, 0, 0, 129, 6, 129, 133, 130, 133, 130, 134, 129,
	134, 129, 1, 130, 129, 130, 128, 129, 128, 129, 129, 128, 3, 131, 131, 133, 0, 0, 0, 128, 3, 129, 132,
	130, 131, 131, 132, 128, 1, 129, 130, 130, 129, 131, 130, 133, 0, 0, 0, 129, 6, 130, 134, 131, 133,
	131, 132, 130, 131, 129, 131, 128, 132, 128, 133, 129, 134, 133, 0, 0, 0, 128, 2, 129, 130, 129, 128,
	128, 128, 128, 130, 131, 0, 0, 0, 128, 1, 129, 129, 129, 128, 128, 128, 128, 129, 131, 0, 0, 0, 133, 5,
	133, 134, 130, 134, 130, 128, 128, 130, 134, 0, 0, 0, 128, 3, 128, 134, 131, 134, 132, 133, 132, 131,
	134, 0, 0, 0, 128, 5, 128, 134, 130, 134, 130, 133, 128, 131, 130, 131, 132, 0, 0, 0, 128, 0, 128, 131,
	130, 131, 130, 128, 128, 128, 129, 3, 129, 128, 132, 0, 0, 0
};
static const unsigned char Sans[13596] = /* binary data included from SANS.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 83,
	65, 78, 83, 156, 52, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 254, 0, 0, 1, 10, 3, 0, 25, 0, 249, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 8, 0, 12, 0, 16, 0, 20, 0, 24, 0, 28, 0, 32, 0, 36, 0, 40, 0, 44, 0,
	48, 0, 52, 0, 56, 0, 60, 0, 64, 0, 68, 0, 112, 0, 142, 0, 162, 0, 2, 1, 64, 1, 200, 1, 220, 1, 12, 2, 60, 2,
	124, 2, 152, 2, 194, 2, 208, 2, 240, 2, 0, 3, 78, 3, 100, 3, 158, 3, 236, 3, 2, 4, 82, 4, 196, 4, 214, 4,
	88, 5, 202, 5, 6, 6, 78, 6, 88, 6, 116, 6, 126, 6, 230, 6, 82, 7, 108, 7, 188, 7, 8, 8, 68, 8, 110, 8, 144,
	8, 232, 8, 12, 9, 28, 9, 68, 9, 104, 9, 128, 9, 168, 9, 200, 9, 24, 10, 74, 10, 166, 10, 226, 10, 56,
	11, 82, 11, 130, 11, 154, 11, 194, 11, 222, 11, 252, 11, 28, 12, 48, 12, 62, 12, 82, 12, 102, 12, 116,
	12, 136, 12, 204, 12, 16, 13, 80, 13, 148, 13, 220, 13, 6, 14, 98, 14, 144, 14, 188, 14, 232, 14, 12,
	15, 28, 15, 104, 15, 150, 15, 222, 15, 34, 16, 102, 16, 136, 16, 224, 16, 252, 16, 42, 17, 66, 17,
	106, 17, 134, 17, 164, 17, 196, 17, 18, 18, 26, 18, 104, 18, 152, 18, 176, 18, 40, 19, 142, 19, 248,
	19, 72, 20, 196, 20, 40, 21, 136, 21, 244, 21, 74, 22, 204, 22, 54, 23, 128, 23, 158, 23, 208, 23, 38,
	24, 96, 24, 162, 24, 44, 25, 94, 25, 182, 25, 58, 26, 166, 26, 224, 26, 46, 27, 132, 27, 16, 28, 122,
	28, 208, 28, 18, 29, 112, 29, 176, 29, 246, 29, 90, 30, 140, 30, 248, 30, 70, 31, 160, 31, 226, 31,
	48, 32, 126, 32, 230, 32, 252, 32, 18, 33, 90, 33, 142, 33, 188, 33, 208, 33, 228, 33, 228, 34, 210,
	36, 10, 39, 22, 39, 38, 39, 58, 39, 78, 39, 96, 39, 114, 39, 138, 39, 154, 39, 174, 39, 194, 39, 212,
	39, 230, 39, 244, 39, 254, 39, 12, 40, 26, 40, 38, 40, 46, 40, 58, 40, 74, 40, 90, 40, 106, 40, 122,
	40, 142, 40, 162, 40, 182, 40, 194, 40, 222, 40, 238, 40, 254, 40, 14, 41, 30, 41, 44, 41, 58, 41, 72,
	41, 86, 41, 98, 41, 114, 41, 128, 41, 138, 41, 216, 41, 34, 42, 76, 42, 118, 42, 192, 42, 6, 43, 62,
	43, 86, 43, 120, 43, 150, 43, 224, 43, 22, 44, 62, 44, 166, 44, 4, 45, 94, 45, 176, 45, 48, 46, 134,
	46, 178, 46, 228, 46, 10, 47, 48, 47, 84, 47, 120, 47, 158, 47, 196, 47, 14, 48, 110, 48, 178, 48,
	212, 48, 242, 48, 14, 49, 60, 49, 100, 49, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	0, 0, 0, 0, 0, 0, 0, 0, 16, 8, 16, 20, 18, 23, 24, 7, 13, 13, 15, 22, 22, 22, 10, 24, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 8, 8, 21, 22, 21, 18, 26, 21, 18, 20, 19, 17, 17, 20, 19, 6, 15, 19, 17, 21, 19, 21,
	18, 21, 18, 19, 18, 19, 21, 27, 19, 20, 19, 12, 24, 12, 18, 22, 7, 18, 18, 17, 18, 17, 13, 18, 17, 8, 8,
	17, 6, 28, 17, 18, 18, 18, 15, 16, 12, 17, 17, 23, 17, 17, 17, 10, 5, 10, 23, 17, 20, 17, 17, 18, 18, 18,
	18, 17, 17, 17, 17, 16, 15, 10, 21, 21, 17, 30, 27, 18, 18, 18, 17, 17, 17, 21, 19, 19, 20, 24, 23, 18,
	18, 11, 18, 17, 23, 23, 19, 18, 18, 18, 18, 21, 21, 8, 17, 17, 17, 16, 24, 5, 13, 13, 21, 21, 13, 21, 21,
	21, 21, 21, 13, 13, 8, 16, 16, 8, 16, 16, 8, 16, 16, 16, 24, 24, 16, 16, 24, 16, 16, 16, 16, 16, 8, 8, 16,
	16, 16, 13, 8, 16, 16, 8, 17, 16, 24, 16, 16, 19, 17, 24, 20, 20, 18, 21, 21, 18, 30, 19, 17, 19, 22, 22,
	22, 22, 12, 12, 22, 23, 18, 9, 9, 23, 17, 12, 13, 156, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0,
	128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0,
	128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 144, 0, 0, 0, 129, 21, 129, 135, 130, 135, 129, 21,
	130, 149, 130, 135, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131, 129, 131, 130, 130, 131,
	129, 131, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 136, 0, 0, 0, 128, 14, 130, 148, 129, 149,
	128, 148, 128, 142, 129, 148, 138, 21, 137, 148, 137, 142, 139, 148, 138, 149, 138, 20, 137, 142,
	144, 0, 0, 0, 136, 21, 129, 249, 142, 21, 135, 249, 129, 10, 143, 138, 128, 4, 142, 132, 148, 0, 0, 0,
	134, 25, 134, 252, 135, 252, 134, 25, 135, 153, 135, 252, 139, 18, 141, 146, 139, 148, 136, 149,
	133, 149, 130, 148, 128, 146, 128, 144, 129, 142, 130, 141, 138, 137, 139, 136, 140, 134, 140, 132,
	139, 130, 136, 129, 133, 129, 131, 130, 130, 131, 139, 18, 138, 147, 136, 148, 133, 148, 130, 147,
	129, 146, 129, 144, 130, 142, 138, 138, 140, 136, 141, 134, 141, 132, 140, 130, 139, 129, 136, 128,
	133, 128, 130, 129, 128, 131, 130, 131, 140, 3, 137, 129, 146, 0, 0, 0, 146, 21, 128, 128, 133, 21,
	135, 147, 135, 145, 134, 143, 132, 142, 130, 142, 128, 144, 128, 146, 129, 148, 131, 149, 133, 149,
	135, 148, 138, 147, 141, 147, 144, 148, 146, 149, 142, 7, 140, 134, 139, 132, 139, 130, 141, 128,
	143, 128, 145, 129, 146, 131, 146, 133, 144, 135, 142, 135, 151, 0, 0, 0, 147, 14, 145, 142, 143,
	141, 142, 139, 140, 133, 139, 131, 138, 130, 136, 129, 132, 129, 130, 130, 129, 132, 129, 134, 130,
	136, 131, 137, 136, 140, 138, 142, 139, 144, 139, 146, 138, 148, 136, 149, 135, 149, 133, 148, 132,
	146, 132, 144, 133, 141, 135, 138, 140, 132, 143, 129, 145, 128, 147, 128, 147, 14, 147, 141, 145,
	141, 143, 140, 144, 13, 143, 139, 141, 133, 140, 131, 138, 129, 136, 128, 132, 128, 130, 129, 129,
	130, 128, 132, 128, 134, 129, 136, 131, 138, 136, 141, 137, 142, 138, 144, 138, 146, 137, 148, 138,
	19, 136, 148, 135, 148, 133, 147, 134, 20, 133, 146, 133, 144, 134, 141, 136, 138, 141, 132, 143,
	130, 145, 129, 147, 129, 147, 128, 152, 0, 0, 0, 129, 21, 128, 148, 128, 142, 129, 20, 128, 142, 129,
	21, 130, 148, 128, 142, 135, 0, 0, 0, 135, 25, 133, 151, 131, 148, 129, 144, 128, 139, 128, 135,
	129, 130, 131, 254, 133, 251, 135, 249, 136, 249, 135, 25, 136, 153, 134, 151, 132, 148, 130, 144,
	129, 139, 129, 135, 130, 130, 132, 254, 134, 251, 136, 249, 141, 0, 0, 0, 128, 25, 130, 151, 132,
	148, 134, 144, 135, 139, 135, 135, 134, 130, 132, 254, 130, 251, 128, 249, 129, 249, 128, 25, 129,
	153, 131, 151, 133, 148, 135, 144, 136, 139, 136, 135, 135, 130, 133, 254, 131, 251, 129, 249, 141,
	0, 0, 0, 133, 21, 132, 148, 134, 138, 133, 137, 133, 21, 133, 137, 133, 21, 134, 148, 132, 138,
	133, 137, 128, 18, 129, 146, 137, 140, 138, 140, 128, 18, 138, 140, 128, 18, 128, 145, 138, 141,
	138, 140, 138, 18, 137, 146, 129, 140, 128, 140, 138, 18, 128, 140, 138, 18, 138, 145, 128, 141,
	128, 140, 143, 0, 0, 0, 136, 18, 136, 129, 137, 129, 136, 18, 137, 146, 137, 129, 128, 10, 145, 138,
	145, 137, 128, 10, 128, 137, 145, 137, 150, 0, 0, 0, 130, 125, 131, 129, 130, 128, 129, 128, 128,
	129, 128, 130, 129, 131, 130, 131, 131, 130, 131, 255, 130, 253, 128, 252, 129, 2, 129, 129, 130,
	129, 130, 130, 129, 130, 130, 0, 131, 255, 150, 0, 0, 0, 129, 10, 146, 138, 146, 137, 129, 137, 129,
	138, 150, 0, 0, 0, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131, 129, 131, 130, 130, 131, 129,
	131, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 138, 0, 0, 0, 146, 25, 128, 249, 129, 249, 146,
	25, 147, 153, 129, 249, 152, 0, 0, 0, 134, 21, 131, 148, 129, 145, 128, 140, 128, 137, 129, 132,
	131, 129, 134, 128, 136, 128, 139, 129, 141, 132, 142, 137, 142, 140, 141, 145, 139, 148, 136, 149,
	134, 149, 132, 20, 130, 145, 129, 140, 129, 137, 130, 132, 132, 129, 131, 2, 134, 129, 136, 129,
	139, 130, 138, 1, 140, 132, 141, 137, 141, 140, 140, 145, 138, 148, 139, 19, 136, 148, 134, 148,
	131, 147, 150, 0, 0, 0, 136, 0, 136, 147, 134, 145, 132, 144, 132, 145, 134, 146, 137, 149, 137, 128,
	147, 0, 150, 0, 0, 0, 129, 1, 142, 129, 142, 128, 128, 128, 137, 138, 139, 141, 140, 143, 140, 145,
	139, 147, 137, 148, 133, 148, 131, 147, 130, 145, 130, 144, 129, 144, 129, 145, 130, 147, 131, 148,
	133, 149, 137, 149, 139, 148, 140, 147, 141, 145, 141, 143, 140, 141, 138, 138, 129, 128, 150, 0, 0,
	0, 140, 20, 130, 148, 130, 149, 141, 149, 134, 140, 140, 21, 133, 140, 136, 140, 139, 139, 141,
	136, 134, 13, 136, 141, 139, 140, 141, 138, 142, 135, 142, 134, 141, 131, 139, 129, 136, 128, 133,
	128, 130, 129, 129, 130, 128, 132, 129, 132, 130, 130, 133, 129, 136, 129, 139, 130, 141, 133, 137,
	12, 140, 138, 141, 135, 141, 134, 140, 131, 137, 129, 132, 1, 129, 131, 150, 0, 0, 0, 129, 5, 138,
	146, 138, 128, 139, 128, 139, 149, 128, 133, 143, 133, 143, 134, 129, 134, 150, 0, 0, 0, 141, 5, 139,
	130, 136, 129, 133, 129, 130, 130, 129, 132, 128, 132, 129, 130, 130, 129, 133, 128, 136, 128, 139,
	129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 136, 142, 133, 142, 130, 141, 131, 148, 140,
	148, 140, 149, 130, 149, 129, 140, 130, 140, 132, 141, 136, 141, 139, 140, 141, 137, 137, 13, 140,
	139, 141, 136, 141, 134, 140, 131, 137, 129, 132, 1, 129, 131, 150, 0, 0, 0, 138, 20, 139, 146, 140,
	146, 139, 148, 136, 149, 134, 149, 131, 148, 129, 145, 128, 140, 128, 135, 129, 131, 131, 129, 134,
	128, 135, 128, 138, 129, 140, 131, 141, 134, 141, 135, 140, 138, 138, 140, 135, 141, 134, 141, 131,
	140, 129, 138, 139, 19, 136, 148, 134, 148, 131, 147, 132, 20, 130, 145, 129, 140, 129, 135, 130,
	131, 133, 129, 129, 5, 131, 130, 134, 129, 135, 129, 138, 130, 140, 133, 136, 1, 139, 131, 140, 134,
	140, 135, 139, 138, 136, 140, 140, 8, 138, 139, 135, 140, 134, 140, 131, 139, 129, 136, 133, 12,
	130, 138, 129, 135, 150, 0, 0, 0, 141, 20, 128, 148, 128, 149, 142, 149, 132, 128, 131, 128, 141,
	149, 150, 0, 0, 0, 133, 21, 130, 148, 129, 146, 129, 144, 130, 142, 131, 141, 133, 140, 137, 139,
	139, 138, 140, 137, 141, 135, 141, 132, 140, 130, 137, 129, 133, 129, 130, 130, 129, 132, 129, 135,
	130, 137, 131, 138, 133, 139, 137, 140, 139, 141, 140, 142, 141, 144, 141, 146, 140, 148, 137, 149,
	133, 149, 131, 20, 130, 146, 130, 144, 131, 142, 133, 141, 137, 140, 139, 139, 141, 137, 142, 135,
	142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130, 129, 129, 130, 128, 132, 128, 135, 129, 137,
	131, 139, 133, 140, 137, 141, 139, 142, 140, 144, 140, 146, 139, 148, 140, 19, 137, 148, 133, 148,
	130, 147, 129, 3, 132, 129, 138, 1, 141, 131, 150, 0, 0, 0, 140, 11, 138, 137, 135, 136, 134, 136,
	131, 137, 129, 139, 128, 142, 128, 143, 129, 146, 131, 148, 134, 149, 135, 149, 138, 148, 140, 146,
	141, 142, 141, 137, 140, 132, 138, 129, 135, 128, 133, 128, 130, 129, 129, 131, 130, 131, 131, 129,
	137, 1, 139, 132, 140, 137, 140, 142, 139, 139, 136, 137, 140, 13, 138, 138, 135, 137, 134, 137,
	131, 138, 129, 141, 133, 9, 130, 139, 129, 142, 129, 143, 130, 146, 133, 148, 129, 16, 131, 147,
	134, 148, 135, 148, 138, 147, 140, 144, 136, 20, 139, 146, 140, 142, 138, 2, 135, 129, 133, 129,
	130, 130, 150, 0, 0, 0, 129, 14, 128, 141, 128, 140, 129, 139, 130, 139, 131, 140, 131, 141, 130,
	142, 129, 142, 129, 13, 129, 140, 130, 140, 130, 141, 129, 141, 129, 3, 128, 130, 128, 129, 129,
	128, 130, 128, 131, 129, 131, 130, 130, 131, 129, 131, 129, 2, 129, 129, 130, 129, 130, 130, 129,
	130, 136, 0, 0, 0, 129, 14, 128, 141, 128, 140, 129, 139, 130, 139, 131, 140, 131, 141, 130, 142,
	129, 142, 129, 13, 129, 140, 130, 140, 130, 141, 129, 141, 131, 1, 130, 128, 129, 128, 128, 129,
	128, 130, 129, 131, 130, 131, 131, 130, 131, 255, 130, 253, 128, 252, 129, 2, 129, 129, 130, 129,
	130, 130, 129, 130, 130, 0, 131, 255, 131, 1, 130, 253, 136, 0, 0, 0, 144, 18, 128, 137, 144, 128,
	149, 0, 0, 0, 128, 14, 145, 142, 145, 141, 128, 14, 128, 141, 145, 141, 128, 6, 145, 134, 145, 133,
	128, 6, 128, 133, 145, 133, 150, 0, 0, 0, 128, 18, 144, 137, 128, 128, 149, 0, 0, 0, 128, 16, 128, 145,
	129, 147, 130, 148, 133, 149, 136, 149, 139, 148, 140, 147, 141, 145, 141, 143, 140, 141, 139, 140,
	137, 139, 134, 138, 128, 16, 129, 144, 129, 145, 130, 147, 133, 148, 136, 148, 139, 147, 140, 145,
	140, 143, 139, 141, 137, 140, 134, 139, 129, 18, 132, 148, 137, 20, 140, 146, 140, 14, 136, 139,
	134, 11, 134, 135, 135, 135, 135, 139, 134, 3, 133, 130, 133, 129, 134, 128, 135, 128, 136, 129,
	136, 130, 135, 131, 134, 131, 134, 2, 134, 129, 135, 129, 135, 130, 134, 130, 146, 0, 0, 0, 143, 13,
	142, 143, 140, 144, 137, 144, 135, 143, 134, 142, 133, 139, 133, 136, 134, 134, 136, 133, 139, 133,
	141, 134, 142, 136, 137, 16, 135, 142, 134, 139, 134, 136, 135, 134, 136, 133, 143, 16, 142, 136,
	142, 134, 144, 133, 146, 133, 148, 135, 149, 138, 149, 140, 148, 143, 147, 145, 145, 147, 143, 148,
	140, 149, 137, 149, 134, 148, 132, 147, 130, 145, 129, 143, 128, 140, 128, 137, 129, 134, 130, 132,
	132, 130, 134, 129, 137, 128, 140, 128, 143, 129, 145, 130, 146, 131, 144, 16, 143, 136, 143, 134,
	144, 133, 154, 0, 0, 0, 136, 21, 128, 128, 129, 128, 136, 146, 143, 128, 144, 128, 136, 149, 131, 6,
	141, 134, 130, 5, 142, 133, 149, 0, 0, 0, 128, 21, 128, 128, 129, 20, 129, 129, 128, 21, 136, 149,
	139, 148, 140, 147, 141, 145, 141, 142, 140, 140, 139, 139, 136, 138, 129, 20, 136, 148, 139, 147,
	140, 145, 140, 142, 139, 140, 136, 139, 129, 11, 136, 139, 139, 138, 140, 137, 141, 135, 141, 132,
	140, 130, 139, 129, 136, 128, 128, 128, 129, 10, 136, 138, 139, 137, 140, 135, 140, 132, 139, 130,
	136, 129, 129, 129, 146, 0, 0, 0, 143, 16, 142, 146, 140, 148, 138, 149, 134, 149, 132, 148, 130,
	146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142,
	131, 143, 133, 143, 16, 142, 144, 141, 146, 140, 147, 138, 148, 134, 148, 132, 147, 130, 144, 129,
	141, 129, 136, 130, 133, 132, 130, 134, 129, 138, 129, 140, 130, 141, 131, 142, 133, 143, 133, 148,
	0, 0, 0, 128, 21, 128, 128, 129, 20, 129, 129, 128, 21, 135, 149, 138, 148, 140, 146, 141, 144,
	142, 141, 142, 136, 141, 133, 140, 131, 138, 129, 135, 128, 128, 128, 129, 20, 135, 148, 138, 147,
	139, 146, 140, 144, 141, 141, 141, 136, 140, 133, 139, 131, 138, 130, 135, 129, 129, 129, 147, 0, 0,
	0, 128, 21, 128, 128, 129, 20, 129, 129, 128, 21, 140, 149, 129, 20, 140, 148, 140, 149, 129, 11,
	135, 139, 135, 138, 129, 10, 135, 138, 129, 1, 140, 129, 140, 128, 128, 0, 140, 128, 145, 0, 0, 0,
	128, 21, 128, 128, 129, 20, 129, 128, 128, 128, 128, 21, 140, 149, 129, 20, 140, 148, 140, 149, 129,
	11, 135, 139, 135, 138, 129, 10, 135, 138, 145, 0, 0, 0, 143, 16, 142, 146, 140, 148, 138, 149, 134,
	149, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138,
	128, 140, 129, 142, 131, 143, 133, 143, 137, 138, 137, 143, 16, 142, 144, 141, 146, 140, 147, 138,
	148, 134, 148, 132, 147, 131, 146, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 132, 130, 134,
	129, 138, 129, 140, 130, 141, 131, 142, 133, 142, 136, 138, 136, 138, 137, 148, 0, 0, 0, 128, 21,
	128, 128, 128, 21, 129, 149, 129, 128, 128, 128, 142, 21, 141, 149, 141, 128, 142, 128, 142, 21,
	142, 128, 129, 11, 141, 139, 129, 10, 141, 138, 147, 0, 0, 0, 128, 21, 128, 128, 129, 128, 128, 21,
	129, 149, 129, 128, 134, 0, 0, 0, 137, 21, 137, 133, 136, 130, 134, 129, 132, 129, 130, 130, 129,
	133, 128, 133, 137, 21, 138, 149, 138, 133, 137, 130, 136, 129, 134, 128, 132, 128, 130, 129, 129,
	130, 128, 133, 143, 0, 0, 0, 128, 21, 128, 128, 129, 128, 128, 21, 129, 149, 129, 128, 142, 21, 141,
	149, 129, 137, 142, 21, 129, 136, 132, 12, 141, 128, 142, 128, 133, 12, 142, 128, 147, 0, 0, 0, 128,
	21, 128, 128, 128, 21, 129, 149, 129, 129, 129, 1, 140, 129, 140, 128, 128, 0, 140, 128, 145, 0, 0,
	0, 128, 21, 128, 128, 129, 16, 129, 128, 128, 128, 129, 16, 136, 128, 128, 21, 136, 131, 144, 21,
	136, 131, 143, 16, 136, 128, 143, 16, 143, 128, 144, 128, 144, 21, 144, 128, 149, 0, 0, 0, 128, 21,
	128, 128, 129, 18, 129, 128, 128, 128, 129, 18, 142, 128, 128, 21, 141, 131, 141, 21, 141, 131, 141,
	21, 142, 149, 142, 128, 147, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136,
	129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133, 144, 136, 144, 141,
	143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 135, 20, 132, 147, 130, 144, 129, 141, 129, 136,
	130, 133, 132, 130, 135, 129, 137, 129, 140, 130, 142, 133, 143, 136, 143, 141, 142, 144, 140, 147,
	137, 148, 135, 148, 149, 0, 0, 0, 128, 21, 128, 128, 129, 20, 129, 128, 128, 128, 128, 21, 137, 149,
	139, 148, 140, 147, 141, 145, 141, 142, 140, 140, 139, 139, 137, 138, 129, 138, 129, 20, 137, 148,
	139, 147, 140, 145, 140, 142, 139, 140, 137, 139, 129, 139, 146, 0, 0, 0, 134, 21, 132, 148, 130,
	146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142,
	131, 143, 133, 144, 136, 144, 141, 143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 135, 20, 132,
	147, 130, 144, 129, 141, 129, 136, 130, 133, 132, 130, 135, 129, 137, 129, 140, 130, 142, 133, 143,
	136, 143, 141, 142, 144, 140, 147, 137, 148, 135, 148, 137, 3, 142, 254, 143, 254, 137, 3, 138, 131,
	143, 254, 149, 0, 0, 0, 128, 21, 128, 128, 129, 20, 129, 128, 128, 128, 128, 21, 136, 149, 139, 148,
	140, 147, 141, 145, 141, 142, 140, 140, 139, 139, 136, 138, 129, 138, 129, 20, 136, 148, 139, 147,
	140, 145, 140, 142, 139, 140, 136, 139, 129, 139, 134, 10, 140, 128, 141, 128, 135, 10, 141, 128,
	146, 0, 0, 0, 142, 18, 140, 148, 137, 149, 133, 149, 130, 148, 128, 146, 128, 144, 129, 142, 130,
	141, 132, 140, 137, 138, 139, 137, 140, 136, 141, 134, 141, 131, 140, 130, 137, 129, 133, 129, 131,
	130, 130, 131, 128, 131, 142, 18, 140, 146, 139, 147, 137, 148, 133, 148, 130, 147, 129, 146, 129,
	144, 130, 142, 132, 141, 137, 139, 139, 138, 141, 136, 142, 134, 142, 131, 140, 129, 137, 128, 133,
	128, 130, 129, 128, 131, 147, 0, 0, 0, 134, 20, 134, 128, 135, 20, 135, 128, 134, 128, 128, 21, 141,
	149, 141, 148, 128, 21, 128, 148, 141, 148, 146, 0, 0, 0, 128, 21, 128, 134, 129, 131, 131, 129, 134,
	128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 149, 128, 21, 129, 149, 129, 134, 130, 131, 131,
	130, 134, 129, 136, 129, 139, 130, 140, 131, 141, 134, 141, 149, 142, 149, 147, 0, 0, 0, 128, 21,
	136, 128, 128, 21, 129, 149, 136, 131, 144, 21, 143, 149, 136, 131, 144, 21, 136, 128, 149, 0, 0, 0,
	128, 21, 134, 128, 128, 21, 129, 149, 134, 131, 139, 21, 134, 131, 139, 18, 134, 128, 139, 18, 144,
	128, 139, 21, 144, 131, 150, 21, 149, 149, 144, 131, 150, 21, 144, 128, 155, 0, 0, 0, 128, 21, 141,
	128, 142, 128, 128, 21, 129, 149, 142, 128, 142, 21, 141, 149, 128, 128, 142, 21, 129, 128, 128,
	128, 147, 0, 0, 0, 128, 21, 135, 139, 135, 128, 136, 128, 128, 21, 129, 149, 136, 139, 143, 21, 142,
	149, 135, 139, 143, 21, 136, 139, 136, 128, 148, 0, 0, 0, 141, 21, 128, 128, 142, 21, 129, 128, 128,
	21, 142, 149, 128, 21, 128, 148, 141, 148, 129, 1, 142, 129, 142, 128, 128, 0, 142, 128, 147, 0, 0,
	0, 128, 25, 128, 249, 129, 25, 129, 249, 128, 25, 135, 153, 128, 121, 135, 249, 140, 0, 0, 0, 147,
	121, 129, 153, 128, 153, 146, 249, 147, 249, 152, 0, 0, 0, 134, 25, 134, 249, 135, 25, 135, 249, 128,
	25, 135, 153, 128, 121, 135, 249, 140, 0, 0, 0, 128, 17, 129, 145, 134, 149, 140, 145, 141, 145,
	134, 150, 128, 145, 143, 0, 146, 0, 0, 0, 145, 0, 145, 129, 128, 129, 128, 128, 145, 128, 150, 0, 0, 0,
	129, 21, 128, 148, 128, 142, 130, 148, 129, 149, 129, 20, 128, 142, 141, 0, 135, 0, 0, 0, 140, 14,
	140, 128, 141, 128, 140, 14, 141, 142, 141, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141,
	129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 140, 11,
	136, 141, 133, 141, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129,
	140, 131, 146, 0, 0, 0, 128, 21, 128, 128, 129, 128, 128, 21, 129, 149, 129, 128, 129, 11, 131, 141,
	133, 142, 136, 142, 138, 141, 140, 139, 141, 136, 141, 134, 140, 131, 138, 129, 136, 128, 133, 128,
	131, 129, 129, 131, 129, 11, 133, 141, 136, 141, 138, 140, 139, 139, 140, 136, 140, 134, 139, 131,
	138, 130, 136, 129, 133, 129, 129, 131, 146, 0, 0, 0, 140, 11, 138, 141, 136, 142, 133, 142, 131,
	141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 140,
	11, 139, 138, 138, 140, 136, 141, 133, 141, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131,
	130, 133, 129, 136, 129, 138, 130, 139, 132, 140, 131, 145, 0, 0, 0, 140, 21, 140, 128, 141, 128,
	140, 21, 141, 149, 141, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136,
	128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 140, 11, 136, 141, 133, 141,
	131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 140, 131, 146, 0, 0,
	0, 129, 7, 140, 135, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128,
	136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 129, 8, 139, 136, 139,
	138, 138, 140, 136, 141, 133, 141, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131, 130, 133,
	129, 136, 129, 138, 130, 139, 132, 140, 131, 145, 0, 0, 0, 136, 21, 134, 149, 132, 148, 131, 145,
	131, 128, 132, 128, 136, 21, 136, 148, 134, 148, 132, 147, 133, 20, 132, 145, 132, 128, 128, 14,
	135, 142, 135, 141, 128, 14, 128, 141, 135, 141, 141, 0, 0, 0, 141, 14, 140, 142, 140, 255, 139, 252,
	138, 251, 136, 250, 134, 250, 132, 251, 131, 252, 129, 252, 141, 14, 141, 255, 140, 252, 138, 250,
	136, 249, 133, 249, 131, 250, 129, 252, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 140, 11, 136, 141,
	133, 141, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 140, 131,
	146, 0, 0, 0, 128, 21, 128, 128, 129, 128, 128, 21, 129, 149, 129, 128, 129, 10, 132, 141, 134, 142,
	137, 142, 139, 141, 140, 138, 140, 128, 129, 10, 132, 140, 134, 141, 136, 141, 138, 140, 139, 138,
	139, 128, 140, 128, 145, 0, 0, 0, 129, 21, 128, 148, 128, 147, 129, 146, 130, 146, 131, 147, 131,
	148, 130, 149, 129, 149, 129, 20, 129, 147, 130, 147, 130, 148, 129, 148, 129, 14, 129, 128, 130,
	128, 129, 14, 130, 142, 130, 128, 136, 0, 0, 0, 129, 21, 128, 148, 128, 147, 129, 146, 130, 146, 131,
	147, 131, 148, 130, 149, 129, 149, 129, 20, 129, 147, 130, 147, 130, 148, 129, 148, 129, 14, 129,
	249, 130, 249, 129, 14, 130, 142, 130, 249, 136, 0, 0, 0, 128, 21, 128, 128, 129, 128, 128, 21, 129,
	149, 129, 128, 140, 14, 139, 142, 129, 132, 140, 14, 129, 131, 132, 7, 138, 128, 140, 128, 133, 8,
	140, 128, 145, 0, 0, 0, 128, 21, 128, 128, 129, 128, 128, 21, 129, 149, 129, 128, 134, 0, 0, 0, 128,
	14, 128, 128, 129, 128, 128, 14, 129, 142, 129, 128, 129, 10, 132, 141, 134, 142, 137, 142, 139,
	141, 140, 138, 140, 128, 129, 10, 132, 140, 134, 141, 136, 141, 138, 140, 139, 138, 139, 128, 140,
	128, 140, 10, 143, 141, 145, 142, 148, 142, 150, 141, 151, 138, 151, 128, 140, 10, 143, 140, 145,
	141, 147, 141, 149, 140, 150, 138, 150, 128, 151, 128, 156, 0, 0, 0, 128, 14, 128, 128, 129, 128,
	128, 14, 129, 142, 129, 128, 129, 10, 132, 141, 134, 142, 137, 142, 139, 141, 140, 138, 140, 128,
	129, 10, 132, 140, 134, 141, 136, 141, 138, 140, 139, 138, 139, 128, 140, 128, 145, 0, 0, 0, 133, 14,
	131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131,
	141, 134, 141, 136, 140, 139, 138, 141, 136, 142, 133, 142, 133, 13, 131, 140, 130, 139, 129, 136,
	129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131, 140, 134, 140, 136, 139, 139,
	138, 140, 136, 141, 133, 141, 146, 0, 0, 0, 128, 14, 128, 249, 129, 249, 128, 14, 129, 142, 129, 249,
	129, 11, 131, 141, 133, 142, 136, 142, 138, 141, 140, 139, 141, 136, 141, 134, 140, 131, 138, 129,
	136, 128, 133, 128, 131, 129, 129, 131, 129, 11, 133, 141, 136, 141, 138, 140, 139, 139, 140, 136,
	140, 134, 139, 131, 138, 130, 136, 129, 133, 129, 129, 131, 146, 0, 0, 0, 140, 14, 140, 249, 141,
	249, 140, 14, 141, 142, 141, 249, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128,
	136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 140, 11, 136, 141, 133,
	141, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 140, 131, 146,
	0, 0, 0, 128, 14, 128, 128, 129, 128, 129, 142, 128, 142, 129, 8, 130, 139, 132, 141, 134, 142,
	137, 142, 137, 141, 134, 141, 132, 140, 130, 138, 129, 136, 143, 0, 0, 0, 139, 11, 138, 141, 135,
	142, 132, 142, 129, 141, 128, 139, 129, 137, 131, 136, 136, 134, 138, 133, 137, 6, 138, 132, 138,
	131, 137, 129, 138, 2, 135, 129, 132, 129, 129, 130, 130, 1, 129, 131, 128, 131, 139, 11, 138, 139,
	137, 141, 138, 12, 135, 141, 132, 141, 129, 140, 130, 13, 129, 139, 130, 137, 129, 10, 131, 137,
	136, 135, 138, 134, 139, 132, 139, 131, 138, 129, 135, 128, 132, 128, 129, 129, 128, 131, 144, 0, 0,
	0, 131, 21, 131, 128, 132, 128, 131, 21, 132, 149, 132, 128, 128, 14, 135, 142, 135, 141, 128, 14,
	128, 141, 135, 141, 140, 0, 0, 0, 128, 14, 128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139,
	132, 128, 14, 129, 142, 129, 132, 130, 130, 132, 129, 134, 129, 136, 130, 139, 132, 139, 14, 139,
	128, 140, 128, 139, 14, 140, 142, 140, 128, 145, 0, 0, 0, 128, 14, 134, 128, 128, 14, 129, 142, 134,
	130, 140, 14, 139, 142, 134, 130, 140, 14, 134, 128, 145, 0, 0, 0, 128, 14, 133, 128, 128, 14, 129,
	142, 133, 131, 137, 14, 133, 131, 137, 11, 133, 128, 137, 11, 141, 128, 137, 14, 141, 131, 146, 14,
	145, 142, 141, 131, 146, 14, 141, 128, 151, 0, 0, 0, 128, 14, 139, 128, 140, 128, 128, 14, 129, 142,
	140, 128, 140, 14, 139, 142, 128, 128, 140, 14, 129, 128, 128, 128, 145, 0, 0, 0, 128, 14, 134, 128,
	128, 14, 129, 142, 134, 130, 140, 14, 139, 142, 134, 130, 130, 249, 140, 14, 134, 128, 131, 249,
	130, 249, 145, 0, 0, 0, 138, 13, 128, 128, 140, 14, 130, 129, 128, 14, 140, 142, 128, 14, 128, 141,
	138, 141, 130, 1, 140, 129, 140, 128, 128, 0, 140, 128, 145, 0, 0, 0, 133, 25, 131, 152, 130, 151,
	129, 149, 129, 147, 130, 145, 131, 144, 132, 142, 132, 140, 130, 138, 131, 24, 130, 150, 130, 148,
	131, 146, 132, 145, 133, 143, 133, 141, 132, 139, 128, 137, 132, 135, 133, 133, 133, 131, 132, 129,
	131, 128, 130, 254, 130, 252, 131, 250, 130, 8, 132, 134, 132, 132, 131, 130, 130, 129, 129, 255,
	129, 253, 130, 251, 131, 250, 133, 249, 138, 0, 0, 0, 128, 25, 128, 249, 133, 0, 0, 0, 128, 25, 130,
	152, 131, 151, 132, 149, 132, 147, 131, 145, 130, 144, 129, 142, 129, 140, 131, 138, 130, 24, 131,
	150, 131, 148, 130, 146, 129, 145, 128, 143, 128, 141, 129, 139, 133, 137, 129, 135, 128, 133, 128,
	131, 129, 129, 130, 128, 131, 254, 131, 252, 130, 250, 131, 8, 129, 134, 129, 132, 130, 130, 131,
	129, 132, 255, 132, 253, 131, 251, 130, 250, 128, 249, 138, 0, 0, 0, 128, 6, 128, 136, 129, 139, 131,
	140, 133, 140, 135, 139, 139, 136, 141, 135, 143, 135, 145, 136, 146, 138, 128, 8, 129, 138, 131,
	139, 133, 139, 135, 138, 139, 135, 141, 134, 143, 134, 145, 135, 146, 138, 146, 140, 151, 0, 0, 0,
	128, 7, 128, 128, 140, 128, 140, 135, 134, 144, 128, 135, 134, 7, 134, 135, 146, 0, 128, 0, 145, 0, 0,
	0, 143, 17, 142, 147, 140, 149, 138, 150, 134, 150, 132, 149, 130, 147, 129, 145, 128, 142, 128,
	137, 129, 134, 130, 132, 132, 130, 134, 129, 138, 129, 140, 130, 142, 132, 143, 134, 142, 134, 141,
	132, 140, 131, 138, 130, 134, 130, 132, 131, 130, 134, 129, 137, 129, 142, 130, 145, 132, 148, 134,
	149, 138, 149, 140, 148, 141, 147, 142, 145, 143, 145, 135, 1, 135, 255, 137, 255, 139, 254, 140,
	252, 140, 251, 137, 249, 139, 122, 136, 249, 133, 249, 132, 251, 131, 251, 132, 249, 133, 248, 136,
	248, 139, 249, 141, 251, 141, 252, 140, 254, 139, 255, 137, 128, 136, 128, 136, 129, 148, 0, 0, 0,
	128, 14, 128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132, 136, 130, 134, 129, 132, 129,
	130, 130, 129, 132, 129, 142, 128, 142, 139, 14, 139, 128, 140, 128, 140, 142, 139, 142, 129, 20,
	128, 147, 128, 146, 129, 145, 130, 145, 131, 146, 131, 147, 130, 148, 129, 148, 129, 19, 129, 146,
	130, 146, 130, 147, 129, 147, 137, 20, 136, 147, 136, 146, 137, 145, 138, 145, 139, 146, 139, 147,
	138, 148, 137, 148, 137, 19, 137, 146, 138, 146, 138, 147, 137, 147, 145, 0, 128, 0, 145, 0, 0, 0,
	129, 7, 140, 135, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136,
	128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 139, 132, 138, 130, 136, 129,
	133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 139, 136, 139, 138, 138, 140, 136, 141, 133, 141,
	131, 140, 130, 139, 129, 136, 139, 22, 138, 149, 137, 149, 136, 150, 136, 151, 137, 152, 138, 152,
	139, 151, 139, 148, 137, 146, 134, 145, 137, 23, 137, 150, 138, 150, 138, 151, 137, 151, 145, 0,
	128, 0, 145, 0, 0, 0, 140, 14, 140, 128, 141, 128, 141, 142, 140, 142, 140, 11, 138, 141, 136, 142,
	133, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129,
	140, 131, 136, 129, 133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 130, 139, 131, 140, 133, 141,
	136, 141, 140, 139, 132, 20, 134, 151, 136, 148, 129, 17, 134, 150, 139, 145, 146, 0, 128, 0, 146, 0,
	0, 0, 140, 14, 140, 128, 141, 128, 141, 142, 140, 142, 140, 11, 138, 141, 136, 142, 133, 142, 131,
	141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 136,
	129, 133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 130, 139, 131, 140, 133, 141, 136, 141, 140,
	139, 130, 20, 129, 147, 129, 146, 130, 145, 131, 145, 132, 146, 132, 147, 131, 148, 130, 148, 130,
	19, 130, 146, 131, 146, 131, 147, 130, 147, 138, 20, 137, 147, 137, 146, 138, 145, 139, 145, 140,
	146, 140, 147, 139, 148, 138, 148, 138, 19, 138, 146, 139, 146, 139, 147, 138, 147, 146, 0, 128, 0,
	146, 0, 0, 0, 140, 14, 140, 128, 141, 128, 141, 142, 140, 142, 140, 11, 138, 141, 136, 142, 133, 142,
	131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131,
	136, 129, 133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 130, 139, 131, 140, 133, 141, 136, 141,
	140, 139, 131, 22, 132, 149, 133, 149, 134, 150, 134, 151, 133, 152, 132, 152, 131, 151, 131, 148,
	133, 146, 136, 145, 133, 23, 133, 150, 132, 150, 132, 151, 133, 151, 146, 0, 128, 0, 146, 0, 0, 0,
	140, 14, 140, 128, 141, 128, 141, 142, 140, 142, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141,
	129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 136, 129,
	133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 130, 139, 131, 140, 133, 141, 136, 141, 140, 139,
	135, 20, 134, 147, 134, 146, 135, 145, 136, 145, 137, 146, 137, 147, 136, 148, 135, 148, 135, 19,
	135, 146, 136, 146, 136, 147, 135, 147, 146, 0, 128, 0, 146, 0, 0, 0, 128, 8, 129, 133, 131, 131, 133,
	130, 136, 130, 138, 131, 140, 133, 139, 134, 138, 132, 136, 131, 133, 131, 131, 132, 130, 133, 129,
	136, 130, 139, 131, 140, 133, 141, 136, 141, 138, 140, 139, 138, 140, 139, 138, 141, 136, 142, 133,
	142, 131, 141, 129, 139, 128, 136, 136, 123, 133, 250, 130, 250, 129, 252, 128, 252, 129, 250, 130,
	249, 133, 249, 136, 250, 138, 252, 138, 253, 137, 255, 136, 128, 134, 129, 133, 129, 133, 130, 134,
	122, 137, 252, 137, 253, 136, 255, 134, 128, 132, 128, 132, 131, 145, 0, 128, 0, 145, 0, 0, 0, 129, 7,
	140, 135, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134,
	129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 139, 132, 138, 130, 136, 129, 133, 129,
	131, 130, 130, 131, 129, 134, 129, 136, 139, 136, 139, 138, 138, 140, 136, 141, 133, 141, 131, 140,
	130, 139, 129, 136, 132, 20, 134, 151, 136, 148, 129, 17, 134, 150, 139, 145, 145, 0, 128, 0, 145, 0,
	0, 0, 129, 7, 140, 135, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128,
	136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 139, 132, 138, 130, 136,
	129, 133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 139, 136, 139, 138, 138, 140, 136, 141, 133,
	141, 131, 140, 130, 139, 129, 136, 130, 20, 129, 147, 129, 146, 130, 145, 131, 145, 132, 146, 132,
	147, 131, 148, 130, 148, 130, 19, 130, 146, 131, 146, 131, 147, 130, 147, 138, 20, 137, 147, 137,
	146, 138, 145, 139, 145, 140, 146, 140, 147, 139, 148, 138, 148, 138, 19, 138, 146, 139, 146, 139,
	147, 138, 147, 145, 0, 128, 0, 145, 0, 0, 0, 129, 7, 140, 135, 140, 138, 139, 140, 138, 141, 136, 142,
	133, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129,
	140, 131, 139, 132, 138, 130, 136, 129, 133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 139, 136,
	139, 138, 138, 140, 136, 141, 133, 141, 131, 140, 130, 139, 129, 136, 130, 22, 131, 149, 132, 149,
	133, 150, 133, 151, 132, 152, 131, 152, 130, 151, 130, 148, 132, 146, 135, 145, 132, 23, 132, 150,
	131, 150, 131, 151, 132, 151, 145, 0, 128, 0, 145, 0, 0, 0, 133, 14, 133, 128, 134, 128, 134, 142,
	133, 142, 129, 20, 128, 147, 128, 146, 129, 145, 130, 145, 131, 146, 131, 147, 130, 148, 129, 148,
	129, 19, 129, 146, 130, 146, 130, 147, 129, 147, 137, 20, 136, 147, 136, 146, 137, 145, 138, 145,
	139, 146, 139, 147, 138, 148, 137, 148, 137, 19, 137, 146, 138, 146, 138, 147, 137, 147, 143, 0,
	128, 0, 144, 0, 0, 0, 133, 14, 133, 128, 134, 128, 134, 142, 133, 142, 131, 20, 133, 151, 135, 148,
	128, 17, 133, 150, 138, 145, 141, 0, 128, 0, 143, 0, 0, 0, 132, 14, 132, 128, 133, 128, 133, 142, 132,
	142, 128, 22, 129, 149, 130, 149, 131, 150, 131, 151, 130, 152, 129, 152, 128, 151, 128, 148, 130,
	146, 133, 145, 130, 23, 130, 150, 129, 150, 129, 151, 130, 151, 136, 0, 128, 0, 138, 0, 0, 0, 136, 21,
	128, 128, 129, 128, 136, 146, 143, 128, 144, 128, 136, 149, 131, 6, 141, 134, 130, 5, 142, 133, 132,
	26, 131, 153, 131, 152, 132, 151, 133, 151, 134, 152, 134, 153, 133, 154, 132, 154, 132, 25, 132,
	152, 133, 152, 133, 153, 132, 153, 139, 26, 138, 153, 138, 152, 139, 151, 140, 151, 141, 152, 141,
	153, 140, 154, 139, 154, 139, 25, 139, 152, 140, 152, 140, 153, 139, 153, 149, 0, 128, 0, 149, 0, 0,
	0, 136, 21, 128, 128, 129, 128, 136, 146, 143, 128, 144, 128, 136, 149, 131, 6, 141, 134, 130, 5,
	142, 133, 135, 27, 134, 154, 134, 153, 135, 152, 136, 152, 137, 153, 137, 154, 136, 155, 135, 155,
	135, 26, 135, 153, 136, 153, 136, 154, 135, 154, 149, 0, 128, 0, 149, 0, 0, 0, 128, 0, 140, 128, 140,
	129, 129, 129, 129, 135, 135, 135, 135, 136, 129, 136, 129, 142, 140, 142, 140, 143, 128, 143, 128,
	128, 137, 23, 136, 150, 135, 150, 134, 151, 134, 152, 135, 153, 136, 153, 137, 152, 137, 149, 135,
	147, 132, 146, 135, 24, 135, 151, 136, 151, 136, 152, 135, 152, 145, 0, 128, 0, 145, 0, 0, 0, 140, 14,
	140, 128, 141, 128, 141, 142, 140, 142, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 136, 129, 133, 129,
	131, 130, 130, 131, 129, 134, 129, 136, 130, 139, 131, 140, 133, 141, 136, 141, 140, 139, 141, 8,
	142, 139, 144, 141, 146, 142, 149, 142, 151, 141, 153, 138, 153, 135, 142, 135, 146, 13, 149, 141,
	151, 140, 152, 138, 152, 136, 142, 136, 143, 139, 144, 140, 146, 141, 148, 13, 148, 141, 142, 8,
	142, 134, 143, 131, 144, 130, 146, 129, 149, 129, 151, 130, 152, 132, 153, 131, 151, 129, 149, 128,
	146, 128, 144, 129, 142, 131, 141, 134, 158, 0, 128, 0, 158, 0, 0, 0, 138, 21, 138, 128, 150, 128,
	150, 129, 139, 129, 139, 138, 145, 138, 145, 139, 139, 139, 139, 148, 150, 148, 150, 149, 136, 149,
	128, 128, 129, 128, 136, 146, 138, 146, 138, 6, 132, 134, 138, 5, 131, 133, 156, 0, 128, 0, 155, 0, 0,
	0, 133, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138,
	129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136, 142, 133, 142, 133, 13, 131, 140, 130,
	139, 129, 136, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131, 140, 134, 140,
	136, 139, 139, 138, 140, 136, 141, 133, 141, 132, 20, 134, 151, 136, 148, 129, 17, 134, 150, 139,
	145, 146, 0, 128, 0, 146, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131,
	129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136, 142, 133,
	142, 133, 13, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 138,
	130, 139, 131, 140, 134, 140, 136, 139, 139, 138, 140, 136, 141, 133, 141, 130, 19, 129, 146, 129,
	145, 130, 144, 131, 144, 132, 145, 132, 146, 131, 147, 130, 147, 130, 18, 130, 145, 131, 145, 131,
	146, 130, 146, 138, 19, 137, 146, 137, 145, 138, 144, 139, 144, 140, 145, 140, 146, 139, 147, 138,
	147, 138, 18, 138, 145, 139, 145, 139, 146, 138, 146, 146, 0, 128, 0, 146, 0, 0, 0, 133, 14, 131, 141,
	129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134,
	141, 136, 140, 139, 138, 141, 136, 142, 133, 142, 133, 13, 131, 140, 130, 139, 129, 136, 129, 134,
	130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131, 140, 134, 140, 136, 139, 139, 138, 140,
	136, 141, 133, 141, 131, 22, 132, 149, 133, 149, 134, 150, 134, 151, 133, 152, 132, 152, 131, 151,
	131, 148, 133, 146, 136, 145, 133, 23, 133, 150, 132, 150, 132, 151, 133, 151, 146, 0, 128, 0, 146,
	0, 0, 0, 128, 14, 128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132, 136, 130, 134, 129,
	132, 129, 130, 130, 129, 132, 129, 142, 128, 142, 139, 14, 139, 128, 140, 128, 140, 142, 139, 142,
	132, 20, 134, 151, 136, 148, 129, 17, 134, 150, 139, 145, 145, 0, 128, 0, 145, 0, 0, 0, 128, 14, 128,
	132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132, 136, 130, 134, 129, 132, 129, 130, 130, 129,
	132, 129, 142, 128, 142, 139, 14, 139, 128, 140, 128, 140, 142, 139, 142, 131, 22, 132, 149, 133,
	149, 134, 150, 134, 151, 133, 152, 132, 152, 131, 151, 131, 148, 133, 146, 136, 145, 133, 23, 133,
	150, 132, 150, 132, 151, 133, 151, 145, 0, 128, 0, 145, 0, 0, 0, 128, 14, 134, 128, 131, 249, 130,
	249, 134, 130, 129, 142, 128, 142, 134, 0, 140, 142, 139, 142, 134, 130, 129, 20, 128, 147, 128,
	146, 129, 145, 130, 145, 131, 146, 131, 147, 130, 148, 129, 148, 129, 19, 129, 146, 130, 146, 130,
	147, 129, 147, 137, 20, 136, 147, 136, 146, 137, 145, 138, 145, 139, 146, 139, 147, 138, 148, 137,
	148, 137, 19, 137, 146, 138, 146, 138, 147, 137, 147, 145, 0, 128, 0, 145, 0, 0, 0, 134, 21, 132, 148,
	130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129,
	142, 131, 143, 133, 144, 136, 144, 141, 143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 135, 20,
	132, 147, 130, 144, 129, 141, 129, 136, 130, 133, 132, 130, 135, 129, 137, 129, 140, 130, 142, 133,
	143, 136, 143, 141, 142, 144, 140, 147, 137, 148, 135, 148, 141, 27, 140, 154, 140, 153, 141, 152,
	142, 152, 143, 153, 143, 154, 142, 155, 141, 155, 141, 26, 141, 153, 142, 153, 142, 154, 141, 154,
	130, 27, 129, 154, 129, 153, 130, 152, 131, 152, 132, 153, 132, 154, 131, 155, 130, 155, 130, 26,
	130, 153, 131, 153, 131, 154, 130, 154, 149, 0, 128, 0, 149, 0, 0, 0, 128, 21, 128, 134, 129, 131,
	131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 149, 141, 149, 141, 134, 140, 131,
	139, 130, 136, 129, 134, 129, 131, 130, 130, 131, 129, 134, 129, 149, 128, 149, 130, 27, 129, 154,
	129, 153, 130, 152, 131, 152, 132, 153, 132, 154, 131, 155, 130, 155, 130, 26, 130, 153, 131, 153,
	131, 154, 130, 154, 138, 27, 137, 154, 137, 153, 138, 152, 139, 152, 140, 153, 140, 154, 139, 155,
	138, 155, 138, 26, 138, 153, 139, 153, 139, 154, 138, 154, 147, 0, 128, 0, 147, 0, 0, 0, 133, 14, 131,
	141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141,
	134, 141, 136, 140, 139, 138, 141, 136, 142, 133, 142, 133, 13, 131, 140, 130, 139, 129, 136, 129,
	134, 130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131, 140, 134, 140, 136, 139, 139, 138,
	140, 136, 141, 133, 141, 128, 124, 130, 252, 142, 145, 140, 145, 128, 252, 141, 17, 129, 252, 147,
	0, 0, 0, 131, 0, 141, 128, 143, 129, 143, 132, 142, 133, 140, 133, 140, 132, 141, 132, 142, 131,
	142, 130, 140, 129, 132, 129, 132, 144, 133, 146, 134, 147, 136, 147, 137, 146, 138, 146, 138, 147,
	137, 148, 134, 148, 132, 147, 131, 144, 131, 128, 128, 11, 138, 139, 137, 140, 128, 140, 128, 139,
	150, 0, 128, 0, 148, 0, 0, 0, 135, 21, 133, 148, 131, 146, 130, 144, 129, 141, 129, 136, 130, 133,
	131, 131, 133, 129, 135, 128, 139, 128, 141, 129, 143, 131, 144, 133, 145, 136, 145, 141, 144, 144,
	143, 146, 141, 148, 139, 149, 135, 149, 136, 20, 133, 147, 131, 144, 130, 141, 130, 136, 131, 133,
	133, 130, 136, 129, 138, 129, 141, 130, 143, 133, 144, 136, 144, 141, 143, 144, 141, 147, 138, 148,
	136, 148, 146, 27, 128, 251, 129, 251, 147, 155, 146, 155, 149, 0, 128, 0, 152, 0, 0, 0, 129, 14, 137,
	142, 139, 143, 140, 144, 141, 146, 141, 149, 140, 151, 139, 152, 137, 153, 128, 153, 128, 128, 129,
	128, 129, 152, 137, 152, 139, 151, 140, 149, 140, 146, 139, 144, 137, 143, 129, 143, 138, 12, 145,
	140, 145, 139, 138, 139, 138, 140, 141, 0, 141, 144, 142, 144, 142, 128, 141, 128, 151, 0, 0, 0, 134,
	13, 134, 254, 133, 252, 132, 251, 130, 251, 129, 252, 128, 252, 128, 251, 129, 250, 132, 250, 134,
	251, 135, 254, 135, 142, 135, 13, 135, 130, 135, 3, 135, 146, 136, 148, 137, 149, 139, 149, 140,
	148, 141, 148, 141, 149, 140, 150, 137, 150, 135, 149, 134, 146, 134, 130, 130, 8, 140, 136, 139,
	137, 130, 137, 130, 136, 146, 0, 0, 0, 140, 14, 140, 128, 141, 128, 141, 142, 140, 142, 140, 11, 138,
	141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136,
	128, 138, 129, 140, 131, 136, 129, 133, 129, 131, 130, 130, 131, 129, 134, 129, 136, 130, 139, 131,
	140, 133, 141, 136, 141, 140, 139, 139, 22, 138, 149, 137, 149, 136, 150, 136, 151, 137, 152, 138,
	152, 139, 151, 139, 148, 137, 146, 134, 145, 137, 23, 137, 150, 138, 150, 138, 151, 137, 151, 146,
	0, 128, 0, 146, 0, 0, 0, 129, 14, 129, 128, 130, 128, 130, 142, 129, 142, 134, 22, 133, 149, 132,
	149, 131, 150, 131, 151, 132, 152, 133, 152, 134, 151, 134, 148, 132, 146, 129, 145, 132, 23, 132,
	150, 133, 150, 133, 151, 132, 151, 136, 0, 128, 0, 139, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128,
	136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140,
	139, 138, 141, 136, 142, 133, 142, 133, 13, 131, 140, 130, 139, 129, 136, 129, 134, 130, 131, 131,
	130, 133, 129, 136, 129, 138, 130, 139, 131, 140, 134, 140, 136, 139, 139, 138, 140, 136, 141, 133,
	141, 138, 22, 137, 149, 136, 149, 135, 150, 135, 151, 136, 152, 137, 152, 138, 151, 138, 148, 136,
	146, 133, 145, 136, 23, 136, 150, 137, 150, 137, 151, 136, 151, 146, 0, 128, 0, 146, 0, 0, 0, 128, 14,
	128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132, 136, 130, 134, 129, 132, 129, 130, 130,
	129, 132, 129, 142, 128, 142, 139, 14, 139, 128, 140, 128, 140, 142, 139, 142, 137, 22, 136, 149,
	135, 149, 134, 150, 134, 151, 135, 152, 136, 152, 137, 151, 137, 148, 135, 146, 132, 145, 135, 23,
	135, 150, 136, 150, 136, 151, 135, 151, 145, 0, 128, 0, 145, 0, 0, 0, 131, 14, 131, 128, 132, 128,
	132, 142, 131, 142, 132, 10, 135, 141, 137, 142, 140, 142, 142, 141, 143, 138, 143, 128, 142, 128,
	142, 138, 141, 140, 139, 141, 137, 141, 135, 140, 132, 138, 128, 17, 128, 147, 129, 150, 131, 151,
	133, 151, 135, 150, 139, 147, 141, 146, 143, 146, 145, 147, 146, 149, 146, 151, 128, 19, 129, 149,
	131, 150, 133, 150, 135, 149, 139, 146, 141, 145, 143, 145, 145, 146, 146, 149, 147, 0, 128, 0, 151,
	0, 0, 0, 131, 21, 131, 128, 132, 128, 132, 146, 145, 128, 145, 149, 144, 149, 144, 131, 131, 149,
	129, 24, 129, 154, 130, 157, 132, 158, 134, 158, 136, 157, 140, 154, 142, 153, 144, 153, 146, 154,
	147, 156, 147, 158, 129, 26, 130, 156, 132, 157, 134, 157, 136, 156, 140, 153, 142, 152, 144, 152,
	146, 153, 147, 156, 151, 0, 0, 0, 140, 21, 140, 135, 141, 135, 141, 149, 140, 149, 140, 18, 138, 148,
	136, 149, 133, 149, 131, 148, 129, 146, 128, 143, 128, 141, 129, 138, 131, 136, 133, 135, 136, 135,
	138, 136, 140, 138, 136, 136, 133, 136, 131, 137, 130, 138, 129, 141, 129, 143, 130, 146, 131, 147,
	133, 148, 136, 148, 140, 146, 142, 0, 142, 129, 128, 129, 128, 128, 142, 128, 146, 0, 128, 0, 147, 0,
	0, 0, 128, 15, 129, 140, 131, 138, 133, 137, 136, 137, 138, 138, 140, 140, 141, 143, 140, 146,
	138, 148, 136, 149, 133, 149, 131, 148, 129, 146, 128, 143, 129, 15, 130, 140, 131, 139, 133, 138,
	136, 138, 138, 139, 139, 140, 140, 143, 139, 146, 138, 147, 136, 148, 133, 148, 131, 147, 130, 146,
	129, 143, 141, 1, 141, 128, 128, 128, 128, 129, 141, 129, 146, 0, 128, 0, 146, 0, 0, 0, 134, 10, 134,
	142, 135, 142, 135, 138, 132, 137, 130, 136, 129, 134, 129, 132, 130, 130, 133, 129, 136, 129, 139,
	130, 140, 132, 140, 133, 141, 133, 141, 132, 140, 130, 139, 129, 136, 128, 133, 128, 130, 129, 129,
	130, 128, 132, 128, 134, 129, 136, 130, 137, 132, 138, 135, 139, 140, 3, 137, 129, 132, 1, 129, 131,
	129, 7, 133, 138, 135, 18, 136, 147, 136, 148, 135, 149, 134, 149, 133, 148, 133, 147, 134, 146,
	135, 146, 135, 19, 135, 148, 134, 148, 134, 147, 135, 147, 146, 0, 128, 0, 146, 0, 0, 0, 128, 8, 128,
	128, 130, 128, 130, 134, 141, 134, 141, 136, 128, 136, 146, 0, 128, 0, 146, 0, 0, 0, 141, 8, 141, 128,
	139, 128, 139, 134, 128, 134, 128, 136, 141, 136, 146, 0, 128, 0, 146, 0, 0, 0, 144, 21, 142, 149,
	128, 128, 130, 128, 144, 149, 133, 21, 133, 139, 131, 139, 131, 146, 129, 145, 128, 146, 132, 149,
	133, 149, 136, 0, 144, 128, 144, 129, 137, 129, 143, 133, 144, 134, 144, 137, 142, 138, 138, 138,
	137, 137, 137, 135, 138, 135, 138, 136, 139, 137, 142, 137, 143, 136, 143, 134, 136, 129, 136, 128,
	149, 0, 128, 0, 149, 0, 0, 0, 144, 21, 142, 149, 128, 128, 130, 128, 144, 149, 133, 21, 133, 139, 131,
	139, 131, 146, 129, 145, 128, 146, 132, 149, 133, 149, 142, 0, 142, 138, 135, 130, 144, 130, 144,
	131, 137, 131, 141, 135, 141, 128, 142, 128, 149, 0, 128, 0, 149, 0, 0, 0, 129, 0, 129, 142, 130, 142,
	130, 128, 129, 128, 129, 18, 128, 147, 128, 148, 129, 149, 130, 149, 131, 148, 131, 147, 130, 146,
	129, 146, 129, 19, 129, 148, 130, 148, 130, 147, 129, 147, 136, 0, 128, 0, 136, 0, 0, 0, 134, 5, 128,
	139, 134, 145, 140, 5, 134, 139, 140, 145, 145, 0, 128, 0, 145, 0, 0, 0, 134, 5, 140, 139, 134, 145,
	128, 5, 134, 139, 128, 145, 145, 0, 128, 0, 145, 0, 0, 0, 128, 12, 130, 140, 130, 138, 128, 138, 128,
	140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129, 132, 128, 0,
	130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254, 128, 18, 130, 146, 130, 144, 128, 144,
	128, 146, 129, 18, 129, 144, 133, 15, 135, 143, 135, 141, 133, 141, 133, 143, 134, 15, 134, 141,
	133, 9, 135, 137, 135, 135, 133, 135, 133, 137, 134, 9, 134, 135, 133, 3, 135, 131, 135, 129, 133,
	129, 133, 131, 134, 3, 134, 129, 133, 21, 135, 149, 135, 147, 133, 147, 133, 149, 134, 21, 134, 147,
	138, 12, 140, 140, 140, 138, 138, 138, 138, 140, 139, 12, 139, 138, 138, 6, 140, 134, 140, 132, 138,
	132, 138, 134, 139, 6, 139, 132, 138, 0, 140, 128, 140, 254, 138, 254, 138, 128, 139, 0, 139, 254,
	138, 18, 140, 146, 140, 144, 138, 144, 138, 146, 139, 18, 139, 144, 143, 15, 145, 143, 145, 141,
	143, 141, 143, 143, 144, 15, 144, 141, 143, 9, 145, 137, 145, 135, 143, 135, 143, 137, 144, 9, 144,
	135, 143, 3, 145, 131, 145, 129, 143, 129, 143, 131, 144, 3, 144, 129, 143, 21, 145, 149, 145, 147,
	143, 147, 143, 149, 144, 21, 144, 147, 132, 125, 132, 251, 134, 251, 134, 253, 132, 253, 133, 125,
	133, 251, 143, 125, 145, 253, 145, 251, 143, 251, 143, 253, 144, 125, 144, 251, 145, 0, 0, 0, 128,
	12, 130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128,
	132, 128, 134, 129, 6, 129, 132, 128, 0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254,
	128, 18, 130, 146, 130, 144, 128, 144, 128, 146, 129, 18, 129, 144, 130, 15, 132, 143, 132, 141,
	130, 141, 130, 143, 131, 15, 131, 141, 130, 9, 132, 137, 132, 135, 130, 135, 130, 137, 131, 9, 131,
	135, 130, 3, 132, 131, 132, 129, 130, 129, 130, 131, 131, 3, 131, 129, 130, 21, 132, 149, 132, 147,
	130, 147, 130, 149, 131, 21, 131, 147, 132, 12, 134, 140, 134, 138, 132, 138, 132, 140, 133, 12,
	133, 138, 132, 6, 134, 134, 134, 132, 132, 132, 132, 134, 133, 6, 133, 132, 132, 0, 134, 128, 134,
	254, 132, 254, 132, 128, 133, 0, 133, 254, 132, 18, 134, 146, 134, 144, 132, 144, 132, 146, 133, 18,
	133, 144, 134, 15, 136, 143, 136, 141, 134, 141, 134, 143, 135, 15, 135, 141, 134, 9, 136, 137, 136,
	135, 134, 135, 134, 137, 135, 9, 135, 135, 134, 3, 136, 131, 136, 129, 134, 129, 134, 131, 135, 3,
	135, 129, 134, 21, 136, 149, 136, 147, 134, 147, 134, 149, 135, 21, 135, 147, 136, 12, 138, 140,
	138, 138, 136, 138, 136, 140, 137, 12, 137, 138, 136, 6, 138, 134, 138, 132, 136, 132, 136, 134,
	137, 6, 137, 132, 136, 0, 138, 128, 138, 254, 136, 254, 136, 128, 137, 0, 137, 254, 136, 18, 138,
	146, 138, 144, 136, 144, 136, 146, 137, 18, 137, 144, 138, 15, 140, 143, 140, 141, 138, 141, 138,
	143, 139, 15, 139, 141, 138, 9, 140, 137, 140, 135, 138, 135, 138, 137, 139, 9, 139, 135, 138, 3,
	140, 131, 140, 129, 138, 129, 138, 131, 139, 3, 139, 129, 138, 21, 140, 149, 140, 147, 138, 147,
	138, 149, 139, 21, 139, 147, 140, 12, 142, 140, 142, 138, 140, 138, 140, 140, 141, 12, 141, 138,
	140, 6, 142, 134, 142, 132, 140, 132, 140, 134, 141, 6, 141, 132, 140, 0, 142, 128, 142, 254, 140,
	254, 140, 128, 141, 0, 141, 254, 140, 18, 142, 146, 142, 144, 140, 144, 140, 146, 141, 18, 141, 144,
	142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 143, 15, 143, 141, 142, 9, 144, 137, 144, 135, 142,
	135, 142, 137, 143, 9, 143, 135, 142, 3, 144, 131, 144, 129, 142, 129, 142, 131, 143, 3, 143, 129,
	142, 21, 144, 149, 144, 147, 142, 147, 142, 149, 143, 21, 143, 147, 130, 125, 130, 251, 132, 251,
	132, 253, 130, 253, 131, 125, 131, 251, 134, 125, 134, 251, 136, 251, 136, 253, 134, 253, 135, 125,
	135, 251, 138, 125, 138, 251, 140, 251, 140, 253, 138, 253, 139, 125, 139, 251, 144, 0, 0, 0, 128,
	21, 130, 149, 130, 147, 128, 147, 128, 149, 129, 21, 129, 147, 130, 21, 132, 149, 132, 147, 130,
	147, 130, 149, 131, 21, 131, 147, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139,
	147, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21, 141, 147, 148, 21, 150, 149, 150,
	147, 148, 147, 148, 149, 149, 21, 149, 147, 150, 21, 152, 149, 152, 147, 150, 147, 150, 149, 151,
	21, 151, 147, 132, 17, 134, 145, 134, 143, 132, 143, 132, 145, 133, 17, 133, 143, 134, 17, 136,
	145, 136, 143, 134, 143, 134, 145, 135, 17, 135, 143, 136, 17, 138, 145, 138, 143, 136, 143, 136,
	145, 137, 17, 137, 143, 128, 13, 130, 141, 130, 139, 128, 139, 128, 141, 129, 13, 129, 139, 130, 13,
	132, 141, 132, 139, 130, 139, 130, 141, 131, 13, 131, 139, 138, 13, 140, 141, 140, 139, 138, 139,
	138, 141, 139, 13, 139, 139, 140, 13, 142, 141, 142, 139, 140, 139, 140, 141, 141, 13, 141, 139,
	148, 13, 150, 141, 150, 139, 148, 139, 148, 141, 149, 13, 149, 139, 150, 13, 152, 141, 152, 139,
	150, 139, 150, 141, 151, 13, 151, 139, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143,
	135, 144, 9, 146, 137, 146, 135, 144, 135, 144, 137, 145, 9, 145, 135, 146, 9, 148, 137, 148, 135,
	146, 135, 146, 137, 147, 9, 147, 135, 128, 5, 130, 133, 130, 131, 128, 131, 128, 133, 129, 5, 129,
	131, 130, 5, 132, 133, 132, 131, 130, 131, 130, 133, 131, 5, 131, 131, 138, 5, 140, 133, 140, 131,
	138, 131, 138, 133, 139, 5, 139, 131, 140, 5, 142, 133, 142, 131, 140, 131, 140, 133, 141, 5, 141,
	131, 148, 5, 150, 133, 150, 131, 148, 131, 148, 133, 149, 5, 149, 131, 150, 5, 152, 133, 152, 131,
	150, 131, 150, 133, 151, 5, 151, 131, 132, 1, 138, 129, 138, 255, 132, 255, 132, 129, 133, 1, 133,
	255, 135, 1, 135, 255, 137, 1, 137, 255, 128, 125, 130, 253, 130, 251, 128, 251, 128, 253, 129, 125,
	129, 251, 130, 125, 132, 253, 132, 251, 130, 251, 130, 253, 131, 125, 131, 251, 138, 125, 140, 253,
	140, 251, 138, 251, 138, 253, 139, 125, 139, 251, 140, 125, 142, 253, 142, 251, 140, 251, 140, 253,
	141, 125, 141, 251, 148, 125, 150, 253, 150, 251, 148, 251, 148, 253, 149, 125, 149, 251, 150, 125,
	152, 253, 152, 251, 150, 251, 150, 253, 151, 125, 151, 251, 134, 1, 134, 255, 136, 1, 136, 255, 146,
	17, 148, 145, 148, 143, 146, 143, 146, 145, 147, 17, 147, 143, 148, 17, 150, 145, 150, 143, 148,
	143, 148, 145, 149, 17, 149, 143, 150, 17, 152, 145, 152, 143, 150, 143, 150, 145, 151, 17, 151,
	143, 128, 9, 130, 137, 130, 135, 128, 135, 128, 137, 129, 9, 129, 135, 130, 9, 132, 137, 132, 135,
	130, 135, 130, 137, 131, 9, 131, 135, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133,
	135, 146, 1, 152, 129, 152, 255, 146, 255, 146, 129, 147, 1, 147, 255, 149, 1, 149, 255, 151, 1, 151,
	255, 148, 1, 148, 255, 150, 1, 150, 255, 152, 0, 0, 0, 128, 21, 128, 249, 136, 0, 128, 0, 133, 0, 0, 0,
	136, 21, 136, 249, 136, 5, 128, 133, 142, 0, 128, 0, 141, 0, 0, 0, 136, 21, 136, 249, 136, 5, 128, 133,
	128, 9, 136, 137, 142, 0, 128, 0, 141, 0, 0, 0, 136, 21, 136, 249, 144, 21, 144, 249, 128, 5, 136, 133,
	149, 0, 128, 0, 149, 0, 0, 0, 128, 5, 144, 133, 144, 249, 136, 5, 136, 249, 149, 0, 128, 0, 149, 0, 0, 0,
	128, 6, 136, 134, 136, 249, 128, 4, 136, 132, 142, 0, 128, 0, 141, 0, 0, 0, 144, 21, 144, 249, 128, 5,
	136, 133, 136, 249, 128, 9, 136, 137, 136, 149, 149, 0, 128, 0, 149, 0, 0, 0, 136, 21, 136, 249, 144,
	21, 144, 249, 149, 0, 128, 0, 149, 0, 0, 0, 128, 9, 144, 137, 144, 249, 128, 5, 136, 133, 136, 249,
	149, 0, 128, 0, 149, 0, 0, 0, 128, 5, 144, 133, 144, 149, 128, 9, 136, 137, 136, 149, 149, 0, 128, 0,
	149, 0, 0, 0, 128, 9, 144, 137, 144, 149, 136, 9, 136, 149, 149, 0, 128, 0, 149, 0, 0, 0, 128, 8, 136,
	136, 136, 149, 128, 10, 136, 138, 142, 0, 128, 0, 141, 0, 0, 0, 128, 4, 136, 132, 136, 249, 142, 0,
	128, 0, 141, 0, 0, 0, 136, 10, 128, 138, 128, 149, 136, 0, 0, 0, 128, 10, 136, 138, 136, 149, 144, 10,
	136, 138, 144, 0, 0, 0, 128, 4, 136, 132, 136, 249, 144, 4, 136, 132, 144, 0, 0, 0, 128, 21, 128, 249,
	128, 5, 136, 133, 136, 0, 0, 0, 128, 5, 144, 133, 144, 0, 0, 0, 136, 21, 136, 249, 144, 5, 128, 133,
	144, 0, 0, 0, 128, 121, 128, 149, 128, 9, 136, 137, 136, 5, 128, 133, 136, 0, 0, 0, 136, 21, 136, 249,
	128, 21, 128, 249, 144, 5, 136, 133, 144, 0, 0, 0, 144, 5, 128, 133, 128, 149, 144, 9, 136, 137, 136,
	149, 144, 0, 0, 0, 144, 9, 128, 137, 128, 249, 144, 5, 136, 133, 136, 249, 144, 0, 0, 0, 128, 5, 152,
	133, 128, 9, 136, 137, 136, 149, 152, 9, 144, 137, 144, 149, 152, 0, 0, 0, 128, 9, 152, 137, 128, 5,
	136, 133, 136, 249, 152, 5, 144, 133, 144, 249, 152, 0, 0, 0, 128, 21, 128, 249, 144, 5, 136, 133,
	136, 249, 144, 9, 136, 137, 136, 149, 144, 0, 0, 0, 128, 5, 144, 133, 128, 9, 144, 137, 144, 0, 0, 0,
	128, 5, 136, 133, 136, 249, 128, 9, 136, 137, 136, 149, 144, 21, 144, 137, 152, 137, 144, 121, 144,
	133, 152, 133, 152, 0, 0, 0, 128, 5, 144, 133, 128, 10, 144, 138, 136, 21, 136, 138, 144, 0, 0, 0, 128,
	9, 144, 137, 134, 21, 134, 137, 142, 21, 142, 137, 144, 0, 0, 0, 128, 9, 144, 137, 128, 4, 144, 132,
	136, 121, 136, 132, 144, 0, 0, 0, 128, 5, 144, 133, 134, 121, 134, 133, 142, 121, 142, 133, 144, 0, 0,
	0, 144, 9, 128, 137, 128, 149, 136, 9, 136, 149, 144, 0, 0, 0, 136, 8, 128, 136, 128, 149, 136, 10,
	128, 138, 136, 0, 0, 0, 136, 6, 128, 134, 128, 249, 136, 4, 128, 132, 136, 0, 0, 0, 144, 5, 128, 133,
	128, 249, 136, 5, 136, 249, 144, 0, 0, 0, 136, 21, 136, 249, 144, 5, 128, 133, 144, 0, 0, 0, 136, 21,
	136, 249, 144, 5, 128, 133, 128, 9, 144, 137, 144, 0, 0, 0, 128, 10, 136, 138, 136, 149, 142, 0, 128,
	0, 141, 0, 0, 0, 136, 4, 128, 132, 128, 249, 136, 0, 0, 0, 128, 21, 144, 149, 144, 128, 128, 128,
	128, 149, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128, 133, 21, 133,
	128, 134, 21, 134, 128, 135, 0, 135, 149, 136, 21, 136, 128, 137, 21, 137, 128, 138, 21, 138, 128,
	139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142, 21, 142, 128, 143, 21, 143, 128, 128,
	11, 144, 139, 144, 0, 0, 0, 144, 0, 128, 128, 128, 139, 144, 139, 144, 128, 129, 11, 129, 128, 130,
	11, 130, 128, 131, 11, 131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134, 11, 134, 128, 135, 11,
	135, 128, 136, 11, 136, 128, 137, 11, 137, 128, 138, 11, 138, 128, 139, 11, 139, 128, 140, 11, 140,
	128, 141, 11, 141, 128, 142, 11, 142, 128, 143, 11, 143, 128, 144, 0, 0, 0, 128, 0, 128, 149, 136,
	149, 136, 128, 128, 128, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128,
	133, 21, 133, 128, 134, 21, 134, 128, 135, 0, 135, 149, 136, 0, 0, 0, 137, 0, 137, 149, 145, 149, 145,
	128, 137, 128, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142, 21,
	142, 128, 143, 21, 143, 128, 144, 0, 144, 149, 145, 0, 0, 0, 144, 10, 128, 138, 128, 149, 144, 149,
	144, 138, 129, 21, 129, 138, 130, 21, 130, 138, 131, 21, 131, 138, 132, 21, 132, 138, 133, 21, 133,
	138, 134, 21, 134, 138, 135, 21, 135, 138, 136, 21, 136, 138, 137, 21, 137, 138, 138, 21, 138, 138,
	139, 21, 139, 138, 140, 21, 140, 138, 141, 21, 141, 138, 142, 21, 142, 138, 143, 21, 143, 138, 144,
	0, 0, 0, 140, 9, 138, 139, 136, 140, 133, 140, 131, 139, 129, 137, 128, 134, 129, 131, 131, 129,
	133, 128, 136, 128, 138, 129, 140, 131, 147, 142, 146, 142, 139, 131, 138, 130, 136, 129, 133, 129,
	131, 130, 130, 131, 129, 134, 130, 137, 131, 138, 133, 139, 136, 139, 138, 138, 139, 137, 146, 128,
	147, 128, 140, 137, 151, 0, 128, 0, 152, 0, 0, 0, 129, 1, 137, 129, 139, 130, 139, 134, 136, 135, 139,
	136, 139, 139, 137, 141, 129, 141, 128, 140, 128, 251, 129, 251, 129, 135, 135, 135, 138, 133, 138,
	131, 137, 130, 129, 130, 129, 11, 130, 140, 137, 140, 138, 139, 138, 137, 136, 136, 129, 136, 129,
	139, 144, 0, 0, 0, 129, 0, 129, 143, 138, 143, 138, 141, 139, 141, 139, 144, 128, 144, 128, 128, 142,
	0, 128, 0, 144, 0, 0, 0, 131, 15, 131, 128, 132, 128, 132, 143, 139, 143, 139, 128, 140, 128, 140,
	143, 142, 143, 142, 144, 128, 144, 128, 143, 131, 143, 145, 0, 128, 0, 147, 0, 0, 0, 128, 21, 140,
	149, 140, 148, 130, 148, 136, 139, 130, 129, 140, 129, 140, 128, 128, 128, 135, 139, 128, 149, 145,
	0, 128, 0, 145, 0, 0, 0, 133, 12, 131, 139, 129, 137, 128, 134, 129, 131, 131, 129, 133, 128, 136,
	128, 138, 129, 140, 131, 141, 134, 140, 137, 138, 139, 136, 140, 133, 140, 135, 141, 147, 141, 147,
	142, 134, 142, 131, 139, 133, 11, 131, 138, 130, 137, 129, 134, 130, 131, 131, 130, 133, 129, 136,
	129, 138, 130, 139, 131, 140, 134, 139, 137, 138, 138, 136, 139, 133, 139, 152, 0, 0, 0, 131, 14,
	131, 132, 132, 129, 134, 128, 137, 128, 139, 129, 142, 132, 139, 130, 137, 129, 135, 129, 133, 130,
	132, 132, 132, 142, 131, 142, 142, 14, 142, 128, 143, 128, 143, 142, 142, 142, 132, 1, 132, 253,
	129, 250, 130, 250, 133, 253, 133, 129, 148, 0, 0, 0, 136, 11, 136, 254, 137, 254, 137, 136, 143,
	141, 142, 141, 137, 137, 137, 140, 136, 141, 134, 142, 131, 142, 129, 140, 129, 138, 130, 138, 130,
	140, 131, 141, 134, 141, 136, 139, 148, 0, 0, 0, 133, 15, 131, 142, 129, 140, 128, 137, 129, 134,
	131, 132, 133, 131, 136, 131, 138, 132, 140, 134, 141, 137, 140, 140, 138, 142, 136, 143, 133, 143,
	133, 14, 131, 141, 130, 140, 129, 137, 130, 134, 131, 133, 133, 132, 136, 132, 138, 133, 139, 134,
	140, 137, 139, 140, 138, 141, 136, 142, 133, 142, 135, 15, 135, 148, 141, 148, 141, 149, 128, 149,
	128, 148, 134, 148, 134, 143, 136, 3, 136, 131, 135, 3, 135, 254, 141, 254, 141, 253, 128, 253, 128,
	254, 134, 254, 134, 131, 145, 0, 128, 0, 146, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144, 128,
	141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133, 144,
	136, 144, 141, 143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 135, 20, 132, 147, 130, 144, 129,
	141, 129, 139, 143, 139, 143, 141, 142, 144, 140, 147, 137, 148, 135, 148, 129, 8, 130, 133, 132,
	130, 135, 129, 137, 129, 140, 130, 142, 133, 143, 136, 143, 138, 129, 138, 129, 136, 149, 0, 128, 0,
	149, 0, 0, 0, 129, 13, 130, 144, 132, 147, 135, 148, 137, 148, 140, 147, 142, 144, 143, 141, 143,
	137, 142, 135, 139, 133, 139, 128, 144, 128, 144, 129, 140, 129, 140, 133, 143, 135, 144, 137, 144,
	141, 143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 132, 148, 130, 146, 129, 144, 128, 141, 128,
	137, 129, 135, 132, 133, 132, 129, 128, 129, 128, 128, 133, 128, 133, 133, 130, 135, 129, 137, 129,
	141, 128, 8, 128, 136, 149, 0, 128, 0, 149, 0, 0, 0, 133, 12, 131, 139, 129, 137, 128, 134, 129, 131,
	131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 140, 137, 138, 139, 136, 140, 133, 140,
	133, 11, 131, 138, 130, 137, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131,
	140, 134, 139, 137, 138, 138, 136, 139, 133, 139, 138, 11, 129, 148, 141, 148, 141, 149, 128, 149,
	128, 148, 136, 140, 144, 0, 128, 0, 146, 0, 0, 0, 133, 12, 131, 139, 129, 137, 128, 134, 129, 131,
	131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 140, 137, 138, 139, 136, 140, 133, 140,
	133, 11, 131, 138, 130, 137, 129, 134, 130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131,
	140, 134, 139, 137, 138, 138, 136, 139, 133, 139, 145, 12, 143, 139, 141, 137, 140, 134, 141, 131,
	143, 129, 145, 128, 148, 128, 150, 129, 152, 131, 153, 134, 152, 137, 150, 139, 148, 140, 145, 140,
	145, 11, 143, 138, 142, 137, 141, 134, 142, 131, 143, 130, 145, 129, 148, 129, 150, 130, 151, 131,
	152, 134, 151, 137, 150, 138, 148, 139, 145, 139, 157, 0, 128, 0, 158, 0, 0, 0, 133, 14, 131, 141,
	129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134,
	141, 136, 140, 139, 138, 141, 136, 142, 133, 142, 133, 13, 131, 140, 130, 139, 129, 136, 129, 134,
	130, 131, 131, 130, 133, 129, 136, 129, 138, 130, 139, 131, 140, 134, 140, 136, 139, 139, 138, 140,
	136, 141, 133, 141, 128, 124, 130, 252, 142, 145, 140, 145, 128, 252, 141, 17, 129, 252, 147, 0, 0,
	0, 129, 5, 129, 138, 135, 138, 135, 139, 129, 139, 129, 147, 131, 148, 140, 148, 140, 149, 131,
	149, 128, 147, 128, 130, 131, 128, 140, 128, 140, 129, 131, 129, 129, 130, 129, 133, 145, 0, 128, 0,
	145, 0, 0, 0, 128, 0, 128, 143, 129, 146, 131, 148, 134, 149, 136, 149, 139, 148, 141, 146, 142, 143,
	142, 128, 141, 128, 141, 143, 140, 146, 139, 147, 136, 148, 134, 148, 131, 147, 130, 146, 129, 143,
	129, 128, 128, 128, 147, 0, 128, 0, 147, 0, 0, 0, 128, 9, 145, 137, 145, 136, 128, 136, 128, 137, 128,
	5, 145, 133, 145, 132, 128, 132, 128, 133, 128, 13, 145, 141, 145, 140, 128, 140, 128, 141, 149,
	0, 128, 0, 150, 0, 0, 0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 136, 21, 136, 132, 137,
	132, 137, 149, 136, 149, 128, 13, 145, 141, 145, 140, 128, 140, 128, 141, 150, 0, 128, 0, 150, 0, 0,
	0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 128, 21, 145, 141, 129, 132, 128, 132, 143,
	141, 128, 149, 145, 141, 129, 149, 128, 149, 150, 0, 128, 0, 150, 0, 0, 0, 145, 1, 128, 129, 128, 128,
	145, 128, 145, 129, 145, 21, 128, 141, 144, 132, 145, 132, 130, 141, 145, 149, 128, 141, 144, 149,
	145, 149, 150, 0, 128, 0, 150, 0, 0, 0, 129, 2, 129, 145, 130, 147, 131, 148, 133, 148, 134, 147, 135,
	147, 135, 148, 134, 149, 131, 149, 129, 148, 128, 145, 128, 249, 129, 249, 129, 130, 139, 0, 128, 0,
	140, 0, 0, 0, 134, 12, 134, 253, 133, 251, 132, 250, 130, 250, 129, 251, 128, 251, 128, 250, 129,
	249, 132, 249, 134, 250, 135, 253, 135, 149, 134, 149, 134, 140, 139, 0, 128, 0, 140, 0, 0, 0, 136,
	21, 135, 148, 135, 147, 136, 146, 137, 146, 138, 147, 138, 148, 137, 149, 136, 149, 136, 20, 136,
	147, 137, 147, 137, 148, 136, 148, 136, 3, 135, 130, 135, 129, 136, 128, 137, 128, 138, 129, 138,
	130, 137, 131, 136, 131, 136, 2, 136, 129, 137, 129, 137, 130, 136, 130, 128, 11, 145, 139, 145,
	138, 128, 138, 128, 139, 150, 0, 128, 0, 150, 0, 0, 0, 128, 10, 128, 140, 129, 143, 131, 144, 133,
	144, 135, 143, 139, 140, 141, 139, 143, 139, 145, 140, 146, 142, 146, 144, 128, 12, 129, 142, 131,
	143, 133, 143, 135, 142, 139, 139, 141, 138, 143, 138, 145, 139, 146, 142, 128, 3, 128, 133, 129,
	136, 131, 137, 133, 137, 135, 136, 139, 133, 141, 132, 143, 132, 145, 133, 146, 135, 146, 137, 128,
	5, 129, 135, 131, 136, 133, 136, 135, 135, 139, 132, 141, 131, 143, 131, 145, 132, 146, 135, 151,
	0, 128, 0, 151, 0, 0, 0, 133, 21, 131, 148, 129, 146, 128, 143, 129, 140, 131, 138, 133, 137, 136,
	137, 138, 138, 140, 140, 141, 143, 140, 146, 138, 148, 136, 149, 133, 149, 133, 20, 131, 147, 130,
	146, 129, 143, 130, 140, 131, 139, 133, 138, 136, 138, 138, 139, 139, 140, 140, 143, 139, 146, 138,
	147, 136, 148, 133, 148, 144, 0, 128, 0, 146, 0, 0, 0, 132, 0, 128, 128, 128, 132, 132, 132, 132, 128,
	129, 4, 129, 128, 130, 4, 130, 128, 131, 4, 131, 128, 128, 2, 132, 130, 140, 0, 128, 0, 137, 0, 0, 0,
	132, 0, 128, 128, 128, 130, 132, 130, 132, 128, 129, 2, 129, 128, 130, 2, 130, 128, 131, 2, 131, 128,
	136, 0, 128, 0, 137, 0, 0, 0, 136, 20, 136, 128, 135, 128, 128, 138, 128, 139, 135, 130, 135, 149,
	146, 149, 146, 148, 136, 148, 148, 0, 128, 0, 151, 0, 0, 0, 129, 21, 128, 149, 128, 138, 129, 138,
	129, 149, 129, 17, 132, 148, 134, 149, 137, 149, 139, 148, 140, 145, 140, 138, 139, 138, 139, 145,
	138, 147, 136, 148, 134, 148, 132, 147, 129, 145, 145, 0, 128, 0, 145, 0, 0, 0, 134, 18, 128, 141,
	135, 141, 135, 142, 129, 142, 129, 141, 135, 146, 135, 148, 134, 149, 130, 149, 129, 148, 129, 147,
	130, 147, 131, 148, 134, 148, 134, 146, 139, 0, 128, 0, 140, 0, 0, 0, 128, 0, 128, 139, 136, 139, 136,
	128, 128, 128, 129, 11, 129, 128, 130, 11, 130, 128, 131, 11, 131, 128, 132, 11, 132, 128, 133, 11,
	133, 128, 134, 11, 134, 128, 135, 11, 135, 128, 141, 0, 128, 0, 141, 0, 0, 0
};
static const unsigned char Gothic[18063] = /* binary data included from GOTH.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 71,
	79, 84, 72, 15, 70, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 25, 0, 249, 0, 0, 0, 0, 0, 0, 0, 4, 0, 58, 0, 94, 0, 114, 0, 224, 0, 30, 1,
	134, 1, 162, 1, 214, 1, 10, 2, 62, 2, 90, 2, 118, 2, 134, 2, 156, 2, 172, 2, 236, 2, 26, 3, 100, 3, 186, 3,
	250, 3, 70, 4, 160, 4, 222, 4, 64, 5, 156, 5, 196, 5, 242, 5, 252, 5, 24, 6, 34, 6, 124, 6, 232, 6, 74, 7,
	254, 7, 120, 8, 242, 8, 132, 9, 28, 10, 178, 10, 106, 11, 222, 11, 78, 12, 10, 13, 150, 13, 74, 14, 216,
	14, 100, 15, 218, 15, 136, 16, 62, 17, 226, 17, 96, 18, 248, 18, 116, 19, 16, 20, 124, 20, 16, 21,
	112, 21, 132, 21, 140, 21, 160, 21, 174, 21, 188, 21, 216, 21, 54, 22, 132, 22, 194, 22, 10, 23, 62,
	23, 132, 23, 232, 23, 62, 24, 126, 24, 198, 24, 28, 25, 70, 25, 190, 25, 16, 26, 86, 26, 180, 26, 2,
	27, 70, 27, 168, 27, 218, 27, 46, 28, 110, 28, 210, 28, 54, 29, 160, 29, 224, 29, 46, 30, 54, 30, 132,
	30, 152, 30, 170, 30, 88, 31, 202, 31, 18, 32, 118, 32, 244, 32, 102, 33, 210, 33, 72, 34, 130, 34,
	214, 34, 30, 35, 110, 35, 164, 35, 232, 35, 110, 36, 230, 36, 132, 37, 2, 38, 234, 38, 52, 39, 152, 39,
	240, 39, 72, 40, 174, 40, 52, 41, 220, 41, 142, 42, 216, 42, 50, 43, 192, 43, 92, 44, 186, 44, 44, 45,
	112, 45, 200, 45, 46, 46, 138, 46, 30, 47, 130, 47, 206, 47, 36, 48, 56, 48, 76, 48, 202, 48, 58, 49,
	108, 49, 124, 49, 140, 49, 140, 50, 136, 52, 188, 54, 196, 54, 208, 54, 224, 54, 240, 54, 254, 54, 12,
	55, 32, 55, 44, 55, 60, 55, 76, 55, 90, 55, 104, 55, 114, 55, 124, 55, 138, 55, 152, 55, 164, 55, 172,
	55, 184, 55, 200, 55, 216, 55, 232, 55, 248, 55, 12, 56, 32, 56, 52, 56, 64, 56, 92, 56, 110, 56, 126,
	56, 144, 56, 160, 56, 174, 56, 188, 56, 202, 56, 216, 56, 232, 56, 248, 56, 2, 57, 12, 57, 114, 57,
	212, 57, 10, 58, 64, 58, 162, 58, 4, 59, 118, 59, 204, 59, 50, 60, 144, 60, 234, 60, 86, 61, 192, 61,
	24, 62, 144, 62, 32, 63, 130, 63, 250, 63, 68, 64, 162, 64, 18, 65, 52, 65, 86, 65, 106, 65, 126, 65,
	166, 65, 206, 65, 0, 66, 36, 66, 100, 66, 126, 66, 148, 66, 160, 66, 222, 66, 44, 67, 16, 9, 14, 18, 17,
	21, 23, 8, 11, 10, 13, 21, 21, 21, 8, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 8, 8, 20, 21, 20, 15,
	24, 26, 22, 21, 21, 20, 22, 22, 22, 19, 18, 22, 20, 27, 23, 23, 20, 23, 22, 21, 21, 22, 21, 25, 21, 21,
	18, 7, 17, 8, 19, 20, 7, 14, 16, 12, 15, 12, 12, 16, 16, 8, 8, 15, 8, 24, 16, 16, 16, 16, 12, 14, 9, 16,
	15, 23, 17, 16, 15, 11, 6, 9, 20, 14, 25, 16, 12, 18, 14, 14, 14, 19, 18, 12, 12, 12, 18, 11, 25, 26, 20,
	22, 35, 16, 16, 16, 18, 16, 16, 23, 22, 18, 23, 25, 28, 23, 14, 10, 16, 16, 19, 23, 21, 20, 15, 14, 14,
	26, 26, 9, 18, 18, 17, 16, 24, 4, 12, 12, 21, 21, 11, 21, 21, 21, 21, 21, 11, 11, 8, 16, 16, 8, 16, 16, 8,
	18, 18, 18, 26, 26, 18, 26, 26, 16, 18, 16, 18, 18, 8, 8, 18, 26, 16, 11, 8, 22, 22, 11, 22, 22, 26, 17,
	22, 24, 20, 27, 18, 28, 19, 24, 24, 21, 27, 18, 14, 24, 21, 21, 21, 21, 14, 14, 21, 21, 17, 6, 6, 26, 18,
	18, 14, 144, 0, 0, 0, 131, 21, 130, 148, 128, 147, 130, 146, 131, 135, 131, 18, 132, 147, 131, 148,
	130, 147, 131, 146, 131, 135, 131, 21, 132, 148, 134, 147, 132, 146, 131, 135, 131, 3, 129, 129,
	131, 128, 133, 129, 131, 131, 131, 2, 130, 129, 132, 129, 131, 130, 137, 0, 0, 0, 129, 21, 128, 148,
	128, 142, 129, 20, 128, 142, 129, 21, 130, 148, 128, 142, 138, 21, 137, 148, 137, 142, 138, 20, 137,
	142, 138, 21, 139, 148, 137, 142, 142, 0, 0, 0, 136, 21, 129, 249, 142, 21, 135, 249, 129, 10, 143,
	138, 128, 4, 142, 132, 146, 0, 0, 0, 133, 25, 133, 252, 137, 25, 137, 252, 137, 21, 139, 148, 140,
	146, 140, 144, 142, 145, 141, 147, 140, 148, 137, 149, 133, 149, 130, 148, 128, 146, 128, 143, 129,
	141, 132, 139, 138, 137, 140, 136, 141, 134, 141, 131, 140, 129, 141, 17, 140, 147, 129, 15, 130,
	141, 132, 140, 138, 138, 140, 137, 141, 135, 130, 2, 129, 132, 130, 20, 129, 146, 129, 144, 130,
	142, 132, 141, 138, 139, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130,
	129, 129, 130, 128, 132, 130, 133, 130, 131, 131, 129, 133, 128, 145, 0, 0, 0, 146, 21, 128, 128,
	133, 21, 135, 147, 135, 145, 134, 143, 132, 142, 130, 142, 128, 144, 128, 146, 129, 148, 131, 149,
	133, 149, 135, 148, 138, 147, 141, 147, 144, 148, 146, 149, 142, 7, 140, 134, 139, 132, 139, 130,
	141, 128, 143, 128, 145, 129, 146, 131, 146, 133, 144, 135, 142, 135, 149, 0, 0, 0, 145, 13, 146,
	140, 147, 140, 148, 141, 144, 12, 145, 139, 147, 139, 144, 11, 145, 138, 146, 138, 147, 139, 148,
	141, 145, 13, 139, 135, 138, 6, 132, 128, 128, 133, 134, 139, 135, 12, 139, 144, 135, 149, 130, 143,
	136, 137, 140, 131, 142, 129, 144, 128, 146, 128, 147, 129, 148, 131, 132, 1, 129, 133, 138, 16,
	135, 148, 131, 15, 136, 138, 140, 132, 142, 130, 144, 129, 147, 129, 133, 1, 129, 134, 138, 15, 134,
	148, 131, 16, 137, 138, 141, 132, 142, 131, 144, 130, 147, 130, 148, 131, 151, 0, 0, 0, 130, 15, 130,
	145, 128, 147, 130, 149, 131, 147, 131, 145, 130, 143, 128, 142, 130, 20, 129, 147, 130, 146, 130,
	148, 136, 0, 0, 0, 135, 25, 133, 151, 131, 148, 129, 144, 128, 139, 128, 135, 129, 130, 131, 254,
	133, 251, 135, 249, 131, 19, 130, 144, 129, 140, 129, 134, 130, 130, 131, 255, 133, 23, 132, 149,
	131, 146, 130, 140, 130, 134, 131, 128, 132, 253, 133, 251, 139, 0, 0, 0, 128, 25, 130, 151, 132,
	148, 134, 144, 135, 139, 135, 135, 134, 130, 132, 254, 130, 251, 128, 249, 132, 19, 133, 144, 134,
	140, 134, 134, 133, 130, 132, 255, 130, 23, 131, 149, 132, 146, 133, 140, 133, 134, 132, 128, 131,
	253, 130, 251, 138, 0, 0, 0, 134, 12, 133, 139, 135, 129, 134, 128, 134, 140, 135, 139, 133, 129,
	134, 128, 129, 9, 130, 137, 138, 131, 139, 131, 129, 137, 129, 136, 139, 132, 139, 131, 139, 9, 138,
	137, 130, 131, 129, 131, 139, 137, 139, 136, 129, 132, 129, 131, 141, 0, 0, 0, 136, 18, 136, 129,
	137, 129, 136, 18, 137, 146, 137, 129, 128, 10, 145, 138, 145, 137, 128, 10, 128, 137, 145, 137,
	149, 0, 0, 0, 130, 125, 130, 255, 128, 129, 130, 131, 131, 129, 131, 255, 130, 253, 128, 252, 130, 2,
	129, 129, 130, 128, 130, 130, 149, 0, 0, 0, 128, 10, 145, 138, 145, 137, 128, 10, 128, 137, 145, 137,
	149, 0, 0, 0, 130, 3, 128, 129, 130, 128, 132, 129, 130, 131, 130, 2, 129, 129, 131, 129, 130, 130,
	136, 0, 0, 0, 146, 25, 128, 249, 129, 249, 146, 25, 147, 153, 129, 249, 149, 0, 0, 0, 135, 1, 134, 130,
	132, 131, 132, 147, 130, 147, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 140, 130,
	142, 130, 142, 146, 144, 147, 142, 147, 140, 148, 139, 149, 137, 148, 138, 147, 140, 146, 140, 130,
	131, 18, 131, 131, 134, 129, 132, 19, 137, 148, 138, 20, 141, 146, 141, 131, 149, 0, 0, 0, 131, 19,
	132, 146, 133, 144, 133, 131, 131, 130, 132, 130, 134, 129, 135, 128, 136, 129, 138, 130, 137, 130,
	135, 131, 135, 147, 134, 149, 131, 147, 133, 18, 132, 147, 133, 148, 134, 146, 134, 130, 136, 129,
	149, 0, 0, 0, 136, 20, 135, 147, 133, 146, 131, 146, 129, 147, 131, 147, 133, 148, 134, 149, 136,
	148, 139, 147, 141, 147, 141, 139, 134, 139, 131, 138, 129, 136, 128, 133, 128, 128, 132, 130, 136,
	131, 139, 131, 143, 130, 141, 128, 138, 129, 133, 129, 128, 128, 133, 19, 135, 148, 139, 19, 139,
	139, 140, 18, 140, 140, 131, 1, 134, 130, 139, 130, 142, 129, 149, 0, 0, 0, 135, 20, 133, 146, 131,
	146, 129, 147, 130, 147, 132, 148, 133, 149, 135, 148, 139, 147, 141, 147, 141, 140, 139, 140, 136,
	139, 134, 138, 132, 19, 134, 148, 139, 19, 139, 140, 140, 18, 140, 141, 134, 11, 136, 138, 139, 137,
	141, 137, 141, 130, 139, 130, 139, 137, 140, 8, 140, 131, 135, 1, 133, 128, 132, 129, 130, 130, 128,
	130, 130, 131, 132, 131, 134, 130, 135, 129, 139, 130, 132, 2, 134, 129, 149, 0, 0, 0, 138, 17, 139,
	147, 138, 148, 138, 130, 140, 129, 142, 130, 141, 130, 139, 131, 139, 145, 140, 147, 138, 149, 128,
	139, 128, 134, 137, 134, 139, 6, 143, 134, 144, 133, 144, 135, 143, 134, 129, 11, 129, 135, 130, 13,
	130, 134, 137, 20, 137, 131, 135, 130, 136, 130, 138, 129, 139, 128, 140, 129, 149, 0, 0, 0, 129, 19,
	138, 147, 140, 148, 141, 149, 129, 149, 129, 140, 132, 140, 136, 141, 137, 141, 139, 140, 139, 130,
	141, 130, 141, 140, 143, 141, 142, 141, 140, 142, 139, 143, 138, 142, 136, 141, 130, 20, 139, 148,
	138, 14, 140, 141, 140, 131, 135, 1, 133, 128, 132, 129, 130, 130, 128, 130, 130, 131, 132, 131,
	134, 130, 135, 129, 139, 130, 132, 2, 134, 129, 149, 0, 0, 0, 135, 1, 134, 130, 132, 131, 132, 147,
	130, 147, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 140, 130, 142, 130, 142, 139,
	144, 140, 143, 140, 141, 141, 140, 142, 139, 141, 141, 139, 141, 131, 131, 18, 131, 131, 134, 129,
	132, 19, 136, 148, 138, 149, 139, 148, 141, 147, 142, 147, 140, 146, 138, 146, 136, 148, 137, 20,
	139, 147, 132, 11, 133, 139, 137, 140, 139, 141, 137, 12, 138, 140, 140, 139, 140, 130, 149, 0, 0, 0,
	143, 21, 139, 147, 135, 146, 132, 146, 128, 147, 130, 149, 133, 148, 138, 148, 143, 149, 142, 147,
	140, 144, 136, 140, 134, 137, 133, 134, 133, 131, 134, 128, 136, 130, 135, 133, 135, 136, 136, 139,
	138, 142, 129, 20, 132, 147, 137, 147, 140, 148, 135, 10, 134, 135, 134, 132, 135, 129, 149, 0, 0, 0,
	132, 12, 132, 146, 130, 146, 130, 140, 132, 140, 140, 137, 142, 137, 142, 130, 140, 130, 140, 137,
	131, 17, 131, 141, 132, 18, 137, 147, 139, 148, 140, 149, 141, 148, 143, 147, 144, 147, 142, 146,
	142, 140, 140, 140, 132, 137, 130, 137, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129,
	140, 130, 137, 19, 138, 147, 140, 146, 140, 140, 139, 20, 141, 147, 141, 141, 131, 8, 131, 131, 134,
	129, 132, 9, 132, 131, 134, 130, 135, 129, 141, 8, 141, 131, 149, 0, 0, 0, 135, 9, 134, 137, 132, 138,
	132, 147, 130, 147, 130, 138, 128, 137, 129, 137, 131, 136, 132, 135, 133, 136, 135, 137, 139, 138,
	140, 138, 131, 18, 131, 137, 133, 136, 132, 19, 137, 148, 139, 149, 140, 148, 142, 147, 144, 147,
	142, 146, 142, 130, 140, 130, 140, 146, 138, 147, 137, 148, 138, 20, 141, 146, 141, 131, 136, 1,
	134, 128, 133, 129, 131, 130, 129, 130, 131, 131, 133, 131, 135, 130, 136, 129, 140, 130, 133, 2,
	135, 129, 149, 0, 0, 0, 130, 14, 128, 140, 130, 139, 132, 140, 130, 142, 130, 13, 129, 140, 131, 140,
	130, 141, 130, 3, 128, 129, 130, 128, 132, 129, 130, 131, 130, 2, 129, 129, 131, 129, 130, 130, 136,
	0, 0, 0, 130, 14, 128, 140, 130, 139, 132, 140, 130, 142, 130, 13, 129, 140, 131, 140, 130, 141,
	130, 125, 130, 255, 128, 129, 130, 131, 131, 129, 131, 255, 130, 253, 128, 252, 130, 2, 129, 129,
	130, 128, 130, 130, 136, 0, 0, 0, 144, 18, 128, 137, 144, 128, 148, 0, 0, 0, 128, 14, 145, 142, 145,
	141, 128, 14, 128, 141, 145, 141, 128, 6, 145, 134, 145, 133, 128, 6, 128, 133, 145, 133, 149, 0, 0,
	0, 128, 18, 144, 137, 128, 128, 148, 0, 0, 0, 128, 17, 129, 147, 130, 148, 133, 149, 135, 149, 138,
	148, 139, 147, 140, 145, 140, 143, 139, 141, 137, 139, 135, 138, 129, 17, 130, 147, 138, 19, 139,
	146, 139, 142, 138, 141, 128, 17, 130, 144, 130, 146, 131, 148, 133, 149, 135, 21, 137, 148, 138,
	146, 138, 142, 137, 140, 135, 138, 134, 10, 134, 135, 135, 138, 133, 138, 134, 135, 134, 3, 132,
	129, 134, 128, 136, 129, 134, 131, 134, 2, 133, 129, 135, 129, 134, 130, 143, 0, 0, 0, 143, 13, 142,
	143, 140, 144, 137, 144, 135, 143, 134, 142, 133, 139, 133, 136, 134, 134, 136, 133, 139, 133, 141,
	134, 142, 136, 137, 16, 135, 142, 134, 139, 134, 136, 135, 134, 136, 133, 143, 16, 142, 136, 142,
	134, 144, 133, 146, 133, 148, 135, 149, 138, 149, 140, 148, 143, 147, 145, 145, 147, 143, 148, 140,
	149, 137, 149, 134, 148, 132, 147, 130, 145, 129, 143, 128, 140, 128, 137, 129, 134, 130, 132, 132,
	130, 134, 129, 137, 128, 140, 128, 143, 129, 145, 130, 146, 131, 144, 16, 143, 136, 143, 134, 144,
	133, 152, 0, 0, 0, 133, 18, 135, 148, 137, 149, 139, 149, 140, 148, 147, 132, 148, 131, 150, 131,
	148, 128, 147, 128, 146, 129, 145, 131, 138, 147, 137, 148, 135, 148, 138, 20, 139, 147, 146, 131,
	147, 129, 148, 130, 146, 131, 133, 14, 134, 143, 136, 144, 137, 144, 138, 143, 137, 15, 137, 142,
	134, 15, 136, 143, 137, 141, 128, 0, 130, 130, 132, 131, 135, 131, 137, 130, 135, 128, 134, 129,
	131, 129, 128, 128, 131, 2, 135, 130, 136, 129, 139, 17, 133, 131, 135, 8, 143, 136, 154, 0, 0, 0,
	128, 19, 130, 149, 133, 149, 135, 148, 137, 149, 131, 20, 134, 148, 128, 19, 130, 148, 132, 147,
	135, 147, 137, 149, 133, 16, 132, 143, 131, 141, 131, 140, 129, 140, 128, 139, 128, 137, 129, 138,
	131, 138, 131, 132, 132, 14, 132, 134, 129, 11, 132, 139, 133, 16, 133, 135, 132, 133, 131, 132,
	138, 18, 137, 145, 136, 143, 136, 134, 137, 16, 137, 136, 138, 18, 138, 137, 137, 135, 136, 134,
	138, 18, 144, 149, 146, 148, 147, 146, 147, 144, 145, 142, 141, 140, 144, 20, 146, 146, 146, 144,
	142, 20, 144, 147, 145, 146, 145, 143, 143, 141, 143, 13, 146, 139, 147, 137, 147, 131, 145, 11,
	146, 137, 146, 132, 143, 13, 144, 140, 145, 138, 145, 131, 130, 0, 133, 130, 136, 131, 140, 131,
	143, 130, 132, 1, 135, 130, 140, 130, 142, 129, 130, 0, 134, 129, 139, 129, 141, 128, 143, 130, 145,
	131, 147, 131, 141, 12, 141, 131, 141, 9, 145, 137, 141, 6, 145, 134, 150, 0, 0, 0, 134, 20, 132, 147,
	130, 145, 129, 143, 128, 140, 128, 136, 129, 133, 130, 131, 133, 129, 136, 128, 139, 128, 142, 129,
	144, 130, 146, 132, 147, 134, 130, 16, 129, 141, 129, 136, 131, 132, 134, 130, 137, 129, 140, 129,
	143, 130, 134, 20, 132, 146, 131, 144, 130, 141, 130, 137, 131, 134, 134, 131, 137, 130, 140, 130,
	143, 131, 145, 132, 147, 134, 136, 17, 136, 133, 137, 17, 137, 135, 138, 18, 138, 136, 137, 134,
	136, 133, 136, 17, 138, 146, 141, 149, 143, 148, 145, 148, 146, 149, 140, 20, 142, 147, 144, 147,
	139, 19, 141, 146, 143, 146, 145, 147, 146, 149, 143, 18, 143, 131, 149, 0, 0, 0, 128, 21, 142, 149,
	144, 148, 145, 146, 145, 131, 130, 20, 142, 148, 144, 146, 144, 132, 128, 21, 129, 148, 131, 147,
	142, 147, 143, 146, 143, 131, 134, 16, 133, 143, 132, 141, 132, 140, 130, 140, 129, 139, 129, 137,
	130, 138, 132, 138, 132, 133, 133, 14, 133, 135, 130, 11, 133, 139, 134, 16, 134, 136, 133, 134,
	132, 133, 128, 0, 131, 130, 134, 131, 138, 131, 141, 130, 130, 1, 133, 130, 138, 130, 140, 129, 128,
	0, 132, 129, 137, 129, 139, 128, 141, 130, 143, 131, 145, 131, 137, 19, 137, 131, 137, 14, 139,
	141, 141, 141, 143, 142, 137, 8, 139, 137, 141, 137, 143, 136, 149, 0, 0, 0, 128, 19, 130, 149, 132,
	149, 134, 148, 136, 149, 134, 147, 132, 147, 130, 148, 128, 147, 131, 20, 133, 148, 133, 16, 132,
	143, 131, 141, 131, 140, 129, 140, 128, 139, 128, 137, 129, 138, 131, 138, 131, 132, 132, 133, 133,
	135, 133, 144, 132, 14, 132, 134, 129, 11, 132, 139, 136, 3, 136, 142, 137, 145, 138, 147, 139, 148,
	141, 149, 143, 149, 146, 148, 144, 146, 142, 147, 140, 147, 138, 146, 137, 145, 139, 19, 141, 148,
	143, 148, 145, 147, 136, 6, 137, 137, 138, 139, 139, 140, 141, 140, 143, 139, 141, 137, 140, 138,
	138, 138, 137, 137, 139, 11, 141, 139, 142, 138, 130, 0, 133, 130, 137, 131, 142, 131, 146, 130,
	144, 128, 141, 129, 134, 129, 130, 128, 132, 1, 135, 130, 142, 130, 145, 129, 148, 0, 0, 0, 131, 19,
	133, 149, 136, 149, 138, 148, 140, 149, 134, 20, 137, 148, 131, 19, 133, 148, 135, 147, 138, 147,
	140, 149, 137, 16, 136, 143, 135, 141, 135, 140, 133, 140, 132, 139, 132, 137, 133, 138, 135, 138,
	135, 133, 136, 14, 136, 135, 133, 11, 136, 139, 137, 16, 137, 136, 136, 134, 135, 133, 140, 17, 140,
	130, 139, 129, 138, 129, 134, 131, 132, 131, 130, 130, 128, 128, 141, 17, 141, 131, 141, 11, 145,
	139, 137, 1, 136, 129, 134, 130, 131, 130, 142, 18, 142, 140, 145, 140, 145, 10, 142, 138, 142, 132,
	141, 130, 137, 128, 135, 128, 133, 129, 131, 129, 128, 128, 140, 17, 142, 146, 145, 149, 147, 148,
	149, 148, 150, 149, 144, 20, 146, 147, 148, 147, 143, 19, 145, 146, 147, 146, 149, 147, 150, 149,
	145, 18, 145, 132, 150, 0, 0, 0, 134, 20, 132, 147, 130, 145, 129, 143, 128, 140, 128, 137, 129, 134,
	130, 132, 132, 130, 134, 129, 137, 128, 141, 128, 144, 129, 146, 131, 147, 133, 147, 136, 146, 138,
	145, 139, 143, 140, 141, 140, 130, 16, 129, 141, 129, 136, 130, 133, 134, 20, 132, 146, 131, 144,
	130, 141, 130, 136, 131, 133, 132, 131, 134, 129, 145, 3, 146, 132, 146, 136, 145, 138, 141, 0, 143,
	129, 144, 130, 145, 132, 145, 136, 144, 138, 143, 139, 141, 140, 136, 17, 136, 132, 137, 17, 137,
	134, 138, 18, 138, 135, 137, 133, 136, 132, 136, 17, 138, 146, 141, 149, 143, 148, 145, 148, 146,
	149, 140, 20, 142, 147, 144, 147, 139, 19, 141, 146, 143, 146, 145, 147, 146, 149, 145, 19, 141,
	140, 141, 128, 141, 8, 145, 136, 141, 5, 145, 133, 150, 0, 0, 0, 128, 19, 130, 149, 133, 149, 135,
	148, 137, 149, 131, 20, 134, 148, 128, 19, 130, 148, 132, 147, 135, 147, 137, 149, 133, 16, 132,
	143, 131, 141, 131, 140, 129, 140, 128, 139, 128, 137, 129, 138, 131, 138, 131, 132, 132, 14, 132,
	134, 129, 11, 132, 139, 133, 16, 133, 135, 132, 133, 131, 132, 130, 0, 133, 130, 136, 131, 139, 131,
	141, 130, 132, 1, 135, 130, 138, 130, 140, 129, 130, 0, 134, 129, 137, 129, 139, 128, 141, 130, 138,
	18, 137, 145, 136, 143, 136, 134, 137, 16, 137, 136, 138, 18, 138, 137, 137, 135, 136, 134, 138,
	18, 140, 148, 142, 149, 144, 149, 146, 148, 143, 20, 144, 148, 145, 147, 140, 20, 142, 148, 144,
	146, 146, 148, 141, 12, 143, 141, 145, 143, 146, 142, 147, 139, 147, 135, 146, 131, 144, 128, 144,
	14, 145, 141, 146, 139, 146, 134, 145, 131, 143, 13, 144, 141, 145, 139, 145, 134, 144, 128, 141,
	12, 141, 130, 141, 9, 145, 137, 141, 6, 145, 134, 150, 0, 0, 0, 131, 19, 133, 149, 136, 149, 139,
	148, 141, 149, 134, 20, 138, 148, 131, 19, 133, 148, 136, 147, 139, 147, 141, 149, 138, 16, 137,
	143, 136, 141, 136, 140, 134, 140, 133, 139, 133, 137, 134, 138, 136, 138, 136, 133, 137, 14, 137,
	135, 134, 11, 137, 139, 138, 16, 138, 136, 137, 134, 136, 133, 144, 19, 142, 145, 141, 142, 141,
	131, 140, 129, 138, 129, 134, 131, 132, 131, 130, 130, 128, 128, 142, 16, 142, 132, 137, 1, 136,
	129, 134, 130, 131, 130, 144, 19, 143, 145, 143, 133, 142, 131, 140, 129, 138, 128, 135, 128, 133,
	129, 130, 129, 128, 128, 147, 0, 0, 0, 130, 19, 132, 149, 135, 149, 138, 148, 140, 149, 133, 20, 137,
	148, 130, 19, 132, 148, 135, 147, 138, 147, 140, 149, 137, 16, 136, 143, 135, 141, 135, 140, 133,
	140, 132, 139, 132, 137, 133, 138, 135, 138, 135, 133, 136, 14, 136, 135, 133, 11, 136, 139, 137,
	16, 137, 136, 136, 134, 135, 133, 143, 19, 141, 145, 140, 142, 140, 131, 139, 129, 141, 16, 141,
	132, 143, 19, 142, 145, 142, 133, 141, 131, 139, 129, 136, 128, 133, 128, 130, 129, 128, 131, 128,
	133, 129, 134, 130, 134, 131, 133, 130, 132, 129, 132, 128, 5, 131, 133, 146, 0, 0, 0, 128, 19, 130,
	149, 133, 149, 135, 148, 137, 149, 131, 20, 134, 148, 128, 19, 130, 148, 132, 147, 135, 147, 137,
	149, 133, 16, 132, 143, 131, 141, 131, 140, 129, 140, 128, 139, 128, 137, 129, 138, 131, 138, 131,
	132, 132, 14, 132, 134, 129, 11, 132, 139, 133, 16, 133, 135, 132, 133, 131, 132, 130, 0, 133, 130,
	136, 131, 139, 131, 141, 130, 132, 1, 134, 130, 138, 130, 140, 129, 130, 0, 134, 129, 137, 129, 139,
	128, 141, 130, 138, 18, 137, 145, 136, 143, 136, 134, 137, 16, 137, 136, 138, 18, 138, 137, 137,
	135, 136, 134, 138, 18, 140, 148, 142, 149, 144, 149, 146, 148, 143, 20, 144, 148, 145, 147, 140,
	20, 142, 148, 144, 146, 146, 148, 141, 12, 144, 143, 145, 142, 147, 141, 143, 14, 145, 141, 147,
	141, 147, 13, 145, 138, 143, 136, 141, 134, 143, 8, 145, 135, 146, 131, 147, 129, 148, 129, 145, 5,
	146, 129, 143, 8, 144, 135, 145, 129, 146, 128, 147, 128, 148, 129, 141, 12, 141, 130, 150, 0, 0, 0,
	128, 19, 130, 149, 133, 149, 135, 148, 137, 149, 131, 20, 134, 148, 128, 19, 130, 148, 132, 147,
	135, 147, 137, 149, 133, 16, 132, 143, 131, 141, 131, 140, 129, 140, 128, 139, 128, 137, 129, 138,
	131, 138, 131, 132, 132, 14, 132, 134, 129, 11, 132, 139, 133, 16, 133, 135, 132, 133, 131, 132,
	130, 0, 133, 130, 137, 131, 142, 131, 146, 130, 132, 1, 135, 130, 142, 130, 145, 129, 130, 0, 134,
	129, 141, 129, 144, 128, 146, 130, 138, 18, 137, 145, 136, 143, 136, 134, 137, 16, 137, 136, 138,
	18, 138, 137, 137, 135, 136, 134, 138, 18, 140, 148, 142, 149, 144, 149, 146, 148, 143, 20, 144,
	148, 145, 147, 140, 20, 142, 148, 144, 146, 146, 148, 142, 20, 142, 131, 148, 0, 0, 0, 135, 17, 134,
	144, 133, 142, 133, 140, 131, 140, 130, 139, 130, 137, 131, 138, 133, 138, 133, 134, 134, 15, 134,
	136, 131, 11, 134, 139, 135, 17, 135, 137, 134, 135, 133, 134, 128, 0, 130, 130, 132, 131, 134, 131,
	136, 130, 137, 130, 138, 131, 131, 2, 134, 130, 136, 129, 128, 0, 130, 129, 133, 129, 135, 128, 136,
	128, 137, 129, 138, 131, 135, 17, 139, 149, 143, 145, 143, 132, 144, 130, 145, 130, 139, 20, 142,
	145, 142, 131, 141, 130, 142, 129, 143, 130, 142, 131, 139, 11, 142, 139, 137, 19, 138, 147, 141,
	144, 141, 140, 138, 140, 138, 10, 141, 138, 141, 131, 140, 130, 142, 128, 145, 130, 146, 131, 143,
	17, 147, 149, 151, 145, 151, 132, 152, 130, 153, 130, 147, 20, 150, 145, 150, 131, 152, 129, 147,
	11, 150, 139, 145, 19, 146, 147, 149, 144, 149, 140, 146, 140, 146, 10, 149, 138, 149, 130, 151,
	128, 153, 130, 138, 19, 138, 131, 146, 19, 146, 131, 155, 0, 0, 0, 128, 18, 130, 148, 132, 149, 134,
	149, 136, 148, 138, 145, 143, 134, 145, 131, 146, 130, 134, 20, 136, 146, 137, 144, 143, 132, 146,
	129, 130, 20, 132, 148, 134, 147, 136, 144, 141, 133, 143, 130, 144, 129, 146, 128, 143, 19, 145,
	146, 147, 146, 149, 147, 150, 149, 144, 20, 146, 147, 148, 147, 143, 19, 145, 149, 147, 148, 149,
	148, 150, 149, 132, 12, 130, 140, 129, 139, 129, 137, 130, 138, 132, 138, 130, 11, 132, 139, 128, 0,
	130, 130, 132, 131, 135, 131, 137, 130, 131, 2, 134, 130, 136, 129, 128, 0, 131, 129, 134, 129, 135,
	128, 137, 130, 132, 20, 132, 131, 146, 18, 146, 128, 139, 15, 140, 142, 142, 141, 144, 141, 146,
	142, 132, 7, 134, 136, 138, 136, 140, 135, 151, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144, 128,
	141, 128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 142, 129, 144, 130, 146,
	132, 147, 134, 148, 137, 148, 141, 147, 144, 146, 146, 144, 148, 142, 149, 141, 148, 138, 146, 135,
	145, 130, 17, 129, 142, 129, 136, 130, 133, 134, 21, 132, 147, 131, 145, 130, 142, 130, 136, 131,
	133, 132, 131, 134, 129, 146, 5, 147, 136, 147, 142, 145, 146, 144, 147, 142, 1, 144, 131, 145, 133,
	146, 136, 146, 142, 145, 144, 143, 147, 141, 148, 135, 17, 135, 132, 136, 17, 136, 134, 137, 17,
	137, 135, 136, 133, 135, 132, 141, 20, 141, 129, 141, 14, 143, 141, 144, 141, 146, 142, 141, 8, 143,
	137, 144, 137, 146, 136, 151, 0, 0, 0, 129, 21, 130, 148, 131, 146, 131, 140, 129, 140, 128, 139,
	128, 137, 129, 138, 131, 138, 131, 130, 128, 128, 131, 129, 131, 249, 133, 251, 131, 19, 132, 145,
	132, 251, 129, 11, 132, 139, 129, 21, 131, 148, 132, 147, 133, 145, 133, 251, 133, 16, 136, 146,
	140, 149, 144, 145, 144, 131, 140, 20, 143, 145, 143, 131, 138, 19, 139, 147, 142, 144, 142, 130,
	136, 3, 139, 131, 142, 130, 137, 2, 139, 130, 141, 129, 136, 1, 138, 129, 140, 128, 142, 130, 144,
	131, 136, 18, 136, 252, 136, 14, 138, 141, 140, 141, 142, 142, 136, 8, 138, 137, 140, 137, 142, 136,
	148, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144, 128, 141, 128, 137, 129, 134, 130, 132, 132,
	130, 134, 129, 136, 128, 140, 128, 142, 129, 144, 130, 146, 132, 147, 134, 148, 137, 148, 141, 147,
	144, 146, 146, 144, 148, 142, 149, 141, 148, 138, 146, 135, 145, 130, 17, 129, 142, 129, 136, 130,
	133, 134, 21, 132, 147, 131, 145, 130, 142, 130, 136, 131, 133, 132, 131, 134, 129, 146, 5, 147,
	136, 147, 142, 145, 146, 144, 147, 142, 1, 144, 131, 145, 133, 146, 136, 146, 142, 145, 144, 143,
	147, 141, 148, 135, 17, 135, 132, 136, 17, 136, 134, 137, 17, 137, 135, 136, 133, 135, 132, 141, 20,
	141, 129, 141, 14, 143, 141, 144, 141, 146, 142, 141, 8, 143, 137, 144, 137, 146, 136, 136, 0, 137,
	129, 138, 129, 140, 128, 144, 251, 146, 250, 147, 250, 140, 127, 142, 252, 144, 250, 145, 250, 138,
	1, 139, 128, 142, 250, 144, 249, 146, 249, 147, 250, 151, 0, 0, 0, 128, 19, 130, 149, 133, 149,
	135, 148, 137, 149, 131, 20, 134, 148, 128, 19, 130, 148, 132, 147, 135, 147, 137, 149, 133, 16,
	132, 143, 131, 141, 131, 140, 129, 140, 128, 139, 128, 137, 129, 138, 131, 138, 131, 132, 132, 14,
	132, 134, 129, 11, 132, 139, 133, 16, 133, 135, 132, 133, 131, 132, 130, 0, 133, 130, 136, 131, 138,
	131, 141, 130, 132, 1, 134, 130, 138, 130, 140, 129, 130, 0, 134, 129, 137, 129, 139, 128, 141, 130,
	138, 18, 137, 145, 136, 143, 136, 134, 137, 16, 137, 136, 138, 18, 138, 137, 137, 135, 136, 134,
	138, 18, 141, 148, 143, 149, 145, 148, 146, 146, 146, 143, 145, 141, 144, 140, 140, 138, 138, 137,
	143, 20, 144, 148, 145, 146, 145, 142, 144, 141, 141, 20, 143, 147, 144, 145, 144, 142, 143, 140,
	140, 138, 140, 10, 142, 137, 143, 136, 146, 131, 147, 130, 148, 130, 143, 7, 145, 131, 147, 129,
	140, 10, 142, 136, 144, 130, 146, 128, 148, 130, 150, 0, 0, 0, 140, 18, 139, 147, 137, 148, 134, 149,
	141, 19, 139, 148, 142, 20, 138, 149, 134, 149, 131, 148, 130, 147, 129, 145, 130, 143, 131, 142,
	134, 141, 142, 141, 144, 140, 145, 139, 145, 137, 144, 134, 130, 16, 131, 143, 134, 142, 143, 142,
	145, 141, 146, 140, 146, 138, 145, 136, 130, 19, 130, 145, 131, 144, 134, 143, 144, 143, 146, 142,
	147, 140, 147, 138, 144, 134, 140, 128, 128, 12, 129, 139, 131, 138, 140, 138, 141, 137, 141, 136,
	140, 134, 129, 10, 131, 137, 139, 137, 140, 136, 128, 12, 128, 139, 129, 137, 131, 136, 138, 136,
	140, 135, 140, 134, 128, 0, 131, 130, 135, 131, 138, 131, 141, 130, 130, 1, 133, 130, 137, 130, 140,
	129, 128, 0, 132, 129, 137, 129, 140, 128, 142, 20, 140, 146, 138, 143, 137, 13, 135, 138, 134, 8,
	132, 134, 130, 133, 129, 133, 129, 134, 130, 133, 149, 0, 0, 0, 130, 17, 129, 143, 128, 140, 128,
	136, 129, 133, 131, 130, 133, 129, 136, 128, 139, 128, 142, 129, 144, 130, 146, 132, 147, 134, 129,
	8, 130, 133, 132, 131, 134, 130, 137, 129, 140, 129, 143, 130, 130, 17, 129, 142, 129, 138, 130,
	135, 132, 132, 134, 131, 137, 130, 140, 130, 143, 131, 145, 132, 147, 134, 128, 18, 129, 148, 131,
	149, 135, 149, 141, 148, 145, 148, 147, 149, 136, 20, 140, 147, 144, 147, 128, 18, 129, 147, 131,
	148, 134, 148, 140, 146, 143, 146, 145, 147, 147, 149, 139, 18, 138, 145, 136, 144, 136, 133, 137,
	16, 137, 135, 138, 17, 138, 136, 137, 134, 136, 133, 143, 18, 143, 131, 149, 0, 0, 0, 128, 19, 130,
	149, 132, 149, 135, 148, 137, 149, 131, 20, 134, 148, 128, 19, 130, 148, 133, 147, 135, 147, 137,
	149, 131, 17, 130, 143, 129, 140, 129, 136, 130, 133, 131, 131, 133, 129, 136, 128, 139, 128, 142,
	129, 144, 130, 146, 128, 148, 130, 130, 8, 131, 133, 134, 130, 137, 129, 140, 129, 131, 17, 130,
	141, 130, 138, 131, 135, 132, 133, 134, 131, 137, 130, 141, 130, 144, 131, 141, 18, 137, 145, 136,
	143, 136, 133, 137, 16, 137, 135, 138, 17, 138, 136, 137, 134, 136, 133, 141, 18, 143, 147, 145,
	149, 146, 148, 148, 147, 146, 146, 146, 132, 147, 130, 148, 130, 145, 18, 146, 147, 145, 148, 144,
	147, 145, 146, 145, 131, 147, 129, 143, 19, 144, 146, 144, 131, 141, 18, 141, 130, 141, 13, 144,
	141, 141, 9, 144, 137, 150, 0, 0, 0, 129, 21, 130, 148, 131, 146, 131, 140, 129, 140, 128, 139, 128,
	137, 129, 138, 131, 138, 131, 131, 129, 130, 131, 19, 132, 145, 132, 131, 129, 11, 132, 139, 133, 2,
	136, 130, 138, 129, 129, 21, 131, 148, 132, 147, 133, 145, 133, 131, 137, 131, 140, 130, 129, 2,
	132, 130, 135, 129, 137, 128, 140, 130, 143, 131, 145, 131, 137, 17, 140, 146, 142, 147, 144, 149,
	145, 148, 147, 147, 145, 146, 145, 131, 144, 18, 145, 147, 144, 148, 143, 147, 144, 146, 144, 132,
	142, 19, 143, 146, 143, 131, 137, 17, 137, 131, 137, 14, 139, 141, 141, 141, 143, 142, 137, 8, 139,
	137, 141, 137, 143, 136, 149, 0, 0, 0, 129, 21, 130, 148, 131, 146, 131, 140, 129, 140, 128, 139,
	128, 137, 129, 138, 131, 138, 131, 131, 129, 130, 131, 19, 132, 145, 132, 131, 129, 11, 132, 139,
	133, 2, 135, 130, 137, 129, 129, 21, 131, 148, 132, 147, 133, 145, 133, 131, 136, 131, 138, 130,
	129, 2, 132, 130, 135, 129, 136, 128, 138, 130, 141, 131, 143, 130, 144, 128, 146, 130, 149, 131,
	136, 19, 139, 149, 141, 147, 141, 131, 144, 131, 146, 130, 139, 20, 140, 147, 140, 131, 136, 19,
	138, 147, 139, 146, 139, 131, 138, 130, 144, 2, 145, 129, 144, 19, 147, 149, 149, 147, 149, 131,
	147, 20, 148, 147, 148, 131, 144, 19, 146, 147, 147, 146, 147, 131, 146, 130, 136, 19, 136, 131,
	144, 19, 144, 131, 136, 13, 139, 141, 136, 9, 139, 137, 144, 13, 147, 141, 144, 9, 147, 137, 153, 0,
	0, 0, 128, 18, 130, 148, 132, 149, 134, 149, 135, 148, 143, 130, 144, 129, 146, 129, 133, 20, 134,
	147, 142, 130, 143, 129, 130, 20, 132, 148, 133, 147, 141, 129, 142, 128, 144, 128, 146, 129, 148,
	131, 143, 21, 145, 148, 147, 148, 148, 149, 143, 20, 144, 147, 146, 147, 142, 19, 143, 146, 145,
	146, 147, 147, 148, 149, 128, 0, 129, 130, 131, 131, 133, 131, 134, 130, 130, 2, 132, 130, 133, 129,
	128, 0, 129, 129, 131, 129, 133, 128, 143, 21, 139, 140, 137, 9, 133, 128, 132, 11, 136, 139, 139,
	11, 144, 139, 149, 0, 0, 0, 129, 21, 130, 148, 131, 146, 131, 140, 129, 140, 128, 139, 128, 137,
	129, 138, 131, 138, 131, 131, 129, 130, 131, 19, 132, 145, 132, 131, 129, 11, 132, 139, 133, 2, 136,
	130, 138, 129, 129, 21, 131, 148, 132, 147, 133, 145, 133, 131, 137, 131, 140, 130, 129, 2, 132,
	130, 135, 129, 137, 128, 140, 130, 143, 131, 137, 17, 140, 146, 142, 147, 144, 149, 145, 148, 147,
	147, 145, 146, 145, 253, 144, 251, 142, 249, 140, 250, 136, 251, 131, 251, 144, 18, 145, 147, 144,
	148, 143, 147, 144, 146, 144, 130, 142, 19, 143, 146, 143, 131, 145, 128, 143, 122, 141, 251, 138,
	251, 144, 123, 141, 252, 135, 252, 131, 251, 137, 17, 137, 131, 137, 14, 139, 141, 141, 141, 143,
	142, 137, 8, 139, 137, 141, 137, 143, 136, 149, 0, 0, 0, 142, 20, 141, 146, 136, 140, 133, 136, 131,
	132, 128, 128, 140, 16, 132, 133, 144, 21, 141, 145, 139, 141, 136, 137, 131, 131, 130, 129, 128,
	19, 130, 149, 133, 148, 139, 148, 144, 149, 129, 20, 133, 147, 137, 147, 141, 148, 128, 19, 132,
	146, 136, 146, 140, 147, 142, 148, 130, 1, 132, 130, 136, 131, 140, 131, 144, 130, 131, 1, 135, 130,
	139, 130, 143, 129, 128, 0, 133, 129, 139, 129, 142, 128, 144, 130, 131, 11, 135, 139, 138, 11, 142,
	139, 146, 0, 0, 0, 128, 19, 128, 255, 129, 19, 129, 255, 128, 19, 133, 147, 128, 127, 133, 255, 135,
	0, 0, 0, 128, 21, 142, 253, 145, 0, 0, 0, 132, 19, 132, 255, 133, 19, 133, 255, 128, 19, 133, 147,
	128, 127, 133, 255, 136, 0, 0, 0, 136, 21, 130, 144, 136, 148, 142, 144, 136, 149, 147, 0, 0, 0, 128,
	122, 145, 250, 145, 249, 128, 249, 128, 250, 148, 0, 0, 0, 131, 21, 129, 148, 128, 146, 128, 144,
	129, 142, 131, 144, 129, 146, 129, 148, 129, 17, 129, 143, 130, 144, 129, 145, 135, 0, 0, 0, 131, 9,
	129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 130, 136, 131, 128, 5, 129, 131, 130, 130,
	132, 129, 129, 7, 129, 133, 130, 131, 132, 130, 133, 130, 129, 11, 131, 139, 134, 140, 136, 141,
	137, 142, 139, 140, 138, 139, 138, 131, 139, 130, 140, 130, 130, 13, 129, 140, 132, 140, 135, 12,
	138, 140, 137, 141, 137, 130, 138, 129, 128, 12, 130, 142, 131, 141, 133, 140, 136, 139, 136, 130,
	138, 128, 140, 130, 128, 12, 133, 135, 142, 0, 0, 0, 129, 19, 130, 145, 130, 131, 128, 130, 131, 17,
	130, 147, 131, 148, 131, 131, 134, 129, 129, 19, 132, 149, 132, 131, 134, 130, 135, 129, 128, 2,
	130, 130, 132, 129, 133, 128, 135, 129, 138, 130, 140, 130, 132, 11, 135, 140, 137, 141, 138, 142,
	139, 141, 141, 140, 142, 140, 140, 139, 140, 130, 137, 13, 139, 140, 139, 131, 135, 12, 136, 140,
	138, 139, 138, 130, 144, 0, 0, 0, 130, 12, 130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 131, 12,
	131, 130, 133, 129, 132, 12, 132, 131, 134, 130, 135, 130, 133, 129, 132, 128, 130, 12, 134, 141,
	136, 142, 137, 141, 139, 140, 140, 140, 135, 13, 136, 140, 138, 140, 132, 12, 134, 141, 136, 139,
	138, 139, 140, 140, 140, 0, 0, 0, 135, 14, 133, 141, 130, 140, 130, 131, 128, 130, 131, 12, 131, 131,
	134, 129, 135, 14, 132, 140, 132, 131, 134, 130, 135, 129, 128, 2, 130, 130, 132, 129, 133, 128,
	135, 129, 138, 130, 140, 130, 130, 19, 133, 149, 134, 146, 140, 140, 140, 130, 133, 18, 131, 147,
	132, 148, 133, 146, 139, 140, 139, 131, 130, 19, 138, 139, 138, 130, 143, 0, 0, 0, 131, 6, 136, 137,
	138, 138, 135, 142, 131, 140, 131, 131, 133, 130, 134, 130, 132, 129, 130, 130, 130, 140, 128, 142,
	128, 130, 130, 129, 131, 128, 132, 129, 136, 9, 133, 141, 134, 13, 137, 138, 130, 12, 131, 140, 255,
	3, 255, 131, 140, 0, 0, 0, 131, 19, 131, 131, 129, 130, 130, 130, 132, 129, 133, 128, 132, 19, 132,
	130, 134, 129, 133, 19, 133, 131, 135, 130, 136, 130, 134, 129, 133, 128, 131, 19, 134, 148, 136,
	149, 137, 148, 139, 147, 140, 147, 135, 20, 136, 147, 138, 147, 133, 19, 134, 148, 136, 146, 138,
	146, 140, 147, 128, 14, 131, 142, 133, 14, 137, 142, 140, 0, 0, 0, 130, 12, 130, 131, 128, 130, 129,
	130, 131, 129, 132, 128, 133, 129, 135, 130, 138, 131, 131, 11, 131, 130, 133, 129, 132, 12, 132,
	131, 134, 130, 135, 130, 130, 12, 132, 140, 135, 141, 137, 142, 138, 141, 140, 140, 142, 140, 140,
	139, 140, 255, 139, 252, 137, 250, 135, 249, 134, 250, 132, 251, 130, 251, 136, 13, 139, 139, 139,
	255, 136, 122, 134, 251, 133, 251, 135, 13, 136, 140, 138, 139, 138, 129, 139, 254, 139, 252, 137,
	122, 136, 251, 134, 252, 132, 252, 130, 251, 144, 0, 0, 0, 129, 19, 130, 145, 130, 131, 128, 130,
	129, 130, 131, 129, 132, 128, 131, 17, 130, 147, 131, 148, 131, 130, 133, 129, 129, 19, 132, 149,
	132, 131, 134, 130, 132, 128, 132, 11, 135, 140, 137, 141, 138, 142, 139, 141, 141, 140, 142, 140,
	140, 139, 140, 130, 138, 128, 137, 254, 137, 13, 139, 140, 139, 130, 138, 128, 135, 12, 136, 140,
	138, 139, 138, 130, 137, 254, 137, 251, 138, 249, 139, 249, 137, 251, 144, 0, 0, 0, 131, 21, 129,
	147, 131, 146, 133, 147, 131, 149, 131, 20, 130, 147, 132, 147, 131, 148, 131, 14, 130, 141, 128,
	140, 130, 139, 130, 130, 132, 128, 134, 130, 131, 11, 132, 140, 131, 141, 130, 140, 131, 139, 131,
	130, 132, 129, 131, 14, 132, 141, 134, 140, 132, 139, 132, 131, 133, 130, 134, 130, 136, 0, 0, 0,
	131, 21, 129, 147, 131, 146, 133, 147, 131, 149, 131, 20, 130, 147, 132, 147, 131, 148, 131, 14,
	130, 141, 128, 140, 130, 139, 130, 130, 132, 128, 133, 254, 131, 11, 132, 140, 131, 141, 130, 140,
	131, 139, 131, 130, 132, 128, 131, 14, 132, 141, 134, 140, 132, 139, 132, 130, 133, 254, 133, 251,
	131, 249, 129, 249, 129, 250, 131, 249, 136, 0, 0, 0, 129, 19, 130, 145, 130, 131, 128, 130, 129,
	130, 131, 129, 132, 128, 131, 17, 130, 147, 131, 148, 131, 130, 133, 129, 129, 19, 132, 149, 132,
	131, 134, 130, 132, 128, 132, 11, 135, 141, 137, 142, 139, 139, 136, 137, 132, 134, 136, 13, 138,
	139, 135, 13, 137, 138, 136, 9, 137, 136, 139, 131, 140, 130, 141, 130, 136, 8, 137, 135, 138, 130,
	139, 129, 135, 8, 136, 135, 137, 130, 139, 128, 141, 130, 143, 0, 0, 0, 129, 19, 130, 145, 130, 131,
	128, 130, 129, 130, 131, 129, 132, 128, 131, 17, 130, 147, 131, 148, 131, 130, 133, 129, 129, 19,
	132, 149, 132, 131, 134, 130, 135, 130, 133, 129, 132, 128, 136, 0, 0, 0, 128, 12, 129, 140, 130,
	139, 130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 130, 13, 131, 140, 131, 130, 133, 129, 128,
	12, 130, 142, 132, 140, 132, 131, 134, 130, 132, 128, 132, 11, 135, 140, 137, 141, 138, 142, 140,
	140, 140, 131, 142, 130, 140, 128, 137, 13, 139, 140, 139, 130, 141, 129, 135, 12, 136, 140, 138,
	139, 138, 131, 137, 130, 139, 129, 140, 128, 140, 11, 143, 140, 145, 141, 146, 142, 147, 141, 149,
	140, 150, 140, 148, 139, 148, 131, 149, 130, 150, 130, 145, 13, 147, 140, 147, 130, 148, 129, 143,
	12, 144, 140, 146, 139, 146, 130, 148, 128, 150, 130, 152, 0, 0, 0, 128, 12, 129, 140, 130, 139,
	130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 130, 13, 131, 140, 131, 130, 133, 129, 128, 12,
	130, 142, 132, 140, 132, 131, 134, 130, 132, 128, 132, 11, 135, 140, 137, 141, 138, 142, 139, 141,
	141, 140, 142, 140, 140, 139, 140, 131, 141, 130, 142, 130, 137, 13, 139, 140, 139, 130, 140, 129,
	135, 12, 136, 140, 138, 139, 138, 130, 140, 128, 142, 130, 144, 0, 0, 0, 130, 12, 130, 131, 128, 130,
	131, 11, 131, 131, 134, 129, 132, 12, 132, 131, 134, 130, 135, 129, 128, 2, 130, 130, 132, 129, 133,
	128, 135, 129, 138, 130, 140, 130, 130, 12, 132, 140, 135, 141, 137, 142, 138, 141, 140, 140, 142,
	140, 140, 139, 140, 130, 136, 13, 139, 139, 139, 131, 135, 13, 136, 140, 138, 139, 138, 130, 144, 0,
	0, 0, 129, 14, 130, 140, 130, 131, 128, 130, 130, 130, 130, 249, 130, 13, 131, 140, 131, 250, 132,
	251, 131, 253, 131, 2, 132, 130, 134, 129, 129, 14, 131, 141, 132, 140, 132, 131, 134, 130, 135,
	129, 132, 1, 133, 128, 135, 129, 138, 130, 140, 130, 132, 1, 132, 253, 133, 251, 130, 249, 132, 11,
	135, 140, 137, 141, 138, 142, 139, 141, 141, 140, 142, 140, 140, 139, 140, 130, 137, 13, 139, 140,
	139, 131, 135, 12, 136, 140, 138, 139, 138, 130, 144, 0, 0, 0, 130, 12, 130, 131, 128, 130, 131, 11,
	131, 130, 133, 129, 132, 12, 132, 131, 134, 130, 135, 130, 128, 2, 129, 130, 131, 129, 132, 128,
	133, 129, 135, 130, 138, 131, 130, 12, 132, 140, 135, 141, 137, 142, 138, 141, 140, 140, 142, 140,
	140, 139, 140, 249, 136, 13, 139, 139, 139, 250, 138, 251, 139, 253, 135, 13, 136, 140, 138, 139,
	138, 253, 137, 251, 140, 249, 144, 0, 0, 0, 128, 12, 129, 140, 130, 139, 130, 131, 128, 130, 129,
	130, 131, 129, 132, 128, 129, 13, 131, 140, 131, 130, 133, 129, 128, 12, 130, 142, 132, 140, 132,
	131, 134, 130, 135, 130, 133, 129, 132, 128, 132, 12, 136, 142, 137, 141, 139, 140, 140, 140, 135,
	13, 136, 140, 138, 140, 134, 13, 136, 139, 138, 139, 140, 140, 140, 0, 0, 0, 129, 12, 129, 136, 131,
	135, 137, 135, 139, 134, 139, 130, 130, 12, 130, 136, 138, 6, 138, 130, 132, 13, 131, 140, 131, 136,
	133, 135, 135, 7, 137, 134, 137, 130, 136, 129, 129, 12, 132, 141, 134, 142, 136, 141, 138, 141,
	139, 142, 133, 13, 135, 141, 132, 13, 134, 140, 136, 140, 138, 141, 139, 2, 136, 129, 134, 128, 132,
	129, 130, 129, 128, 128, 135, 1, 133, 129, 136, 1, 134, 130, 131, 130, 128, 128, 139, 14, 138, 140,
	136, 137, 131, 132, 128, 128, 142, 0, 0, 0, 130, 19, 131, 145, 131, 131, 129, 130, 130, 130, 132,
	129, 133, 128, 132, 17, 131, 147, 132, 148, 132, 130, 134, 129, 130, 19, 133, 149, 133, 131, 135,
	130, 136, 130, 134, 129, 133, 128, 128, 14, 131, 142, 133, 14, 136, 142, 137, 0, 0, 0, 128, 12, 129,
	140, 130, 139, 130, 131, 128, 130, 129, 13, 131, 140, 131, 130, 133, 129, 128, 12, 130, 142, 132,
	140, 132, 131, 134, 130, 135, 130, 128, 2, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130, 138,
	131, 138, 14, 139, 141, 141, 140, 142, 140, 140, 139, 140, 131, 141, 130, 142, 130, 137, 13, 139,
	140, 139, 130, 140, 129, 138, 14, 136, 140, 138, 139, 138, 130, 140, 128, 142, 130, 144, 0, 0, 0,
	128, 14, 129, 140, 129, 131, 132, 128, 134, 130, 137, 131, 139, 131, 129, 13, 130, 140, 130, 131,
	133, 129, 128, 14, 130, 141, 131, 140, 131, 132, 132, 131, 134, 130, 137, 14, 138, 141, 140, 140,
	141, 140, 139, 139, 139, 131, 136, 13, 138, 140, 138, 132, 137, 14, 135, 140, 137, 139, 137, 131,
	143, 0, 0, 0, 128, 14, 129, 140, 129, 131, 132, 128, 134, 130, 137, 131, 129, 13, 130, 140, 130, 131,
	133, 129, 128, 14, 130, 141, 131, 140, 131, 132, 132, 131, 134, 130, 137, 14, 135, 140, 137, 139,
	137, 131, 140, 128, 142, 130, 145, 131, 147, 131, 136, 13, 138, 140, 138, 131, 141, 129, 137, 14,
	138, 141, 140, 140, 139, 139, 139, 132, 140, 131, 142, 130, 145, 14, 146, 141, 148, 140, 149, 140,
	147, 139, 147, 131, 144, 13, 146, 140, 146, 132, 145, 14, 143, 140, 145, 139, 145, 131, 151, 0, 0, 0,
	129, 12, 130, 140, 132, 139, 133, 138, 137, 130, 138, 129, 140, 128, 142, 130, 131, 13, 133, 140,
	138, 130, 140, 129, 129, 12, 131, 142, 133, 141, 134, 140, 138, 132, 139, 131, 141, 130, 142, 130,
	136, 8, 139, 142, 140, 141, 142, 141, 143, 142, 139, 13, 140, 140, 141, 140, 138, 12, 140, 139, 142,
	140, 143, 142, 135, 6, 132, 128, 131, 129, 129, 129, 128, 128, 132, 1, 131, 130, 130, 130, 133, 2,
	131, 131, 129, 130, 128, 128, 131, 7, 134, 135, 137, 7, 140, 135, 145, 0, 0, 0, 128, 12, 129, 140,
	130, 139, 130, 131, 128, 130, 129, 13, 131, 140, 131, 130, 133, 129, 128, 12, 130, 142, 132, 140,
	132, 131, 134, 130, 135, 130, 128, 2, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130, 138, 131,
	138, 14, 139, 141, 141, 140, 142, 140, 140, 139, 140, 255, 139, 252, 137, 250, 135, 249, 134, 250,
	132, 251, 130, 251, 137, 13, 139, 140, 139, 255, 136, 122, 134, 251, 133, 251, 138, 14, 136, 140,
	138, 139, 138, 129, 139, 254, 139, 252, 137, 122, 136, 251, 134, 252, 132, 252, 130, 251, 144, 0, 0,
	0, 140, 14, 128, 128, 128, 12, 130, 139, 133, 139, 136, 140, 140, 142, 129, 13, 131, 140, 135,
	140, 128, 12, 130, 142, 132, 141, 136, 141, 140, 142, 128, 0, 132, 130, 135, 131, 138, 131, 140,
	130, 133, 2, 137, 130, 139, 129, 128, 0, 132, 129, 136, 129, 138, 128, 140, 130, 130, 7, 138, 135,
	143, 0, 0, 0, 133, 25, 131, 152, 130, 151, 129, 149, 129, 147, 130, 145, 131, 144, 132, 142, 132,
	140, 130, 138, 131, 24, 130, 150, 130, 148, 131, 146, 132, 145, 133, 143, 133, 141, 132, 139, 128,
	137, 132, 135, 133, 133, 133, 131, 132, 129, 131, 128, 130, 254, 130, 252, 131, 250, 133, 249, 130,
	8, 132, 134, 132, 132, 131, 130, 130, 129, 129, 255, 129, 253, 130, 251, 131, 250, 139, 0, 0, 0,
	128, 23, 128, 253, 134, 0, 0, 0, 128, 25, 130, 152, 131, 151, 132, 149, 132, 147, 131, 145, 130, 144,
	129, 142, 129, 140, 131, 138, 130, 24, 131, 150, 131, 148, 130, 146, 129, 145, 128, 143, 128, 141,
	129, 139, 133, 137, 129, 135, 128, 133, 128, 131, 129, 129, 130, 128, 131, 254, 131, 252, 130, 250,
	131, 8, 129, 134, 129, 132, 130, 130, 131, 129, 132, 255, 132, 253, 131, 251, 130, 250, 128, 249,
	137, 0, 0, 0, 138, 15, 135, 145, 128, 144, 135, 147, 140, 143, 145, 146, 140, 142, 135, 145, 148, 0,
	0, 0, 128, 5, 128, 128, 140, 128, 140, 134, 134, 142, 128, 134, 128, 133, 142, 0, 0, 0, 134, 22,
	132, 149, 130, 147, 129, 145, 128, 142, 128, 138, 129, 135, 130, 133, 133, 131, 136, 130, 139, 130,
	142, 131, 144, 132, 146, 134, 147, 136, 145, 134, 143, 133, 140, 132, 137, 132, 134, 133, 131, 136,
	130, 139, 130, 143, 131, 146, 132, 148, 134, 150, 130, 18, 129, 143, 129, 138, 131, 134, 134, 132,
	137, 131, 140, 131, 143, 132, 138, 20, 136, 147, 136, 135, 137, 136, 138, 138, 138, 148, 141, 151,
	143, 150, 145, 150, 146, 151, 145, 149, 143, 148, 143, 133, 137, 19, 137, 137, 140, 22, 142, 149,
	144, 149, 139, 21, 141, 148, 143, 148, 135, 121, 133, 250, 132, 252, 132, 254, 130, 253, 131, 251,
	132, 250, 135, 249, 137, 249, 139, 250, 140, 252, 140, 254, 139, 128, 135, 129, 135, 130, 136, 2,
	136, 129, 139, 129, 141, 255, 142, 253, 141, 251, 140, 250, 137, 249, 131, 125, 132, 251, 140, 127,
	141, 254, 141, 252, 140, 251, 149, 0, 153, 0, 0, 0, 135, 2, 134, 130, 132, 131, 132, 140, 130, 142,
	128, 140, 129, 140, 130, 139, 130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130,
	138, 131, 129, 13, 131, 140, 131, 130, 133, 129, 138, 14, 139, 141, 141, 140, 142, 140, 140, 139,
	140, 131, 141, 130, 142, 130, 140, 128, 138, 130, 138, 139, 136, 140, 138, 142, 137, 13, 139, 140,
	139, 130, 140, 129, 132, 19, 130, 145, 132, 144, 134, 145, 132, 147, 132, 18, 131, 145, 133, 145,
	132, 146, 138, 19, 136, 145, 138, 144, 140, 145, 138, 147, 138, 18, 137, 145, 139, 145, 138, 146,
	144, 0, 0, 0, 131, 6, 136, 137, 138, 138, 135, 142, 131, 140, 131, 131, 133, 130, 134, 130, 132, 129,
	130, 130, 130, 140, 128, 142, 128, 130, 130, 129, 131, 128, 132, 129, 136, 9, 133, 141, 134, 13,
	137, 138, 130, 12, 131, 140, 135, 18, 135, 148, 133, 150, 135, 152, 136, 150, 136, 148, 135, 146,
	131, 144, 135, 23, 134, 150, 135, 149, 135, 151, 140, 0, 0, 0, 133, 9, 131, 135, 130, 133, 130, 131,
	131, 129, 133, 128, 135, 130, 138, 131, 130, 5, 131, 131, 132, 130, 134, 129, 131, 7, 131, 133, 132,
	131, 134, 130, 135, 130, 131, 11, 133, 139, 136, 140, 138, 141, 139, 142, 141, 140, 140, 139, 140,
	131, 141, 130, 142, 130, 140, 128, 138, 130, 138, 139, 135, 140, 133, 141, 132, 142, 130, 140, 135,
	135, 132, 13, 131, 140, 134, 140, 137, 12, 140, 140, 139, 141, 139, 130, 140, 129, 135, 21, 129,
	144, 135, 148, 141, 144, 135, 149, 146, 0, 0, 0, 131, 9, 129, 135, 128, 133, 128, 131, 129, 129, 131,
	128, 133, 130, 136, 131, 128, 5, 129, 131, 130, 130, 132, 129, 129, 7, 129, 133, 130, 131, 132, 130,
	133, 130, 129, 11, 131, 139, 134, 140, 136, 141, 137, 142, 139, 140, 138, 139, 138, 131, 139, 130,
	140, 130, 138, 128, 136, 130, 136, 139, 133, 140, 131, 141, 130, 142, 128, 140, 133, 135, 130, 13,
	129, 140, 132, 140, 135, 12, 138, 140, 137, 141, 137, 130, 138, 129, 131, 19, 129, 145, 131, 144,
	133, 145, 131, 147, 131, 18, 130, 145, 132, 145, 131, 146, 137, 19, 135, 145, 137, 144, 139, 145,
	137, 147, 137, 18, 136, 145, 138, 145, 137, 146, 142, 0, 0, 0, 131, 9, 129, 135, 128, 133, 128, 131,
	129, 129, 131, 128, 133, 130, 136, 131, 128, 5, 129, 131, 130, 130, 132, 129, 129, 7, 129, 133, 130,
	131, 132, 130, 133, 130, 129, 11, 131, 139, 134, 140, 136, 141, 137, 142, 139, 140, 138, 139, 138,
	131, 139, 130, 140, 130, 138, 128, 136, 130, 136, 139, 133, 140, 131, 141, 130, 142, 128, 140, 133,
	135, 130, 13, 129, 140, 132, 140, 135, 12, 138, 140, 137, 141, 137, 130, 138, 129, 131, 18, 131,
	148, 133, 150, 131, 152, 130, 150, 130, 148, 131, 146, 135, 144, 131, 23, 132, 150, 131, 149, 131,
	151, 142, 0, 0, 0, 131, 9, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 130, 136, 131, 128,
	5, 129, 131, 130, 130, 132, 129, 129, 7, 129, 133, 130, 131, 132, 130, 133, 130, 129, 11, 131,
	139, 134, 140, 136, 141, 137, 142, 139, 140, 138, 139, 138, 131, 139, 130, 140, 130, 138, 128, 136,
	130, 136, 139, 133, 140, 131, 141, 130, 142, 128, 140, 133, 135, 130, 13, 129, 140, 132, 140, 135,
	12, 138, 140, 137, 141, 137, 130, 138, 129, 134, 19, 132, 145, 134, 144, 136, 145, 134, 147, 134,
	18, 133, 145, 135, 145, 134, 146, 142, 0, 0, 0, 136, 6, 136, 142, 138, 143, 140, 141, 142, 141, 144,
	142, 143, 142, 141, 143, 140, 144, 138, 143, 134, 142, 134, 134, 135, 133, 137, 132, 139, 133, 138,
	133, 136, 134, 135, 14, 135, 134, 139, 15, 140, 142, 142, 142, 133, 5, 135, 132, 136, 131, 137, 132,
	134, 4, 135, 130, 137, 128, 138, 254, 138, 252, 137, 250, 135, 249, 138, 250, 139, 251, 140, 253,
	139, 255, 137, 129, 135, 130, 133, 130, 134, 132, 134, 130, 138, 123, 139, 252, 139, 254, 138, 255,
	133, 121, 131, 250, 130, 252, 130, 254, 128, 253, 129, 251, 130, 250, 133, 249, 135, 249, 129, 125,
	130, 251, 147, 0, 0, 0, 135, 6, 140, 137, 142, 138, 139, 142, 135, 140, 135, 131, 137, 130, 138, 130,
	136, 129, 134, 130, 134, 140, 132, 142, 132, 130, 134, 129, 135, 128, 136, 129, 140, 9, 137, 141,
	138, 13, 141, 138, 134, 12, 135, 140, 136, 21, 130, 144, 136, 148, 142, 144, 136, 149, 146, 0, 0, 0,
	131, 6, 136, 137, 138, 138, 135, 142, 131, 140, 131, 131, 133, 130, 134, 130, 132, 129, 130, 130,
	130, 140, 128, 142, 128, 130, 130, 129, 131, 128, 132, 129, 136, 9, 133, 141, 134, 13, 137, 138,
	130, 12, 131, 140, 130, 19, 128, 145, 130, 144, 132, 145, 130, 147, 130, 18, 129, 145, 131, 145,
	130, 146, 136, 19, 134, 145, 136, 144, 138, 145, 136, 147, 136, 18, 135, 145, 137, 145, 136, 146,
	140, 0, 0, 0, 131, 6, 136, 137, 138, 138, 135, 142, 131, 140, 131, 131, 133, 130, 134, 130, 132, 129,
	130, 130, 130, 140, 128, 142, 128, 130, 130, 129, 131, 128, 132, 129, 136, 9, 133, 141, 134, 13,
	137, 138, 130, 12, 131, 140, 129, 18, 129, 148, 131, 150, 129, 152, 128, 150, 128, 148, 129, 146,
	133, 144, 129, 23, 130, 150, 129, 149, 129, 151, 140, 0, 0, 0, 133, 14, 132, 141, 130, 140, 132, 139,
	132, 130, 134, 128, 136, 130, 135, 130, 134, 131, 134, 139, 136, 140, 134, 141, 133, 142, 133, 11,
	134, 140, 133, 141, 132, 140, 133, 139, 133, 130, 134, 129, 130, 19, 128, 145, 130, 144, 132, 145,
	130, 147, 130, 18, 129, 145, 131, 145, 130, 146, 136, 19, 134, 145, 136, 144, 138, 145, 136, 147,
	136, 18, 135, 145, 137, 145, 136, 146, 140, 0, 0, 0, 136, 14, 135, 141, 133, 140, 135, 139, 135, 130,
	137, 128, 139, 130, 138, 130, 137, 131, 137, 139, 139, 140, 137, 141, 136, 142, 136, 11, 137, 140,
	136, 141, 135, 140, 136, 139, 136, 130, 137, 129, 136, 21, 130, 144, 136, 148, 142, 144, 136, 149,
	146, 0, 0, 0, 133, 14, 132, 141, 130, 140, 132, 139, 132, 130, 134, 128, 136, 130, 135, 130, 134,
	131, 134, 139, 136, 140, 134, 141, 133, 142, 133, 11, 134, 140, 133, 141, 132, 140, 133, 139, 133,
	130, 134, 129, 129, 18, 129, 148, 131, 150, 129, 152, 128, 150, 128, 148, 129, 146, 133, 144, 129,
	23, 130, 150, 129, 149, 129, 151, 139, 0, 0, 0, 133, 18, 135, 148, 137, 149, 139, 149, 140, 148,
	147, 132, 148, 131, 150, 131, 148, 128, 147, 128, 146, 129, 145, 131, 138, 147, 137, 148, 135, 148,
	138, 20, 139, 147, 146, 131, 147, 129, 148, 130, 146, 131, 133, 14, 134, 143, 136, 144, 137, 144,
	138, 143, 137, 15, 137, 142, 134, 15, 136, 143, 137, 141, 128, 0, 130, 130, 132, 131, 135, 131, 137,
	130, 135, 128, 134, 129, 131, 129, 128, 128, 131, 2, 135, 130, 136, 129, 139, 17, 133, 131, 135, 8,
	143, 136, 136, 27, 134, 153, 136, 152, 138, 153, 136, 155, 136, 26, 135, 153, 137, 153, 136, 154,
	142, 27, 140, 153, 142, 152, 144, 153, 142, 155, 142, 26, 141, 153, 143, 153, 142, 154, 153, 0, 0, 0,
	133, 18, 135, 148, 137, 149, 139, 149, 140, 148, 147, 132, 148, 131, 150, 131, 148, 128, 147, 128,
	146, 129, 145, 131, 138, 147, 137, 148, 135, 148, 138, 20, 139, 147, 146, 131, 147, 129, 148, 130,
	146, 131, 133, 14, 134, 143, 136, 144, 137, 144, 138, 143, 137, 15, 137, 142, 134, 15, 136, 143,
	137, 141, 128, 0, 130, 130, 132, 131, 135, 131, 137, 130, 135, 128, 134, 129, 131, 129, 128, 128,
	131, 2, 135, 130, 136, 129, 139, 17, 133, 131, 135, 8, 143, 136, 142, 25, 142, 153, 139, 27, 137,
	153, 139, 152, 141, 153, 139, 155, 139, 26, 138, 153, 140, 153, 139, 154, 154, 0, 0, 0, 130, 0, 133,
	130, 137, 131, 142, 131, 146, 130, 144, 128, 141, 129, 134, 129, 130, 128, 132, 1, 135, 130, 142,
	130, 145, 129, 137, 6, 138, 135, 140, 135, 141, 134, 143, 136, 141, 137, 139, 137, 138, 136, 137,
	134, 136, 131, 136, 136, 137, 139, 138, 141, 139, 142, 141, 143, 143, 143, 146, 142, 144, 140, 142,
	141, 140, 141, 138, 140, 137, 139, 128, 13, 130, 143, 132, 143, 134, 142, 136, 143, 134, 141, 132,
	141, 130, 142, 128, 141, 131, 14, 133, 142, 139, 13, 141, 142, 143, 142, 145, 141, 139, 8, 141, 136,
	142, 135, 132, 8, 128, 136, 128, 134, 129, 135, 131, 135, 131, 131, 133, 134, 133, 139, 131, 137,
	131, 136, 132, 5, 132, 138, 138, 19, 138, 149, 136, 151, 138, 153, 139, 151, 139, 149, 138, 147,
	134, 145, 138, 24, 137, 151, 138, 150, 138, 152, 148, 0, 0, 0, 131, 9, 129, 135, 128, 133, 128, 131,
	129, 129, 131, 128, 133, 130, 136, 131, 128, 5, 129, 131, 130, 130, 132, 129, 129, 7, 129, 133, 130,
	131, 132, 130, 133, 130, 129, 11, 131, 139, 134, 140, 136, 141, 137, 142, 139, 140, 138, 139, 138,
	131, 139, 130, 139, 140, 142, 141, 144, 142, 147, 138, 140, 134, 130, 13, 129, 140, 132, 140, 135,
	12, 138, 140, 137, 141, 137, 130, 139, 129, 140, 128, 141, 129, 143, 130, 142, 130, 140, 131, 140,
	140, 142, 141, 145, 137, 133, 7, 128, 140, 130, 142, 131, 141, 133, 140, 136, 139, 136, 129, 137,
	129, 138, 128, 137, 129, 137, 129, 146, 10, 143, 141, 142, 141, 150, 0, 0, 0, 133, 18, 135, 148, 137,
	149, 139, 149, 140, 148, 140, 147, 142, 149, 144, 149, 146, 148, 148, 149, 146, 147, 144, 147, 142,
	148, 140, 147, 138, 20, 139, 147, 142, 140, 143, 140, 143, 141, 144, 143, 145, 144, 145, 135, 143,
	132, 143, 138, 141, 138, 140, 137, 140, 139, 141, 140, 138, 147, 137, 148, 135, 148, 142, 10, 143,
	136, 135, 136, 146, 1, 142, 128, 145, 130, 149, 131, 154, 131, 158, 130, 156, 128, 153, 129, 146,
	129, 139, 17, 133, 131, 133, 14, 134, 143, 136, 144, 137, 144, 138, 143, 137, 15, 137, 142, 134, 15,
	136, 143, 137, 141, 128, 0, 130, 130, 132, 131, 135, 131, 137, 130, 135, 128, 134, 129, 131, 129,
	128, 128, 131, 2, 135, 130, 136, 129, 143, 20, 145, 148, 157, 1, 154, 130, 147, 130, 144, 136, 144,
	134, 146, 130, 141, 11, 144, 139, 153, 21, 155, 149, 158, 148, 156, 146, 154, 147, 152, 147, 150,
	146, 149, 145, 150, 147, 151, 148, 153, 149, 151, 19, 153, 148, 155, 148, 157, 147, 149, 17, 148,
	142, 148, 131, 148, 6, 149, 137, 150, 139, 151, 140, 153, 140, 155, 139, 153, 137, 152, 138, 150,
	138, 149, 137, 151, 11, 153, 139, 154, 138, 144, 1, 147, 130, 144, 14, 144, 136, 145, 134, 145, 135,
	163, 0, 0, 0, 136, 1, 135, 130, 133, 131, 133, 140, 131, 140, 131, 131, 129, 130, 131, 130, 133, 129,
	134, 128, 136, 129, 139, 130, 141, 130, 141, 139, 143, 140, 141, 140, 139, 141, 138, 142, 136, 141,
	137, 140, 139, 139, 139, 130, 132, 11, 132, 131, 135, 129, 133, 12, 136, 141, 137, 13, 140, 139,
	140, 131, 136, 21, 130, 144, 136, 148, 142, 144, 136, 149, 144, 0, 0, 0, 135, 1, 134, 130, 132, 131,
	132, 140, 130, 140, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 138, 130, 140, 130,
	140, 139, 142, 140, 140, 140, 138, 141, 137, 142, 135, 141, 136, 140, 138, 139, 138, 130, 131, 11,
	131, 131, 134, 129, 132, 12, 135, 141, 136, 13, 139, 139, 139, 131, 133, 20, 131, 146, 133, 145,
	135, 146, 133, 148, 133, 19, 132, 146, 134, 146, 133, 147, 139, 20, 137, 146, 139, 145, 141, 146,
	139, 148, 139, 19, 138, 146, 140, 146, 139, 147, 144, 0, 0, 0, 135, 1, 134, 130, 132, 131, 132, 140,
	130, 140, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 138, 130, 140, 130, 140, 139,
	142, 140, 140, 140, 138, 141, 137, 142, 135, 141, 136, 140, 138, 139, 138, 130, 131, 11, 131, 131,
	134, 129, 132, 12, 135, 141, 136, 13, 139, 139, 139, 131, 132, 18, 132, 148, 134, 150, 132, 152,
	131, 150, 131, 148, 132, 146, 136, 144, 132, 23, 133, 150, 132, 149, 132, 151, 144, 0, 0, 0, 136, 2,
	135, 130, 133, 131, 133, 140, 131, 142, 129, 140, 130, 140, 131, 139, 131, 131, 129, 130, 130, 130,
	132, 129, 133, 128, 134, 129, 136, 130, 139, 131, 130, 13, 132, 140, 132, 130, 134, 129, 139, 14,
	140, 141, 142, 140, 143, 140, 141, 139, 141, 131, 142, 130, 143, 130, 141, 128, 139, 130, 139, 139,
	137, 140, 139, 142, 138, 13, 140, 140, 140, 130, 141, 129, 136, 21, 130, 144, 136, 148, 142, 144,
	136, 149, 146, 0, 0, 0, 135, 2, 134, 130, 132, 131, 132, 140, 130, 142, 128, 140, 129, 140, 130, 139,
	130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130, 138, 131, 129, 13, 131, 140,
	131, 130, 133, 129, 138, 14, 139, 141, 141, 140, 142, 140, 140, 139, 140, 131, 141, 130, 142, 130,
	140, 128, 138, 130, 138, 139, 136, 140, 138, 142, 137, 13, 139, 140, 139, 130, 140, 129, 131, 18,
	131, 148, 133, 150, 131, 152, 130, 150, 130, 148, 131, 146, 135, 144, 131, 23, 132, 150, 131, 149,
	131, 151, 144, 0, 0, 0, 135, 2, 134, 130, 132, 131, 132, 140, 130, 142, 128, 140, 129, 140, 130, 139,
	130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130, 138, 131, 129, 13, 131, 140,
	131, 130, 133, 129, 139, 124, 139, 254, 138, 129, 138, 139, 136, 140, 138, 142, 139, 141, 141, 140,
	142, 140, 140, 139, 140, 255, 139, 252, 137, 250, 135, 249, 134, 250, 132, 251, 130, 251, 132, 252,
	134, 252, 136, 251, 137, 250, 137, 13, 139, 140, 139, 255, 136, 122, 134, 251, 133, 251, 132, 19,
	130, 145, 132, 144, 134, 145, 132, 147, 132, 18, 131, 145, 133, 145, 132, 146, 138, 19, 136, 145,
	138, 144, 140, 145, 138, 147, 138, 18, 137, 145, 139, 145, 138, 146, 144, 0, 0, 0, 134, 1, 132, 131,
	131, 133, 130, 136, 130, 142, 131, 145, 132, 147, 134, 149, 132, 148, 130, 146, 129, 144, 128, 141,
	128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 142, 129, 144, 130, 146, 132,
	147, 134, 148, 137, 148, 141, 147, 144, 146, 146, 144, 148, 142, 149, 141, 148, 138, 146, 135, 145,
	135, 132, 136, 133, 137, 135, 137, 145, 130, 17, 129, 142, 129, 136, 130, 133, 146, 5, 147, 136,
	147, 142, 145, 146, 144, 147, 142, 1, 144, 131, 145, 133, 146, 136, 146, 142, 145, 144, 143, 147,
	141, 148, 141, 129, 136, 17, 136, 134, 141, 14, 143, 141, 144, 141, 146, 142, 141, 8, 143, 137, 144,
	137, 146, 136, 135, 27, 133, 153, 135, 152, 137, 153, 135, 155, 135, 26, 134, 153, 136, 153, 135,
	154, 141, 27, 139, 153, 141, 152, 143, 153, 141, 155, 141, 26, 140, 153, 142, 153, 141, 154, 151, 0,
	0, 0, 128, 19, 130, 149, 132, 149, 135, 148, 137, 149, 135, 147, 133, 147, 130, 148, 128, 147,
	131, 20, 134, 148, 131, 17, 130, 143, 129, 140, 129, 136, 130, 133, 131, 131, 133, 129, 136, 128,
	139, 128, 142, 129, 144, 130, 146, 128, 148, 130, 147, 130, 146, 132, 146, 146, 148, 147, 146, 148,
	145, 149, 143, 147, 144, 146, 144, 131, 141, 130, 137, 130, 134, 131, 132, 133, 131, 135, 130, 138,
	130, 141, 131, 145, 130, 8, 131, 133, 134, 130, 137, 129, 140, 129, 143, 19, 141, 146, 137, 145,
	136, 143, 136, 133, 137, 134, 138, 136, 138, 145, 137, 16, 137, 135, 145, 18, 146, 147, 145, 148,
	144, 147, 145, 146, 145, 131, 147, 129, 141, 18, 141, 130, 141, 13, 144, 141, 141, 9, 144, 137, 135,
	27, 133, 153, 135, 152, 137, 153, 135, 155, 135, 26, 134, 153, 136, 153, 135, 154, 141, 27, 139,
	153, 141, 152, 143, 153, 141, 155, 141, 26, 140, 153, 142, 153, 141, 154, 150, 0, 0, 0, 135, 1, 134,
	130, 132, 131, 132, 140, 130, 140, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 138,
	130, 140, 130, 140, 139, 142, 140, 140, 140, 138, 141, 137, 142, 135, 141, 136, 140, 138, 139, 138,
	130, 131, 11, 131, 131, 134, 129, 132, 12, 135, 141, 136, 13, 139, 139, 139, 131, 131, 126, 141,
	144, 142, 144, 132, 254, 131, 254, 146, 0, 0, 0, 143, 0, 145, 130, 145, 131, 143, 132, 145, 132, 146,
	131, 146, 130, 145, 129, 143, 128, 130, 128, 128, 130, 128, 131, 129, 131, 130, 128, 131, 0, 131,
	145, 132, 147, 133, 148, 135, 149, 138, 149, 140, 148, 141, 146, 141, 145, 140, 145, 140, 146, 139,
	148, 137, 149, 136, 21, 134, 148, 133, 147, 132, 144, 132, 128, 133, 13, 130, 140, 128, 139, 128,
	140, 130, 141, 136, 141, 138, 140, 138, 139, 137, 139, 135, 140, 132, 141, 151, 0, 0, 0, 134, 1, 132,
	131, 131, 133, 130, 136, 130, 142, 131, 145, 132, 147, 134, 149, 132, 148, 130, 146, 129, 144, 128,
	141, 128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 142, 129, 144, 130, 146,
	132, 147, 134, 148, 137, 148, 141, 147, 144, 146, 146, 144, 148, 142, 149, 141, 148, 138, 146, 135,
	145, 135, 132, 136, 133, 137, 135, 137, 145, 130, 17, 129, 142, 129, 136, 130, 133, 146, 5, 147,
	136, 147, 142, 145, 146, 144, 147, 142, 1, 144, 131, 145, 133, 146, 136, 146, 142, 145, 144, 143,
	147, 141, 148, 141, 129, 136, 17, 136, 134, 141, 14, 143, 141, 144, 141, 146, 142, 141, 8, 143, 137,
	144, 137, 146, 136, 131, 126, 145, 151, 146, 151, 132, 254, 131, 254, 153, 0, 0, 0, 129, 25, 130,
	152, 131, 150, 131, 144, 129, 144, 128, 143, 128, 141, 129, 142, 131, 142, 131, 134, 128, 132, 131,
	133, 131, 253, 133, 255, 133, 149, 132, 151, 131, 152, 129, 153, 131, 23, 132, 149, 132, 255, 129,
	15, 132, 143, 133, 20, 136, 150, 140, 153, 144, 149, 144, 135, 142, 134, 142, 148, 139, 151, 138,
	151, 140, 24, 143, 149, 143, 135, 136, 7, 139, 135, 142, 134, 140, 132, 138, 133, 136, 133, 137, 6,
	139, 134, 141, 133, 136, 22, 136, 128, 136, 18, 138, 145, 140, 145, 142, 146, 136, 12, 138, 141,
	140, 141, 142, 140, 150, 3, 150, 145, 147, 143, 148, 141, 148, 131, 146, 130, 147, 130, 149, 129,
	150, 128, 151, 129, 153, 130, 152, 130, 150, 131, 149, 13, 148, 143, 149, 144, 149, 130, 151, 129,
	145, 10, 148, 138, 150, 10, 153, 138, 156, 0, 0, 0, 137, 2, 137, 147, 138, 149, 139, 150, 141, 151,
	144, 151, 146, 150, 147, 148, 147, 147, 146, 147, 146, 148, 145, 150, 143, 151, 142, 23, 140, 150,
	139, 149, 138, 146, 138, 255, 137, 253, 136, 252, 134, 251, 131, 251, 129, 252, 128, 254, 128, 255,
	129, 255, 129, 254, 130, 252, 132, 251, 133, 123, 135, 252, 136, 253, 137, 128, 137, 144, 138, 10,
	135, 137, 133, 136, 133, 137, 135, 138, 141, 138, 143, 137, 143, 136, 142, 136, 140, 137, 137, 138,
	151, 0, 0, 0, 131, 9, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 130, 136, 131, 128, 5,
	129, 131, 130, 130, 132, 129, 129, 7, 129, 133, 130, 131, 132, 130, 133, 130, 129, 11, 131, 139,
	134, 140, 136, 141, 137, 142, 139, 140, 138, 139, 138, 131, 139, 130, 140, 130, 138, 128, 136, 130,
	136, 139, 133, 140, 131, 141, 130, 142, 128, 140, 133, 135, 130, 13, 129, 140, 132, 140, 135, 12,
	138, 140, 137, 141, 137, 130, 138, 129, 136, 18, 136, 148, 134, 150, 136, 152, 137, 150, 137, 148,
	136, 146, 132, 144, 136, 23, 135, 150, 136, 149, 136, 151, 142, 0, 0, 0, 131, 14, 130, 141, 128, 140,
	130, 139, 130, 130, 132, 128, 134, 130, 133, 130, 132, 131, 132, 139, 134, 140, 132, 141, 131, 142,
	131, 11, 132, 140, 131, 141, 130, 140, 131, 139, 131, 130, 132, 129, 134, 18, 134, 148, 132, 150,
	134, 152, 135, 150, 135, 148, 134, 146, 130, 144, 134, 23, 133, 150, 134, 149, 134, 151, 138, 0, 0,
	0, 135, 1, 134, 130, 132, 131, 132, 140, 130, 140, 130, 131, 128, 130, 130, 130, 132, 129, 133,
	128, 135, 129, 138, 130, 140, 130, 140, 139, 142, 140, 140, 140, 138, 141, 137, 142, 135, 141, 136,
	140, 138, 139, 138, 130, 131, 11, 131, 131, 134, 129, 132, 12, 135, 141, 136, 13, 139, 139, 139,
	131, 138, 18, 138, 148, 136, 150, 138, 152, 139, 150, 139, 148, 138, 146, 134, 144, 138, 23, 137,
	150, 138, 149, 138, 151, 144, 0, 0, 0, 135, 2, 134, 130, 132, 131, 132, 140, 130, 142, 128, 140, 129,
	140, 130, 139, 130, 131, 128, 130, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130, 138, 131, 129,
	13, 131, 140, 131, 130, 133, 129, 138, 14, 139, 141, 141, 140, 142, 140, 140, 139, 140, 131, 141,
	130, 142, 130, 140, 128, 138, 130, 138, 139, 136, 140, 138, 142, 137, 13, 139, 140, 139, 130, 140,
	129, 138, 18, 138, 148, 136, 150, 138, 152, 139, 150, 139, 148, 138, 146, 134, 144, 138, 23, 137,
	150, 138, 149, 138, 151, 144, 0, 0, 0, 128, 12, 129, 140, 130, 139, 130, 131, 128, 130, 129, 130,
	131, 129, 132, 128, 134, 130, 132, 131, 132, 140, 130, 142, 128, 140, 130, 13, 131, 140, 131, 130,
	133, 129, 132, 11, 135, 140, 137, 141, 138, 142, 139, 141, 141, 140, 142, 140, 140, 139, 140, 131,
	141, 130, 142, 130, 140, 128, 138, 130, 138, 139, 136, 140, 135, 140, 137, 13, 139, 140, 139, 130,
	140, 129, 135, 18, 130, 145, 135, 147, 138, 146, 142, 148, 138, 145, 135, 146, 147, 0, 0, 0, 128, 18,
	130, 148, 132, 149, 134, 149, 136, 148, 138, 145, 143, 134, 145, 131, 146, 130, 134, 20, 136, 146,
	143, 132, 146, 129, 130, 20, 132, 148, 134, 147, 136, 144, 141, 133, 143, 130, 144, 129, 146, 128,
	146, 146, 143, 19, 145, 146, 147, 146, 149, 147, 150, 149, 149, 148, 147, 148, 145, 149, 143, 147,
	144, 20, 146, 147, 148, 147, 132, 12, 130, 140, 129, 139, 129, 137, 130, 138, 132, 138, 130, 11,
	132, 139, 128, 0, 130, 130, 132, 131, 135, 131, 137, 130, 135, 128, 134, 129, 131, 129, 128, 128,
	131, 2, 134, 130, 136, 129, 132, 20, 132, 131, 139, 15, 140, 142, 142, 141, 144, 141, 146, 142, 132,
	7, 134, 136, 138, 136, 140, 135, 138, 27, 131, 153, 138, 156, 143, 152, 148, 155, 143, 151, 138,
	155, 151, 0, 0, 0, 133, 16, 131, 142, 130, 140, 130, 138, 131, 136, 133, 135, 135, 137, 138, 138,
	130, 12, 131, 138, 132, 137, 134, 136, 131, 14, 131, 140, 132, 138, 134, 137, 135, 137, 131, 18,
	133, 146, 136, 147, 138, 148, 139, 149, 141, 147, 140, 146, 140, 138, 141, 137, 142, 137, 140, 135,
	138, 137, 138, 146, 135, 147, 133, 148, 132, 149, 130, 147, 135, 142, 132, 20, 131, 147, 134, 147,
	137, 19, 140, 147, 139, 148, 139, 137, 140, 136, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129,
	149, 0, 0, 0, 136, 10, 135, 139, 133, 140, 133, 147, 131, 147, 131, 140, 129, 139, 131, 139, 133,
	138, 134, 137, 136, 138, 139, 139, 141, 139, 133, 19, 136, 148, 138, 149, 139, 148, 141, 147, 143,
	147, 141, 146, 141, 140, 137, 20, 140, 146, 140, 140, 136, 20, 137, 147, 139, 146, 139, 140, 132,
	18, 132, 140, 135, 138, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 148, 0, 0, 0, 135, 0, 137,
	129, 138, 131, 138, 133, 140, 132, 139, 130, 138, 129, 135, 128, 133, 128, 130, 129, 129, 130, 128,
	132, 128, 134, 129, 136, 131, 138, 133, 139, 135, 139, 134, 142, 133, 139, 131, 137, 130, 135, 130,
	131, 131, 129, 133, 128, 139, 4, 138, 130, 130, 2, 129, 131, 129, 135, 130, 136, 134, 11, 134, 142,
	134, 18, 136, 148, 134, 149, 132, 148, 134, 146, 134, 19, 135, 148, 133, 148, 134, 147, 143, 0, 0, 0,
	138, 5, 138, 131, 131, 131, 131, 128, 128, 128, 128, 134, 138, 134, 138, 133, 142, 0, 0, 0, 128, 5,
	128, 131, 135, 131, 135, 128, 138, 128, 138, 134, 128, 134, 128, 133, 142, 0, 0, 0, 149, 21, 147,
	149, 128, 128, 130, 128, 149, 149, 133, 12, 133, 147, 132, 149, 129, 147, 130, 146, 131, 144, 131,
	140, 129, 139, 130, 139, 132, 138, 133, 137, 134, 138, 136, 139, 135, 139, 133, 140, 131, 18, 130,
	147, 131, 148, 132, 146, 132, 139, 134, 138, 142, 1, 145, 129, 147, 128, 149, 130, 146, 131, 144,
	131, 141, 130, 139, 128, 142, 129, 141, 1, 143, 130, 146, 130, 148, 129, 139, 0, 139, 131, 140, 133,
	144, 135, 148, 135, 148, 139, 146, 139, 146, 135, 147, 10, 147, 136, 146, 11, 144, 140, 142, 139,
	141, 138, 140, 138, 142, 137, 143, 137, 145, 139, 144, 11, 142, 138, 148, 21, 129, 128, 154, 0, 0, 0,
	149, 21, 147, 149, 128, 128, 130, 128, 149, 149, 133, 12, 133, 147, 132, 149, 129, 147, 130, 146,
	131, 144, 131, 140, 129, 139, 130, 139, 132, 138, 133, 137, 134, 138, 136, 139, 135, 139, 133, 140,
	131, 18, 130, 147, 131, 148, 132, 146, 132, 139, 134, 138, 148, 21, 129, 128, 144, 11, 144, 130,
	142, 129, 144, 129, 146, 128, 147, 128, 145, 129, 145, 139, 146, 138, 145, 136, 146, 0, 148, 129,
	146, 130, 146, 136, 147, 138, 145, 140, 138, 133, 138, 132, 148, 132, 149, 133, 149, 131, 148, 132,
	140, 7, 140, 132, 139, 6, 139, 132, 154, 0, 0, 0, 131, 14, 132, 131, 134, 130, 132, 129, 131, 128,
	130, 129, 128, 130, 130, 131, 131, 142, 131, 131, 132, 130, 131, 129, 130, 130, 131, 131, 131, 18,
	129, 148, 131, 149, 133, 148, 131, 146, 131, 19, 130, 148, 132, 148, 131, 147, 137, 0, 0, 0, 135, 4,
	128, 138, 135, 145, 141, 17, 134, 138, 141, 132, 146, 0, 0, 0, 134, 4, 141, 138, 134, 145, 128, 17,
	135, 138, 128, 132, 146, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128, 144, 128, 146, 129, 18, 129, 144,
	128, 12, 130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128,
	132, 128, 134, 129, 6, 129, 132, 128, 0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254,
	133, 21, 135, 149, 135, 147, 133, 147, 133, 149, 134, 21, 134, 147, 133, 15, 135, 143, 135, 141,
	133, 141, 133, 143, 134, 15, 134, 141, 133, 9, 135, 137, 135, 135, 133, 135, 133, 137, 134, 9, 134,
	135, 133, 3, 135, 131, 135, 129, 133, 129, 133, 131, 134, 3, 134, 129, 138, 18, 140, 146, 140, 144,
	138, 144, 138, 146, 139, 18, 139, 144, 138, 12, 140, 140, 140, 138, 138, 138, 138, 140, 139, 12,
	139, 138, 138, 6, 140, 134, 140, 132, 138, 132, 138, 134, 139, 6, 139, 132, 138, 0, 140, 128, 140,
	254, 138, 254, 138, 128, 139, 0, 139, 254, 143, 21, 145, 149, 145, 147, 143, 147, 143, 149, 144, 21,
	144, 147, 143, 15, 145, 143, 145, 141, 143, 141, 143, 143, 144, 15, 144, 141, 143, 9, 145, 137, 145,
	135, 143, 135, 143, 137, 144, 9, 144, 135, 143, 3, 145, 131, 145, 129, 143, 129, 143, 131, 144, 3,
	144, 129, 133, 126, 133, 252, 135, 252, 135, 254, 133, 254, 134, 126, 134, 252, 143, 126, 143, 252,
	145, 252, 145, 254, 143, 254, 144, 126, 144, 252, 145, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128,
	144, 128, 146, 129, 18, 129, 144, 128, 12, 130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129,
	138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129, 132, 128, 0, 130, 128, 130, 254,
	128, 254, 128, 128, 129, 0, 129, 254, 130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131,
	147, 130, 15, 132, 143, 132, 141, 130, 141, 130, 143, 131, 15, 131, 141, 130, 9, 132, 137, 132, 135,
	130, 135, 130, 137, 131, 9, 131, 135, 130, 3, 132, 131, 132, 129, 130, 129, 130, 131, 131, 3, 131,
	129, 132, 18, 134, 146, 134, 144, 132, 144, 132, 146, 133, 18, 133, 144, 132, 12, 134, 140, 134,
	138, 132, 138, 132, 140, 133, 12, 133, 138, 132, 6, 134, 134, 134, 132, 132, 132, 132, 134, 133, 6,
	133, 132, 132, 0, 134, 128, 134, 254, 132, 254, 132, 128, 133, 0, 133, 254, 134, 21, 136, 149, 136,
	147, 134, 147, 134, 149, 135, 21, 135, 147, 134, 15, 136, 143, 136, 141, 134, 141, 134, 143, 135,
	15, 135, 141, 134, 9, 136, 137, 136, 135, 134, 135, 134, 137, 135, 9, 135, 135, 134, 3, 136, 131,
	136, 129, 134, 129, 134, 131, 135, 3, 135, 129, 136, 18, 138, 146, 138, 144, 136, 144, 136, 146,
	137, 18, 137, 144, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138, 136, 6, 138,
	134, 138, 132, 136, 132, 136, 134, 137, 6, 137, 132, 136, 0, 138, 128, 138, 254, 136, 254, 136, 128,
	137, 0, 137, 254, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139, 147, 138, 15, 140,
	143, 140, 141, 138, 141, 138, 143, 139, 15, 139, 141, 138, 9, 140, 137, 140, 135, 138, 135, 138,
	137, 139, 9, 139, 135, 138, 3, 140, 131, 140, 129, 138, 129, 138, 131, 139, 3, 139, 129, 140, 18,
	142, 146, 142, 144, 140, 144, 140, 146, 141, 18, 141, 144, 140, 12, 142, 140, 142, 138, 140, 138,
	140, 140, 141, 12, 141, 138, 140, 6, 142, 134, 142, 132, 140, 132, 140, 134, 141, 6, 141, 132, 140,
	0, 142, 128, 142, 254, 140, 254, 140, 128, 141, 0, 141, 254, 142, 21, 144, 149, 144, 147, 142,
	147, 142, 149, 143, 21, 143, 147, 142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 143, 15, 143,
	141, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143, 135, 142, 3, 144, 131, 144, 129,
	142, 129, 142, 131, 143, 3, 143, 129, 130, 125, 130, 251, 132, 251, 132, 253, 130, 253, 131, 125,
	131, 251, 134, 125, 134, 251, 136, 251, 136, 253, 134, 253, 135, 125, 135, 251, 138, 125, 138, 251,
	140, 251, 140, 253, 138, 253, 139, 125, 139, 251, 142, 125, 142, 251, 144, 251, 144, 253, 142, 253,
	143, 125, 143, 251, 144, 0, 0, 0, 128, 21, 130, 149, 130, 147, 128, 147, 128, 149, 129, 21, 129, 147,
	130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131, 147, 138, 21, 140, 149, 140, 147,
	138, 147, 138, 149, 139, 21, 139, 147, 140, 19, 140, 149, 142, 149, 142, 147, 140, 147, 141, 21,
	141, 147, 148, 21, 150, 149, 150, 147, 148, 147, 148, 149, 149, 21, 149, 147, 150, 21, 152, 149,
	152, 147, 150, 147, 150, 149, 151, 21, 151, 147, 152, 19, 152, 149, 132, 17, 134, 145, 134, 143,
	132, 143, 132, 145, 133, 17, 133, 143, 134, 17, 136, 145, 136, 143, 134, 143, 134, 145, 135, 17,
	135, 143, 136, 17, 138, 145, 138, 143, 136, 143, 136, 145, 137, 17, 137, 143, 146, 17, 148, 145,
	148, 143, 146, 143, 146, 145, 147, 17, 147, 143, 148, 17, 150, 145, 150, 143, 148, 143, 148, 145,
	149, 17, 149, 143, 150, 17, 152, 145, 152, 143, 150, 143, 150, 145, 151, 17, 151, 143, 130, 13, 132,
	141, 132, 139, 128, 139, 128, 141, 130, 141, 130, 139, 129, 13, 129, 139, 131, 13, 131, 139, 138,
	13, 140, 141, 140, 139, 138, 139, 138, 141, 139, 13, 139, 139, 142, 13, 142, 139, 140, 139, 140,
	141, 142, 141, 141, 13, 141, 139, 148, 13, 150, 141, 150, 139, 148, 139, 148, 141, 149, 13, 149,
	139, 150, 13, 152, 141, 152, 139, 150, 139, 150, 141, 151, 13, 151, 139, 152, 11, 152, 141, 130, 9,
	130, 135, 128, 135, 128, 137, 132, 137, 132, 135, 130, 135, 131, 9, 131, 135, 142, 9, 144, 137, 144,
	135, 142, 135, 142, 137, 143, 9, 143, 135, 144, 9, 146, 137, 146, 135, 144, 135, 144, 137, 145, 9,
	145, 135, 146, 9, 148, 137, 148, 135, 146, 135, 146, 137, 147, 9, 147, 135, 129, 9, 129, 135, 132, 9,
	134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133, 135, 130, 5, 132, 133, 132, 131, 130, 131, 130,
	133, 128, 133, 128, 131, 130, 131, 129, 5, 129, 131, 131, 5, 131, 131, 138, 5, 140, 133, 140, 131,
	138, 131, 138, 133, 139, 5, 139, 131, 140, 5, 142, 133, 142, 131, 140, 131, 140, 133, 141, 5, 141,
	131, 148, 5, 150, 133, 150, 131, 148, 131, 148, 133, 149, 5, 149, 131, 150, 5, 152, 133, 152, 131,
	150, 131, 150, 133, 151, 5, 151, 131, 152, 3, 152, 133, 132, 1, 138, 129, 138, 255, 132, 255, 132,
	129, 133, 1, 133, 255, 135, 1, 135, 255, 137, 1, 137, 255, 146, 1, 152, 129, 152, 255, 146, 255, 146,
	129, 147, 1, 147, 255, 149, 1, 149, 255, 151, 1, 151, 255, 134, 1, 134, 255, 136, 1, 136, 255, 148, 1,
	148, 255, 150, 1, 150, 255, 128, 125, 130, 253, 130, 251, 128, 251, 128, 253, 129, 125, 129, 251,
	130, 125, 132, 253, 132, 251, 130, 251, 130, 253, 131, 125, 131, 251, 138, 125, 140, 253, 140, 251,
	138, 251, 138, 253, 139, 125, 139, 251, 140, 125, 142, 253, 142, 251, 140, 251, 140, 253, 141, 125,
	141, 251, 148, 125, 150, 253, 150, 251, 148, 251, 148, 253, 149, 125, 149, 251, 150, 125, 152, 253,
	152, 251, 150, 251, 150, 253, 151, 125, 151, 251, 152, 0, 0, 0, 128, 21, 128, 249, 132, 0, 0, 0, 136,
	21, 136, 249, 128, 4, 136, 132, 140, 0, 0, 0, 136, 121, 136, 149, 128, 10, 136, 138, 128, 4, 136,
	132, 140, 0, 0, 0, 136, 21, 136, 249, 128, 4, 136, 132, 146, 21, 146, 249, 149, 0, 0, 0, 128, 4, 146,
	132, 146, 249, 136, 4, 136, 249, 149, 0, 0, 0, 128, 10, 136, 138, 136, 249, 128, 4, 136, 132, 139, 0,
	0, 0, 128, 4, 136, 132, 136, 249, 146, 21, 146, 249, 136, 21, 136, 138, 128, 138, 149, 0, 0, 0, 136,
	21, 136, 249, 146, 21, 146, 249, 149, 0, 0, 0, 128, 10, 146, 138, 146, 249, 128, 4, 136, 132, 136,
	249, 149, 0, 0, 0, 128, 4, 146, 132, 146, 149, 128, 10, 136, 138, 136, 149, 149, 0, 0, 0, 128, 10, 146,
	138, 146, 149, 136, 10, 136, 149, 149, 0, 0, 0, 128, 4, 136, 132, 136, 149, 128, 10, 136, 138, 139, 0,
	0, 0, 128, 4, 136, 132, 136, 249, 139, 0, 0, 0, 136, 10, 128, 138, 128, 149, 136, 0, 0, 0, 136, 21,
	136, 138, 128, 138, 144, 10, 136, 138, 144, 0, 0, 0, 136, 121, 136, 132, 128, 132, 144, 4, 136, 132,
	144, 0, 0, 0, 128, 21, 128, 249, 136, 4, 128, 132, 136, 0, 0, 0, 128, 4, 144, 132, 144, 0, 0, 0, 136, 21,
	136, 249, 128, 4, 144, 132, 144, 0, 0, 0, 128, 121, 128, 149, 136, 10, 128, 138, 136, 4, 128, 132,
	136, 0, 0, 0, 138, 21, 138, 249, 146, 4, 138, 132, 128, 21, 128, 249, 146, 0, 0, 0, 146, 4, 128, 132,
	128, 149, 146, 10, 138, 138, 138, 149, 146, 0, 0, 0, 146, 10, 128, 138, 128, 249, 146, 4, 138, 132,
	138, 249, 146, 0, 0, 0, 136, 21, 136, 138, 128, 138, 146, 21, 146, 138, 154, 138, 128, 4, 154, 132,
	154, 0, 0, 0, 136, 121, 136, 132, 128, 132, 146, 121, 146, 132, 154, 132, 128, 10, 154, 138, 154, 0,
	0, 0, 146, 4, 138, 132, 138, 249, 128, 21, 128, 249, 138, 21, 138, 138, 146, 138, 146, 0, 0, 0, 128,
	10, 154, 138, 128, 4, 154, 132, 154, 0, 0, 0, 128, 4, 136, 132, 136, 249, 136, 21, 136, 138, 128,
	138, 146, 21, 146, 138, 154, 138, 146, 121, 146, 132, 154, 132, 154, 0, 0, 0, 136, 21, 136, 138, 128,
	138, 144, 10, 136, 138, 128, 4, 144, 132, 144, 0, 0, 0, 128, 10, 146, 138, 134, 10, 134, 149, 144, 21,
	144, 138, 146, 0, 0, 0, 136, 121, 136, 132, 128, 132, 144, 4, 136, 132, 128, 10, 144, 138, 144, 0, 0,
	0, 128, 4, 146, 132, 134, 4, 134, 249, 144, 121, 144, 132, 146, 0, 0, 0, 146, 10, 128, 138, 128,
	149, 138, 10, 138, 149, 146, 0, 0, 0, 136, 4, 128, 132, 128, 149, 136, 10, 128, 138, 136, 0, 0, 0, 136,
	10, 128, 138, 128, 249, 136, 4, 128, 132, 136, 0, 0, 0, 146, 4, 128, 132, 128, 249, 138, 4, 138, 249,
	146, 0, 0, 0, 136, 21, 136, 249, 128, 4, 154, 132, 146, 21, 146, 249, 154, 0, 0, 0, 136, 121, 136, 149,
	128, 10, 144, 138, 128, 4, 144, 132, 144, 0, 0, 0, 136, 21, 136, 132, 128, 132, 139, 0, 0, 0, 128, 121,
	128, 138, 136, 138, 136, 0, 0, 0, 128, 21, 150, 149, 150, 128, 128, 128, 128, 149, 129, 21, 129, 128,
	130, 21, 130, 128, 132, 21, 132, 128, 133, 21, 133, 128, 134, 21, 134, 128, 135, 0, 135, 149, 136,
	21, 136, 128, 137, 21, 137, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142, 0,
	142, 149, 143, 21, 143, 128, 144, 21, 144, 128, 146, 21, 146, 128, 147, 21, 147, 128, 148, 21, 148,
	128, 149, 21, 149, 128, 131, 21, 131, 128, 138, 21, 138, 128, 145, 21, 145, 128, 128, 11, 150, 139,
	150, 0, 0, 0, 150, 0, 128, 128, 128, 139, 150, 139, 150, 128, 129, 11, 129, 128, 130, 11, 130, 128,
	131, 11, 131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134, 11, 134, 128, 135, 11, 135, 128, 136,
	0, 136, 139, 137, 11, 137, 128, 138, 11, 138, 128, 139, 11, 139, 128, 140, 11, 140, 128, 141, 11,
	141, 128, 142, 11, 142, 128, 143, 11, 143, 128, 144, 0, 144, 139, 145, 11, 145, 128, 146, 11, 146,
	128, 147, 11, 147, 128, 148, 11, 148, 128, 149, 11, 149, 128, 150, 0, 0, 0, 128, 0, 128, 149, 139,
	149, 139, 128, 128, 128, 129, 21, 129, 128, 130, 21, 130, 128, 132, 21, 132, 128, 133, 21, 133, 128,
	134, 21, 134, 128, 135, 0, 135, 149, 136, 21, 136, 128, 137, 21, 137, 128, 131, 21, 131, 128, 138,
	21, 138, 128, 139, 0, 0, 0, 139, 0, 139, 149, 150, 149, 150, 128, 139, 128, 140, 21, 140, 128, 141,
	21, 141, 128, 143, 21, 143, 128, 144, 21, 144, 128, 145, 21, 145, 128, 146, 0, 146, 149, 147, 21,
	147, 128, 148, 21, 148, 128, 142, 21, 142, 128, 149, 21, 149, 128, 150, 0, 0, 0, 150, 10, 128, 138,
	128, 149, 150, 149, 150, 138, 129, 21, 129, 138, 130, 21, 130, 138, 131, 21, 131, 138, 132, 21, 132,
	138, 133, 21, 133, 138, 134, 21, 134, 138, 135, 21, 135, 138, 136, 10, 136, 149, 137, 21, 137, 138,
	138, 21, 138, 138, 139, 21, 139, 138, 140, 21, 140, 138, 141, 21, 141, 138, 142, 21, 142, 138, 143,
	21, 143, 138, 144, 10, 144, 149, 145, 21, 145, 138, 146, 21, 146, 138, 147, 21, 147, 138, 148, 21,
	148, 138, 149, 21, 149, 138, 150, 0, 0, 0, 134, 12, 135, 141, 133, 142, 132, 141, 130, 140, 128, 140,
	130, 139, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 134, 130, 132, 131, 132, 139,
	134, 140, 137, 141, 140, 140, 145, 130, 147, 131, 149, 130, 150, 128, 149, 129, 147, 129, 146, 128,
	145, 130, 134, 13, 131, 139, 131, 131, 134, 129, 134, 2, 137, 129, 140, 130, 146, 142, 147, 141,
	149, 141, 150, 142, 149, 140, 147, 139, 145, 140, 148, 2, 147, 130, 146, 129, 148, 12, 147, 140,
	146, 141, 154, 0, 0, 0, 131, 0, 131, 142, 128, 140, 129, 138, 129, 252, 131, 251, 132, 250, 134, 251,
	133, 252, 131, 253, 131, 128, 130, 10, 130, 141, 129, 140, 130, 138, 130, 253, 133, 251, 131, 12,
	134, 142, 136, 143, 138, 142, 138, 137, 138, 2, 136, 129, 134, 130, 135, 130, 137, 131, 137, 135,
	134, 136, 133, 136, 134, 14, 135, 142, 137, 141, 137, 137, 139, 137, 139, 141, 141, 142, 140, 142,
	138, 143, 137, 144, 136, 143, 137, 7, 139, 135, 139, 131, 141, 130, 140, 130, 138, 129, 137, 128,
	136, 129, 138, 7, 138, 131, 134, 2, 131, 130, 134, 8, 137, 137, 145, 0, 0, 0, 133, 13, 132, 143, 131,
	144, 129, 145, 130, 144, 131, 142, 131, 134, 128, 132, 131, 133, 131, 128, 133, 130, 133, 141, 131,
	15, 132, 141, 132, 129, 131, 11, 129, 139, 128, 138, 128, 136, 129, 137, 131, 137, 131, 139, 131,
	10, 129, 138, 141, 19, 135, 145, 134, 145, 132, 146, 131, 147, 132, 145, 134, 144, 136, 144, 142,
	145, 145, 145, 147, 144, 145, 146, 143, 147, 141, 147, 137, 17, 141, 146, 144, 146, 150, 0, 0, 0,
	137, 14, 135, 141, 132, 140, 132, 131, 130, 130, 132, 130, 134, 129, 135, 128, 137, 129, 136, 130,
	134, 131, 134, 140, 137, 142, 133, 12, 133, 131, 136, 129, 148, 14, 146, 141, 143, 140, 143, 131,
	141, 130, 143, 130, 145, 129, 146, 128, 148, 129, 147, 130, 145, 131, 145, 140, 148, 142, 136, 13,
	140, 140, 144, 140, 144, 131, 147, 129, 143, 11, 140, 139, 134, 141, 131, 141, 129, 140, 128, 139,
	129, 141, 131, 142, 135, 142, 141, 141, 145, 141, 147, 142, 145, 140, 143, 139, 142, 139, 152, 0, 0,
	0, 128, 3, 131, 129, 135, 128, 140, 128, 144, 129, 142, 131, 139, 130, 132, 130, 128, 131, 130,
	135, 132, 137, 134, 138, 135, 138, 132, 140, 131, 142, 130, 145, 135, 10, 132, 136, 131, 134, 130,
	131, 130, 2, 133, 129, 140, 129, 143, 130, 128, 18, 131, 148, 135, 149, 140, 149, 144, 148, 142,
	146, 139, 147, 132, 147, 128, 146, 129, 143, 130, 141, 132, 139, 134, 138, 130, 19, 133, 148, 140,
	148, 143, 147, 129, 17, 130, 142, 129, 3, 130, 134, 148, 0, 0, 0, 132, 8, 135, 137, 137, 138, 138,
	137, 140, 136, 142, 136, 140, 135, 140, 130, 138, 130, 135, 129, 134, 130, 132, 131, 132, 136, 130,
	136, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 131, 7, 131, 131, 134, 129, 138, 2,
	138, 135, 136, 136, 135, 137, 139, 3, 139, 135, 136, 137, 135, 11, 139, 140, 148, 140, 150, 139,
	152, 141, 150, 142, 142, 142, 139, 141, 135, 139, 130, 136, 140, 13, 149, 141, 151, 140, 155, 0, 0,
	0, 135, 2, 134, 130, 132, 131, 132, 140, 130, 142, 128, 140, 129, 140, 130, 139, 130, 131, 128,
	130, 129, 130, 131, 129, 132, 128, 133, 129, 135, 130, 138, 131, 129, 13, 131, 140, 131, 130, 133,
	129, 138, 14, 139, 141, 141, 140, 142, 140, 140, 139, 140, 131, 141, 130, 142, 130, 140, 128, 138,
	130, 138, 139, 136, 140, 138, 142, 137, 13, 139, 140, 139, 130, 140, 129, 133, 120, 133, 247, 132,
	247, 133, 248, 133, 249, 131, 253, 131, 129, 130, 1, 130, 253, 132, 251, 132, 0, 132, 253, 133, 249,
	131, 3, 131, 130, 146, 0, 0, 0, 145, 7, 148, 141, 150, 142, 152, 142, 153, 141, 152, 141, 150, 140,
	146, 135, 142, 135, 142, 255, 143, 254, 144, 254, 142, 252, 140, 254, 140, 135, 138, 136, 137, 136,
	139, 137, 140, 138, 141, 137, 143, 136, 144, 136, 142, 135, 130, 7, 129, 137, 129, 139, 130, 140,
	132, 141, 137, 141, 138, 140, 139, 138, 140, 138, 132, 13, 129, 140, 128, 139, 128, 137, 131, 133,
	130, 136, 130, 138, 131, 139, 133, 140, 137, 140, 138, 138, 139, 137, 141, 136, 141, 254, 142, 253,
	146, 8, 148, 139, 150, 141, 151, 141, 156, 0, 0, 0, 133, 10, 136, 139, 138, 140, 139, 139, 141, 138,
	143, 138, 141, 137, 141, 132, 139, 132, 136, 131, 135, 132, 133, 133, 133, 138, 131, 138, 131, 133,
	129, 132, 131, 132, 133, 131, 134, 130, 136, 131, 136, 252, 132, 9, 132, 133, 135, 131, 139, 4, 139,
	137, 137, 138, 136, 139, 136, 147, 140, 5, 140, 137, 137, 139, 144, 20, 144, 147, 128, 147, 128,
	148, 144, 148, 144, 124, 144, 251, 128, 251, 128, 252, 144, 252, 147, 0, 0, 0, 134, 1, 132, 131, 131,
	133, 130, 136, 130, 142, 131, 145, 132, 147, 134, 149, 132, 148, 130, 146, 129, 144, 128, 141, 128,
	137, 129, 134, 130, 132, 132, 130, 136, 128, 140, 128, 144, 130, 146, 132, 147, 134, 148, 137, 148,
	141, 147, 144, 146, 146, 144, 148, 142, 149, 138, 149, 138, 148, 141, 148, 143, 147, 145, 144, 146,
	142, 146, 136, 145, 133, 144, 131, 142, 129, 130, 17, 129, 142, 129, 136, 130, 133, 146, 5, 147,
	136, 147, 142, 145, 146, 144, 147, 133, 12, 130, 140, 132, 139, 136, 138, 140, 138, 144, 139, 148,
	141, 143, 140, 133, 140, 137, 139, 141, 139, 145, 140, 152, 0, 0, 0, 134, 20, 132, 146, 131, 144,
	130, 141, 130, 140, 131, 137, 132, 135, 134, 133, 132, 134, 130, 136, 128, 140, 129, 143, 130, 145,
	132, 147, 136, 149, 140, 149, 144, 147, 146, 145, 147, 143, 148, 140, 146, 136, 144, 134, 142, 133,
	141, 134, 143, 135, 145, 138, 146, 140, 146, 141, 145, 144, 144, 146, 142, 148, 140, 149, 130, 9,
	129, 140, 129, 141, 130, 144, 146, 16, 147, 141, 147, 140, 145, 136, 144, 135, 140, 2, 143, 130,
	145, 129, 147, 130, 145, 128, 142, 128, 140, 129, 140, 130, 141, 1, 144, 129, 141, 6, 141, 130, 142,
	5, 142, 130, 135, 2, 132, 130, 130, 129, 128, 130, 130, 128, 133, 128, 135, 129, 135, 130, 134, 1,
	131, 129, 132, 7, 134, 134, 134, 130, 133, 6, 133, 130, 152, 0, 0, 0, 132, 8, 135, 137, 137, 138, 138,
	137, 140, 136, 142, 136, 140, 135, 140, 130, 138, 130, 135, 129, 134, 130, 132, 131, 132, 136, 130,
	136, 130, 131, 128, 130, 130, 130, 132, 129, 133, 128, 135, 129, 131, 7, 131, 131, 134, 129, 138, 2,
	138, 135, 136, 136, 135, 137, 128, 146, 132, 147, 141, 147, 143, 146, 145, 148, 143, 149, 135, 149,
	132, 148, 128, 146, 137, 138, 139, 3, 139, 135, 136, 137, 129, 145, 133, 20, 142, 148, 144, 147,
	140, 7, 137, 137, 128, 146, 149, 0, 0, 0, 132, 8, 135, 137, 138, 137, 140, 136, 142, 136, 140, 135,
	140, 130, 138, 130, 135, 129, 134, 130, 132, 131, 132, 136, 130, 136, 130, 131, 128, 130, 130, 130,
	132, 129, 133, 128, 135, 129, 131, 7, 131, 131, 134, 129, 138, 2, 138, 135, 136, 136, 135, 137, 144,
	1, 147, 130, 149, 130, 149, 135, 151, 136, 149, 136, 147, 137, 144, 137, 141, 136, 141, 131, 143,
	130, 144, 129, 142, 128, 141, 129, 139, 130, 137, 130, 139, 131, 139, 135, 136, 137, 141, 8, 139,
	136, 139, 131, 140, 7, 140, 131, 143, 129, 147, 2, 147, 135, 145, 136, 144, 137, 148, 3, 148, 135,
	145, 137, 155, 0, 0, 0, 135, 1, 134, 130, 132, 131, 132, 140, 130, 140, 130, 131, 128, 130, 130, 130,
	132, 129, 133, 128, 135, 129, 138, 130, 140, 130, 140, 139, 142, 140, 140, 140, 138, 141, 137, 142,
	135, 141, 136, 140, 138, 139, 138, 130, 131, 11, 131, 131, 134, 129, 132, 12, 135, 141, 136, 13,
	139, 139, 139, 131, 131, 126, 141, 144, 142, 144, 132, 254, 131, 254, 146, 0, 0, 0, 129, 17, 130,
	146, 132, 147, 134, 147, 136, 146, 138, 148, 135, 149, 133, 149, 131, 148, 130, 147, 129, 145, 128,
	142, 128, 135, 129, 132, 130, 130, 131, 129, 133, 128, 135, 128, 138, 129, 136, 131, 134, 130, 132,
	130, 130, 131, 129, 132, 131, 2, 133, 129, 135, 129, 137, 130, 131, 19, 133, 148, 135, 148, 137,
	147, 129, 11, 130, 138, 132, 138, 133, 139, 135, 137, 133, 136, 131, 136, 130, 137, 129, 139, 128,
	142, 131, 9, 133, 137, 134, 138, 142, 0, 0, 0, 148, 2, 146, 128, 144, 128, 141, 129, 139, 128, 141,
	130, 143, 130, 146, 129, 148, 130, 145, 1, 142, 129, 145, 4, 146, 134, 147, 137, 147, 141, 146, 144,
	145, 146, 143, 148, 140, 149, 137, 149, 134, 148, 132, 147, 130, 149, 128, 147, 129, 147, 130, 145,
	130, 131, 128, 130, 130, 129, 131, 128, 133, 130, 132, 131, 132, 146, 135, 147, 139, 147, 142, 146,
	144, 144, 145, 142, 146, 139, 146, 136, 144, 130, 145, 132, 146, 13, 145, 144, 142, 147, 139, 148,
	136, 148, 131, 3, 130, 130, 131, 129, 132, 130, 131, 131, 131, 146, 129, 148, 152, 0, 0, 0, 128, 8,
	145, 136, 145, 135, 128, 135, 128, 136, 128, 4, 145, 132, 145, 131, 128, 131, 128, 132, 128, 12,
	145, 140, 145, 139, 128, 139, 128, 140, 149, 0, 0, 0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129,
	136, 21, 136, 132, 137, 132, 137, 149, 136, 149, 128, 13, 145, 141, 145, 140, 128, 140, 128, 141,
	149, 0, 0, 0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 128, 21, 144, 140, 128, 131, 149, 0, 0,
	0, 145, 1, 128, 129, 128, 128, 145, 128, 145, 129, 145, 21, 129, 140, 145, 131, 149, 0, 0, 0, 133,
	21, 131, 148, 130, 147, 129, 144, 129, 249, 128, 249, 128, 145, 129, 147, 130, 148, 132, 149, 135,
	149, 137, 148, 138, 146, 138, 145, 137, 145, 137, 146, 136, 148, 134, 149, 142, 0, 0, 0, 133, 121,
	135, 250, 136, 251, 137, 254, 137, 149, 138, 149, 138, 253, 137, 251, 136, 250, 134, 249, 131, 249,
	129, 250, 128, 252, 128, 253, 129, 253, 129, 252, 130, 250, 132, 249, 142, 0, 0, 0, 128, 10, 145,
	138, 145, 137, 128, 137, 128, 138, 136, 21, 134, 147, 136, 146, 138, 147, 136, 149, 136, 20, 135,
	147, 137, 147, 136, 148, 136, 3, 134, 129, 136, 128, 138, 129, 136, 131, 136, 2, 135, 129, 137, 129,
	136, 130, 149, 0, 0, 0, 138, 12, 135, 142, 128, 141, 135, 144, 140, 140, 145, 143, 140, 139, 135,
	142, 138, 7, 135, 137, 128, 136, 135, 139, 140, 135, 145, 138, 140, 134, 135, 137, 149, 0, 0, 0, 132,
	19, 135, 148, 137, 149, 138, 148, 140, 147, 142, 147, 140, 146, 140, 141, 138, 141, 135, 140, 134,
	141, 132, 142, 132, 147, 130, 147, 130, 142, 128, 141, 130, 141, 132, 140, 133, 139, 135, 140, 131,
	18, 131, 142, 134, 140, 138, 13, 138, 146, 136, 147, 135, 148, 139, 14, 139, 146, 136, 148, 145, 0,
	0, 0, 128, 0, 131, 128, 131, 132, 128, 132, 128, 128, 129, 4, 129, 128, 130, 4, 130, 128, 128, 2,
	131, 130, 134, 0, 0, 0, 128, 0, 131, 128, 131, 130, 128, 130, 128, 128, 130, 2, 130, 128, 129, 2, 129,
	128, 134, 0, 0, 0, 128, 11, 139, 128, 139, 149, 151, 149, 154, 0, 0, 0, 132, 11, 132, 147, 130, 149,
	128, 147, 129, 147, 130, 146, 130, 139, 132, 139, 130, 20, 131, 147, 131, 139, 132, 18, 135, 147,
	137, 148, 138, 149, 139, 148, 141, 147, 142, 147, 140, 146, 140, 139, 138, 139, 138, 146, 136, 147,
	135, 147, 137, 20, 139, 147, 139, 139, 130, 12, 131, 140, 146, 0, 0, 0, 134, 9, 136, 138, 139, 138,
	143, 137, 141, 135, 138, 136, 135, 136, 131, 135, 134, 137, 139, 137, 142, 136, 131, 7, 131, 138,
	132, 140, 136, 142, 143, 142, 143, 146, 141, 146, 141, 142, 142, 18, 142, 142, 141, 18, 138, 148,
	137, 147, 135, 146, 134, 146, 133, 147, 132, 149, 134, 148, 135, 148, 136, 149, 138, 148, 132, 21,
	134, 147, 135, 147, 137, 148, 136, 148, 146, 0, 0, 0, 128, 0, 128, 139, 139, 139, 139, 128, 128, 128,
	129, 11, 129, 128, 130, 11, 130, 128, 131, 11, 131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134,
	11, 134, 128, 135, 11, 135, 128, 136, 0, 136, 139, 137, 11, 137, 128, 138, 11, 138, 128, 142, 0, 0,
	0
};
static const unsigned char Script[10987] = /* binary data included from SCRI.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 83,
	67, 82, 73, 107, 42, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 25, 0, 244, 0, 0, 0, 0, 0, 0, 0, 4, 0, 30, 0, 50, 0, 70, 0, 148, 0, 210, 0, 62,
	1, 80, 1, 120, 1, 160, 1, 176, 1, 188, 1, 206, 1, 214, 1, 228, 1, 236, 1, 18, 2, 32, 2, 64, 2, 98, 2,
	110, 2, 148, 2, 198, 2, 208, 2, 14, 3, 64, 3, 88, 3, 116, 3, 126, 3, 138, 3, 148, 3, 214, 3, 66, 4, 108, 4,
	190, 4, 240, 4, 56, 5, 114, 5, 168, 5, 228, 5, 48, 6, 100, 6, 152, 6, 228, 6, 32, 7, 120, 7, 184, 7, 244,
	7, 52, 8, 118, 8, 196, 8, 254, 8, 48, 9, 114, 9, 180, 9, 226, 9, 42, 10, 118, 10, 200, 10, 220, 10,
	228, 10, 248, 10, 6, 11, 14, 11, 32, 11, 78, 11, 126, 11, 156, 11, 204, 11, 240, 11, 34, 12, 90, 12,
	148, 12, 180, 12, 220, 12, 28, 13, 66, 13, 130, 13, 176, 13, 224, 13, 14, 14, 68, 14, 100, 14, 132, 14,
	162, 14, 200, 14, 234, 14, 26, 15, 66, 15, 112, 15, 160, 15, 238, 15, 246, 15, 68, 16, 110, 16, 126,
	16, 220, 16, 30, 17, 80, 17, 136, 17, 210, 17, 14, 18, 80, 18, 142, 18, 188, 18, 252, 18, 46, 19, 96,
	19, 128, 19, 164, 19, 234, 19, 40, 20, 106, 20, 176, 20, 16, 21, 74, 21, 150, 21, 212, 21, 4, 22, 56,
	22, 130, 22, 218, 22, 56, 23, 108, 23, 188, 23, 252, 23, 82, 24, 134, 24, 194, 24, 230, 24, 36, 25,
	88, 25, 166, 25, 12, 26, 62, 26, 96, 26, 162, 26, 180, 26, 198, 26, 238, 26, 12, 27, 38, 27, 54, 27,
	70, 27, 70, 28, 66, 30, 100, 32, 108, 32, 120, 32, 136, 32, 152, 32, 166, 32, 180, 32, 200, 32, 212,
	32, 228, 32, 244, 32, 2, 33, 16, 33, 26, 33, 36, 33, 50, 33, 64, 33, 76, 33, 84, 33, 96, 33, 112, 33,
	128, 33, 144, 33, 160, 33, 180, 33, 200, 33, 220, 33, 232, 33, 4, 34, 22, 34, 38, 34, 56, 34, 72, 34,
	86, 34, 100, 34, 114, 34, 132, 34, 148, 34, 164, 34, 174, 34, 184, 34, 10, 35, 80, 35, 122, 35, 164,
	35, 234, 35, 12, 36, 40, 36, 52, 36, 68, 36, 86, 36, 126, 36, 170, 36, 190, 36, 240, 36, 34, 37, 82,
	37, 124, 37, 188, 37, 240, 37, 6, 38, 34, 38, 50, 38, 66, 38, 80, 38, 94, 38, 112, 38, 130, 38, 158,
	38, 242, 38, 20, 39, 46, 39, 68, 39, 82, 39, 128, 39, 152, 39, 21, 9, 13, 18, 19, 21, 24, 5, 12, 15, 12,
	22, 22, 22, 9, 24, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 9, 10, 20, 22, 20, 15, 24, 20, 20, 17, 24, 17,
	19, 23, 23, 16, 14, 23, 19, 31, 22, 18, 22, 22, 22, 20, 25, 22, 21, 26, 26, 21, 19, 7, 19, 8, 19, 17, 5,
	16, 14, 11, 16, 10, 13, 15, 15, 7, 15, 14, 8, 25, 18, 14, 15, 15, 13, 11, 9, 15, 15, 21, 16, 15, 14, 10,
	4, 9, 17, 16, 17, 15, 10, 17, 16, 16, 16, 11, 16, 10, 10, 7, 18, 12, 20, 20, 17, 23, 30, 16, 14, 14, 17,
	15, 15, 18, 22, 14, 23, 18, 26, 23, 16, 7, 14, 15, 18, 22, 21, 11, 15, 12, 12, 23, 23, 9, 19, 19, 14, 16,
	24, 3, 10, 10, 18, 18, 10, 18, 18, 18, 18, 18, 10, 0, 7, 14, 14, 7, 15, 14, 7, 15, 15, 15, 22, 22, 15, 22,
	22, 14, 15, 14, 15, 15, 7, 7, 15, 23, 14, 10, 7, 15, 15, 8, 17, 15, 15, 11, 9, 12, 15, 19, 25, 16, 12, 18,
	17, 12, 21, 14, 15, 17, 21, 21, 21, 22, 15, 15, 21, 17, 11, 6, 6, 22, 21, 11, 10, 149, 0, 0, 0, 131, 8,
	135, 148, 134, 149, 133, 148, 131, 136, 134, 148, 129, 2, 128, 129, 129, 128, 130, 129, 129, 130,
	137, 0, 0, 0, 130, 21, 128, 142, 131, 21, 128, 142, 139, 21, 137, 142, 140, 21, 137, 142, 141, 0, 0, 0,
	136, 21, 129, 249, 142, 21, 135, 249, 129, 10, 143, 138, 128, 4, 142, 132, 146, 0, 0, 0, 138, 25, 130,
	252, 143, 25, 135, 252, 144, 17, 143, 144, 144, 143, 145, 144, 145, 145, 144, 147, 143, 148, 140,
	149, 136, 149, 133, 148, 131, 146, 131, 144, 132, 142, 133, 141, 140, 137, 142, 135, 131, 16, 133,
	142, 140, 138, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130, 129, 129,
	130, 128, 132, 128, 133, 129, 134, 130, 133, 129, 132, 147, 0, 0, 0, 146, 21, 128, 128, 133, 21, 135,
	147, 135, 145, 134, 143, 132, 142, 130, 142, 128, 144, 128, 146, 129, 148, 131, 149, 133, 149, 135,
	148, 138, 147, 141, 147, 144, 148, 146, 149, 142, 7, 140, 134, 139, 132, 139, 130, 141, 128, 143,
	128, 145, 129, 146, 131, 146, 133, 144, 135, 142, 135, 149, 0, 0, 0, 149, 13, 148, 140, 149, 139,
	150, 140, 150, 141, 149, 142, 148, 142, 146, 141, 144, 139, 139, 131, 137, 129, 135, 128, 132, 128,
	129, 129, 128, 131, 128, 133, 129, 135, 130, 136, 132, 137, 137, 139, 139, 140, 141, 142, 142, 144,
	142, 146, 141, 148, 139, 149, 137, 148, 136, 146, 136, 143, 137, 137, 138, 134, 140, 131, 142, 129,
	144, 128, 146, 128, 147, 130, 147, 131, 132, 0, 130, 129, 129, 131, 129, 133, 130, 135, 131, 136,
	137, 139, 136, 15, 137, 138, 138, 135, 140, 132, 142, 130, 144, 129, 146, 129, 147, 130, 152, 0, 0,
	0, 130, 19, 129, 148, 130, 149, 131, 148, 131, 147, 130, 145, 128, 143, 133, 0, 0, 0, 140, 25, 136,
	150, 133, 147, 131, 144, 129, 140, 128, 135, 128, 131, 129, 254, 130, 251, 131, 249, 136, 22, 133,
	146, 131, 142, 130, 139, 129, 134, 129, 129, 130, 252, 131, 249, 140, 0, 0, 0, 137, 25, 138, 151,
	139, 148, 140, 143, 140, 139, 139, 134, 137, 130, 135, 255, 132, 252, 128, 249, 137, 25, 138, 150,
	139, 145, 139, 140, 138, 135, 137, 132, 135, 128, 132, 252, 143, 0, 0, 0, 133, 21, 133, 137, 128, 18,
	138, 140, 138, 18, 128, 140, 140, 0, 0, 0, 137, 18, 137, 128, 128, 9, 146, 137, 150, 0, 0, 0, 130, 0,
	129, 129, 130, 130, 131, 129, 131, 128, 130, 254, 128, 252, 150, 0, 0, 0, 128, 9, 146, 137, 150, 0, 0,
	0, 129, 2, 128, 129, 129, 128, 130, 129, 129, 130, 137, 0, 0, 0, 154, 25, 128, 249, 152, 0, 0, 0,
	134, 21, 131, 148, 129, 145, 128, 140, 128, 137, 129, 132, 131, 129, 134, 128, 136, 128, 139, 129,
	141, 132, 142, 137, 142, 140, 141, 145, 139, 148, 136, 149, 134, 149, 150, 0, 0, 0, 132, 17, 134,
	146, 137, 149, 137, 128, 147, 0, 150, 0, 0, 0, 129, 16, 129, 145, 130, 147, 131, 148, 133, 149, 137,
	149, 139, 148, 140, 147, 141, 145, 141, 143, 140, 141, 138, 138, 128, 128, 142, 128, 150, 0, 0, 0,
	130, 21, 141, 149, 135, 141, 138, 141, 140, 140, 141, 139, 142, 136, 142, 134, 141, 131, 139, 129,
	136, 128, 133, 128, 130, 129, 129, 130, 128, 132, 150, 0, 0, 0, 138, 0, 138, 149, 128, 135, 143, 135,
	150, 0, 0, 0, 140, 21, 130, 149, 129, 140, 130, 141, 133, 142, 136, 142, 139, 141, 141, 139, 142,
	136, 142, 134, 141, 131, 139, 129, 136, 128, 133, 128, 130, 129, 129, 130, 128, 132, 150, 0, 0, 0,
	140, 18, 139, 148, 136, 149, 134, 149, 131, 148, 129, 145, 128, 140, 128, 135, 129, 131, 131, 129,
	134, 128, 135, 128, 138, 129, 140, 131, 141, 134, 141, 135, 140, 138, 138, 140, 135, 141, 134, 141,
	131, 140, 129, 138, 128, 135, 150, 0, 0, 0, 128, 21, 142, 149, 132, 128, 150, 0, 0, 0, 133, 21, 130,
	148, 129, 146, 129, 144, 130, 142, 132, 141, 136, 140, 139, 139, 141, 137, 142, 135, 142, 132, 141,
	130, 140, 129, 137, 128, 133, 128, 130, 129, 129, 130, 128, 132, 128, 135, 129, 137, 131, 139, 134,
	140, 138, 141, 140, 142, 141, 144, 141, 146, 140, 148, 137, 149, 133, 149, 150, 0, 0, 0, 141, 14,
	140, 139, 138, 137, 135, 136, 134, 136, 131, 137, 129, 139, 128, 142, 128, 143, 129, 146, 131, 148,
	134, 149, 135, 149, 138, 148, 140, 146, 141, 142, 141, 137, 140, 132, 138, 129, 135, 128, 133, 128,
	130, 129, 129, 131, 150, 0, 0, 0, 132, 14, 131, 141, 132, 140, 133, 141, 132, 142, 132, 3, 131, 130,
	132, 129, 133, 130, 132, 131, 137, 0, 0, 0, 133, 14, 132, 141, 133, 140, 134, 141, 133, 142, 133, 0,
	132, 129, 133, 130, 134, 129, 134, 128, 133, 254, 131, 252, 138, 0, 0, 0, 144, 18, 128, 137, 144,
	128, 148, 0, 0, 0, 128, 12, 146, 140, 128, 6, 146, 134, 150, 0, 0, 0, 128, 18, 144, 137, 128, 128, 148,
	0, 0, 0, 129, 17, 130, 144, 129, 143, 128, 144, 128, 145, 129, 147, 130, 148, 133, 149, 137, 149,
	140, 148, 141, 146, 141, 144, 140, 142, 139, 141, 133, 139, 131, 138, 131, 136, 132, 135, 134, 135,
	137, 21, 139, 148, 140, 146, 140, 144, 139, 142, 138, 141, 136, 140, 133, 2, 132, 129, 133, 128,
	134, 129, 133, 130, 143, 0, 0, 0, 143, 13, 142, 143, 140, 144, 137, 144, 135, 143, 134, 142, 133,
	139, 133, 136, 134, 134, 136, 133, 139, 133, 141, 134, 142, 136, 137, 16, 135, 142, 134, 139, 134,
	136, 135, 134, 136, 133, 143, 16, 142, 136, 142, 134, 144, 133, 146, 133, 148, 135, 149, 138, 149,
	140, 148, 143, 147, 145, 145, 147, 143, 148, 140, 149, 137, 149, 134, 148, 132, 147, 130, 145, 129,
	143, 128, 140, 128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137, 128, 140, 128, 143, 129, 145,
	130, 146, 131, 144, 16, 143, 136, 143, 134, 144, 133, 152, 0, 0, 0, 128, 0, 130, 129, 133, 132, 136,
	136, 140, 143, 143, 149, 143, 128, 142, 131, 140, 134, 138, 136, 135, 138, 133, 138, 132, 137, 132,
	135, 133, 133, 135, 131, 138, 129, 141, 128, 146, 128, 148, 0, 0, 0, 138, 19, 139, 146, 139, 143,
	138, 139, 137, 136, 136, 134, 134, 131, 132, 129, 130, 128, 129, 128, 128, 129, 128, 132, 129, 137,
	130, 140, 131, 142, 133, 145, 135, 147, 137, 148, 140, 149, 143, 149, 145, 148, 146, 146, 146, 144,
	145, 142, 144, 141, 142, 140, 139, 139, 138, 11, 139, 139, 142, 138, 143, 137, 144, 135, 144, 132,
	143, 130, 142, 129, 140, 128, 137, 128, 135, 129, 134, 131, 148, 0, 0, 0, 137, 15, 137, 142, 138,
	141, 140, 141, 142, 142, 143, 144, 143, 146, 142, 148, 140, 149, 137, 149, 134, 148, 132, 146, 130,
	143, 129, 141, 128, 137, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 131, 140,
	133, 145, 0, 0, 0, 142, 21, 140, 148, 139, 146, 138, 142, 137, 136, 136, 133, 135, 131, 133, 129,
	131, 128, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 133, 131, 135, 129, 138, 128, 141, 128,
	144, 129, 146, 131, 148, 135, 149, 140, 149, 144, 148, 147, 147, 148, 145, 149, 142, 149, 140, 147,
	140, 145, 141, 142, 143, 139, 145, 137, 148, 135, 150, 134, 152, 0, 0, 0, 139, 17, 139, 144, 140,
	143, 142, 143, 143, 144, 143, 146, 142, 148, 139, 149, 135, 149, 132, 148, 131, 146, 131, 143, 132,
	141, 133, 140, 136, 139, 133, 139, 130, 138, 129, 137, 128, 135, 128, 132, 129, 130, 130, 129, 133,
	128, 136, 128, 139, 129, 141, 131, 142, 133, 145, 0, 0, 0, 137, 15, 135, 143, 133, 144, 132, 146,
	133, 148, 136, 149, 139, 149, 143, 148, 146, 148, 148, 149, 143, 20, 141, 141, 139, 135, 137, 131,
	135, 129, 133, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129, 134, 131, 134, 133, 133, 136, 11,
	145, 139, 147, 0, 0, 0, 128, 0, 130, 129, 134, 133, 137, 138, 138, 141, 139, 145, 139, 148, 138, 149,
	137, 149, 136, 148, 135, 146, 135, 143, 136, 141, 138, 140, 142, 140, 145, 141, 146, 142, 147, 144,
	147, 138, 146, 133, 145, 131, 143, 129, 140, 128, 136, 128, 133, 129, 131, 131, 130, 133, 130, 135,
	151, 0, 0, 0, 134, 14, 132, 143, 131, 145, 131, 146, 132, 148, 134, 149, 135, 149, 137, 148, 138,
	146, 138, 144, 137, 140, 135, 134, 133, 130, 131, 128, 129, 128, 128, 129, 128, 131, 134, 9, 143,
	140, 145, 141, 148, 143, 150, 145, 151, 147, 151, 148, 150, 149, 149, 149, 147, 147, 145, 143, 143,
	137, 142, 132, 142, 129, 143, 128, 144, 128, 146, 129, 147, 130, 149, 133, 151, 0, 0, 0, 141, 5, 139,
	135, 137, 138, 136, 140, 135, 143, 135, 146, 136, 148, 137, 149, 139, 149, 140, 148, 141, 146, 141,
	143, 140, 138, 138, 133, 137, 131, 135, 129, 133, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129,
	134, 131, 134, 133, 133, 144, 0, 0, 0, 137, 125, 135, 128, 133, 133, 132, 139, 132, 145, 133, 148,
	135, 149, 137, 149, 138, 148, 139, 145, 139, 142, 138, 137, 135, 128, 133, 250, 132, 247, 131, 245,
	129, 244, 128, 245, 128, 247, 129, 250, 131, 253, 133, 255, 136, 129, 140, 131, 142, 0, 0, 0, 134,
	14, 132, 143, 131, 145, 131, 146, 132, 148, 134, 149, 135, 149, 137, 148, 138, 146, 138, 144, 137,
	140, 135, 134, 133, 130, 131, 128, 129, 128, 128, 129, 128, 131, 151, 18, 151, 148, 150, 149, 149,
	149, 147, 148, 145, 146, 143, 143, 141, 141, 139, 140, 137, 140, 139, 12, 140, 138, 140, 131, 141,
	129, 142, 128, 143, 128, 145, 129, 146, 130, 148, 133, 151, 0, 0, 0, 132, 9, 134, 137, 138, 138, 141,
	140, 143, 142, 144, 144, 144, 147, 143, 149, 141, 149, 140, 148, 139, 146, 138, 141, 137, 136, 136,
	133, 135, 131, 133, 129, 131, 128, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 133, 131, 136,
	129, 139, 128, 141, 128, 144, 129, 146, 131, 147, 0, 0, 0, 131, 14, 129, 143, 128, 145, 128, 146,
	129, 148, 131, 149, 132, 149, 134, 148, 135, 146, 135, 144, 134, 139, 133, 135, 131, 128, 133, 7,
	136, 143, 138, 147, 139, 148, 141, 149, 142, 149, 144, 148, 145, 146, 145, 144, 144, 139, 143, 135,
	141, 128, 143, 7, 146, 143, 148, 147, 149, 148, 151, 149, 152, 149, 154, 148, 155, 146, 155, 144,
	154, 139, 152, 132, 152, 129, 153, 128, 154, 128, 156, 129, 157, 130, 159, 133, 159, 0, 0, 0, 131,
	14, 129, 143, 128, 145, 128, 146, 129, 148, 131, 149, 132, 149, 134, 148, 135, 146, 135, 144, 134,
	139, 133, 135, 131, 128, 133, 7, 136, 143, 138, 147, 139, 148, 141, 149, 143, 149, 145, 148, 146,
	146, 146, 144, 145, 139, 143, 132, 143, 129, 144, 128, 145, 128, 147, 129, 148, 130, 150, 133, 150,
	0, 0, 0, 137, 21, 134, 148, 132, 146, 130, 143, 129, 141, 128, 137, 128, 133, 129, 130, 130, 129,
	132, 128, 134, 128, 137, 129, 139, 131, 141, 134, 142, 136, 143, 140, 143, 144, 142, 147, 141, 148,
	139, 149, 137, 149, 135, 147, 135, 144, 136, 141, 138, 138, 140, 136, 143, 134, 145, 133, 146, 0, 0,
	0, 138, 19, 139, 146, 139, 143, 138, 139, 137, 136, 136, 134, 134, 131, 132, 129, 130, 128, 129,
	128, 128, 129, 128, 132, 129, 137, 130, 140, 131, 142, 133, 145, 135, 147, 137, 148, 140, 149, 145,
	149, 147, 148, 148, 147, 149, 145, 149, 142, 148, 140, 147, 139, 145, 138, 142, 138, 140, 139, 139,
	140, 150, 0, 0, 0, 141, 15, 140, 141, 139, 140, 137, 139, 135, 139, 134, 141, 134, 143, 135, 146,
	137, 148, 140, 149, 143, 149, 145, 148, 146, 146, 146, 142, 145, 139, 143, 136, 139, 132, 136, 130,
	134, 129, 131, 128, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 133, 131, 136, 129, 139, 128,
	142, 128, 145, 129, 147, 131, 150, 0, 0, 0, 138, 19, 139, 146, 139, 143, 138, 139, 137, 136, 136,
	134, 134, 131, 132, 129, 130, 128, 129, 128, 128, 129, 128, 132, 129, 137, 130, 140, 131, 142, 133,
	145, 135, 147, 137, 148, 140, 149, 144, 149, 146, 148, 147, 147, 148, 145, 148, 142, 147, 140, 146,
	139, 144, 138, 141, 138, 138, 139, 139, 138, 140, 136, 140, 131, 141, 129, 143, 128, 145, 129, 146,
	130, 148, 133, 150, 0, 0, 0, 128, 0, 130, 129, 132, 131, 135, 135, 137, 138, 139, 142, 140, 145, 140,
	148, 139, 149, 138, 149, 137, 148, 136, 146, 136, 144, 137, 142, 139, 140, 142, 138, 144, 136, 145,
	134, 145, 132, 144, 130, 143, 129, 140, 128, 136, 128, 133, 129, 131, 131, 130, 133, 130, 135, 148,
	0, 0, 0, 137, 15, 135, 143, 133, 144, 132, 146, 133, 148, 136, 149, 139, 149, 143, 148, 146, 148,
	148, 149, 143, 20, 141, 141, 139, 135, 137, 131, 135, 129, 133, 128, 131, 128, 129, 129, 128, 131,
	128, 133, 129, 134, 131, 134, 133, 133, 153, 0, 0, 0, 131, 14, 129, 143, 128, 145, 128, 146, 129,
	148, 131, 149, 132, 149, 134, 148, 135, 146, 135, 144, 134, 140, 133, 137, 132, 133, 132, 131, 133,
	129, 135, 128, 137, 128, 139, 129, 140, 130, 142, 134, 145, 142, 147, 149, 145, 14, 144, 138, 143,
	132, 143, 129, 144, 128, 145, 128, 147, 129, 148, 130, 150, 133, 150, 0, 0, 0, 131, 14, 129, 143,
	128, 145, 128, 146, 129, 148, 131, 149, 132, 149, 134, 148, 135, 146, 135, 144, 134, 140, 133, 137,
	132, 133, 132, 130, 133, 128, 135, 128, 137, 129, 140, 132, 142, 135, 144, 139, 145, 142, 146, 146,
	146, 148, 145, 149, 144, 149, 143, 148, 142, 146, 142, 144, 143, 141, 145, 139, 147, 138, 149, 0, 0,
	0, 131, 14, 129, 143, 128, 145, 128, 146, 129, 148, 131, 149, 132, 149, 134, 148, 135, 146, 135,
	143, 134, 128, 144, 21, 134, 128, 144, 21, 142, 128, 156, 21, 154, 148, 151, 145, 148, 141, 145,
	135, 142, 128, 154, 0, 0, 0, 135, 15, 133, 143, 132, 144, 132, 146, 133, 148, 135, 149, 137, 149,
	139, 148, 140, 146, 140, 143, 138, 134, 138, 131, 139, 129, 141, 128, 143, 128, 145, 129, 146, 131,
	146, 133, 145, 134, 143, 134, 150, 18, 150, 148, 149, 149, 147, 149, 145, 148, 143, 146, 141, 143,
	137, 134, 135, 131, 133, 129, 131, 128, 129, 128, 128, 129, 128, 131, 154, 0, 0, 0, 131, 14, 129,
	143, 128, 145, 128, 146, 129, 148, 131, 149, 132, 149, 134, 148, 135, 146, 135, 144, 134, 140, 133,
	137, 132, 133, 132, 131, 133, 129, 134, 128, 136, 128, 138, 129, 140, 131, 142, 134, 143, 136, 145,
	142, 147, 21, 145, 142, 142, 132, 140, 254, 138, 249, 136, 245, 134, 244, 133, 245, 133, 247, 134,
	250, 136, 253, 139, 128, 142, 130, 147, 133, 149, 0, 0, 0, 139, 15, 138, 141, 137, 140, 135, 139,
	133, 139, 132, 141, 132, 143, 133, 146, 135, 148, 138, 149, 141, 149, 143, 148, 144, 146, 144, 142,
	143, 139, 141, 135, 138, 132, 134, 129, 132, 128, 129, 128, 128, 129, 128, 131, 129, 132, 132, 132,
	134, 131, 135, 130, 136, 128, 136, 253, 135, 250, 134, 248, 132, 245, 130, 244, 129, 245, 129, 247,
	130, 250, 132, 253, 135, 128, 138, 130, 144, 133, 147, 0, 0, 0, 128, 19, 128, 255, 129, 19, 129, 255,
	128, 19, 133, 147, 128, 127, 133, 255, 135, 0, 0, 0, 128, 21, 142, 253, 147, 0, 0, 0, 132, 19, 132,
	255, 133, 19, 133, 255, 128, 19, 133, 147, 128, 127, 133, 255, 136, 0, 0, 0, 141, 12, 136, 144, 131,
	140, 136, 145, 141, 140, 147, 0, 0, 0, 128, 121, 144, 249, 145, 0, 0, 0, 131, 21, 129, 147, 128, 145,
	128, 144, 129, 143, 130, 144, 129, 145, 133, 0, 0, 0, 137, 6, 136, 136, 134, 137, 132, 137, 130, 136,
	129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 131, 138, 137, 137, 132,
	137, 129, 138, 128, 139, 128, 141, 129, 142, 130, 144, 133, 144, 0, 0, 0, 128, 5, 130, 136, 133, 141,
	134, 143, 135, 146, 135, 148, 134, 149, 132, 148, 131, 146, 130, 142, 129, 135, 129, 129, 130, 128,
	131, 128, 133, 129, 135, 131, 136, 134, 136, 137, 137, 133, 138, 132, 140, 132, 142, 133, 142, 0, 0,
	0, 135, 7, 135, 136, 134, 137, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131,
	128, 134, 128, 137, 130, 139, 133, 139, 0, 0, 0, 137, 6, 136, 136, 134, 137, 132, 137, 130, 136, 129,
	135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 131, 142, 149, 138, 9, 137,
	132, 137, 129, 138, 128, 139, 128, 141, 129, 142, 130, 144, 133, 144, 0, 0, 0, 129, 2, 131, 131, 132,
	132, 133, 134, 133, 136, 132, 137, 131, 137, 129, 136, 128, 134, 128, 131, 129, 129, 131, 128, 133,
	128, 135, 129, 136, 130, 138, 133, 138, 0, 0, 0, 133, 5, 137, 138, 139, 141, 140, 143, 141, 146, 141,
	148, 140, 149, 138, 148, 137, 146, 135, 138, 132, 129, 129, 250, 128, 247, 128, 245, 129, 244, 131,
	245, 132, 248, 133, 129, 134, 128, 136, 128, 138, 129, 139, 130, 141, 133, 141, 0, 0, 0, 137, 6, 136,
	136, 134, 137, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135,
	129, 136, 130, 138, 9, 136, 130, 132, 247, 131, 245, 129, 244, 128, 245, 128, 247, 129, 250, 132,
	253, 135, 255, 137, 128, 140, 130, 143, 133, 143, 0, 0, 0, 128, 5, 130, 136, 133, 141, 134, 143, 135,
	146, 135, 148, 134, 149, 132, 148, 131, 146, 130, 142, 129, 136, 128, 128, 128, 0, 129, 131, 130,
	133, 132, 136, 134, 137, 136, 137, 137, 136, 137, 134, 136, 131, 136, 129, 137, 128, 138, 128, 140,
	129, 141, 130, 143, 133, 143, 0, 0, 0, 131, 14, 131, 141, 132, 141, 132, 142, 131, 142, 128, 5, 130,
	137, 128, 131, 128, 129, 129, 128, 130, 128, 132, 129, 133, 130, 135, 133, 135, 0, 0, 0, 139, 14,
	139, 141, 140, 141, 140, 142, 139, 142, 136, 5, 138, 137, 132, 247, 131, 245, 129, 244, 128, 245,
	128, 247, 129, 250, 132, 253, 135, 255, 137, 128, 140, 130, 143, 133, 143, 0, 0, 0, 128, 5, 130, 136,
	133, 141, 134, 143, 135, 146, 135, 148, 134, 149, 132, 148, 131, 146, 130, 142, 129, 136, 128, 128,
	128, 0, 129, 131, 130, 133, 132, 136, 134, 137, 136, 137, 137, 136, 137, 134, 135, 133, 132, 133,
	132, 5, 134, 132, 135, 129, 136, 128, 137, 128, 139, 129, 140, 130, 142, 133, 142, 0, 0, 0, 128, 5,
	130, 136, 133, 141, 134, 143, 135, 146, 135, 148, 134, 149, 132, 148, 131, 146, 130, 142, 129, 135,
	129, 129, 130, 128, 131, 128, 133, 129, 134, 130, 136, 133, 136, 0, 0, 0, 128, 5, 130, 136, 132, 137,
	133, 136, 133, 135, 132, 131, 131, 128, 132, 3, 133, 133, 135, 136, 137, 137, 139, 137, 140, 136,
	140, 135, 139, 131, 138, 128, 139, 3, 140, 133, 142, 136, 144, 137, 146, 137, 147, 136, 147, 134,
	146, 131, 146, 129, 147, 128, 148, 128, 150, 129, 151, 130, 153, 133, 153, 0, 0, 0, 128, 5, 130, 136,
	132, 137, 133, 136, 133, 135, 132, 131, 131, 128, 132, 3, 133, 133, 135, 136, 137, 137, 139, 137,
	140, 136, 140, 134, 139, 131, 139, 129, 140, 128, 141, 128, 143, 129, 144, 130, 146, 133, 146, 0, 0,
	0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135,
	129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 133, 136, 133, 134, 134, 132, 136, 131, 139,
	131, 141, 132, 142, 133, 142, 0, 0, 0, 128, 5, 130, 136, 131, 138, 130, 134, 252, 244, 130, 6, 131,
	136, 133, 137, 135, 137, 137, 136, 138, 134, 138, 132, 137, 130, 136, 129, 134, 128, 130, 1, 132,
	128, 135, 128, 138, 129, 140, 130, 143, 133, 143, 0, 0, 0, 137, 6, 136, 136, 134, 137, 132, 137, 130,
	136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 138, 9, 137, 134, 135,
	129, 132, 250, 131, 247, 131, 245, 132, 244, 134, 245, 135, 248, 135, 255, 137, 128, 140, 130, 143,
	133, 143, 0, 0, 0, 128, 5, 130, 136, 131, 138, 131, 136, 134, 136, 135, 135, 135, 133, 134, 130, 134,
	129, 135, 128, 136, 128, 138, 129, 139, 130, 141, 133, 141, 0, 0, 0, 128, 5, 130, 136, 131, 138, 131,
	136, 133, 133, 134, 131, 134, 129, 132, 128, 128, 1, 130, 128, 134, 128, 136, 129, 137, 130, 139,
	133, 139, 0, 0, 0, 128, 5, 130, 136, 132, 140, 135, 21, 129, 131, 129, 129, 130, 128, 132, 128, 134,
	129, 135, 130, 137, 133, 129, 13, 136, 141, 137, 0, 0, 0, 128, 5, 130, 137, 128, 131, 128, 129, 129,
	128, 131, 128, 133, 129, 135, 131, 137, 134, 138, 9, 136, 131, 136, 129, 137, 128, 138, 128, 140,
	129, 141, 130, 143, 133, 143, 0, 0, 0, 128, 5, 130, 137, 129, 132, 129, 129, 130, 128, 131, 128, 134,
	129, 136, 131, 137, 134, 137, 137, 137, 9, 138, 133, 139, 132, 141, 132, 143, 133, 143, 0, 0, 0, 131,
	9, 129, 135, 128, 132, 128, 130, 129, 128, 131, 128, 133, 129, 135, 131, 137, 9, 135, 131, 135,
	129, 136, 128, 138, 128, 140, 129, 142, 131, 143, 134, 143, 137, 143, 9, 144, 133, 145, 132, 147,
	132, 149, 133, 149, 0, 0, 0, 128, 5, 130, 136, 132, 137, 134, 137, 135, 136, 135, 129, 136, 128, 139,
	128, 142, 130, 144, 133, 141, 8, 140, 137, 138, 137, 137, 136, 133, 129, 132, 128, 130, 128, 129,
	129, 144, 0, 0, 0, 128, 5, 130, 137, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129, 135, 131, 137,
	134, 138, 9, 132, 247, 131, 245, 129, 244, 128, 245, 128, 247, 129, 250, 132, 253, 135, 255, 137,
	128, 140, 130, 143, 133, 143, 0, 0, 0, 128, 5, 130, 136, 132, 137, 134, 137, 136, 135, 136, 133, 135,
	131, 133, 129, 130, 128, 132, 255, 133, 253, 133, 250, 132, 247, 131, 245, 129, 244, 128, 245, 128,
	247, 129, 250, 132, 253, 135, 255, 139, 130, 142, 133, 142, 0, 0, 0, 133, 25, 131, 152, 130, 151,
	129, 149, 129, 147, 130, 145, 131, 144, 132, 142, 132, 140, 130, 138, 131, 24, 130, 150, 130, 148,
	131, 146, 132, 145, 133, 143, 133, 141, 132, 139, 128, 137, 132, 135, 133, 133, 133, 131, 132, 129,
	131, 128, 130, 254, 130, 252, 131, 250, 130, 8, 132, 134, 132, 132, 131, 130, 130, 129, 129, 255,
	129, 253, 130, 251, 131, 250, 133, 249, 138, 0, 0, 0, 128, 22, 128, 250, 132, 0, 0, 0, 128, 25, 130,
	152, 131, 151, 132, 149, 132, 147, 131, 145, 130, 144, 129, 142, 129, 140, 131, 138, 130, 24, 131,
	150, 131, 148, 130, 146, 129, 145, 128, 143, 128, 141, 129, 139, 133, 137, 129, 135, 128, 133, 128,
	131, 129, 129, 130, 128, 131, 254, 131, 252, 130, 250, 131, 8, 129, 134, 129, 132, 130, 130, 131,
	129, 132, 255, 132, 253, 131, 251, 130, 250, 128, 249, 137, 0, 0, 0, 128, 13, 130, 143, 132, 144,
	134, 144, 135, 143, 136, 141, 137, 140, 139, 139, 140, 139, 141, 140, 142, 142, 142, 139, 140, 138,
	139, 138, 137, 139, 135, 141, 133, 142, 131, 142, 128, 141, 145, 0, 0, 0, 128, 5, 128, 128, 138, 128,
	138, 133, 133, 141, 128, 133, 144, 0, 0, 0, 137, 13, 137, 140, 138, 139, 140, 139, 142, 140, 143,
	142, 143, 144, 142, 146, 140, 147, 137, 147, 134, 146, 132, 144, 130, 141, 129, 139, 128, 135, 129,
	132, 130, 131, 132, 130, 134, 130, 137, 131, 139, 133, 140, 135, 129, 123, 130, 252, 129, 253, 128,
	252, 128, 251, 129, 249, 130, 248, 133, 247, 137, 247, 140, 248, 141, 250, 141, 252, 140, 254, 139,
	255, 137, 128, 139, 254, 140, 252, 140, 250, 139, 248, 137, 247, 132, 2, 132, 128, 137, 128, 145, 0,
	0, 0, 128, 5, 130, 137, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129, 135, 131, 137, 134, 138,
	9, 136, 131, 136, 129, 137, 128, 138, 128, 140, 129, 141, 130, 143, 133, 131, 13, 130, 140, 130,
	139, 132, 139, 133, 140, 132, 141, 131, 141, 137, 13, 136, 140, 136, 139, 138, 139, 139, 140, 138,
	141, 137, 141, 143, 0, 0, 0, 129, 2, 131, 131, 132, 132, 133, 134, 133, 136, 132, 137, 131, 137, 129,
	136, 128, 134, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 138, 133, 135, 15, 134,
	144, 135, 145, 136, 144, 136, 143, 135, 141, 131, 139, 138, 0, 0, 0, 138, 6, 137, 136, 135, 137, 133,
	137, 131, 136, 130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 134, 128, 136, 129, 137, 131, 139,
	137, 138, 132, 138, 129, 139, 128, 140, 128, 142, 129, 143, 130, 145, 133, 135, 17, 140, 140, 135,
	144, 130, 140, 135, 145, 145, 0, 0, 0, 137, 6, 136, 136, 134, 137, 132, 137, 130, 136, 129, 135, 128,
	133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 131, 138, 137, 137, 132, 137, 129, 138,
	128, 139, 128, 141, 129, 142, 130, 144, 133, 131, 13, 130, 140, 130, 139, 132, 139, 133, 140, 132,
	141, 131, 141, 137, 13, 136, 140, 136, 139, 138, 139, 139, 140, 138, 141, 137, 141, 144, 0, 0, 0,
	137, 6, 136, 136, 134, 137, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128,
	133, 128, 135, 129, 136, 131, 138, 137, 137, 132, 137, 129, 138, 128, 139, 128, 141, 129, 142, 130,
	144, 133, 131, 15, 132, 144, 131, 145, 130, 144, 130, 143, 131, 141, 135, 139, 144, 0, 0, 0, 137, 6,
	136, 136, 134, 137, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128,
	135, 129, 136, 131, 138, 137, 137, 132, 137, 129, 138, 128, 139, 128, 141, 129, 142, 130, 144, 133,
	135, 14, 134, 142, 132, 141, 132, 140, 133, 139, 135, 139, 137, 140, 137, 141, 136, 142, 135, 142,
	144, 0, 0, 0, 135, 7, 135, 136, 134, 137, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129,
	131, 128, 134, 128, 137, 130, 139, 133, 131, 0, 131, 254, 134, 254, 136, 253, 136, 250, 134, 249,
	131, 249, 130, 250, 130, 251, 131, 252, 132, 251, 131, 251, 134, 126, 135, 252, 135, 250, 134, 249,
	139, 0, 0, 0, 133, 2, 135, 131, 136, 132, 137, 134, 137, 136, 136, 137, 135, 137, 133, 136, 132, 134,
	132, 131, 133, 129, 135, 128, 137, 128, 139, 129, 140, 130, 142, 133, 131, 12, 136, 144, 141, 140,
	136, 145, 131, 140, 144, 0, 0, 0, 129, 2, 131, 131, 132, 132, 133, 134, 133, 136, 132, 137, 131, 137,
	129, 136, 128, 134, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 138, 133, 129, 13,
	128, 140, 128, 139, 130, 139, 131, 140, 130, 141, 129, 141, 135, 13, 134, 140, 134, 139, 136, 139,
	137, 140, 136, 141, 135, 141, 138, 0, 0, 0, 129, 2, 131, 131, 132, 132, 133, 134, 133, 136, 132, 137,
	131, 137, 129, 136, 128, 134, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 138, 133,
	129, 15, 130, 144, 129, 145, 128, 144, 128, 143, 129, 141, 133, 139, 138, 0, 0, 0, 128, 5, 130, 137,
	128, 131, 128, 129, 129, 128, 130, 128, 132, 129, 133, 130, 135, 133, 129, 13, 128, 140, 128, 139,
	130, 139, 131, 140, 130, 141, 129, 141, 135, 13, 134, 140, 134, 139, 136, 139, 137, 140, 136, 141,
	135, 141, 135, 0, 0, 0, 133, 5, 135, 137, 133, 131, 133, 129, 134, 128, 135, 128, 137, 129, 138, 130,
	140, 133, 131, 12, 136, 144, 141, 140, 136, 145, 131, 140, 146, 0, 0, 0, 130, 5, 132, 137, 130, 131,
	130, 129, 131, 128, 132, 128, 134, 129, 135, 130, 137, 133, 129, 15, 130, 144, 129, 145, 128, 144,
	128, 143, 129, 141, 133, 139, 140, 0, 0, 0, 128, 0, 130, 129, 133, 132, 136, 136, 140, 143, 143, 149,
	143, 128, 142, 131, 140, 134, 138, 136, 135, 138, 133, 138, 132, 137, 132, 135, 133, 133, 135, 131,
	138, 129, 141, 128, 146, 128, 137, 25, 136, 152, 136, 151, 138, 151, 139, 152, 138, 153, 137, 153,
	143, 25, 142, 152, 142, 151, 144, 151, 145, 152, 144, 153, 143, 153, 148, 0, 0, 0, 128, 0, 130, 129,
	133, 132, 136, 136, 140, 143, 143, 149, 143, 128, 142, 131, 140, 134, 138, 136, 135, 138, 133, 138,
	132, 137, 132, 135, 133, 133, 135, 131, 138, 129, 141, 128, 146, 128, 142, 26, 141, 154, 139, 153,
	139, 152, 140, 151, 142, 151, 144, 152, 144, 153, 143, 154, 142, 154, 148, 0, 0, 0, 136, 13, 136,
	140, 137, 139, 139, 139, 140, 140, 140, 142, 139, 144, 136, 145, 132, 145, 129, 144, 128, 142, 128,
	139, 129, 137, 132, 136, 130, 136, 128, 135, 128, 132, 129, 130, 130, 129, 133, 128, 136, 128, 139,
	129, 141, 131, 142, 133, 136, 23, 135, 152, 136, 153, 137, 152, 137, 151, 136, 149, 132, 147, 145,
	0, 0, 0, 137, 6, 136, 136, 134, 137, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129,
	131, 128, 133, 128, 135, 129, 136, 131, 138, 137, 137, 132, 137, 130, 138, 129, 139, 130, 141, 131,
	142, 132, 143, 134, 143, 136, 142, 137, 141, 137, 139, 136, 138, 134, 138, 131, 139, 129, 141, 128,
	143, 128, 145, 129, 146, 130, 148, 133, 151, 0, 0, 0, 128, 0, 130, 129, 133, 132, 136, 136, 140, 143,
	143, 149, 143, 128, 142, 131, 140, 134, 138, 136, 135, 138, 133, 138, 132, 137, 132, 135, 133, 133,
	135, 131, 138, 129, 141, 128, 147, 128, 155, 17, 155, 144, 156, 143, 158, 143, 159, 144, 159, 146,
	158, 148, 155, 149, 151, 149, 148, 148, 147, 146, 147, 143, 148, 141, 149, 140, 152, 139, 149, 139,
	146, 138, 145, 137, 144, 135, 144, 132, 145, 130, 146, 129, 149, 128, 152, 128, 155, 129, 157, 131,
	158, 133, 158, 0, 0, 0, 136, 9, 134, 137, 132, 136, 131, 135, 130, 133, 130, 131, 131, 129, 133, 128,
	135, 128, 137, 129, 138, 130, 139, 132, 139, 134, 138, 136, 136, 137, 135, 136, 135, 134, 136, 132,
	138, 131, 141, 131, 143, 132, 144, 133, 130, 12, 135, 144, 140, 140, 135, 145, 130, 140, 144, 0, 0,
	0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135,
	129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 133, 136, 133, 134, 134, 132, 136, 131, 139,
	131, 141, 132, 142, 133, 130, 13, 129, 140, 129, 139, 131, 139, 132, 140, 131, 141, 130, 141, 136,
	13, 135, 140, 135, 139, 137, 139, 138, 140, 137, 141, 136, 141, 142, 0, 0, 0, 134, 9, 132, 137, 130,
	136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 137, 132, 137,
	134, 136, 136, 134, 137, 133, 136, 133, 134, 134, 132, 136, 131, 139, 131, 141, 132, 142, 133, 131,
	15, 132, 144, 131, 145, 130, 144, 130, 143, 131, 141, 135, 139, 142, 0, 0, 0, 130, 5, 132, 137, 130,
	131, 130, 129, 131, 128, 133, 128, 135, 129, 137, 131, 139, 134, 140, 9, 138, 131, 138, 129, 139,
	128, 140, 128, 142, 129, 143, 130, 145, 133, 131, 12, 136, 145, 141, 140, 136, 144, 131, 140, 145,
	0, 0, 0, 128, 5, 130, 137, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129, 135, 131, 137, 134,
	138, 9, 136, 131, 136, 129, 137, 128, 138, 128, 140, 129, 141, 130, 143, 133, 131, 15, 132, 144,
	131, 145, 130, 144, 130, 143, 131, 141, 135, 139, 143, 0, 0, 0, 128, 5, 130, 137, 128, 131, 128, 129,
	129, 128, 131, 128, 133, 129, 135, 131, 137, 134, 138, 9, 132, 247, 131, 245, 129, 244, 128, 245,
	128, 247, 129, 250, 132, 253, 135, 255, 137, 128, 140, 130, 143, 133, 131, 13, 130, 140, 130, 139,
	132, 139, 133, 140, 132, 141, 131, 141, 137, 13, 136, 140, 136, 139, 138, 139, 139, 140, 138, 141,
	137, 141, 143, 0, 0, 0, 137, 21, 134, 148, 132, 146, 130, 143, 129, 141, 128, 137, 128, 133, 129,
	130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 131, 141, 134, 142, 136, 143, 140, 143, 144, 142,
	147, 141, 148, 139, 149, 137, 149, 135, 147, 135, 144, 136, 141, 138, 138, 140, 136, 143, 134, 145,
	133, 134, 26, 133, 153, 133, 152, 135, 152, 136, 153, 135, 154, 134, 154, 140, 26, 139, 153, 139,
	152, 141, 152, 142, 153, 141, 154, 140, 154, 146, 0, 0, 0, 131, 14, 129, 143, 128, 145, 128, 146,
	129, 148, 131, 149, 132, 149, 134, 148, 135, 146, 135, 144, 134, 140, 133, 137, 132, 133, 132, 131,
	133, 129, 135, 128, 137, 128, 139, 129, 140, 130, 142, 134, 145, 142, 147, 149, 145, 14, 144, 138,
	143, 132, 143, 129, 144, 128, 145, 128, 147, 129, 148, 130, 150, 133, 138, 25, 137, 152, 137, 151,
	139, 151, 140, 152, 139, 153, 138, 153, 144, 25, 143, 152, 143, 151, 145, 151, 146, 152, 145, 153,
	144, 153, 150, 0, 0, 0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128,
	133, 128, 135, 129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 133, 136, 133, 134, 134, 132,
	136, 131, 139, 131, 141, 132, 142, 133, 138, 9, 128, 255, 142, 0, 0, 0, 143, 18, 145, 145, 146, 145,
	147, 146, 147, 147, 146, 148, 144, 149, 141, 149, 140, 148, 139, 146, 137, 136, 136, 133, 135, 131,
	133, 129, 131, 128, 129, 128, 128, 129, 128, 131, 129, 132, 131, 132, 133, 131, 136, 129, 139, 128,
	141, 128, 144, 129, 145, 130, 145, 131, 144, 132, 143, 132, 142, 131, 132, 10, 134, 140, 136, 141,
	142, 141, 144, 140, 144, 139, 143, 138, 141, 138, 151, 0, 0, 0, 137, 21, 134, 148, 132, 146, 130,
	143, 129, 141, 128, 137, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 131, 141,
	134, 142, 136, 143, 140, 143, 144, 142, 147, 141, 148, 139, 149, 137, 149, 135, 147, 135, 144, 136,
	141, 138, 138, 140, 136, 143, 134, 145, 133, 145, 21, 128, 255, 146, 0, 0, 0, 138, 23, 139, 150, 139,
	147, 138, 143, 137, 140, 134, 132, 131, 128, 130, 128, 128, 130, 128, 136, 129, 141, 130, 144, 131,
	146, 133, 149, 135, 151, 137, 152, 140, 153, 145, 153, 147, 152, 148, 151, 149, 149, 149, 146, 148,
	144, 147, 143, 145, 142, 142, 142, 140, 143, 139, 144, 148, 14, 144, 131, 144, 129, 145, 128, 147,
	128, 149, 129, 150, 130, 152, 133, 143, 11, 151, 139, 142, 2, 144, 133, 146, 137, 154, 0, 0, 0, 132,
	124, 130, 253, 129, 253, 128, 252, 128, 251, 129, 250, 131, 249, 134, 249, 135, 250, 136, 252, 138,
	134, 139, 136, 141, 146, 142, 148, 143, 149, 146, 149, 148, 148, 149, 147, 149, 146, 148, 145, 147,
	145, 145, 146, 146, 8, 132, 136, 151, 0, 0, 0, 137, 6, 136, 136, 134, 137, 132, 137, 130, 136, 129,
	135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 131, 138, 137, 137, 132, 137,
	129, 138, 128, 139, 128, 141, 129, 142, 130, 144, 133, 136, 16, 135, 145, 136, 146, 137, 145, 137,
	144, 136, 142, 132, 140, 144, 0, 0, 0, 128, 5, 130, 137, 128, 131, 128, 129, 129, 128, 130, 128, 132,
	129, 133, 130, 135, 133, 134, 15, 133, 144, 134, 145, 135, 144, 135, 143, 134, 141, 130, 139, 135,
	0, 0, 0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128,
	135, 129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 133, 136, 133, 134, 134, 132, 136, 131,
	139, 131, 141, 132, 142, 133, 136, 15, 135, 144, 136, 145, 137, 144, 137, 143, 136, 141, 132, 139,
	142, 0, 0, 0, 128, 5, 130, 137, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129, 135, 131, 137, 134,
	138, 9, 136, 131, 136, 129, 137, 128, 138, 128, 140, 129, 141, 130, 143, 133, 136, 15, 135, 144,
	136, 145, 137, 144, 137, 143, 136, 141, 132, 139, 143, 0, 0, 0, 128, 5, 130, 136, 132, 137, 133, 136,
	133, 135, 132, 131, 131, 128, 132, 3, 133, 133, 135, 136, 137, 137, 139, 137, 140, 136, 140, 134,
	139, 131, 139, 129, 140, 128, 141, 128, 143, 129, 144, 130, 146, 133, 132, 13, 136, 143, 138, 143,
	141, 140, 143, 139, 144, 139, 145, 140, 146, 142, 146, 139, 144, 138, 143, 138, 141, 139, 139, 141,
	137, 142, 135, 142, 132, 141, 146, 0, 0, 0, 131, 14, 129, 143, 128, 145, 128, 146, 129, 148, 131,
	149, 132, 149, 134, 148, 135, 146, 135, 144, 134, 139, 133, 135, 131, 128, 133, 7, 136, 143, 138,
	147, 139, 148, 141, 149, 143, 149, 145, 148, 146, 146, 146, 144, 145, 139, 143, 132, 143, 129, 144,
	128, 145, 128, 147, 129, 148, 130, 150, 133, 136, 27, 138, 157, 140, 158, 142, 158, 143, 157, 144,
	155, 145, 154, 147, 153, 148, 153, 149, 154, 150, 156, 150, 153, 148, 152, 147, 152, 145, 153, 143,
	155, 141, 156, 139, 156, 136, 155, 150, 0, 0, 0, 137, 18, 136, 148, 134, 149, 132, 149, 130, 148,
	129, 147, 128, 145, 128, 143, 129, 141, 131, 140, 133, 140, 135, 141, 136, 143, 138, 149, 137, 144,
	137, 141, 138, 140, 139, 140, 141, 141, 142, 142, 144, 145, 128, 0, 143, 128, 149, 0, 0, 0, 128, 17,
	129, 143, 131, 142, 133, 142, 135, 143, 136, 144, 137, 146, 136, 148, 134, 149, 132, 149, 130, 148,
	129, 147, 128, 145, 128, 0, 137, 128, 139, 0, 0, 0, 140, 4, 139, 133, 140, 134, 141, 133, 141, 132,
	140, 130, 139, 129, 136, 128, 132, 128, 129, 129, 128, 131, 128, 133, 129, 135, 130, 136, 136, 138,
	138, 139, 138, 141, 137, 142, 135, 142, 132, 0, 130, 129, 129, 131, 129, 133, 130, 135, 131, 136,
	133, 137, 139, 19, 140, 148, 139, 149, 138, 148, 139, 147, 143, 0, 0, 0, 128, 0, 128, 133, 137, 133,
	137, 131, 130, 131, 130, 128, 128, 128, 140, 0, 0, 0, 137, 0, 137, 133, 128, 133, 128, 131, 135, 131,
	135, 128, 137, 128, 140, 0, 0, 0, 146, 21, 144, 149, 128, 128, 130, 128, 146, 149, 128, 18, 129, 146,
	132, 149, 132, 140, 139, 6, 139, 135, 140, 136, 142, 137, 144, 137, 146, 135, 146, 132, 139, 128,
	146, 128, 151, 0, 0, 0, 146, 21, 144, 149, 128, 128, 130, 128, 146, 149, 128, 18, 129, 146, 132, 149,
	132, 140, 146, 3, 138, 131, 144, 137, 144, 128, 151, 0, 0, 0, 131, 13, 135, 129, 134, 128, 133, 129,
	131, 141, 134, 129, 129, 19, 128, 148, 129, 149, 130, 148, 129, 147, 137, 0, 0, 0, 135, 14, 128, 137,
	135, 132, 142, 14, 135, 137, 142, 132, 147, 0, 0, 0, 135, 14, 142, 137, 135, 132, 128, 14, 135, 137,
	128, 132, 147, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128, 144, 128, 146, 128, 12, 130, 140, 130, 138,
	128, 138, 128, 140, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 128, 0, 130, 128, 130, 254, 128,
	254, 128, 128, 129, 18, 129, 144, 129, 12, 129, 138, 129, 6, 129, 132, 129, 0, 129, 254, 132, 21,
	134, 149, 134, 147, 132, 147, 132, 149, 132, 15, 134, 143, 134, 141, 132, 141, 132, 143, 132, 9,
	134, 137, 134, 135, 132, 135, 132, 137, 132, 3, 134, 131, 134, 129, 132, 129, 132, 131, 133, 21,
	133, 147, 133, 15, 133, 141, 133, 9, 133, 135, 133, 3, 133, 129, 136, 18, 138, 146, 138, 144, 136,
	144, 136, 146, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 136, 6, 138, 134, 138, 132, 136,
	132, 136, 134, 136, 0, 138, 128, 138, 254, 136, 254, 136, 128, 137, 18, 137, 144, 137, 12, 137, 138,
	137, 6, 137, 132, 137, 0, 137, 254, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 140, 15, 142,
	143, 142, 141, 140, 141, 140, 143, 140, 9, 142, 137, 142, 135, 140, 135, 140, 137, 140, 3, 142, 131,
	142, 129, 140, 129, 140, 131, 141, 21, 141, 147, 141, 15, 141, 141, 141, 9, 141, 135, 141, 3, 141,
	129, 132, 125, 132, 251, 134, 251, 134, 253, 132, 253, 133, 125, 133, 251, 140, 125, 140, 251, 142,
	251, 142, 253, 140, 253, 141, 125, 141, 251, 142, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128, 144,
	128, 146, 128, 12, 130, 140, 130, 138, 128, 138, 128, 140, 128, 6, 130, 134, 130, 132, 128, 132,
	128, 134, 128, 0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 18, 129, 144, 129, 12, 129, 138, 129,
	6, 129, 132, 129, 0, 129, 254, 130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 130, 15, 132, 143,
	132, 141, 130, 141, 130, 143, 130, 9, 132, 137, 132, 135, 130, 135, 130, 137, 130, 3, 132, 131, 132,
	129, 130, 129, 130, 131, 131, 21, 131, 147, 131, 15, 131, 141, 131, 9, 131, 135, 131, 3, 131, 129,
	132, 18, 134, 146, 134, 144, 132, 144, 132, 146, 132, 12, 134, 140, 134, 138, 132, 138, 132, 140,
	132, 6, 134, 134, 134, 132, 132, 132, 132, 134, 132, 0, 134, 128, 134, 254, 132, 254, 132, 128, 133,
	18, 133, 144, 133, 12, 133, 138, 133, 6, 133, 132, 133, 0, 133, 254, 134, 21, 136, 149, 136, 147,
	134, 147, 134, 149, 134, 15, 136, 143, 136, 141, 134, 141, 134, 143, 134, 9, 136, 137, 136, 135,
	134, 135, 134, 137, 134, 3, 136, 131, 136, 129, 134, 129, 134, 131, 135, 21, 135, 147, 135, 15, 135,
	141, 135, 9, 135, 135, 135, 3, 135, 129, 136, 18, 138, 146, 138, 144, 136, 144, 136, 146, 136, 12,
	138, 140, 138, 138, 136, 138, 136, 140, 136, 6, 138, 134, 138, 132, 136, 132, 136, 134, 136, 0, 138,
	128, 138, 254, 136, 254, 136, 128, 137, 18, 137, 144, 137, 12, 137, 138, 137, 6, 137, 132, 137, 0,
	137, 254, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 138, 15, 140, 143, 140, 141, 138, 141,
	138, 143, 138, 9, 140, 137, 140, 135, 138, 135, 138, 137, 138, 3, 140, 131, 140, 129, 138, 129, 138,
	131, 139, 21, 139, 147, 139, 15, 139, 141, 139, 9, 139, 135, 139, 3, 139, 129, 140, 18, 142, 146,
	142, 144, 140, 144, 140, 146, 140, 12, 142, 140, 142, 138, 140, 138, 140, 140, 140, 6, 142, 134,
	142, 132, 140, 132, 140, 134, 140, 0, 142, 128, 142, 254, 140, 254, 140, 128, 141, 18, 141, 144,
	141, 12, 141, 138, 141, 6, 141, 132, 141, 0, 141, 254, 142, 21, 144, 149, 144, 147, 142, 147, 142,
	149, 142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 142, 9, 144, 137, 144, 135, 142, 135, 142,
	137, 142, 3, 144, 131, 144, 129, 142, 129, 142, 131, 143, 21, 143, 147, 143, 15, 143, 141, 143, 9,
	143, 135, 143, 3, 143, 129, 130, 125, 130, 251, 132, 251, 132, 253, 130, 253, 131, 125, 131, 251,
	134, 125, 136, 253, 136, 251, 134, 251, 134, 253, 135, 125, 135, 251, 138, 125, 138, 251, 140, 251,
	140, 253, 138, 253, 139, 125, 139, 251, 142, 125, 142, 251, 144, 251, 144, 253, 142, 253, 143, 125,
	143, 251, 144, 0, 0, 0, 128, 21, 130, 149, 130, 147, 128, 147, 128, 149, 129, 21, 129, 147, 130, 21,
	132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131, 147, 138, 21, 140, 149, 140, 147, 138, 147,
	138, 149, 139, 21, 139, 147, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21, 141, 147,
	148, 21, 150, 149, 150, 147, 148, 147, 148, 149, 149, 21, 149, 147, 150, 21, 152, 149, 152, 147,
	150, 147, 150, 149, 151, 21, 151, 147, 132, 17, 134, 145, 134, 143, 132, 143, 132, 145, 133, 17,
	133, 143, 134, 17, 138, 145, 138, 143, 134, 143, 134, 145, 135, 17, 135, 143, 137, 17, 137, 143,
	146, 17, 152, 145, 152, 143, 146, 143, 146, 145, 147, 17, 147, 143, 149, 17, 149, 143, 151, 17, 151,
	143, 128, 13, 130, 141, 130, 139, 128, 139, 128, 141, 129, 13, 129, 139, 130, 13, 132, 141, 132,
	139, 130, 139, 130, 141, 131, 13, 131, 139, 128, 5, 130, 133, 130, 131, 128, 131, 128, 133, 129, 5,
	129, 131, 130, 5, 132, 133, 132, 131, 130, 131, 130, 133, 131, 5, 131, 131, 134, 1, 138, 129, 138,
	255, 132, 255, 132, 129, 134, 129, 134, 255, 133, 1, 133, 255, 135, 1, 135, 255, 137, 1, 137, 255,
	138, 13, 140, 141, 140, 139, 138, 139, 138, 141, 139, 13, 139, 139, 142, 13, 142, 139, 140, 139,
	140, 141, 142, 141, 141, 13, 141, 139, 150, 13, 150, 139, 148, 139, 148, 141, 152, 141, 152, 139,
	150, 139, 150, 141, 149, 13, 149, 139, 151, 139, 151, 141, 142, 9, 144, 137, 144, 135, 142, 135,
	142, 137, 143, 9, 143, 135, 144, 9, 146, 137, 146, 135, 144, 135, 144, 137, 145, 9, 145, 135, 146, 9,
	148, 137, 148, 135, 146, 135, 146, 137, 147, 9, 147, 135, 138, 5, 140, 133, 140, 131, 138, 131, 138,
	133, 139, 5, 139, 131, 140, 5, 142, 133, 142, 131, 140, 131, 140, 133, 141, 5, 141, 131, 148, 5, 150,
	133, 150, 131, 148, 131, 148, 133, 149, 5, 149, 131, 150, 5, 152, 133, 152, 131, 150, 131, 150, 133,
	151, 5, 151, 131, 128, 125, 130, 253, 130, 251, 128, 251, 128, 253, 129, 125, 129, 251, 130, 125,
	132, 253, 132, 251, 130, 251, 130, 253, 131, 125, 131, 251, 138, 125, 140, 253, 140, 251, 138, 251,
	138, 253, 139, 125, 139, 251, 140, 125, 142, 253, 142, 251, 140, 251, 140, 253, 141, 125, 141, 251,
	148, 125, 150, 253, 150, 251, 148, 251, 148, 253, 149, 125, 149, 251, 150, 125, 152, 253, 152, 251,
	150, 251, 150, 253, 151, 125, 151, 251, 136, 1, 136, 255, 136, 17, 136, 143, 148, 17, 148, 143, 150,
	17, 150, 143, 128, 9, 130, 137, 130, 135, 128, 135, 128, 137, 129, 9, 129, 135, 130, 9, 132, 137,
	132, 135, 130, 135, 130, 137, 131, 9, 131, 135, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133,
	9, 133, 135, 148, 1, 152, 129, 152, 255, 146, 255, 146, 129, 148, 129, 148, 255, 147, 1, 147, 255,
	149, 1, 149, 255, 151, 1, 151, 255, 150, 1, 150, 255, 152, 0, 0, 0, 128, 21, 128, 249, 131, 0, 0, 0,
	135, 21, 135, 249, 128, 5, 135, 133, 138, 0, 0, 0, 135, 121, 135, 149, 128, 9, 135, 137, 128, 5, 135,
	133, 138, 0, 0, 0, 135, 21, 135, 249, 128, 5, 135, 133, 143, 21, 143, 249, 146, 0, 0, 0, 128, 5, 143,
	133, 143, 249, 135, 5, 135, 249, 146, 0, 0, 0, 128, 9, 135, 137, 135, 249, 128, 5, 135, 133, 138, 0, 0,
	0, 128, 5, 135, 133, 135, 249, 143, 21, 143, 249, 128, 9, 135, 137, 135, 149, 146, 0, 0, 0, 135, 21,
	135, 249, 143, 21, 143, 249, 146, 0, 0, 0, 128, 5, 135, 133, 135, 249, 128, 9, 143, 137, 143, 249,
	146, 0, 0, 0, 128, 9, 135, 137, 135, 149, 128, 5, 143, 133, 143, 149, 146, 0, 0, 0, 128, 9, 143, 137,
	143, 149, 135, 9, 135, 149, 146, 0, 0, 0, 128, 5, 135, 133, 135, 149, 128, 9, 135, 137, 138, 0, 0, 0,
	128, 5, 135, 133, 135, 249, 128, 0, 0, 0, 135, 9, 128, 137, 128, 149, 135, 0, 0, 0, 128, 9, 135, 137,
	135, 149, 142, 9, 135, 137, 142, 0, 0, 0, 128, 5, 135, 133, 135, 249, 142, 5, 135, 133, 142, 0, 0, 0,
	128, 21, 128, 249, 135, 5, 128, 133, 135, 0, 0, 0, 128, 5, 143, 133, 143, 0, 0, 0, 135, 21, 135, 249,
	128, 5, 142, 133, 142, 0, 0, 0, 128, 121, 128, 149, 135, 9, 128, 137, 135, 5, 128, 133, 135, 0, 0, 0,
	136, 21, 136, 249, 143, 5, 136, 133, 128, 21, 128, 249, 143, 0, 0, 0, 143, 9, 136, 137, 136, 149, 143,
	5, 128, 133, 128, 149, 143, 0, 0, 0, 143, 5, 136, 133, 136, 249, 143, 9, 128, 137, 128, 249, 143, 0,
	0, 0, 128, 9, 135, 137, 135, 149, 128, 5, 150, 133, 143, 21, 143, 137, 150, 137, 150, 0, 0, 0, 128,
	5, 135, 133, 135, 249, 128, 9, 150, 137, 143, 121, 143, 133, 150, 133, 150, 0, 0, 0, 143, 5, 136,
	133, 136, 249, 128, 21, 128, 249, 143, 9, 136, 137, 136, 149, 143, 0, 0, 0, 128, 9, 150, 137, 128, 5,
	150, 133, 150, 0, 0, 0, 128, 5, 135, 133, 135, 249, 128, 9, 135, 137, 135, 149, 143, 21, 143, 137,
	150, 137, 143, 121, 143, 133, 150, 133, 150, 0, 0, 0, 128, 9, 135, 137, 135, 149, 142, 9, 135, 137,
	128, 5, 142, 133, 142, 0, 0, 0, 128, 9, 143, 137, 141, 21, 141, 137, 133, 21, 133, 137, 143, 0, 0, 0,
	128, 5, 135, 133, 135, 249, 142, 5, 135, 133, 128, 9, 142, 137, 142, 0, 0, 0, 128, 5, 143, 133, 141,
	121, 141, 133, 133, 121, 133, 133, 143, 0, 0, 0, 143, 9, 128, 137, 128, 149, 136, 9, 136, 149, 143, 0,
	0, 0, 135, 5, 128, 133, 128, 149, 135, 9, 128, 137, 135, 0, 0, 0, 135, 9, 128, 137, 128, 249, 135, 5,
	128, 133, 135, 0, 0, 0, 143, 5, 128, 133, 128, 249, 136, 5, 136, 249, 255, 0, 255, 128, 143, 0, 0, 0,
	135, 21, 135, 249, 128, 5, 150, 133, 143, 21, 143, 249, 151, 0, 0, 0, 135, 121, 135, 149, 128, 9, 142,
	137, 128, 5, 142, 133, 142, 0, 0, 0, 128, 9, 135, 137, 135, 149, 138, 0, 0, 0, 135, 5, 128, 133, 128,
	249, 135, 0, 0, 0, 128, 21, 143, 149, 143, 128, 128, 128, 128, 149, 129, 21, 129, 128, 130, 21, 130,
	128, 131, 21, 131, 128, 132, 21, 132, 128, 133, 21, 133, 128, 134, 21, 134, 128, 135, 21, 135, 128,
	136, 21, 136, 128, 137, 21, 137, 128, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141,
	21, 141, 128, 142, 21, 142, 128, 143, 21, 143, 128, 138, 12, 136, 140, 128, 11, 143, 139, 143, 0, 0,
	0, 143, 0, 128, 128, 128, 139, 143, 139, 143, 128, 129, 11, 129, 128, 130, 11, 130, 128, 131, 11,
	131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134, 0, 134, 139, 135, 11, 135, 128, 136, 11, 136,
	128, 137, 11, 137, 128, 138, 11, 138, 128, 139, 11, 139, 128, 140, 0, 140, 139, 141, 11, 141, 128,
	142, 11, 142, 128, 143, 0, 0, 0, 128, 0, 128, 149, 136, 149, 136, 128, 128, 128, 129, 21, 129, 128,
	130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128, 133, 21, 133, 128, 134, 21, 134, 128, 135,
	21, 135, 128, 136, 0, 0, 0, 137, 0, 137, 149, 145, 149, 145, 128, 137, 128, 138, 21, 138, 128, 139,
	21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142, 21, 142, 128, 143, 21, 143, 128, 144, 21,
	144, 128, 145, 0, 0, 0, 143, 10, 128, 138, 128, 149, 143, 149, 143, 138, 129, 21, 129, 138, 130, 21,
	130, 138, 131, 21, 131, 138, 132, 21, 132, 138, 133, 21, 133, 138, 134, 10, 134, 149, 135, 21, 135,
	138, 136, 21, 136, 138, 137, 21, 137, 138, 138, 21, 138, 138, 139, 21, 139, 138, 140, 10, 140, 149,
	141, 21, 141, 138, 142, 21, 142, 138, 143, 0, 0, 0, 140, 0, 136, 136, 134, 137, 132, 137, 130, 136,
	129, 135, 128, 133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 137, 132, 140, 137,
	143, 0, 0, 0, 128, 125, 128, 138, 135, 138, 136, 137, 136, 135, 134, 134, 128, 134, 134, 6, 136, 133,
	136, 130, 135, 129, 128, 129, 139, 0, 0, 0, 128, 0, 128, 138, 135, 138, 135, 136, 137, 0, 0, 0, 131,
	10, 131, 128, 136, 10, 136, 128, 128, 10, 138, 138, 140, 0, 0, 0, 140, 2, 140, 128, 128, 128, 136,
	139, 128, 149, 140, 149, 140, 147, 143, 0, 0, 0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128,
	131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 132,
	9, 135, 139, 145, 139, 147, 0, 0, 0, 135, 5, 137, 137, 135, 131, 135, 129, 136, 128, 138, 128, 140,
	129, 142, 131, 144, 134, 145, 9, 143, 131, 143, 129, 144, 128, 145, 128, 147, 129, 148, 130, 150,
	133, 135, 2, 133, 252, 130, 248, 153, 0, 0, 0, 137, 125, 137, 134, 135, 137, 132, 137, 129, 136, 128,
	133, 137, 4, 142, 137, 144, 0, 0, 0, 133, 14, 133, 149, 128, 21, 138, 149, 134, 14, 132, 142, 130,
	141, 129, 140, 128, 138, 128, 136, 129, 134, 131, 133, 133, 133, 135, 134, 136, 135, 137, 137, 137,
	139, 136, 141, 134, 142, 132, 5, 132, 254, 128, 126, 137, 254, 140, 0, 0, 0, 137, 21, 134, 148, 132,
	146, 130, 143, 129, 141, 128, 137, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137, 129, 139,
	131, 141, 134, 142, 136, 143, 140, 143, 144, 142, 147, 141, 148, 139, 149, 137, 149, 129, 11, 142,
	139, 146, 0, 0, 0, 142, 0, 137, 128, 137, 132, 138, 134, 139, 135, 141, 136, 142, 138, 142, 140, 141,
	145, 139, 148, 136, 149, 134, 149, 131, 148, 129, 145, 128, 140, 128, 138, 129, 136, 131, 135, 132,
	134, 133, 132, 133, 128, 128, 128, 145, 0, 0, 0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128,
	131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 136,
	8, 128, 149, 137, 149, 137, 147, 140, 0, 0, 0, 134, 9, 132, 137, 130, 136, 129, 135, 128, 133, 128,
	131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 137, 132, 137, 134, 136, 136, 134, 137, 143,
	9, 141, 137, 139, 136, 138, 135, 137, 133, 137, 131, 138, 129, 140, 128, 142, 128, 144, 129, 145,
	130, 146, 132, 146, 134, 145, 136, 143, 137, 149, 0, 0, 0, 134, 9, 132, 137, 130, 136, 129, 135, 128,
	133, 128, 131, 129, 129, 131, 128, 133, 128, 135, 129, 136, 130, 137, 132, 137, 134, 136, 136, 134,
	137, 133, 136, 133, 134, 134, 132, 136, 131, 139, 131, 141, 132, 142, 133, 138, 9, 128, 255, 142, 0,
	0, 0, 140, 21, 131, 149, 128, 147, 128, 139, 136, 139, 140, 0, 131, 128, 128, 130, 128, 139, 143,
	0, 0, 0, 142, 0, 142, 140, 141, 145, 139, 148, 136, 149, 134, 149, 131, 148, 129, 145, 128, 140,
	128, 128, 169, 126, 169, 254, 145, 0, 0, 0, 128, 9, 146, 137, 128, 13, 146, 141, 128, 5, 146, 133,
	149, 0, 0, 0, 128, 0, 146, 128, 137, 21, 137, 131, 128, 12, 146, 140, 149, 0, 0, 0, 128, 0, 146, 128,
	128, 21, 146, 140, 128, 131, 149, 0, 0, 0, 146, 0, 128, 128, 146, 21, 128, 140, 146, 131, 150, 0, 0, 0,
	128, 122, 128, 146, 130, 148, 132, 149, 137, 149, 139, 148, 140, 147, 143, 0, 0, 0, 140, 21, 140,
	253, 138, 251, 136, 250, 131, 250, 129, 251, 128, 252, 143, 0, 0, 0, 137, 21, 136, 148, 137, 147,
	138, 148, 137, 149, 137, 2, 136, 129, 137, 128, 138, 129, 137, 130, 128, 11, 146, 139, 149, 0, 0, 0,
	128, 13, 130, 143, 132, 144, 134, 144, 135, 143, 136, 141, 137, 140, 139, 139, 140, 139, 141, 140,
	142, 142, 142, 139, 140, 138, 139, 138, 137, 139, 135, 141, 133, 142, 131, 142, 128, 141, 128, 5,
	130, 135, 132, 136, 134, 136, 135, 135, 136, 133, 137, 132, 139, 131, 140, 131, 141, 132, 142, 134,
	142, 131, 140, 130, 139, 130, 137, 131, 135, 133, 133, 134, 131, 134, 128, 133, 133, 2, 133, 130,
	145, 0, 0, 0, 134, 21, 132, 149, 130, 148, 129, 147, 128, 145, 128, 143, 129, 141, 131, 140, 133,
	140, 135, 141, 136, 142, 137, 144, 137, 146, 136, 148, 134, 149, 139, 0, 0, 0, 131, 0, 131, 132, 128,
	132, 128, 128, 131, 128, 130, 4, 130, 128, 129, 4, 129, 128, 128, 2, 131, 130, 134, 0, 0, 0, 128, 0,
	131, 128, 131, 130, 128, 130, 128, 128, 130, 2, 130, 128, 129, 2, 129, 128, 134, 0, 0, 0, 128, 9, 137,
	128, 137, 149, 147, 149, 147, 147, 150, 0, 0, 0, 128, 17, 130, 148, 132, 149, 133, 148, 133, 147,
	132, 143, 131, 140, 132, 15, 133, 145, 135, 148, 137, 149, 139, 149, 140, 148, 140, 146, 139, 143,
	139, 141, 140, 140, 141, 140, 143, 141, 144, 142, 146, 145, 149, 0, 0, 0, 136, 11, 128, 139, 134,
	143, 136, 145, 136, 147, 134, 149, 131, 149, 129, 148, 128, 147, 128, 146, 139, 0, 0, 0, 128, 0, 128,
	139, 135, 139, 135, 128, 128, 128, 129, 11, 129, 128, 130, 11, 130, 128, 131, 11, 131, 128, 132, 11,
	132, 128, 133, 11, 133, 128, 134, 0, 134, 139, 138, 0, 0, 0
};
static const unsigned char Simplex[8437] = /* binary data included from SIMP.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 83,
	73, 77, 80, 117, 32, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 28, 0, 249, 0, 0, 0, 0, 0, 0, 0, 4, 0, 22, 0, 58, 0, 78, 0, 158, 0, 220, 0, 60,
	1, 78, 1, 118, 1, 158, 1, 174, 1, 186, 1, 206, 1, 214, 1, 228, 1, 236, 1, 18, 2, 32, 2, 64, 2, 98, 2,
	110, 2, 148, 2, 198, 2, 208, 2, 14, 3, 64, 3, 88, 3, 118, 3, 128, 3, 140, 3, 150, 3, 192, 3, 44, 4, 58, 4,
	104, 4, 144, 4, 176, 4, 192, 4, 208, 4, 254, 4, 14, 5, 22, 5, 46, 5, 62, 5, 74, 5, 94, 5, 110, 5, 156, 5,
	182, 5, 232, 5, 8, 6, 52, 6, 64, 6, 88, 6, 100, 6, 120, 6, 132, 6, 146, 6, 162, 6, 182, 6, 190, 6, 210, 6,
	226, 6, 234, 6, 252, 6, 32, 7, 68, 7, 100, 7, 136, 7, 174, 7, 192, 7, 238, 7, 4, 8, 22, 8, 46, 8, 62, 8, 70,
	8, 106, 8, 128, 8, 166, 8, 202, 8, 238, 8, 0, 9, 38, 9, 56, 9, 78, 9, 90, 9, 110, 9, 122, 9, 142, 9, 158,
	9, 236, 9, 244, 9, 66, 10, 78, 10, 98, 10, 162, 10, 204, 10, 0, 11, 46, 11, 102, 11, 152, 11, 202, 11,
	248, 11, 40, 12, 98, 12, 150, 12, 178, 12, 196, 12, 218, 12, 252, 12, 24, 13, 54, 13, 124, 13, 148, 13,
	196, 13, 254, 13, 50, 14, 82, 14, 118, 14, 158, 14, 224, 14, 12, 15, 54, 15, 82, 15, 134, 15, 174, 15,
	206, 15, 0, 16, 22, 16, 74, 16, 110, 16, 140, 16, 160, 16, 200, 16, 238, 16, 24, 17, 42, 17, 60, 17, 94,
	17, 118, 17, 136, 17, 152, 17, 168, 17, 168, 18, 164, 20, 208, 22, 216, 22, 228, 22, 244, 22, 4, 23,
	18, 23, 32, 23, 56, 23, 68, 23, 84, 23, 100, 23, 114, 23, 128, 23, 138, 23, 148, 23, 162, 23, 176, 23,
	188, 23, 196, 23, 208, 23, 224, 23, 240, 23, 0, 24, 16, 24, 36, 24, 56, 24, 76, 24, 88, 24, 116, 24,
	134, 24, 150, 24, 168, 24, 184, 24, 198, 24, 212, 24, 226, 24, 240, 24, 0, 25, 16, 25, 26, 25, 36, 25,
	118, 25, 192, 25, 234, 25, 18, 26, 92, 26, 126, 26, 156, 26, 168, 26, 184, 26, 202, 26, 242, 26, 14,
	27, 38, 27, 96, 27, 146, 27, 190, 27, 232, 27, 40, 28, 82, 28, 104, 28, 128, 28, 144, 28, 160, 28,
	174, 28, 188, 28, 206, 28, 224, 28, 252, 28, 16, 29, 54, 29, 76, 29, 100, 29, 114, 29, 136, 29, 158,
	29, 12, 6, 14, 18, 17, 21, 22, 6, 10, 11, 13, 22, 22, 22, 9, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	6, 6, 20, 22, 20, 15, 24, 19, 17, 19, 17, 15, 14, 18, 18, 4, 14, 17, 13, 20, 18, 19, 17, 19, 17, 17, 15,
	18, 17, 22, 17, 17, 17, 7, 14, 8, 19, 17, 6, 16, 15, 15, 16, 15, 10, 16, 15, 7, 9, 13, 4, 26, 15, 16, 15,
	16, 9, 14, 10, 15, 14, 19, 14, 15, 14, 10, 4, 9, 14, 16, 18, 15, 15, 18, 16, 16, 16, 15, 18, 15, 15, 12,
	16, 7, 17, 17, 15, 28, 26, 16, 16, 16, 17, 15, 15, 19, 18, 16, 21, 19, 21, 22, 16, 7, 16, 15, 17, 18, 16,
	16, 15, 16, 16, 19, 19, 6, 19, 19, 14, 16, 24, 5, 13, 13, 21, 21, 13, 21, 20, 21, 21, 21, 13, 0, 8, 16,
	16, 8, 16, 16, 8, 16, 16, 16, 24, 24, 16, 16, 24, 16, 16, 16, 16, 16, 8, 8, 16, 24, 16, 13, 8, 16, 16, 8,
	17, 16, 22, 18, 14, 18, 18, 24, 18, 18, 18, 21, 21, 18, 29, 16, 17, 19, 23, 23, 23, 24, 13, 14, 23, 18,
	18, 7, 7, 18, 15, 11, 13, 140, 0, 0, 0, 129, 21, 129, 135, 129, 2, 128, 129, 129, 128, 130, 129, 129,
	130, 134, 0, 0, 0, 129, 21, 128, 148, 128, 142, 129, 20, 128, 142, 129, 21, 130, 148, 128, 142, 138,
	21, 137, 148, 137, 142, 138, 20, 137, 142, 138, 21, 139, 148, 137, 142, 142, 0, 0, 0, 136, 21, 129,
	249, 142, 21, 135, 249, 129, 10, 143, 138, 128, 4, 142, 132, 146, 0, 0, 0, 133, 25, 133, 252, 137, 25,
	137, 252, 141, 18, 140, 145, 141, 144, 142, 145, 142, 146, 140, 148, 137, 149, 133, 149, 130, 148,
	128, 146, 128, 144, 129, 142, 130, 141, 132, 140, 138, 138, 140, 137, 142, 135, 128, 16, 130, 142,
	132, 141, 138, 139, 140, 138, 141, 137, 142, 135, 142, 131, 140, 129, 137, 128, 133, 128, 130, 129,
	128, 131, 128, 132, 129, 133, 130, 132, 129, 131, 145, 0, 0, 0, 146, 21, 128, 128, 133, 21, 135, 147,
	135, 145, 134, 143, 132, 142, 130, 142, 128, 144, 128, 146, 129, 148, 131, 149, 133, 149, 135, 148,
	138, 147, 141, 147, 144, 148, 146, 149, 142, 7, 140, 134, 139, 132, 139, 130, 141, 128, 143, 128,
	145, 129, 146, 131, 146, 133, 144, 135, 142, 135, 149, 0, 0, 0, 146, 13, 145, 140, 146, 139, 147,
	140, 147, 141, 146, 142, 145, 142, 144, 141, 143, 139, 141, 134, 139, 131, 137, 129, 135, 128, 132,
	128, 129, 129, 128, 131, 128, 134, 129, 136, 135, 140, 137, 142, 138, 144, 138, 146, 137, 148, 135,
	149, 133, 148, 132, 146, 132, 144, 133, 141, 135, 138, 140, 131, 142, 129, 145, 128, 146, 128, 147,
	129, 147, 130, 132, 0, 130, 129, 129, 131, 129, 134, 130, 136, 132, 138, 132, 16, 133, 142, 141,
	131, 143, 129, 145, 128, 150, 0, 0, 0, 129, 19, 128, 148, 129, 149, 130, 148, 130, 146, 129, 144,
	128, 143, 134, 0, 0, 0, 135, 25, 133, 151, 131, 148, 129, 144, 128, 139, 128, 135, 129, 130, 131,
	254, 133, 251, 135, 249, 133, 23, 131, 147, 130, 144, 129, 139, 129, 135, 130, 130, 131, 255, 133,
	251, 138, 0, 0, 0, 128, 25, 130, 151, 132, 148, 134, 144, 135, 139, 135, 135, 134, 130, 132, 254,
	130, 251, 128, 249, 130, 23, 132, 147, 133, 144, 134, 139, 134, 135, 133, 130, 132, 255, 130, 251,
	139, 0, 0, 0, 133, 21, 133, 137, 128, 18, 138, 140, 138, 18, 128, 140, 141, 0, 0, 0, 137, 18, 137, 128,
	128, 9, 146, 137, 150, 0, 0, 0, 130, 1, 129, 128, 128, 129, 129, 130, 130, 129, 130, 255, 129, 253,
	128, 252, 150, 0, 0, 0, 128, 9, 146, 137, 150, 0, 0, 0, 129, 2, 128, 129, 129, 128, 130, 129, 129, 130,
	137, 0, 0, 0, 128, 125, 142, 149, 142, 0, 0, 0, 134, 21, 131, 148, 129, 145, 128, 140, 128, 137, 129,
	132, 131, 129, 134, 128, 136, 128, 139, 129, 141, 132, 142, 137, 142, 140, 141, 145, 139, 148, 136,
	149, 134, 149, 150, 0, 0, 0, 132, 17, 134, 146, 137, 149, 137, 128, 148, 0, 150, 0, 0, 0, 129, 16, 129,
	145, 130, 147, 131, 148, 133, 149, 137, 149, 139, 148, 140, 147, 141, 145, 141, 143, 140, 141, 138,
	138, 128, 128, 142, 128, 150, 0, 0, 0, 130, 21, 141, 149, 135, 141, 138, 141, 140, 140, 141, 139,
	142, 136, 142, 134, 141, 131, 139, 129, 136, 128, 133, 128, 130, 129, 129, 130, 128, 132, 150, 0, 0,
	0, 138, 0, 138, 149, 128, 135, 143, 135, 150, 0, 0, 0, 140, 21, 130, 149, 129, 140, 130, 141, 133,
	142, 136, 142, 139, 141, 141, 139, 142, 136, 142, 134, 141, 131, 139, 129, 136, 128, 133, 128, 130,
	129, 129, 130, 128, 132, 150, 0, 0, 0, 140, 18, 139, 148, 136, 149, 134, 149, 131, 148, 129, 145,
	128, 140, 128, 135, 129, 131, 131, 129, 134, 128, 135, 128, 138, 129, 140, 131, 141, 134, 141, 135,
	140, 138, 138, 140, 135, 141, 134, 141, 131, 140, 129, 138, 128, 135, 150, 0, 0, 0, 128, 21, 142,
	149, 132, 128, 150, 0, 0, 0, 133, 21, 130, 148, 129, 146, 129, 144, 130, 142, 132, 141, 136, 140,
	139, 139, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130, 129, 129, 130,
	128, 132, 128, 135, 129, 137, 131, 139, 134, 140, 138, 141, 140, 142, 141, 144, 141, 146, 140, 148,
	137, 149, 133, 149, 150, 0, 0, 0, 141, 14, 140, 139, 138, 137, 135, 136, 134, 136, 131, 137, 129,
	139, 128, 142, 128, 143, 129, 146, 131, 148, 134, 149, 135, 149, 138, 148, 140, 146, 141, 142, 141,
	137, 140, 132, 138, 129, 135, 128, 133, 128, 130, 129, 129, 131, 150, 0, 0, 0, 129, 14, 128, 141,
	129, 140, 130, 141, 129, 142, 129, 2, 128, 129, 129, 128, 130, 129, 129, 130, 134, 0, 0, 0, 129, 14,
	128, 141, 129, 140, 130, 141, 129, 142, 130, 1, 129, 128, 128, 129, 129, 130, 130, 129, 130, 255,
	129, 253, 128, 252, 134, 0, 0, 0, 144, 18, 128, 137, 144, 128, 148, 0, 0, 0, 128, 12, 146, 140, 128, 6,
	146, 134, 150, 0, 0, 0, 128, 18, 144, 137, 128, 128, 148, 0, 0, 0, 128, 16, 128, 145, 129, 147, 130,
	148, 132, 149, 136, 149, 138, 148, 139, 147, 140, 145, 140, 143, 139, 141, 138, 140, 134, 138, 134,
	135, 134, 2, 133, 129, 134, 128, 135, 129, 134, 130, 143, 0, 0, 0, 143, 13, 142, 143, 140, 144, 137,
	144, 135, 143, 134, 142, 133, 139, 133, 136, 134, 134, 136, 133, 139, 133, 141, 134, 142, 136, 137,
	16, 135, 142, 134, 139, 134, 136, 135, 134, 136, 133, 143, 16, 142, 136, 142, 134, 144, 133, 146,
	133, 148, 135, 149, 138, 149, 140, 148, 143, 147, 145, 145, 147, 143, 148, 140, 149, 137, 149, 134,
	148, 132, 147, 130, 145, 129, 143, 128, 140, 128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137,
	128, 140, 128, 143, 129, 145, 130, 146, 131, 144, 16, 143, 136, 143, 134, 144, 133, 152, 0, 0, 0,
	144, 0, 136, 149, 128, 128, 131, 7, 141, 135, 147, 0, 0, 0, 128, 21, 128, 128, 128, 21, 137, 149, 140,
	148, 141, 147, 142, 145, 142, 143, 141, 141, 140, 140, 137, 139, 128, 11, 137, 139, 140, 138, 141,
	137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 128, 128, 145, 0, 0, 0, 143, 16, 142, 146,
	140, 148, 138, 149, 134, 149, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131,
	132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133, 147, 0, 0, 0, 128, 21, 128, 128, 128, 21,
	135, 149, 138, 148, 140, 146, 141, 144, 142, 141, 142, 136, 141, 133, 140, 131, 138, 129, 135, 128,
	128, 128, 145, 0, 0, 0, 141, 21, 128, 149, 128, 128, 141, 128, 128, 11, 136, 139, 143, 0, 0, 0, 128,
	21, 128, 128, 128, 21, 141, 149, 128, 11, 136, 139, 142, 0, 0, 0, 143, 16, 142, 146, 140, 148, 138,
	149, 134, 149, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134,
	128, 138, 128, 140, 129, 142, 131, 143, 133, 143, 136, 138, 8, 143, 136, 146, 0, 0, 0, 128, 21, 128,
	128, 142, 21, 142, 128, 128, 11, 142, 139, 146, 0, 0, 0, 128, 21, 128, 128, 132, 0, 0, 0, 138, 21, 138,
	133, 137, 130, 136, 129, 134, 128, 132, 128, 130, 129, 129, 130, 128, 133, 128, 135, 142, 0, 0, 0,
	128, 21, 128, 128, 142, 21, 128, 135, 133, 12, 142, 128, 145, 0, 0, 0, 128, 21, 128, 128, 128, 0, 140,
	128, 141, 0, 0, 0, 128, 21, 128, 128, 128, 21, 136, 128, 144, 21, 136, 128, 144, 21, 144, 128, 148, 0,
	0, 0, 128, 21, 128, 128, 128, 21, 142, 128, 142, 21, 142, 128, 146, 0, 0, 0, 134, 21, 132, 148, 130,
	146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142,
	131, 143, 133, 144, 136, 144, 141, 143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 147, 0, 0, 0,
	128, 10, 137, 138, 140, 139, 141, 140, 142, 142, 142, 145, 141, 147, 140, 148, 137, 149, 128, 149,
	128, 128, 145, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130,
	131, 132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133, 144, 136, 144, 141, 143, 144, 142,
	146, 140, 148, 138, 149, 134, 149, 137, 4, 143, 254, 147, 0, 0, 0, 128, 21, 128, 128, 128, 21, 137,
	149, 140, 148, 141, 147, 142, 145, 142, 143, 141, 141, 140, 140, 137, 139, 128, 139, 135, 11, 142,
	128, 145, 0, 0, 0, 142, 18, 140, 148, 137, 149, 133, 149, 130, 148, 128, 146, 128, 144, 129, 142,
	130, 141, 132, 140, 138, 138, 140, 137, 141, 136, 142, 134, 142, 131, 140, 129, 137, 128, 133, 128,
	130, 129, 128, 131, 145, 0, 0, 0, 135, 21, 135, 128, 128, 21, 142, 149, 143, 0, 0, 0, 128, 21, 128,
	134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 149, 146, 0, 0, 0,
	128, 21, 136, 128, 144, 21, 136, 128, 145, 0, 0, 0, 128, 21, 133, 128, 138, 21, 133, 128, 138, 21,
	143, 128, 148, 21, 143, 128, 150, 0, 0, 0, 128, 21, 142, 128, 142, 21, 128, 128, 145, 0, 0, 0, 128, 21,
	136, 139, 136, 128, 144, 21, 136, 139, 145, 0, 0, 0, 142, 21, 128, 128, 128, 21, 142, 149, 128, 0,
	142, 128, 145, 0, 0, 0, 128, 19, 128, 255, 129, 19, 129, 255, 128, 19, 133, 147, 128, 127, 133, 255,
	135, 0, 0, 0, 128, 21, 142, 253, 142, 0, 0, 0, 132, 19, 132, 255, 133, 19, 133, 255, 128, 19, 133, 147,
	128, 127, 133, 255, 136, 0, 0, 0, 136, 18, 131, 142, 136, 147, 141, 142, 136, 146, 136, 146, 147, 0,
	0, 0, 128, 121, 144, 249, 145, 0, 0, 0, 130, 21, 129, 148, 128, 146, 128, 144, 129, 143, 130, 144,
	129, 145, 134, 0, 0, 0, 140, 14, 140, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 144, 0, 0, 0, 128,
	21, 128, 128, 128, 11, 130, 141, 132, 142, 135, 142, 137, 141, 139, 139, 140, 136, 140, 134, 139,
	131, 137, 129, 135, 128, 132, 128, 130, 129, 128, 131, 143, 0, 0, 0, 140, 11, 138, 141, 136, 142,
	133, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129,
	140, 131, 143, 0, 0, 0, 140, 21, 140, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 144, 0, 0, 0, 128, 8,
	140, 136, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134,
	129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 143, 0, 0, 0, 136, 21, 134, 149, 132,
	148, 131, 145, 131, 128, 128, 14, 135, 142, 138, 0, 0, 0, 140, 14, 140, 254, 139, 251, 138, 250, 136,
	249, 133, 249, 131, 250, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128,
	134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 144, 0, 0, 0, 128, 21, 128, 128,
	128, 10, 131, 141, 133, 142, 136, 142, 138, 141, 139, 138, 139, 128, 143, 0, 0, 0, 130, 21, 131, 148,
	132, 149, 131, 150, 130, 149, 131, 14, 131, 128, 135, 0, 0, 0, 132, 21, 133, 148, 134, 149, 133, 150,
	132, 149, 133, 14, 133, 253, 132, 250, 130, 249, 128, 249, 137, 0, 0, 0, 128, 21, 128, 128, 138, 14,
	128, 132, 132, 8, 139, 128, 141, 0, 0, 0, 128, 21, 128, 128, 132, 0, 0, 0, 128, 14, 128, 128, 128, 10,
	131, 141, 133, 142, 136, 142, 138, 141, 139, 138, 139, 128, 139, 10, 142, 141, 144, 142, 147, 142,
	149, 141, 150, 138, 150, 128, 154, 0, 0, 0, 128, 14, 128, 128, 128, 10, 131, 141, 133, 142, 136, 142,
	138, 141, 139, 138, 139, 128, 143, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129,
	131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136,
	142, 133, 142, 144, 0, 0, 0, 128, 14, 128, 249, 128, 11, 130, 141, 132, 142, 135, 142, 137, 141, 139,
	139, 140, 136, 140, 134, 139, 131, 137, 129, 135, 128, 132, 128, 130, 129, 128, 131, 143, 0, 0, 0,
	140, 14, 140, 249, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134,
	129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 144, 0, 0, 0, 128, 14, 128, 128, 128, 8,
	129, 139, 131, 141, 133, 142, 136, 142, 137, 0, 0, 0, 139, 11, 138, 141, 135, 142, 132, 142, 129,
	141, 128, 139, 129, 137, 131, 136, 136, 135, 138, 134, 139, 132, 139, 131, 138, 129, 135, 128, 132,
	128, 129, 129, 128, 131, 142, 0, 0, 0, 131, 21, 131, 132, 132, 129, 134, 128, 136, 128, 128, 14, 135,
	142, 138, 0, 0, 0, 128, 14, 128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132, 139, 14, 139,
	128, 143, 0, 0, 0, 128, 14, 134, 128, 140, 14, 134, 128, 142, 0, 0, 0, 128, 14, 132, 128, 136, 14, 132,
	128, 136, 14, 140, 128, 144, 14, 140, 128, 147, 0, 0, 0, 128, 14, 139, 128, 139, 14, 128, 128, 142, 0,
	0, 0, 129, 14, 135, 128, 141, 14, 135, 128, 133, 252, 131, 250, 129, 249, 128, 249, 143, 0, 0, 0,
	139, 14, 128, 128, 128, 14, 139, 142, 128, 0, 139, 128, 142, 0, 0, 0, 133, 25, 131, 152, 130, 151,
	129, 149, 129, 147, 130, 145, 131, 144, 132, 142, 132, 140, 130, 138, 131, 24, 130, 150, 130, 148,
	131, 146, 132, 145, 133, 143, 133, 141, 132, 139, 128, 137, 132, 135, 133, 133, 133, 131, 132, 129,
	131, 128, 130, 254, 130, 252, 131, 250, 130, 8, 132, 134, 132, 132, 131, 130, 130, 129, 129, 255,
	129, 253, 130, 251, 131, 250, 133, 249, 138, 0, 0, 0, 128, 21, 128, 128, 132, 0, 0, 0, 128, 25, 130,
	152, 131, 151, 132, 149, 132, 147, 131, 145, 130, 144, 129, 142, 129, 140, 131, 138, 130, 24, 131,
	150, 131, 148, 130, 146, 129, 145, 128, 143, 128, 141, 129, 139, 133, 137, 129, 135, 128, 133, 128,
	131, 129, 129, 130, 128, 131, 254, 131, 252, 130, 250, 131, 8, 129, 134, 129, 132, 130, 130, 131,
	129, 132, 255, 132, 253, 131, 251, 130, 250, 128, 249, 137, 0, 0, 0, 128, 16, 133, 147, 137, 144,
	141, 146, 142, 0, 0, 0, 128, 7, 128, 128, 140, 128, 140, 135, 134, 144, 128, 135, 134, 6, 134, 134,
	144, 0, 0, 0, 143, 16, 142, 146, 140, 148, 138, 149, 134, 149, 132, 148, 130, 146, 129, 144, 128,
	141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133, 136,
	0, 136, 255, 135, 255, 135, 128, 131, 124, 131, 250, 132, 249, 138, 249, 140, 251, 140, 252, 138,
	254, 136, 255, 146, 0, 0, 0, 128, 14, 128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132,
	139, 14, 139, 128, 130, 19, 129, 146, 130, 145, 131, 146, 130, 147, 138, 19, 137, 146, 138, 145,
	139, 146, 138, 147, 143, 0, 0, 0, 128, 8, 140, 136, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142,
	131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131,
	138, 22, 137, 149, 136, 150, 137, 151, 138, 150, 138, 148, 133, 145, 143, 0, 0, 0, 141, 14, 141, 128,
	141, 11, 139, 141, 137, 142, 134, 142, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129,
	134, 128, 137, 128, 139, 129, 141, 131, 131, 16, 136, 149, 141, 144, 136, 148, 131, 144, 146, 0, 0,
	0, 140, 14, 140, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128,
	134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 130, 19, 129, 146, 130, 145, 131,
	146, 130, 147, 138, 19, 137, 146, 138, 145, 139, 146, 138, 147, 144, 0, 0, 0, 140, 14, 140, 128, 140,
	11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133,
	128, 136, 128, 138, 129, 140, 131, 131, 22, 132, 149, 133, 150, 132, 151, 131, 150, 131, 148, 136,
	145, 144, 0, 0, 0, 140, 14, 140, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128,
	136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 133, 19, 132, 146, 133,
	145, 135, 145, 136, 146, 135, 147, 133, 147, 144, 0, 0, 0, 140, 11, 138, 141, 136, 142, 133, 142,
	131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131,
	134, 0, 134, 255, 137, 254, 138, 251, 136, 249, 132, 249, 131, 251, 143, 0, 0, 0, 130, 8, 142, 136,
	142, 138, 141, 140, 140, 141, 138, 142, 135, 142, 133, 141, 131, 139, 130, 136, 130, 134, 131, 131,
	133, 129, 135, 128, 138, 128, 140, 129, 142, 131, 132, 16, 137, 149, 142, 144, 137, 148, 132, 144,
	146, 0, 0, 0, 128, 8, 140, 136, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 131, 19, 130, 146,
	131, 145, 132, 146, 131, 147, 139, 19, 138, 146, 139, 145, 140, 146, 139, 147, 143, 0, 0, 0, 128, 8,
	140, 136, 140, 138, 139, 140, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134,
	129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 130, 22, 131, 149, 132, 150, 131, 151,
	130, 150, 130, 148, 135, 145, 143, 0, 0, 0, 133, 14, 133, 128, 129, 19, 128, 146, 129, 145, 130, 146,
	129, 147, 137, 19, 136, 146, 137, 145, 138, 146, 137, 147, 140, 0, 0, 0, 136, 14, 136, 128, 131, 16,
	136, 149, 141, 144, 136, 148, 131, 144, 144, 0, 0, 0, 133, 14, 133, 128, 128, 22, 129, 149, 130, 150,
	129, 151, 128, 150, 128, 148, 133, 145, 135, 0, 0, 0, 144, 0, 136, 149, 128, 128, 131, 7, 141, 135,
	132, 25, 131, 152, 132, 151, 133, 152, 132, 153, 140, 25, 139, 152, 140, 151, 141, 152, 140, 153,
	145, 0, 0, 0, 144, 0, 136, 149, 128, 128, 131, 7, 141, 135, 135, 26, 134, 153, 135, 152, 137, 152,
	138, 153, 137, 154, 135, 154, 145, 0, 0, 0, 141, 21, 128, 149, 128, 128, 141, 128, 128, 11, 136, 139,
	138, 27, 137, 154, 136, 155, 137, 156, 138, 155, 138, 153, 133, 150, 143, 0, 0, 0, 140, 14, 140, 128,
	140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129,
	133, 128, 136, 128, 138, 129, 140, 131, 145, 14, 148, 142, 150, 141, 151, 140, 152, 138, 152, 136,
	140, 136, 141, 139, 143, 141, 145, 142, 140, 6, 141, 131, 143, 129, 145, 128, 148, 128, 150, 129,
	152, 131, 156, 0, 0, 0, 151, 21, 136, 149, 128, 128, 138, 21, 138, 128, 151, 128, 138, 11, 146, 139,
	131, 7, 138, 135, 154, 0, 0, 0, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129,
	134, 128, 137, 128, 139, 129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 137, 142, 134, 142,
	131, 16, 136, 149, 141, 144, 136, 148, 131, 144, 144, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136,
	128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139,
	138, 141, 136, 142, 133, 142, 131, 19, 130, 146, 131, 145, 132, 146, 131, 147, 139, 19, 138, 146,
	139, 145, 140, 146, 139, 147, 144, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129,
	131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136,
	142, 133, 142, 130, 22, 131, 149, 132, 150, 131, 151, 130, 150, 130, 148, 135, 145, 144, 0, 0, 0,
	130, 14, 130, 132, 131, 129, 133, 128, 136, 128, 138, 129, 141, 132, 141, 14, 141, 128, 131, 16,
	136, 149, 141, 144, 136, 148, 131, 144, 145, 0, 0, 0, 128, 14, 128, 132, 129, 129, 131, 128, 134,
	128, 136, 129, 139, 132, 139, 14, 139, 128, 129, 22, 130, 149, 131, 150, 130, 151, 129, 150, 129,
	148, 134, 145, 143, 0, 0, 0, 129, 14, 135, 128, 133, 252, 131, 250, 129, 249, 128, 249, 141, 14, 135,
	128, 131, 19, 130, 146, 131, 145, 132, 146, 131, 147, 139, 19, 138, 146, 139, 145, 140, 146, 139,
	147, 143, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131,
	132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133, 144, 136, 144, 141, 143, 144, 142, 146,
	140, 148, 138, 149, 134, 149, 132, 26, 131, 153, 132, 152, 133, 153, 132, 154, 140, 26, 139, 153,
	140, 152, 141, 153, 140, 154, 147, 0, 0, 0, 128, 21, 128, 134, 129, 131, 131, 129, 134, 128, 136,
	128, 139, 129, 141, 131, 142, 134, 142, 149, 131, 26, 130, 153, 131, 152, 132, 153, 131, 154, 139,
	26, 138, 153, 139, 152, 140, 153, 139, 154, 146, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136,
	128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139,
	138, 141, 136, 142, 133, 142, 128, 125, 141, 145, 144, 0, 0, 0, 141, 20, 138, 149, 136, 149, 133,
	148, 132, 147, 131, 144, 131, 128, 140, 128, 143, 129, 143, 130, 128, 12, 135, 140, 149, 0, 0, 0,
	134, 21, 132, 148, 130, 146, 129, 144, 128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128,
	138, 128, 140, 129, 142, 131, 143, 133, 144, 136, 144, 141, 143, 144, 142, 146, 140, 148, 138, 149,
	134, 149, 129, 125, 130, 255, 144, 151, 147, 0, 0, 0, 128, 10, 137, 138, 140, 139, 141, 140, 142,
	142, 142, 145, 141, 147, 140, 148, 137, 149, 128, 149, 128, 128, 140, 8, 146, 136, 143, 12, 143,
	130, 144, 128, 146, 128, 147, 129, 149, 0, 0, 0, 129, 124, 131, 251, 134, 251, 136, 252, 138, 255,
	138, 143, 134, 8, 142, 136, 138, 1, 138, 145, 140, 148, 142, 149, 145, 149, 147, 148, 150, 0, 0, 0,
	140, 14, 140, 128, 140, 11, 138, 141, 136, 142, 133, 142, 131, 141, 129, 139, 128, 136, 128, 134,
	129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 138, 22, 137, 149, 136, 150, 137, 151,
	138, 150, 138, 148, 133, 145, 144, 0, 0, 0, 131, 14, 131, 128, 135, 22, 134, 149, 133, 150, 134, 151,
	135, 150, 135, 148, 130, 145, 135, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129,
	131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136,
	142, 133, 142, 139, 22, 138, 149, 137, 150, 138, 151, 139, 150, 139, 148, 134, 145, 144, 0, 0, 0,
	128, 14, 128, 132, 129, 129, 131, 128, 134, 128, 136, 129, 139, 132, 139, 14, 139, 128, 137, 22,
	136, 149, 135, 150, 136, 151, 137, 150, 137, 148, 132, 145, 143, 0, 0, 0, 128, 14, 128, 128, 128, 10,
	131, 141, 133, 142, 136, 142, 138, 141, 139, 138, 139, 128, 128, 17, 133, 148, 137, 145, 141, 147,
	145, 0, 0, 0, 142, 21, 142, 128, 128, 149, 128, 128, 128, 24, 133, 155, 137, 152, 141, 154, 146, 0, 0,
	0, 140, 21, 140, 135, 140, 18, 138, 148, 136, 149, 133, 149, 131, 148, 129, 146, 128, 143, 128,
	141, 129, 138, 131, 136, 133, 135, 136, 135, 138, 136, 140, 138, 128, 0, 140, 128, 144, 0, 0, 0, 128,
	15, 129, 140, 131, 138, 133, 137, 136, 137, 138, 138, 140, 140, 141, 143, 140, 146, 138, 148, 136,
	149, 133, 149, 131, 148, 129, 146, 128, 143, 128, 0, 141, 128, 144, 0, 0, 0, 140, 5, 140, 132, 139,
	130, 138, 129, 136, 128, 132, 128, 130, 129, 129, 130, 128, 132, 128, 134, 129, 136, 130, 137, 134,
	139, 134, 142, 134, 19, 135, 148, 134, 149, 133, 148, 134, 147, 143, 0, 0, 0, 128, 0, 128, 136, 140,
	136, 140, 133, 131, 133, 131, 128, 128, 128, 144, 0, 0, 0, 140, 0, 140, 136, 128, 136, 128, 133, 137,
	133, 137, 128, 140, 128, 144, 0, 0, 0, 128, 18, 131, 149, 132, 149, 132, 140, 137, 6, 137, 135, 139,
	137, 143, 137, 144, 135, 144, 133, 143, 132, 137, 128, 144, 128, 143, 21, 129, 128, 147, 0, 0, 0,
	128, 18, 131, 149, 132, 149, 132, 140, 143, 21, 129, 128, 143, 3, 135, 131, 141, 137, 141, 128, 147,
	0, 0, 0, 129, 0, 129, 142, 129, 19, 128, 148, 129, 149, 130, 148, 129, 147, 134, 0, 0, 0, 135, 17,
	128, 139, 135, 133, 143, 17, 136, 139, 143, 133, 147, 0, 0, 0, 136, 17, 143, 139, 136, 133, 128, 17,
	135, 139, 128, 133, 147, 0, 0, 0, 132, 21, 134, 149, 134, 147, 132, 147, 132, 149, 133, 21, 133, 147,
	132, 15, 134, 143, 134, 141, 132, 141, 132, 143, 133, 15, 133, 141, 132, 9, 134, 137, 134, 135, 132,
	135, 132, 137, 133, 9, 133, 135, 132, 3, 134, 131, 134, 129, 132, 129, 132, 131, 133, 3, 133, 129,
	128, 18, 130, 146, 130, 144, 128, 144, 128, 146, 129, 18, 129, 144, 128, 12, 130, 140, 130, 138,
	128, 138, 128, 140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129,
	132, 128, 0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254, 136, 18, 138, 146, 138, 144,
	136, 144, 136, 146, 137, 18, 137, 144, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12,
	137, 138, 136, 6, 138, 134, 138, 132, 136, 132, 136, 134, 137, 6, 137, 132, 136, 0, 138, 128, 138,
	254, 136, 254, 136, 128, 137, 0, 137, 254, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21,
	141, 147, 140, 15, 142, 143, 142, 141, 140, 141, 140, 143, 141, 15, 141, 141, 140, 9, 142, 137, 142,
	135, 140, 135, 140, 137, 141, 9, 141, 135, 140, 3, 142, 131, 142, 129, 140, 129, 140, 131, 141, 3,
	141, 129, 131, 125, 131, 251, 133, 251, 133, 253, 131, 253, 132, 125, 132, 251, 140, 125, 140, 251,
	142, 251, 142, 253, 140, 253, 141, 125, 141, 251, 142, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128,
	144, 128, 146, 129, 18, 129, 144, 128, 12, 130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129,
	138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129, 132, 128, 0, 130, 128, 130, 254,
	128, 254, 128, 128, 129, 0, 129, 254, 130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131,
	147, 130, 15, 132, 143, 132, 141, 130, 141, 130, 143, 131, 15, 131, 141, 130, 9, 132, 137, 132, 135,
	130, 135, 130, 137, 131, 9, 131, 135, 130, 3, 132, 131, 132, 129, 130, 129, 130, 131, 131, 3, 131,
	129, 132, 18, 134, 146, 134, 144, 132, 144, 132, 146, 133, 18, 133, 144, 132, 12, 134, 140, 134,
	138, 132, 138, 132, 140, 133, 12, 133, 138, 132, 6, 134, 134, 134, 132, 132, 132, 132, 134, 133, 6,
	133, 132, 132, 0, 134, 128, 134, 254, 132, 254, 132, 128, 133, 0, 133, 254, 134, 21, 136, 149, 136,
	147, 134, 147, 134, 149, 135, 21, 135, 147, 134, 15, 136, 143, 136, 141, 134, 141, 134, 143, 135,
	15, 135, 141, 134, 9, 136, 137, 136, 135, 134, 135, 134, 137, 135, 9, 135, 135, 134, 3, 136, 131,
	136, 129, 134, 129, 134, 131, 135, 3, 135, 129, 136, 18, 138, 146, 138, 144, 136, 144, 136, 146,
	137, 18, 137, 144, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138, 136, 6, 138,
	134, 138, 132, 136, 132, 136, 134, 137, 6, 137, 132, 136, 0, 138, 128, 138, 254, 136, 254, 136, 128,
	137, 0, 137, 254, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139, 147, 138, 15, 140,
	143, 140, 141, 138, 141, 138, 143, 139, 15, 139, 141, 138, 9, 140, 137, 140, 135, 138, 135, 138,
	137, 139, 9, 139, 135, 138, 3, 140, 131, 140, 129, 138, 129, 138, 131, 139, 3, 139, 129, 140, 18,
	142, 146, 142, 144, 140, 144, 140, 146, 141, 18, 141, 144, 140, 12, 142, 140, 142, 138, 140, 138,
	140, 140, 141, 12, 141, 138, 140, 6, 142, 134, 142, 132, 140, 132, 140, 134, 141, 6, 141, 132, 140,
	0, 142, 128, 142, 254, 140, 254, 140, 128, 141, 0, 141, 254, 142, 21, 144, 149, 144, 147, 142,
	147, 142, 149, 143, 21, 143, 147, 142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 143, 15, 143,
	141, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143, 135, 142, 3, 144, 131, 144, 129,
	142, 129, 142, 131, 143, 3, 143, 129, 130, 125, 130, 251, 132, 251, 132, 253, 130, 253, 131, 125,
	131, 251, 134, 125, 134, 251, 136, 251, 136, 253, 134, 253, 135, 125, 135, 251, 138, 125, 138, 251,
	140, 251, 140, 253, 138, 253, 139, 125, 139, 251, 142, 125, 142, 251, 144, 251, 144, 253, 142, 253,
	143, 125, 143, 251, 144, 0, 0, 0, 128, 21, 130, 149, 130, 147, 128, 147, 128, 149, 129, 21, 129, 147,
	130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131, 147, 138, 21, 140, 149, 140, 147,
	138, 147, 138, 149, 139, 21, 139, 147, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21,
	141, 147, 148, 21, 150, 149, 150, 147, 148, 147, 148, 149, 149, 21, 149, 147, 150, 21, 152, 149,
	152, 147, 150, 147, 150, 149, 151, 21, 151, 147, 132, 17, 134, 145, 134, 143, 132, 143, 132, 145,
	133, 17, 133, 143, 134, 17, 136, 145, 136, 143, 134, 143, 134, 145, 135, 17, 135, 143, 136, 17, 138,
	145, 138, 143, 136, 143, 136, 145, 137, 17, 137, 143, 128, 13, 130, 141, 130, 139, 128, 139, 128,
	141, 129, 13, 129, 139, 130, 13, 132, 141, 132, 139, 130, 139, 130, 141, 131, 13, 131, 139, 138, 13,
	140, 141, 140, 139, 138, 139, 138, 141, 139, 13, 139, 139, 140, 13, 142, 141, 142, 139, 140, 139,
	140, 141, 141, 13, 141, 139, 148, 13, 150, 141, 150, 139, 148, 139, 148, 141, 149, 13, 149, 139,
	150, 13, 152, 141, 152, 139, 150, 139, 150, 141, 151, 13, 151, 139, 142, 9, 144, 137, 144, 135, 142,
	135, 142, 137, 143, 9, 143, 135, 144, 9, 146, 137, 146, 135, 144, 135, 144, 137, 145, 9, 145, 135,
	146, 9, 148, 137, 148, 135, 146, 135, 146, 137, 147, 9, 147, 135, 128, 5, 130, 133, 130, 131, 128,
	131, 128, 133, 129, 5, 129, 131, 130, 5, 132, 133, 132, 131, 130, 131, 130, 133, 131, 5, 131, 131,
	138, 5, 140, 133, 140, 131, 138, 131, 138, 133, 139, 5, 139, 131, 140, 5, 142, 133, 142, 131, 140,
	131, 140, 133, 141, 5, 141, 131, 148, 5, 150, 133, 150, 131, 148, 131, 148, 133, 149, 5, 149, 131,
	150, 5, 152, 133, 152, 131, 150, 131, 150, 133, 151, 5, 151, 131, 132, 1, 138, 129, 138, 255, 132,
	255, 132, 129, 133, 1, 133, 255, 135, 1, 135, 255, 137, 1, 137, 255, 128, 125, 130, 253, 130, 251,
	128, 251, 128, 253, 129, 125, 129, 251, 130, 125, 132, 253, 132, 251, 130, 251, 130, 253, 131, 125,
	131, 251, 138, 125, 142, 253, 142, 251, 138, 251, 138, 253, 139, 125, 139, 251, 141, 125, 141, 251,
	148, 125, 152, 253, 152, 251, 148, 251, 148, 253, 149, 125, 149, 251, 151, 125, 151, 251, 136, 1,
	136, 255, 134, 1, 134, 255, 140, 125, 140, 251, 150, 125, 150, 251, 146, 17, 148, 145, 148, 143,
	146, 143, 146, 145, 147, 17, 147, 143, 148, 17, 150, 145, 150, 143, 148, 143, 148, 145, 149, 17,
	149, 143, 150, 17, 152, 145, 152, 143, 150, 143, 150, 145, 151, 17, 151, 143, 128, 9, 130, 137, 130,
	135, 128, 135, 128, 137, 129, 9, 129, 135, 130, 9, 132, 137, 132, 135, 130, 135, 130, 137, 131, 9,
	131, 135, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133, 135, 146, 1, 152, 129, 152,
	255, 146, 255, 146, 129, 147, 1, 147, 255, 149, 1, 149, 255, 151, 1, 151, 255, 148, 1, 148, 255, 150,
	1, 150, 255, 152, 0, 0, 0, 128, 21, 128, 249, 133, 0, 0, 0, 136, 21, 136, 249, 128, 5, 136, 133, 141,
	0, 0, 0, 136, 121, 136, 149, 128, 9, 136, 137, 128, 5, 136, 133, 141, 0, 0, 0, 136, 21, 136, 249,
	128, 5, 136, 133, 144, 21, 144, 249, 149, 0, 0, 0, 128, 5, 144, 133, 144, 249, 136, 5, 136, 249, 149,
	0, 0, 0, 128, 9, 136, 137, 136, 249, 128, 5, 136, 133, 141, 0, 0, 0, 128, 5, 136, 133, 136, 249, 144,
	21, 144, 249, 128, 9, 136, 137, 136, 149, 128, 1, 128, 129, 149, 0, 0, 0, 136, 21, 136, 249, 144, 21,
	144, 249, 148, 0, 0, 0, 128, 9, 144, 137, 144, 249, 128, 5, 136, 133, 136, 249, 149, 0, 0, 0, 128, 5,
	144, 133, 144, 149, 128, 9, 136, 137, 136, 149, 149, 0, 0, 0, 128, 9, 144, 137, 144, 149, 136, 9, 136,
	149, 149, 0, 0, 0, 128, 5, 136, 133, 136, 149, 128, 9, 136, 137, 141, 0, 0, 0, 128, 5, 136, 133, 136,
	249, 128, 0, 0, 0, 136, 9, 128, 137, 128, 149, 136, 0, 0, 0, 128, 9, 136, 137, 136, 149, 144, 9, 136,
	137, 144, 0, 0, 0, 128, 5, 136, 133, 136, 249, 144, 5, 136, 133, 144, 0, 0, 0, 128, 21, 128, 249, 136,
	5, 128, 133, 136, 0, 0, 0, 128, 5, 144, 133, 144, 0, 0, 0, 136, 21, 136, 249, 128, 5, 144, 133, 144,
	0, 0, 0, 128, 121, 128, 149, 136, 9, 128, 137, 136, 5, 128, 133, 136, 0, 0, 0, 136, 21, 136, 249,
	144, 5, 136, 133, 128, 21, 128, 249, 144, 0, 0, 0, 144, 5, 128, 133, 128, 149, 144, 9, 136, 137, 136,
	149, 144, 0, 0, 0, 144, 9, 128, 137, 128, 249, 144, 5, 136, 133, 136, 249, 144, 0, 0, 0, 128, 5, 152,
	133, 128, 9, 136, 137, 136, 149, 144, 21, 144, 137, 152, 137, 152, 0, 0, 0, 128, 9, 152, 137, 128, 5,
	136, 133, 136, 249, 144, 121, 144, 133, 152, 133, 152, 0, 0, 0, 144, 5, 136, 133, 136, 249, 128, 21,
	128, 249, 144, 9, 136, 137, 136, 149, 144, 0, 0, 0, 128, 9, 144, 137, 128, 5, 144, 133, 144, 0, 0, 0,
	128, 5, 136, 133, 136, 249, 128, 9, 136, 137, 136, 149, 144, 21, 144, 137, 152, 137, 144, 121, 144,
	133, 152, 133, 152, 0, 0, 0, 128, 9, 136, 137, 136, 149, 144, 9, 136, 137, 128, 5, 144, 133, 144, 0, 0,
	0, 128, 9, 144, 137, 134, 21, 134, 137, 142, 21, 142, 137, 144, 0, 0, 0, 128, 5, 136, 133, 136, 249,
	144, 5, 136, 133, 128, 9, 144, 137, 144, 0, 0, 0, 128, 5, 144, 133, 134, 121, 134, 133, 142, 121, 142,
	133, 144, 0, 0, 0, 144, 9, 128, 137, 128, 149, 136, 9, 136, 149, 144, 0, 0, 0, 136, 5, 128, 133, 128,
	149, 136, 9, 128, 137, 136, 0, 0, 0, 136, 9, 128, 137, 128, 249, 136, 5, 128, 133, 136, 0, 0, 0, 144, 5,
	128, 133, 128, 249, 136, 5, 136, 249, 144, 0, 0, 0, 136, 21, 136, 249, 128, 5, 152, 133, 144, 21, 144,
	249, 152, 0, 0, 0, 136, 21, 136, 249, 128, 5, 144, 133, 128, 9, 144, 137, 144, 0, 0, 0, 128, 9, 136,
	137, 136, 149, 141, 0, 0, 0, 136, 5, 128, 133, 128, 249, 136, 0, 0, 0, 144, 0, 128, 128, 128, 149, 143,
	149, 143, 128, 144, 128, 144, 149, 143, 149, 143, 128, 129, 21, 129, 128, 130, 21, 130, 128, 131,
	21, 131, 128, 132, 21, 132, 128, 133, 21, 133, 128, 134, 21, 134, 128, 135, 21, 135, 128, 136, 21,
	136, 128, 137, 21, 137, 128, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141,
	128, 142, 21, 142, 128, 128, 11, 144, 139, 144, 0, 0, 0, 144, 0, 128, 128, 128, 139, 144, 139, 144,
	128, 143, 128, 143, 139, 129, 11, 129, 128, 130, 11, 130, 128, 131, 11, 131, 128, 132, 11, 132, 128,
	133, 11, 133, 128, 134, 11, 134, 128, 135, 11, 135, 128, 136, 11, 136, 128, 137, 11, 137, 128, 138,
	11, 138, 128, 139, 11, 139, 128, 140, 11, 140, 128, 141, 11, 141, 128, 142, 11, 142, 128, 144, 0, 0,
	0, 128, 0, 128, 149, 136, 149, 136, 128, 128, 128, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21,
	131, 128, 132, 21, 132, 128, 133, 21, 133, 128, 134, 21, 134, 128, 135, 21, 135, 128, 136, 0, 0, 0,
	137, 0, 137, 149, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142,
	21, 142, 128, 143, 21, 143, 128, 144, 21, 144, 128, 145, 21, 145, 128, 145, 0, 0, 0, 144, 10, 128,
	138, 128, 149, 144, 149, 144, 138, 143, 138, 143, 149, 129, 21, 129, 138, 130, 21, 130, 138, 131,
	21, 131, 138, 132, 21, 132, 138, 133, 21, 133, 138, 134, 21, 134, 138, 135, 21, 135, 138, 136, 21,
	136, 138, 137, 21, 137, 138, 138, 21, 138, 138, 139, 21, 139, 138, 140, 21, 140, 138, 141, 21, 141,
	138, 142, 21, 142, 138, 144, 0, 0, 0, 146, 0, 140, 137, 138, 139, 136, 140, 133, 140, 131, 139, 129,
	137, 128, 134, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 146, 140, 150, 0, 0, 0,
	128, 1, 138, 129, 141, 131, 141, 135, 137, 137, 141, 139, 141, 142, 138, 144, 131, 144, 128, 142,
	128, 253, 137, 9, 128, 137, 146, 0, 0, 0, 128, 0, 128, 142, 137, 142, 137, 139, 142, 0, 0, 0, 131, 13,
	131, 128, 139, 13, 139, 128, 128, 13, 141, 141, 146, 0, 0, 0, 141, 2, 141, 128, 128, 128, 136, 139,
	128, 149, 141, 149, 141, 147, 146, 0, 0, 0, 128, 6, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129,
	140, 131, 141, 134, 140, 137, 138, 139, 136, 140, 133, 140, 131, 139, 129, 137, 128, 134, 133, 12,
	137, 142, 148, 142, 152, 0, 0, 0, 130, 14, 130, 132, 131, 129, 133, 128, 136, 128, 138, 129, 141,
	132, 141, 14, 141, 128, 131, 1, 131, 253, 128, 250, 146, 0, 0, 0, 128, 9, 128, 139, 129, 141, 131,
	142, 134, 142, 136, 140, 136, 254, 136, 9, 139, 139, 142, 142, 146, 0, 0, 0, 128, 9, 129, 134, 131,
	132, 133, 131, 136, 131, 138, 132, 140, 134, 141, 137, 140, 140, 138, 142, 136, 143, 133, 143, 131,
	142, 129, 140, 128, 137, 134, 21, 134, 143, 135, 21, 135, 143, 128, 21, 141, 149, 134, 125, 134,
	131, 135, 125, 135, 131, 128, 125, 141, 253, 146, 0, 0, 0, 134, 21, 132, 148, 130, 146, 129, 144,
	128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 134, 128, 138, 128, 140, 129, 142, 131, 143, 133,
	144, 136, 144, 141, 143, 144, 142, 146, 140, 148, 138, 149, 134, 149, 128, 10, 144, 138, 149, 0, 0,
	0, 144, 0, 139, 128, 139, 134, 142, 135, 144, 137, 144, 141, 143, 144, 142, 146, 140, 148, 138,
	149, 134, 149, 132, 148, 130, 146, 129, 144, 128, 141, 128, 137, 130, 135, 133, 134, 133, 128, 128,
	128, 149, 0, 0, 0, 128, 6, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 140,
	137, 138, 139, 136, 140, 133, 140, 131, 139, 129, 137, 128, 134, 138, 11, 128, 149, 141, 149, 141,
	146, 146, 0, 0, 0, 128, 6, 129, 131, 131, 129, 133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 140,
	137, 138, 139, 136, 140, 133, 140, 131, 139, 129, 137, 128, 134, 140, 6, 141, 131, 143, 129, 145,
	128, 148, 128, 150, 129, 152, 131, 153, 134, 152, 137, 150, 139, 148, 140, 145, 140, 143, 139, 141,
	137, 140, 134, 157, 0, 0, 0, 133, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129,
	133, 128, 136, 128, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136, 142, 133, 142,
	128, 125, 141, 145, 144, 0, 0, 0, 141, 21, 131, 149, 128, 147, 128, 139, 136, 139, 128, 11, 128, 130,
	131, 128, 141, 128, 145, 0, 0, 0, 128, 0, 128, 143, 129, 146, 131, 148, 134, 149, 136, 149, 139, 148,
	141, 146, 142, 143, 142, 128, 147, 0, 0, 0, 128, 9, 146, 137, 128, 5, 146, 133, 128, 13, 146, 141,
	151, 0, 0, 0, 128, 0, 146, 128, 137, 21, 137, 131, 128, 12, 146, 140, 151, 0, 0, 0, 128, 0, 146, 128,
	128, 21, 146, 140, 128, 131, 151, 0, 0, 0, 146, 0, 128, 128, 146, 21, 128, 140, 146, 131, 152, 0, 0, 0,
	138, 20, 135, 149, 133, 149, 130, 148, 129, 147, 128, 144, 128, 249, 141, 0, 0, 0, 128, 122, 131,
	249, 133, 249, 136, 250, 137, 251, 138, 254, 138, 149, 142, 0, 0, 0, 137, 20, 136, 147, 137, 146,
	138, 147, 137, 148, 137, 3, 136, 130, 137, 129, 138, 130, 137, 131, 128, 10, 146, 138, 151, 0, 0, 0,
	128, 11, 133, 142, 137, 139, 141, 141, 128, 6, 133, 137, 137, 134, 141, 136, 146, 0, 0, 0, 128, 15,
	129, 140, 131, 138, 133, 137, 136, 137, 138, 138, 140, 140, 141, 143, 140, 146, 138, 148, 136, 149,
	133, 149, 131, 148, 129, 146, 128, 143, 255, 1, 255, 129, 146, 0, 0, 0, 128, 4, 131, 132, 131, 128,
	128, 128, 128, 132, 129, 4, 129, 128, 130, 4, 130, 128, 135, 0, 0, 0, 128, 2, 131, 130, 131, 128, 128,
	128, 128, 130, 131, 129, 129, 2, 129, 128, 130, 2, 130, 128, 135, 0, 0, 0, 144, 18, 144, 149, 136,
	149, 136, 128, 128, 138, 146, 0, 0, 0, 128, 21, 128, 138, 128, 17, 131, 148, 133, 149, 136, 149, 138,
	148, 139, 145, 139, 138, 143, 0, 0, 0, 129, 19, 129, 148, 130, 149, 134, 149, 135, 148, 135, 147,
	134, 146, 128, 143, 135, 143, 139, 0, 0, 0, 128, 0, 128, 139, 136, 139, 136, 128, 128, 128, 129, 11,
	129, 128, 130, 11, 130, 128, 131, 11, 131, 128, 132, 11, 132, 128, 133, 11, 133, 128, 134, 11, 134,
	128, 135, 11, 135, 128, 141, 0, 0, 0
};
static const unsigned char TriplexScript[17355] = /* binary data included from TSCR.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 65, 117, 103, 32, 51, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 84,
	83, 67, 82, 75, 67, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 24, 0, 249, 2, 3, 0, 0, 0, 0, 0, 4, 0, 66, 0, 104, 0, 126, 0, 226, 0, 34, 1,
	172, 1, 194, 1, 0, 2, 62, 2, 128, 2, 158, 2, 202, 2, 220, 2, 254, 2, 16, 3, 128, 3, 156, 3, 252, 3, 118, 4,
	144, 4, 234, 4, 98, 5, 162, 5, 76, 6, 196, 6, 2, 7, 74, 7, 86, 7, 116, 7, 128, 7, 240, 7, 94, 8, 152, 8, 24,
	9, 106, 9, 210, 9, 58, 10, 160, 10, 20, 11, 134, 11, 192, 11, 18, 12, 120, 12, 192, 12, 34, 13, 98,
	13, 206, 13, 46, 14, 192, 14, 62, 15, 150, 15, 228, 15, 52, 16, 106, 16, 192, 16, 14, 17, 90, 17, 144,
	17, 166, 17, 182, 17, 204, 17, 220, 17, 236, 17, 24, 18, 118, 18, 214, 18, 26, 19, 132, 19, 198, 19,
	30, 20, 138, 20, 210, 20, 18, 21, 102, 21, 188, 21, 236, 21, 90, 22, 168, 22, 0, 23, 116, 23, 214, 23,
	16, 24, 106, 24, 150, 24, 228, 24, 30, 25, 120, 25, 218, 25, 54, 26, 124, 26, 204, 26, 214, 26, 38,
	27, 88, 27, 112, 27, 248, 27, 124, 28, 226, 28, 74, 29, 222, 29, 94, 30, 214, 30, 80, 31, 158, 31, 24,
	32, 126, 32, 228, 32, 30, 33, 112, 33, 220, 33, 46, 34, 196, 34, 72, 35, 192, 35, 34, 36, 176, 36, 42,
	37, 130, 37, 242, 37, 132, 38, 38, 39, 170, 39, 10, 40, 130, 40, 246, 40, 118, 41, 228, 41, 100, 42,
	182, 42, 48, 43, 160, 43, 10, 44, 108, 44, 210, 44, 50, 45, 162, 45, 182, 45, 202, 45, 78, 46, 148, 46,
	204, 46, 222, 46, 240, 46, 246, 47, 248, 49, 38, 52, 52, 52, 66, 52, 84, 52, 102, 52, 118, 52, 134, 52,
	156, 52, 170, 52, 188, 52, 206, 52, 222, 52, 238, 52, 252, 52, 8, 53, 24, 53, 40, 53, 54, 53, 64, 53,
	78, 53, 96, 53, 114, 53, 132, 53, 150, 53, 172, 53, 194, 53, 216, 53, 230, 53, 4, 54, 24, 54, 42, 54,
	62, 54, 80, 54, 96, 54, 112, 54, 128, 54, 144, 54, 162, 54, 180, 54, 192, 54, 204, 54, 28, 55, 104,
	55, 144, 55, 184, 55, 4, 56, 90, 56, 192, 56, 254, 56, 76, 57, 96, 57, 188, 57, 32, 58, 104, 58, 220,
	58, 78, 59, 186, 59, 36, 60, 206, 60, 46, 61, 70, 61, 146, 61, 182, 61, 218, 61, 252, 61, 30, 62, 94,
	62, 158, 62, 230, 62, 68, 63, 156, 63, 184, 63, 208, 63, 0, 64, 66, 64, 114, 64, 16, 10, 16, 17, 19,
	20, 24, 6, 15, 15, 12, 19, 19, 19, 5, 29, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 8, 9, 18, 19, 18, 15,
	23, 20, 23, 19, 22, 23, 23, 19, 28, 16, 20, 27, 19, 30, 27, 18, 24, 18, 23, 21, 20, 23, 20, 24, 26, 22,
	22, 9, 29, 9, 15, 20, 6, 20, 14, 14, 20, 14, 21, 19, 21, 13, 16, 19, 9, 35, 24, 16, 22, 17, 18, 15, 12,
	24, 18, 28, 21, 21, 16, 7, 2, 7, 20, 16, 19, 24, 14, 20, 20, 20, 20, 14, 14, 15, 14, 14, 14, 13, 23, 20,
	21, 27, 31, 16, 16, 16, 24, 24, 21, 18, 23, 16, 21, 22, 31, 28, 20, 13, 16, 24, 24, 27, 21, 16, 15, 15,
	15, 31, 31, 10, 21, 21, 16, 18, 26, 6, 11, 11, 19, 19, 11, 19, 19, 19, 19, 19, 11, 11, 11, 20, 20, 11,
	20, 20, 11, 19, 19, 19, 28, 28, 19, 20, 28, 20, 19, 20, 19, 19, 11, 11, 19, 28, 20, 11, 11, 18, 18, 9,
	17, 18, 21, 23, 24, 30, 13, 24, 24, 20, 16, 18, 17, 16, 28, 16, 13, 23, 19, 19, 19, 19, 19, 19, 19, 21,
	16, 5, 5, 21, 20, 9, 10, 144, 0, 0, 0, 135, 21, 134, 149, 133, 148, 131, 135, 135, 20, 134, 148, 131,
	135, 135, 20, 135, 147, 131, 135, 135, 21, 136, 148, 136, 147, 131, 135, 129, 3, 128, 130, 128, 129,
	129, 128, 130, 128, 131, 129, 131, 130, 130, 131, 129, 131, 129, 2, 129, 129, 130, 129, 130, 130,
	129, 130, 141, 0, 138, 0, 0, 0, 131, 21, 130, 148, 128, 142, 131, 20, 128, 142, 131, 21, 132, 148,
	128, 142, 141, 21, 140, 148, 138, 142, 141, 20, 138, 142, 141, 21, 142, 148, 138, 142, 147, 0, 144,
	0, 0, 0, 136, 21, 129, 249, 142, 21, 135, 249, 129, 10, 143, 138, 128, 4, 142, 132, 148, 0, 145, 0,
	0, 0, 138, 25, 130, 252, 143, 25, 135, 252, 144, 16, 144, 145, 143, 145, 143, 143, 145, 143, 145,
	145, 144, 147, 143, 148, 140, 149, 136, 149, 133, 148, 131, 146, 131, 143, 132, 141, 134, 139, 140,
	136, 141, 134, 141, 131, 140, 129, 132, 15, 133, 141, 140, 137, 141, 135, 133, 20, 132, 146, 132,
	144, 133, 142, 139, 139, 141, 137, 142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130,
	129, 129, 130, 128, 132, 128, 134, 130, 134, 130, 132, 129, 132, 129, 133, 150, 0, 147, 0, 0, 0, 146,
	21, 128, 128, 133, 21, 135, 147, 135, 145, 134, 143, 132, 142, 130, 142, 128, 144, 128, 146, 129,
	148, 131, 149, 133, 149, 135, 148, 138, 147, 141, 147, 144, 148, 146, 149, 142, 7, 140, 134, 139,
	132, 139, 130, 141, 128, 143, 128, 145, 129, 146, 131, 146, 133, 144, 135, 142, 135, 151, 0, 148, 0,
	0, 0, 149, 12, 149, 141, 148, 141, 148, 139, 150, 139, 150, 141, 149, 142, 148, 142, 146, 141,
	144, 139, 139, 131, 137, 129, 135, 128, 132, 128, 129, 129, 128, 131, 128, 133, 129, 135, 130, 136,
	132, 137, 137, 139, 139, 140, 141, 142, 142, 144, 142, 146, 141, 148, 139, 149, 137, 148, 136, 146,
	136, 143, 137, 137, 138, 134, 139, 132, 141, 129, 143, 128, 145, 128, 146, 130, 146, 131, 133, 0,
	129, 129, 130, 1, 129, 131, 129, 133, 130, 135, 131, 136, 133, 137, 137, 11, 138, 136, 141, 130,
	143, 129, 132, 0, 131, 129, 130, 131, 130, 133, 131, 135, 132, 136, 134, 137, 139, 140, 136, 15,
	137, 140, 138, 137, 140, 133, 142, 130, 144, 129, 145, 129, 146, 130, 155, 0, 152, 0, 0, 0, 131, 21,
	130, 148, 128, 142, 131, 20, 128, 142, 131, 21, 132, 148, 128, 142, 137, 0, 134, 0, 0, 0, 141, 25,
	139, 152, 136, 150, 133, 147, 131, 144, 129, 140, 128, 136, 128, 131, 129, 255, 130, 252, 132, 249,
	134, 19, 132, 144, 130, 140, 129, 135, 129, 255, 141, 25, 138, 151, 135, 148, 133, 145, 132, 143,
	131, 140, 130, 136, 129, 255, 129, 7, 130, 254, 131, 251, 132, 249, 146, 0, 143, 0, 0, 0, 137, 25,
	139, 150, 140, 147, 141, 143, 141, 138, 140, 134, 138, 130, 136, 255, 133, 252, 130, 250, 128, 249,
	140, 19, 140, 139, 139, 134, 137, 130, 135, 255, 137, 25, 138, 151, 139, 148, 140, 139, 140, 19,
	139, 138, 138, 134, 137, 131, 136, 129, 134, 254, 131, 251, 128, 249, 146, 0, 143, 0, 0, 0, 133, 21,
	132, 148, 134, 138, 133, 137, 133, 21, 133, 137, 133, 21, 134, 148, 132, 138, 133, 137, 128, 18,
	129, 146, 137, 140, 138, 140, 128, 18, 138, 140, 128, 18, 128, 145, 138, 141, 138, 140, 138, 18,
	137, 146, 129, 140, 128, 140, 138, 18, 128, 140, 138, 18, 138, 145, 128, 141, 128, 140, 143, 0, 140,
	0, 0, 0, 136, 18, 136, 129, 137, 129, 136, 18, 137, 146, 137, 129, 128, 10, 145, 138, 145, 137,
	128, 10, 128, 137, 145, 137, 150, 0, 147, 0, 0, 0, 130, 125, 131, 255, 131, 128, 130, 128, 129, 129,
	129, 130, 130, 131, 131, 131, 132, 130, 132, 128, 131, 254, 130, 253, 128, 252, 130, 2, 130, 129,
	131, 129, 131, 130, 130, 130, 150, 0, 134, 0, 147, 0, 0, 0, 128, 10, 145, 138, 145, 137, 128, 10, 128,
	137, 145, 137, 150, 0, 147, 0, 0, 0, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131, 129, 131,
	130, 130, 131, 129, 131, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 136, 0, 133, 0, 0, 0, 154,
	25, 128, 249, 129, 249, 154, 25, 155, 153, 129, 249, 160, 0, 157, 0, 0, 0, 137, 21, 134, 148, 132,
	146, 130, 143, 129, 140, 128, 136, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137, 129, 139,
	131, 141, 134, 142, 137, 143, 141, 143, 144, 142, 147, 141, 148, 139, 149, 137, 149, 135, 148, 133,
	145, 132, 143, 131, 140, 130, 136, 130, 131, 131, 129, 132, 128, 134, 19, 132, 145, 131, 143, 130,
	140, 129, 136, 129, 132, 130, 130, 137, 2, 139, 132, 140, 134, 141, 137, 142, 141, 142, 145, 141,
	147, 134, 0, 136, 129, 138, 132, 139, 134, 140, 137, 141, 141, 141, 146, 140, 148, 139, 149, 150, 0,
	145, 0, 147, 0, 0, 0, 140, 21, 137, 146, 134, 144, 132, 143, 135, 144, 137, 145, 132, 128, 134, 128,
	140, 149, 138, 145, 133, 128, 145, 0, 147, 0, 0, 0, 134, 16, 134, 145, 135, 145, 135, 143, 133, 143,
	133, 145, 134, 147, 135, 148, 138, 149, 141, 149, 144, 148, 145, 146, 145, 144, 144, 142, 142, 140,
	132, 134, 130, 132, 128, 128, 143, 20, 144, 146, 144, 144, 143, 142, 141, 140, 138, 138, 141, 21,
	142, 148, 143, 146, 143, 144, 142, 142, 140, 140, 132, 134, 129, 2, 130, 131, 132, 131, 137, 130,
	142, 130, 143, 131, 143, 132, 142, 1, 140, 128, 137, 128, 132, 131, 137, 129, 142, 129, 143, 131,
	150, 0, 147, 0, 0, 0, 133, 16, 133, 145, 134, 145, 134, 143, 132, 143, 132, 145, 133, 147, 134, 148,
	137, 149, 140, 149, 143, 148, 144, 146, 144, 144, 143, 142, 142, 141, 140, 140, 137, 139, 140, 138,
	141, 137, 142, 135, 142, 132, 141, 130, 139, 129, 136, 128, 133, 128, 130, 129, 129, 130, 128, 132,
	128, 134, 130, 134, 130, 132, 129, 132, 129, 133, 142, 20, 143, 146, 143, 144, 142, 142, 141, 141,
	140, 21, 141, 148, 142, 146, 142, 144, 141, 142, 139, 140, 137, 139, 139, 138, 140, 136, 140, 132,
	139, 130, 138, 129, 136, 128, 135, 11, 137, 139, 140, 9, 141, 135, 141, 132, 140, 130, 150, 0, 146,
	0, 147, 0, 0, 0, 141, 17, 136, 128, 138, 128, 144, 149, 142, 145, 137, 128, 144, 21, 128, 134, 144,
	134, 150, 0, 146, 0, 147, 0, 0, 0, 135, 21, 130, 139, 135, 21, 145, 149, 135, 20, 143, 148, 134, 19,
	139, 147, 143, 148, 145, 149, 130, 11, 131, 140, 134, 141, 137, 141, 140, 140, 141, 139, 142, 137,
	142, 134, 141, 131, 139, 129, 135, 128, 132, 128, 130, 129, 129, 130, 128, 132, 128, 134, 130, 134,
	130, 132, 129, 132, 129, 133, 140, 11, 141, 137, 141, 134, 140, 131, 138, 129, 137, 13, 139, 140,
	140, 138, 140, 134, 139, 131, 137, 129, 135, 128, 150, 0, 147, 0, 0, 0, 142, 17, 142, 146, 141, 146,
	141, 144, 143, 144, 143, 146, 142, 148, 140, 149, 137, 149, 134, 148, 132, 146, 130, 143, 129, 140,
	128, 136, 128, 133, 129, 130, 130, 129, 132, 128, 135, 128, 138, 129, 140, 131, 141, 133, 141, 136,
	140, 138, 139, 139, 137, 140, 134, 140, 132, 139, 131, 138, 130, 136, 130, 131, 131, 129, 132, 128,
	133, 18, 131, 143, 130, 140, 129, 136, 129, 132, 130, 130, 139, 3, 140, 133, 140, 136, 139, 138,
	137, 21, 135, 148, 133, 145, 132, 143, 131, 140, 130, 136, 135, 0, 137, 129, 138, 130, 139, 133,
	139, 137, 138, 139, 137, 140, 150, 0, 145, 0, 147, 0, 0, 0, 130, 21, 128, 143, 131, 20, 134, 148, 139,
	146, 134, 147, 131, 147, 129, 146, 132, 149, 134, 149, 139, 146, 141, 146, 142, 147, 143, 149, 142,
	146, 140, 143, 136, 138, 134, 135, 133, 132, 132, 128, 130, 128, 131, 132, 132, 134, 134, 137, 140,
	143, 134, 8, 132, 132, 131, 128, 150, 0, 145, 0, 147, 0, 0, 0, 137, 21, 134, 148, 133, 147, 132, 145,
	132, 142, 133, 140, 135, 139, 138, 139, 141, 140, 143, 141, 144, 143, 144, 146, 143, 148, 141, 149,
	137, 149, 135, 147, 134, 145, 134, 141, 135, 139, 131, 138, 129, 136, 128, 134, 128, 131, 129, 129,
	132, 128, 136, 128, 140, 129, 141, 130, 142, 132, 142, 135, 141, 137, 140, 138, 138, 139, 140, 140,
	141, 141, 142, 143, 142, 147, 141, 149, 143, 20, 139, 149, 134, 148, 134, 19, 133, 145, 133, 141,
	134, 140, 133, 12, 136, 139, 131, 138, 140, 10, 137, 139, 141, 140, 142, 13, 143, 143, 143, 146,
	142, 148, 132, 10, 130, 136, 129, 134, 129, 131, 130, 129, 129, 1, 134, 128, 140, 129, 140, 2, 141,
	132, 141, 135, 140, 137, 135, 11, 133, 138, 131, 136, 130, 134, 130, 131, 131, 129, 132, 128, 136,
	0, 138, 129, 139, 130, 140, 132, 140, 136, 139, 138, 138, 139, 150, 0, 146, 0, 147, 0, 0, 0, 134, 0,
	136, 129, 138, 132, 139, 134, 140, 137, 141, 141, 140, 139, 139, 138, 137, 137, 134, 137, 132, 138,
	131, 139, 130, 141, 130, 144, 131, 146, 133, 148, 136, 149, 139, 149, 141, 148, 142, 147, 143, 144,
	143, 141, 142, 137, 141, 134, 139, 131, 137, 129, 134, 128, 131, 128, 129, 129, 128, 131, 128, 133,
	130, 133, 130, 131, 129, 131, 129, 132, 132, 11, 131, 141, 131, 144, 132, 146, 141, 19, 142, 145,
	142, 141, 141, 137, 140, 134, 138, 131, 134, 9, 133, 138, 132, 140, 132, 144, 133, 147, 134, 148,
	136, 149, 139, 21, 140, 148, 141, 146, 141, 141, 150, 0, 145, 0, 147, 0, 0, 0, 132, 14, 131, 141, 131,
	140, 132, 139, 133, 139, 134, 140, 134, 141, 133, 142, 132, 142, 132, 13, 132, 140, 133, 140, 133,
	141, 132, 141, 129, 3, 128, 130, 128, 129, 129, 128, 130, 128, 131, 129, 131, 130, 130, 131, 129,
	131, 129, 2, 129, 129, 130, 129, 130, 130, 129, 130, 139, 0, 136, 0, 0, 0, 133, 14, 132, 141, 132,
	140, 133, 139, 134, 139, 135, 140, 135, 141, 134, 142, 133, 142, 133, 13, 133, 140, 134, 140, 134,
	141, 133, 141, 131, 0, 130, 128, 129, 129, 129, 130, 130, 131, 131, 131, 132, 130, 132, 128, 131,
	254, 130, 253, 128, 252, 130, 2, 130, 129, 131, 129, 131, 130, 130, 130, 131, 0, 131, 255, 130, 253,
	140, 0, 137, 0, 0, 0, 144, 18, 128, 137, 144, 128, 149, 0, 146, 0, 0, 0, 128, 14, 145, 142, 145, 141,
	128, 14, 128, 141, 145, 141, 128, 6, 145, 134, 145, 133, 128, 6, 128, 133, 145, 133, 150, 0, 147, 0,
	0, 0, 128, 18, 144, 137, 128, 128, 149, 0, 146, 0, 0, 0, 129, 16, 129, 145, 130, 145, 130, 143, 128,
	143, 128, 145, 129, 147, 130, 148, 133, 149, 137, 149, 140, 148, 141, 146, 141, 144, 140, 142, 139,
	141, 137, 140, 133, 139, 131, 138, 131, 136, 133, 135, 134, 135, 135, 21, 140, 148, 139, 20, 140,
	146, 140, 144, 139, 142, 138, 141, 136, 140, 137, 21, 138, 148, 139, 146, 139, 144, 138, 142, 137,
	141, 133, 139, 132, 138, 132, 136, 133, 135, 132, 3, 131, 130, 131, 129, 132, 128, 133, 128, 134,
	129, 134, 130, 133, 131, 132, 131, 132, 2, 132, 129, 133, 129, 133, 130, 132, 130, 146, 0, 143, 0, 0,
	0, 143, 13, 142, 143, 140, 144, 137, 144, 135, 143, 134, 142, 133, 139, 133, 136, 134, 134, 136,
	133, 139, 133, 141, 134, 142, 136, 137, 16, 135, 142, 134, 139, 134, 136, 135, 134, 136, 133, 143,
	16, 142, 136, 142, 134, 144, 133, 146, 133, 148, 135, 149, 138, 149, 140, 148, 143, 147, 145, 145,
	147, 143, 148, 140, 149, 137, 149, 134, 148, 132, 147, 130, 145, 129, 143, 128, 140, 128, 137, 129,
	134, 130, 132, 132, 130, 134, 129, 137, 128, 140, 128, 143, 129, 145, 130, 146, 131, 144, 16, 143,
	136, 143, 134, 144, 133, 154, 0, 151, 0, 0, 0, 143, 21, 131, 129, 141, 17, 142, 128, 142, 19, 143,
	129, 143, 21, 143, 147, 144, 130, 144, 128, 134, 6, 142, 134, 128, 0, 134, 128, 139, 0, 146, 128,
	131, 1, 129, 128, 131, 1, 133, 128, 142, 1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 151, 0, 148,
	0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 134, 21, 145, 149, 148, 148, 149,
	146, 149, 144, 148, 141, 147, 140, 144, 139, 147, 20, 148, 146, 148, 144, 147, 141, 146, 140, 145,
	21, 146, 148, 147, 146, 147, 144, 146, 141, 144, 139, 136, 11, 144, 139, 146, 138, 147, 136, 147,
	134, 146, 131, 144, 129, 140, 128, 128, 128, 145, 10, 146, 136, 146, 134, 145, 131, 143, 129, 144,
	11, 145, 137, 145, 134, 144, 131, 142, 129, 140, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140,
	21, 138, 147, 141, 21, 138, 148, 132, 1, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135,
	128, 154, 0, 151, 0, 0, 0, 143, 19, 144, 147, 145, 149, 144, 143, 144, 145, 143, 147, 142, 148, 140,
	149, 137, 149, 134, 148, 132, 146, 130, 143, 129, 140, 128, 136, 128, 133, 129, 130, 130, 129, 133,
	128, 136, 128, 138, 129, 140, 131, 141, 133, 134, 19, 132, 145, 131, 143, 130, 140, 129, 136, 129,
	132, 130, 130, 137, 21, 135, 148, 133, 145, 132, 143, 131, 140, 130, 136, 130, 131, 131, 129, 133,
	128, 150, 0, 147, 0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 134, 21, 143, 149,
	146, 148, 147, 147, 148, 144, 148, 140, 147, 136, 145, 132, 143, 130, 141, 129, 137, 128, 128, 128,
	145, 20, 146, 147, 147, 144, 147, 140, 146, 136, 144, 132, 142, 130, 143, 21, 145, 147, 146, 144,
	146, 140, 145, 136, 143, 132, 140, 129, 137, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140, 21,
	138, 147, 141, 21, 138, 148, 132, 1, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135, 128,
	153, 0, 150, 0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 143, 15, 141, 135, 141,
	139, 143, 143, 134, 21, 149, 149, 148, 143, 148, 149, 136, 11, 142, 139, 128, 0, 143, 128, 145, 133,
	143, 130, 140, 128, 135, 21, 138, 148, 141, 149, 136, 21, 137, 147, 140, 21, 138, 147, 145, 21, 148,
	148, 146, 21, 148, 147, 147, 21, 148, 146, 142, 13, 140, 139, 141, 137, 142, 12, 139, 139, 141, 138,
	135, 0, 132, 129, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 138, 0, 143, 129, 154, 0, 151, 0, 0, 0,
	137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 143, 15, 141, 135, 134, 21, 149, 149, 148,
	143, 136, 11, 142, 139, 128, 0, 136, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140, 21, 138, 147,
	141, 21, 138, 148, 145, 21, 148, 148, 146, 21, 148, 147, 147, 21, 148, 146, 148, 21, 148, 143, 143,
	15, 141, 139, 141, 135, 142, 13, 140, 139, 141, 137, 142, 12, 139, 139, 141, 138, 132, 1, 129, 128,
	132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135, 128, 154, 0, 151, 0, 0, 0, 143, 19, 144, 147, 145,
	149, 144, 143, 144, 145, 143, 147, 142, 148, 140, 149, 137, 149, 134, 148, 132, 146, 130, 143, 129,
	140, 128, 136, 128, 133, 129, 130, 130, 129, 133, 128, 135, 128, 138, 129, 140, 131, 142, 135, 134,
	19, 132, 145, 131, 143, 130, 140, 129, 136, 129, 132, 130, 130, 139, 3, 140, 132, 141, 135, 137,
	21, 135, 148, 133, 145, 132, 143, 131, 140, 130, 136, 130, 131, 131, 129, 133, 128, 135, 0, 137,
	129, 139, 132, 140, 135, 137, 7, 145, 135, 138, 7, 140, 134, 139, 7, 140, 132, 143, 7, 141, 133, 144,
	7, 141, 134, 150, 0, 147, 0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 149, 21,
	143, 128, 150, 21, 144, 128, 151, 21, 145, 128, 134, 21, 142, 149, 146, 21, 154, 149, 135, 11, 147,
	139, 128, 0, 136, 128, 140, 0, 148, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140, 21, 138, 147,
	141, 21, 138, 148, 147, 21, 150, 148, 148, 21, 149, 147, 152, 21, 150, 147, 153, 21, 150, 148, 132,
	1, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135, 128, 144, 1, 141, 128, 144, 2, 142,
	128, 145, 2, 146, 128, 144, 1, 147, 128, 159, 0, 156, 0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128,
	139, 21, 133, 128, 134, 21, 142, 149, 128, 0, 136, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140,
	21, 138, 147, 141, 21, 138, 148, 132, 1, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135,
	128, 147, 0, 144, 0, 0, 0, 141, 21, 136, 132, 135, 130, 133, 128, 142, 21, 138, 136, 137, 133, 136,
	131, 143, 21, 139, 136, 137, 131, 135, 129, 133, 128, 131, 128, 129, 129, 128, 131, 128, 133, 129,
	134, 130, 134, 131, 133, 131, 132, 130, 131, 129, 131, 129, 5, 129, 132, 130, 132, 130, 133, 129,
	133, 138, 21, 146, 149, 139, 21, 142, 148, 140, 21, 141, 147, 144, 21, 142, 147, 145, 21, 142, 148,
	151, 0, 148, 0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 150, 20, 135, 137, 139,
	12, 143, 128, 140, 12, 144, 128, 141, 13, 145, 129, 134, 21, 142, 149, 147, 21, 153, 149, 128, 0,
	136, 128, 140, 0, 147, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140, 21, 138, 147, 141, 21, 138,
	148, 148, 21, 150, 148, 152, 21, 150, 148, 132, 1, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 132,
	1, 135, 128, 143, 1, 141, 128, 143, 2, 142, 128, 144, 2, 146, 128, 158, 0, 155, 0, 0, 0, 137, 21,
	131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 134, 21, 142, 149, 128, 0, 143, 128, 145, 134, 135,
	21, 138, 148, 136, 21, 137, 147, 140, 21, 138, 147, 141, 21, 138, 148, 132, 1, 129, 128, 132, 2,
	130, 128, 133, 2, 134, 128, 132, 1, 135, 128, 138, 0, 143, 129, 140, 0, 144, 131, 142, 0, 145, 134,
	150, 0, 147, 0, 0, 0, 137, 21, 131, 129, 137, 20, 138, 130, 138, 128, 138, 21, 139, 130, 139, 21, 140,
	131, 151, 21, 140, 131, 138, 128, 151, 21, 145, 128, 152, 21, 146, 128, 153, 21, 147, 128, 134, 21,
	139, 149, 151, 21, 156, 149, 128, 0, 134, 128, 142, 0, 150, 128, 135, 21, 137, 148, 136, 21, 137,
	147, 154, 21, 152, 147, 155, 21, 152, 148, 131, 1, 129, 128, 131, 1, 133, 128, 146, 1, 143, 128, 146,
	2, 144, 128, 147, 2, 148, 128, 146, 1, 149, 128, 161, 0, 158, 0, 0, 0, 137, 21, 131, 129, 137, 21,
	144, 128, 138, 21, 144, 131, 139, 21, 145, 131, 150, 20, 145, 131, 144, 128, 134, 21, 139, 149, 147,
	21, 153, 149, 128, 0, 134, 128, 135, 21, 138, 148, 136, 21, 138, 147, 148, 21, 150, 148, 152, 21,
	150, 148, 131, 1, 129, 128, 131, 1, 133, 128, 158, 0, 155, 0, 0, 0, 137, 21, 134, 148, 132, 146, 130,
	143, 129, 140, 128, 136, 128, 133, 129, 130, 130, 129, 132, 128, 135, 128, 138, 129, 140, 131, 142,
	134, 143, 137, 144, 141, 144, 144, 143, 147, 142, 148, 140, 149, 137, 149, 133, 18, 131, 143, 130,
	140, 129, 136, 129, 132, 130, 130, 139, 3, 141, 134, 142, 137, 143, 141, 143, 145, 142, 147, 137,
	21, 135, 148, 133, 145, 132, 143, 131, 140, 130, 136, 130, 131, 131, 129, 132, 128, 135, 0, 137,
	129, 139, 132, 140, 134, 141, 137, 142, 141, 142, 146, 141, 148, 140, 149, 149, 0, 146, 0, 0, 0, 137,
	21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 134, 21, 146, 149, 149, 148, 150, 146, 150,
	144, 149, 141, 147, 139, 143, 138, 135, 138, 148, 20, 149, 146, 149, 144, 148, 141, 146, 139, 146,
	21, 147, 148, 148, 146, 148, 144, 147, 141, 145, 139, 143, 138, 128, 0, 136, 128, 135, 21, 138,
	148, 136, 21, 137, 147, 140, 21, 138, 147, 141, 21, 138, 148, 132, 1, 129, 128, 132, 2, 130, 128,
	133, 2, 134, 128, 132, 1, 135, 128, 155, 0, 152, 0, 0, 0, 137, 21, 134, 148, 132, 146, 130, 143, 129,
	140, 128, 136, 128, 133, 129, 130, 130, 129, 132, 128, 135, 128, 138, 129, 140, 131, 142, 134, 143,
	137, 144, 141, 144, 144, 143, 147, 142, 148, 140, 149, 137, 149, 133, 18, 131, 143, 130, 140, 129,
	136, 129, 132, 130, 130, 139, 3, 141, 134, 142, 137, 143, 141, 143, 145, 142, 147, 137, 21, 135,
	148, 133, 145, 132, 143, 131, 140, 130, 136, 130, 131, 131, 129, 132, 128, 135, 0, 137, 129, 139,
	132, 140, 134, 141, 137, 142, 141, 142, 146, 141, 148, 140, 149, 130, 3, 131, 133, 133, 134, 134,
	134, 136, 133, 137, 131, 138, 254, 139, 253, 140, 253, 141, 254, 138, 125, 139, 252, 140, 252, 137,
	3, 137, 252, 138, 251, 140, 251, 141, 254, 141, 255, 149, 0, 146, 0, 0, 0, 137, 21, 131, 128, 138,
	21, 132, 128, 139, 21, 133, 128, 134, 21, 145, 149, 148, 148, 149, 146, 149, 144, 148, 141, 147,
	140, 144, 139, 136, 139, 147, 20, 148, 146, 148, 144, 147, 141, 146, 140, 145, 21, 146, 148, 147,
	146, 147, 144, 146, 141, 144, 139, 140, 11, 142, 138, 143, 137, 145, 131, 146, 130, 147, 130, 148,
	131, 145, 2, 146, 129, 147, 129, 143, 9, 144, 129, 145, 128, 147, 128, 148, 131, 148, 132, 128, 0,
	136, 128, 135, 21, 138, 148, 136, 21, 137, 147, 140, 21, 138, 147, 141, 21, 138, 148, 132, 1, 129,
	128, 132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135, 128, 154, 0, 151, 0, 0, 0, 145, 19, 146, 147,
	147, 149, 146, 143, 146, 145, 145, 147, 144, 148, 141, 149, 137, 149, 134, 148, 132, 146, 132, 143,
	133, 141, 135, 139, 141, 136, 142, 134, 142, 131, 141, 129, 133, 15, 134, 141, 141, 137, 142, 135,
	134, 20, 133, 146, 133, 144, 134, 142, 140, 139, 142, 137, 143, 135, 143, 132, 142, 130, 141, 129,
	138, 128, 134, 128, 131, 129, 130, 130, 129, 132, 129, 134, 128, 128, 129, 130, 130, 130, 152, 0,
	149, 0, 0, 0, 137, 21, 131, 128, 138, 21, 132, 128, 139, 21, 133, 128, 130, 21, 128, 143, 146, 21,
	145, 143, 130, 21, 146, 149, 128, 0, 136, 128, 131, 21, 128, 143, 133, 21, 129, 146, 135, 21, 130,
	148, 142, 21, 145, 148, 143, 21, 145, 147, 144, 21, 145, 146, 145, 21, 145, 143, 132, 1, 129, 128,
	132, 2, 130, 128, 133, 2, 134, 128, 132, 1, 135, 128, 151, 0, 148, 0, 0, 0, 132, 21, 129, 138, 128,
	134, 128, 131, 129, 129, 132, 128, 136, 128, 139, 129, 141, 131, 142, 134, 146, 148, 133, 21, 130,
	138, 129, 134, 129, 130, 130, 129, 134, 21, 131, 138, 130, 134, 130, 130, 132, 128, 129, 21, 137,
	149, 143, 21, 149, 149, 130, 21, 133, 148, 131, 21, 132, 147, 135, 21, 133, 147, 136, 21, 133, 148,
	144, 21, 146, 148, 148, 21, 146, 148, 154, 0, 151, 0, 0, 0, 130, 21, 130, 147, 131, 130, 131, 128,
	131, 20, 132, 131, 132, 21, 133, 132, 143, 20, 131, 128, 128, 21, 135, 149, 140, 21, 146, 149, 129,
	21, 130, 147, 133, 21, 132, 147, 134, 21, 131, 148, 141, 21, 143, 148, 145, 21, 143, 148, 151, 0,
	148, 0, 0, 0, 131, 21, 131, 147, 129, 130, 129, 128, 132, 20, 130, 131, 133, 21, 131, 132, 139, 21,
	131, 132, 129, 128, 139, 21, 139, 147, 137, 130, 137, 128, 140, 20, 138, 131, 141, 21, 139, 132,
	147, 20, 139, 132, 137, 128, 128, 21, 136, 149, 139, 21, 141, 149, 144, 21, 150, 149, 129, 21, 132,
	148, 130, 21, 131, 147, 134, 21, 132, 146, 135, 21, 132, 148, 145, 21, 147, 148, 149, 21, 147, 148,
	155, 0, 152, 0, 0, 0, 136, 21, 142, 128, 137, 21, 143, 128, 138, 21, 144, 128, 149, 20, 131, 129, 134,
	21, 141, 149, 146, 21, 152, 149, 128, 0, 134, 128, 139, 0, 146, 128, 135, 21, 137, 147, 139, 21,
	138, 147, 140, 21, 138, 148, 147, 21, 149, 148, 151, 21, 149, 148, 131, 1, 129, 128, 131, 1, 133,
	128, 142, 1, 140, 128, 142, 2, 141, 128, 143, 2, 145, 128, 157, 0, 154, 0, 0, 0, 130, 21, 134, 139,
	131, 128, 131, 21, 135, 139, 132, 128, 132, 21, 136, 139, 133, 128, 145, 20, 136, 139, 128, 21, 135,
	149, 142, 21, 148, 149, 128, 0, 136, 128, 129, 21, 131, 148, 133, 21, 132, 147, 134, 21, 131, 148,
	143, 21, 145, 148, 147, 21, 145, 148, 132, 1, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 132, 1,
	135, 128, 153, 0, 150, 0, 0, 0, 146, 21, 128, 128, 147, 21, 129, 128, 148, 21, 130, 128, 148, 21, 134,
	149, 132, 143, 128, 0, 142, 128, 144, 134, 135, 21, 132, 143, 136, 21, 133, 146, 138, 21, 134, 148,
	138, 0, 142, 129, 140, 0, 143, 131, 141, 0, 144, 134, 153, 0, 150, 0, 0, 0, 128, 25, 128, 249, 129, 25,
	129, 249, 128, 25, 135, 153, 128, 121, 135, 249, 140, 0, 137, 0, 0, 0, 129, 25, 155, 249, 154, 249,
	128, 153, 129, 153, 160, 0, 157, 0, 0, 0, 134, 25, 134, 249, 135, 25, 135, 249, 128, 25, 135, 153,
	128, 121, 135, 249, 140, 0, 137, 0, 0, 0, 134, 18, 136, 149, 138, 146, 131, 15, 136, 148, 141, 143,
	143, 0, 0, 0, 128, 122, 146, 250, 146, 249, 128, 249, 128, 250, 151, 0, 148, 0, 0, 0, 131, 18, 130,
	146, 129, 147, 129, 148, 130, 149, 131, 149, 132, 148, 132, 146, 131, 144, 130, 143, 128, 142, 130,
	20, 130, 147, 131, 147, 131, 148, 130, 148, 131, 18, 131, 145, 130, 143, 137, 0, 134, 0, 0, 0, 141,
	14, 139, 135, 139, 131, 140, 129, 141, 128, 143, 128, 145, 130, 146, 132, 142, 14, 140, 135, 140,
	129, 141, 14, 143, 142, 141, 135, 140, 131, 139, 7, 139, 138, 138, 141, 136, 142, 134, 142, 131,
	141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 136, 129, 137, 130, 138,
	132, 139, 135, 132, 13, 130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130,
	135, 130, 132, 131, 129, 132, 128, 151, 0, 148, 0, 0, 0, 131, 21, 129, 142, 128, 136, 128, 132, 129,
	130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 132, 140, 135, 140, 137, 139, 140, 138, 141, 136,
	142, 134, 142, 132, 141, 131, 140, 130, 138, 129, 135, 132, 21, 130, 142, 129, 138, 129, 132, 130,
	129, 137, 2, 138, 132, 139, 135, 139, 138, 138, 140, 128, 21, 133, 149, 131, 142, 129, 135, 134, 0,
	136, 130, 137, 132, 138, 135, 138, 138, 137, 141, 136, 142, 129, 21, 132, 148, 130, 21, 131, 147,
	145, 0, 142, 0, 0, 0, 139, 10, 139, 139, 138, 139, 138, 137, 140, 137, 140, 139, 139, 141, 137, 142,
	134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137, 129,
	139, 132, 131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130, 135,
	130, 132, 131, 129, 132, 128, 145, 0, 142, 0, 0, 0, 143, 21, 140, 138, 139, 134, 139, 131, 140, 129,
	141, 128, 143, 128, 145, 130, 146, 132, 144, 21, 141, 138, 140, 134, 140, 129, 140, 21, 145, 149,
	141, 135, 140, 131, 139, 7, 139, 138, 138, 141, 136, 142, 134, 142, 131, 141, 129, 138, 128, 135,
	128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 136, 129, 137, 130, 138, 132, 139, 135, 131, 12,
	130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129,
	132, 128, 141, 21, 144, 148, 142, 21, 143, 147, 151, 0, 148, 0, 0, 0, 129, 5, 133, 134, 136, 135, 139,
	137, 140, 139, 139, 141, 137, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130,
	129, 132, 128, 134, 128, 137, 129, 139, 131, 131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 134,
	14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 144, 0, 142, 0, 0, 0, 146, 19, 146,
	148, 145, 148, 145, 146, 147, 146, 147, 148, 146, 149, 144, 149, 142, 148, 140, 146, 139, 144, 138,
	141, 137, 137, 135, 128, 134, 253, 133, 251, 131, 249, 140, 17, 139, 142, 138, 137, 136, 128, 135,
	253, 144, 21, 142, 147, 141, 145, 140, 142, 139, 137, 137, 129, 136, 254, 135, 252, 133, 250, 131,
	249, 129, 249, 128, 250, 128, 252, 130, 252, 130, 250, 129, 250, 129, 251, 134, 14, 145, 142, 152,
	0, 149, 0, 0, 0, 143, 14, 139, 128, 138, 253, 136, 250, 134, 249, 144, 14, 140, 128, 138, 252, 143,
	14, 145, 142, 141, 128, 139, 252, 137, 250, 134, 249, 131, 249, 129, 250, 128, 251, 128, 253, 130,
	253, 130, 251, 129, 251, 129, 252, 141, 7, 141, 138, 140, 141, 138, 142, 136, 142, 133, 141, 131,
	138, 130, 135, 130, 133, 131, 130, 132, 129, 134, 128, 136, 128, 138, 129, 139, 130, 140, 132, 141,
	135, 133, 12, 132, 138, 131, 135, 131, 132, 132, 130, 136, 14, 134, 140, 133, 138, 132, 135, 132,
	132, 133, 129, 134, 128, 150, 0, 147, 0, 0, 0, 134, 21, 128, 128, 130, 128, 135, 21, 129, 128, 131,
	21, 136, 149, 130, 128, 132, 7, 134, 139, 136, 141, 138, 142, 140, 142, 142, 141, 143, 139, 143,
	136, 141, 131, 142, 13, 142, 137, 141, 133, 141, 129, 142, 11, 140, 134, 140, 131, 141, 129, 142,
	128, 144, 128, 146, 130, 147, 132, 132, 21, 135, 148, 133, 21, 134, 147, 152, 0, 149, 0, 0, 0, 135,
	21, 135, 147, 137, 147, 137, 149, 135, 149, 136, 21, 136, 147, 135, 20, 137, 148, 128, 10, 129,
	140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133,
	129, 134, 11, 132, 134, 132, 131, 133, 129, 134, 128, 136, 128, 138, 130, 139, 132, 144, 0, 141, 0,
	0, 0, 140, 21, 140, 147, 142, 147, 142, 149, 140, 149, 141, 21, 141, 147, 140, 20, 142, 148, 132,
	10, 133, 140, 135, 142, 137, 142, 138, 141, 139, 139, 139, 136, 137, 129, 136, 254, 135, 252, 133,
	250, 131, 249, 129, 249, 128, 250, 128, 252, 130, 252, 130, 250, 129, 250, 129, 251, 138, 13, 138,
	136, 136, 129, 135, 254, 134, 252, 138, 11, 137, 135, 135, 128, 134, 253, 133, 251, 131, 249, 147,
	0, 144, 0, 0, 0, 134, 21, 128, 128, 130, 128, 135, 21, 129, 128, 131, 21, 136, 149, 130, 128, 144,
	12, 144, 141, 143, 141, 143, 139, 145, 139, 145, 141, 144, 142, 142, 142, 140, 141, 136, 137, 134,
	136, 132, 8, 134, 136, 136, 135, 137, 134, 139, 130, 140, 129, 142, 129, 136, 6, 138, 130, 139, 129,
	134, 8, 135, 135, 137, 129, 138, 128, 140, 128, 142, 129, 144, 132, 132, 21, 135, 148, 133, 21, 134,
	147, 150, 0, 147, 0, 0, 0, 132, 21, 129, 138, 128, 134, 128, 131, 129, 129, 130, 128, 132, 128, 134,
	130, 135, 132, 133, 21, 130, 138, 129, 134, 129, 129, 129, 21, 134, 149, 130, 135, 129, 131, 130,
	21, 133, 148, 131, 21, 132, 147, 140, 0, 137, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134,
	141, 135, 139, 135, 136, 133, 128, 134, 13, 134, 136, 132, 128, 134, 11, 133, 135, 131, 128, 133,
	128, 135, 8, 137, 139, 139, 141, 141, 142, 143, 142, 145, 141, 146, 139, 146, 136, 144, 128, 145,
	13, 145, 136, 143, 128, 145, 11, 144, 135, 142, 128, 144, 128, 146, 8, 148, 139, 150, 141, 152,
	142, 154, 142, 156, 141, 157, 139, 157, 136, 155, 131, 156, 13, 156, 137, 155, 133, 155, 129, 156,
	11, 154, 134, 154, 131, 155, 129, 156, 128, 158, 128, 160, 130, 161, 132, 166, 0, 163, 0, 0, 0, 128,
	10, 129, 140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 128, 134, 13, 134, 136, 132,
	128, 134, 11, 133, 135, 131, 128, 133, 128, 135, 8, 137, 139, 139, 141, 141, 142, 143, 142, 145,
	141, 146, 139, 146, 136, 144, 131, 145, 13, 145, 137, 144, 133, 144, 129, 145, 11, 143, 134, 143,
	131, 144, 129, 145, 128, 147, 128, 149, 130, 150, 132, 155, 0, 152, 0, 0, 0, 134, 14, 131, 141, 129,
	138, 128, 135, 128, 133, 129, 130, 130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142,
	137, 141, 140, 140, 141, 137, 142, 134, 142, 131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 139,
	2, 140, 132, 141, 135, 141, 138, 140, 140, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131,
	129, 133, 128, 136, 0, 138, 130, 139, 132, 140, 135, 140, 138, 139, 141, 137, 142, 147, 0, 144, 0, 0,
	0, 130, 10, 131, 140, 133, 142, 135, 142, 136, 141, 137, 139, 137, 136, 136, 132, 133, 249, 136,
	13, 136, 136, 135, 132, 132, 249, 136, 11, 135, 135, 131, 249, 137, 7, 138, 138, 139, 140, 140,
	141, 142, 142, 144, 142, 146, 141, 147, 140, 148, 137, 148, 135, 147, 132, 145, 129, 142, 128, 140,
	128, 138, 129, 137, 132, 137, 135, 146, 12, 147, 138, 147, 135, 146, 132, 145, 130, 144, 14, 145,
	141, 146, 138, 146, 135, 145, 132, 144, 130, 142, 128, 128, 121, 136, 249, 132, 122, 129, 249, 132,
	123, 130, 249, 133, 123, 134, 249, 132, 122, 135, 249, 153, 0, 150, 0, 0, 0, 141, 14, 135, 249, 142,
	14, 136, 249, 141, 14, 143, 142, 137, 249, 139, 7, 139, 138, 138, 141, 136, 142, 134, 142, 131,
	141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 136, 129, 137, 130, 138,
	132, 139, 135, 131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130,
	135, 130, 132, 131, 129, 132, 128, 132, 121, 140, 249, 136, 122, 133, 249, 136, 123, 134, 249, 137,
	123, 138, 249, 136, 122, 139, 249, 148, 0, 145, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134,
	141, 135, 139, 135, 135, 133, 128, 134, 13, 134, 135, 132, 128, 134, 11, 133, 135, 131, 128, 133,
	128, 143, 12, 143, 141, 142, 141, 142, 139, 144, 139, 144, 141, 143, 142, 141, 142, 139, 141, 137,
	139, 135, 135, 149, 0, 146, 0, 0, 0, 140, 11, 140, 140, 139, 140, 139, 138, 141, 138, 141, 140, 140,
	141, 137, 142, 134, 142, 131, 141, 130, 140, 130, 138, 131, 136, 133, 135, 136, 134, 138, 133, 139,
	131, 131, 13, 130, 138, 131, 9, 133, 136, 136, 135, 138, 134, 139, 5, 138, 129, 130, 12, 131, 138,
	133, 137, 136, 136, 138, 135, 139, 133, 139, 131, 138, 129, 135, 128, 132, 128, 129, 129, 128, 130,
	128, 132, 130, 132, 130, 130, 129, 130, 129, 131, 146, 0, 143, 0, 0, 0, 134, 21, 131, 138, 130, 134,
	130, 131, 131, 129, 132, 128, 134, 128, 136, 130, 137, 132, 135, 21, 132, 138, 131, 134, 131, 129,
	134, 21, 136, 149, 132, 135, 131, 131, 128, 14, 138, 142, 143, 0, 140, 0, 0, 0, 128, 10, 129, 140,
	131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129,
	134, 11, 132, 134, 132, 131, 133, 129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 134, 145, 14,
	143, 134, 143, 131, 144, 129, 145, 128, 147, 128, 149, 130, 150, 132, 146, 14, 144, 134, 144, 129,
	145, 14, 147, 142, 145, 135, 144, 131, 155, 0, 152, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142,
	134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 134, 11, 132, 134,
	132, 131, 133, 129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 134, 144, 138, 144, 142, 143, 142,
	143, 141, 144, 139, 149, 0, 146, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134, 141, 135, 139,
	135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 134, 11, 132, 134, 132, 131, 133, 129,
	135, 128, 137, 128, 139, 129, 141, 131, 142, 134, 144, 14, 142, 134, 142, 131, 143, 129, 145, 128,
	147, 128, 149, 129, 151, 131, 153, 134, 154, 138, 154, 142, 153, 142, 153, 141, 154, 139, 145, 14,
	143, 134, 143, 129, 144, 14, 146, 142, 144, 135, 143, 131, 159, 0, 156, 0, 0, 0, 130, 10, 132, 141,
	134, 142, 136, 142, 138, 141, 139, 139, 139, 137, 136, 14, 137, 141, 137, 137, 136, 133, 135, 131,
	133, 129, 131, 128, 129, 128, 128, 129, 128, 131, 130, 131, 130, 129, 129, 129, 129, 130, 138, 12,
	138, 137, 137, 133, 137, 130, 146, 12, 146, 141, 145, 141, 145, 139, 147, 139, 147, 141, 146, 142,
	144, 142, 142, 141, 140, 139, 139, 137, 138, 133, 138, 129, 139, 128, 136, 5, 136, 131, 137, 129,
	139, 128, 141, 128, 143, 129, 145, 132, 152, 0, 149, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142,
	134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 134, 11, 132, 134,
	132, 131, 133, 129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 135, 145, 14, 141, 128, 140, 253,
	138, 250, 136, 249, 146, 14, 142, 128, 140, 252, 145, 14, 147, 142, 143, 128, 141, 252, 139, 250,
	136, 249, 133, 249, 131, 250, 130, 251, 130, 253, 132, 253, 132, 251, 131, 251, 131, 252, 152, 0,
	149, 0, 0, 0, 142, 14, 141, 140, 139, 138, 131, 132, 129, 130, 128, 128, 141, 12, 132, 140, 130, 139,
	129, 137, 139, 12, 135, 141, 132, 141, 131, 140, 139, 12, 135, 142, 132, 142, 130, 140, 129, 137,
	129, 2, 138, 130, 140, 131, 141, 133, 131, 2, 135, 129, 138, 129, 139, 130, 131, 2, 135, 128, 138,
	128, 140, 130, 141, 133, 147, 0, 144, 0, 0, 0, 133, 25, 131, 152, 130, 151, 129, 149, 129, 147, 130,
	145, 131, 144, 132, 142, 132, 140, 130, 138, 131, 24, 130, 150, 130, 148, 131, 146, 132, 145, 133,
	143, 133, 141, 132, 139, 128, 137, 132, 135, 133, 133, 133, 131, 132, 129, 131, 128, 130, 254, 130,
	252, 131, 250, 130, 8, 132, 134, 132, 132, 131, 130, 130, 129, 129, 255, 129, 253, 130, 251, 131,
	250, 133, 249, 138, 0, 135, 0, 0, 0, 128, 121, 128, 153, 133, 0, 130, 0, 0, 0, 128, 25, 130, 152, 131,
	151, 132, 149, 132, 147, 131, 145, 130, 144, 129, 142, 129, 140, 131, 138, 130, 24, 131, 150, 131,
	148, 130, 146, 129, 145, 128, 143, 128, 141, 129, 139, 133, 137, 129, 135, 128, 133, 128, 131, 129,
	129, 130, 128, 131, 254, 131, 252, 130, 250, 131, 8, 129, 134, 129, 132, 130, 130, 131, 129, 132,
	255, 132, 253, 131, 251, 130, 250, 128, 249, 138, 0, 135, 0, 0, 0, 128, 15, 128, 145, 129, 148, 131,
	149, 133, 149, 135, 148, 139, 145, 141, 144, 143, 144, 145, 145, 146, 147, 146, 149, 128, 17, 129,
	147, 131, 148, 133, 148, 135, 147, 139, 144, 141, 143, 143, 143, 145, 144, 146, 147, 151, 0, 148, 0,
	0, 0, 128, 7, 128, 128, 142, 128, 142, 136, 135, 145, 128, 136, 128, 135, 135, 7, 135, 135, 146, 0,
	144, 0, 0, 0, 143, 20, 144, 148, 145, 150, 144, 144, 144, 146, 143, 148, 142, 149, 140, 150, 137,
	150, 134, 149, 132, 147, 130, 144, 129, 141, 128, 137, 128, 134, 129, 131, 130, 130, 133, 129, 136,
	129, 138, 130, 140, 132, 141, 134, 134, 20, 132, 146, 131, 144, 130, 141, 129, 137, 129, 133, 130,
	131, 137, 22, 135, 149, 133, 146, 132, 144, 131, 141, 130, 137, 130, 132, 131, 130, 133, 129, 140,
	121, 141, 250, 141, 251, 139, 253, 136, 254, 134, 255, 134, 128, 135, 129, 135, 255, 138, 255, 140,
	254, 143, 251, 143, 250, 142, 249, 138, 248, 142, 250, 142, 251, 140, 253, 137, 254, 138, 120, 134,
	248, 132, 250, 132, 252, 134, 252, 134, 250, 133, 250, 133, 251, 150, 0, 147, 0, 0, 0, 128, 10, 129,
	140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133,
	129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 134, 143, 131, 144, 129, 145, 128, 147, 128, 149,
	130, 150, 132, 134, 11, 132, 134, 132, 131, 133, 129, 144, 3, 145, 135, 147, 142, 145, 142, 143,
	134, 146, 14, 144, 134, 144, 129, 134, 20, 133, 147, 133, 146, 134, 145, 135, 145, 136, 146, 136,
	147, 135, 148, 134, 148, 134, 19, 134, 146, 135, 146, 135, 147, 134, 147, 143, 20, 142, 147, 142,
	146, 143, 145, 144, 145, 145, 146, 145, 147, 144, 148, 143, 148, 143, 19, 143, 146, 144, 146, 144,
	147, 143, 147, 155, 0, 152, 0, 0, 0, 129, 5, 133, 134, 136, 135, 139, 137, 140, 139, 139, 141, 137,
	142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137,
	129, 139, 131, 131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130,
	135, 130, 132, 131, 129, 132, 128, 138, 18, 139, 148, 139, 149, 138, 149, 137, 150, 137, 151, 138,
	152, 139, 152, 140, 151, 140, 149, 139, 147, 138, 146, 134, 145, 138, 23, 138, 150, 139, 150, 139,
	151, 138, 151, 144, 0, 142, 0, 0, 0, 140, 3, 141, 135, 143, 142, 141, 142, 139, 135, 139, 131, 140,
	129, 141, 128, 143, 128, 145, 130, 146, 132, 142, 14, 140, 135, 140, 129, 139, 7, 139, 138, 138,
	141, 136, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128, 134,
	128, 136, 129, 137, 130, 138, 132, 139, 135, 132, 13, 130, 138, 129, 135, 129, 132, 130, 130, 134,
	14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 133, 20, 135, 151, 137, 148, 130,
	17, 135, 150, 140, 145, 151, 0, 148, 0, 0, 0, 140, 3, 141, 135, 143, 142, 141, 142, 139, 135, 139,
	131, 140, 129, 141, 128, 143, 128, 145, 130, 146, 132, 142, 14, 140, 135, 140, 129, 139, 7, 139,
	138, 138, 141, 136, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132,
	128, 134, 128, 136, 129, 137, 130, 138, 132, 139, 135, 132, 13, 130, 138, 129, 135, 129, 132, 130,
	130, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 130, 20, 129, 147, 129,
	146, 130, 145, 131, 145, 132, 146, 132, 147, 131, 148, 130, 148, 130, 19, 130, 146, 131, 146, 131,
	147, 130, 147, 139, 20, 138, 147, 138, 146, 139, 145, 140, 145, 141, 146, 141, 147, 140, 148, 139,
	148, 139, 19, 139, 146, 140, 146, 140, 147, 139, 147, 151, 0, 148, 0, 0, 0, 140, 3, 141, 135, 143,
	142, 141, 142, 139, 135, 139, 131, 140, 129, 141, 128, 143, 128, 145, 130, 146, 132, 142, 14, 140,
	135, 140, 129, 139, 7, 139, 138, 138, 141, 136, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128,
	133, 129, 130, 130, 129, 132, 128, 134, 128, 136, 129, 137, 130, 138, 132, 139, 135, 132, 13, 130,
	138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132,
	128, 133, 18, 132, 148, 132, 149, 133, 149, 134, 150, 134, 151, 133, 152, 132, 152, 131, 151, 131,
	149, 132, 147, 133, 146, 137, 145, 133, 23, 133, 150, 132, 150, 132, 151, 133, 151, 151, 0, 148, 0,
	0, 0, 140, 3, 141, 135, 143, 142, 141, 142, 139, 135, 139, 131, 140, 129, 141, 128, 143, 128, 145,
	130, 146, 132, 142, 14, 140, 135, 140, 129, 139, 7, 139, 138, 138, 141, 136, 142, 134, 142, 131,
	141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 136, 129, 137, 130, 138,
	132, 139, 135, 132, 13, 130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130,
	135, 130, 132, 131, 129, 132, 128, 135, 20, 134, 147, 134, 146, 135, 145, 136, 145, 137, 146, 137,
	147, 136, 148, 135, 148, 135, 19, 135, 146, 136, 146, 136, 147, 135, 147, 151, 0, 148, 0, 0, 0, 130,
	124, 130, 251, 131, 251, 131, 253, 129, 253, 129, 251, 131, 249, 135, 249, 139, 250, 140, 251, 140,
	252, 137, 255, 135, 128, 132, 128, 132, 130, 131, 131, 130, 134, 130, 135, 131, 138, 132, 140, 134,
	142, 131, 141, 129, 138, 128, 135, 129, 132, 130, 131, 132, 130, 134, 130, 137, 131, 138, 132, 134,
	127, 137, 254, 139, 252, 139, 251, 137, 250, 138, 251, 138, 252, 136, 254, 133, 255, 131, 128, 131,
	129, 132, 130, 131, 12, 130, 138, 129, 135, 129, 134, 130, 132, 139, 10, 139, 139, 138, 139, 138,
	137, 140, 137, 140, 139, 139, 141, 137, 142, 134, 142, 137, 122, 135, 249, 145, 0, 142, 0, 0, 0, 129,
	5, 133, 134, 136, 135, 139, 137, 140, 139, 139, 141, 137, 142, 134, 142, 131, 141, 129, 138, 128,
	135, 128, 133, 129, 130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 131, 131, 12, 130, 138, 129,
	135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 133,
	20, 135, 151, 137, 148, 130, 17, 135, 150, 140, 145, 144, 0, 142, 0, 0, 0, 129, 5, 133, 134, 136,
	135, 139, 137, 140, 139, 139, 141, 137, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129,
	130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 131, 131, 12, 130, 138, 129, 135, 129, 132, 130,
	130, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 130, 20, 129, 147, 129,
	146, 130, 145, 131, 145, 132, 146, 132, 147, 131, 148, 130, 148, 130, 19, 130, 146, 131, 146, 131,
	147, 130, 147, 139, 20, 138, 147, 138, 146, 139, 145, 140, 145, 141, 146, 141, 147, 140, 148, 139,
	148, 139, 19, 139, 146, 140, 146, 140, 147, 139, 147, 144, 0, 143, 0, 0, 0, 129, 5, 133, 134, 136,
	135, 139, 137, 140, 139, 139, 141, 137, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129,
	130, 130, 129, 132, 128, 134, 128, 137, 129, 139, 131, 131, 12, 130, 138, 129, 135, 129, 132, 130,
	130, 134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 132, 18, 131, 148, 131,
	149, 132, 149, 133, 150, 133, 151, 132, 152, 131, 152, 130, 151, 130, 149, 131, 147, 132, 146, 136,
	145, 132, 23, 132, 150, 131, 150, 131, 151, 132, 151, 144, 0, 142, 0, 0, 0, 129, 10, 130, 140, 132,
	142, 134, 142, 135, 141, 136, 139, 136, 136, 134, 131, 135, 13, 135, 137, 134, 133, 134, 129, 135,
	128, 137, 128, 139, 130, 140, 132, 135, 11, 133, 134, 133, 131, 134, 129, 129, 20, 128, 147, 128,
	146, 129, 145, 130, 145, 131, 146, 131, 147, 130, 148, 129, 148, 129, 19, 129, 146, 130, 146, 130,
	147, 129, 147, 138, 20, 137, 147, 137, 146, 138, 145, 139, 145, 140, 146, 140, 147, 139, 148, 138,
	148, 138, 19, 138, 146, 139, 146, 139, 147, 138, 147, 144, 0, 142, 0, 0, 0, 129, 10, 130, 140, 132,
	142, 134, 142, 135, 141, 136, 139, 136, 136, 134, 131, 135, 13, 135, 137, 134, 133, 134, 129, 135,
	128, 137, 128, 139, 130, 140, 132, 135, 11, 133, 134, 133, 131, 134, 129, 131, 20, 133, 151, 135,
	148, 128, 17, 133, 150, 138, 145, 144, 0, 142, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134,
	141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 134, 128, 136, 128, 138,
	130, 139, 132, 134, 11, 132, 134, 132, 131, 133, 129, 130, 18, 129, 148, 129, 149, 130, 149, 131,
	150, 131, 151, 130, 152, 129, 152, 128, 151, 128, 149, 129, 147, 130, 146, 134, 145, 130, 23, 130,
	150, 129, 150, 129, 151, 130, 151, 144, 0, 141, 0, 0, 0, 144, 0, 144, 130, 143, 147, 143, 149, 131,
	129, 129, 128, 141, 17, 142, 128, 142, 19, 143, 129, 134, 6, 142, 134, 128, 0, 134, 128, 139, 0, 146,
	128, 131, 1, 133, 128, 142, 1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 138, 26, 137, 153, 137,
	152, 138, 151, 139, 151, 140, 152, 140, 153, 139, 154, 138, 154, 138, 25, 138, 152, 139, 152, 139,
	153, 138, 153, 147, 26, 146, 153, 146, 152, 147, 151, 148, 151, 149, 152, 149, 153, 148, 154, 147,
	154, 147, 25, 147, 152, 148, 152, 148, 153, 147, 153, 151, 0, 0, 0, 144, 0, 144, 130, 143, 147, 143,
	149, 131, 129, 129, 128, 141, 17, 142, 128, 142, 19, 143, 129, 134, 6, 142, 134, 128, 0, 134, 128,
	139, 0, 146, 128, 131, 1, 133, 128, 142, 1, 140, 128, 142, 2, 141, 128, 144, 2, 145, 128, 142, 27,
	141, 154, 141, 153, 142, 152, 143, 152, 144, 153, 144, 154, 143, 155, 142, 155, 142, 26, 142, 153,
	143, 153, 143, 154, 142, 154, 151, 0, 148, 0, 0, 0, 128, 0, 143, 128, 144, 131, 143, 130, 140, 128,
	135, 0, 132, 129, 129, 128, 132, 2, 130, 128, 133, 2, 134, 128, 138, 0, 143, 129, 132, 14, 147, 142,
	146, 138, 146, 142, 133, 14, 136, 141, 139, 142, 134, 14, 135, 140, 138, 14, 136, 140, 143, 14, 146,
	141, 144, 14, 146, 140, 145, 14, 146, 139, 131, 0, 135, 142, 132, 0, 136, 142, 133, 0, 137, 142, 141,
	0, 144, 131, 142, 128, 142, 11, 140, 131, 140, 135, 142, 139, 135, 7, 141, 135, 141, 9, 139, 135,
	140, 133, 141, 8, 138, 135, 140, 134, 140, 3, 140, 132, 142, 18, 143, 148, 143, 149, 142, 149, 141,
	150, 141, 151, 142, 152, 143, 152, 144, 151, 144, 149, 143, 147, 142, 146, 138, 145, 142, 23, 142,
	150, 143, 150, 143, 151, 142, 151, 154, 0, 149, 0, 0, 0, 139, 0, 140, 131, 141, 135, 143, 142, 141,
	142, 139, 135, 139, 138, 138, 141, 136, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129,
	130, 130, 129, 132, 128, 134, 128, 136, 129, 137, 130, 138, 132, 139, 135, 137, 128, 139, 128, 142,
	14, 138, 128, 132, 13, 130, 138, 129, 135, 129, 132, 130, 130, 134, 14, 132, 140, 131, 138, 130,
	135, 130, 132, 131, 129, 132, 128, 142, 5, 146, 134, 149, 135, 152, 137, 153, 139, 152, 141, 150,
	142, 147, 142, 144, 141, 142, 138, 147, 14, 145, 140, 144, 138, 143, 135, 143, 132, 144, 129, 145,
	128, 147, 128, 150, 129, 152, 131, 141, 7, 141, 133, 142, 130, 143, 129, 145, 128, 156, 0, 155, 0, 0,
	0, 145, 21, 139, 128, 146, 21, 140, 128, 147, 21, 141, 128, 151, 15, 149, 135, 149, 139, 151, 143,
	142, 21, 157, 149, 156, 143, 156, 149, 144, 11, 150, 139, 136, 0, 151, 128, 153, 133, 151, 130, 148,
	128, 129, 0, 131, 129, 143, 149, 146, 148, 149, 149, 144, 21, 145, 147, 148, 21, 146, 147, 153, 21,
	156, 148, 154, 21, 156, 147, 155, 21, 156, 146, 150, 13, 148, 139, 149, 137, 150, 12, 147, 139, 149,
	138, 143, 0, 140, 129, 137, 128, 140, 2, 138, 128, 141, 2, 142, 128, 146, 0, 151, 129, 131, 1, 133,
	128, 128, 0, 134, 128, 134, 6, 141, 134, 160, 0, 159, 0, 0, 0, 134, 14, 131, 141, 129, 138, 128, 135,
	128, 133, 129, 130, 130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 137, 141, 140,
	140, 141, 137, 142, 134, 142, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 133, 128, 131, 12,
	130, 138, 129, 135, 129, 132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 138, 140, 140, 136, 0, 138,
	130, 139, 132, 140, 135, 140, 138, 139, 141, 137, 142, 134, 20, 136, 151, 138, 148, 131, 17, 136,
	150, 141, 145, 147, 0, 144, 0, 0, 0, 134, 14, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130,
	129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 137, 141, 140, 140, 141, 137, 142, 134,
	142, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 133, 128, 131, 12, 130, 138, 129, 135, 129,
	132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 138, 140, 140, 136, 0, 138, 130, 139, 132, 140, 135,
	140, 138, 139, 141, 137, 142, 130, 20, 129, 147, 129, 146, 130, 145, 131, 145, 132, 146, 132, 147,
	131, 148, 130, 148, 130, 19, 130, 146, 131, 146, 131, 147, 130, 147, 139, 20, 138, 147, 138, 146,
	139, 145, 140, 145, 141, 146, 141, 147, 140, 148, 139, 148, 139, 19, 139, 146, 140, 146, 140, 147,
	139, 147, 147, 0, 144, 0, 0, 0, 134, 14, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129,
	133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 137, 141, 140, 140, 141, 137, 142, 134, 142,
	132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 133, 128, 131, 12, 130, 138, 129, 135, 129, 132,
	130, 130, 139, 2, 140, 132, 141, 135, 141, 138, 140, 140, 136, 0, 138, 130, 139, 132, 140, 135, 140,
	138, 139, 141, 137, 142, 132, 18, 131, 148, 131, 149, 132, 149, 133, 150, 133, 151, 132, 152, 131,
	152, 130, 151, 130, 149, 131, 147, 132, 146, 136, 145, 132, 23, 132, 150, 131, 150, 131, 151, 132,
	151, 147, 0, 144, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133,
	131, 134, 13, 134, 137, 133, 133, 133, 129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 134, 143,
	131, 144, 129, 145, 128, 147, 128, 149, 130, 150, 132, 134, 11, 132, 134, 132, 131, 133, 129, 144,
	3, 145, 135, 147, 142, 145, 142, 143, 134, 146, 14, 144, 134, 144, 129, 137, 20, 139, 151, 141,
	148, 134, 17, 139, 150, 144, 145, 155, 0, 152, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134,
	141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 135, 128, 137, 128, 139,
	129, 141, 131, 143, 134, 143, 131, 144, 129, 145, 128, 147, 128, 149, 130, 150, 132, 134, 11, 132,
	134, 132, 131, 133, 129, 144, 3, 145, 135, 147, 142, 145, 142, 143, 134, 146, 14, 144, 134, 144,
	129, 137, 18, 136, 148, 136, 149, 137, 149, 138, 150, 138, 151, 137, 152, 136, 152, 135, 151, 135,
	149, 136, 147, 137, 146, 141, 145, 137, 23, 137, 150, 136, 150, 136, 151, 137, 151, 155, 0, 152, 0,
	0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134,
	137, 133, 133, 133, 129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 135, 134, 11, 132, 134, 132,
	131, 133, 129, 136, 121, 139, 250, 141, 252, 143, 128, 147, 142, 145, 142, 141, 128, 140, 253, 138,
	250, 136, 249, 133, 249, 131, 250, 130, 251, 130, 253, 132, 253, 132, 251, 131, 251, 131, 252, 146,
	14, 142, 128, 140, 252, 135, 20, 134, 147, 134, 146, 135, 145, 136, 145, 137, 146, 137, 147, 136,
	148, 135, 148, 135, 19, 135, 146, 136, 146, 136, 147, 135, 147, 144, 20, 143, 147, 143, 146, 144,
	145, 145, 145, 146, 146, 146, 147, 145, 148, 144, 148, 144, 19, 144, 146, 145, 146, 145, 147, 144,
	147, 152, 0, 149, 0, 0, 0, 137, 21, 134, 148, 132, 146, 130, 143, 129, 140, 128, 136, 128, 133, 129,
	130, 130, 129, 132, 128, 135, 128, 138, 129, 140, 131, 142, 134, 143, 137, 144, 141, 144, 144, 143,
	147, 142, 148, 140, 149, 137, 149, 135, 148, 133, 145, 132, 143, 131, 140, 130, 136, 130, 131, 131,
	129, 132, 128, 133, 18, 131, 143, 130, 140, 129, 136, 129, 132, 130, 130, 139, 3, 141, 134, 142,
	137, 143, 141, 143, 145, 142, 147, 135, 0, 137, 129, 139, 132, 140, 134, 141, 137, 142, 141, 142,
	146, 141, 148, 140, 149, 141, 27, 140, 154, 140, 153, 141, 152, 142, 152, 143, 153, 143, 154, 142,
	155, 141, 155, 141, 26, 141, 153, 142, 153, 142, 154, 141, 154, 133, 27, 132, 154, 132, 153, 133,
	152, 134, 152, 135, 153, 135, 154, 134, 155, 133, 155, 133, 26, 133, 153, 134, 153, 134, 154, 133,
	154, 149, 0, 146, 0, 0, 0, 132, 21, 129, 138, 128, 134, 128, 131, 129, 129, 132, 128, 136, 128, 139,
	129, 141, 131, 142, 134, 146, 148, 144, 149, 133, 21, 130, 138, 129, 134, 129, 130, 130, 129, 134,
	21, 131, 138, 130, 134, 130, 130, 132, 128, 129, 21, 137, 149, 143, 21, 149, 149, 130, 21, 133,
	148, 136, 149, 131, 21, 132, 147, 135, 21, 133, 147, 148, 21, 146, 148, 135, 27, 134, 154, 134, 153,
	135, 152, 136, 152, 137, 153, 137, 154, 136, 155, 135, 155, 135, 26, 135, 153, 136, 153, 136, 154,
	135, 154, 144, 27, 143, 154, 143, 153, 144, 152, 145, 152, 146, 153, 146, 154, 145, 155, 144, 155,
	144, 26, 144, 153, 145, 153, 145, 154, 144, 154, 154, 0, 151, 0, 0, 0, 134, 14, 131, 141, 129, 138,
	128, 135, 128, 133, 129, 130, 130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 137,
	141, 140, 140, 141, 137, 142, 134, 142, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 133, 128,
	131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 138, 140, 140,
	136, 0, 138, 130, 139, 132, 140, 135, 140, 138, 139, 141, 137, 142, 141, 15, 142, 143, 129, 255,
	128, 255, 141, 143, 147, 0, 144, 0, 0, 0, 141, 20, 139, 147, 138, 146, 136, 142, 134, 135, 133, 130,
	136, 128, 138, 0, 143, 129, 144, 130, 144, 131, 141, 131, 141, 130, 140, 129, 137, 128, 133, 0, 137,
	142, 139, 146, 140, 147, 142, 148, 144, 148, 145, 147, 145, 146, 147, 147, 146, 148, 144, 149, 142,
	149, 138, 147, 137, 146, 135, 142, 133, 135, 132, 131, 131, 132, 130, 132, 129, 131, 129, 130, 131,
	128, 139, 128, 141, 1, 142, 130, 143, 130, 132, 10, 133, 139, 141, 139, 139, 138, 134, 138, 133,
	137, 132, 137, 132, 138, 145, 20, 146, 147, 130, 2, 131, 129, 131, 3, 132, 130, 130, 3, 132, 129,
	154, 0, 149, 0, 0, 0, 139, 21, 136, 148, 134, 146, 132, 143, 131, 140, 130, 136, 130, 133, 131, 130,
	132, 129, 134, 128, 137, 128, 140, 129, 142, 131, 144, 134, 145, 137, 146, 141, 146, 144, 145, 147,
	144, 148, 142, 149, 139, 149, 137, 148, 135, 145, 134, 143, 133, 140, 132, 136, 132, 131, 133, 129,
	134, 128, 135, 18, 133, 143, 132, 140, 131, 136, 131, 132, 132, 130, 141, 3, 143, 134, 144, 137,
	145, 141, 145, 145, 144, 147, 137, 0, 139, 129, 141, 132, 142, 134, 143, 137, 144, 141, 144, 146,
	143, 148, 142, 149, 147, 22, 148, 150, 129, 255, 128, 255, 147, 150, 151, 0, 150, 0, 0, 0, 136, 24,
	148, 152, 151, 151, 152, 149, 152, 147, 151, 144, 149, 142, 145, 141, 137, 141, 150, 23, 151, 149,
	151, 147, 150, 144, 148, 142, 148, 24, 149, 151, 150, 149, 150, 147, 149, 144, 147, 142, 145, 141,
	137, 24, 140, 151, 143, 152, 138, 24, 139, 150, 142, 24, 140, 150, 141, 24, 134, 128, 140, 24, 133,
	128, 139, 24, 132, 128, 129, 0, 137, 128, 136, 0, 133, 129, 130, 128, 133, 2, 131, 128, 134, 2, 135,
	128, 151, 3, 152, 135, 155, 145, 153, 145, 151, 138, 150, 134, 150, 131, 151, 129, 152, 128, 154,
	128, 156, 130, 157, 132, 154, 17, 152, 138, 151, 134, 151, 129, 147, 10, 157, 138, 160, 0, 159, 0, 0,
	0, 134, 124, 136, 253, 137, 254, 139, 130, 143, 144, 145, 148, 146, 149, 148, 150, 142, 16, 138,
	130, 136, 254, 135, 253, 133, 252, 131, 252, 130, 253, 130, 254, 128, 253, 129, 252, 131, 251, 133,
	251, 137, 253, 138, 254, 140, 130, 144, 144, 146, 148, 147, 149, 149, 150, 151, 150, 152, 149, 152,
	148, 154, 149, 153, 150, 151, 151, 149, 151, 145, 149, 144, 148, 142, 144, 138, 130, 130, 124, 129,
	253, 140, 2, 144, 144, 152, 22, 153, 149, 145, 9, 144, 136, 136, 136, 138, 137, 143, 137, 144, 138,
	145, 138, 145, 137, 155, 0, 156, 0, 0, 0, 140, 3, 141, 135, 143, 142, 141, 142, 139, 135, 139, 131,
	140, 129, 141, 128, 143, 128, 145, 130, 146, 132, 142, 14, 140, 135, 140, 129, 139, 7, 139, 138,
	138, 141, 136, 142, 134, 142, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130, 130, 129, 132, 128,
	134, 128, 136, 129, 137, 130, 138, 132, 139, 135, 132, 13, 130, 138, 129, 135, 129, 132, 130, 130,
	134, 14, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 132, 128, 138, 18, 139, 148, 139, 149,
	138, 149, 137, 150, 137, 151, 138, 152, 139, 152, 140, 151, 140, 149, 139, 147, 138, 146, 134, 145,
	138, 23, 138, 150, 139, 150, 139, 151, 138, 151, 151, 0, 148, 0, 0, 0, 128, 10, 129, 140, 131, 142,
	133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 134, 128,
	136, 128, 138, 130, 139, 132, 134, 11, 132, 134, 132, 131, 133, 129, 136, 18, 137, 148, 137, 149,
	136, 149, 135, 150, 135, 151, 136, 152, 137, 152, 138, 151, 138, 149, 137, 147, 136, 146, 132, 145,
	136, 23, 136, 150, 137, 150, 137, 151, 136, 151, 144, 0, 141, 0, 0, 0, 134, 14, 131, 141, 129, 138,
	128, 135, 128, 133, 129, 130, 130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 137,
	141, 140, 140, 141, 137, 142, 134, 142, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 133, 128,
	131, 12, 130, 138, 129, 135, 129, 132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 138, 140, 140,
	136, 0, 138, 130, 139, 132, 140, 135, 140, 138, 139, 141, 137, 142, 137, 18, 138, 148, 138, 149,
	137, 149, 136, 150, 136, 151, 137, 152, 138, 152, 139, 151, 139, 149, 138, 147, 137, 146, 133, 145,
	137, 23, 137, 150, 138, 150, 138, 151, 137, 151, 147, 0, 144, 0, 0, 0, 128, 10, 129, 140, 131, 142,
	133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133, 133, 129, 135, 128,
	137, 128, 139, 129, 141, 131, 143, 134, 143, 131, 144, 129, 145, 128, 147, 128, 149, 130, 150, 132,
	134, 11, 132, 134, 132, 131, 133, 129, 144, 3, 145, 135, 147, 142, 145, 142, 143, 134, 146, 14, 144,
	134, 144, 129, 141, 18, 142, 148, 142, 149, 141, 149, 140, 150, 140, 151, 141, 152, 142, 152, 143,
	151, 143, 149, 142, 147, 141, 146, 137, 145, 141, 23, 141, 150, 142, 150, 142, 151, 141, 151, 155,
	0, 152, 0, 0, 0, 128, 10, 129, 140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 128,
	131, 128, 133, 135, 134, 139, 134, 13, 134, 136, 132, 128, 135, 8, 137, 139, 139, 141, 141, 142,
	143, 142, 145, 141, 146, 139, 146, 136, 144, 131, 145, 13, 145, 137, 144, 133, 144, 129, 145, 128,
	147, 128, 149, 130, 150, 132, 145, 11, 143, 134, 143, 131, 144, 129, 133, 17, 134, 148, 136, 149,
	138, 149, 142, 147, 144, 147, 146, 148, 147, 150, 146, 147, 144, 146, 142, 146, 138, 148, 136, 148,
	134, 147, 133, 145, 155, 0, 152, 0, 0, 0, 134, 21, 139, 149, 145, 131, 144, 128, 137, 149, 131, 129,
	129, 128, 138, 21, 144, 131, 148, 21, 150, 148, 145, 131, 147, 21, 153, 149, 128, 0, 134, 128, 135,
	21, 138, 148, 136, 21, 138, 147, 152, 21, 150, 148, 131, 1, 133, 128, 134, 24, 134, 154, 135, 157,
	137, 158, 139, 158, 141, 157, 145, 154, 147, 153, 149, 153, 151, 154, 152, 156, 152, 158, 134, 26,
	135, 156, 137, 157, 139, 157, 141, 156, 145, 153, 147, 152, 149, 152, 151, 153, 152, 156, 158, 0,
	155, 0, 0, 0, 140, 10, 141, 142, 143, 149, 141, 149, 139, 142, 139, 138, 140, 136, 141, 135, 143,
	135, 145, 137, 146, 139, 142, 21, 140, 142, 140, 136, 139, 14, 139, 145, 138, 148, 136, 149, 134,
	149, 131, 148, 129, 145, 128, 142, 128, 140, 129, 137, 130, 136, 132, 135, 134, 135, 136, 136, 137,
	137, 138, 139, 139, 142, 132, 20, 130, 145, 129, 142, 129, 139, 130, 137, 134, 21, 132, 147, 131,
	145, 130, 142, 130, 139, 131, 136, 132, 135, 128, 0, 147, 128, 147, 129, 128, 129, 128, 128, 151, 0,
	149, 0, 0, 0, 128, 14, 129, 139, 130, 138, 133, 137, 136, 137, 139, 138, 141, 141, 142, 142, 142,
	144, 141, 147, 140, 148, 137, 149, 134, 149, 131, 148, 129, 145, 128, 142, 131, 19, 130, 145, 129,
	142, 129, 141, 130, 139, 139, 11, 140, 141, 141, 142, 141, 145, 140, 147, 134, 21, 132, 147, 131,
	145, 130, 142, 130, 141, 131, 138, 133, 137, 136, 9, 138, 139, 139, 141, 140, 142, 140, 145, 139,
	148, 137, 149, 128, 0, 142, 128, 142, 129, 128, 129, 128, 128, 147, 0, 144, 0, 0, 0, 140, 5, 140, 132,
	139, 132, 139, 134, 141, 134, 141, 132, 140, 130, 139, 129, 136, 128, 132, 128, 129, 129, 128, 131,
	128, 133, 129, 135, 130, 136, 132, 137, 136, 138, 138, 139, 138, 141, 136, 142, 135, 142, 134, 0,
	129, 129, 130, 1, 129, 131, 129, 133, 130, 135, 131, 136, 133, 137, 132, 0, 131, 129, 130, 131, 130,
	133, 131, 135, 132, 136, 136, 138, 137, 139, 137, 141, 136, 142, 139, 18, 140, 147, 140, 148, 139,
	149, 138, 149, 137, 148, 137, 147, 138, 146, 139, 146, 139, 19, 139, 148, 138, 148, 138, 147, 139,
	147, 146, 0, 143, 0, 0, 0, 128, 0, 128, 135, 141, 135, 141, 132, 131, 132, 131, 128, 128, 128, 151, 0,
	143, 0, 0, 0, 141, 0, 141, 135, 128, 135, 128, 132, 138, 132, 138, 128, 141, 128, 151, 0, 143, 0, 0, 0,
	140, 21, 137, 138, 135, 138, 137, 145, 135, 144, 132, 143, 134, 144, 137, 146, 140, 149, 138, 145,
	136, 138, 135, 135, 132, 0, 152, 149, 153, 149, 133, 128, 132, 128, 128, 252, 129, 252, 133, 128,
	146, 0, 148, 132, 153, 134, 156, 136, 157, 138, 157, 139, 155, 141, 153, 142, 150, 142, 148, 141,
	147, 140, 147, 138, 150, 138, 150, 140, 148, 140, 148, 139, 147, 2, 148, 131, 149, 131, 152, 128,
	154, 128, 156, 129, 157, 130, 157, 132, 157, 2, 155, 129, 152, 129, 149, 131, 152, 130, 156, 130,
	157, 131, 153, 14, 156, 139, 156, 137, 153, 134, 135, 10, 134, 135, 136, 135, 137, 138, 152, 21,
	156, 153, 157, 153, 153, 149, 160, 0, 159, 0, 0, 0, 140, 21, 137, 138, 136, 135, 134, 135, 135, 138,
	137, 145, 135, 144, 132, 143, 134, 144, 137, 146, 140, 149, 138, 145, 136, 138, 135, 135, 132, 0,
	152, 149, 156, 153, 157, 153, 153, 149, 133, 128, 132, 128, 128, 252, 129, 252, 133, 128, 155, 12,
	151, 128, 153, 128, 157, 142, 146, 132, 157, 132, 156, 13, 152, 128, 160, 0, 159, 0, 0, 0, 135, 0,
	134, 128, 133, 129, 131, 142, 134, 129, 135, 129, 135, 130, 131, 142, 136, 130, 136, 129, 135, 128,
	129, 18, 128, 147, 128, 148, 129, 149, 130, 149, 131, 148, 131, 147, 130, 146, 129, 146, 129, 19,
	129, 148, 130, 148, 130, 147, 129, 147, 141, 0, 138, 0, 0, 0, 137, 6, 128, 140, 137, 146, 147, 6, 138,
	140, 147, 146, 151, 0, 149, 0, 0, 0, 138, 6, 147, 140, 138, 146, 128, 6, 137, 140, 128, 146, 151, 0,
	149, 0, 0, 0, 132, 21, 134, 149, 134, 147, 132, 147, 132, 149, 133, 21, 133, 147, 132, 15, 134, 143,
	134, 141, 132, 141, 132, 143, 133, 15, 133, 141, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137,
	133, 9, 133, 135, 132, 3, 134, 131, 134, 129, 132, 129, 132, 131, 133, 3, 133, 129, 128, 18, 130,
	146, 130, 144, 128, 144, 128, 146, 129, 18, 129, 144, 128, 12, 130, 140, 130, 138, 128, 138, 128,
	140, 129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129, 132, 128, 0,
	130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254, 136, 18, 138, 146, 138, 144, 136, 144,
	136, 146, 137, 18, 137, 144, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138,
	136, 6, 138, 134, 138, 132, 136, 132, 136, 134, 137, 6, 137, 132, 136, 0, 138, 128, 138, 254, 136,
	254, 136, 128, 137, 0, 137, 254, 140, 21, 142, 149, 142, 147, 140, 147, 140, 149, 141, 21, 141, 147,
	140, 15, 142, 143, 142, 141, 140, 141, 140, 143, 141, 15, 141, 141, 140, 9, 142, 137, 142, 135, 140,
	135, 140, 137, 141, 9, 141, 135, 140, 3, 142, 131, 142, 129, 140, 129, 140, 131, 141, 3, 141, 129,
	131, 125, 131, 251, 133, 251, 133, 253, 131, 253, 132, 125, 132, 251, 140, 125, 140, 251, 142, 251,
	142, 253, 140, 253, 142, 125, 142, 253, 141, 125, 141, 251, 142, 0, 144, 0, 0, 0, 128, 18, 130, 146,
	130, 144, 128, 144, 128, 146, 129, 18, 129, 144, 128, 12, 130, 140, 130, 138, 128, 138, 128, 140,
	129, 12, 129, 138, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129, 132, 128, 0, 130,
	128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254, 130, 21, 132, 149, 132, 147, 130, 147, 130,
	149, 131, 21, 131, 147, 130, 15, 132, 143, 132, 141, 130, 141, 130, 143, 131, 15, 131, 141, 130, 9,
	132, 137, 132, 135, 130, 135, 130, 137, 131, 9, 131, 135, 130, 3, 132, 131, 132, 129, 130, 129, 130,
	131, 131, 3, 131, 129, 132, 18, 134, 146, 134, 144, 132, 144, 132, 146, 133, 18, 133, 144, 132, 12,
	134, 140, 134, 138, 132, 138, 132, 140, 133, 12, 133, 138, 132, 6, 134, 134, 134, 132, 132, 132,
	132, 134, 133, 6, 133, 132, 132, 0, 134, 128, 134, 254, 132, 254, 132, 128, 133, 0, 133, 254, 134,
	21, 136, 149, 136, 147, 134, 147, 134, 149, 135, 21, 135, 147, 134, 15, 136, 143, 136, 141, 134,
	141, 134, 143, 135, 15, 135, 141, 136, 7, 134, 135, 134, 137, 136, 137, 136, 135, 135, 9, 135, 135,
	136, 1, 134, 129, 134, 131, 136, 131, 136, 129, 135, 3, 135, 129, 138, 18, 138, 144, 136, 144, 136,
	146, 138, 146, 137, 18, 137, 144, 138, 12, 138, 138, 136, 138, 136, 140, 138, 140, 137, 12, 137,
	138, 138, 6, 138, 132, 136, 132, 136, 134, 138, 134, 137, 6, 137, 132, 138, 0, 138, 254, 136, 254,
	136, 128, 138, 128, 137, 0, 137, 254, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139,
	147, 138, 15, 140, 143, 140, 141, 138, 141, 138, 143, 139, 15, 139, 141, 138, 9, 140, 137, 140, 135,
	138, 135, 138, 137, 139, 9, 139, 135, 138, 3, 140, 131, 140, 129, 138, 129, 138, 131, 139, 3, 139,
	129, 140, 18, 142, 146, 142, 144, 140, 144, 140, 146, 141, 18, 141, 144, 140, 12, 142, 140, 142,
	138, 140, 138, 140, 140, 141, 12, 141, 138, 140, 6, 142, 134, 142, 132, 140, 132, 140, 134, 141, 6,
	141, 132, 140, 0, 142, 128, 142, 254, 140, 254, 140, 128, 141, 0, 141, 254, 142, 21, 144, 149, 144,
	147, 142, 147, 142, 149, 143, 21, 143, 147, 142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 143,
	15, 143, 141, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143, 135, 142, 3, 144, 131,
	144, 129, 142, 129, 142, 131, 143, 3, 143, 129, 130, 125, 130, 251, 132, 251, 132, 253, 130, 253,
	131, 125, 131, 251, 135, 125, 134, 253, 134, 251, 136, 251, 136, 253, 135, 253, 135, 251, 139, 125,
	138, 253, 138, 251, 140, 251, 140, 253, 139, 253, 139, 251, 143, 125, 142, 253, 142, 251, 144, 251,
	144, 253, 143, 253, 143, 251, 141, 125, 141, 253, 144, 0, 146, 0, 0, 0, 128, 21, 130, 149, 130, 147,
	128, 147, 128, 149, 129, 21, 129, 147, 130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21,
	131, 147, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139, 147, 140, 21, 142, 149,
	142, 147, 140, 147, 140, 149, 141, 21, 141, 147, 148, 21, 150, 149, 150, 147, 148, 147, 148, 149,
	149, 21, 149, 147, 150, 21, 152, 149, 152, 147, 150, 147, 150, 149, 151, 21, 151, 147, 132, 17, 134,
	145, 134, 143, 132, 143, 132, 145, 133, 17, 133, 143, 134, 17, 136, 145, 136, 143, 134, 143, 134,
	145, 135, 17, 135, 143, 136, 17, 138, 145, 138, 143, 136, 143, 136, 145, 137, 17, 137, 143, 128, 13,
	130, 141, 130, 139, 128, 139, 128, 141, 129, 13, 129, 139, 130, 13, 132, 141, 132, 139, 130, 139,
	130, 141, 131, 13, 131, 139, 138, 13, 140, 141, 140, 139, 138, 139, 138, 141, 139, 13, 139, 139,
	140, 13, 142, 141, 142, 139, 140, 139, 140, 141, 141, 13, 141, 139, 148, 13, 150, 141, 150, 139,
	148, 139, 148, 141, 149, 13, 149, 139, 150, 13, 152, 141, 152, 139, 150, 139, 150, 141, 151, 13,
	151, 139, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143, 135, 144, 9, 146, 137, 146,
	135, 144, 135, 144, 137, 145, 9, 145, 135, 146, 9, 148, 137, 148, 135, 146, 135, 146, 137, 147, 9,
	147, 135, 128, 5, 130, 133, 130, 131, 128, 131, 128, 133, 129, 5, 129, 131, 130, 5, 132, 133, 132,
	131, 130, 131, 130, 133, 131, 5, 131, 131, 138, 5, 140, 133, 140, 131, 138, 131, 138, 133, 139, 5,
	139, 131, 140, 5, 142, 133, 142, 131, 140, 131, 140, 133, 141, 5, 141, 131, 148, 5, 150, 133, 150,
	131, 148, 131, 148, 133, 149, 5, 149, 131, 150, 5, 152, 133, 152, 131, 150, 131, 150, 133, 151, 5,
	151, 131, 132, 1, 138, 129, 138, 255, 132, 255, 132, 129, 133, 1, 133, 255, 135, 1, 135, 255, 137, 1,
	137, 255, 128, 125, 130, 253, 130, 251, 128, 251, 128, 253, 129, 125, 129, 251, 130, 125, 132, 253,
	132, 251, 130, 251, 130, 253, 131, 125, 131, 251, 138, 125, 142, 253, 142, 251, 138, 251, 138, 253,
	139, 125, 139, 251, 141, 125, 141, 251, 148, 125, 152, 253, 152, 251, 148, 251, 148, 253, 149, 125,
	149, 251, 151, 125, 151, 251, 140, 125, 140, 251, 150, 125, 150, 251, 136, 1, 136, 255, 134, 1, 134,
	255, 146, 17, 148, 145, 148, 143, 146, 143, 146, 145, 147, 17, 147, 143, 148, 17, 150, 145, 150,
	143, 148, 143, 148, 145, 149, 17, 149, 143, 150, 17, 152, 145, 152, 143, 150, 143, 150, 145, 151,
	17, 151, 143, 128, 9, 130, 137, 130, 135, 128, 135, 128, 137, 129, 9, 129, 135, 130, 9, 132, 137,
	132, 135, 130, 135, 130, 137, 131, 9, 131, 135, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133,
	9, 133, 135, 146, 1, 152, 129, 152, 255, 146, 255, 146, 129, 147, 1, 147, 255, 149, 1, 149, 255,
	151, 1, 151, 255, 150, 1, 150, 255, 148, 1, 148, 255, 152, 0, 154, 0, 0, 0, 128, 21, 128, 249, 132, 1,
	132, 129, 132, 0, 134, 0, 0, 0, 137, 121, 137, 149, 128, 5, 137, 133, 141, 0, 139, 0, 0, 0, 137, 21,
	137, 249, 128, 9, 137, 137, 128, 5, 137, 133, 141, 0, 139, 0, 0, 0, 137, 121, 137, 149, 128, 5, 137,
	133, 145, 121, 145, 149, 149, 0, 147, 0, 0, 0, 128, 5, 145, 133, 145, 249, 137, 5, 137, 249, 149, 0,
	147, 0, 0, 0, 128, 9, 137, 137, 137, 249, 128, 5, 137, 133, 141, 0, 139, 0, 0, 0, 128, 5, 137, 133, 137,
	249, 145, 121, 145, 149, 128, 9, 137, 137, 137, 149, 149, 0, 147, 0, 0, 0, 137, 121, 137, 149, 145,
	121, 145, 149, 149, 0, 147, 0, 0, 0, 128, 9, 145, 137, 145, 249, 128, 5, 137, 133, 137, 249, 149, 0,
	147, 0, 0, 0, 128, 5, 145, 133, 145, 149, 128, 9, 137, 137, 137, 149, 149, 0, 147, 0, 0, 0, 128, 9, 145,
	137, 145, 149, 137, 9, 137, 149, 149, 0, 147, 0, 0, 0, 128, 5, 137, 133, 137, 149, 128, 9, 137, 137,
	141, 0, 139, 0, 0, 0, 128, 5, 137, 133, 137, 249, 139, 0, 128, 0, 139, 0, 0, 0, 137, 9, 128, 137, 128,
	149, 137, 0, 139, 0, 0, 0, 128, 9, 137, 137, 137, 149, 146, 9, 137, 137, 146, 0, 148, 0, 0, 0, 128, 5,
	137, 133, 137, 249, 146, 5, 137, 133, 146, 0, 148, 0, 0, 0, 128, 121, 128, 149, 137, 5, 128, 133, 137,
	0, 139, 0, 0, 0, 128, 5, 146, 133, 146, 0, 148, 0, 0, 0, 137, 121, 137, 149, 128, 5, 146, 133, 146, 0,
	148, 0, 0, 0, 128, 21, 128, 249, 137, 9, 128, 137, 137, 5, 128, 133, 137, 0, 139, 0, 0, 0, 136, 121,
	136, 149, 145, 5, 136, 133, 128, 121, 128, 149, 145, 0, 147, 0, 0, 0, 145, 5, 128, 133, 128, 149, 145,
	9, 136, 137, 136, 149, 145, 0, 147, 0, 0, 0, 145, 9, 128, 137, 128, 249, 145, 5, 136, 133, 136, 249,
	145, 0, 147, 0, 0, 0, 128, 5, 154, 133, 128, 9, 137, 137, 137, 149, 145, 21, 145, 137, 154, 137, 154,
	0, 156, 0, 0, 0, 128, 9, 154, 137, 128, 5, 137, 133, 137, 249, 145, 121, 145, 133, 154, 133, 154, 0,
	156, 0, 0, 0, 145, 5, 136, 133, 136, 249, 128, 121, 128, 149, 145, 9, 136, 137, 136, 149, 145, 0, 147,
	0, 0, 0, 128, 5, 146, 133, 128, 9, 146, 137, 146, 0, 148, 0, 0, 0, 128, 5, 137, 133, 137, 249, 128, 9,
	137, 137, 137, 149, 145, 21, 145, 137, 154, 137, 145, 121, 145, 133, 154, 133, 154, 0, 156, 0, 0, 0,
	128, 9, 137, 137, 137, 149, 146, 9, 137, 137, 128, 5, 146, 133, 146, 0, 148, 0, 0, 0, 128, 9, 145, 137,
	135, 21, 135, 137, 143, 21, 143, 137, 145, 0, 147, 0, 0, 0, 128, 5, 137, 133, 137, 249, 146, 5, 137,
	133, 128, 9, 146, 137, 146, 0, 148, 0, 0, 0, 128, 5, 145, 133, 135, 121, 135, 133, 143, 121, 143, 133,
	145, 0, 147, 0, 0, 0, 145, 9, 128, 137, 128, 149, 136, 9, 136, 149, 145, 0, 147, 0, 0, 0, 137, 5, 128,
	133, 128, 149, 137, 9, 128, 137, 137, 0, 139, 0, 0, 0, 137, 9, 128, 137, 128, 249, 137, 5, 128, 133,
	137, 0, 139, 0, 0, 0, 145, 5, 128, 133, 128, 249, 136, 5, 136, 249, 145, 0, 147, 0, 0, 0, 137, 121, 137,
	149, 128, 5, 154, 133, 145, 121, 145, 149, 154, 0, 156, 0, 0, 0, 137, 121, 137, 149, 128, 5, 146, 133,
	128, 9, 146, 137, 146, 0, 148, 0, 0, 0, 128, 9, 137, 137, 137, 149, 141, 0, 139, 0, 0, 0, 137, 5, 128,
	133, 128, 249, 137, 0, 139, 0, 0, 0, 128, 21, 144, 149, 144, 128, 128, 128, 128, 149, 129, 21, 129,
	128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128, 133, 0, 133, 149, 134, 21, 134, 128,
	135, 21, 135, 128, 136, 21, 136, 128, 137, 21, 137, 128, 138, 0, 138, 149, 139, 21, 139, 128, 140,
	21, 140, 128, 141, 21, 141, 128, 142, 21, 142, 128, 143, 21, 143, 128, 128, 10, 144, 138, 144, 0,
	146, 0, 0, 0, 144, 0, 128, 128, 128, 138, 144, 138, 144, 128, 129, 10, 129, 128, 130, 10, 130, 128,
	131, 10, 131, 128, 132, 10, 132, 128, 133, 10, 133, 128, 134, 0, 134, 138, 135, 10, 135, 128, 136,
	10, 136, 128, 137, 10, 137, 128, 138, 10, 138, 128, 139, 10, 139, 128, 140, 0, 140, 138, 141, 10,
	141, 128, 142, 10, 142, 128, 143, 10, 143, 128, 144, 0, 146, 0, 0, 0, 128, 0, 128, 149, 135, 149, 135,
	128, 128, 128, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128, 133, 0,
	133, 149, 134, 21, 134, 128, 135, 0, 137, 0, 0, 0, 136, 0, 136, 149, 143, 149, 143, 128, 136, 128,
	137, 21, 137, 128, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 0, 141, 149, 142,
	21, 142, 128, 143, 0, 145, 0, 0, 0, 144, 11, 128, 139, 128, 149, 144, 149, 144, 139, 129, 21, 129,
	139, 130, 21, 130, 139, 131, 21, 131, 139, 132, 21, 132, 139, 133, 21, 133, 139, 134, 11, 134, 149,
	135, 21, 135, 139, 136, 21, 136, 139, 137, 21, 137, 139, 138, 21, 138, 139, 139, 21, 139, 139, 140,
	11, 140, 149, 141, 21, 141, 139, 142, 21, 142, 139, 143, 21, 143, 139, 144, 0, 146, 0, 0, 0, 133, 0,
	131, 129, 130, 132, 130, 134, 131, 137, 132, 139, 134, 141, 131, 140, 129, 137, 128, 134, 128, 133,
	129, 130, 130, 129, 133, 128, 137, 128, 139, 129, 140, 132, 145, 141, 147, 141, 141, 130, 140, 129,
	137, 128, 137, 13, 139, 140, 140, 137, 145, 128, 147, 128, 141, 139, 140, 140, 137, 141, 134, 141,
	131, 11, 130, 137, 129, 134, 129, 132, 130, 130, 140, 11, 146, 128, 140, 2, 146, 141, 151, 0, 149, 0,
	0, 0, 140, 125, 128, 253, 135, 125, 132, 254, 129, 253, 136, 15, 132, 255, 130, 253, 138, 15, 133,
	255, 134, 253, 137, 15, 132, 253, 133, 15, 144, 143, 145, 142, 148, 141, 149, 139, 148, 138, 145,
	137, 147, 139, 146, 141, 145, 142, 134, 15, 137, 142, 140, 143, 135, 15, 136, 141, 139, 15, 137,
	141, 147, 13, 148, 139, 145, 137, 147, 136, 148, 134, 147, 131, 145, 129, 134, 129, 143, 1, 145,
	131, 146, 134, 146, 135, 145, 137, 136, 137, 146, 8, 147, 134, 146, 131, 144, 129, 152, 0, 151, 0, 0,
	0, 129, 0, 137, 128, 136, 0, 133, 129, 130, 128, 133, 2, 131, 128, 135, 142, 135, 143, 150, 143,
	149, 140, 147, 140, 147, 141, 135, 141, 134, 2, 135, 128, 136, 14, 132, 128, 137, 14, 133, 128, 135,
	14, 148, 142, 148, 141, 149, 140, 149, 15, 149, 141, 148, 13, 147, 140, 153, 0, 152, 0, 0, 0, 129, 0,
	137, 128, 136, 0, 133, 129, 130, 128, 133, 2, 131, 128, 135, 142, 134, 2, 135, 128, 142, 0, 150, 128,
	149, 0, 146, 129, 143, 128, 146, 2, 144, 128, 149, 14, 145, 128, 147, 130, 148, 128, 136, 14, 132,
	128, 137, 14, 133, 128, 150, 14, 146, 128, 151, 14, 147, 128, 128, 15, 156, 143, 155, 141, 128, 141,
	128, 143, 128, 14, 155, 142, 160, 0, 158, 0, 0, 0, 139, 2, 139, 128, 128, 128, 136, 139, 128, 149,
	139, 149, 139, 147, 143, 0, 141, 0, 0, 0, 128, 5, 129, 130, 130, 129, 133, 128, 136, 128, 139, 129,
	141, 132, 142, 135, 142, 136, 141, 139, 140, 140, 137, 141, 134, 141, 131, 140, 129, 137, 128, 134,
	128, 133, 131, 11, 130, 137, 129, 134, 129, 132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 137,
	140, 139, 150, 14, 137, 142, 134, 141, 132, 139, 131, 137, 130, 134, 130, 132, 131, 129, 133, 128,
	136, 0, 138, 130, 139, 132, 140, 135, 140, 137, 139, 140, 137, 141, 153, 0, 152, 0, 0, 0, 128, 10,
	129, 140, 131, 142, 133, 142, 134, 141, 135, 139, 135, 136, 133, 131, 134, 13, 134, 137, 133, 133,
	133, 129, 135, 128, 137, 128, 139, 129, 141, 131, 143, 134, 143, 131, 144, 129, 145, 128, 147, 128,
	149, 130, 150, 132, 134, 11, 132, 134, 132, 131, 133, 129, 133, 253, 131, 249, 133, 249, 135, 253,
	135, 128, 144, 3, 145, 135, 147, 142, 145, 142, 143, 134, 146, 14, 144, 134, 144, 129, 135, 124,
	135, 252, 134, 124, 134, 252, 134, 0, 134, 253, 132, 249, 154, 0, 152, 0, 0, 0, 138, 11, 138, 253,
	140, 253, 140, 139, 139, 141, 137, 142, 132, 142, 130, 141, 128, 139, 128, 137, 130, 137, 130, 139,
	132, 140, 137, 140, 138, 139, 129, 10, 129, 139, 131, 141, 137, 141, 139, 139, 139, 253, 131, 12,
	131, 141, 138, 13, 139, 140, 140, 9, 144, 142, 146, 142, 140, 134, 145, 14, 140, 136, 145, 13, 140,
	135, 150, 0, 148, 0, 0, 0, 128, 7, 129, 132, 130, 131, 133, 130, 136, 130, 139, 131, 141, 134, 142,
	137, 142, 138, 141, 141, 140, 142, 137, 143, 134, 143, 131, 142, 129, 139, 128, 136, 128, 135, 131,
	13, 130, 139, 129, 136, 129, 134, 130, 132, 139, 4, 140, 134, 141, 137, 141, 139, 140, 141, 134,
	15, 132, 141, 131, 139, 130, 136, 130, 134, 131, 131, 133, 130, 136, 2, 138, 132, 139, 134, 140,
	137, 140, 139, 139, 142, 137, 143, 128, 21, 128, 148, 142, 148, 142, 149, 128, 149, 135, 15, 135,
	148, 135, 2, 135, 253, 128, 125, 142, 253, 142, 252, 128, 252, 128, 253, 146, 0, 144, 0, 0, 0, 137,
	21, 134, 148, 132, 146, 130, 143, 129, 140, 128, 136, 128, 133, 129, 130, 130, 129, 132, 128, 135,
	128, 138, 129, 140, 131, 142, 134, 143, 137, 144, 141, 144, 144, 143, 147, 142, 148, 140, 149, 137,
	149, 135, 148, 133, 145, 132, 143, 131, 140, 130, 136, 130, 131, 131, 129, 132, 128, 133, 18, 131,
	143, 130, 140, 129, 136, 129, 132, 130, 130, 139, 3, 141, 134, 142, 137, 143, 141, 143, 145, 142,
	147, 135, 0, 137, 129, 139, 132, 140, 134, 141, 137, 142, 141, 142, 146, 141, 148, 140, 149, 131,
	11, 142, 139, 131, 10, 141, 138, 148, 0, 146, 0, 0, 0, 131, 12, 132, 143, 133, 145, 135, 148, 137,
	149, 134, 148, 132, 146, 130, 143, 128, 137, 131, 135, 132, 134, 132, 129, 128, 129, 128, 128, 134,
	128, 134, 134, 131, 136, 130, 137, 131, 140, 139, 21, 140, 148, 141, 146, 141, 141, 140, 137, 139,
	136, 136, 134, 136, 128, 142, 128, 142, 129, 138, 129, 138, 134, 139, 135, 142, 137, 143, 141, 143,
	144, 142, 147, 141, 148, 139, 149, 137, 149, 134, 19, 132, 145, 131, 143, 129, 137, 133, 134, 133,
	128, 137, 0, 137, 134, 141, 137, 142, 141, 142, 145, 141, 147, 147, 0, 145, 0, 0, 0, 128, 5, 129, 130,
	130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 136, 141, 139, 140, 140, 137, 141,
	134, 141, 131, 140, 129, 137, 128, 134, 128, 133, 131, 11, 130, 137, 129, 134, 129, 132, 130, 130,
	139, 2, 140, 132, 141, 135, 141, 137, 140, 139, 134, 13, 132, 139, 131, 137, 130, 134, 130, 132,
	131, 129, 133, 128, 136, 0, 138, 130, 139, 132, 140, 135, 140, 137, 139, 140, 137, 141, 128, 149,
	142, 149, 142, 147, 141, 147, 141, 148, 131, 148, 140, 140, 139, 12, 129, 149, 146, 0, 144, 0, 0, 0,
	128, 5, 129, 130, 130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 136, 141, 139,
	140, 140, 137, 141, 134, 141, 131, 140, 129, 137, 128, 134, 128, 133, 131, 11, 130, 137, 129, 134,
	129, 132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 137, 140, 139, 134, 13, 132, 139, 131, 137,
	130, 134, 130, 132, 131, 129, 133, 128, 136, 0, 138, 130, 139, 132, 140, 135, 140, 137, 139, 140,
	137, 141, 140, 5, 141, 130, 142, 129, 145, 128, 148, 128, 151, 129, 153, 132, 154, 135, 154, 136,
	153, 139, 152, 140, 149, 141, 146, 141, 143, 140, 141, 137, 140, 134, 140, 133, 143, 11, 142, 137,
	141, 134, 141, 132, 142, 130, 151, 2, 152, 132, 153, 135, 153, 137, 152, 139, 146, 13, 144, 139,
	143, 137, 142, 134, 142, 132, 143, 129, 145, 128, 148, 0, 150, 130, 151, 132, 152, 135, 152, 137,
	151, 140, 149, 141, 158, 0, 156, 0, 0, 0, 134, 14, 131, 141, 129, 138, 128, 135, 128, 133, 129, 130,
	130, 129, 133, 128, 136, 128, 139, 129, 141, 132, 142, 135, 142, 137, 141, 140, 140, 141, 137, 142,
	134, 142, 132, 140, 131, 138, 130, 135, 130, 132, 131, 129, 133, 128, 131, 12, 130, 138, 129, 135,
	129, 132, 130, 130, 139, 2, 140, 132, 141, 135, 141, 138, 140, 140, 136, 0, 138, 130, 139, 132, 140,
	135, 140, 138, 139, 141, 137, 142, 141, 15, 142, 143, 129, 255, 128, 255, 141, 143, 147, 0, 144, 0,
	0, 0, 136, 11, 128, 139, 128, 147, 130, 149, 139, 149, 128, 11, 128, 130, 130, 128, 139, 128, 143,
	0, 141, 0, 0, 0, 132, 0, 129, 139, 128, 143, 128, 146, 129, 148, 132, 149, 136, 149, 139, 148, 141,
	146, 142, 143, 146, 129, 144, 128, 133, 0, 130, 139, 129, 143, 129, 147, 130, 148, 134, 0, 131, 139,
	130, 143, 130, 147, 132, 149, 129, 0, 137, 128, 143, 0, 149, 128, 130, 0, 133, 129, 136, 128, 131, 0,
	132, 130, 135, 0, 133, 130, 148, 0, 146, 129, 152, 0, 151, 0, 0, 0, 128, 10, 145, 138, 145, 137, 128,
	137, 128, 138, 128, 6, 145, 134, 145, 133, 128, 133, 128, 134, 128, 14, 145, 142, 145, 141, 128,
	141, 128, 142, 149, 0, 147, 0, 0, 0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 136, 21, 136,
	132, 137, 132, 137, 149, 136, 149, 128, 13, 145, 141, 145, 140, 128, 140, 128, 141, 149, 0, 147, 0,
	0, 0, 128, 1, 145, 129, 145, 128, 128, 128, 128, 129, 129, 21, 145, 141, 145, 140, 129, 132, 128,
	132, 143, 140, 143, 141, 128, 149, 129, 149, 149, 0, 147, 0, 0, 0, 145, 1, 128, 129, 128, 128, 145,
	128, 145, 129, 144, 21, 128, 141, 128, 140, 144, 132, 145, 132, 130, 140, 130, 141, 145, 149, 144,
	149, 149, 0, 147, 0, 0, 0, 139, 20, 137, 147, 136, 146, 134, 142, 132, 135, 131, 130, 129, 249, 131,
	0, 135, 142, 137, 146, 138, 147, 140, 148, 142, 148, 143, 147, 143, 146, 145, 147, 144, 148, 142,
	149, 140, 149, 136, 147, 135, 146, 133, 142, 131, 135, 130, 131, 128, 249, 130, 249, 131, 128, 143,
	20, 144, 147, 149, 0, 147, 0, 0, 0, 134, 122, 136, 251, 137, 252, 139, 128, 141, 135, 142, 140, 144,
	149, 142, 14, 138, 128, 136, 252, 135, 251, 133, 250, 131, 250, 130, 251, 130, 252, 128, 251, 129,
	250, 131, 249, 133, 249, 137, 251, 138, 252, 140, 128, 142, 135, 143, 139, 145, 149, 143, 149, 142,
	142, 130, 122, 129, 251, 149, 0, 147, 0, 0, 0, 128, 11, 145, 139, 145, 138, 128, 138, 128, 139, 135,
	21, 134, 148, 134, 147, 135, 146, 136, 146, 137, 147, 137, 148, 136, 149, 135, 149, 135, 20, 135,
	147, 136, 147, 136, 148, 135, 148, 135, 3, 134, 130, 134, 129, 135, 128, 136, 128, 137, 129, 137,
	130, 136, 131, 135, 131, 135, 2, 135, 129, 136, 129, 136, 130, 135, 130, 149, 0, 147, 0, 0, 0, 129,
	11, 129, 141, 130, 144, 132, 145, 134, 145, 136, 144, 140, 141, 142, 140, 144, 140, 146, 141, 147,
	143, 147, 145, 129, 13, 130, 143, 132, 144, 134, 144, 136, 143, 140, 140, 142, 139, 144, 139, 146,
	140, 147, 143, 129, 3, 129, 133, 130, 136, 132, 137, 134, 137, 136, 136, 140, 133, 142, 132, 144,
	132, 146, 133, 147, 135, 147, 137, 129, 5, 130, 135, 132, 136, 134, 136, 136, 135, 140, 132, 142,
	131, 144, 131, 146, 132, 147, 135, 151, 0, 149, 0, 0, 0, 128, 13, 129, 138, 130, 137, 133, 136, 136,
	136, 139, 137, 141, 140, 142, 143, 142, 144, 141, 147, 140, 148, 137, 149, 134, 149, 131, 148, 129,
	145, 128, 142, 128, 141, 131, 19, 130, 145, 129, 142, 129, 140, 130, 138, 139, 10, 140, 140, 141,
	143, 141, 145, 140, 147, 134, 21, 132, 147, 131, 145, 130, 142, 130, 140, 131, 137, 133, 136, 136,
	8, 138, 138, 139, 140, 140, 143, 140, 145, 139, 148, 137, 149, 146, 0, 144, 0, 0, 0, 128, 4, 131,
	132, 131, 128, 128, 128, 128, 132, 129, 4, 129, 128, 130, 4, 130, 128, 128, 2, 131, 130, 134, 0, 133,
	0, 0, 0, 131, 0, 128, 128, 128, 130, 131, 130, 131, 128, 129, 2, 129, 128, 130, 2, 130, 128, 134, 0,
	133, 0, 0, 0, 135, 20, 135, 132, 128, 138, 128, 135, 135, 128, 138, 128, 138, 147, 147, 147, 147,
	149, 135, 149, 135, 148, 128, 8, 136, 128, 136, 148, 146, 148, 137, 19, 137, 128, 128, 9, 136, 129,
	129, 9, 136, 130, 150, 0, 149, 0, 0, 0, 128, 17, 129, 147, 131, 149, 133, 149, 134, 148, 135, 146,
	135, 143, 137, 146, 139, 148, 141, 149, 143, 149, 145, 148, 146, 146, 146, 143, 144, 138, 135, 15,
	133, 137, 131, 137, 133, 142, 134, 146, 134, 20, 134, 143, 132, 137, 145, 20, 145, 144, 144, 140,
	144, 137, 143, 138, 143, 141, 145, 146, 150, 0, 148, 0, 0, 0, 130, 19, 131, 147, 131, 146, 129, 146,
	129, 148, 131, 149, 133, 149, 135, 148, 135, 146, 133, 145, 130, 143, 129, 142, 130, 142, 132, 141,
	134, 141, 135, 142, 135, 143, 135, 14, 130, 142, 129, 14, 128, 141, 139, 0, 137, 0, 0, 0, 128, 0, 128,
	138, 136, 138, 136, 128, 128, 128, 129, 10, 129, 128, 130, 10, 130, 128, 131, 10, 131, 128, 132, 10,
	132, 128, 133, 10, 133, 128, 134, 0, 134, 138, 135, 10, 135, 128, 140, 0, 138, 0, 0, 0
};
static const unsigned char Complex[12083] = /* binary data included from LCOM.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 76,
	67, 79, 77, 179, 46, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 223, 0, 0, 32, 173, 2, 0, 28, 0, 249, 0, 0, 0, 0, 0, 0, 0, 4, 0, 32, 0, 52, 0, 72, 0, 152, 0, 214, 0, 54,
	1, 66, 1, 106, 1, 146, 1, 162, 1, 174, 1, 192, 1, 200, 1, 214, 1, 230, 1, 50, 2, 70, 2, 156, 2, 244, 2,
	8, 3, 74, 3, 168, 3, 222, 3, 78, 4, 172, 4, 196, 4, 224, 4, 234, 4, 246, 4, 0, 5, 62, 5, 170, 5, 198, 5,
	24, 6, 88, 6, 144, 6, 180, 6, 212, 6, 30, 7, 70, 7, 90, 7, 128, 7, 168, 7, 192, 7, 236, 7, 12, 8, 98, 8,
	150, 8, 16, 9, 96, 9, 164, 9, 192, 9, 234, 9, 2, 10, 38, 10, 70, 10, 102, 10, 130, 10, 150, 10, 166, 10,
	186, 10, 200, 10, 208, 10, 226, 10, 44, 11, 104, 11, 160, 11, 224, 11, 28, 12, 68, 12, 180, 12, 226,
	12, 0, 13, 46, 13, 86, 13, 106, 13, 178, 13, 224, 13, 38, 14, 102, 14, 162, 14, 202, 14, 10, 15, 40,
	15, 86, 15, 110, 15, 146, 15, 178, 15, 216, 15, 244, 15, 66, 16, 74, 16, 152, 16, 200, 16, 216, 16,
	70, 17, 130, 17, 204, 17, 32, 18, 126, 18, 214, 18, 50, 19, 150, 19, 220, 19, 44, 20, 118, 20, 156,
	20, 184, 20, 216, 20, 6, 21, 46, 21, 96, 21, 232, 21, 26, 22, 104, 22, 192, 22, 18, 23, 68, 23, 122,
	23, 180, 23, 22, 24, 84, 24, 162, 24, 252, 24, 92, 25, 176, 25, 18, 26, 106, 26, 138, 26, 220, 26, 18,
	27, 92, 27, 150, 27, 224, 27, 38, 28, 100, 28, 120, 28, 140, 28, 234, 28, 28, 29, 56, 29, 72, 29, 88,
	29, 88, 30, 70, 32, 114, 34, 122, 34, 136, 34, 154, 34, 172, 34, 186, 34, 200, 34, 220, 34, 232, 34,
	248, 34, 8, 35, 22, 35, 36, 35, 46, 35, 56, 35, 70, 35, 84, 35, 98, 35, 106, 35, 122, 35, 140, 35, 158,
	35, 174, 35, 190, 35, 210, 35, 230, 35, 250, 35, 6, 36, 34, 36, 54, 36, 70, 36, 86, 36, 102, 36, 116,
	36, 130, 36, 144, 36, 158, 36, 178, 36, 198, 36, 208, 36, 218, 36, 48, 37, 126, 37, 168, 37, 210, 37,
	32, 38, 96, 38, 154, 38, 176, 38, 204, 38, 240, 38, 60, 39, 110, 39, 144, 39, 222, 39, 58, 40, 140,
	40, 222, 40, 86, 41, 164, 41, 198, 41, 240, 41, 4, 42, 20, 42, 34, 42, 48, 42, 88, 42, 128, 42, 156,
	42, 248, 42, 58, 43, 84, 43, 106, 43, 120, 43, 156, 43, 216, 43, 18, 7, 15, 20, 19, 23, 24, 7, 12, 12,
	15, 23, 23, 23, 8, 25, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 7, 7, 21, 23, 21, 17, 26, 23, 22, 20, 22,
	21, 21, 23, 25, 12, 16, 24, 20, 26, 24, 21, 22, 21, 23, 19, 20, 25, 23, 27, 23, 24, 19, 12, 27, 12, 21,
	23, 7, 20, 21, 18, 21, 18, 14, 19, 23, 12, 11, 22, 12, 34, 23, 19, 21, 21, 18, 16, 16, 23, 21, 27, 21,
	21, 17, 10, 5, 10, 23, 16, 20, 23, 18, 20, 20, 20, 20, 18, 18, 18, 18, 12, 18, 12, 23, 23, 21, 30, 27,
	19, 19, 19, 20, 20, 21, 21, 25, 20, 24, 26, 27, 21, 20, 12, 19, 20, 23, 24, 20, 19, 17, 14, 14, 23, 23,
	7, 21, 21, 14, 16, 24, 4, 13, 13, 22, 22, 13, 22, 22, 22, 22, 22, 13, 0, 9, 18, 18, 9, 18, 19, 9, 18, 18,
	18, 27, 27, 18, 18, 27, 18, 18, 18, 18, 18, 9, 10, 18, 28, 18, 13, 9, 17, 17, 8, 16, 17, 23, 14, 13, 21,
	20, 24, 19, 15, 18, 20, 20, 19, 31, 20, 16, 23, 23, 22, 21, 23, 14, 14, 22, 22, 18, 7, 6, 20, 18, 12, 13,
	146, 0, 0, 0, 129, 21, 128, 147, 129, 135, 130, 147, 129, 149, 129, 19, 129, 141, 129, 2, 128, 129,
	129, 128, 130, 129, 129, 130, 135, 0, 0, 0, 129, 21, 128, 142, 130, 21, 128, 142, 137, 21, 136, 142,
	138, 21, 136, 142, 143, 0, 0, 0, 136, 21, 129, 249, 142, 21, 135, 249, 129, 10, 143, 138, 128, 4, 142,
	132, 148, 0, 0, 0, 133, 25, 133, 252, 137, 25, 137, 252, 141, 18, 140, 145, 141, 144, 142, 145, 142,
	146, 140, 148, 137, 149, 133, 149, 130, 148, 128, 146, 128, 144, 129, 142, 130, 141, 132, 140, 138,
	138, 140, 137, 142, 135, 128, 16, 130, 142, 132, 141, 138, 139, 140, 138, 141, 137, 142, 135, 142,
	131, 140, 129, 137, 128, 133, 128, 130, 129, 128, 131, 128, 132, 129, 133, 130, 132, 129, 131, 147,
	0, 0, 0, 146, 21, 128, 128, 133, 21, 135, 147, 135, 145, 134, 143, 132, 142, 130, 142, 128, 144,
	128, 146, 129, 148, 131, 149, 133, 149, 135, 148, 138, 147, 141, 147, 144, 148, 146, 149, 142, 7,
	140, 134, 139, 132, 139, 130, 141, 128, 143, 128, 145, 129, 146, 131, 146, 133, 144, 135, 142, 135,
	151, 0, 0, 0, 146, 13, 145, 140, 146, 139, 147, 140, 147, 141, 146, 142, 145, 142, 144, 141, 143,
	139, 141, 134, 139, 131, 137, 129, 135, 128, 132, 128, 129, 129, 128, 131, 128, 134, 129, 136, 135,
	140, 137, 142, 138, 144, 138, 146, 137, 148, 135, 149, 133, 148, 132, 146, 132, 144, 133, 141, 135,
	138, 140, 131, 142, 129, 145, 128, 146, 128, 147, 129, 147, 130, 132, 0, 130, 129, 129, 131, 129,
	134, 130, 136, 132, 138, 132, 16, 133, 142, 141, 131, 143, 129, 145, 128, 152, 0, 0, 0, 129, 21, 128,
	142, 130, 21, 128, 142, 135, 0, 0, 0, 135, 25, 133, 151, 131, 148, 129, 144, 128, 139, 128, 135, 129,
	130, 131, 254, 133, 251, 135, 249, 133, 23, 131, 147, 130, 144, 129, 139, 129, 135, 130, 130, 131,
	255, 133, 251, 140, 0, 0, 0, 128, 25, 130, 151, 132, 148, 134, 144, 135, 139, 135, 135, 134, 130,
	132, 254, 130, 251, 128, 249, 130, 23, 132, 147, 133, 144, 134, 139, 134, 135, 133, 130, 132, 255,
	130, 251, 140, 0, 0, 0, 133, 12, 133, 128, 128, 9, 138, 131, 138, 9, 128, 131, 143, 0, 0, 0, 137, 18,
	137, 128, 128, 9, 146, 137, 151, 0, 0, 0, 129, 0, 128, 129, 129, 130, 130, 129, 130, 255, 129, 253,
	128, 252, 151, 0, 0, 0, 128, 9, 146, 137, 151, 0, 0, 0, 129, 2, 128, 129, 129, 128, 130, 129, 129, 130,
	136, 0, 0, 0, 147, 17, 130, 128, 128, 128, 149, 149, 151, 149, 147, 145, 153, 0, 0, 0, 134, 21, 131,
	148, 129, 145, 128, 140, 128, 137, 129, 132, 131, 129, 134, 128, 136, 128, 139, 129, 141, 132, 142,
	137, 142, 140, 141, 145, 139, 148, 136, 149, 134, 149, 132, 148, 131, 147, 130, 145, 129, 140, 129,
	137, 130, 132, 131, 130, 132, 129, 134, 128, 136, 0, 138, 129, 139, 130, 140, 132, 141, 137, 141,
	140, 140, 145, 139, 147, 138, 148, 136, 149, 151, 0, 0, 0, 132, 17, 134, 146, 137, 149, 137, 128,
	136, 20, 136, 128, 132, 0, 141, 128, 151, 0, 0, 0, 129, 17, 130, 144, 129, 143, 128, 144, 128, 145,
	129, 147, 130, 148, 133, 149, 137, 149, 140, 148, 141, 147, 142, 145, 142, 143, 141, 141, 138, 139,
	133, 137, 131, 136, 129, 134, 128, 131, 128, 128, 137, 21, 139, 148, 140, 147, 141, 145, 141, 143,
	140, 141, 137, 139, 133, 137, 128, 2, 129, 131, 131, 131, 136, 129, 139, 129, 141, 130, 142, 131,
	142, 133, 131, 3, 136, 128, 140, 128, 141, 129, 142, 131, 151, 0, 0, 0, 129, 17, 130, 144, 129, 143,
	128, 144, 128, 145, 129, 147, 130, 148, 133, 149, 137, 149, 140, 148, 141, 146, 141, 143, 140, 141,
	137, 140, 134, 140, 137, 21, 139, 148, 140, 146, 140, 143, 139, 141, 137, 140, 139, 139, 141, 137,
	142, 135, 142, 132, 141, 130, 140, 129, 137, 128, 133, 128, 130, 129, 129, 130, 128, 132, 128, 133,
	129, 134, 130, 133, 129, 132, 140, 10, 141, 135, 141, 132, 140, 130, 139, 129, 137, 128, 151, 0, 0,
	0, 138, 19, 138, 128, 144, 6, 128, 134, 139, 149, 139, 128, 135, 0, 142, 128, 151, 0, 0, 0, 130, 20,
	135, 148, 140, 149, 130, 149, 128, 139, 130, 141, 133, 142, 136, 142, 139, 141, 141, 139, 142, 136,
	142, 134, 141, 131, 139, 129, 136, 128, 133, 128, 130, 129, 129, 130, 128, 132, 128, 133, 129, 134,
	130, 133, 129, 132, 136, 14, 138, 141, 140, 139, 141, 136, 141, 134, 140, 131, 138, 129, 136, 128,
	151, 0, 0, 0, 140, 18, 139, 145, 140, 144, 141, 145, 141, 146, 140, 148, 138, 149, 135, 149, 132,
	148, 130, 146, 129, 144, 128, 140, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141,
	131, 142, 134, 142, 135, 141, 138, 139, 140, 136, 141, 135, 141, 132, 140, 130, 138, 129, 135, 135,
	21, 133, 148, 131, 146, 130, 144, 129, 140, 129, 134, 130, 131, 132, 129, 134, 128, 136, 0, 138,
	129, 140, 131, 141, 134, 141, 135, 140, 138, 138, 140, 136, 141, 151, 0, 0, 0, 128, 21, 128, 143,
	128, 17, 129, 147, 131, 149, 133, 149, 138, 146, 140, 146, 141, 147, 142, 149, 142, 146, 141, 143,
	137, 138, 136, 136, 135, 133, 135, 128, 129, 19, 131, 148, 133, 148, 138, 146, 141, 15, 136, 138,
	135, 136, 134, 133, 134, 128, 151, 0, 0, 0, 133, 21, 130, 148, 129, 146, 129, 143, 130, 141, 133,
	140, 137, 140, 140, 141, 141, 143, 141, 146, 140, 148, 137, 149, 133, 149, 131, 148, 130, 146, 130,
	143, 131, 141, 133, 140, 130, 139, 129, 138, 128, 136, 128, 132, 129, 130, 130, 129, 133, 128, 137,
	128, 140, 129, 141, 130, 142, 132, 142, 136, 141, 138, 140, 139, 137, 140, 139, 141, 140, 143, 140,
	146, 139, 148, 137, 149, 133, 12, 131, 139, 130, 138, 129, 136, 129, 132, 130, 130, 131, 129, 133,
	128, 137, 0, 139, 129, 140, 130, 141, 132, 141, 136, 140, 138, 139, 139, 137, 140, 151, 0, 0, 0, 141,
	14, 140, 139, 138, 137, 135, 136, 134, 136, 131, 137, 129, 139, 128, 142, 128, 143, 129, 146, 131,
	148, 134, 149, 136, 149, 139, 148, 141, 146, 142, 143, 142, 137, 141, 133, 140, 131, 138, 129, 135,
	128, 132, 128, 130, 129, 129, 131, 129, 132, 130, 133, 131, 132, 130, 131, 134, 8, 132, 137, 130,
	139, 129, 142, 129, 143, 130, 146, 132, 148, 134, 149, 136, 21, 138, 148, 140, 146, 141, 143, 141,
	137, 140, 133, 139, 131, 137, 129, 135, 128, 151, 0, 0, 0, 129, 14, 128, 141, 129, 140, 130, 141,
	129, 142, 129, 2, 128, 129, 129, 128, 130, 129, 129, 130, 135, 0, 0, 0, 129, 14, 128, 141, 129, 140,
	130, 141, 129, 142, 129, 0, 128, 129, 129, 130, 130, 129, 130, 255, 129, 253, 128, 252, 135, 0, 0, 0,
	144, 18, 128, 137, 144, 128, 149, 0, 0, 0, 128, 12, 146, 140, 128, 6, 146, 134, 151, 0, 0, 0, 128, 18,
	144, 137, 128, 128, 149, 0, 0, 0, 129, 17, 130, 144, 129, 143, 128, 144, 128, 145, 129, 147, 130,
	148, 132, 149, 135, 149, 138, 148, 139, 147, 140, 145, 140, 143, 139, 141, 138, 140, 134, 138, 134,
	135, 135, 21, 137, 148, 138, 147, 139, 145, 139, 143, 138, 141, 136, 139, 134, 2, 133, 129, 134,
	128, 135, 129, 134, 130, 145, 0, 0, 0, 143, 13, 142, 143, 140, 144, 137, 144, 135, 143, 134, 142,
	133, 139, 133, 136, 134, 134, 136, 133, 139, 133, 141, 134, 142, 136, 137, 16, 135, 142, 134, 139,
	134, 136, 135, 134, 136, 133, 143, 16, 142, 136, 142, 134, 144, 133, 146, 133, 148, 135, 149, 138,
	149, 140, 148, 143, 147, 145, 145, 147, 143, 148, 140, 149, 137, 149, 134, 148, 132, 147, 130, 145,
	129, 143, 128, 140, 128, 137, 129, 134, 130, 132, 132, 130, 134, 129, 137, 128, 140, 128, 143, 129,
	145, 130, 146, 131, 144, 16, 143, 136, 143, 134, 144, 133, 154, 0, 0, 0, 137, 21, 130, 128, 137, 21,
	144, 128, 137, 18, 143, 128, 132, 6, 141, 134, 128, 0, 134, 128, 140, 0, 146, 128, 151, 0, 0, 0, 131,
	21, 131, 128, 132, 21, 132, 128, 128, 21, 140, 149, 143, 148, 144, 147, 145, 145, 145, 143, 144,
	141, 143, 140, 140, 139, 140, 21, 142, 148, 143, 147, 144, 145, 144, 143, 143, 141, 142, 140, 140,
	139, 132, 11, 140, 139, 143, 138, 144, 137, 145, 135, 145, 132, 144, 130, 143, 129, 140, 128, 128,
	128, 140, 11, 142, 138, 143, 137, 144, 135, 144, 132, 143, 130, 142, 129, 140, 128, 150, 0, 0, 0,
	142, 18, 143, 143, 143, 149, 142, 146, 140, 148, 137, 149, 135, 149, 132, 148, 130, 146, 129, 144,
	128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 133,
	135, 21, 133, 148, 131, 146, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 133, 129, 135, 128,
	148, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 128, 21, 138, 149, 141, 148, 143, 146, 144, 144,
	145, 141, 145, 136, 144, 133, 143, 131, 141, 129, 138, 128, 128, 128, 138, 21, 140, 148, 142, 146,
	143, 144, 144, 141, 144, 136, 143, 133, 142, 131, 140, 129, 138, 128, 150, 0, 0, 0, 131, 21, 131,
	128, 132, 21, 132, 128, 138, 15, 138, 135, 128, 21, 144, 149, 144, 143, 143, 149, 132, 11, 138, 139,
	128, 0, 144, 128, 144, 134, 143, 128, 149, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 138, 15,
	138, 135, 128, 21, 144, 149, 144, 143, 143, 149, 132, 11, 138, 139, 128, 0, 135, 128, 149, 0, 0, 0,
	142, 18, 143, 143, 143, 149, 142, 146, 140, 148, 137, 149, 135, 149, 132, 148, 130, 146, 129, 144,
	128, 141, 128, 136, 129, 133, 130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 135, 21,
	133, 148, 131, 146, 130, 144, 129, 141, 129, 136, 130, 133, 131, 131, 133, 129, 135, 128, 142, 8,
	142, 128, 143, 8, 143, 128, 139, 8, 146, 136, 151, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 144,
	21, 144, 128, 145, 21, 145, 128, 128, 21, 135, 149, 141, 21, 148, 149, 132, 11, 144, 139, 128, 0,
	135, 128, 141, 0, 148, 128, 153, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 128, 21, 135, 149,
	128, 0, 135, 128, 140, 0, 0, 0, 136, 21, 136, 132, 135, 129, 133, 128, 131, 128, 129, 129, 128, 131,
	128, 133, 129, 134, 130, 133, 129, 132, 135, 21, 135, 132, 134, 129, 133, 128, 132, 21, 139, 149,
	144, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 145, 21, 132, 136, 137, 12, 145, 128, 136, 12,
	144, 128, 128, 21, 135, 149, 141, 21, 147, 149, 128, 0, 135, 128, 141, 0, 147, 128, 152, 0, 0, 0, 131,
	21, 131, 128, 132, 21, 132, 128, 128, 21, 135, 149, 128, 0, 143, 128, 143, 134, 142, 128, 148, 0, 0,
	0, 131, 21, 131, 128, 132, 21, 138, 131, 131, 21, 138, 128, 145, 21, 138, 128, 145, 21, 145, 128,
	146, 21, 146, 128, 128, 21, 132, 149, 145, 21, 149, 149, 128, 0, 134, 128, 142, 0, 149, 128, 154, 0,
	0, 0, 131, 21, 131, 128, 132, 21, 144, 130, 132, 19, 144, 128, 144, 21, 144, 128, 128, 21, 132,
	149, 141, 21, 147, 149, 128, 0, 134, 128, 152, 0, 0, 0, 135, 21, 132, 148, 130, 146, 129, 144, 128,
	140, 128, 137, 129, 133, 130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 133, 144,
	137, 144, 140, 143, 144, 142, 146, 140, 148, 137, 149, 135, 149, 135, 21, 133, 148, 131, 146, 130,
	144, 129, 140, 129, 137, 130, 133, 131, 131, 133, 129, 135, 128, 137, 0, 139, 129, 141, 131, 142,
	133, 143, 137, 143, 140, 142, 144, 141, 146, 139, 148, 137, 149, 149, 0, 0, 0, 131, 21, 131, 128,
	132, 21, 132, 128, 128, 21, 140, 149, 143, 148, 144, 147, 145, 145, 145, 142, 144, 140, 143, 139,
	140, 138, 132, 138, 140, 21, 142, 148, 143, 147, 144, 145, 144, 142, 143, 140, 142, 139, 140, 138,
	128, 0, 135, 128, 150, 0, 0, 0, 135, 21, 132, 148, 130, 146, 129, 144, 128, 140, 128, 137, 129, 133,
	130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 133, 144, 137, 144, 140, 143, 144,
	142, 146, 140, 148, 137, 149, 135, 149, 135, 21, 133, 148, 131, 146, 130, 144, 129, 140, 129, 137,
	130, 133, 131, 131, 133, 129, 135, 128, 137, 0, 139, 129, 141, 131, 142, 133, 143, 137, 143, 140,
	142, 144, 141, 146, 139, 148, 137, 149, 132, 2, 132, 131, 133, 133, 135, 134, 136, 134, 138, 133,
	139, 131, 140, 252, 141, 251, 143, 251, 144, 253, 144, 254, 139, 3, 140, 255, 141, 253, 142, 252,
	143, 252, 144, 253, 149, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 128, 21, 140, 149, 143, 148,
	144, 147, 145, 145, 145, 143, 144, 141, 143, 140, 140, 139, 132, 139, 140, 21, 142, 148, 143, 147,
	144, 145, 144, 143, 143, 141, 142, 140, 140, 139, 128, 0, 135, 128, 137, 11, 139, 138, 140, 137,
	143, 130, 144, 129, 145, 129, 146, 130, 139, 10, 140, 136, 142, 129, 143, 128, 145, 128, 146, 130,
	146, 131, 151, 0, 0, 0, 141, 18, 142, 149, 142, 143, 141, 146, 139, 148, 136, 149, 133, 149, 130,
	148, 128, 146, 128, 144, 129, 142, 130, 141, 132, 140, 138, 138, 140, 137, 142, 135, 128, 16, 130,
	142, 132, 141, 138, 139, 140, 138, 141, 137, 142, 135, 142, 131, 140, 129, 137, 128, 134, 128, 131,
	129, 129, 131, 128, 134, 128, 128, 129, 131, 147, 0, 0, 0, 135, 21, 135, 128, 136, 21, 136, 128, 129,
	21, 128, 143, 128, 149, 143, 149, 143, 143, 142, 149, 132, 0, 139, 128, 148, 0, 0, 0, 131, 21, 131,
	134, 132, 131, 134, 129, 137, 128, 139, 128, 142, 129, 144, 131, 145, 134, 145, 149, 132, 21, 132,
	134, 133, 131, 135, 129, 137, 128, 128, 21, 135, 149, 142, 21, 148, 149, 153, 0, 0, 0, 130, 21, 137,
	128, 131, 21, 137, 131, 144, 21, 137, 128, 128, 21, 134, 149, 140, 21, 146, 149, 151, 0, 0, 0, 131,
	21, 135, 128, 132, 21, 135, 133, 139, 21, 135, 128, 139, 21, 143, 128, 140, 21, 143, 133, 147, 21,
	143, 128, 128, 21, 135, 149, 144, 21, 150, 149, 155, 0, 0, 0, 130, 21, 143, 128, 131, 21, 144, 128,
	144, 21, 130, 128, 128, 21, 134, 149, 140, 21, 146, 149, 128, 0, 134, 128, 140, 0, 146, 128, 151, 0,
	0, 0, 130, 21, 137, 138, 137, 128, 131, 21, 138, 138, 138, 128, 145, 21, 138, 138, 128, 21, 134,
	149, 141, 21, 147, 149, 134, 0, 141, 128, 152, 0, 0, 0, 141, 21, 128, 128, 142, 21, 129, 128, 129, 21,
	128, 143, 128, 149, 142, 149, 128, 0, 142, 128, 142, 134, 141, 128, 147, 0, 0, 0, 128, 25, 128, 249,
	129, 25, 129, 249, 128, 25, 135, 153, 128, 121, 135, 249, 140, 0, 0, 0, 132, 17, 149, 128, 151, 128,
	130, 149, 128, 149, 132, 145, 155, 0, 0, 0, 134, 25, 134, 249, 135, 25, 135, 249, 128, 25, 135, 153,
	128, 121, 135, 249, 140, 0, 0, 0, 128, 16, 136, 149, 144, 144, 136, 148, 128, 144, 149, 0, 0, 0, 129,
	121, 146, 249, 151, 0, 0, 0, 128, 21, 129, 148, 130, 146, 130, 144, 129, 143, 128, 144, 129, 145,
	135, 0, 0, 0, 130, 12, 130, 139, 129, 139, 129, 140, 130, 141, 132, 142, 136, 142, 138, 141, 139,
	140, 140, 138, 140, 131, 141, 129, 142, 128, 139, 12, 139, 131, 140, 129, 142, 128, 143, 128, 139,
	10, 138, 137, 132, 136, 129, 135, 128, 133, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129, 139,
	131, 132, 8, 130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 148, 0, 0, 0, 131, 21, 131, 128, 132,
	21, 132, 128, 132, 11, 134, 141, 136, 142, 138, 142, 141, 141, 143, 139, 144, 136, 144, 134, 143,
	131, 141, 129, 138, 128, 136, 128, 134, 129, 132, 131, 138, 14, 140, 141, 142, 139, 143, 136, 143,
	134, 142, 131, 140, 129, 138, 128, 128, 21, 132, 149, 149, 0, 0, 0, 140, 11, 139, 138, 140, 137, 141,
	138, 141, 139, 139, 141, 137, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131,
	129, 134, 128, 136, 128, 139, 129, 141, 131, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130,
	131, 132, 129, 134, 128, 146, 0, 0, 0, 140, 21, 140, 128, 141, 21, 141, 128, 140, 11, 138, 141, 136,
	142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 138,
	129, 140, 131, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129, 134, 128, 137,
	21, 141, 149, 140, 0, 144, 128, 149, 0, 0, 0, 129, 8, 141, 136, 141, 138, 140, 140, 139, 141, 137,
	142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139,
	129, 141, 131, 140, 8, 140, 139, 139, 141, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130,
	131, 132, 129, 134, 128, 146, 0, 0, 0, 136, 20, 135, 147, 136, 146, 137, 147, 137, 148, 136, 149,
	134, 149, 132, 148, 131, 146, 131, 128, 134, 21, 133, 148, 132, 146, 132, 128, 128, 14, 136, 142,
	128, 0, 135, 128, 142, 0, 0, 0, 134, 14, 132, 141, 131, 140, 130, 138, 130, 136, 131, 134, 132, 133,
	134, 132, 136, 132, 138, 133, 139, 134, 140, 136, 140, 138, 139, 140, 138, 141, 136, 142, 134, 142,
	132, 13, 131, 139, 131, 135, 132, 133, 138, 5, 139, 135, 139, 139, 138, 141, 139, 12, 140, 141, 142,
	142, 142, 141, 140, 141, 131, 6, 130, 133, 129, 131, 129, 130, 130, 128, 133, 255, 138, 255, 141,
	254, 142, 253, 129, 2, 130, 129, 133, 128, 138, 128, 141, 255, 142, 253, 142, 252, 141, 250, 138,
	249, 132, 249, 129, 250, 128, 252, 128, 253, 129, 255, 132, 128, 147, 0, 0, 0, 131, 21, 131, 128,
	132, 21, 132, 128, 132, 11, 134, 141, 137, 142, 139, 142, 142, 141, 143, 139, 143, 128, 139, 14,
	141, 141, 142, 139, 142, 128, 128, 21, 132, 149, 128, 0, 135, 128, 139, 0, 146, 128, 151, 0, 0, 0,
	131, 21, 130, 148, 131, 147, 132, 148, 131, 149, 131, 14, 131, 128, 132, 14, 132, 128, 128, 14, 132,
	142, 128, 0, 135, 128, 140, 0, 0, 0, 133, 21, 132, 148, 133, 147, 134, 148, 133, 149, 134, 14, 134,
	252, 133, 250, 131, 249, 129, 249, 128, 250, 128, 251, 129, 252, 130, 251, 129, 250, 133, 14, 133,
	252, 132, 250, 131, 249, 130, 14, 134, 142, 139, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 142,
	14, 132, 132, 137, 8, 143, 128, 136, 8, 142, 128, 128, 21, 132, 149, 139, 14, 145, 142, 128, 0, 135,
	128, 139, 0, 145, 128, 150, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 128, 21, 132, 149, 128, 0,
	135, 128, 140, 0, 0, 0, 131, 14, 131, 128, 132, 14, 132, 128, 132, 11, 134, 141, 137, 142, 139, 142,
	142, 141, 143, 139, 143, 128, 139, 14, 141, 141, 142, 139, 142, 128, 143, 11, 145, 141, 148, 142,
	150, 142, 153, 141, 154, 139, 154, 128, 150, 14, 152, 141, 153, 139, 153, 128, 128, 14, 132, 142,
	128, 0, 135, 128, 139, 0, 146, 128, 150, 0, 157, 128, 162, 0, 0, 0, 131, 14, 131, 128, 132, 14, 132,
	128, 132, 11, 134, 141, 137, 142, 139, 142, 142, 141, 143, 139, 143, 128, 139, 14, 141, 141, 142,
	139, 142, 128, 128, 14, 132, 142, 128, 0, 135, 128, 139, 0, 146, 128, 151, 0, 0, 0, 134, 14, 131, 141,
	129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134,
	142, 136, 141, 139, 139, 141, 136, 142, 134, 142, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134,
	130, 131, 132, 129, 134, 128, 136, 0, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141,
	136, 142, 147, 0, 0, 0, 131, 14, 131, 249, 132, 14, 132, 249, 132, 11, 134, 141, 136, 142, 138, 142,
	141, 141, 143, 139, 144, 136, 144, 134, 143, 131, 141, 129, 138, 128, 136, 128, 134, 129, 132, 131,
	138, 14, 140, 141, 142, 139, 143, 136, 143, 134, 142, 131, 140, 129, 138, 128, 128, 14, 132, 142,
	128, 121, 135, 249, 149, 0, 0, 0, 140, 14, 140, 249, 141, 14, 141, 249, 140, 11, 138, 141, 136, 142,
	134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 138, 129,
	140, 131, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129, 134, 128, 137, 121,
	144, 249, 149, 0, 0, 0, 131, 14, 131, 128, 132, 14, 132, 128, 132, 8, 133, 139, 135, 141, 137, 142,
	140, 142, 141, 141, 141, 140, 140, 139, 139, 140, 140, 141, 128, 14, 132, 142, 128, 0, 135, 128,
	146, 0, 0, 0, 138, 12, 139, 142, 139, 138, 138, 140, 137, 141, 135, 142, 131, 142, 129, 141, 128,
	140, 128, 138, 129, 137, 131, 136, 136, 134, 138, 133, 139, 132, 128, 11, 129, 138, 131, 137, 136,
	135, 138, 134, 139, 133, 139, 130, 138, 129, 136, 128, 132, 128, 130, 129, 129, 130, 128, 132, 128,
	128, 129, 130, 144, 0, 0, 0, 134, 0, 133, 129, 132, 132, 132, 149, 131, 149, 131, 132, 132, 129, 134,
	128, 136, 128, 138, 129, 139, 131, 128, 14, 136, 142, 144, 0, 0, 0, 131, 14, 131, 131, 132, 129, 135,
	128, 137, 128, 140, 129, 142, 131, 132, 14, 132, 131, 133, 129, 135, 128, 142, 14, 142, 128, 143,
	14, 143, 128, 128, 14, 132, 142, 139, 14, 143, 142, 142, 0, 146, 128, 151, 0, 0, 0, 130, 14, 136,
	128, 131, 14, 136, 130, 142, 14, 136, 128, 128, 14, 134, 142, 138, 14, 144, 142, 149, 0, 0, 0, 131,
	14, 135, 128, 132, 14, 135, 131, 139, 14, 135, 128, 139, 14, 143, 128, 140, 14, 143, 131, 147, 14,
	143, 128, 128, 14, 135, 142, 144, 14, 150, 142, 155, 0, 0, 0, 130, 14, 141, 128, 131, 14, 142, 128,
	142, 14, 130, 128, 128, 14, 134, 142, 138, 14, 144, 142, 128, 0, 134, 128, 138, 0, 144, 128, 149, 0,
	0, 0, 130, 14, 136, 128, 131, 14, 136, 130, 142, 14, 136, 128, 134, 252, 132, 250, 130, 249, 129,
	249, 128, 250, 129, 251, 130, 250, 128, 14, 134, 142, 138, 14, 144, 142, 149, 0, 0, 0, 139, 14, 128,
	128, 140, 14, 129, 128, 129, 14, 128, 138, 128, 142, 140, 142, 128, 0, 140, 128, 140, 132, 139, 128,
	145, 0, 0, 0, 133, 25, 131, 152, 130, 151, 129, 149, 129, 147, 130, 145, 131, 144, 132, 142, 132,
	140, 130, 138, 131, 24, 130, 150, 130, 148, 131, 146, 132, 145, 133, 143, 133, 141, 132, 139, 128,
	137, 132, 135, 133, 133, 133, 131, 132, 129, 131, 128, 130, 254, 130, 252, 131, 250, 130, 8, 132,
	134, 132, 132, 131, 130, 130, 129, 129, 255, 129, 253, 130, 251, 131, 250, 133, 249, 138, 0, 0, 0,
	128, 25, 128, 250, 133, 0, 0, 0, 128, 25, 130, 152, 131, 151, 132, 149, 132, 147, 131, 145, 130, 144,
	129, 142, 129, 140, 131, 138, 130, 24, 131, 150, 131, 148, 130, 146, 129, 145, 128, 143, 128, 141,
	129, 139, 133, 137, 129, 135, 128, 133, 128, 131, 129, 129, 130, 128, 131, 254, 131, 252, 130, 250,
	131, 8, 129, 134, 129, 132, 130, 130, 131, 129, 132, 255, 132, 253, 131, 251, 130, 250, 128, 249,
	138, 0, 0, 0, 128, 13, 128, 143, 129, 146, 131, 147, 133, 147, 135, 146, 139, 143, 141, 142, 143,
	142, 145, 143, 146, 145, 128, 15, 129, 145, 131, 146, 133, 146, 135, 145, 139, 142, 141, 141, 143,
	141, 145, 142, 146, 145, 146, 147, 151, 0, 0, 0, 140, 0, 140, 136, 134, 145, 128, 136, 128, 128, 140,
	128, 144, 0, 0, 0, 142, 19, 143, 144, 143, 150, 142, 147, 140, 149, 137, 150, 135, 150, 132, 149,
	130, 147, 129, 145, 128, 142, 128, 137, 129, 134, 130, 132, 132, 130, 135, 129, 137, 129, 140, 130,
	142, 132, 143, 134, 135, 22, 133, 149, 131, 147, 130, 145, 129, 142, 129, 137, 130, 134, 131, 132,
	133, 130, 135, 129, 136, 1, 136, 128, 139, 255, 140, 254, 141, 252, 140, 250, 139, 249, 136, 248,
	133, 248, 131, 249, 130, 250, 129, 252, 129, 253, 130, 254, 131, 253, 130, 252, 137, 0, 139, 254,
	140, 252, 139, 250, 138, 249, 136, 248, 148, 127, 148, 0, 0, 0, 131, 14, 131, 131, 132, 129, 135,
	128, 137, 128, 140, 129, 142, 131, 128, 14, 132, 142, 132, 131, 133, 129, 135, 128, 142, 14, 142,
	128, 146, 128, 139, 14, 143, 142, 143, 128, 132, 18, 131, 145, 132, 144, 133, 145, 132, 146, 141,
	18, 140, 145, 141, 144, 142, 145, 141, 146, 151, 0, 0, 0, 134, 0, 132, 129, 130, 131, 129, 134, 129,
	136, 141, 136, 141, 138, 140, 140, 139, 141, 137, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128,
	134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 140, 8, 140, 139, 139, 141, 134,
	14, 132, 141, 130, 139, 129, 136, 137, 20, 136, 149, 137, 150, 138, 149, 138, 147, 135, 145, 133,
	144, 146, 0, 0, 0, 132, 12, 132, 139, 131, 139, 131, 140, 132, 141, 134, 142, 138, 142, 140, 141,
	141, 140, 142, 138, 142, 131, 143, 129, 144, 128, 145, 128, 141, 12, 141, 131, 142, 129, 144, 128,
	141, 10, 140, 137, 134, 136, 131, 135, 130, 133, 130, 131, 131, 129, 134, 128, 137, 128, 139, 129,
	141, 131, 134, 8, 132, 135, 131, 133, 131, 131, 132, 129, 134, 128, 128, 16, 136, 149, 144, 144,
	136, 148, 128, 144, 148, 0, 0, 0, 130, 12, 130, 139, 129, 139, 129, 140, 130, 141, 132, 142, 136,
	142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 143, 128, 139, 12, 139, 131, 140,
	129, 142, 128, 139, 10, 138, 137, 132, 136, 129, 135, 128, 133, 128, 131, 129, 129, 132, 128, 135,
	128, 137, 129, 139, 131, 132, 8, 130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 131, 18, 130,
	145, 131, 144, 132, 145, 131, 146, 138, 18, 137, 145, 138, 144, 139, 145, 138, 146, 148, 0, 0, 0,
	130, 12, 130, 139, 129, 139, 129, 140, 130, 141, 132, 142, 136, 142, 138, 141, 139, 140, 140, 138,
	140, 131, 141, 129, 142, 128, 143, 128, 139, 12, 139, 131, 140, 129, 142, 128, 139, 10, 138, 137,
	132, 136, 129, 135, 128, 133, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129, 139, 131, 132, 8,
	130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 132, 20, 133, 149, 132, 150, 131, 149, 131, 147,
	134, 145, 136, 144, 148, 0, 0, 0, 130, 12, 130, 139, 129, 139, 129, 140, 130, 141, 132, 142, 136,
	142, 138, 141, 139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 143, 128, 139, 12, 139, 131, 140,
	129, 142, 128, 139, 10, 138, 137, 132, 136, 129, 135, 128, 133, 128, 131, 129, 129, 132, 128, 135,
	128, 137, 129, 139, 131, 132, 8, 130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 137, 19, 137,
	147, 134, 18, 133, 145, 134, 144, 135, 144, 136, 145, 135, 146, 134, 146, 148, 0, 0, 0, 136, 0, 138,
	255, 139, 254, 140, 252, 139, 250, 138, 249, 135, 248, 137, 249, 138, 250, 139, 252, 138, 254, 136,
	128, 134, 128, 134, 129, 132, 130, 130, 132, 129, 135, 129, 137, 130, 140, 132, 142, 134, 143, 131,
	142, 129, 140, 128, 137, 128, 135, 129, 132, 131, 130, 134, 129, 136, 129, 139, 130, 141, 132, 129,
	124, 130, 253, 129, 254, 128, 253, 128, 252, 129, 250, 130, 249, 132, 248, 135, 248, 140, 12, 139,
	139, 140, 138, 141, 139, 141, 140, 139, 142, 137, 143, 134, 143, 146, 0, 0, 0, 135, 0, 133, 129, 131,
	131, 130, 134, 130, 136, 142, 136, 142, 138, 141, 140, 140, 141, 138, 142, 135, 142, 132, 141, 130,
	139, 129, 136, 129, 134, 130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 141, 8, 141,
	139, 140, 141, 135, 14, 133, 141, 131, 139, 130, 136, 128, 16, 136, 149, 144, 144, 136, 148, 128,
	144, 146, 0, 0, 0, 134, 0, 132, 129, 130, 131, 129, 134, 129, 136, 141, 136, 141, 138, 140, 140, 139,
	141, 137, 142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136,
	128, 139, 129, 141, 131, 140, 8, 140, 139, 139, 141, 134, 14, 132, 141, 130, 139, 129, 136, 132, 18,
	131, 145, 132, 144, 133, 145, 132, 146, 139, 18, 138, 145, 139, 144, 140, 145, 139, 146, 146, 0, 0,
	0, 134, 0, 132, 129, 130, 131, 129, 134, 129, 136, 141, 136, 141, 138, 140, 140, 139, 141, 137,
	142, 134, 142, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139,
	129, 141, 131, 140, 8, 140, 139, 139, 141, 134, 14, 132, 141, 130, 139, 129, 136, 133, 20, 134, 149,
	133, 150, 132, 149, 132, 147, 135, 145, 137, 144, 146, 0, 0, 0, 133, 14, 133, 128, 130, 14, 134, 142,
	134, 128, 130, 0, 137, 128, 129, 18, 128, 145, 129, 144, 130, 145, 129, 146, 136, 18, 135, 145, 136,
	144, 137, 145, 136, 146, 140, 0, 0, 0, 136, 14, 136, 128, 133, 14, 137, 142, 137, 128, 133, 0, 140,
	128, 128, 16, 136, 149, 144, 144, 136, 148, 128, 144, 146, 0, 0, 0, 132, 14, 132, 128, 129, 14, 133,
	142, 133, 128, 129, 0, 136, 128, 129, 20, 130, 149, 129, 150, 128, 149, 128, 147, 131, 145, 133,
	144, 140, 0, 0, 0, 144, 0, 137, 149, 130, 128, 137, 18, 143, 128, 132, 6, 141, 134, 128, 0, 134, 128,
	140, 0, 146, 128, 133, 25, 132, 152, 133, 151, 134, 152, 133, 153, 140, 25, 139, 152, 140, 151, 141,
	152, 140, 153, 151, 0, 0, 0, 144, 0, 137, 149, 130, 128, 137, 18, 143, 128, 132, 6, 141, 134, 128, 0,
	134, 128, 140, 0, 146, 128, 137, 25, 136, 153, 135, 152, 136, 151, 137, 151, 138, 152, 137, 153,
	151, 0, 0, 0, 131, 21, 131, 128, 132, 21, 132, 128, 138, 15, 138, 135, 128, 21, 144, 149, 144, 143,
	143, 149, 132, 11, 138, 139, 128, 0, 144, 128, 144, 134, 143, 128, 139, 26, 138, 155, 139, 156, 140,
	155, 140, 153, 137, 151, 135, 150, 149, 0, 0, 0, 130, 12, 130, 139, 129, 139, 129, 140, 130, 141,
	132, 142, 136, 142, 138, 141, 139, 140, 140, 138, 140, 134, 141, 131, 143, 129, 146, 128, 148, 128,
	151, 129, 153, 131, 140, 6, 140, 131, 141, 129, 142, 128, 146, 128, 144, 129, 142, 131, 141, 134,
	141, 136, 153, 136, 153, 138, 152, 140, 151, 141, 149, 142, 146, 142, 143, 141, 141, 139, 140, 136,
	139, 12, 139, 131, 140, 129, 142, 128, 139, 10, 138, 137, 132, 136, 129, 135, 128, 133, 128, 131,
	129, 129, 132, 128, 135, 128, 137, 129, 139, 131, 132, 8, 130, 135, 129, 133, 129, 131, 130, 129,
	132, 128, 141, 8, 142, 139, 144, 141, 146, 142, 151, 13, 152, 139, 152, 136, 141, 2, 142, 129, 144,
	128, 158, 0, 0, 0, 149, 0, 150, 134, 150, 128, 137, 128, 137, 149, 134, 149, 128, 0, 134, 128, 138, 0,
	138, 149, 150, 149, 150, 143, 149, 149, 138, 11, 144, 139, 144, 15, 144, 135, 132, 6, 137, 134, 135,
	21, 130, 128, 138, 21, 137, 149, 155, 0, 0, 0, 135, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130,
	131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 134, 143, 136, 142, 139, 140, 141, 137,
	142, 135, 142, 133, 141, 131, 139, 130, 136, 130, 134, 131, 131, 133, 129, 135, 128, 137, 0, 139,
	129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 137, 142, 128, 16, 136, 149, 144, 144, 136,
	148, 128, 144, 147, 0, 0, 0, 134, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129,
	134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 136, 142, 134, 142,
	132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129, 134, 128, 136, 0, 138, 129, 140, 131,
	141, 134, 141, 136, 140, 139, 138, 141, 136, 142, 132, 18, 131, 145, 132, 144, 133, 145, 132, 146,
	139, 18, 138, 145, 139, 144, 140, 145, 139, 146, 147, 0, 0, 0, 134, 14, 131, 141, 129, 139, 128, 136,
	128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 136, 141, 139,
	139, 141, 136, 142, 134, 142, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129, 134, 128,
	136, 0, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136, 142, 133, 20, 134, 149,
	133, 150, 132, 149, 132, 147, 135, 145, 137, 144, 147, 0, 0, 0, 131, 14, 131, 131, 132, 129, 135,
	128, 137, 128, 140, 129, 142, 131, 128, 14, 132, 142, 132, 131, 133, 129, 135, 128, 142, 14, 142,
	128, 146, 128, 139, 14, 143, 142, 143, 128, 128, 16, 136, 149, 144, 144, 136, 148, 128, 144, 148, 0,
	0, 0, 131, 14, 131, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 128, 14, 132, 142, 132,
	131, 133, 129, 135, 128, 142, 14, 142, 128, 146, 128, 139, 14, 143, 142, 143, 128, 134, 20, 135,
	149, 134, 150, 133, 149, 133, 147, 136, 145, 138, 144, 148, 0, 0, 0, 130, 14, 136, 128, 134, 252,
	132, 250, 130, 249, 129, 249, 128, 250, 129, 251, 130, 250, 131, 14, 136, 130, 142, 14, 136, 128,
	128, 14, 134, 142, 138, 14, 144, 142, 132, 19, 131, 146, 132, 145, 133, 146, 132, 147, 139, 19, 138,
	146, 139, 145, 140, 146, 139, 147, 149, 0, 0, 0, 128, 9, 129, 133, 130, 131, 132, 129, 135, 128, 137,
	128, 140, 129, 142, 131, 143, 133, 144, 137, 143, 141, 142, 143, 140, 145, 137, 146, 135, 146, 132,
	145, 130, 143, 129, 141, 128, 137, 135, 18, 133, 145, 131, 143, 130, 141, 129, 137, 130, 133, 131,
	131, 133, 129, 135, 128, 137, 0, 139, 129, 141, 131, 142, 133, 143, 137, 142, 141, 141, 143, 139,
	145, 137, 146, 133, 22, 132, 149, 133, 148, 134, 149, 133, 150, 140, 22, 139, 149, 140, 148, 141,
	149, 140, 150, 149, 0, 0, 0, 131, 18, 131, 134, 132, 131, 134, 129, 137, 128, 139, 128, 142, 129,
	144, 131, 145, 134, 145, 146, 132, 18, 132, 134, 133, 131, 135, 129, 137, 128, 142, 18, 148, 146,
	128, 18, 135, 146, 134, 23, 133, 150, 134, 149, 135, 150, 134, 151, 141, 23, 140, 150, 141, 149,
	142, 150, 141, 151, 153, 0, 0, 0, 135, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132,
	129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 134, 143, 136, 142, 139, 140, 141, 137, 142, 135,
	142, 133, 141, 131, 139, 130, 136, 130, 134, 131, 131, 133, 129, 135, 128, 137, 0, 139, 129, 141,
	131, 142, 134, 142, 136, 141, 139, 139, 141, 137, 142, 144, 14, 130, 128, 128, 128, 142, 142, 144,
	142, 148, 0, 0, 0, 143, 0, 145, 130, 145, 131, 143, 132, 145, 132, 146, 131, 146, 130, 145, 129, 143,
	128, 130, 128, 128, 130, 128, 131, 129, 131, 130, 128, 131, 0, 131, 145, 132, 147, 133, 148, 135,
	149, 138, 149, 140, 148, 141, 146, 141, 145, 140, 145, 140, 146, 139, 148, 137, 149, 136, 21, 134,
	148, 133, 147, 132, 144, 132, 128, 133, 13, 130, 140, 128, 139, 128, 140, 130, 141, 136, 141, 138,
	140, 138, 139, 137, 139, 135, 140, 132, 141, 152, 0, 0, 0, 138, 21, 135, 148, 133, 146, 132, 144,
	131, 140, 131, 137, 132, 133, 133, 131, 135, 129, 138, 128, 140, 128, 143, 129, 145, 131, 146, 133,
	147, 137, 147, 140, 146, 144, 145, 146, 143, 148, 140, 149, 138, 149, 136, 148, 134, 146, 133, 144,
	132, 140, 132, 137, 133, 133, 134, 131, 136, 129, 138, 128, 140, 0, 142, 129, 144, 131, 145, 133,
	146, 137, 146, 140, 145, 144, 144, 146, 142, 148, 140, 149, 128, 0, 130, 128, 151, 149, 149, 149,
	128, 128, 128, 128, 154, 0, 0, 0, 128, 21, 140, 149, 143, 148, 144, 147, 145, 145, 145, 142, 144,
	140, 143, 139, 140, 138, 132, 138, 140, 21, 142, 148, 143, 147, 144, 145, 144, 142, 143, 140, 142,
	139, 140, 138, 131, 21, 131, 128, 132, 21, 132, 128, 128, 0, 135, 128, 147, 15, 146, 143, 146, 132,
	147, 129, 149, 128, 148, 129, 147, 132, 147, 143, 149, 0, 151, 128, 153, 129, 154, 131, 146, 14,
	146, 143, 144, 9, 153, 137, 155, 0, 0, 0, 138, 14, 138, 253, 137, 251, 136, 250, 134, 249, 131, 249,
	129, 250, 128, 252, 128, 253, 129, 253, 129, 252, 130, 250, 132, 249, 133, 121, 135, 250, 136, 251,
	137, 254, 137, 142, 137, 0, 137, 145, 138, 147, 139, 148, 141, 149, 144, 149, 146, 148, 147, 146,
	147, 145, 146, 145, 146, 146, 145, 148, 143, 149, 142, 21, 140, 148, 139, 147, 138, 144, 138, 128,
	138, 9, 135, 136, 133, 135, 133, 136, 135, 137, 141, 137, 143, 136, 143, 135, 142, 135, 140, 136,
	137, 137, 149, 0, 0, 0, 130, 12, 130, 139, 129, 139, 129, 140, 130, 141, 132, 142, 136, 142, 138,
	141, 139, 140, 140, 138, 140, 131, 141, 129, 142, 128, 143, 128, 139, 12, 139, 131, 140, 129, 142,
	128, 139, 10, 138, 137, 132, 136, 129, 135, 128, 133, 128, 131, 129, 129, 132, 128, 135, 128, 137,
	129, 139, 131, 132, 8, 130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 136, 20, 135, 149, 136,
	150, 137, 149, 137, 147, 134, 145, 132, 144, 148, 0, 0, 0, 131, 14, 131, 128, 128, 14, 132, 142, 132,
	128, 128, 0, 135, 128, 135, 20, 134, 149, 135, 150, 136, 149, 136, 147, 133, 145, 131, 144, 140, 0,
	0, 0, 134, 14, 131, 141, 129, 139, 128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128,
	139, 129, 141, 131, 142, 134, 142, 136, 141, 139, 139, 141, 136, 142, 134, 142, 132, 141, 130, 139,
	129, 136, 129, 134, 130, 131, 132, 129, 134, 128, 136, 0, 138, 129, 140, 131, 141, 134, 141, 136,
	140, 139, 138, 141, 136, 142, 138, 20, 137, 149, 138, 150, 139, 149, 139, 147, 136, 145, 134, 144,
	147, 0, 0, 0, 131, 14, 131, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 128, 14, 132, 142,
	132, 131, 133, 129, 135, 128, 142, 14, 142, 128, 146, 128, 139, 14, 143, 142, 143, 128, 138, 20,
	137, 149, 138, 150, 139, 149, 139, 147, 136, 145, 134, 144, 148, 0, 0, 0, 131, 14, 131, 128, 128, 14,
	132, 142, 132, 128, 132, 11, 134, 141, 137, 142, 139, 142, 142, 141, 143, 139, 143, 128, 139, 14,
	141, 141, 142, 139, 142, 128, 128, 0, 135, 128, 139, 0, 146, 128, 131, 16, 132, 147, 134, 148, 136,
	148, 138, 147, 140, 147, 142, 148, 143, 150, 142, 147, 140, 146, 138, 146, 136, 147, 134, 147, 132,
	146, 131, 144, 151, 0, 0, 0, 131, 21, 131, 128, 128, 21, 132, 149, 144, 130, 132, 19, 144, 128, 144,
	149, 141, 21, 147, 149, 128, 0, 134, 128, 134, 28, 132, 155, 131, 152, 132, 154, 134, 155, 136, 155,
	140, 153, 142, 153, 144, 154, 145, 157, 144, 155, 142, 154, 140, 154, 136, 156, 134, 156, 152, 0, 0,
	0, 130, 12, 130, 139, 129, 139, 129, 140, 130, 141, 132, 142, 136, 142, 138, 141, 139, 140, 140,
	138, 140, 131, 141, 129, 142, 128, 139, 12, 139, 131, 140, 129, 142, 128, 143, 128, 139, 10, 138,
	137, 132, 136, 129, 135, 128, 133, 128, 131, 129, 129, 132, 128, 135, 128, 137, 129, 139, 131, 132,
	8, 130, 135, 129, 133, 129, 131, 130, 129, 132, 128, 148, 0, 0, 0, 134, 14, 131, 141, 129, 139,
	128, 136, 128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 142, 136,
	141, 139, 139, 141, 136, 142, 134, 142, 134, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131,
	132, 129, 134, 128, 136, 0, 138, 129, 140, 131, 141, 134, 141, 136, 140, 139, 138, 141, 136, 142,
	147, 0, 0, 0, 139, 4, 138, 133, 139, 134, 140, 133, 140, 132, 139, 130, 138, 129, 136, 128, 133, 128,
	130, 129, 129, 130, 128, 132, 128, 134, 129, 136, 130, 137, 134, 139, 134, 142, 133, 0, 131, 129,
	130, 130, 129, 132, 129, 134, 130, 136, 132, 138, 134, 19, 135, 148, 134, 149, 133, 148, 134, 147,
	145, 0, 0, 0, 128, 5, 128, 128, 131, 128, 131, 132, 140, 132, 140, 135, 128, 135, 128, 133, 142, 0, 0,
	0, 140, 5, 140, 128, 137, 128, 137, 132, 128, 132, 128, 135, 140, 135, 140, 133, 142, 0, 0, 0, 146,
	21, 130, 128, 128, 128, 144, 149, 146, 149, 144, 21, 145, 149, 128, 17, 130, 146, 133, 149, 133,
	138, 132, 20, 132, 138, 130, 10, 135, 138, 138, 0, 138, 130, 139, 131, 140, 131, 142, 128, 145, 128,
	146, 130, 146, 131, 140, 3, 142, 129, 144, 129, 146, 130, 138, 2, 138, 131, 139, 133, 140, 134, 144,
	135, 145, 136, 145, 138, 143, 139, 140, 139, 139, 138, 139, 137, 140, 136, 141, 137, 140, 138, 140,
	6, 144, 136, 144, 138, 143, 139, 151, 0, 0, 0, 146, 21, 130, 128, 128, 128, 144, 149, 146, 149,
	144, 21, 145, 149, 128, 17, 130, 146, 133, 149, 133, 138, 132, 20, 132, 138, 130, 10, 135, 138, 141,
	0, 146, 128, 144, 0, 144, 139, 138, 132, 146, 132, 143, 9, 143, 128, 151, 0, 0, 0, 129, 0, 128, 130,
	129, 142, 130, 130, 129, 128, 129, 2, 129, 136, 129, 19, 128, 148, 129, 149, 130, 148, 129, 147,
	135, 0, 0, 0, 136, 17, 128, 138, 136, 132, 145, 17, 137, 138, 145, 132, 149, 0, 0, 0, 137, 17, 145,
	138, 137, 132, 128, 17, 136, 138, 128, 132, 149, 0, 0, 0, 128, 18, 130, 146, 130, 144, 128, 144, 128,
	146, 129, 18, 129, 144, 128, 6, 130, 134, 130, 132, 128, 132, 128, 134, 129, 6, 129, 132, 128, 12,
	130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129, 138, 128, 0, 130, 128, 130, 254, 128, 254,
	128, 128, 129, 0, 129, 254, 132, 21, 134, 149, 134, 147, 132, 147, 132, 149, 133, 21, 133, 147, 132,
	9, 134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133, 135, 132, 15, 134, 143, 134, 141, 132,
	141, 132, 143, 133, 15, 133, 141, 132, 3, 134, 131, 134, 129, 132, 129, 132, 131, 133, 3, 133, 129,
	136, 18, 138, 146, 138, 144, 136, 144, 136, 146, 137, 18, 137, 144, 136, 6, 138, 134, 138, 132, 136,
	132, 136, 134, 137, 6, 137, 132, 136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138,
	136, 0, 138, 128, 138, 254, 136, 254, 136, 128, 137, 0, 137, 254, 140, 21, 142, 149, 142, 147, 140,
	147, 140, 149, 141, 21, 141, 147, 140, 9, 142, 137, 142, 135, 140, 135, 140, 137, 141, 9, 141, 135,
	140, 15, 142, 143, 142, 141, 140, 141, 140, 143, 141, 15, 141, 141, 140, 3, 142, 131, 142, 129, 140,
	129, 140, 131, 141, 3, 141, 129, 132, 125, 134, 253, 134, 251, 132, 251, 132, 253, 133, 125, 133,
	251, 140, 125, 140, 251, 142, 251, 142, 253, 140, 253, 141, 125, 141, 251, 142, 0, 0, 0, 128, 18,
	130, 146, 130, 144, 128, 144, 128, 146, 129, 18, 129, 144, 128, 6, 130, 134, 130, 132, 128, 132,
	128, 134, 129, 6, 129, 132, 128, 12, 130, 140, 130, 138, 128, 138, 128, 140, 129, 12, 129, 138, 128,
	0, 130, 128, 130, 254, 128, 254, 128, 128, 129, 0, 129, 254, 130, 21, 132, 149, 132, 147, 130,
	147, 130, 149, 131, 21, 131, 147, 130, 9, 132, 137, 132, 135, 130, 135, 130, 137, 131, 9, 131, 135,
	130, 15, 132, 143, 132, 141, 130, 141, 130, 143, 131, 15, 131, 141, 130, 3, 132, 131, 132, 129, 130,
	129, 130, 131, 131, 3, 131, 129, 132, 18, 134, 146, 134, 144, 132, 144, 132, 146, 133, 18, 133, 144,
	132, 6, 134, 134, 134, 132, 132, 132, 132, 134, 133, 6, 133, 132, 132, 12, 134, 140, 134, 138, 132,
	138, 132, 140, 133, 12, 133, 138, 132, 0, 134, 128, 134, 254, 132, 254, 132, 128, 133, 0, 133, 254,
	134, 21, 136, 149, 136, 147, 134, 147, 134, 149, 135, 21, 135, 147, 134, 9, 136, 137, 136, 135, 134,
	135, 134, 137, 135, 9, 135, 135, 134, 15, 136, 143, 136, 141, 134, 141, 134, 143, 135, 15, 135, 141,
	134, 3, 136, 131, 136, 129, 134, 129, 134, 131, 135, 3, 135, 129, 136, 18, 138, 146, 138, 144, 136,
	144, 136, 146, 137, 18, 137, 144, 136, 6, 138, 134, 138, 132, 136, 132, 136, 134, 137, 6, 137, 132,
	136, 12, 138, 140, 138, 138, 136, 138, 136, 140, 137, 12, 137, 138, 136, 0, 138, 128, 138, 254, 136,
	254, 136, 128, 137, 0, 137, 254, 138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139, 147,
	138, 9, 140, 137, 140, 135, 138, 135, 138, 137, 139, 9, 139, 135, 138, 15, 140, 143, 140, 141, 138,
	141, 138, 143, 139, 15, 139, 141, 138, 3, 140, 131, 140, 129, 138, 129, 138, 131, 139, 3, 139, 129,
	140, 18, 142, 146, 142, 144, 140, 144, 140, 146, 141, 18, 141, 144, 140, 6, 142, 134, 142, 132, 140,
	132, 140, 134, 141, 6, 141, 132, 140, 12, 142, 140, 142, 138, 140, 138, 140, 140, 141, 12, 141, 138,
	140, 0, 142, 128, 142, 254, 140, 254, 140, 128, 141, 0, 141, 254, 142, 21, 144, 149, 144, 147, 142,
	147, 142, 149, 143, 21, 143, 147, 142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143, 135,
	142, 15, 144, 143, 144, 141, 142, 141, 142, 143, 143, 15, 143, 141, 142, 3, 144, 131, 144, 129, 142,
	129, 142, 131, 143, 3, 143, 129, 130, 123, 132, 251, 132, 253, 130, 253, 130, 251, 131, 125, 131,
	251, 134, 125, 136, 253, 136, 251, 134, 251, 134, 253, 135, 125, 135, 251, 138, 125, 138, 251, 140,
	251, 140, 253, 138, 253, 139, 125, 139, 251, 144, 0, 0, 0, 128, 21, 130, 149, 130, 147, 128, 147,
	128, 149, 129, 21, 129, 147, 130, 21, 132, 149, 132, 147, 130, 147, 130, 149, 131, 21, 131, 147,
	138, 21, 140, 149, 140, 147, 138, 147, 138, 149, 139, 21, 139, 147, 140, 21, 142, 149, 142, 147,
	140, 147, 140, 149, 141, 21, 141, 147, 148, 21, 150, 149, 150, 147, 148, 147, 148, 149, 149, 21,
	149, 147, 150, 21, 152, 149, 152, 147, 150, 147, 150, 149, 151, 21, 151, 147, 132, 17, 134, 145,
	134, 143, 132, 143, 132, 145, 133, 17, 133, 143, 134, 17, 136, 145, 136, 143, 134, 143, 134, 145,
	135, 17, 135, 143, 136, 17, 138, 145, 138, 143, 136, 143, 136, 145, 137, 17, 137, 143, 128, 13, 130,
	141, 130, 139, 128, 139, 128, 141, 129, 13, 129, 139, 130, 13, 132, 141, 132, 139, 130, 139, 130,
	141, 131, 13, 131, 139, 138, 13, 140, 141, 140, 139, 138, 139, 138, 141, 139, 13, 139, 139, 140, 13,
	142, 141, 142, 139, 140, 139, 140, 141, 141, 13, 141, 139, 148, 13, 150, 141, 150, 139, 148, 139,
	148, 141, 149, 13, 149, 139, 150, 13, 152, 141, 152, 139, 150, 139, 150, 141, 151, 13, 151, 139,
	142, 9, 144, 137, 144, 135, 142, 135, 142, 137, 143, 9, 143, 135, 144, 9, 146, 137, 146, 135, 144,
	135, 144, 137, 145, 9, 145, 135, 146, 9, 148, 137, 148, 135, 146, 135, 146, 137, 147, 9, 147, 135,
	128, 5, 130, 133, 130, 131, 128, 131, 128, 133, 129, 5, 129, 131, 130, 5, 132, 133, 132, 131, 130,
	131, 130, 133, 131, 5, 131, 131, 138, 5, 140, 133, 140, 131, 138, 131, 138, 133, 139, 5, 139, 131,
	140, 5, 142, 133, 142, 131, 140, 131, 140, 133, 141, 5, 141, 131, 148, 5, 150, 133, 150, 131, 148,
	131, 148, 133, 149, 5, 149, 131, 150, 5, 152, 133, 152, 131, 150, 131, 150, 133, 151, 5, 151, 131,
	132, 1, 138, 129, 138, 255, 132, 255, 132, 129, 133, 1, 133, 255, 135, 1, 135, 255, 137, 1, 137, 255,
	128, 125, 132, 253, 132, 251, 128, 251, 128, 253, 129, 125, 129, 251, 131, 125, 131, 251, 138, 125,
	142, 253, 142, 251, 138, 251, 138, 253, 139, 125, 139, 251, 141, 125, 141, 251, 148, 125, 150, 253,
	150, 251, 148, 251, 148, 253, 149, 125, 149, 251, 150, 125, 152, 253, 152, 251, 150, 251, 150, 253,
	151, 125, 151, 251, 140, 125, 140, 251, 130, 125, 130, 251, 134, 1, 134, 255, 136, 1, 136, 255, 146,
	17, 148, 145, 148, 143, 146, 143, 146, 145, 147, 17, 147, 143, 148, 17, 150, 145, 150, 143, 148,
	143, 148, 145, 149, 17, 149, 143, 150, 17, 152, 145, 152, 143, 150, 143, 150, 145, 151, 17, 151,
	143, 128, 9, 130, 137, 130, 135, 128, 135, 128, 137, 129, 9, 129, 135, 130, 9, 132, 137, 132, 135,
	130, 135, 130, 137, 131, 9, 131, 135, 132, 9, 134, 137, 134, 135, 132, 135, 132, 137, 133, 9, 133,
	135, 146, 1, 152, 129, 152, 255, 146, 255, 146, 129, 147, 1, 147, 255, 149, 1, 149, 255, 151, 1, 151,
	255, 148, 1, 148, 255, 150, 1, 150, 255, 152, 0, 0, 0, 128, 21, 128, 249, 132, 0, 0, 0, 128, 5, 137,
	133, 137, 149, 137, 5, 137, 249, 141, 0, 0, 0, 128, 9, 137, 137, 137, 249, 137, 9, 137, 149, 128, 5,
	137, 133, 141, 0, 0, 0, 128, 5, 137, 133, 137, 149, 137, 5, 137, 249, 146, 121, 146, 149, 150, 0, 0, 0,
	128, 5, 146, 133, 146, 249, 137, 5, 137, 249, 150, 0, 0, 0, 128, 9, 137, 137, 137, 249, 128, 5, 137,
	133, 141, 0, 0, 0, 128, 5, 137, 133, 137, 249, 146, 121, 146, 149, 128, 9, 137, 137, 137, 149, 150, 0,
	0, 0, 137, 121, 137, 149, 146, 121, 146, 149, 150, 0, 0, 0, 128, 9, 146, 137, 146, 249, 128, 5, 137,
	133, 137, 249, 150, 0, 0, 0, 128, 5, 146, 133, 146, 149, 128, 9, 137, 137, 137, 149, 150, 0, 0, 0, 128,
	9, 146, 137, 146, 149, 137, 9, 137, 149, 150, 0, 0, 0, 128, 5, 137, 133, 137, 149, 128, 9, 137, 137,
	141, 0, 0, 0, 128, 9, 137, 137, 137, 249, 128, 0, 0, 0, 137, 5, 128, 133, 128, 149, 137, 0, 0, 0, 128, 5,
	137, 133, 137, 149, 146, 5, 137, 133, 146, 0, 0, 0, 128, 9, 137, 137, 137, 249, 146, 9, 137, 137, 146,
	0, 0, 0, 137, 5, 128, 133, 128, 149, 128, 5, 128, 249, 137, 0, 0, 0, 128, 5, 146, 133, 146, 0, 0, 0,
	128, 5, 137, 133, 137, 149, 146, 5, 137, 133, 137, 249, 147, 0, 0, 0, 137, 9, 128, 137, 128, 249, 128,
	9, 128, 149, 137, 5, 128, 133, 137, 0, 0, 0, 146, 5, 137, 133, 137, 149, 137, 5, 137, 249, 128, 121,
	128, 149, 146, 0, 0, 0, 146, 5, 128, 133, 128, 149, 146, 9, 137, 137, 137, 149, 146, 0, 0, 0, 146, 9,
	128, 137, 128, 249, 146, 5, 137, 133, 137, 249, 146, 0, 0, 0, 128, 5, 155, 133, 128, 9, 137, 137, 137,
	149, 155, 9, 146, 137, 146, 149, 155, 0, 0, 0, 128, 9, 155, 137, 128, 5, 137, 133, 137, 249, 155, 5,
	146, 133, 146, 249, 155, 0, 0, 0, 146, 5, 137, 133, 137, 249, 128, 121, 128, 149, 146, 9, 137, 137,
	137, 149, 146, 0, 0, 0, 128, 5, 146, 133, 128, 9, 146, 137, 146, 0, 0, 0, 128, 5, 137, 133, 137, 249,
	128, 9, 137, 137, 137, 149, 146, 21, 146, 137, 155, 137, 146, 121, 146, 133, 155, 133, 155, 0, 0, 0,
	128, 5, 146, 133, 128, 9, 146, 137, 137, 21, 137, 137, 255, 0, 128, 128, 146, 0, 0, 0, 128, 9, 146,
	137, 135, 9, 135, 149, 144, 9, 144, 149, 146, 0, 0, 0, 128, 9, 146, 137, 128, 5, 146, 133, 137, 121,
	137, 133, 146, 0, 0, 0, 128, 5, 146, 133, 135, 5, 135, 249, 144, 5, 144, 249, 146, 0, 0, 0, 146, 9, 128,
	137, 128, 149, 137, 9, 137, 149, 146, 0, 0, 0, 137, 5, 128, 133, 128, 149, 137, 9, 128, 137, 137, 0, 0,
	0, 137, 9, 128, 137, 128, 249, 137, 5, 128, 133, 138, 0, 0, 0, 146, 5, 128, 133, 128, 249, 137, 5,
	137, 249, 146, 0, 0, 0, 128, 5, 137, 133, 137, 149, 155, 5, 137, 133, 137, 249, 146, 121, 146, 149,
	156, 0, 0, 0, 128, 5, 137, 133, 137, 149, 146, 5, 137, 133, 137, 249, 128, 9, 146, 137, 146, 0, 0, 0,
	128, 5, 137, 133, 137, 149, 141, 0, 0, 0, 137, 9, 128, 137, 128, 249, 137, 0, 0, 0, 128, 21, 145, 149,
	145, 128, 128, 128, 128, 149, 129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132,
	128, 133, 21, 133, 128, 134, 0, 134, 149, 135, 21, 135, 128, 136, 21, 136, 128, 137, 21, 137, 128,
	138, 21, 138, 128, 139, 21, 139, 128, 140, 0, 140, 149, 141, 21, 141, 128, 142, 21, 142, 128, 143,
	21, 143, 128, 144, 21, 144, 128, 145, 21, 145, 128, 128, 10, 145, 138, 145, 0, 0, 0, 145, 0, 128,
	128, 128, 138, 145, 138, 145, 128, 129, 10, 129, 128, 130, 10, 130, 128, 131, 10, 131, 128, 132, 10,
	132, 128, 133, 10, 133, 128, 134, 10, 134, 128, 135, 10, 135, 128, 136, 10, 136, 128, 137, 10, 137,
	128, 138, 10, 138, 128, 139, 10, 139, 128, 140, 10, 140, 128, 141, 10, 141, 128, 142, 10, 142, 128,
	143, 10, 143, 128, 144, 10, 144, 128, 145, 0, 0, 0, 128, 0, 128, 149, 136, 149, 136, 128, 128, 128,
	129, 21, 129, 128, 130, 21, 130, 128, 131, 21, 131, 128, 132, 21, 132, 128, 133, 21, 133, 128, 134,
	0, 134, 149, 135, 21, 135, 128, 136, 0, 0, 0, 136, 0, 136, 149, 144, 149, 144, 128, 136, 128, 137,
	21, 137, 128, 138, 21, 138, 128, 139, 21, 139, 128, 140, 21, 140, 128, 141, 21, 141, 128, 142, 0,
	142, 149, 143, 21, 143, 128, 144, 0, 0, 0, 145, 11, 128, 139, 128, 149, 145, 149, 145, 139, 129, 21,
	129, 139, 130, 21, 130, 139, 131, 21, 131, 139, 132, 21, 132, 139, 133, 21, 133, 139, 134, 21, 134,
	139, 135, 21, 135, 139, 136, 21, 136, 139, 137, 21, 137, 139, 138, 21, 138, 139, 139, 21, 139, 139,
	140, 21, 140, 139, 141, 21, 141, 139, 142, 21, 142, 139, 143, 21, 143, 139, 144, 21, 144, 139, 145,
	0, 0, 0, 134, 0, 132, 129, 130, 131, 129, 134, 130, 137, 132, 139, 134, 140, 131, 139, 129, 137,
	128, 134, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 148, 142, 147, 142, 140, 131,
	138, 129, 136, 128, 136, 12, 138, 139, 140, 137, 147, 128, 148, 128, 141, 137, 139, 139, 136, 140,
	134, 140, 151, 0, 0, 0, 128, 127, 128, 251, 129, 251, 129, 135, 136, 135, 138, 133, 138, 130, 129,
	130, 129, 129, 138, 129, 139, 130, 139, 133, 137, 135, 139, 137, 139, 140, 138, 141, 129, 141, 128,
	140, 128, 252, 129, 11, 130, 140, 137, 140, 138, 139, 138, 137, 136, 136, 129, 136, 129, 139, 142,
	0, 0, 0, 128, 0, 128, 143, 137, 143, 137, 141, 136, 141, 136, 142, 129, 142, 129, 128, 255, 128,
	141, 0, 0, 0, 132, 0, 132, 143, 128, 143, 128, 144, 145, 144, 145, 143, 142, 143, 142, 128, 141, 0,
	141, 143, 133, 143, 133, 128, 149, 0, 0, 0, 143, 0, 144, 134, 144, 128, 131, 128, 137, 139, 131, 149,
	144, 149, 144, 143, 143, 149, 132, 21, 138, 139, 132, 128, 131, 21, 128, 149, 128, 0, 131, 128, 148,
	0, 0, 0, 128, 6, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 141, 137,
	139, 139, 136, 140, 134, 140, 131, 139, 129, 137, 128, 134, 134, 12, 132, 139, 130, 137, 129, 134,
	130, 131, 132, 129, 134, 128, 136, 0, 138, 129, 140, 131, 141, 134, 140, 137, 138, 139, 136, 140,
	131, 11, 133, 141, 135, 142, 148, 142, 148, 141, 135, 141, 132, 139, 152, 0, 0, 0, 131, 14, 131, 131,
	132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 142, 14, 142, 128, 143, 128, 143, 142, 139, 142,
	128, 14, 132, 142, 132, 131, 133, 129, 135, 128, 132, 1, 132, 252, 130, 249, 131, 249, 133, 252,
	133, 129, 147, 0, 0, 0, 134, 12, 134, 254, 135, 254, 135, 136, 140, 140, 139, 140, 135, 137, 135,
	140, 133, 142, 131, 142, 128, 139, 129, 139, 131, 141, 133, 141, 134, 140, 143, 0, 0, 0, 128, 8, 129,
	133, 131, 131, 134, 130, 136, 130, 139, 131, 141, 133, 142, 136, 141, 139, 139, 141, 136, 142, 134,
	142, 131, 141, 129, 139, 128, 136, 134, 14, 132, 141, 130, 139, 129, 136, 130, 133, 132, 131, 134,
	130, 136, 2, 138, 131, 140, 133, 141, 136, 140, 139, 138, 141, 136, 142, 128, 21, 142, 149, 135, 21,
	135, 142, 135, 2, 135, 251, 128, 123, 142, 251, 146, 0, 0, 0, 135, 21, 132, 148, 130, 146, 129, 144,
	128, 140, 128, 137, 129, 133, 130, 131, 132, 129, 135, 128, 137, 128, 140, 129, 142, 131, 143, 133,
	144, 137, 144, 140, 143, 144, 142, 146, 140, 148, 137, 149, 135, 149, 133, 148, 131, 146, 130, 144,
	129, 140, 129, 139, 143, 139, 143, 140, 142, 144, 141, 146, 139, 148, 137, 149, 137, 0, 139, 129,
	141, 131, 142, 133, 143, 137, 143, 138, 129, 138, 129, 137, 130, 133, 131, 131, 133, 129, 135, 128,
	148, 0, 0, 0, 129, 9, 129, 140, 130, 144, 131, 146, 133, 148, 135, 149, 132, 148, 130, 146, 129, 144,
	128, 140, 128, 137, 129, 136, 133, 133, 133, 129, 128, 129, 128, 128, 134, 128, 134, 133, 129, 137,
	135, 21, 137, 149, 139, 148, 141, 146, 142, 144, 143, 140, 143, 137, 138, 133, 138, 128, 144, 128,
	144, 129, 139, 129, 139, 133, 143, 136, 144, 137, 144, 140, 143, 144, 142, 146, 140, 148, 137, 149,
	148, 0, 0, 0, 128, 6, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 141, 137,
	139, 139, 136, 140, 134, 140, 131, 139, 129, 137, 128, 134, 136, 0, 138, 129, 140, 131, 141, 134,
	140, 137, 138, 139, 136, 140, 128, 149, 142, 149, 143, 148, 142, 147, 141, 148, 132, 148, 131, 147,
	139, 139, 134, 12, 132, 139, 130, 137, 129, 134, 130, 131, 132, 129, 134, 128, 155, 0, 155, 128,
	147, 0, 0, 0, 128, 6, 129, 131, 131, 129, 134, 128, 136, 128, 139, 129, 141, 131, 142, 134, 141, 137,
	139, 139, 136, 140, 134, 140, 131, 139, 129, 137, 128, 134, 136, 0, 138, 129, 140, 131, 141, 134,
	140, 137, 138, 139, 136, 140, 134, 12, 132, 139, 130, 137, 129, 134, 130, 131, 132, 129, 134, 128,
	141, 6, 142, 131, 144, 129, 147, 128, 149, 128, 152, 129, 154, 131, 155, 134, 154, 137, 152, 139,
	149, 140, 147, 140, 144, 139, 142, 137, 141, 134, 149, 0, 151, 129, 153, 131, 154, 134, 153, 137,
	151, 139, 149, 140, 147, 12, 145, 139, 143, 137, 142, 134, 143, 131, 145, 129, 147, 128, 159, 0, 0,
	0, 135, 14, 132, 141, 130, 139, 129, 136, 129, 134, 130, 131, 132, 129, 135, 128, 137, 128, 140,
	129, 142, 131, 143, 134, 143, 136, 142, 139, 140, 141, 137, 142, 135, 142, 133, 141, 131, 139, 130,
	136, 130, 134, 131, 131, 133, 129, 135, 128, 137, 0, 139, 129, 141, 131, 142, 134, 142, 136, 141,
	139, 139, 141, 137, 142, 144, 14, 130, 128, 128, 128, 142, 142, 144, 142, 148, 0, 0, 0, 141, 20, 132,
	148, 130, 147, 129, 146, 128, 144, 128, 138, 135, 138, 141, 0, 132, 128, 130, 129, 129, 130, 128,
	132, 128, 142, 128, 6, 128, 138, 144, 0, 0, 0, 131, 0, 131, 143, 132, 146, 134, 148, 137, 149, 139,
	149, 142, 148, 144, 146, 145, 143, 145, 128, 132, 0, 132, 143, 133, 146, 135, 148, 137, 149, 128, 0,
	135, 128, 142, 0, 148, 128, 151, 0, 0, 0, 128, 9, 146, 137, 128, 12, 146, 140, 128, 6, 146, 134, 155,
	127, 155, 255, 151, 0, 0, 0, 128, 0, 146, 128, 137, 21, 137, 131, 128, 12, 146, 140, 150, 0, 0, 0, 128,
	0, 146, 128, 128, 21, 144, 140, 128, 131, 149, 0, 0, 0, 146, 0, 128, 128, 146, 21, 130, 140, 146,
	131, 151, 0, 0, 0, 133, 21, 131, 148, 130, 147, 129, 144, 129, 249, 128, 249, 128, 145, 129, 147,
	130, 148, 132, 149, 135, 149, 137, 148, 138, 146, 138, 145, 137, 145, 137, 146, 136, 148, 134, 149,
	142, 0, 0, 0, 133, 121, 135, 250, 136, 251, 137, 254, 137, 149, 138, 149, 138, 253, 137, 251, 136,
	250, 134, 249, 131, 249, 129, 250, 128, 252, 128, 253, 129, 253, 129, 252, 130, 250, 132, 249, 142,
	0, 0, 0, 137, 21, 136, 148, 137, 147, 138, 148, 137, 149, 137, 2, 136, 129, 137, 128, 138, 129,
	137, 130, 128, 10, 146, 138, 150, 0, 0, 0, 128, 2, 128, 132, 129, 135, 131, 136, 133, 136, 135, 135,
	139, 132, 141, 131, 143, 131, 145, 132, 146, 134, 146, 136, 128, 4, 129, 134, 131, 135, 133, 135,
	135, 134, 139, 131, 141, 130, 143, 130, 145, 131, 146, 134, 128, 10, 128, 140, 129, 143, 131, 144,
	133, 144, 135, 143, 139, 140, 141, 139, 143, 139, 145, 140, 146, 142, 146, 144, 128, 12, 129, 142,
	131, 143, 133, 143, 135, 142, 139, 139, 141, 138, 143, 138, 145, 139, 146, 142, 150, 0, 0, 0, 128,
	15, 129, 140, 131, 138, 134, 137, 136, 137, 139, 138, 141, 140, 142, 143, 141, 146, 139, 148, 136,
	149, 134, 149, 131, 148, 129, 146, 128, 143, 134, 21, 132, 148, 130, 146, 129, 143, 130, 140, 132,
	138, 134, 137, 136, 9, 138, 138, 140, 140, 141, 143, 140, 146, 138, 148, 136, 149, 128, 6, 128, 134,
	146, 0, 0, 0, 128, 2, 131, 130, 131, 128, 128, 128, 128, 132, 131, 132, 131, 130, 130, 4, 130, 128,
	129, 4, 129, 128, 135, 0, 0, 0, 128, 2, 131, 130, 131, 128, 128, 128, 128, 130, 129, 2, 129, 128, 130,
	2, 130, 128, 134, 0, 0, 0, 128, 11, 137, 128, 137, 149, 147, 149, 147, 146, 148, 0, 0, 0, 132, 18,
	134, 148, 137, 149, 139, 149, 142, 148, 143, 146, 143, 139, 142, 139, 142, 146, 141, 148, 139, 149,
	128, 21, 132, 149, 132, 139, 131, 139, 131, 149, 146, 0, 0, 0, 130, 19, 131, 147, 130, 146, 129, 147,
	129, 148, 131, 149, 133, 149, 135, 148, 135, 146, 133, 144, 130, 143, 128, 141, 128, 140, 129, 141,
	130, 141, 132, 139, 134, 139, 135, 141, 136, 142, 130, 13, 132, 140, 133, 140, 135, 141, 133, 16,
	135, 145, 136, 146, 136, 148, 133, 149, 140, 0, 0, 0, 128, 0, 128, 138, 137, 138, 137, 128, 128, 128,
	129, 10, 129, 128, 130, 10, 130, 128, 131, 10, 131, 128, 132, 10, 132, 128, 133, 10, 133, 128, 134,
	10, 134, 128, 135, 10, 135, 128, 136, 10, 136, 128, 141, 0, 0, 0
};
static const unsigned char European[8439] = /* binary data included from EURO.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 77, 97, 121, 32, 49, 55, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121,
	114, 105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108,
	97, 110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0,
	69, 85, 82, 79, 119, 32, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0,
	43, 223, 0, 0, 32, 173, 2, 0, 45, 0, 246, 0, 0, 0, 0, 0, 0, 0, 4, 0, 22, 0, 54, 0, 74, 0, 118, 0, 164, 0,
	212, 0, 230, 0, 250, 0, 14, 1, 42, 1, 54, 1, 70, 1, 78, 1, 92, 1, 100, 1, 138, 1, 148, 1, 180, 1, 214, 1,
	226, 1, 254, 1, 34, 2, 44, 2, 92, 2, 128, 2, 152, 2, 180, 2, 190, 2, 202, 2, 212, 2, 252, 2, 52, 3, 66, 3,
	102, 3, 138, 3, 164, 3, 180, 3, 194, 3, 232, 3, 248, 3, 0, 4, 22, 4, 40, 4, 50, 4, 64, 4, 76, 4, 114, 4,
	136, 4, 178, 4, 208, 4, 248, 4, 4, 5, 28, 5, 38, 5, 52, 5, 64, 5, 78, 5, 90, 5, 102, 5, 110, 5, 122, 5, 132,
	5, 140, 5, 148, 5, 190, 5, 222, 5, 250, 5, 26, 6, 56, 6, 74, 6, 114, 6, 136, 6, 148, 6, 164, 6, 182, 6,
	190, 6, 226, 6, 248, 6, 22, 7, 54, 7, 86, 7, 106, 7, 146, 7, 170, 7, 192, 7, 202, 7, 216, 7, 228, 7, 246,
	7, 2, 8, 20, 8, 28, 8, 46, 8, 58, 8, 74, 8, 130, 8, 172, 8, 216, 8, 6, 9, 66, 9, 120, 9, 184, 9, 226, 9, 6,
	10, 56, 10, 100, 10, 128, 10, 142, 10, 164, 10, 198, 10, 236, 10, 10, 11, 76, 11, 104, 11, 140, 11,
	190, 11, 234, 11, 6, 12, 46, 12, 84, 12, 142, 12, 186, 12, 220, 12, 252, 12, 42, 13, 84, 13, 120, 13,
	174, 13, 196, 13, 240, 13, 20, 14, 50, 14, 70, 14, 114, 14, 146, 14, 186, 14, 196, 14, 206, 14, 244,
	14, 14, 15, 32, 15, 52, 15, 68, 15, 104, 16, 172, 18, 230, 21, 238, 21, 250, 21, 10, 22, 26, 22, 44,
	22, 64, 22, 84, 22, 96, 22, 112, 22, 128, 22, 142, 22, 162, 22, 172, 22, 182, 22, 194, 22, 206, 22,
	222, 22, 230, 22, 242, 22, 2, 23, 18, 23, 34, 23, 50, 23, 70, 23, 90, 23, 114, 23, 126, 23, 154, 23,
	170, 23, 188, 23, 204, 23, 222, 23, 236, 23, 252, 23, 12, 24, 26, 24, 42, 24, 58, 24, 68, 24, 78, 24,
	216, 24, 94, 25, 164, 25, 234, 25, 112, 26, 140, 26, 168, 26, 180, 26, 196, 26, 214, 26, 246, 26, 22,
	27, 44, 27, 88, 27, 122, 27, 166, 27, 202, 27, 252, 27, 30, 28, 62, 28, 86, 28, 102, 28, 118, 28, 132,
	28, 146, 28, 168, 28, 190, 28, 218, 28, 238, 28, 10, 29, 40, 29, 70, 29, 84, 29, 106, 29, 132, 29, 29,
	8, 15, 27, 35, 54, 40, 10, 15, 15, 25, 32, 32, 32, 9, 19, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 8, 12,
	28, 28, 28, 30, 31, 37, 32, 34, 35, 30, 29, 35, 33, 6, 27, 32, 27, 42, 34, 36, 32, 39, 31, 32, 31, 33,
	35, 53, 35, 35, 33, 14, 19, 14, 24, 32, 22, 26, 27, 26, 27, 27, 21, 27, 26, 6, 11, 24, 6, 40, 26, 27, 27,
	27, 23, 26, 26, 26, 28, 37, 27, 26, 25, 14, 7, 14, 31, 26, 34, 26, 27, 26, 26, 26, 26, 26, 27, 27, 27,
	12, 19, 16, 37, 37, 30, 48, 49, 27, 27, 27, 26, 26, 26, 36, 33, 27, 37, 36, 37, 43, 26, 12, 27, 26, 31,
	34, 26, 27, 30, 26, 26, 37, 37, 8, 29, 29, 25, 24, 36, 21, 21, 20, 36, 36, 20, 36, 36, 36, 36, 36, 20,
	21, 15, 30, 30, 15, 31, 30, 15, 31, 31, 31, 46, 46, 31, 31, 46, 31, 31, 30, 31, 31, 15, 15, 31, 46, 31,
	20, 15, 31, 31, 15, 30, 31, 33, 28, 25, 30, 29, 36, 28, 36, 26, 35, 36, 26, 47, 25, 30, 33, 26, 26, 26,
	26, 25, 25, 29, 31, 27, 9, 9, 35, 25, 21, 15, 157, 0, 0, 0, 129, 42, 129, 142, 130, 0, 130, 132, 128,
	132, 128, 128, 130, 128, 136, 0, 0, 0, 130, 42, 128, 170, 128, 166, 130, 166, 130, 170, 129, 38, 129,
	158, 136, 38, 137, 166, 137, 170, 135, 170, 135, 166, 136, 166, 136, 158, 143, 0, 0, 0, 138, 42, 131,
	128, 139, 0, 147, 170, 148, 28, 128, 156, 129, 16, 149, 144, 155, 0, 0, 0, 156, 35, 155, 168, 152,
	170, 132, 170, 129, 168, 128, 163, 128, 158, 129, 153, 131, 151, 153, 149, 156, 146, 157, 142, 157,
	135, 156, 131, 153, 128, 132, 128, 129, 131, 128, 135, 142, 48, 142, 253, 163, 0, 0, 0, 145, 38, 142,
	170, 130, 170, 128, 166, 128, 148, 130, 144, 142, 144, 145, 148, 145, 166, 155, 42, 149, 128, 174,
	0, 176, 132, 176, 151, 174, 155, 162, 155, 159, 151, 159, 132, 159, 132, 162, 128, 174, 128, 182,
	0, 0, 0, 157, 18, 157, 137, 155, 131, 152, 128, 134, 128, 131, 131, 128, 137, 128, 146, 131, 152,
	134, 153, 154, 31, 154, 165, 153, 168, 152, 169, 149, 170, 136, 170, 133, 169, 131, 168, 131, 165,
	131, 158, 134, 153, 162, 128, 168, 0, 0, 0, 130, 42, 128, 170, 128, 166, 130, 166, 130, 42, 130, 160,
	128, 158, 138, 0, 0, 0, 137, 42, 131, 169, 129, 165, 128, 156, 128, 142, 129, 134, 131, 129, 137,
	128, 143, 0, 0, 0, 128, 42, 134, 169, 136, 165, 137, 156, 137, 142, 136, 134, 134, 129, 128, 128,
	143, 0, 0, 0, 128, 31, 135, 159, 140, 31, 147, 159, 134, 42, 136, 162, 138, 28, 141, 148, 141, 42,
	138, 162, 136, 28, 134, 148, 153, 0, 0, 0, 128, 18, 148, 146, 138, 34, 138, 131, 160, 0, 0, 0, 130, 0,
	128, 128, 128, 132, 130, 132, 130, 251, 128, 248, 160, 0, 0, 0, 128, 18, 149, 146, 160, 0, 0, 0, 130,
	0, 128, 128, 128, 132, 130, 132, 130, 128, 137, 0, 0, 0, 141, 42, 128, 253, 147, 0, 0, 0, 137, 0,
	131, 129, 129, 134, 128, 142, 128, 156, 129, 165, 131, 169, 137, 170, 146, 170, 151, 169, 153, 165,
	154, 156, 154, 142, 153, 134, 151, 129, 146, 128, 136, 128, 160, 0, 0, 0, 134, 27, 146, 170, 146,
	128, 160, 0, 0, 0, 129, 34, 130, 167, 133, 170, 148, 170, 152, 167, 153, 162, 153, 156, 152, 151,
	148, 148, 133, 145, 130, 142, 129, 137, 128, 128, 153, 128, 160, 0, 0, 0, 128, 35, 129, 167, 132,
	170, 149, 170, 153, 167, 153, 153, 149, 151, 137, 151, 149, 23, 153, 148, 153, 131, 149, 128, 132,
	128, 129, 131, 128, 136, 160, 0, 0, 0, 154, 11, 128, 139, 151, 170, 151, 128, 160, 0, 0, 0, 128, 7,
	129, 131, 132, 128, 149, 128, 153, 131, 153, 153, 149, 156, 133, 156, 130, 153, 128, 149, 128, 170,
	153, 170, 160, 0, 0, 0, 153, 34, 153, 167, 149, 170, 132, 170, 129, 167, 128, 162, 128, 136, 129,
	131, 132, 128, 149, 128, 153, 131, 153, 149, 149, 152, 133, 152, 130, 149, 128, 143, 160, 0, 0, 0,
	128, 42, 154, 170, 135, 128, 160, 0, 0, 0, 148, 23, 153, 148, 153, 131, 149, 128, 132, 128, 129, 131,
	128, 135, 128, 144, 129, 148, 133, 151, 148, 151, 152, 153, 153, 158, 153, 163, 152, 167, 148, 170,
	133, 170, 130, 167, 129, 163, 129, 158, 130, 154, 133, 151, 160, 0, 0, 0, 128, 8, 129, 131, 132, 128,
	149, 128, 153, 131, 153, 167, 149, 170, 132, 170, 129, 167, 128, 162, 128, 155, 129, 149, 132, 146,
	148, 146, 152, 149, 153, 155, 160, 0, 0, 0, 128, 24, 128, 156, 130, 156, 130, 152, 128, 152, 128, 4,
	130, 132, 130, 128, 128, 128, 128, 132, 136, 0, 0, 0, 128, 24, 128, 156, 130, 156, 130, 152, 128,
	152, 130, 4, 128, 132, 128, 128, 130, 128, 130, 4, 130, 251, 128, 248, 140, 0, 0, 0, 150, 34, 128,
	146, 150, 131, 156, 0, 0, 0, 128, 24, 149, 152, 128, 13, 149, 141, 156, 0, 0, 0, 128, 34, 150, 146,
	128, 131, 156, 0, 0, 0, 128, 28, 128, 163, 129, 167, 133, 170, 148, 170, 151, 167, 152, 163, 152,
	156, 151, 152, 148, 149, 141, 148, 139, 145, 139, 142, 140, 0, 140, 132, 139, 132, 139, 128, 140,
	128, 158, 0, 0, 0, 143, 28, 140, 158, 136, 155, 135, 147, 136, 141, 139, 139, 142, 142, 143, 30, 142,
	142, 143, 139, 146, 139, 148, 141, 151, 149, 151, 159, 147, 166, 143, 170, 141, 170, 135, 166, 130,
	158, 128, 149, 128, 142, 130, 135, 135, 128, 139, 128, 145, 128, 153, 132, 159, 0, 0, 0, 128, 0, 143,
	170, 159, 128, 154, 11, 132, 139, 165, 0, 0, 0, 128, 0, 128, 170, 149, 170, 153, 167, 153, 163, 153,
	157, 153, 153, 149, 150, 128, 150, 149, 22, 153, 147, 154, 142, 154, 136, 153, 131, 149, 128, 128,
	128, 160, 0, 0, 0, 156, 31, 155, 165, 153, 169, 148, 170, 136, 170, 131, 169, 129, 164, 128, 156,
	128, 142, 129, 133, 131, 129, 136, 128, 148, 128, 153, 129, 155, 134, 156, 139, 162, 0, 0, 0, 128, 0,
	128, 170, 148, 170, 153, 169, 156, 165, 157, 156, 157, 142, 156, 134, 154, 129, 148, 128, 128, 128,
	163, 0, 0, 0, 152, 0, 128, 128, 128, 170, 152, 170, 151, 22, 128, 150, 158, 0, 0, 0, 128, 0, 128, 170,
	151, 170, 150, 22, 128, 150, 157, 0, 0, 0, 156, 36, 154, 169, 148, 170, 136, 170, 131, 169, 129, 165,
	128, 156, 128, 142, 129, 134, 131, 129, 136, 128, 148, 128, 154, 129, 156, 134, 157, 142, 157, 148,
	142, 148, 163, 0, 0, 0, 128, 0, 128, 170, 128, 22, 155, 150, 155, 42, 155, 128, 161, 0, 0, 0, 128, 0,
	128, 170, 134, 0, 0, 0, 128, 13, 129, 134, 131, 129, 136, 128, 142, 128, 146, 129, 148, 134, 149,
	141, 149, 170, 155, 0, 0, 0, 128, 0, 128, 170, 153, 42, 135, 151, 128, 151, 135, 23, 154, 128, 160, 0,
	0, 0, 128, 42, 128, 128, 149, 128, 155, 0, 0, 0, 128, 0, 128, 170, 146, 128, 164, 171, 164, 128,
	170, 0, 0, 0, 128, 0, 128, 170, 156, 128, 156, 170, 162, 0, 0, 0, 137, 0, 131, 129, 129, 134, 128, 142,
	128, 156, 129, 165, 131, 169, 137, 170, 148, 170, 154, 169, 157, 164, 158, 156, 158, 142, 157, 134,
	154, 129, 148, 128, 137, 128, 164, 0, 0, 0, 128, 0, 128, 170, 149, 170, 153, 168, 154, 163, 154, 153,
	153, 149, 149, 146, 128, 146, 160, 0, 0, 0, 137, 0, 131, 129, 129, 134, 128, 142, 128, 156, 129, 165,
	131, 169, 137, 170, 148, 170, 154, 169, 157, 165, 158, 156, 158, 142, 157, 134, 154, 129, 148, 128,
	137, 128, 146, 17, 161, 129, 167, 0, 0, 0, 128, 0, 128, 170, 149, 170, 153, 167, 153, 163, 153, 153,
	153, 149, 149, 146, 128, 146, 149, 18, 153, 144, 153, 139, 153, 128, 159, 0, 0, 0, 128, 7, 129, 131,
	132, 128, 149, 128, 153, 131, 153, 135, 153, 142, 153, 146, 149, 149, 131, 151, 129, 154, 128, 158,
	128, 163, 129, 167, 132, 170, 148, 170, 152, 167, 153, 163, 160, 0, 0, 0, 128, 42, 153, 170, 141, 42,
	141, 128, 159, 0, 0, 0, 128, 42, 128, 141, 129, 134, 131, 129, 136, 128, 147, 128, 152, 129, 154,
	134, 155, 141, 155, 170, 161, 0, 0, 0, 128, 42, 142, 128, 157, 170, 163, 0, 0, 0, 128, 42, 140, 128,
	152, 170, 164, 128, 176, 170, 181, 0, 0, 0, 128, 0, 156, 170, 129, 42, 157, 128, 163, 0, 0, 0, 128, 42,
	142, 146, 157, 170, 142, 18, 142, 128, 163, 0, 0, 0, 129, 42, 154, 170, 128, 128, 155, 128, 161, 0, 0,
	0, 136, 47, 128, 175, 128, 253, 136, 253, 142, 0, 0, 0, 128, 42, 141, 253, 147, 0, 0, 0, 128, 47,
	136, 175, 136, 253, 128, 253, 142, 0, 0, 0, 132, 31, 139, 167, 146, 159, 152, 0, 0, 0, 128, 126, 154,
	254, 160, 0, 0, 0, 128, 47, 140, 166, 150, 0, 0, 0, 128, 24, 130, 156, 133, 158, 142, 158, 146, 156,
	148, 152, 148, 128, 148, 13, 146, 143, 143, 145, 132, 145, 130, 143, 128, 141, 128, 132, 130, 129,
	132, 128, 143, 128, 146, 129, 148, 132, 154, 0, 0, 0, 128, 0, 128, 170, 128, 21, 130, 155, 133, 158,
	144, 158, 148, 155, 149, 148, 149, 138, 148, 131, 144, 128, 133, 128, 130, 131, 128, 136, 155, 0, 0,
	0, 148, 21, 147, 155, 143, 158, 133, 158, 130, 155, 128, 148, 128, 138, 130, 131, 133, 128, 143,
	128, 147, 131, 148, 136, 154, 0, 0, 0, 149, 21, 148, 155, 144, 158, 133, 158, 130, 155, 128, 148,
	128, 138, 130, 131, 133, 128, 144, 128, 148, 131, 149, 136, 149, 42, 149, 128, 155, 0, 0, 0, 128, 16,
	149, 144, 149, 148, 148, 155, 144, 158, 133, 158, 130, 155, 128, 148, 128, 138, 130, 131, 133, 128,
	145, 128, 148, 132, 155, 0, 0, 0, 133, 0, 133, 165, 135, 169, 139, 170, 142, 170, 128, 27, 143, 155,
	149, 0, 0, 0, 129, 121, 133, 246, 144, 246, 147, 249, 149, 254, 149, 158, 149, 21, 147, 155, 144,
	158, 133, 158, 130, 155, 128, 148, 128, 139, 130, 132, 133, 129, 144, 129, 148, 132, 149, 138, 155,
	0, 0, 0, 128, 0, 128, 170, 128, 21, 130, 155, 133, 158, 142, 158, 146, 155, 148, 149, 148, 128,
	154, 0, 0, 0, 128, 0, 128, 158, 128, 38, 128, 170, 134, 0, 0, 0, 128, 118, 131, 247, 133, 251, 133,
	158, 133, 38, 133, 170, 139, 0, 0, 0, 128, 0, 128, 170, 128, 16, 132, 144, 145, 158, 132, 16, 146,
	128, 152, 0, 0, 0, 128, 0, 128, 170, 134, 0, 0, 0, 128, 0, 128, 158, 128, 21, 130, 155, 133, 158, 140,
	158, 143, 155, 145, 149, 145, 128, 145, 21, 147, 155, 150, 158, 157, 158, 160, 155, 162, 149, 162,
	128, 168, 0, 0, 0, 128, 0, 128, 158, 128, 21, 130, 155, 133, 158, 143, 158, 147, 155, 148, 149, 148,
	128, 154, 0, 0, 0, 133, 0, 130, 131, 128, 138, 128, 149, 130, 155, 133, 158, 144, 158, 148, 155, 149,
	148, 149, 138, 148, 131, 144, 128, 133, 128, 155, 0, 0, 0, 128, 118, 128, 158, 128, 21, 130, 155,
	133, 158, 144, 158, 147, 155, 149, 148, 149, 138, 148, 131, 144, 128, 133, 128, 130, 131, 128, 137,
	155, 0, 0, 0, 149, 21, 148, 155, 144, 158, 133, 158, 130, 155, 128, 148, 128, 138, 130, 131, 133,
	128, 144, 128, 148, 131, 149, 136, 149, 30, 149, 246, 155, 0, 0, 0, 128, 0, 128, 158, 128, 21, 131,
	155, 134, 158, 140, 158, 143, 155, 145, 148, 151, 0, 0, 0, 128, 6, 130, 129, 133, 128, 143, 128, 147,
	129, 148, 132, 148, 139, 147, 142, 143, 144, 133, 144, 130, 145, 128, 148, 128, 153, 130, 156, 133,
	158, 143, 158, 147, 156, 148, 152, 154, 0, 0, 0, 128, 30, 147, 158, 133, 38, 133, 134, 135, 129, 139,
	128, 142, 128, 146, 129, 148, 134, 148, 139, 154, 0, 0, 0, 128, 30, 128, 137, 130, 131, 133, 128,
	142, 128, 146, 131, 148, 136, 148, 30, 148, 128, 154, 0, 0, 0, 128, 30, 139, 128, 150, 158, 156, 0, 0,
	0, 128, 30, 136, 128, 143, 158, 151, 128, 159, 158, 165, 0, 0, 0, 128, 0, 148, 158, 129, 30, 149,
	128, 155, 0, 0, 0, 128, 30, 138, 128, 148, 158, 138, 0, 136, 250, 133, 246, 131, 246, 154, 0, 0, 0,
	129, 30, 147, 158, 128, 128, 147, 128, 153, 0, 0, 0, 136, 39, 131, 165, 131, 149, 128, 146, 130, 143,
	130, 128, 136, 254, 142, 0, 0, 0, 128, 126, 128, 168, 135, 0, 0, 0, 128, 40, 133, 165, 133, 149, 136,
	146, 133, 144, 133, 128, 128, 254, 142, 0, 0, 0, 129, 34, 135, 165, 144, 161, 152, 165, 159, 0, 0, 0,
	149, 0, 149, 145, 138, 163, 128, 145, 128, 128, 149, 128, 154, 0, 0, 0, 156, 33, 155, 167, 153, 171,
	148, 172, 136, 172, 131, 171, 129, 166, 128, 158, 128, 144, 129, 135, 131, 131, 136, 130, 148, 130,
	153, 131, 155, 136, 156, 141, 138, 2, 138, 129, 140, 128, 144, 255, 146, 253, 146, 248, 144, 246,
	131, 246, 129, 248, 129, 252, 162, 0, 0, 0, 128, 30, 128, 137, 130, 131, 133, 128, 142, 128, 146,
	131, 148, 136, 148, 30, 148, 128, 134, 38, 136, 166, 136, 162, 134, 162, 134, 166, 142, 38, 144,
	166, 144, 162, 142, 162, 142, 166, 154, 0, 0, 0, 128, 16, 149, 144, 149, 148, 148, 155, 144, 158,
	133, 158, 130, 155, 128, 148, 128, 138, 130, 131, 133, 128, 145, 128, 148, 132, 143, 41, 141, 169,
	141, 173, 143, 173, 143, 169, 140, 164, 135, 162, 155, 0, 0, 0, 128, 24, 130, 156, 133, 158, 142,
	158, 146, 156, 148, 152, 148, 128, 148, 13, 146, 143, 143, 145, 132, 145, 128, 141, 128, 132, 130,
	129, 132, 128, 143, 128, 146, 129, 148, 132, 131, 34, 138, 170, 145, 162, 154, 0, 0, 0, 128, 24, 130,
	156, 133, 158, 142, 158, 146, 156, 148, 152, 148, 128, 148, 13, 146, 143, 143, 145, 132, 145, 128,
	141, 128, 132, 130, 129, 132, 128, 143, 128, 146, 129, 148, 132, 135, 34, 133, 162, 133, 166, 135,
	166, 135, 162, 143, 34, 141, 162, 141, 166, 143, 166, 143, 162, 154, 0, 0, 0, 128, 24, 130, 156, 133,
	158, 142, 158, 146, 156, 148, 152, 148, 128, 148, 13, 146, 143, 143, 145, 132, 145, 128, 141, 128,
	132, 130, 129, 132, 128, 143, 128, 146, 129, 148, 132, 131, 41, 133, 169, 133, 173, 131, 173, 131,
	169, 134, 164, 139, 162, 154, 0, 0, 0, 128, 24, 130, 156, 133, 158, 142, 158, 146, 156, 148, 152,
	148, 128, 148, 13, 146, 143, 143, 145, 132, 145, 128, 141, 128, 132, 130, 129, 132, 128, 143, 128,
	146, 129, 148, 132, 135, 40, 140, 168, 143, 165, 140, 162, 135, 162, 132, 165, 135, 168, 137, 38,
	136, 165, 137, 164, 138, 165, 137, 166, 154, 0, 0, 0, 148, 14, 144, 139, 133, 139, 130, 142, 128,
	149, 130, 155, 133, 158, 144, 158, 148, 155, 138, 11, 138, 137, 140, 136, 144, 135, 146, 133, 146,
	128, 144, 254, 131, 254, 129, 128, 129, 132, 154, 0, 0, 0, 128, 16, 149, 144, 149, 148, 148, 155,
	144, 158, 133, 158, 130, 155, 128, 148, 128, 138, 130, 131, 133, 128, 145, 128, 148, 132, 132, 34,
	139, 170, 146, 162, 155, 0, 0, 0, 128, 16, 149, 144, 149, 148, 148, 155, 144, 158, 133, 158, 130,
	155, 128, 148, 128, 138, 130, 131, 133, 128, 145, 128, 148, 132, 136, 34, 134, 162, 134, 166, 136,
	166, 136, 162, 144, 34, 142, 162, 142, 166, 144, 166, 144, 162, 155, 0, 0, 0, 128, 16, 149, 144, 149,
	148, 148, 155, 144, 158, 133, 158, 130, 155, 128, 148, 128, 138, 130, 131, 133, 128, 145, 128, 148,
	132, 131, 41, 133, 169, 133, 173, 131, 173, 131, 169, 134, 164, 139, 162, 155, 0, 0, 0, 133, 0, 133,
	158, 130, 34, 128, 162, 128, 166, 130, 166, 130, 162, 138, 34, 136, 162, 136, 166, 138, 166, 138,
	162, 140, 0, 0, 0, 136, 0, 136, 158, 129, 34, 136, 170, 143, 162, 147, 0, 0, 0, 136, 0, 136, 158, 128,
	41, 130, 169, 130, 173, 128, 173, 128, 169, 131, 164, 136, 162, 144, 0, 0, 0, 128, 0, 143, 170, 159,
	128, 154, 11, 132, 139, 140, 46, 138, 174, 138, 178, 140, 178, 140, 174, 148, 46, 146, 174, 146,
	178, 148, 178, 148, 174, 165, 0, 0, 0, 128, 0, 143, 170, 159, 128, 154, 11, 132, 139, 144, 49, 143,
	178, 142, 177, 143, 176, 144, 177, 142, 47, 140, 177, 142, 179, 144, 179, 146, 177, 144, 175, 142,
	175, 165, 0, 0, 0, 152, 0, 128, 128, 128, 158, 152, 158, 128, 15, 152, 143, 144, 41, 142, 169, 142,
	173, 144, 173, 144, 169, 141, 164, 136, 162, 158, 0, 0, 0, 128, 24, 130, 156, 133, 158, 142, 158,
	146, 156, 148, 152, 148, 128, 148, 13, 146, 143, 143, 145, 132, 145, 128, 141, 128, 132, 130, 129,
	132, 128, 143, 128, 146, 129, 148, 132, 148, 20, 150, 155, 153, 158, 164, 158, 168, 155, 169, 148,
	169, 144, 148, 144, 148, 10, 150, 131, 153, 128, 165, 128, 168, 132, 176, 0, 0, 0, 128, 0, 143, 170,
	155, 170, 154, 42, 170, 170, 146, 41, 146, 128, 170, 128, 146, 22, 169, 150, 132, 11, 146, 139, 177,
	0, 0, 0, 133, 0, 130, 131, 128, 138, 128, 149, 130, 155, 133, 158, 144, 158, 148, 155, 149, 148,
	149, 138, 148, 131, 144, 128, 133, 128, 132, 34, 139, 170, 146, 162, 155, 0, 0, 0, 133, 0, 130, 131,
	128, 138, 128, 149, 130, 155, 133, 158, 144, 158, 148, 155, 149, 148, 149, 138, 148, 131, 144, 128,
	133, 128, 136, 35, 134, 163, 134, 167, 136, 167, 136, 163, 144, 35, 142, 163, 142, 167, 144, 167,
	144, 163, 155, 0, 0, 0, 133, 0, 130, 131, 128, 138, 128, 149, 130, 155, 133, 158, 144, 158, 148, 155,
	149, 148, 149, 138, 148, 131, 144, 128, 133, 128, 133, 41, 135, 169, 135, 173, 133, 173, 133, 169,
	136, 164, 141, 162, 155, 0, 0, 0, 128, 30, 128, 137, 130, 131, 133, 128, 142, 128, 146, 131, 148,
	136, 148, 30, 148, 128, 131, 34, 138, 170, 145, 162, 154, 0, 0, 0, 128, 30, 128, 137, 130, 131, 133,
	128, 142, 128, 146, 131, 148, 136, 148, 30, 148, 128, 130, 41, 132, 169, 132, 173, 130, 173, 130,
	169, 133, 164, 138, 162, 155, 125, 155, 253, 154, 0, 0, 0, 128, 30, 138, 128, 148, 158, 138, 0, 136,
	250, 133, 246, 131, 246, 135, 34, 133, 162, 133, 166, 135, 166, 135, 162, 143, 34, 141, 162, 141,
	166, 143, 166, 143, 162, 154, 0, 0, 0, 137, 0, 131, 129, 129, 134, 128, 142, 128, 156, 129, 165, 131,
	169, 137, 170, 148, 170, 154, 169, 157, 164, 158, 156, 158, 142, 157, 134, 154, 129, 148, 128, 137,
	128, 140, 47, 138, 175, 138, 179, 140, 179, 140, 175, 148, 47, 146, 175, 146, 179, 148, 179, 148,
	175, 164, 0, 0, 0, 128, 42, 128, 141, 129, 134, 131, 129, 136, 128, 147, 128, 152, 129, 154, 134,
	155, 141, 155, 170, 138, 50, 140, 178, 140, 174, 138, 174, 138, 178, 146, 50, 148, 178, 148, 174,
	146, 174, 146, 178, 161, 0, 0, 0, 133, 0, 130, 131, 128, 138, 128, 149, 130, 155, 133, 158, 144, 158,
	148, 155, 149, 148, 149, 138, 148, 131, 144, 128, 133, 128, 145, 38, 132, 249, 155, 0, 0, 0, 152, 41,
	150, 170, 146, 171, 143, 171, 139, 170, 136, 169, 134, 167, 132, 161, 132, 128, 149, 128, 153, 129,
	154, 132, 128, 23, 140, 151, 165, 0, 0, 0, 137, 0, 131, 129, 129, 134, 128, 142, 128, 156, 129, 165,
	131, 169, 137, 170, 148, 170, 154, 169, 157, 164, 158, 156, 158, 142, 157, 134, 154, 129, 148, 128,
	137, 128, 135, 250, 151, 48, 150, 172, 137, 255, 164, 0, 0, 0, 128, 20, 149, 148, 153, 151, 154, 155,
	154, 165, 153, 170, 149, 172, 128, 172, 128, 128, 153, 21, 153, 132, 154, 129, 155, 128, 159, 128,
	160, 129, 161, 132, 161, 134, 149, 16, 161, 144, 165, 0, 0, 0, 169, 38, 167, 167, 163, 168, 160, 168,
	153, 166, 151, 164, 149, 158, 149, 133, 147, 255, 145, 253, 138, 251, 135, 251, 131, 252, 129, 253,
	145, 19, 157, 147, 171, 0, 0, 0, 128, 24, 130, 156, 133, 158, 142, 158, 146, 156, 148, 152, 148, 128,
	148, 13, 146, 143, 143, 145, 132, 145, 128, 141, 128, 132, 130, 129, 132, 128, 143, 128, 146, 129,
	148, 132, 142, 41, 140, 169, 140, 173, 142, 173, 142, 169, 139, 164, 134, 162, 154, 0, 0, 0, 128, 0,
	128, 158, 136, 41, 134, 169, 134, 173, 136, 173, 136, 169, 133, 164, 128, 162, 140, 0, 0, 0, 133, 0,
	130, 131, 128, 138, 128, 149, 130, 155, 133, 158, 144, 158, 148, 155, 149, 148, 149, 138, 148, 131,
	144, 128, 133, 128, 145, 41, 143, 169, 143, 173, 145, 173, 145, 169, 142, 164, 137, 162, 155, 0, 0,
	0, 128, 30, 128, 137, 130, 131, 133, 128, 142, 128, 146, 131, 148, 136, 148, 30, 148, 128, 143,
	41, 141, 169, 141, 173, 143, 173, 143, 169, 140, 164, 135, 162, 154, 0, 0, 0, 128, 0, 128, 158, 128,
	21, 130, 155, 133, 158, 143, 158, 147, 155, 148, 149, 148, 128, 128, 35, 134, 166, 143, 162, 151,
	166, 159, 0, 0, 0, 128, 0, 128, 170, 156, 128, 156, 170, 130, 44, 136, 175, 145, 171, 153, 175, 162,
	0, 0, 0, 128, 37, 130, 169, 133, 171, 142, 171, 146, 169, 148, 165, 148, 141, 148, 26, 146, 156,
	143, 158, 132, 158, 128, 154, 128, 145, 130, 142, 132, 141, 143, 141, 146, 142, 148, 145, 128, 0,
	149, 128, 154, 0, 0, 0, 133, 23, 130, 154, 128, 161, 128, 162, 130, 168, 133, 171, 144, 171, 148,
	168, 149, 161, 148, 154, 144, 151, 133, 151, 128, 0, 149, 128, 155, 0, 0, 0, 152, 14, 152, 135, 151,
	131, 147, 128, 132, 128, 129, 131, 128, 135, 128, 142, 129, 146, 132, 149, 139, 150, 141, 153, 141,
	156, 140, 42, 140, 166, 141, 166, 141, 170, 140, 170, 158, 0, 0, 0, 128, 0, 128, 149, 148, 149, 154,
	0, 0, 0, 148, 0, 148, 149, 128, 149, 154, 0, 0, 0, 148, 17, 148, 147, 150, 150, 156, 150, 159, 147,
	159, 140, 157, 139, 152, 138, 150, 137, 148, 135, 146, 128, 159, 128, 159, 43, 128, 128, 129, 34,
	135, 171, 135, 149, 165, 0, 0, 0, 159, 43, 159, 171, 128, 128, 129, 34, 135, 171, 135, 149, 159, 6,
	142, 134, 144, 136, 156, 150, 156, 128, 165, 0, 0, 0, 129, 0, 129, 156, 130, 42, 130, 166, 128, 166,
	128, 170, 130, 170, 136, 0, 0, 0, 140, 35, 128, 150, 140, 136, 153, 35, 141, 150, 153, 136, 160, 35,
	160, 163, 157, 0, 0, 0, 141, 35, 153, 150, 141, 136, 128, 35, 140, 150, 128, 136, 157, 0, 0, 0, 128,
	34, 128, 165, 131, 165, 131, 162, 128, 162, 130, 37, 130, 162, 129, 37, 129, 162, 128, 24, 128,
	149, 131, 149, 131, 152, 128, 152, 129, 24, 129, 149, 130, 24, 130, 149, 128, 11, 131, 139, 131,
	136, 128, 136, 128, 139, 130, 11, 130, 136, 129, 11, 129, 136, 128, 126, 131, 254, 131, 251, 128,
	251, 128, 254, 129, 126, 129, 251, 130, 126, 130, 251, 135, 40, 135, 171, 138, 171, 138, 168, 135,
	168, 137, 43, 137, 168, 136, 43, 136, 168, 135, 30, 135, 155, 138, 155, 138, 158, 135, 158, 136, 30,
	136, 155, 137, 30, 137, 155, 135, 17, 138, 145, 138, 142, 135, 142, 135, 145, 137, 17, 137, 142,
	136, 17, 136, 142, 135, 4, 138, 132, 138, 129, 135, 129, 135, 132, 136, 4, 136, 129, 137, 4, 137,
	129, 143, 34, 143, 165, 146, 165, 146, 162, 143, 162, 145, 37, 145, 162, 144, 37, 144, 162, 143, 24,
	143, 149, 146, 149, 146, 152, 143, 152, 144, 24, 144, 149, 145, 24, 145, 149, 143, 11, 146, 139,
	146, 136, 143, 136, 143, 139, 145, 11, 145, 136, 144, 11, 144, 136, 143, 126, 146, 254, 146, 251,
	143, 251, 143, 254, 144, 126, 144, 251, 145, 126, 145, 251, 150, 40, 150, 171, 153, 171, 153, 168,
	150, 168, 152, 43, 152, 168, 151, 43, 151, 168, 150, 30, 150, 155, 153, 155, 153, 158, 150, 158,
	151, 30, 151, 155, 152, 30, 152, 155, 150, 17, 153, 145, 153, 142, 150, 142, 150, 145, 152, 17, 152,
	142, 151, 17, 151, 142, 150, 4, 153, 132, 153, 129, 150, 129, 150, 132, 151, 4, 151, 129, 152, 4,
	152, 129, 153, 0, 0, 0, 128, 34, 128, 165, 131, 165, 131, 162, 128, 162, 130, 37, 130, 162, 129, 37,
	129, 162, 128, 24, 128, 149, 131, 149, 131, 152, 128, 152, 129, 24, 129, 149, 130, 24, 130, 149,
	128, 11, 131, 139, 131, 136, 128, 136, 128, 139, 130, 11, 130, 136, 129, 11, 129, 136, 128, 126,
	131, 254, 131, 251, 128, 251, 128, 254, 129, 126, 129, 251, 130, 126, 130, 251, 131, 40, 131, 171,
	134, 171, 134, 168, 131, 168, 133, 43, 133, 168, 132, 43, 132, 168, 131, 30, 131, 155, 134, 155,
	134, 158, 131, 158, 132, 30, 132, 155, 133, 30, 133, 155, 131, 17, 134, 145, 134, 142, 131, 142,
	131, 145, 133, 17, 133, 142, 132, 17, 132, 142, 131, 4, 134, 132, 134, 129, 131, 129, 131, 132, 132,
	4, 132, 129, 133, 4, 133, 129, 134, 34, 134, 165, 137, 165, 137, 162, 134, 162, 136, 37, 136, 162,
	135, 37, 135, 162, 134, 24, 134, 149, 137, 149, 137, 152, 134, 152, 135, 24, 135, 149, 136, 24, 136,
	149, 134, 11, 137, 139, 137, 136, 134, 136, 134, 139, 136, 11, 136, 136, 135, 11, 135, 136, 134,
	126, 137, 254, 137, 251, 134, 251, 134, 254, 135, 126, 135, 251, 136, 126, 136, 251, 137, 40, 137,
	171, 140, 171, 140, 168, 137, 168, 139, 43, 139, 168, 138, 43, 138, 168, 137, 30, 137, 155, 140,
	155, 140, 158, 137, 158, 138, 30, 138, 155, 139, 30, 139, 155, 137, 17, 140, 145, 140, 142, 137,
	142, 137, 145, 139, 17, 139, 142, 138, 17, 138, 142, 137, 4, 140, 132, 140, 129, 137, 129, 137, 132,
	138, 4, 138, 129, 139, 4, 139, 129, 140, 34, 140, 165, 143, 165, 143, 162, 140, 162, 142, 37, 142,
	162, 141, 37, 141, 162, 140, 24, 140, 149, 143, 149, 143, 152, 140, 152, 141, 24, 141, 149, 142, 24,
	142, 149, 140, 11, 143, 139, 143, 136, 140, 136, 140, 139, 142, 11, 142, 136, 141, 11, 141, 136,
	140, 126, 143, 254, 143, 251, 140, 251, 140, 254, 141, 126, 141, 251, 142, 126, 142, 251, 143, 40,
	143, 171, 146, 171, 146, 168, 143, 168, 145, 43, 145, 168, 144, 43, 144, 168, 143, 30, 143, 155,
	146, 155, 146, 158, 143, 158, 144, 30, 144, 155, 145, 30, 145, 155, 143, 17, 146, 145, 146, 142,
	143, 142, 143, 145, 145, 17, 145, 142, 144, 17, 144, 142, 143, 4, 146, 132, 146, 129, 143, 129, 143,
	132, 144, 4, 144, 129, 145, 4, 145, 129, 146, 34, 146, 165, 149, 165, 149, 162, 146, 162, 148, 37,
	148, 162, 147, 37, 147, 162, 146, 24, 146, 149, 149, 149, 149, 152, 146, 152, 147, 24, 147, 149,
	148, 24, 148, 149, 146, 11, 149, 139, 149, 136, 146, 136, 146, 139, 148, 11, 148, 136, 147, 11, 147,
	136, 146, 126, 149, 254, 149, 251, 146, 251, 146, 254, 147, 126, 147, 251, 148, 126, 148, 251, 149,
	40, 149, 171, 152, 171, 152, 168, 149, 168, 151, 43, 151, 168, 150, 43, 150, 168, 149, 30, 149,
	155, 152, 155, 152, 158, 149, 158, 150, 30, 150, 155, 151, 30, 151, 155, 149, 17, 152, 145, 152,
	142, 149, 142, 149, 145, 151, 17, 151, 142, 150, 17, 150, 142, 149, 4, 152, 132, 152, 129, 149, 129,
	149, 132, 150, 4, 150, 129, 151, 4, 151, 129, 152, 0, 0, 0, 128, 39, 128, 170, 131, 170, 131, 167,
	128, 167, 130, 42, 130, 167, 129, 42, 129, 167, 131, 39, 131, 170, 134, 170, 134, 167, 131, 167,
	133, 42, 133, 167, 132, 42, 132, 167, 134, 36, 137, 164, 137, 161, 134, 161, 134, 164, 136, 36, 136,
	161, 135, 36, 135, 161, 134, 30, 134, 155, 128, 155, 128, 158, 134, 158, 130, 30, 130, 155, 129, 30,
	129, 155, 133, 30, 133, 155, 132, 30, 132, 155, 131, 30, 131, 155, 128, 3, 128, 134, 131, 134, 131,
	131, 128, 131, 130, 6, 130, 131, 129, 6, 129, 131, 137, 33, 137, 164, 140, 164, 140, 161, 137, 161,
	139, 36, 139, 161, 138, 36, 138, 161, 143, 39, 143, 170, 146, 170, 146, 167, 143, 167, 145, 42, 145,
	167, 144, 42, 144, 167, 146, 39, 146, 170, 149, 170, 149, 167, 146, 167, 148, 42, 148, 167, 147, 42,
	147, 167, 140, 33, 140, 164, 143, 164, 143, 161, 140, 161, 142, 36, 142, 161, 141, 36, 141, 161,
	128, 24, 131, 152, 131, 149, 128, 149, 128, 152, 130, 24, 130, 149, 129, 24, 129, 149, 131, 21, 131,
	152, 134, 152, 134, 149, 131, 149, 133, 24, 133, 149, 132, 24, 132, 149, 134, 21, 134, 152, 137,
	152, 137, 149, 134, 149, 136, 24, 136, 149, 135, 24, 135, 149, 128, 15, 128, 146, 131, 146, 131,
	143, 128, 143, 130, 18, 130, 143, 129, 18, 129, 143, 134, 12, 137, 140, 137, 137, 134, 137, 134,
	140, 136, 12, 136, 137, 135, 12, 135, 137, 137, 9, 137, 140, 140, 140, 140, 137, 137, 137, 139, 12,
	139, 137, 138, 12, 138, 137, 140, 9, 140, 140, 143, 140, 143, 137, 140, 137, 142, 12, 142, 137, 141,
	12, 141, 137, 128, 0, 131, 128, 131, 253, 128, 253, 128, 128, 130, 0, 130, 253, 129, 0, 129, 253,
	131, 125, 131, 128, 134, 128, 134, 253, 131, 253, 133, 0, 133, 253, 132, 0, 132, 253, 134, 125, 134,
	128, 137, 128, 137, 253, 134, 253, 136, 0, 136, 253, 135, 0, 135, 253, 131, 15, 131, 146, 134, 146,
	134, 143, 131, 143, 133, 18, 133, 143, 132, 18, 132, 143, 131, 3, 131, 134, 134, 134, 134, 131, 131,
	131, 133, 6, 133, 131, 132, 6, 132, 131, 149, 30, 149, 155, 143, 155, 143, 158, 149, 158, 145, 30,
	145, 155, 144, 30, 144, 155, 148, 30, 148, 155, 147, 30, 147, 155, 146, 30, 146, 155, 149, 18, 149,
	143, 143, 143, 143, 146, 149, 146, 145, 18, 145, 143, 144, 18, 144, 143, 148, 18, 148, 143, 147, 18,
	147, 143, 146, 18, 146, 143, 149, 6, 149, 131, 143, 131, 143, 134, 149, 134, 145, 6, 145, 131, 144,
	6, 144, 131, 148, 6, 148, 131, 147, 6, 147, 131, 146, 6, 146, 131, 158, 41, 158, 168, 164, 42, 164,
	167, 158, 167, 158, 170, 164, 170, 160, 42, 160, 167, 159, 42, 159, 167, 163, 42, 163, 167, 162, 42,
	162, 167, 161, 42, 161, 167, 155, 36, 158, 164, 158, 161, 155, 161, 155, 164, 157, 36, 157, 161,
	156, 36, 156, 161, 158, 33, 158, 164, 161, 164, 161, 161, 158, 161, 160, 36, 160, 161, 159, 36, 159,
	161, 161, 33, 161, 164, 164, 164, 164, 161, 161, 161, 163, 36, 163, 161, 162, 36, 162, 161, 164, 30,
	164, 155, 158, 155, 158, 158, 164, 158, 160, 30, 160, 155, 159, 30, 159, 155, 163, 30, 163, 155,
	162, 30, 162, 155, 161, 30, 161, 155, 164, 18, 164, 143, 158, 143, 158, 146, 164, 146, 160, 18, 160,
	143, 159, 18, 159, 143, 163, 18, 163, 143, 162, 18, 162, 143, 161, 18, 161, 143, 155, 12, 158, 140,
	158, 137, 155, 137, 155, 140, 157, 12, 157, 137, 156, 12, 156, 137, 158, 9, 158, 140, 161, 140, 161,
	137, 158, 137, 160, 12, 160, 137, 159, 12, 159, 137, 161, 9, 161, 140, 164, 140, 164, 137, 161, 137,
	163, 12, 163, 137, 162, 12, 162, 137, 164, 6, 164, 131, 158, 131, 158, 134, 164, 134, 160, 6, 160,
	131, 159, 6, 159, 131, 163, 6, 163, 131, 162, 6, 162, 131, 161, 6, 161, 131, 149, 24, 152, 152, 152,
	149, 149, 149, 149, 152, 151, 24, 151, 149, 150, 24, 150, 149, 152, 21, 152, 152, 155, 152, 155,
	149, 152, 149, 154, 24, 154, 149, 153, 24, 153, 149, 155, 21, 155, 152, 158, 152, 158, 149, 155,
	149, 157, 24, 157, 149, 156, 24, 156, 149, 149, 0, 152, 128, 152, 253, 149, 253, 149, 128, 151, 0,
	151, 253, 150, 0, 150, 253, 152, 125, 152, 128, 155, 128, 155, 253, 152, 253, 154, 0, 154, 253, 153,
	0, 153, 253, 155, 125, 155, 128, 158, 128, 158, 253, 155, 253, 157, 0, 157, 253, 156, 0, 156, 253,
	164, 127, 164, 0, 0, 0, 143, 43, 143, 254, 149, 0, 0, 0, 128, 17, 143, 145, 143, 43, 143, 254, 149, 0,
	0, 0, 128, 24, 143, 152, 143, 126, 143, 171, 128, 17, 143, 145, 148, 0, 0, 0, 128, 17, 143, 145,
	143, 43, 143, 254, 159, 43, 159, 254, 164, 0, 0, 0, 128, 17, 159, 145, 159, 254, 143, 17, 143, 254,
	128, 127, 255, 255, 164, 0, 0, 0, 128, 17, 143, 145, 143, 254, 128, 24, 143, 152, 143, 145, 128, 127,
	128, 255, 148, 0, 0, 0, 143, 43, 143, 152, 128, 152, 128, 17, 143, 145, 143, 254, 159, 43, 159, 254,
	164, 0, 0, 0, 143, 43, 143, 254, 159, 43, 159, 254, 164, 0, 0, 0, 128, 17, 143, 145, 143, 254, 128, 24,
	159, 152, 159, 254, 164, 0, 0, 0, 143, 43, 143, 152, 128, 152, 159, 43, 159, 145, 128, 145, 164, 0, 0,
	0, 128, 24, 159, 152, 159, 171, 143, 24, 143, 171, 164, 0, 0, 0, 128, 24, 143, 152, 143, 171, 128,
	17, 143, 145, 143, 152, 255, 127, 255, 255, 148, 0, 0, 0, 128, 17, 143, 145, 143, 254, 149, 0, 0, 0,
	143, 24, 128, 152, 128, 171, 143, 0, 0, 0, 128, 24, 158, 152, 143, 24, 143, 171, 158, 0, 0, 0, 128, 17,
	158, 145, 143, 17, 143, 254, 158, 0, 0, 0, 143, 17, 128, 145, 128, 43, 128, 254, 128, 127, 255, 255,
	143, 0, 0, 0, 128, 17, 159, 145, 159, 0, 0, 0, 128, 17, 158, 145, 143, 43, 143, 254, 158, 0, 0, 0, 143,
	24, 128, 152, 128, 126, 128, 171, 143, 17, 128, 145, 143, 0, 0, 0, 159, 17, 144, 145, 144, 43, 144,
	254, 128, 43, 128, 254, 159, 0, 0, 0, 159, 24, 144, 152, 144, 171, 159, 17, 128, 145, 128, 171, 159,
	0, 0, 0, 159, 17, 144, 145, 144, 254, 159, 24, 128, 152, 128, 254, 159, 0, 0, 0, 128, 24, 143, 152,
	143, 171, 128, 17, 174, 145, 174, 24, 159, 152, 159, 171, 174, 0, 0, 0, 128, 17, 143, 145, 143, 254,
	128, 24, 174, 152, 174, 17, 159, 145, 159, 254, 174, 0, 0, 0, 144, 43, 144, 152, 159, 152, 159, 17,
	144, 145, 144, 254, 128, 43, 128, 254, 128, 127, 129, 255, 159, 0, 0, 0, 128, 17, 159, 145, 128, 24,
	159, 152, 159, 0, 0, 0, 143, 43, 143, 152, 128, 152, 128, 17, 143, 145, 143, 254, 159, 43, 159, 152,
	174, 152, 174, 17, 159, 145, 159, 254, 174, 0, 0, 0, 128, 24, 158, 152, 143, 24, 143, 171, 128, 17,
	159, 145, 159, 0, 0, 0, 159, 24, 153, 152, 153, 171, 137, 24, 137, 171, 153, 24, 128, 152, 159, 0, 0,
	0, 128, 17, 158, 145, 143, 17, 143, 254, 128, 24, 159, 152, 158, 0, 0, 0, 159, 17, 153, 145, 153,
	254, 137, 17, 137, 254, 153, 17, 128, 145, 159, 0, 0, 0, 159, 24, 128, 152, 128, 171, 144, 24, 144,
	171, 159, 0, 0, 0, 143, 24, 128, 152, 128, 171, 143, 17, 128, 145, 128, 152, 143, 0, 0, 0, 143, 17,
	128, 145, 128, 254, 143, 24, 128, 152, 128, 145, 143, 0, 0, 0, 159, 17, 128, 145, 128, 254, 144, 17,
	144, 254, 159, 0, 0, 0, 128, 17, 174, 145, 143, 43, 143, 254, 159, 43, 159, 254, 174, 0, 0, 0, 143, 43,
	143, 254, 128, 17, 159, 145, 128, 24, 159, 152, 159, 0, 0, 0, 143, 43, 143, 152, 128, 152, 148, 0, 0,
	0, 128, 126, 128, 145, 143, 145, 143, 0, 0, 0, 128, 43, 159, 171, 159, 128, 128, 128, 128, 171,
	130, 43, 130, 128, 132, 43, 132, 128, 134, 43, 134, 128, 136, 43, 136, 128, 138, 43, 138, 128, 140,
	43, 140, 128, 129, 43, 129, 128, 131, 43, 131, 128, 133, 43, 133, 128, 135, 43, 135, 128, 137, 43,
	137, 128, 139, 43, 139, 128, 141, 43, 141, 128, 146, 43, 146, 128, 148, 43, 148, 128, 150, 43, 150,
	128, 152, 43, 152, 128, 154, 43, 154, 128, 156, 43, 156, 128, 158, 43, 158, 128, 145, 43, 145, 128,
	147, 43, 147, 128, 149, 43, 149, 128, 151, 43, 151, 128, 153, 43, 153, 128, 155, 43, 155, 128, 157,
	43, 157, 128, 142, 43, 142, 128, 143, 43, 143, 128, 144, 43, 144, 128, 159, 19, 128, 147, 159, 0, 0,
	0, 159, 0, 128, 128, 128, 147, 159, 147, 159, 128, 129, 19, 129, 128, 130, 19, 130, 128, 131, 19,
	131, 128, 132, 19, 132, 128, 133, 19, 133, 128, 134, 0, 134, 147, 135, 19, 135, 128, 136, 19, 136,
	128, 137, 19, 137, 128, 138, 19, 138, 128, 139, 19, 139, 128, 140, 0, 140, 147, 141, 19, 141, 128,
	142, 19, 142, 128, 143, 19, 143, 128, 144, 19, 144, 128, 145, 19, 145, 128, 146, 0, 146, 147, 147,
	19, 147, 128, 148, 19, 148, 128, 149, 19, 149, 128, 150, 19, 150, 128, 151, 19, 151, 128, 152, 0,
	152, 147, 153, 19, 153, 128, 154, 19, 154, 128, 155, 19, 155, 128, 156, 19, 156, 128, 157, 19, 157,
	128, 158, 19, 158, 128, 159, 0, 0, 0, 128, 0, 128, 171, 143, 171, 143, 128, 128, 128, 130, 43, 130,
	128, 132, 43, 132, 128, 134, 43, 134, 128, 136, 43, 136, 128, 138, 43, 138, 128, 140, 43, 140, 128,
	129, 43, 129, 128, 131, 43, 131, 128, 133, 43, 133, 128, 135, 43, 135, 128, 137, 43, 137, 128, 139,
	43, 139, 128, 141, 43, 141, 128, 142, 43, 142, 128, 143, 0, 0, 0, 143, 0, 143, 171, 158, 171, 158,
	128, 143, 128, 145, 43, 145, 128, 147, 43, 147, 128, 149, 43, 149, 128, 151, 43, 151, 128, 153, 43,
	153, 128, 155, 43, 155, 128, 144, 43, 144, 128, 146, 43, 146, 128, 148, 43, 148, 128, 150, 43, 150,
	128, 152, 43, 152, 128, 154, 43, 154, 128, 156, 43, 156, 128, 157, 43, 157, 128, 158, 0, 0, 0, 159,
	24, 128, 152, 128, 171, 159, 171, 159, 152, 129, 43, 129, 152, 130, 43, 130, 152, 131, 43, 131,
	152, 132, 43, 132, 152, 133, 43, 133, 152, 134, 24, 134, 171, 135, 43, 135, 152, 136, 43, 136, 152,
	137, 43, 137, 152, 138, 43, 138, 152, 139, 43, 139, 152, 140, 24, 140, 171, 141, 43, 141, 152, 142,
	43, 142, 152, 143, 43, 143, 152, 144, 43, 144, 152, 145, 43, 145, 152, 146, 24, 146, 171, 147, 43,
	147, 152, 148, 43, 148, 152, 149, 43, 149, 152, 150, 43, 150, 152, 151, 43, 151, 152, 152, 24, 152,
	171, 153, 43, 153, 152, 154, 43, 154, 152, 155, 43, 155, 152, 156, 43, 156, 152, 157, 43, 157, 152,
	158, 43, 158, 152, 159, 0, 0, 0, 156, 0, 147, 155, 143, 158, 133, 158, 130, 155, 128, 148, 128, 138,
	130, 131, 133, 128, 143, 128, 147, 131, 156, 158, 161, 0, 0, 0, 128, 18, 148, 146, 151, 149, 151,
	154, 148, 156, 128, 156, 128, 247, 148, 18, 151, 143, 151, 134, 148, 132, 128, 132, 156, 0, 0, 0,
	128, 0, 128, 162, 148, 162, 148, 156, 153, 0, 0, 0, 148, 0, 148, 160, 133, 32, 133, 128, 128, 32, 153,
	160, 158, 0, 0, 0, 152, 3, 152, 128, 128, 128, 145, 150, 128, 170, 152, 170, 152, 167, 157, 0, 0, 0,
	133, 24, 144, 152, 147, 150, 149, 148, 149, 132, 147, 130, 144, 128, 133, 128, 130, 130, 128, 132,
	128, 148, 130, 150, 142, 158, 159, 158, 164, 0, 0, 0, 131, 27, 131, 139, 133, 133, 136, 130, 145,
	130, 149, 133, 151, 138, 151, 27, 151, 137, 136, 2, 136, 252, 132, 246, 135, 124, 135, 252, 156, 0,
	0, 0, 128, 27, 131, 158, 140, 158, 142, 155, 142, 253, 142, 21, 151, 158, 157, 158, 159, 157, 164,
	0, 0, 0, 128, 43, 149, 171, 139, 43, 139, 157, 149, 20, 148, 141, 144, 138, 133, 138, 130, 141,
	128, 148, 130, 154, 133, 157, 144, 157, 148, 154, 149, 147, 149, 148, 128, 124, 149, 252, 139, 124,
	139, 138, 154, 0, 0, 0, 138, 42, 149, 170, 158, 163, 159, 156, 159, 142, 158, 135, 149, 128, 138,
	128, 129, 135, 128, 142, 128, 156, 129, 163, 138, 170, 128, 21, 159, 149, 163, 0, 0, 0, 128, 0, 138,
	128, 138, 139, 136, 140, 131, 143, 128, 147, 128, 156, 129, 165, 131, 169, 137, 170, 148, 170, 154,
	169, 157, 164, 158, 156, 158, 147, 155, 143, 150, 140, 148, 139, 148, 128, 158, 128, 164, 0, 0, 0,
	133, 24, 144, 152, 147, 150, 149, 148, 149, 132, 147, 130, 144, 128, 133, 128, 130, 130, 128, 132,
	128, 148, 130, 150, 133, 152, 144, 24, 128, 171, 149, 171, 154, 0, 0, 0, 149, 10, 148, 131, 144, 128,
	133, 128, 130, 131, 128, 138, 130, 144, 133, 147, 144, 147, 148, 144, 149, 137, 149, 138, 151, 144,
	154, 147, 165, 147, 169, 144, 170, 137, 170, 138, 169, 131, 165, 128, 154, 128, 151, 131, 149, 138,
	175, 0, 0, 0, 133, 0, 130, 131, 128, 138, 128, 149, 130, 155, 133, 158, 144, 158, 148, 155, 149, 148,
	149, 138, 148, 131, 144, 128, 133, 128, 145, 38, 132, 249, 153, 0, 0, 0, 152, 42, 143, 169, 136, 167,
	130, 162, 128, 158, 128, 142, 152, 0, 143, 129, 136, 131, 130, 136, 128, 140, 128, 156, 128, 22,
	151, 150, 158, 0, 0, 0, 128, 0, 128, 157, 129, 164, 131, 169, 136, 170, 147, 170, 152, 169, 154, 164,
	155, 157, 155, 128, 161, 0, 0, 0, 128, 17, 148, 145, 128, 5, 149, 133, 128, 28, 149, 156, 154, 0, 0, 0,
	128, 0, 149, 128, 128, 27, 148, 155, 138, 43, 138, 140, 154, 0, 0, 0, 149, 0, 128, 128, 128, 43, 148,
	155, 128, 140, 154, 0, 0, 0, 128, 0, 149, 128, 149, 43, 129, 155, 149, 140, 154, 0, 0, 0, 148, 41, 146,
	170, 142, 171, 139, 171, 135, 170, 132, 169, 130, 167, 128, 161, 128, 253, 153, 0, 0, 0, 128, 127,
	130, 254, 134, 253, 137, 253, 141, 254, 144, 255, 146, 129, 148, 135, 148, 171, 153, 0, 0, 0, 139,
	39, 137, 167, 137, 171, 139, 171, 139, 167, 139, 0, 137, 128, 137, 132, 139, 132, 139, 128, 128,
	22, 149, 150, 157, 0, 0, 0, 129, 26, 135, 157, 144, 153, 152, 157, 128, 17, 134, 148, 143, 144, 151,
	148, 159, 0, 0, 0, 149, 34, 148, 155, 144, 152, 133, 152, 130, 155, 128, 162, 130, 168, 133, 171,
	144, 171, 148, 168, 149, 161, 149, 162, 155, 0, 0, 0, 130, 0, 132, 128, 132, 136, 130, 136, 130, 128,
	128, 128, 128, 136, 130, 136, 130, 132, 131, 8, 131, 128, 129, 8, 129, 128, 137, 0, 0, 0, 130, 0, 128,
	128, 128, 132, 132, 132, 132, 128, 130, 128, 130, 132, 129, 4, 129, 128, 131, 4, 131, 128, 128, 127,
	128, 255, 137, 0, 0, 0, 158, 38, 158, 171, 143, 171, 143, 128, 128, 155, 163, 0, 0, 0, 128, 24, 128,
	171, 128, 34, 130, 168, 133, 171, 143, 171, 147, 168, 148, 162, 148, 152, 153, 0, 0, 0, 129, 39, 132,
	170, 134, 171, 141, 171, 144, 169, 144, 165, 143, 163, 138, 162, 135, 161, 128, 153, 143, 153, 149,
	0, 0, 0, 128, 0, 128, 147, 143, 147, 143, 128, 128, 128, 129, 19, 129, 128, 130, 19, 130, 128, 131,
	19, 131, 128, 132, 19, 132, 128, 133, 19, 133, 128, 134, 0, 134, 147, 135, 19, 135, 128, 136, 19,
	136, 128, 137, 19, 137, 128, 138, 19, 138, 128, 139, 19, 139, 128, 140, 0, 140, 147, 141, 19, 141,
	128, 142, 19, 142, 128, 143, 0, 0, 0
};
static const unsigned char Bold[14670] = /* binary data included from BOLD.CHR */
{
	80, 75, 8, 8, 66, 71, 73, 32, 83, 116, 114, 111, 107, 101, 100, 32, 70, 111, 110, 116, 32, 86,
	49, 46, 49, 32, 45, 32, 74, 117, 110, 32, 53, 44, 32, 49, 57, 56, 57, 13, 10, 67, 111, 112, 121, 114,
	105, 103, 104, 116, 32, 40, 99, 41, 32, 49, 57, 56, 55, 44, 49, 57, 56, 56, 32, 66, 111, 114, 108, 97,
	110, 100, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 13, 10, 26, 128, 0, 66,
	79, 76, 68, 206, 56, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,
	43, 224, 0, 0, 32, 176, 2, 0, 53, 0, 249, 0, 0, 0, 0, 0, 0, 0, 4, 0, 32, 0, 58, 0, 130, 0, 236, 0, 62, 1,
	188, 1, 202, 1, 254, 1, 44, 2, 86, 2, 116, 2, 132, 2, 146, 2, 160, 2, 174, 2, 18, 3, 46, 3, 118, 3, 230, 3,
	10, 4, 94, 4, 194, 4, 214, 4, 90, 5, 200, 5, 226, 5, 254, 5, 12, 6, 38, 6, 52, 6, 124, 6, 232, 6, 6, 7, 88,
	7, 188, 7, 252, 7, 28, 8, 56, 8, 148, 8, 178, 8, 192, 8, 238, 8, 12, 9, 32, 9, 64, 9, 90, 9, 190, 9, 242,
	9, 90, 10, 152, 10, 2, 11, 26, 11, 78, 11, 98, 11, 130, 11, 160, 11, 186, 11, 212, 11, 234, 11, 248,
	11, 14, 12, 28, 12, 42, 12, 56, 12, 152, 12, 240, 12, 70, 13, 158, 13, 252, 13, 38, 14, 160, 14, 216,
	14, 240, 14, 22, 15, 52, 15, 66, 15, 146, 15, 202, 15, 42, 16, 130, 16, 218, 16, 252, 16, 90, 17, 132,
	17, 174, 17, 194, 17, 226, 17, 0, 18, 26, 18, 52, 18, 100, 18, 118, 18, 166, 18, 188, 18, 216, 18, 74,
	19, 136, 19, 242, 19, 92, 20, 210, 20, 62, 21, 190, 21, 30, 22, 134, 22, 248, 22, 98, 23, 132, 23,
	156, 23, 182, 23, 232, 23, 38, 24, 82, 24, 8, 25, 58, 25, 164, 25, 24, 26, 132, 26, 184, 26, 238, 26,
	28, 27, 148, 27, 220, 27, 68, 28, 130, 28, 232, 28, 62, 29, 136, 29, 248, 29, 18, 30, 126, 30, 180,
	30, 254, 30, 42, 31, 148, 31, 248, 31, 64, 32, 82, 32, 100, 32, 190, 32, 8, 33, 36, 33, 68, 33, 100,
	33, 148, 34, 232, 36, 76, 40, 90, 40, 112, 40, 142, 40, 174, 40, 200, 40, 226, 40, 16, 41, 40, 41, 76,
	41, 112, 41, 140, 41, 166, 41, 184, 41, 202, 41, 226, 41, 250, 41, 16, 42, 30, 42, 60, 42, 90, 42,
	122, 42, 158, 42, 194, 42, 238, 42, 26, 43, 72, 43, 96, 43, 158, 43, 194, 43, 226, 43, 6, 44, 38, 44,
	66, 44, 92, 44, 118, 44, 144, 44, 190, 44, 242, 44, 4, 45, 24, 45, 150, 45, 20, 46, 90, 46, 160, 46,
	30, 47, 124, 47, 194, 47, 218, 47, 248, 47, 52, 48, 118, 48, 168, 48, 212, 48, 62, 49, 148, 49, 242,
	49, 108, 50, 14, 51, 120, 51, 184, 51, 236, 51, 16, 52, 56, 52, 92, 52, 122, 52, 152, 52, 182, 52,
	220, 52, 4, 53, 66, 53, 80, 53, 94, 53, 122, 53, 168, 53, 212, 53, 26, 54, 21, 14, 14, 31, 27, 40, 32,
	10, 17, 17, 24, 33, 33, 33, 13, 40, 33, 33, 33, 33, 32, 33, 33, 32, 33, 33, 13, 19, 25, 29, 25, 26, 26,
	36, 32, 34, 33, 31, 28, 33, 30, 15, 28, 34, 29, 38, 32, 33, 30, 33, 30, 31, 33, 32, 34, 58, 31, 35, 33,
	22, 26, 22, 29, 29, 10, 28, 30, 29, 30, 29, 18, 29, 30, 14, 18, 30, 14, 40, 27, 29, 30, 30, 21, 27, 18,
	27, 29, 40, 31, 28, 27, 20, 13, 19, 29, 30, 34, 26, 26, 30, 28, 28, 28, 25, 26, 27, 28, 19, 20, 15, 36,
	36, 31, 48, 51, 26, 29, 28, 27, 26, 28, 33, 30, 29, 46, 33, 37, 42, 26, 11, 29, 26, 28, 31, 26, 30, 26,
	33, 34, 37, 37, 14, 25, 26, 34, 39, 37, 13, 28, 27, 38, 39, 27, 40, 28, 42, 40, 40, 26, 0, 21, 34, 34,
	21, 34, 34, 21, 34, 34, 34, 34, 34, 34, 34, 34, 34, 39, 34, 39, 34, 21, 21, 34, 33, 32, 26, 21, 36, 36,
	14, 28, 29, 33, 28, 32, 33, 36, 33, 27, 34, 29, 27, 36, 29, 47, 29, 25, 32, 27, 28, 27, 27, 43, 31, 29,
	28, 16, 10, 10, 38, 25, 21, 22, 40, 149, 0, 0, 0, 130, 10, 134, 138, 136, 160, 136, 168, 128, 168,
	128, 160, 130, 138, 129, 0, 129, 136, 135, 136, 135, 128, 129, 128, 142, 0, 0, 0, 128, 38, 129, 156,
	130, 166, 129, 168, 128, 166, 0, 128, 133, 38, 134, 156, 135, 166, 134, 168, 133, 166, 142, 0, 0, 0,
	134, 15, 142, 143, 144, 153, 136, 153, 134, 143, 133, 10, 131, 128, 128, 128, 130, 138, 128, 138,
	128, 143, 131, 143, 133, 153, 129, 153, 129, 158, 134, 158, 136, 168, 139, 168, 137, 158, 145, 158,
	147, 168, 150, 168, 148, 158, 152, 158, 152, 153, 147, 153, 145, 143, 151, 143, 151, 138, 144, 138,
	142, 128, 139, 128, 141, 138, 133, 138, 159, 0, 0, 0, 130, 24, 142, 144, 143, 142, 143, 141, 142,
	140, 140, 139, 137, 139, 135, 140, 134, 141, 134, 144, 129, 144, 129, 139, 130, 136, 131, 135, 132,
	134, 134, 133, 135, 133, 135, 128, 141, 128, 141, 133, 143, 133, 145, 134, 147, 136, 148, 139, 148,
	141, 147, 144, 145, 147, 134, 155, 134, 156, 135, 157, 137, 158, 140, 158, 142, 157, 143, 155, 143,
	153, 148, 153, 148, 157, 147, 160, 145, 162, 143, 163, 141, 163, 141, 168, 135, 168, 135, 163, 134,
	163, 132, 162, 131, 161, 130, 160, 129, 157, 129, 155, 130, 152, 155, 0, 0, 0, 138, 33, 139, 163,
	139, 166, 138, 168, 137, 169, 136, 170, 134, 170, 133, 169, 132, 168, 131, 166, 131, 163, 132, 161,
	133, 160, 134, 159, 136, 159, 138, 161, 0, 128, 158, 4, 158, 133, 157, 135, 155, 137, 153, 137, 152,
	136, 151, 135, 150, 133, 150, 131, 151, 129, 152, 255, 153, 254, 155, 254, 157, 128, 158, 130, 158,
	132, 0, 128, 157, 42, 161, 170, 132, 255, 128, 255, 157, 170, 168, 0, 0, 0, 140, 19, 140, 154, 139,
	154, 137, 154, 136, 156, 136, 159, 138, 161, 141, 161, 142, 161, 143, 160, 144, 159, 144, 158, 151,
	158, 151, 159, 150, 161, 148, 164, 146, 166, 144, 167, 141, 168, 139, 168, 136, 167, 134, 166, 132,
	164, 130, 161, 129, 159, 129, 155, 130, 153, 131, 151, 130, 150, 129, 148, 128, 145, 128, 139, 129,
	135, 130, 132, 132, 130, 135, 128, 139, 255, 142, 255, 144, 128, 147, 130, 149, 132, 150, 135, 151,
	138, 151, 141, 153, 141, 153, 147, 144, 147, 144, 141, 145, 141, 145, 138, 144, 136, 143, 135, 141,
	134, 139, 134, 137, 135, 135, 138, 135, 143, 136, 145, 137, 146, 139, 147, 140, 147, 160, 0, 0, 0,
	128, 38, 128, 156, 131, 166, 129, 168, 128, 166, 138, 0, 0, 0, 136, 0, 138, 128, 136, 128, 133, 131,
	131, 135, 129, 140, 128, 145, 128, 151, 129, 156, 131, 161, 133, 165, 136, 168, 138, 168, 136, 168,
	138, 40, 135, 165, 133, 161, 131, 156, 130, 151, 130, 145, 131, 140, 133, 135, 135, 131, 138, 128,
	145, 0, 0, 0, 130, 40, 128, 168, 131, 165, 133, 161, 135, 156, 136, 151, 136, 146, 135, 140, 133,
	135, 131, 132, 128, 128, 129, 128, 133, 132, 136, 137, 137, 140, 138, 146, 138, 151, 137, 156, 135,
	161, 133, 165, 130, 168, 145, 0, 0, 0, 135, 22, 135, 160, 137, 160, 137, 150, 144, 155, 145, 153,
	138, 148, 145, 143, 144, 141, 137, 146, 137, 136, 135, 136, 135, 146, 129, 141, 128, 143, 135, 148,
	128, 153, 129, 155, 135, 150, 152, 0, 0, 0, 135, 5, 135, 143, 128, 143, 128, 153, 135, 153, 135, 163,
	143, 163, 143, 153, 150, 153, 150, 143, 143, 143, 143, 133, 135, 133, 161, 0, 0, 0, 131, 0, 131, 135,
	136, 138, 136, 128, 128, 250, 131, 128, 161, 0, 0, 0, 128, 15, 128, 153, 150, 153, 150, 143, 128,
	143, 161, 0, 0, 0, 128, 0, 128, 136, 134, 136, 134, 128, 128, 128, 141, 0, 0, 0, 128, 127, 157, 170,
	161, 170, 132, 255, 128, 255, 168, 0, 0, 0, 128, 20, 128, 144, 129, 139, 131, 134, 133, 131, 135,
	129, 138, 128, 144, 128, 147, 129, 149, 131, 151, 134, 153, 139, 154, 144, 154, 152, 153, 157, 151,
	162, 149, 165, 147, 167, 144, 168, 138, 168, 135, 167, 133, 165, 131, 162, 129, 157, 128, 152, 128,
	148, 134, 20, 134, 145, 135, 141, 136, 138, 138, 135, 140, 134, 142, 134, 144, 135, 146, 138, 147,
	141, 148, 145, 148, 151, 147, 155, 146, 158, 144, 161, 142, 162, 140, 162, 138, 161, 136, 158, 135,
	155, 134, 151, 134, 148, 161, 0, 0, 0, 139, 40, 139, 165, 137, 162, 136, 161, 133, 160, 131, 160,
	131, 152, 139, 152, 139, 128, 147, 128, 147, 168, 139, 168, 161, 0, 0, 0, 136, 26, 136, 157, 137,
	158, 139, 159, 140, 159, 142, 158, 143, 156, 143, 152, 141, 150, 133, 144, 130, 139, 129, 135, 128,
	130, 128, 128, 151, 128, 151, 136, 137, 136, 145, 142, 148, 146, 149, 148, 150, 151, 150, 157, 149,
	160, 148, 162, 145, 166, 143, 167, 140, 168, 138, 168, 134, 166, 131, 163, 130, 161, 129, 157, 129,
	154, 136, 154, 161, 0, 0, 0, 129, 28, 135, 156, 135, 158, 136, 160, 138, 161, 142, 161, 144, 159,
	144, 157, 143, 155, 141, 154, 137, 154, 137, 147, 141, 147, 143, 146, 144, 145, 145, 143, 145, 139,
	144, 137, 142, 135, 138, 135, 136, 136, 135, 138, 135, 141, 129, 141, 129, 139, 130, 133, 131, 131,
	133, 129, 139, 255, 140, 255, 143, 128, 147, 130, 149, 132, 151, 136, 152, 141, 152, 144, 151, 148,
	150, 150, 149, 151, 150, 153, 151, 156, 151, 158, 150, 161, 149, 163, 147, 166, 144, 168, 141, 169,
	139, 169, 136, 168, 134, 167, 132, 165, 130, 162, 129, 158, 129, 156, 161, 0, 0, 0, 141, 16, 141,
	159, 133, 144, 141, 144, 141, 0, 148, 128, 148, 136, 153, 136, 153, 144, 148, 144, 148, 168, 141,
	168, 128, 148, 128, 136, 141, 136, 141, 128, 160, 0, 0, 0, 135, 25, 137, 160, 150, 160, 150, 168,
	132, 168, 129, 146, 135, 146, 137, 148, 139, 149, 141, 149, 143, 148, 145, 144, 145, 140, 144, 137,
	142, 135, 140, 134, 139, 134, 137, 135, 136, 136, 135, 138, 135, 141, 129, 141, 129, 138, 130, 135,
	132, 132, 134, 130, 138, 128, 141, 128, 144, 129, 146, 130, 148, 132, 150, 135, 151, 138, 151, 147,
	150, 149, 148, 152, 144, 155, 140, 155, 137, 154, 135, 153, 161, 0, 0, 0, 134, 26, 134, 157, 136,
	160, 138, 161, 141, 161, 142, 160, 149, 160, 148, 162, 146, 165, 143, 167, 140, 168, 138, 168, 134,
	166, 130, 162, 129, 159, 128, 153, 128, 143, 129, 137, 130, 134, 133, 130, 137, 128, 142, 128, 146,
	130, 149, 134, 150, 138, 150, 145, 148, 151, 145, 154, 143, 155, 140, 156, 138, 156, 134, 154, 137,
	20, 139, 149, 140, 149, 142, 148, 143, 147, 144, 144, 144, 140, 143, 137, 141, 135, 139, 135, 137,
	136, 136, 138, 135, 141, 135, 143, 136, 146, 137, 148, 161, 0, 0, 0, 150, 40, 128, 168, 128, 160,
	143, 160, 132, 128, 141, 128, 150, 160, 150, 168, 160, 0, 0, 0, 149, 23, 150, 150, 151, 148, 152,
	145, 152, 139, 151, 136, 149, 133, 147, 131, 144, 129, 142, 128, 139, 128, 133, 130, 131, 132, 129,
	136, 128, 139, 128, 145, 129, 148, 130, 150, 131, 151, 129, 155, 129, 158, 130, 161, 132, 164, 134,
	166, 136, 167, 139, 168, 141, 168, 144, 167, 146, 166, 148, 164, 150, 161, 151, 158, 151, 155, 149,
	151, 139, 18, 141, 146, 143, 145, 144, 144, 145, 142, 145, 139, 144, 137, 143, 136, 141, 135, 139,
	135, 137, 136, 136, 137, 135, 139, 135, 142, 136, 144, 137, 145, 139, 146, 139, 26, 137, 155, 136,
	157, 136, 159, 137, 161, 139, 162, 141, 162, 143, 161, 144, 159, 144, 157, 143, 155, 141, 154, 139,
	154, 161, 0, 0, 0, 145, 15, 145, 141, 144, 138, 142, 135, 139, 134, 137, 134, 136, 135, 136, 136,
	130, 136, 130, 133, 132, 130, 136, 128, 140, 128, 143, 129, 145, 130, 147, 132, 149, 136, 150, 140,
	151, 146, 151, 148, 150, 155, 149, 159, 147, 163, 144, 166, 141, 167, 137, 167, 134, 166, 132, 164,
	130, 160, 129, 155, 129, 151, 130, 146, 132, 143, 134, 141, 137, 140, 141, 140, 143, 141, 145, 143,
	141, 20, 140, 147, 137, 147, 135, 148, 134, 151, 134, 155, 135, 158, 136, 159, 138, 160, 140, 160,
	142, 158, 143, 155, 143, 152, 142, 149, 141, 148, 161, 0, 0, 0, 128, 0, 128, 136, 134, 136, 134, 128,
	128, 128, 0, 128, 128, 16, 128, 153, 134, 153, 134, 144, 128, 144, 141, 0, 0, 0, 134, 0, 134, 135,
	140, 138, 140, 128, 132, 250, 134, 128, 0, 128, 134, 16, 134, 153, 140, 153, 140, 144, 134, 144,
	147, 0, 0, 0, 146, 0, 128, 148, 146, 168, 132, 148, 146, 128, 153, 0, 0, 0, 128, 13, 128, 146, 150,
	146, 150, 141, 128, 141, 0, 128, 128, 22, 128, 155, 150, 155, 150, 150, 128, 150, 157, 0, 0, 0, 128,
	0, 146, 148, 128, 168, 143, 148, 128, 128, 153, 0, 0, 0, 128, 26, 134, 154, 134, 155, 136, 159,
	138, 160, 140, 160, 142, 159, 143, 156, 143, 151, 142, 147, 140, 144, 138, 142, 138, 138, 145, 138,
	145, 142, 147, 144, 148, 147, 149, 152, 149, 157, 148, 161, 146, 164, 143, 167, 140, 168, 137, 168,
	133, 166, 130, 162, 129, 160, 128, 157, 128, 154, 138, 0, 138, 136, 145, 136, 145, 128, 138, 128,
	154, 0, 0, 0, 143, 22, 142, 152, 140, 153, 137, 153, 135, 152, 134, 151, 133, 148, 133, 145, 134,
	143, 136, 142, 139, 142, 141, 143, 142, 145, 142, 143, 144, 142, 146, 142, 148, 144, 149, 147, 149,
	149, 148, 152, 147, 154, 145, 156, 143, 157, 140, 158, 137, 158, 134, 157, 132, 156, 130, 154, 129,
	152, 128, 149, 128, 146, 129, 143, 130, 141, 132, 139, 134, 138, 137, 137, 140, 137, 143, 138, 145,
	139, 146, 140, 137, 25, 135, 151, 134, 148, 134, 145, 135, 143, 136, 142, 144, 14, 143, 143, 143,
	145, 144, 153, 143, 153, 142, 145, 154, 0, 0, 0, 128, 0, 139, 168, 145, 168, 157, 128, 151, 128, 149,
	136, 136, 136, 134, 128, 128, 128, 138, 14, 147, 142, 142, 158, 138, 142, 164, 0, 0, 0, 134, 6, 134,
	145, 142, 145, 144, 144, 145, 143, 146, 141, 146, 138, 145, 136, 144, 135, 142, 134, 134, 134, 128,
	0, 147, 128, 149, 129, 151, 131, 152, 133, 153, 136, 153, 142, 152, 145, 151, 147, 149, 149, 150,
	150, 151, 152, 152, 155, 152, 161, 151, 164, 148, 167, 146, 168, 128, 168, 128, 128, 134, 23, 141,
	151, 143, 152, 144, 155, 144, 158, 143, 161, 141, 162, 134, 162, 134, 151, 160, 0, 0, 0, 134, 22,
	134, 145, 135, 141, 137, 138, 139, 136, 141, 135, 143, 135, 146, 136, 148, 138, 149, 141, 149, 143,
	155, 143, 155, 141, 154, 137, 152, 133, 150, 131, 147, 129, 144, 128, 139, 128, 137, 129, 134, 131,
	132, 134, 130, 138, 128, 146, 128, 150, 130, 158, 132, 162, 134, 165, 137, 167, 139, 168, 144, 168,
	147, 167, 150, 165, 152, 163, 154, 159, 155, 155, 155, 153, 149, 153, 149, 155, 148, 158, 146, 160,
	143, 161, 141, 161, 139, 160, 137, 158, 135, 155, 134, 151, 134, 146, 162, 0, 0, 0, 142, 34, 145,
	162, 147, 159, 148, 156, 149, 150, 149, 146, 148, 140, 147, 137, 145, 134, 142, 134, 134, 134, 134,
	162, 142, 162, 142, 40, 128, 168, 128, 128, 145, 128, 148, 129, 150, 131, 152, 135, 153, 138, 154,
	144, 154, 152, 153, 158, 152, 161, 151, 163, 149, 165, 147, 167, 145, 168, 142, 168, 161, 0, 0, 0,
	128, 3, 128, 168, 152, 168, 152, 162, 134, 162, 134, 151, 150, 151, 150, 145, 134, 145, 134, 134,
	152, 134, 152, 128, 128, 128, 128, 131, 159, 0, 0, 0, 128, 3, 128, 168, 152, 168, 152, 162, 134, 162,
	134, 151, 150, 151, 150, 145, 134, 145, 134, 128, 128, 128, 128, 131, 156, 0, 0, 0, 148, 2, 147, 129,
	144, 128, 141, 128, 137, 129, 134, 131, 132, 134, 130, 138, 128, 146, 128, 150, 130, 158, 132, 162,
	134, 165, 137, 167, 141, 168, 145, 168, 149, 166, 152, 162, 153, 160, 154, 155, 154, 154, 148, 154,
	148, 156, 146, 160, 144, 161, 140, 161, 137, 159, 135, 155, 134, 151, 134, 145, 135, 141, 137, 137,
	140, 135, 144, 135, 146, 136, 147, 138, 148, 141, 148, 143, 143, 143, 143, 149, 154, 149, 154, 128,
	148, 128, 148, 130, 161, 0, 0, 0, 128, 0, 128, 168, 136, 168, 136, 152, 143, 152, 143, 168, 151, 168,
	151, 128, 143, 128, 143, 144, 136, 144, 136, 128, 128, 128, 158, 0, 0, 0, 128, 0, 128, 168, 136, 168,
	136, 128, 128, 128, 143, 0, 0, 0, 149, 10, 149, 136, 148, 133, 146, 130, 143, 128, 138, 128, 135,
	128, 132, 130, 130, 134, 129, 137, 129, 141, 135, 141, 135, 140, 136, 137, 138, 136, 140, 136, 142,
	138, 143, 141, 143, 168, 149, 168, 149, 138, 156, 0, 0, 0, 128, 0, 128, 168, 135, 168, 135, 152, 145,
	168, 154, 168, 142, 152, 155, 128, 146, 128, 137, 145, 135, 142, 135, 128, 128, 128, 162, 0, 0, 0,
	128, 37, 128, 128, 152, 128, 152, 134, 134, 134, 134, 168, 128, 168, 128, 165, 157, 0, 0, 0, 128, 0,
	128, 168, 138, 168, 143, 144, 149, 168, 159, 168, 159, 128, 152, 128, 152, 149, 147, 128, 140, 128,
	135, 149, 135, 128, 128, 128, 166, 0, 0, 0, 128, 0, 128, 168, 135, 168, 146, 145, 146, 168, 153, 168,
	153, 128, 146, 128, 135, 151, 135, 128, 128, 128, 160, 0, 0, 0, 128, 20, 128, 144, 129, 139, 131,
	134, 133, 131, 135, 129, 138, 128, 144, 128, 147, 129, 149, 131, 151, 134, 153, 139, 154, 144, 154,
	152, 153, 157, 151, 162, 149, 165, 147, 167, 144, 168, 138, 168, 135, 167, 133, 165, 131, 162, 129,
	157, 128, 152, 128, 148, 134, 20, 134, 145, 135, 141, 136, 138, 138, 135, 140, 134, 142, 134, 144,
	135, 146, 138, 147, 141, 148, 145, 148, 151, 147, 155, 146, 158, 144, 161, 142, 162, 140, 162, 138,
	161, 136, 158, 135, 155, 134, 151, 134, 148, 161, 0, 0, 0, 139, 17, 145, 145, 148, 146, 151, 149,
	152, 152, 152, 161, 151, 164, 148, 167, 145, 168, 128, 168, 128, 128, 134, 128, 134, 145, 139, 145,
	139, 23, 134, 151, 134, 162, 143, 162, 145, 161, 146, 159, 146, 154, 145, 152, 143, 151, 139, 151,
	158, 0, 0, 0, 144, 8, 144, 135, 142, 134, 140, 134, 138, 135, 136, 138, 135, 141, 134, 145, 134, 151,
	135, 155, 136, 158, 138, 161, 140, 162, 142, 162, 144, 161, 146, 158, 147, 155, 148, 151, 148, 145,
	147, 142, 145, 145, 141, 140, 144, 136, 150, 0, 154, 133, 152, 136, 153, 139, 154, 144, 154, 152,
	153, 157, 151, 162, 149, 165, 147, 167, 144, 168, 138, 168, 135, 167, 133, 165, 131, 162, 129, 157,
	128, 152, 128, 144, 129, 139, 131, 134, 133, 131, 135, 129, 138, 128, 144, 128, 147, 129, 148, 130,
	150, 128, 161, 0, 0, 0, 134, 0, 134, 145, 143, 145, 145, 144, 146, 142, 146, 128, 152, 128, 152, 142,
	151, 145, 149, 147, 151, 149, 152, 152, 152, 161, 151, 164, 148, 167, 145, 168, 128, 168, 128, 128,
	134, 128, 139, 23, 134, 151, 134, 162, 143, 162, 145, 161, 146, 159, 146, 154, 145, 152, 143, 151,
	139, 151, 158, 0, 0, 0, 136, 25, 135, 154, 134, 156, 134, 158, 135, 160, 136, 161, 138, 162, 140,
	162, 142, 161, 143, 160, 144, 158, 144, 156, 150, 156, 150, 160, 149, 163, 146, 166, 142, 168, 136,
	168, 132, 166, 130, 164, 128, 160, 128, 155, 129, 151, 131, 149, 136, 146, 144, 142, 145, 141, 146,
	139, 146, 137, 145, 135, 144, 134, 141, 133, 138, 133, 136, 134, 135, 135, 135, 137, 129, 137, 129,
	134, 130, 132, 132, 130, 137, 128, 141, 128, 146, 129, 149, 131, 151, 133, 152, 137, 152, 140, 151,
	143, 150, 145, 146, 148, 136, 153, 159, 0, 0, 0, 137, 34, 128, 162, 128, 168, 154, 168, 154, 162,
	144, 162, 144, 128, 138, 128, 138, 162, 137, 162, 161, 0, 0, 0, 128, 10, 128, 168, 135, 168, 135,
	142, 136, 138, 137, 137, 140, 136, 142, 136, 144, 137, 145, 138, 146, 142, 146, 168, 153, 168, 153,
	139, 152, 135, 150, 131, 149, 130, 146, 129, 141, 128, 139, 128, 135, 129, 132, 130, 130, 132, 128,
	138, 160, 0, 0, 0, 134, 40, 128, 168, 139, 128, 145, 128, 157, 168, 151, 168, 142, 138, 134, 168,
	162, 0, 0, 0, 151, 40, 142, 138, 134, 168, 128, 168, 139, 128, 145, 128, 154, 158, 162, 128, 168,
	128, 180, 168, 174, 168, 165, 138, 157, 168, 151, 168, 186, 0, 0, 0, 134, 20, 128, 128, 134, 128,
	137, 138, 140, 128, 146, 128, 140, 148, 146, 168, 140, 168, 137, 158, 134, 168, 128, 168, 134, 148,
	159, 0, 0, 0, 142, 0, 139, 128, 139, 145, 128, 168, 134, 168, 142, 151, 150, 168, 156, 168, 145, 145,
	145, 128, 142, 128, 163, 0, 0, 0, 128, 0, 128, 135, 143, 160, 128, 160, 128, 168, 154, 168, 154, 161,
	139, 137, 154, 137, 154, 128, 128, 128, 161, 0, 0, 0, 128, 0, 128, 168, 143, 168, 143, 161, 135, 161,
	135, 135, 143, 135, 143, 128, 128, 128, 150, 0, 0, 0, 147, 0, 132, 168, 128, 168, 143, 128, 147, 128,
	154, 0, 0, 0, 143, 0, 143, 168, 128, 168, 128, 161, 135, 161, 135, 135, 128, 135, 128, 128, 143, 128,
	150, 0, 0, 0, 130, 29, 141, 169, 152, 157, 141, 163, 130, 157, 157, 0, 0, 0, 128, 0, 128, 247, 150,
	247, 150, 128, 128, 128, 157, 0, 0, 0, 128, 38, 128, 156, 131, 166, 129, 168, 128, 166, 138, 0, 0, 0,
	143, 14, 143, 137, 142, 135, 140, 134, 138, 134, 136, 135, 135, 137, 136, 140, 138, 141, 140, 141,
	143, 142, 147, 29, 146, 158, 144, 159, 140, 159, 136, 158, 134, 157, 132, 155, 130, 151, 130, 149,
	136, 149, 136, 151, 137, 153, 139, 154, 141, 154, 142, 153, 143, 151, 143, 149, 142, 147, 140, 146,
	137, 146, 134, 145, 131, 143, 129, 139, 129, 135, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128,
	143, 130, 143, 128, 149, 128, 149, 154, 148, 156, 147, 157, 156, 0, 0, 0, 135, 9, 136, 135, 138, 134,
	141, 134, 143, 135, 144, 137, 145, 141, 145, 145, 144, 149, 143, 151, 141, 152, 138, 152, 136, 151,
	135, 149, 134, 145, 134, 141, 135, 137, 135, 29, 138, 158, 141, 158, 144, 157, 146, 156, 148, 154,
	149, 152, 150, 149, 151, 145, 151, 141, 150, 137, 149, 134, 148, 132, 146, 130, 144, 129, 141, 128,
	138, 128, 135, 129, 134, 130, 134, 128, 128, 128, 128, 168, 134, 168, 134, 156, 135, 157, 158, 0, 0,
	0, 150, 21, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131,
	154, 130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138,
	128, 141, 128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 144, 137, 143, 135, 141, 134, 138,
	134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 143, 151, 144,
	149, 150, 149, 157, 0, 0, 0, 144, 9, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134, 141, 134,
	145, 135, 149, 136, 151, 138, 152, 141, 152, 143, 151, 144, 149, 145, 145, 145, 141, 144, 137, 144,
	29, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149, 128, 145, 128, 141, 129,
	137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129, 145, 130, 145, 128, 151,
	128, 151, 168, 145, 168, 145, 156, 144, 157, 158, 0, 0, 0, 151, 17, 150, 149, 149, 152, 148, 154,
	146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149, 128, 145,
	128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129, 146, 130,
	148, 132, 149, 134, 150, 137, 144, 137, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134, 141,
	151, 141, 151, 145, 135, 21, 136, 151, 138, 152, 141, 152, 143, 151, 144, 149, 145, 146, 134, 146,
	135, 149, 157, 0, 0, 0, 139, 34, 142, 162, 142, 168, 139, 168, 135, 167, 133, 165, 132, 161, 132,
	158, 128, 158, 128, 151, 132, 151, 132, 128, 138, 128, 138, 151, 142, 151, 142, 158, 138, 158, 138,
	161, 139, 162, 146, 0, 0, 0, 144, 21, 143, 151, 141, 152, 138, 152, 136, 151, 135, 149, 134, 145,
	134, 141, 135, 137, 136, 135, 138, 134, 141, 134, 143, 135, 144, 137, 145, 141, 145, 145, 144, 149,
	151, 4, 150, 254, 149, 251, 148, 249, 146, 247, 144, 246, 141, 245, 138, 245, 135, 246, 133, 247,
	131, 249, 130, 251, 129, 254, 135, 254, 136, 252, 138, 251, 141, 251, 143, 252, 144, 254, 145, 130,
	144, 129, 141, 128, 138, 128, 135, 129, 133, 130, 131, 132, 130, 134, 129, 137, 128, 141, 128, 145,
	129, 149, 130, 152, 131, 154, 133, 156, 135, 157, 138, 158, 141, 158, 144, 157, 145, 156, 145, 158,
	151, 158, 151, 132, 157, 0, 0, 0, 145, 13, 145, 145, 144, 149, 143, 151, 141, 152, 138, 152, 136,
	151, 135, 149, 134, 145, 134, 128, 128, 128, 128, 168, 134, 168, 134, 156, 135, 157, 138, 158, 141,
	158, 144, 157, 146, 156, 148, 154, 149, 152, 150, 149, 151, 145, 151, 128, 145, 128, 145, 141, 158,
	0, 0, 0, 128, 0, 128, 158, 134, 158, 134, 128, 128, 128, 128, 34, 128, 168, 134, 168, 134, 162,
	128, 162, 142, 0, 0, 0, 129, 126, 129, 249, 132, 249, 136, 250, 138, 252, 139, 128, 139, 158, 133,
	158, 133, 128, 132, 255, 130, 254, 129, 254, 133, 40, 139, 168, 139, 162, 133, 162, 133, 168, 146,
	0, 0, 0, 128, 0, 128, 168, 135, 168, 135, 149, 141, 158, 150, 158, 141, 146, 151, 128, 142, 128,
	136, 141, 135, 138, 135, 128, 128, 128, 158, 0, 0, 0, 128, 0, 128, 168, 135, 168, 135, 128, 128, 128,
	142, 0, 0, 0, 135, 28, 135, 158, 130, 158, 130, 128, 135, 128, 135, 147, 136, 150, 138, 152, 140,
	152, 142, 150, 143, 147, 143, 128, 148, 128, 148, 147, 149, 150, 151, 152, 153, 152, 155, 150, 156,
	147, 156, 128, 161, 128, 161, 147, 161, 149, 160, 152, 159, 154, 157, 156, 156, 157, 154, 158, 152,
	158, 149, 157, 148, 156, 146, 154, 145, 156, 144, 157, 142, 158, 138, 158, 136, 157, 135, 156, 168,
	0, 0, 0, 145, 13, 145, 145, 144, 149, 143, 151, 141, 152, 138, 152, 136, 151, 135, 149, 134, 145,
	134, 128, 128, 128, 128, 158, 134, 158, 134, 156, 135, 157, 138, 158, 141, 158, 144, 157, 146, 156,
	148, 154, 149, 152, 150, 149, 151, 145, 151, 128, 145, 128, 145, 141, 155, 0, 0, 0, 150, 21, 149,
	152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129,
	149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144,
	129, 146, 130, 148, 132, 149, 134, 150, 137, 151, 141, 151, 145, 150, 149, 144, 9, 143, 135, 141,
	134, 138, 134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 143,
	151, 144, 149, 145, 145, 145, 141, 144, 137, 157, 0, 0, 0, 135, 21, 136, 151, 138, 152, 141, 152,
	143, 151, 144, 149, 145, 145, 145, 141, 144, 137, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137,
	134, 141, 134, 145, 135, 149, 135, 1, 138, 128, 141, 128, 144, 129, 146, 130, 148, 132, 149, 134,
	150, 137, 151, 141, 151, 145, 150, 149, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158,
	135, 157, 134, 156, 134, 158, 128, 158, 128, 249, 134, 249, 134, 130, 135, 129, 158, 0, 0, 0, 144,
	21, 143, 151, 141, 152, 138, 152, 136, 151, 135, 149, 134, 145, 134, 141, 135, 137, 136, 135, 138,
	134, 141, 134, 143, 135, 144, 137, 145, 141, 145, 145, 144, 149, 144, 1, 141, 128, 138, 128, 135,
	129, 133, 130, 131, 132, 130, 134, 129, 137, 128, 141, 128, 145, 129, 149, 130, 152, 131, 154, 133,
	156, 135, 157, 138, 158, 141, 158, 144, 157, 145, 156, 145, 158, 151, 158, 151, 249, 145, 249, 145,
	130, 144, 129, 158, 0, 0, 0, 135, 0, 135, 142, 135, 144, 136, 147, 137, 148, 139, 149, 142, 149, 142,
	158, 138, 158, 136, 157, 135, 156, 135, 158, 129, 158, 129, 128, 135, 128, 149, 0, 0, 0, 137, 0, 140,
	128, 143, 129, 147, 132, 148, 134, 148, 137, 147, 140, 145, 142, 136, 147, 134, 149, 134, 150, 135,
	152, 137, 153, 139, 153, 141, 152, 142, 149, 148, 149, 148, 150, 147, 153, 145, 156, 143, 158, 140,
	159, 137, 159, 134, 158, 132, 157, 130, 154, 129, 151, 129, 149, 130, 146, 132, 144, 142, 139, 143,
	137, 143, 136, 142, 134, 139, 133, 137, 133, 135, 134, 134, 136, 134, 138, 129, 138, 129, 135, 130,
	132, 131, 131, 134, 129, 137, 128, 155, 0, 0, 0, 139, 6, 142, 134, 142, 128, 139, 128, 135, 129, 133,
	131, 132, 135, 132, 151, 128, 151, 128, 158, 132, 158, 132, 165, 138, 165, 138, 158, 142, 158, 142,
	151, 138, 151, 138, 135, 139, 134, 146, 0, 0, 0, 142, 9, 141, 135, 139, 134, 137, 134, 135, 136, 134,
	139, 134, 158, 128, 158, 128, 137, 130, 131, 132, 129, 134, 128, 138, 128, 141, 129, 141, 128, 148,
	128, 148, 158, 142, 158, 142, 137, 155, 0, 0, 0, 143, 0, 136, 128, 128, 158, 136, 158, 139, 138, 143,
	158, 150, 158, 143, 128, 157, 0, 0, 0, 144, 18, 141, 128, 135, 128, 128, 158, 135, 158, 138, 142,
	142, 158, 147, 158, 151, 142, 154, 158, 161, 158, 154, 128, 149, 128, 144, 146, 168, 0, 0, 0, 129, 0,
	136, 144, 129, 158, 137, 158, 140, 151, 143, 158, 151, 158, 144, 144, 152, 128, 144, 128, 140, 137,
	136, 128, 129, 128, 159, 0, 0, 0, 139, 121, 151, 158, 144, 158, 139, 141, 135, 158, 128, 158, 136,
	130, 133, 249, 139, 249, 140, 252, 141, 128, 156, 0, 0, 0, 128, 0, 128, 136, 137, 150, 129, 150, 129,
	158, 147, 158, 147, 150, 137, 136, 148, 136, 148, 128, 128, 128, 155, 0, 0, 0, 133, 18, 133, 142,
	135, 134, 138, 130, 142, 130, 142, 128, 137, 128, 133, 133, 131, 141, 131, 147, 128, 147, 128, 149,
	131, 149, 131, 155, 133, 163, 137, 168, 142, 168, 142, 166, 138, 166, 135, 162, 133, 154, 133, 146,
	148, 0, 0, 0, 128, 0, 128, 168, 134, 168, 134, 128, 128, 128, 128, 22, 128, 154, 141, 0, 0, 0, 137, 18,
	137, 142, 135, 134, 132, 130, 128, 130, 128, 128, 133, 128, 137, 133, 139, 141, 139, 147, 142, 147,
	142, 149, 139, 149, 139, 155, 137, 163, 133, 168, 128, 168, 128, 166, 132, 166, 135, 162, 137, 154,
	137, 146, 147, 0, 0, 0, 130, 33, 138, 169, 145, 162, 153, 168, 155, 166, 145, 158, 138, 165, 132,
	159, 130, 161, 157, 0, 0, 0, 128, 17, 128, 128, 150, 128, 150, 145, 139, 162, 128, 145, 134, 17, 134,
	134, 144, 134, 144, 145, 139, 152, 134, 145, 158, 0, 0, 0, 134, 22, 134, 145, 135, 141, 137, 138,
	139, 136, 141, 135, 143, 135, 146, 136, 148, 138, 149, 141, 149, 143, 155, 143, 155, 141, 154, 137,
	152, 133, 150, 131, 147, 129, 144, 128, 144, 253, 140, 249, 136, 249, 136, 251, 139, 253, 139, 128,
	137, 129, 134, 131, 132, 134, 130, 138, 128, 146, 128, 150, 130, 158, 132, 162, 134, 165, 137, 167,
	139, 168, 144, 168, 147, 167, 150, 165, 152, 163, 154, 159, 155, 155, 155, 153, 149, 153, 149, 155,
	148, 158, 146, 160, 143, 161, 141, 161, 139, 160, 137, 158, 135, 155, 134, 151, 134, 146, 255, 0,
	255, 128, 162, 0, 0, 0, 142, 9, 141, 135, 139, 134, 137, 134, 135, 136, 134, 139, 134, 158, 128, 158,
	128, 137, 130, 131, 132, 129, 134, 128, 138, 128, 141, 129, 141, 128, 148, 128, 148, 158, 142, 158,
	142, 137, 128, 36, 128, 161, 133, 161, 133, 164, 128, 164, 143, 36, 143, 161, 148, 161, 148, 164,
	143, 164, 154, 0, 0, 0, 151, 17, 150, 149, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138,
	158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131,
	132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 144,
	137, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134, 141, 151, 141, 151, 145, 135, 21, 136,
	151, 138, 152, 141, 152, 143, 151, 144, 149, 145, 146, 134, 146, 135, 149, 141, 39, 141, 174, 146,
	177, 146, 167, 138, 161, 141, 167, 154, 0, 0, 0, 144, 14, 144, 137, 143, 135, 141, 134, 139, 134,
	137, 135, 136, 137, 137, 140, 139, 141, 141, 141, 144, 142, 148, 29, 147, 158, 145, 159, 141, 159,
	137, 158, 135, 157, 133, 155, 131, 151, 131, 149, 137, 149, 137, 151, 138, 153, 140, 154, 142, 154,
	143, 153, 144, 151, 144, 149, 143, 147, 141, 146, 138, 146, 135, 145, 132, 143, 130, 139, 130, 135,
	131, 132, 133, 130, 135, 129, 138, 128, 140, 128, 144, 130, 144, 128, 150, 128, 150, 154, 149, 156,
	148, 157, 131, 31, 142, 171, 153, 159, 142, 165, 131, 159, 158, 0, 0, 0, 143, 14, 143, 137, 142, 135,
	140, 134, 138, 134, 136, 135, 135, 137, 136, 140, 138, 141, 140, 141, 143, 142, 147, 29, 146, 158,
	144, 159, 140, 159, 136, 158, 134, 157, 132, 155, 130, 151, 130, 149, 136, 149, 136, 151, 137, 153,
	139, 154, 141, 154, 142, 153, 143, 151, 143, 149, 142, 147, 140, 146, 137, 146, 134, 145, 131, 143,
	129, 139, 129, 135, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 143, 130, 143, 128, 149, 128,
	149, 154, 148, 156, 147, 157, 133, 39, 133, 164, 138, 164, 138, 167, 133, 167, 146, 36, 150, 164,
	150, 167, 145, 167, 145, 164, 146, 164, 156, 0, 0, 0, 143, 14, 143, 137, 142, 135, 140, 134, 138,
	134, 136, 135, 135, 137, 136, 140, 138, 141, 140, 141, 143, 142, 147, 29, 146, 158, 144, 159, 140,
	159, 136, 158, 134, 157, 132, 155, 130, 151, 130, 149, 136, 149, 136, 151, 137, 153, 139, 154, 141,
	154, 142, 153, 143, 151, 143, 149, 142, 147, 140, 146, 137, 146, 134, 145, 131, 143, 129, 139, 129,
	135, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 143, 130, 143, 128, 149, 128, 149, 154, 148,
	156, 147, 157, 138, 39, 138, 174, 133, 177, 133, 167, 141, 161, 138, 167, 156, 0, 0, 0, 143, 14, 143,
	137, 142, 135, 140, 134, 138, 134, 136, 135, 135, 137, 136, 140, 138, 141, 140, 141, 143, 142, 147,
	29, 146, 158, 144, 159, 140, 159, 136, 158, 134, 157, 132, 155, 130, 151, 130, 149, 136, 149, 136,
	151, 137, 153, 139, 154, 141, 154, 142, 153, 143, 151, 143, 149, 142, 147, 140, 146, 137, 146, 134,
	145, 131, 143, 129, 139, 129, 135, 130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 143, 130, 143,
	128, 149, 128, 149, 154, 148, 156, 147, 157, 138, 40, 142, 168, 145, 166, 145, 164, 141, 162, 138,
	162, 135, 164, 135, 166, 138, 168, 138, 38, 142, 166, 143, 165, 141, 164, 139, 164, 137, 165, 138,
	166, 156, 0, 0, 0, 144, 1, 146, 130, 148, 132, 149, 134, 150, 137, 144, 137, 143, 135, 141, 134, 138,
	134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 143, 151, 144,
	149, 150, 149, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131,
	154, 130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138,
	128, 138, 253, 135, 251, 135, 249, 139, 249, 143, 253, 143, 128, 144, 129, 153, 0, 0, 0, 151, 17,
	150, 149, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154,
	130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128,
	141, 128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 144, 137, 143, 135, 141, 134, 138, 134,
	136, 135, 135, 137, 134, 141, 151, 141, 151, 145, 135, 21, 136, 151, 138, 152, 141, 152, 143, 151,
	144, 149, 145, 146, 134, 146, 135, 149, 129, 29, 140, 169, 151, 157, 140, 163, 129, 157, 154, 0, 0,
	0, 151, 17, 150, 149, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133,
	156, 131, 154, 130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135,
	129, 138, 128, 141, 128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 144, 137, 143, 135, 141,
	134, 138, 134, 136, 135, 135, 137, 134, 141, 151, 141, 151, 145, 135, 21, 136, 151, 138, 152, 141,
	152, 143, 151, 144, 149, 145, 146, 134, 146, 135, 149, 143, 36, 143, 161, 148, 161, 148, 164, 143,
	164, 131, 36, 131, 161, 136, 161, 136, 164, 131, 164, 155, 0, 0, 0, 151, 17, 150, 149, 149, 152, 148,
	154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149, 128,
	145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129, 146,
	130, 148, 132, 149, 134, 150, 137, 144, 137, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134,
	141, 151, 141, 151, 145, 135, 21, 136, 151, 138, 152, 141, 152, 143, 151, 144, 149, 145, 146, 134,
	146, 135, 149, 137, 39, 137, 174, 132, 177, 132, 167, 140, 161, 137, 167, 156, 0, 0, 0, 134, 0, 134,
	158, 140, 158, 140, 128, 134, 128, 128, 36, 128, 161, 133, 161, 133, 164, 128, 164, 141, 36, 141,
	161, 146, 161, 146, 164, 141, 164, 147, 0, 0, 0, 136, 0, 136, 158, 142, 158, 142, 128, 136, 128, 128,
	31, 139, 171, 150, 159, 139, 165, 128, 159, 148, 0, 0, 0, 132, 0, 132, 158, 138, 158, 138, 128, 132,
	128, 133, 39, 133, 174, 128, 177, 128, 167, 136, 161, 133, 167, 143, 0, 0, 0, 128, 0, 139, 168, 145,
	168, 157, 128, 151, 128, 149, 136, 136, 136, 134, 128, 128, 128, 138, 14, 147, 142, 142, 158, 138,
	142, 134, 46, 134, 171, 138, 171, 138, 174, 134, 174, 147, 46, 147, 171, 151, 171, 151, 174, 147,
	174, 164, 0, 0, 0, 128, 0, 139, 168, 145, 168, 157, 128, 151, 128, 149, 136, 136, 136, 134, 128, 128,
	128, 138, 14, 147, 142, 142, 158, 138, 142, 140, 49, 144, 177, 147, 175, 147, 173, 143, 171, 140,
	171, 137, 173, 137, 175, 140, 177, 140, 47, 144, 175, 145, 174, 143, 173, 141, 173, 139, 174, 140,
	175, 164, 0, 0, 0, 128, 3, 128, 168, 152, 168, 152, 162, 134, 162, 134, 151, 150, 151, 150, 145, 134,
	145, 134, 134, 152, 134, 152, 128, 128, 128, 128, 131, 148, 48, 140, 170, 143, 176, 143, 177, 148,
	181, 148, 176, 159, 0, 0, 0, 143, 14, 143, 137, 142, 135, 140, 134, 138, 134, 136, 135, 135, 137,
	136, 140, 138, 141, 140, 141, 143, 142, 149, 11, 149, 154, 148, 156, 146, 158, 144, 159, 140, 159,
	136, 158, 134, 157, 132, 155, 130, 151, 130, 149, 136, 149, 136, 151, 137, 153, 139, 154, 141, 154,
	142, 153, 143, 151, 143, 149, 142, 147, 140, 146, 137, 146, 134, 145, 131, 143, 129, 139, 129, 135,
	130, 132, 132, 130, 134, 129, 137, 128, 139, 128, 143, 130, 143, 128, 149, 128, 149, 139, 150, 9,
	151, 134, 152, 132, 154, 130, 156, 129, 159, 128, 162, 128, 165, 129, 167, 130, 169, 132, 170, 134,
	171, 137, 165, 137, 164, 135, 162, 134, 159, 134, 157, 135, 156, 137, 155, 141, 172, 141, 172, 145,
	171, 149, 170, 152, 169, 154, 167, 156, 165, 157, 162, 158, 159, 158, 156, 157, 154, 156, 152, 154,
	151, 152, 150, 149, 150, 137, 156, 21, 157, 151, 159, 152, 162, 152, 164, 151, 165, 149, 166, 146,
	155, 146, 156, 149, 176, 0, 0, 0, 145, 40, 145, 162, 138, 142, 145, 142, 145, 136, 136, 136, 134,
	128, 128, 128, 139, 168, 145, 168, 169, 40, 169, 162, 151, 162, 151, 151, 167, 151, 167, 145, 151,
	145, 151, 134, 169, 134, 169, 128, 146, 128, 146, 168, 169, 168, 179, 0, 0, 0, 150, 21, 149, 152,
	148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149,
	128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129,
	146, 130, 148, 132, 149, 134, 150, 137, 151, 141, 151, 145, 150, 149, 144, 9, 143, 135, 141, 134,
	138, 134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 143, 151,
	144, 149, 145, 145, 145, 141, 144, 137, 129, 31, 140, 171, 151, 159, 140, 165, 129, 159, 154, 0, 0,
	0, 150, 21, 149, 152, 148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131,
	154, 130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138,
	128, 141, 128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 151, 141, 151, 145, 150, 149, 144,
	9, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138,
	152, 141, 152, 143, 151, 144, 149, 145, 145, 145, 141, 144, 137, 132, 37, 132, 162, 136, 162, 136,
	165, 132, 165, 145, 37, 145, 162, 149, 162, 149, 165, 145, 165, 157, 0, 0, 0, 150, 21, 149, 152, 148,
	154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149, 128,
	145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129, 146,
	130, 148, 132, 149, 134, 150, 137, 151, 141, 151, 145, 150, 149, 144, 9, 143, 135, 141, 134, 138,
	134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 143, 151, 144,
	149, 145, 145, 145, 141, 144, 137, 136, 39, 136, 174, 131, 177, 131, 167, 139, 161, 136, 167, 156,
	0, 0, 0, 143, 9, 142, 135, 140, 134, 138, 134, 136, 136, 135, 139, 135, 158, 129, 158, 129, 137,
	131, 131, 133, 129, 135, 128, 139, 128, 142, 129, 142, 128, 149, 128, 149, 158, 143, 158, 143, 137,
	128, 32, 139, 172, 150, 160, 139, 166, 128, 160, 155, 0, 0, 0, 142, 9, 141, 135, 139, 134, 137, 134,
	135, 136, 134, 139, 134, 158, 128, 158, 128, 137, 130, 131, 132, 129, 134, 128, 138, 128, 141, 129,
	141, 128, 148, 128, 148, 158, 142, 158, 142, 137, 139, 39, 139, 174, 134, 177, 134, 167, 142, 161,
	139, 167, 154, 0, 0, 0, 139, 121, 151, 158, 144, 158, 139, 141, 135, 158, 128, 158, 136, 130, 133,
	249, 139, 249, 140, 252, 141, 128, 129, 36, 129, 161, 134, 161, 134, 164, 129, 164, 145, 36, 145,
	161, 150, 161, 150, 164, 145, 164, 156, 0, 0, 0, 128, 20, 128, 144, 129, 139, 131, 134, 133, 131,
	135, 129, 138, 128, 144, 128, 147, 129, 149, 131, 151, 134, 153, 139, 154, 144, 154, 152, 153, 157,
	151, 162, 149, 165, 147, 167, 144, 168, 138, 168, 135, 167, 133, 165, 131, 162, 129, 157, 128, 152,
	128, 148, 134, 20, 134, 145, 135, 141, 136, 138, 138, 135, 140, 134, 142, 134, 144, 135, 146, 138,
	147, 141, 148, 145, 148, 151, 147, 155, 146, 158, 144, 161, 142, 162, 140, 162, 138, 161, 136, 158,
	135, 155, 134, 151, 134, 148, 134, 47, 134, 172, 138, 172, 138, 175, 134, 175, 147, 47, 147, 172,
	151, 172, 151, 175, 147, 175, 161, 0, 0, 0, 128, 10, 128, 168, 135, 168, 135, 142, 136, 138, 137,
	137, 140, 136, 142, 136, 144, 137, 145, 138, 146, 142, 146, 168, 153, 168, 153, 139, 152, 135, 150,
	131, 149, 130, 146, 129, 141, 128, 139, 128, 135, 129, 132, 130, 130, 132, 128, 138, 129, 46, 129,
	171, 134, 171, 134, 174, 129, 174, 147, 46, 147, 171, 152, 171, 152, 174, 147, 174, 158, 0, 0, 0,
	141, 0, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 151, 141, 151, 145, 150, 149, 149, 152,
	148, 153, 152, 159, 147, 159, 145, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154,
	130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 128, 254, 133, 254, 135, 129,
	138, 128, 141, 128, 145, 17, 145, 141, 144, 137, 143, 135, 141, 134, 138, 134, 144, 146, 145, 147,
	145, 145, 134, 13, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 142, 151, 135, 138, 134, 141,
	157, 0, 0, 0, 145, 40, 136, 168, 132, 160, 132, 152, 128, 152, 128, 148, 132, 148, 132, 128, 155,
	128, 162, 132, 162, 141, 154, 141, 154, 136, 150, 134, 138, 134, 138, 148, 149, 148, 147, 152, 138,
	152, 138, 161, 140, 165, 146, 165, 148, 161, 153, 161, 153, 164, 151, 168, 144, 168, 145, 37, 145,
	134, 174, 0, 0, 0, 135, 1, 138, 128, 144, 128, 147, 129, 149, 131, 151, 134, 153, 139, 154, 144, 154,
	152, 153, 157, 151, 163, 147, 155, 148, 151, 148, 145, 147, 141, 146, 138, 144, 135, 142, 134, 140,
	134, 138, 135, 137, 136, 134, 130, 135, 129, 131, 7, 128, 128, 132, 128, 154, 171, 149, 171, 147,
	167, 144, 168, 138, 168, 135, 167, 133, 165, 131, 162, 129, 157, 128, 152, 128, 144, 129, 139, 131,
	134, 142, 34, 140, 162, 138, 161, 136, 158, 135, 155, 134, 151, 134, 145, 135, 141, 144, 161, 142,
	162, 161, 0, 0, 0, 146, 49, 149, 176, 152, 173, 153, 170, 153, 161, 152, 158, 149, 155, 146, 154,
	135, 154, 135, 128, 129, 128, 129, 177, 147, 177, 135, 43, 144, 171, 146, 170, 147, 168, 147, 163,
	146, 161, 144, 160, 135, 160, 135, 171, 155, 22, 158, 150, 158, 146, 155, 146, 155, 135, 156, 134,
	159, 134, 159, 128, 156, 128, 152, 129, 150, 131, 149, 135, 149, 146, 146, 146, 146, 150, 149, 150,
	149, 154, 155, 154, 155, 150, 165, 0, 0, 0, 151, 12, 151, 148, 156, 148, 156, 152, 151, 152, 151,
	167, 153, 171, 159, 171, 161, 167, 167, 167, 167, 172, 165, 176, 150, 176, 145, 166, 145, 152, 140,
	152, 140, 148, 145, 148, 145, 134, 145, 20, 145, 132, 143, 128, 137, 128, 135, 132, 130, 132, 130,
	129, 132, 253, 134, 251, 146, 251, 151, 133, 151, 148, 151, 37, 151, 152, 145, 31, 145, 152, 170, 0,
	0, 0, 143, 14, 143, 137, 142, 135, 140, 134, 138, 134, 136, 135, 135, 137, 136, 140, 138, 141,
	140, 141, 143, 142, 147, 29, 146, 158, 144, 159, 140, 159, 136, 158, 134, 157, 132, 155, 130, 151,
	130, 149, 136, 149, 136, 151, 137, 153, 139, 154, 141, 154, 142, 153, 143, 151, 143, 149, 142, 147,
	140, 146, 137, 146, 134, 145, 131, 143, 129, 139, 129, 135, 130, 132, 132, 130, 134, 129, 137, 128,
	139, 128, 143, 130, 143, 128, 149, 128, 149, 154, 148, 156, 147, 157, 143, 39, 143, 174, 148, 177,
	148, 167, 140, 161, 143, 167, 128, 1, 128, 129, 154, 0, 0, 0, 128, 0, 128, 158, 134, 158, 134, 128,
	128, 128, 133, 39, 133, 174, 138, 177, 138, 167, 130, 161, 133, 167, 139, 0, 0, 0, 150, 21, 149, 152,
	148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149,
	128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129,
	146, 130, 148, 132, 149, 134, 150, 137, 151, 141, 151, 145, 150, 149, 144, 9, 143, 135, 141, 134,
	138, 134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141, 152, 143, 151,
	144, 149, 145, 145, 145, 141, 144, 137, 142, 39, 142, 174, 147, 177, 147, 167, 139, 161, 142, 167,
	157, 0, 0, 0, 142, 9, 141, 135, 139, 134, 137, 134, 135, 136, 134, 139, 134, 158, 128, 158, 128, 137,
	130, 131, 132, 129, 134, 128, 138, 128, 141, 129, 141, 128, 148, 128, 148, 158, 142, 158, 142, 137,
	138, 39, 138, 174, 143, 177, 143, 167, 135, 161, 138, 167, 154, 0, 0, 0, 145, 13, 145, 145, 144, 149,
	143, 151, 141, 152, 138, 152, 136, 151, 135, 149, 134, 145, 134, 128, 128, 128, 128, 158, 134, 158,
	134, 156, 135, 157, 138, 158, 141, 158, 144, 157, 146, 156, 148, 154, 149, 152, 150, 149, 151, 145,
	151, 128, 145, 128, 145, 141, 128, 36, 136, 172, 143, 165, 151, 171, 153, 169, 143, 161, 136, 168,
	130, 162, 128, 164, 156, 0, 0, 0, 128, 0, 128, 168, 135, 168, 146, 145, 146, 168, 153, 168, 153, 128,
	146, 128, 135, 151, 135, 128, 128, 128, 154, 50, 144, 171, 136, 176, 130, 172, 128, 174, 136, 180,
	145, 174, 154, 180, 154, 178, 159, 0, 0, 0, 143, 23, 143, 146, 142, 144, 140, 143, 138, 143, 136,
	144, 135, 146, 136, 149, 138, 150, 140, 150, 143, 151, 147, 38, 146, 167, 144, 168, 140, 168, 136,
	167, 134, 166, 132, 164, 130, 160, 130, 158, 136, 158, 136, 160, 137, 162, 139, 163, 141, 163, 142,
	162, 143, 160, 143, 158, 142, 156, 140, 155, 137, 155, 134, 154, 131, 152, 129, 148, 129, 144, 130,
	141, 132, 139, 134, 138, 137, 137, 139, 137, 143, 139, 143, 137, 149, 137, 149, 163, 148, 165, 147,
	166, 128, 4, 149, 132, 149, 128, 128, 128, 128, 132, 154, 0, 0, 0, 128, 22, 129, 146, 130, 143, 131,
	141, 133, 139, 135, 138, 138, 137, 141, 137, 144, 138, 146, 139, 148, 141, 149, 143, 150, 146, 151,
	150, 150, 154, 149, 157, 148, 159, 146, 161, 144, 162, 141, 163, 138, 163, 135, 162, 133, 161, 131,
	159, 130, 157, 129, 154, 128, 150, 144, 18, 143, 144, 141, 143, 138, 143, 136, 144, 135, 146, 134,
	150, 135, 154, 136, 156, 138, 157, 141, 157, 143, 156, 144, 154, 145, 150, 144, 146, 149, 0, 128,
	128, 128, 132, 151, 132, 151, 128, 149, 128, 158, 0, 0, 0, 149, 14, 143, 142, 143, 141, 141, 137,
	139, 136, 137, 136, 135, 137, 134, 140, 134, 145, 135, 149, 137, 152, 139, 154, 139, 158, 132, 158,
	132, 154, 130, 152, 129, 149, 128, 144, 128, 139, 129, 135, 131, 132, 134, 129, 137, 128, 140, 128,
	144, 130, 147, 134, 148, 136, 149, 139, 149, 142, 139, 40, 139, 160, 132, 160, 132, 168, 139, 168,
	154, 0, 0, 0, 128, 25, 155, 153, 155, 144, 137, 144, 137, 128, 128, 128, 128, 153, 161, 0, 0, 0, 155,
	25, 128, 153, 128, 144, 146, 144, 146, 128, 155, 128, 155, 153, 162, 0, 0, 0, 128, 0, 154, 168, 157,
	168, 131, 128, 128, 128, 132, 31, 128, 159, 128, 163, 130, 163, 131, 164, 132, 166, 132, 168, 137,
	168, 137, 151, 132, 151, 132, 159, 157, 3, 149, 131, 157, 138, 157, 142, 156, 144, 153, 145, 150,
	145, 148, 144, 145, 142, 144, 140, 144, 139, 148, 139, 148, 140, 149, 141, 151, 142, 153, 141, 152,
	139, 150, 137, 145, 133, 144, 131, 144, 128, 157, 128, 157, 131, 148, 11, 144, 139, 238, 1, 238,
	128, 165, 0, 0, 0, 154, 40, 157, 168, 131, 128, 128, 128, 154, 168, 132, 31, 128, 159, 128, 163, 130,
	163, 131, 164, 132, 166, 132, 168, 137, 168, 137, 151, 132, 151, 132, 159, 238, 1, 238, 128, 154, 0,
	150, 128, 150, 131, 141, 131, 141, 135, 150, 145, 155, 145, 155, 135, 157, 135, 157, 131, 155, 131,
	155, 128, 154, 128, 150, 7, 150, 139, 146, 135, 150, 135, 165, 0, 0, 0, 130, 30, 134, 158, 136, 136,
	136, 128, 128, 128, 128, 136, 130, 158, 129, 40, 129, 160, 135, 160, 135, 168, 129, 168, 142, 0, 0,
	0, 132, 17, 138, 136, 136, 136, 128, 145, 136, 154, 138, 154, 132, 145, 143, 17, 149, 136, 147,
	136, 139, 145, 147, 154, 149, 154, 143, 145, 153, 0, 0, 0, 145, 17, 139, 136, 141, 136, 149, 145,
	141, 154, 139, 154, 145, 145, 134, 17, 128, 136, 130, 136, 138, 145, 130, 154, 128, 154, 134, 145,
	154, 0, 0, 0, 129, 34, 132, 162, 132, 159, 129, 159, 129, 162, 130, 34, 130, 159, 131, 34, 131, 159,
	129, 22, 132, 150, 132, 147, 129, 147, 129, 150, 130, 22, 130, 147, 131, 22, 131, 147, 129, 10, 129,
	135, 132, 135, 132, 138, 129, 138, 130, 10, 130, 135, 131, 10, 131, 135, 129, 126, 132, 254, 132,
	251, 129, 251, 129, 254, 130, 126, 130, 251, 131, 126, 131, 251, 139, 40, 139, 165, 142, 165, 142,
	168, 139, 168, 139, 166, 140, 40, 140, 165, 141, 40, 141, 165, 139, 28, 142, 156, 142, 153, 139,
	153, 139, 156, 140, 28, 140, 153, 141, 28, 141, 153, 139, 16, 139, 141, 142, 141, 142, 144, 139,
	144, 140, 16, 140, 141, 141, 16, 141, 141, 139, 4, 142, 132, 142, 129, 139, 129, 139, 132, 140, 4,
	140, 129, 141, 4, 141, 129, 152, 33, 152, 159, 149, 159, 149, 162, 152, 162, 152, 159, 149, 34, 152,
	162, 150, 34, 150, 159, 151, 34, 151, 159, 149, 22, 152, 150, 152, 147, 149, 147, 149, 150, 150, 22,
	150, 147, 151, 22, 151, 147, 149, 10, 149, 135, 152, 135, 152, 138, 149, 138, 150, 10, 150, 135,
	151, 10, 151, 135, 149, 126, 152, 254, 152, 251, 149, 251, 149, 254, 150, 126, 150, 251, 151, 126,
	151, 251, 161, 40, 159, 168, 159, 165, 162, 165, 162, 168, 161, 168, 161, 165, 160, 40, 160, 165,
	159, 28, 162, 156, 162, 153, 159, 153, 159, 156, 160, 28, 160, 153, 161, 28, 161, 153, 159, 16, 159,
	141, 162, 141, 162, 144, 159, 144, 160, 16, 160, 141, 161, 16, 161, 141, 159, 4, 162, 132, 162, 129,
	159, 129, 159, 132, 160, 4, 160, 129, 161, 4, 161, 129, 162, 38, 162, 165, 162, 0, 0, 0, 129, 32, 129,
	162, 132, 162, 132, 159, 129, 159, 129, 162, 130, 162, 130, 159, 131, 34, 131, 159, 129, 22, 132,
	150, 132, 147, 129, 147, 129, 150, 130, 22, 130, 147, 131, 22, 131, 147, 129, 10, 129, 135, 132,
	135, 132, 138, 129, 138, 130, 10, 130, 135, 131, 10, 131, 135, 129, 126, 132, 254, 132, 251, 129,
	251, 129, 254, 130, 126, 130, 251, 131, 126, 131, 251, 134, 40, 134, 165, 137, 165, 137, 168, 134,
	168, 134, 166, 135, 40, 135, 165, 136, 40, 136, 165, 134, 28, 137, 156, 137, 153, 134, 153, 134,
	156, 135, 28, 135, 153, 136, 28, 136, 153, 134, 16, 134, 141, 137, 141, 137, 144, 134, 144, 135, 16,
	135, 141, 136, 16, 136, 141, 134, 4, 137, 132, 137, 129, 134, 129, 134, 132, 135, 4, 135, 129, 136,
	4, 136, 129, 139, 34, 139, 159, 142, 159, 142, 162, 139, 162, 139, 160, 140, 34, 140, 159, 141,
	34, 141, 159, 139, 22, 142, 150, 142, 147, 139, 147, 139, 150, 140, 22, 140, 147, 141, 22, 141,
	147, 139, 10, 139, 135, 142, 135, 142, 138, 139, 138, 140, 10, 140, 135, 141, 10, 141, 135, 139,
	126, 142, 254, 142, 251, 139, 251, 139, 254, 140, 126, 140, 251, 141, 126, 141, 251, 144, 40, 144,
	165, 147, 165, 147, 168, 144, 168, 144, 166, 145, 40, 145, 165, 146, 40, 146, 165, 144, 28, 147,
	156, 147, 153, 144, 153, 144, 156, 145, 28, 145, 153, 146, 28, 146, 153, 144, 16, 144, 141, 147,
	141, 147, 144, 144, 144, 145, 16, 145, 141, 146, 16, 146, 141, 144, 4, 147, 132, 147, 129, 144, 129,
	144, 132, 145, 4, 145, 129, 146, 4, 146, 129, 149, 34, 149, 159, 152, 159, 152, 162, 149, 162, 149,
	160, 150, 34, 150, 159, 151, 34, 151, 159, 149, 22, 152, 150, 152, 147, 149, 147, 149, 150, 150, 22,
	150, 147, 151, 22, 151, 147, 149, 10, 149, 135, 152, 135, 152, 138, 149, 138, 150, 10, 150, 135,
	151, 10, 151, 135, 149, 126, 152, 254, 152, 251, 149, 251, 149, 254, 150, 126, 150, 251, 151, 126,
	151, 251, 154, 40, 154, 165, 157, 165, 157, 168, 154, 168, 154, 166, 155, 40, 155, 165, 156, 40,
	156, 165, 154, 28, 157, 156, 157, 153, 154, 153, 154, 156, 155, 28, 155, 153, 156, 28, 156, 153,
	154, 16, 154, 141, 157, 141, 157, 144, 154, 144, 155, 16, 155, 141, 156, 16, 156, 141, 154, 4, 157,
	132, 157, 129, 154, 129, 154, 132, 155, 4, 155, 129, 156, 4, 156, 129, 159, 34, 159, 159, 162, 159,
	162, 162, 159, 162, 159, 160, 160, 34, 160, 159, 161, 34, 161, 159, 159, 22, 162, 150, 162, 147,
	159, 147, 159, 150, 160, 22, 160, 147, 161, 22, 161, 147, 159, 10, 159, 135, 162, 135, 162, 138,
	159, 138, 160, 10, 160, 135, 161, 10, 161, 135, 159, 126, 162, 254, 162, 251, 159, 251, 159, 254,
	160, 126, 160, 251, 161, 126, 161, 251, 164, 40, 164, 165, 167, 165, 167, 168, 164, 168, 164, 166,
	165, 40, 165, 165, 166, 40, 166, 165, 164, 28, 167, 156, 167, 153, 164, 153, 164, 156, 165, 28, 165,
	153, 166, 28, 166, 153, 164, 16, 164, 141, 167, 141, 167, 144, 164, 144, 165, 16, 165, 141, 166, 16,
	166, 141, 164, 4, 167, 132, 167, 129, 164, 129, 164, 132, 165, 4, 165, 129, 166, 4, 166, 129, 167, 0,
	0, 0, 129, 41, 132, 169, 132, 166, 129, 166, 129, 169, 130, 41, 130, 166, 131, 41, 131, 166, 129,
	29, 132, 157, 132, 154, 129, 154, 129, 157, 130, 29, 130, 154, 131, 29, 131, 154, 129, 17, 129,
	142, 132, 142, 132, 145, 129, 145, 130, 17, 130, 142, 131, 17, 131, 142, 129, 5, 132, 133, 132, 130,
	129, 130, 129, 133, 130, 5, 130, 130, 131, 5, 131, 130, 132, 41, 135, 169, 135, 166, 132, 166, 132,
	169, 133, 41, 133, 166, 134, 41, 134, 166, 132, 29, 135, 157, 135, 154, 132, 154, 132, 157, 133, 29,
	133, 154, 134, 29, 134, 154, 132, 17, 132, 142, 135, 142, 135, 145, 132, 145, 133, 17, 133, 142,
	134, 17, 134, 142, 132, 5, 135, 133, 135, 130, 132, 130, 132, 133, 133, 5, 133, 130, 134, 5, 134,
	130, 135, 35, 138, 163, 138, 160, 135, 160, 135, 163, 136, 35, 136, 160, 137, 35, 137, 160, 135, 11,
	135, 136, 138, 136, 138, 139, 135, 139, 136, 11, 136, 136, 137, 11, 137, 136, 138, 35, 141, 163,
	141, 160, 138, 160, 138, 163, 139, 35, 139, 160, 140, 35, 140, 160, 138, 11, 138, 136, 141, 136,
	141, 139, 138, 139, 139, 11, 139, 136, 140, 11, 140, 136, 141, 35, 144, 163, 144, 160, 141, 160,
	141, 163, 142, 35, 142, 160, 143, 35, 143, 160, 141, 11, 141, 136, 144, 136, 144, 139, 141, 139,
	142, 11, 142, 136, 143, 11, 143, 136, 144, 41, 147, 169, 147, 166, 144, 166, 144, 169, 145, 41, 145,
	166, 146, 41, 146, 166, 144, 29, 147, 157, 147, 154, 144, 154, 144, 157, 145, 29, 145, 154, 146, 29,
	146, 154, 144, 17, 144, 142, 147, 142, 147, 145, 144, 145, 145, 17, 145, 142, 146, 17, 146, 142,
	144, 5, 147, 133, 147, 130, 144, 130, 144, 133, 145, 5, 145, 130, 146, 5, 146, 130, 147, 41, 150,
	169, 150, 166, 147, 166, 147, 169, 148, 41, 148, 166, 149, 41, 149, 166, 147, 29, 150, 157, 150,
	154, 147, 154, 147, 157, 148, 29, 148, 154, 149, 29, 149, 154, 147, 17, 147, 142, 150, 142, 150,
	145, 147, 145, 148, 17, 148, 142, 149, 17, 149, 142, 147, 5, 150, 133, 150, 130, 147, 130, 147, 133,
	148, 5, 148, 130, 149, 5, 149, 130, 150, 127, 153, 255, 153, 252, 150, 252, 150, 255, 151, 127, 151,
	252, 152, 127, 152, 252, 153, 127, 156, 255, 156, 252, 153, 252, 153, 255, 154, 127, 154, 252, 155,
	127, 155, 252, 156, 127, 159, 255, 159, 252, 156, 252, 156, 255, 157, 127, 157, 252, 158, 127, 158,
	252, 159, 41, 162, 169, 162, 166, 159, 166, 159, 169, 160, 41, 160, 166, 161, 41, 161, 166, 159, 29,
	162, 157, 162, 154, 159, 154, 159, 157, 160, 29, 160, 154, 161, 29, 161, 154, 159, 17, 159, 142,
	162, 142, 162, 145, 159, 145, 160, 17, 160, 142, 161, 17, 161, 142, 159, 5, 162, 133, 162, 130, 159,
	130, 159, 133, 160, 5, 160, 130, 161, 5, 161, 130, 162, 41, 165, 169, 165, 166, 162, 166, 162, 169,
	163, 41, 163, 166, 164, 41, 164, 166, 162, 29, 165, 157, 165, 154, 162, 154, 162, 157, 163, 29, 163,
	154, 164, 29, 164, 154, 162, 17, 162, 142, 165, 142, 165, 145, 162, 145, 163, 17, 163, 142, 164, 17,
	164, 142, 162, 5, 165, 133, 165, 130, 162, 130, 162, 133, 163, 5, 163, 130, 164, 5, 164, 130, 156,
	35, 159, 163, 159, 160, 156, 160, 156, 163, 157, 35, 157, 160, 158, 35, 158, 160, 159, 35, 162,
	163, 162, 160, 159, 160, 159, 163, 160, 35, 160, 160, 161, 35, 161, 160, 162, 35, 165, 163, 165,
	160, 162, 160, 162, 163, 163, 35, 163, 160, 164, 35, 164, 160, 129, 23, 132, 151, 132, 148, 129,
	148, 129, 151, 130, 23, 130, 148, 131, 23, 131, 148, 132, 23, 135, 151, 135, 148, 132, 148, 132,
	151, 133, 23, 133, 148, 134, 23, 134, 148, 135, 23, 138, 151, 138, 148, 135, 148, 135, 151, 136, 23,
	136, 148, 137, 23, 137, 148, 150, 23, 153, 151, 153, 148, 150, 148, 150, 151, 151, 23, 151, 148,
	152, 23, 152, 148, 153, 23, 156, 151, 156, 148, 153, 148, 153, 151, 154, 23, 154, 148, 155, 23, 155,
	148, 159, 23, 159, 148, 156, 148, 156, 151, 159, 151, 157, 23, 157, 148, 158, 23, 158, 148, 156, 11,
	156, 136, 159, 136, 159, 139, 156, 139, 157, 11, 157, 136, 158, 11, 158, 136, 159, 11, 159, 136,
	162, 136, 162, 139, 159, 139, 160, 11, 160, 136, 161, 11, 161, 136, 162, 11, 162, 136, 165, 136,
	165, 139, 162, 139, 163, 11, 163, 136, 164, 11, 164, 136, 129, 127, 132, 255, 132, 252, 129, 252,
	129, 255, 130, 127, 130, 252, 131, 127, 131, 252, 132, 127, 135, 255, 135, 252, 132, 252, 132, 255,
	133, 127, 133, 252, 134, 127, 134, 252, 135, 127, 138, 255, 138, 252, 135, 252, 135, 255, 136, 127,
	136, 252, 137, 127, 137, 252, 165, 0, 0, 0, 128, 40, 136, 168, 136, 247, 128, 247, 128, 168, 141, 0,
	0, 0, 141, 40, 149, 168, 149, 247, 141, 247, 141, 142, 128, 142, 128, 148, 141, 148, 141, 168,
	156, 0, 0, 0, 141, 40, 149, 168, 149, 247, 141, 247, 141, 142, 128, 142, 128, 148, 141, 148, 141,
	152, 128, 152, 128, 158, 141, 158, 141, 168, 155, 0, 0, 0, 141, 40, 149, 168, 149, 247, 141, 247,
	141, 142, 128, 142, 128, 148, 141, 148, 141, 168, 154, 40, 162, 168, 162, 247, 154, 247, 154, 168,
	166, 0, 0, 0, 128, 20, 162, 148, 162, 247, 154, 247, 154, 142, 149, 142, 149, 247, 141, 247, 141,
	142, 128, 142, 128, 148, 167, 0, 0, 0, 128, 30, 149, 158, 149, 247, 141, 247, 141, 142, 128, 142,
	128, 148, 141, 148, 141, 152, 128, 152, 128, 158, 155, 0, 0, 0, 155, 40, 162, 168, 162, 247, 154,
	247, 154, 168, 155, 168, 141, 24, 128, 152, 128, 158, 141, 158, 141, 168, 149, 168, 149, 152, 141,
	152, 149, 119, 141, 247, 141, 142, 128, 142, 128, 148, 149, 148, 149, 247, 168, 0, 0, 0, 128, 40,
	136, 168, 136, 247, 128, 247, 128, 168, 141, 40, 149, 168, 149, 247, 141, 247, 141, 168, 156, 0, 0,
	0, 162, 20, 162, 247, 154, 247, 154, 152, 128, 152, 128, 158, 162, 158, 162, 148, 149, 14, 149,
	247, 141, 247, 141, 142, 128, 142, 128, 148, 149, 148, 149, 142, 170, 0, 0, 0, 154, 39, 154, 148,
	128, 148, 128, 142, 162, 142, 162, 168, 154, 168, 154, 167, 141, 37, 141, 158, 128, 158, 128, 152,
	149, 152, 149, 168, 141, 168, 141, 165, 168, 0, 0, 0, 154, 39, 154, 148, 149, 148, 149, 168, 141,
	168, 141, 148, 128, 148, 128, 142, 162, 142, 162, 168, 154, 168, 154, 167, 168, 0, 0, 0, 128, 20,
	128, 142, 149, 142, 149, 168, 141, 168, 141, 158, 128, 158, 128, 152, 141, 152, 141, 148, 128, 148,
	154, 0, 0, 0, 128, 20, 149, 148, 149, 247, 141, 247, 141, 142, 128, 142, 128, 148, 128, 0, 0, 0, 149,
	14, 128, 142, 128, 168, 136, 168, 136, 148, 149, 148, 149, 142, 149, 0, 0, 0, 141, 14, 162, 142,
	162, 148, 149, 148, 149, 168, 141, 168, 141, 148, 128, 148, 128, 142, 149, 142, 162, 0, 0, 0, 141,
	20, 162, 148, 162, 142, 149, 142, 149, 250, 141, 250, 141, 142, 128, 142, 128, 148, 149, 148, 162,
	0, 0, 0, 136, 40, 128, 168, 128, 247, 136, 247, 136, 142, 149, 142, 149, 148, 136, 148, 136, 168,
	149, 0, 0, 0, 128, 20, 162, 148, 162, 142, 128, 142, 128, 148, 162, 0, 0, 0, 141, 40, 149, 168, 149,
	148, 162, 148, 162, 142, 149, 142, 149, 247, 141, 247, 141, 142, 128, 142, 128, 148, 141, 148, 141,
	168, 162, 0, 0, 0, 136, 40, 128, 168, 128, 247, 136, 247, 136, 142, 149, 142, 149, 148, 136, 148,
	136, 152, 149, 152, 149, 158, 136, 158, 136, 168, 149, 0, 0, 0, 149, 40, 141, 168, 141, 247, 149,
	247, 149, 142, 162, 142, 162, 148, 149, 148, 149, 168, 136, 40, 128, 168, 128, 247, 136, 247, 136,
	168, 162, 0, 0, 0, 136, 39, 136, 148, 162, 148, 162, 142, 128, 142, 128, 168, 136, 168, 136, 167,
	149, 37, 149, 158, 162, 158, 162, 152, 141, 152, 141, 168, 149, 168, 149, 165, 162, 0, 0, 0, 128, 20,
	128, 247, 136, 247, 136, 152, 162, 152, 162, 158, 128, 158, 128, 148, 141, 14, 141, 247, 149, 247,
	149, 142, 162, 142, 162, 148, 141, 148, 141, 142, 162, 0, 0, 0, 162, 20, 128, 148, 128, 142, 162,
	142, 162, 148, 148, 24, 148, 168, 156, 168, 156, 158, 162, 158, 162, 152, 148, 152, 134, 37, 134,
	158, 128, 158, 128, 152, 142, 152, 142, 168, 134, 168, 134, 165, 162, 0, 0, 0, 162, 24, 128, 152,
	128, 158, 162, 158, 162, 152, 148, 20, 148, 247, 156, 247, 156, 142, 162, 142, 162, 148, 148, 148,
	134, 7, 134, 142, 128, 142, 128, 148, 142, 148, 142, 247, 134, 247, 134, 135, 162, 0, 0, 0, 135, 40,
	128, 168, 128, 247, 136, 247, 136, 168, 135, 168, 149, 24, 162, 152, 162, 158, 149, 158, 149, 168,
	141, 168, 141, 152, 149, 152, 141, 119, 149, 247, 149, 142, 162, 142, 162, 148, 141, 148, 141, 247,
	162, 0, 0, 0, 128, 20, 162, 148, 162, 142, 128, 142, 128, 148, 128, 24, 162, 152, 162, 158, 128, 158,
	128, 152, 162, 0, 0, 0, 148, 24, 148, 168, 156, 168, 156, 158, 162, 158, 162, 152, 148, 152, 134, 37,
	134, 158, 128, 158, 128, 152, 142, 152, 142, 168, 134, 168, 134, 165, 148, 20, 148, 247, 156, 247,
	156, 142, 162, 142, 162, 148, 148, 148, 134, 14, 128, 142, 128, 148, 142, 148, 142, 247, 134, 247,
	134, 142, 162, 0, 0, 0, 128, 20, 162, 148, 162, 142, 128, 142, 128, 148, 149, 24, 162, 152, 162, 158,
	149, 158, 149, 168, 141, 168, 141, 158, 128, 158, 128, 152, 162, 152, 162, 158, 162, 0, 0, 0, 154,
	39, 154, 148, 149, 148, 149, 168, 141, 168, 141, 148, 128, 148, 128, 142, 167, 142, 167, 148, 162,
	148, 162, 168, 154, 168, 154, 167, 167, 0, 0, 0, 128, 24, 162, 152, 162, 158, 128, 158, 128, 152,
	149, 20, 162, 148, 162, 142, 149, 142, 149, 247, 141, 247, 141, 142, 128, 142, 128, 148, 162, 148,
	162, 142, 162, 0, 0, 0, 154, 123, 154, 142, 149, 142, 149, 247, 141, 247, 141, 142, 128, 142, 128,
	148, 167, 148, 167, 142, 162, 142, 162, 247, 154, 247, 154, 251, 167, 0, 0, 0, 136, 39, 136, 148,
	141, 148, 141, 168, 149, 168, 149, 148, 162, 148, 162, 142, 128, 142, 128, 168, 136, 168, 136, 167,
	162, 0, 0, 0, 149, 20, 149, 142, 128, 142, 128, 168, 136, 168, 136, 158, 149, 158, 149, 152, 136,
	152, 136, 148, 149, 148, 149, 0, 0, 0, 149, 30, 128, 158, 128, 247, 136, 247, 136, 142, 149, 142,
	149, 148, 136, 148, 136, 152, 149, 152, 149, 158, 149, 0, 0, 0, 162, 20, 128, 148, 128, 247, 136,
	247, 136, 142, 141, 142, 141, 247, 149, 247, 149, 142, 162, 142, 162, 148, 162, 0, 0, 0, 128, 20,
	134, 148, 134, 168, 142, 168, 142, 148, 147, 148, 147, 168, 155, 168, 155, 148, 161, 148, 161, 142,
	155, 142, 155, 247, 147, 247, 147, 142, 142, 142, 142, 247, 134, 247, 134, 142, 128, 142, 128, 148,
	161, 0, 0, 0, 140, 121, 140, 142, 128, 142, 128, 148, 140, 148, 140, 152, 128, 152, 128, 158, 140,
	158, 140, 168, 148, 168, 148, 158, 160, 158, 160, 152, 148, 152, 148, 148, 160, 148, 160, 142, 148,
	142, 148, 247, 140, 247, 140, 253, 140, 2, 140, 140, 160, 0, 0, 0, 149, 40, 149, 142, 128, 142, 128,
	148, 141, 148, 141, 168, 149, 168, 154, 0, 0, 0, 128, 122, 128, 148, 149, 148, 149, 142, 136, 142,
	136, 247, 128, 247, 128, 250, 149, 0, 0, 0, 128, 0, 157, 128, 157, 177, 128, 177, 128, 128, 156, 49,
	156, 128, 155, 49, 155, 128, 154, 49, 154, 128, 153, 49, 153, 128, 152, 49, 152, 128, 151, 49, 151,
	128, 150, 49, 150, 128, 149, 49, 149, 128, 148, 49, 148, 128, 147, 49, 147, 128, 146, 49, 146, 128,
	145, 49, 145, 128, 144, 49, 144, 128, 143, 49, 143, 128, 142, 49, 142, 128, 141, 49, 141, 128, 140,
	49, 140, 128, 139, 49, 139, 128, 138, 49, 138, 128, 137, 49, 137, 128, 136, 49, 136, 128, 135, 49,
	135, 128, 134, 49, 134, 128, 133, 49, 133, 128, 132, 49, 132, 128, 131, 49, 131, 128, 130, 49, 130,
	128, 129, 49, 129, 128, 164, 0, 0, 0, 128, 24, 157, 152, 157, 128, 128, 128, 128, 152, 129, 24, 129,
	128, 130, 24, 130, 128, 131, 24, 131, 128, 132, 24, 132, 128, 133, 24, 133, 128, 134, 24, 134, 128,
	135, 24, 135, 128, 136, 24, 136, 128, 137, 24, 137, 128, 138, 24, 138, 128, 139, 24, 139, 128, 140,
	24, 140, 128, 141, 24, 141, 128, 143, 24, 143, 128, 144, 24, 144, 128, 145, 24, 145, 128, 146, 24,
	146, 128, 147, 24, 147, 128, 148, 24, 148, 128, 149, 24, 149, 128, 150, 24, 150, 128, 151, 24, 151,
	128, 152, 24, 152, 128, 153, 24, 153, 128, 154, 24, 154, 128, 155, 24, 155, 128, 156, 24, 156, 128,
	142, 24, 142, 128, 164, 0, 0, 0, 128, 49, 142, 177, 142, 128, 128, 128, 128, 177, 129, 49, 129, 128,
	130, 49, 130, 128, 131, 49, 131, 128, 132, 49, 132, 128, 133, 49, 133, 128, 134, 49, 134, 128, 136,
	49, 136, 128, 137, 49, 137, 128, 138, 49, 138, 128, 139, 49, 139, 128, 140, 49, 140, 128, 141, 49,
	141, 128, 142, 49, 142, 128, 135, 49, 135, 128, 142, 0, 0, 0, 142, 49, 156, 177, 156, 128, 142, 128,
	142, 177, 143, 49, 143, 128, 144, 49, 144, 128, 145, 49, 145, 128, 146, 49, 146, 128, 147, 49, 147,
	128, 148, 49, 148, 128, 150, 49, 150, 128, 151, 49, 151, 128, 152, 49, 152, 128, 153, 49, 153, 128,
	154, 49, 154, 128, 155, 49, 155, 128, 156, 49, 156, 128, 149, 49, 149, 128, 156, 0, 0, 0, 128, 49,
	157, 177, 157, 153, 128, 153, 128, 177, 129, 49, 129, 153, 130, 49, 130, 153, 131, 49, 131, 153,
	132, 49, 132, 153, 133, 49, 133, 153, 134, 49, 134, 153, 135, 49, 135, 153, 136, 49, 136, 153, 137,
	49, 137, 153, 138, 49, 138, 153, 139, 49, 139, 153, 140, 49, 140, 153, 141, 49, 141, 153, 143, 49,
	143, 153, 144, 49, 144, 153, 145, 49, 145, 153, 146, 49, 146, 153, 147, 49, 147, 153, 148, 49, 148,
	153, 149, 49, 149, 153, 150, 49, 150, 153, 151, 49, 151, 153, 152, 49, 152, 153, 153, 49, 153, 153,
	154, 49, 154, 153, 155, 49, 155, 153, 156, 49, 156, 153, 142, 49, 142, 153, 157, 0, 0, 0, 149, 24,
	148, 154, 146, 156, 144, 157, 141, 158, 138, 158, 135, 157, 133, 156, 131, 154, 130, 152, 129, 149,
	128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 129,
	146, 130, 148, 132, 149, 135, 152, 128, 158, 128, 152, 144, 158, 158, 152, 158, 149, 152, 144, 10,
	143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152,
	141, 152, 143, 151, 146, 143, 144, 138, 161, 0, 0, 0, 146, 1, 150, 131, 152, 133, 152, 138, 149, 140,
	144, 141, 149, 142, 152, 144, 152, 149, 150, 151, 146, 153, 133, 153, 129, 149, 129, 251, 134, 251,
	134, 129, 146, 129, 134, 6, 135, 133, 144, 133, 146, 134, 146, 137, 144, 138, 134, 138, 134, 134,
	134, 20, 135, 149, 144, 149, 146, 148, 146, 145, 144, 144, 134, 144, 134, 148, 156, 0, 0, 0, 128, 22,
	128, 128, 134, 128, 134, 158, 151, 158, 151, 155, 157, 155, 157, 163, 128, 163, 128, 149, 160, 0, 0,
	0, 128, 35, 155, 163, 155, 158, 150, 158, 150, 128, 144, 128, 144, 158, 139, 158, 139, 128, 133,
	128, 133, 158, 128, 158, 128, 163, 161, 0, 0, 0, 128, 30, 128, 166, 130, 168, 155, 168, 157, 166,
	157, 159, 151, 159, 151, 161, 150, 162, 135, 162, 134, 161, 134, 160, 148, 149, 148, 147, 134, 136,
	134, 135, 135, 134, 150, 134, 151, 135, 151, 137, 157, 137, 157, 130, 155, 128, 130, 128, 128, 130,
	128, 138, 140, 148, 128, 158, 164, 0, 0, 0, 142, 15, 142, 139, 141, 136, 139, 134, 137, 134, 135,
	136, 134, 139, 134, 148, 135, 151, 137, 153, 139, 153, 141, 151, 142, 148, 142, 143, 156, 30, 135,
	158, 132, 157, 128, 153, 128, 137, 130, 131, 132, 129, 134, 128, 142, 128, 144, 129, 146, 131, 148,
	137, 148, 152, 149, 153, 158, 153, 158, 158, 156, 158, 161, 0, 0, 0, 138, 0, 146, 128, 148, 129, 150,
	131, 152, 137, 152, 158, 146, 158, 146, 137, 145, 135, 143, 134, 141, 134, 139, 136, 138, 139, 138,
	158, 132, 158, 132, 255, 131, 251, 129, 249, 135, 249, 138, 253, 138, 128, 134, 121, 135, 249, 155,
	0, 0, 0, 141, 22, 141, 250, 148, 250, 148, 145, 158, 158, 151, 158, 146, 151, 146, 154, 145, 156,
	143, 158, 133, 158, 130, 157, 128, 154, 128, 149, 134, 149, 134, 151, 135, 152, 140, 152, 141, 151,
	141, 150, 162, 0, 0, 0, 144, 3, 146, 132, 148, 134, 149, 136, 150, 139, 151, 143, 150, 147, 149, 150,
	148, 152, 146, 154, 142, 156, 142, 160, 151, 160, 151, 165, 128, 165, 128, 160, 137, 160, 137, 156,
	133, 154, 131, 152, 130, 150, 129, 147, 128, 143, 129, 139, 130, 136, 131, 134, 133, 132, 137, 130,
	137, 254, 128, 254, 128, 249, 151, 249, 151, 254, 142, 254, 142, 130, 144, 131, 144, 11, 143, 137,
	141, 136, 138, 136, 136, 137, 135, 139, 134, 143, 135, 147, 136, 149, 138, 150, 141, 150, 143, 149,
	144, 147, 145, 143, 144, 139, 157, 0, 0, 0, 133, 3, 131, 135, 128, 144, 128, 150, 129, 155, 131, 160,
	133, 164, 136, 167, 144, 167, 147, 164, 149, 160, 151, 155, 152, 150, 152, 145, 151, 140, 149, 135,
	147, 131, 144, 128, 136, 128, 133, 131, 137, 36, 134, 157, 132, 149, 148, 149, 146, 157, 143, 164,
	137, 164, 136, 39, 133, 164, 131, 160, 129, 155, 128, 150, 137, 3, 134, 138, 132, 146, 148, 146,
	146, 138, 143, 131, 137, 131, 148, 18, 132, 146, 155, 0, 0, 0, 144, 32, 142, 163, 138, 163, 136, 160,
	134, 153, 133, 149, 133, 144, 134, 141, 137, 138, 137, 128, 128, 128, 128, 132, 132, 132, 132, 137,
	129, 140, 128, 145, 128, 150, 129, 155, 131, 160, 133, 164, 136, 167, 138, 168, 143, 168, 147, 164,
	149, 160, 151, 155, 152, 150, 152, 145, 151, 140, 148, 137, 148, 132, 152, 132, 152, 128, 143, 128,
	143, 138, 146, 141, 147, 144, 147, 149, 146, 153, 144, 160, 145, 157, 135, 29, 136, 160, 142, 35,
	138, 163, 164, 0, 0, 0, 142, 0, 141, 128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 151, 141,
	150, 145, 149, 148, 148, 150, 147, 153, 143, 161, 141, 164, 151, 164, 151, 168, 149, 168, 150, 40,
	133, 168, 140, 154, 138, 154, 135, 153, 133, 152, 131, 150, 130, 148, 129, 145, 128, 141, 129, 137,
	130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141, 128, 144, 9, 143, 135, 141, 134, 138, 134,
	136, 135, 135, 137, 134, 141, 135, 145, 136, 147, 138, 148, 141, 148, 143, 147, 144, 145, 145, 141,
	144, 137, 139, 26, 140, 154, 149, 20, 150, 145, 144, 17, 143, 147, 141, 148, 138, 148, 136, 147,
	135, 145, 157, 0, 0, 0, 128, 13, 129, 137, 130, 134, 131, 132, 133, 130, 135, 129, 138, 128, 141,
	128, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 151, 134, 152, 132, 154, 130, 156, 129, 159,
	128, 162, 128, 165, 129, 167, 130, 169, 132, 170, 134, 171, 137, 172, 141, 171, 145, 170, 148, 169,
	150, 167, 152, 165, 153, 162, 154, 159, 154, 156, 153, 154, 152, 152, 150, 151, 148, 150, 145, 149,
	148, 148, 150, 146, 152, 144, 153, 141, 154, 138, 154, 135, 153, 133, 152, 131, 150, 130, 148, 129,
	145, 128, 141, 144, 9, 143, 135, 141, 134, 138, 134, 136, 135, 135, 137, 134, 141, 135, 145, 136,
	147, 138, 148, 141, 148, 143, 147, 144, 145, 145, 141, 144, 137, 165, 9, 164, 135, 162, 134, 159,
	134, 157, 135, 156, 137, 155, 141, 156, 145, 157, 147, 159, 148, 162, 148, 164, 147, 165, 145, 166,
	141, 165, 137, 175, 0, 0, 0, 141, 0, 144, 129, 146, 130, 148, 132, 149, 134, 150, 137, 151, 141, 151,
	145, 150, 149, 149, 152, 148, 153, 152, 159, 147, 159, 145, 156, 144, 157, 141, 158, 138, 158, 135,
	157, 133, 156, 131, 154, 130, 152, 129, 149, 128, 145, 128, 141, 129, 137, 130, 134, 131, 132, 128,
	254, 133, 254, 135, 129, 138, 128, 141, 128, 145, 17, 145, 141, 144, 137, 143, 135, 141, 134, 138,
	134, 144, 146, 145, 147, 145, 145, 135, 9, 134, 141, 134, 145, 135, 149, 136, 151, 138, 152, 141,
	152, 143, 151, 142, 23, 135, 138, 157, 0, 0, 0, 145, 6, 140, 134, 138, 135, 136, 138, 135, 141, 134,
	145, 147, 145, 147, 151, 134, 151, 135, 155, 136, 158, 138, 161, 140, 162, 147, 162, 147, 168, 138,
	168, 135, 167, 133, 165, 131, 162, 129, 157, 128, 152, 128, 144, 129, 139, 131, 134, 133, 131, 135,
	129, 138, 128, 147, 128, 147, 134, 145, 134, 153, 0, 0, 0, 128, 30, 128, 128, 135, 128, 135, 154,
	136, 158, 137, 159, 140, 160, 142, 160, 144, 159, 145, 158, 146, 154, 146, 128, 153, 128, 153, 157,
	152, 161, 150, 165, 149, 166, 146, 167, 141, 168, 139, 168, 135, 167, 132, 166, 130, 164, 128, 158,
	160, 0, 0, 0, 128, 35, 150, 163, 150, 157, 128, 157, 128, 163, 150, 163, 128, 6, 128, 128, 150, 128,
	150, 134, 128, 134, 150, 14, 128, 142, 128, 148, 150, 148, 150, 142, 155, 0, 0, 0, 150, 0, 128, 128,
	128, 134, 150, 134, 150, 128, 135, 10, 135, 148, 128, 148, 128, 158, 135, 158, 135, 168, 143, 168,
	143, 158, 150, 158, 150, 148, 143, 148, 143, 138, 135, 138, 156, 0, 0, 0, 150, 0, 128, 128, 128, 134,
	150, 134, 150, 128, 128, 12, 128, 139, 145, 154, 128, 168, 135, 168, 150, 155, 150, 153, 135, 139,
	128, 139, 128, 41, 128, 168, 155, 0, 0, 0, 128, 0, 150, 128, 150, 134, 128, 134, 128, 128, 150, 11,
	133, 154, 150, 168, 143, 168, 128, 155, 128, 153, 143, 139, 150, 139, 155, 0, 0, 0, 159, 40, 150,
	168, 146, 160, 146, 249, 152, 249, 152, 161, 154, 165, 160, 165, 162, 161, 167, 161, 167, 164, 165,
	168, 158, 168, 171, 0, 0, 0, 139, 121, 147, 249, 152, 129, 152, 168, 146, 168, 146, 128, 144, 252,
	138, 252, 136, 128, 131, 128, 131, 253, 133, 249, 140, 249, 159, 0, 0, 0, 128, 25, 150, 153, 150,
	143, 128, 143, 128, 153, 136, 32, 136, 168, 142, 168, 142, 160, 136, 160, 139, 13, 139, 141, 136, 0,
	136, 136, 142, 136, 142, 128, 136, 128, 157, 0, 0, 0, 130, 17, 138, 153, 145, 146, 153, 152, 155,
	150, 145, 142, 138, 149, 132, 143, 130, 145, 130, 5, 138, 141, 145, 134, 153, 140, 155, 138, 145,
	130, 138, 137, 132, 131, 130, 133, 156, 0, 0, 0, 138, 25, 137, 151, 135, 150, 132, 150, 130, 151,
	129, 153, 128, 157, 128, 161, 129, 165, 130, 167, 132, 168, 135, 168, 137, 167, 138, 165, 139, 161,
	139, 157, 138, 153, 136, 35, 137, 160, 137, 157, 136, 154, 135, 152, 133, 152, 132, 153, 130, 157,
	130, 160, 132, 166, 135, 166, 136, 163, 144, 0, 0, 0, 128, 0, 128, 137, 134, 137, 134, 128, 128, 128,
	138, 0, 0, 0, 134, 0, 128, 128, 128, 132, 134, 132, 134, 128, 138, 0, 0, 0, 153, 0, 153, 171, 164, 171,
	164, 177, 145, 177, 145, 140, 136, 155, 128, 155, 145, 128, 153, 128, 229, 121, 229, 243, 166, 0, 0,
	0, 142, 19, 142, 166, 140, 168, 136, 168, 134, 166, 134, 147, 128, 147, 128, 173, 134, 173, 134,
	171, 136, 173, 141, 173, 144, 172, 146, 170, 148, 166, 148, 147, 142, 147, 145, 19, 148, 147, 128,
	19, 134, 147, 153, 0, 0, 0, 128, 27, 130, 156, 139, 162, 140, 164, 139, 165, 137, 165, 135, 164,
	133, 162, 129, 162, 131, 166, 135, 168, 141, 168, 144, 166, 144, 162, 141, 159, 132, 154, 144, 154,
	144, 151, 128, 151, 128, 155, 149, 0, 0, 0, 143, 24, 143, 128, 128, 128, 128, 152, 143, 152, 129, 24,
	129, 128, 130, 24, 130, 128, 131, 24, 131, 128, 132, 24, 132, 128, 133, 24, 133, 128, 134, 24, 134,
	128, 135, 24, 135, 128, 136, 24, 136, 128, 137, 24, 137, 128, 138, 24, 138, 128, 139, 24, 139, 128,
	140, 24, 140, 128, 141, 24, 141, 128, 142, 24, 142, 128, 150, 0, 0, 0, 168, 0, 0, 0
};

static const int           stroke_mults[11] = {1, 3, 2, 3, 1, 4, 5, 2, 5, 3, 4};
static const int           stroke_divs[11] = {1, 5, 3, 4, 1, 3, 3, 1, 2, 1, 1};

static const char          low_char[256] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
	1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

struct metric {
	unsigned top;  // Scan lines from TOP OF CELL to char top
	unsigned bow;  // Scan lines from TOC to crest of char
	unsigned base; // Scan lines from TOC to baseline
	unsigned drop; // Scan lines from TOC to lowermost pixel
};

static const struct                metric font_metrics[11][10] = {
#if 0 // These are from the doc and are wrong
        // This one is certainly wrong since we use a different font.
	{
		{0, 2, 6, 7},
		{0, 4, 13, 15},
		{0, 6, 20, 23},
		{0, 8, 27, 31},
		{0, 10, 34, 39},
		{0, 12, 41, 47},
		{0, 14, 48, 55},
		{0, 16, 55, 63},
		{0, 18, 62, 71},
		{0, 20, 69, 79}
	},

        // Triplex
	{
		{6, 10, 18, 22},
		{6, 11, 20, 24},
		{8, 13, 23, 28},
		{10, 17, 31, 38},
		{13, 23, 41, 50},
		{16, 28, 51, 62},
		{20, 34, 62, 76},
		{25, 42, 77, 94},
		{30, 51, 93, 114},
		{40, 67, 124, 152}
	},

        // Small (Top, Bow, Base, Drop)
	{
		{2, 3, 5, 6},
		{2, 4, 6, 7},
		{2, 3, 6, 7},
		{3, 5, 9, 11},
		{4, 7, 12, 14},
		{5, 9, 15, 18},
		{6, 10, 13, 22},  //
		{7, 12, 22, 27},
		{9, 15, 27, 33},
		{12, 20, 36, 44}
	},

	{
		{7, 11, 19, 23},
		{7, 12, 21, 25},
		{9, 14, 24, 29},
		{11, 18, 32, 39},
		{14, 24, 42, 51},
		{18, 30, 53, 64},
		{22, 36, 64, 78},
		{28, 45, 80, 97},
		{33, 54, 96, 117},
		{74, 102, 158, 186}
	},

	{
		{7, 11, 19, 23},
		{7, 12, 21, 25},
		{9, 14, 24, 29},
		{11, 18, 32, 39},
		{14, 24, 42, 51},
		{18, 30, 53, 64},
		{22, 36, 64, 78},
		{28, 45, 80, 97},
		{33, 54, 96, 117},
		{44, 72, 128, 156}
	},

	{
		{10, 17, 22, 29},
		{10, 18, 24, 32},
		{12, 21, 27, 36},
		{16, 28, 37, 49},
		{21, 37, 49, 65},
		{26, 46, 61, 80},
		{32, 56, 74, 98},
		{40, 70, 92, 122},
		{48, 84, 111, 147},
		{63, 111, 147, 195}
	},

	{
		{9, 13, 21, 25},
		{9, 14, 23, 27},
		{11, 16, 26, 31},
		{14, 21, 35, 42},
		{18, 28, 46, 56},
		{23, 35, 58, 69},
		{28, 42, 70, 84},
		{35, 52, 87, 104},
		{42, 63, 105, 126},
		{56, 84, 140, 168}
	},

	{
		{5, 9, 17, 21},
		{5, 10, 19, 23},
		{7, 12, 22, 27},
		{9, 16, 30, 37},
		{12, 22, 40, 49},
		{15, 27, 50, 61},
		{19, 33, 61, 75},
		{24, 41, 77, 93},
		{29, 50, 92, 113},
		{39, 67, 123, 151}
	},

	{
		{8, 12, 20, 24},
		{8, 13, 22, 26},
		{10, 15, 25, 30},
		{13, 20, 34, 41},
		{17, 27, 45, 54},
		{22, 34, 57, 68},
		{27, 41, 69, 83},
		{34, 51, 86, 103},
		{41, 62, 104, 125},
		{54, 83, 139, 167}
	},

	{
		{7, 14, 32, 38},
		{7, 15, 35, 41},
		{9, 18, 40, 47},
		{12, 24, 54, 64},
		{16, 32, 72, 85},
		{20, 40, 96, 106},
		{25, 49, 109, 129},
		{31, 61, 136, 161},
		{38, 74, 164, 194},
		{51, 99, 219, 259}
	},

	{
		{11, 17, 35, 39},
		{13, 19, 39, 43},
		{14, 22, 44, 49},
		{19, 29, 59, 66},
		{27, 39, 79, 88},
		{33, 49, 99, 110},
		{39, 59, 119, 133},
		{49, 74, 149, 166},
		{59, 89, 179, 200},
		{79, 199, 239, 267}
	},
#else /* if 0 */
        // These are from the EXE and there's still weirdness (such as size 7 in small)
	{
		{0x00, 0x02, 0x06, 0x07},
		{0x00, 0x04, 0x0D, 0x0F},
		{0x00, 0x06, 0x14, 0x17},
		{0x00, 0x08, 0x1B, 0x1F},
		{0x00, 0x0A, 0x22, 0x27},
		{0x00, 0x0C, 0x29, 0x2F},
		{0x00, 0x0E, 0x30, 0x37},
		{0x00, 0x10, 0x37, 0x3F},
		{0x00, 0x12, 0x3E, 0x47},
		{0x00, 0x14, 0x45, 0x4F}
	},

	{
		{0x06, 0x0A, 0x12, 0x16},
		{0x06, 0x0B, 0x14, 0x18},
		{0x08, 0x0D, 0x17, 0x1C},
		{0x0A, 0x11, 0x1F, 0x26},
		{0x0D, 0x17, 0x29, 0x32},
		{0x10, 0x1C, 0x33, 0x3E},
		{0x14, 0x22, 0x3E, 0x4C},
		{0x19, 0x2A, 0x4D, 0x5E},
		{0x1E, 0x33, 0x5D, 0x72},
		{0x28, 0x43, 0x7C, 0x98}
	},

	{
		{0x02, 0x03, 0x05, 0x06},
		{0x02, 0x04, 0x06, 0x07},
		{0x02, 0x03, 0x06, 0x07},
		{0x03, 0x05, 0x09, 0x0B},
		{0x04, 0x07, 0x0C, 0x0E},
		{0x05, 0x09, 0x0F, 0x12},
		{0x06, 0x0A, 0x0D, 0x16},
		{0x07, 0x0C, 0x16, 0x1B},
		{0x09, 0x0F, 0x1B, 0x21},
		{0x0C, 0x14, 0x24, 0x2C}
	},

	{
		{0x07, 0x0B, 0x13, 0x17},
		{0x07, 0x0C, 0x15, 0x19},
		{0x09, 0x0E, 0x18, 0x1D},
		{0x0B, 0x12, 0x20, 0x27},
		{0x0E, 0x18, 0x2A, 0x33},
		{0x12, 0x1E, 0x35, 0x40},
		{0x16, 0x24, 0x40, 0x4E},
		{0x1C, 0x2D, 0x50, 0x61},
		{0x21, 0x36, 0x60, 0x75},
		{0x4A, 0x66, 0x9E, 0xBA}
	},

	{
		{0x07, 0x0B, 0x13, 0x17},
		{0x07, 0x0C, 0x15, 0x19},
		{0x09, 0x0E, 0x18, 0x1D},
		{0x0B, 0x12, 0x20, 0x27},
		{0x0E, 0x18, 0x2A, 0x33},
		{0x12, 0x1E, 0x35, 0x40},
		{0x16, 0x24, 0x40, 0x4E},
		{0x1C, 0x2D, 0x50, 0x61},
		{0x21, 0x36, 0x60, 0x75},
		{0x2C, 0x48, 0x80, 0x9C}
	},

	{
		{0x0A, 0x11, 0x16, 0x1D},
		{0x0A, 0x12, 0x18, 0x20},
		{0x0C, 0x15, 0x1B, 0x24},
		{0x10, 0x1C, 0x25, 0x31},
		{0x15, 0x25, 0x31, 0x41},
		{0x1A, 0x2E, 0x3D, 0x50},
		{0x20, 0x38, 0x4A, 0x62},
		{0x28, 0x46, 0x5C, 0x7A},
		{0x30, 0x54, 0x6F, 0x93},
		{0x3F, 0x6F, 0x93, 0xC3}
	},

	{
		{0x09, 0x0D, 0x15, 0x19},
		{0x09, 0x0E, 0x17, 0x1B},
		{0x0B, 0x10, 0x1A, 0x1F},
		{0x0E, 0x15, 0x23, 0x2A},
		{0x12, 0x1C, 0x2E, 0x38},
		{0x17, 0x23, 0x3A, 0x45},
		{0x1C, 0x2A, 0x46, 0x54},
		{0x23, 0x34, 0x57, 0x68},
		{0x2A, 0x3F, 0x69, 0x7E},
		{0x38, 0x54, 0x8C, 0xA8}
	},

	{
		{0x05, 0x09, 0x11, 0x15},
		{0x05, 0x0A, 0x13, 0x17},
		{0x07, 0x0C, 0x16, 0x1B},
		{0x09, 0x10, 0x1E, 0x25},
		{0x0C, 0x16, 0x28, 0x31},
		{0x0F, 0x1B, 0x32, 0x3D},
		{0x13, 0x21, 0x3D, 0x4B},
		{0x18, 0x29, 0x4D, 0x5D},
		{0x1D, 0x32, 0x5C, 0x71},
		{0x27, 0x43, 0x7B, 0x97}
	},

	{
		{0x08, 0x0C, 0x14, 0x18},
		{0x08, 0x0D, 0x16, 0x1A},
		{0x0A, 0x0F, 0x19, 0x1E},
		{0x0D, 0x14, 0x22, 0x29},
		{0x11, 0x1B, 0x2D, 0x36},
		{0x16, 0x22, 0x39, 0x44},
		{0x1B, 0x29, 0x45, 0x53},
		{0x22, 0x33, 0x56, 0x67},
		{0x29, 0x3E, 0x68, 0x7D},
		{0x36, 0x53, 0x8B, 0xA7}
	},

	{
		{0x07, 0x0E, 0x20, 0x26},
		{0x07, 0x0F, 0x23, 0x29},
		{0x09, 0x12, 0x28, 0x2F},
		{0x0C, 0x18, 0x36, 0x40},
		{0x10, 0x20, 0x48, 0x55},
		{0x14, 0x28, 0x60, 0x6A},
		{0x19, 0x31, 0x6D, 0x81},
		{0x1F, 0x3D, 0x88, 0xA1},
		{0x26, 0x4A, 0xA4, 0xC2},
		{0x33, 0x63, 0xDB, 0x0103}
	},

	{
		{0x0B, 0x11, 0x23, 0x27},
		{0x0D, 0x13, 0x27, 0x2B},
		{0x0E, 0x16, 0x2C, 0x31},
		{0x13, 0x1D, 0x3B, 0x42},
		{0x1B, 0x27, 0x4F, 0x58},
		{0x21, 0x31, 0x63, 0x6E},
		{0x27, 0x3B, 0x77, 0x85},
		{0x31, 0x4A, 0x95, 0xA6},
		{0x3B, 0x59, 0xB3, 0xC8},
		{0x4F, 0xC7, 0xEF, 0x010B}
	}
#endif /* if 0 */
};

static const unsigned char * const rip_fonts[] = {
	Triplex,
	Small,
	Sans,
	Gothic,
	Script,
	Simplex,
	TriplexScript,
	Complex,
	European,
	Bold
};
static int next_char(const char *buf, size_t *pos);
static int parse_mega(const char *buf, int fieldwidth);
static char *parse_string(const char *buf);
static void buffer_rip(const BYTE *buf, unsigned len);
static void buffer_data(const BYTE *buf, unsigned len);
static void do_rip_command(int level, int sublevel, int cmd, const char *args);
static void do_rip_string(const char *buf, size_t len);
static bool handle_rip_line(BYTE *buf,
    unsigned                     *blen,
    unsigned                     *pos,
    size_t                       *rip_start,
    unsigned                      maxlen,
    enum rip_state                ns);
static void unrip_line(BYTE *buf, unsigned *blen, unsigned *pos, size_t *rip_start, unsigned maxlen);
static void write_text(const char *str);
static char *rv_version(const char * const var, const void * const data);
static char *rv_date(const char * const var, const void * const data);
static char *rv_time(const char * const var, const void * const data);
static char *rv_sound(const char * const var, const void * const data);
static char *rv_mouse(const char * const var, const void * const data);
static char *rv_reset(const char * const var, const void * const data);
static char *rv_save(const char * const var, const void * const data);
static char *rv_restore(const char * const var, const void * const data);
static char *rv_erase(const char * const var, const void * const data);
static char *rv_mouse_kill(const char * const var, const void * const data);
static char *rv_disable(const char * const var, const void * const data);
static char *rv_termstat(const char * const var, const void * const data);
static char *rv_termset(const char * const var, const void * const data);
static char *rv_hotkey(const char * const var, const void * const data);
static char *rv_exploit(const char * const var, const void * const data);
static char *rv_paste(const char * const var, const void * const data);
static void kill_mouse_fields(void);
static void kill_saved_mouse_fields(void);
static void copy_mouse_fields(struct mouse_field *from, struct mouse_field **to);
static void shadow_palette(void);
static void normal_palette(void);
static void draw_line(int x1, int y1, int x2, int y2, bool final);
static void reinit_screen(uint8_t *font, int fontx, int fonty);
static bool no_viewport(void);

static const char *ripver[] = {"", "RIPSCRIP015410", "RIPSCRIP030001"};

#define RIP_MOUSE_EVENT_NONE 0
#define RIP_MOUSE_EVENT_TEXT 1
#define RIP_MOUSE_EVENT_GRAPHICS 2
struct rip_mouse_event {
	int     x;
	int     y;
	uint8_t buttons;
	uint8_t type;
};

static struct rip_mouse_event            rip_mouse_event;

static const struct builtin_rip_variable builtins[] = {
	{"ADOW", rv_date, NULL}, // Abbreviated Day of Week
	{"ALARM", rv_sound, NULL},
	{"AMPM", rv_time, NULL}, // Returns AM or PM depending on time
	{"APP0", rv_exploit, NULL},
	{"APP1", rv_exploit, NULL},
	{"APP2", rv_exploit, NULL},
	{"APP3", rv_exploit, NULL},
	{"APP4", rv_exploit, NULL},
	{"APP5", rv_exploit, NULL},
	{"APP6", rv_exploit, NULL},
	{"APP7", rv_exploit, NULL},
	{"APP8", rv_exploit, NULL},
	{"APP9", rv_exploit, NULL},
	{"BEEP", rv_sound, NULL},               // Beep Sound (ala Ctrl-G)
	{"BLIP", rv_sound, NULL},
	{"COFF", rv_termset, NULL},
	{"COMPAT", rv_termset, NULL},
	{"CON", rv_termset, NULL},
	{"CURSOR", rv_termstat, NULL},
	{"CURX", rv_termstat, NULL},
	{"CURY", rv_termstat, NULL},
	{"DATE", rv_date, NULL},                // Date in short format MM/DD/YY
	{"DATETIME", rv_date, NULL},            // Date and Time
	{"DAY", rv_date, NULL},                 // Day of Month Number
	{"DOW", rv_date, NULL},                 // Day of week fully spelled out
	{"DOY", rv_date, NULL},                 // Day of year
	{"DTW", rv_disable, NULL},
	{"DWAYOFF", rv_termset, NULL},
	{"DWAYON", rv_termset, NULL},
	{"EGW", rv_erase, NULL},
	{"ETW", rv_erase, NULL},
	{"FYEAR", rv_date, NULL},               // 4 digit year
	{"HKEYOFF", rv_hotkey, NULL},
	{"HKEYON", rv_hotkey, NULL},
	{"HOUR", rv_time, NULL},                // Hour (format HH) - normal style
	{"M", rv_mouse, NULL},
	{"MHOUR", rv_time, NULL},               // Hour (format HH) - military style
	{"MIN", rv_time, NULL},                 // Minutes
	{"MKILL", rv_mouse_kill, NULL},
	{"MONTH", rv_date, NULL},               // Month Name
	{"MONTHNUM", rv_date, NULL},            // Month Number (1..12)
	{"MSTAT", rv_mouse, NULL},
	{"MUSIC", rv_sound, NULL},
	{"PCB", rv_paste, NULL},
	{"PHASER", rv_sound, NULL},
	{"RCB", rv_restore, NULL},
	{"RESET", rv_reset, NULL},
	{"RESTORE", rv_restore, NULL},
	{"RESTORE1", rv_restore, NULL},
	{"RESTORE2", rv_restore, NULL},
	{"RESTORE3", rv_restore, NULL},
	{"RESTORE4", rv_restore, NULL},
	{"RESTORE5", rv_restore, NULL},
	{"RESTORE6", rv_restore, NULL},
	{"RESTORE7", rv_restore, NULL},
	{"RESTORE8", rv_restore, NULL},
	{"RESTORE9", rv_restore, NULL},
	{"RESTOREALL", rv_restore, NULL},
	{"REVPHASER", rv_sound, NULL},
	{"RIPVER", rv_version, NULL},  // RIPscrip version
	{"RMF", rv_restore, NULL},
	{"RTW", rv_restore, NULL},
	{"SAVE", rv_save, NULL},
	{"SAVE0", rv_save, NULL},
	{"SAVE1", rv_save, NULL},
	{"SAVE2", rv_save, NULL},
	{"SAVE3", rv_save, NULL},
	{"SAVE4", rv_save, NULL},
	{"SAVE5", rv_save, NULL},
	{"SAVE6", rv_save, NULL},
	{"SAVE7", rv_save, NULL},
	{"SAVE8", rv_save, NULL},
	{"SAVE9", rv_save, NULL},
	{"SAVEALL", rv_save, NULL},
	{"SBAROFF", rv_termset, NULL},
	{"SBARON", rv_termset, NULL},
	{"SCB", rv_save, NULL},
	{"SEC", rv_time, NULL},                 // Seconds
	{"SMF", rv_save, NULL},
	{"STATBAR", rv_termstat, NULL},
	{"STW", rv_save, NULL},
	{"TABOFF", rv_hotkey, NULL},
	{"TABON", rv_hotkey, NULL},
	{"TIME", rv_time, NULL},                // Time in standard format 18:09:33
	{"TIMEZONE", rv_time, NULL},            // Time Zone or "NONE" if unknown
	{"TWFONT", rv_termstat, NULL},
	{"TWH", rv_termstat, NULL},
	{"TWIN", rv_termstat, NULL},
	{"TWW", rv_termstat, NULL},
	{"TWX0", rv_termstat, NULL},
	{"TWX1", rv_termstat, NULL},
	{"TWY0", rv_termstat, NULL},
	{"TWY1", rv_termstat, NULL},
	{"VT102OFF", rv_termset, NULL},
	{"VT102ON", rv_termset, NULL},
	{"WDAY", rv_date, NULL},                // Day of Week (0..6)
	{"WOY", rv_date, NULL},                 // Week of current year 00-53; Sunday=1st Day of Week
	{"WOYM", rv_date, NULL},                // Week of current year 00-53; Monday=1st Day of Week
	{"X", rv_mouse, NULL},
	{"XY", rv_mouse, NULL},
	{"XYM", rv_mouse, NULL},
	{"Y", rv_mouse, NULL},
	{"YEAR", rv_date, NULL}                 // 2 digit year
	,
};

static void
set_ega_palette(void)
{
	int      i;
	uint32_t fg;

	for (i = 0; i < 16; i++) {
		attr2palette(i, &fg, NULL);
		ega_colours[i] = fg;
		setpalette(fg, ega_palette[curr_ega_palette[i]][0], ega_palette[curr_ega_palette[i]][1],
		    ega_palette[curr_ega_palette[i]][2]);
	}
}

static int
bicmp(const void *str, const void *vd)
{
	int   ret;
	char *tmpstr = strdup(str);
	char *openparen = strchr(tmpstr, '(');

	if (openparen != NULL)
		*openparen = '\0';

	const struct builtin_rip_variable *vardef = vd;

	ret = strcmp(tmpstr, vardef->name);
	free(tmpstr);
	return ret;
}

static char *
get_text_variable(const char * const var)
{
	struct builtin_rip_variable *vardef;

	if (var[0] == '>') {
		puts("TODO: Local RIP playback");
		return NULL;
	}
	vardef = bsearch(var, builtins, sizeof(builtins) / sizeof(builtins[0]), sizeof(builtins[0]), bicmp);
	if (vardef == NULL) {
		printf("TODO: User variables (%s)\n", var);
		return calloc(1, 1);
	}
	return vardef->func(var, vardef->data);
}

static char *
rv_version(const char * const var, const void * const data)
{
	return strdup(ripver[rip.version]);
}

static char *
rv_date(const char * const var, const void * const data)
{
	time_t    now;
	struct tm nlt;
	char      str[1024];

	now = time(NULL);
	localtime_r(&now, &nlt);
	switch (var[0]) {
		case 'D':
			switch (var[1]) {
				case 'A':
					switch (var[2]) {
						case 'T':
							switch (var[4]) {
								case 0:
									snprintf(str,
									    sizeof(str),
									    "%02d/%02d/%02d",
									    nlt.tm_mon + 1,
									    nlt.tm_mday,
									    nlt.tm_year % 100);
									return strdup(str);
								case 'T':
									ctime_r(&now, str);
									return strdup(str);
							}
							break;
						case 'Y':
							snprintf(str, sizeof(str), "%02d", nlt.tm_mday);
							return strdup(str);
					}
					break;
				case 'O':
					switch (var[2]) {
						case 'Y':
							snprintf(str, sizeof(str), "%03d", nlt.tm_yday + 1);
							return strdup(str);
						case 'W':
							strftime(str, sizeof(str), "%A", &nlt);
							return strdup(str);
					}
					break;
			}
			break;
		case 'M':
			switch (var[5]) {
				case 0:
					strftime(str, sizeof(str), "%B", &nlt);
					return strdup(str);
				case 'N':
					snprintf(str, sizeof(str), "%02d", nlt.tm_mon + 1);
					return strdup(str);
			}
			break;
		case 'Y':
			snprintf(str, sizeof(str), "%02d", nlt.tm_mon % 100);
			return strdup(str);
		case 'F':
			snprintf(str, sizeof(str), "%04d", nlt.tm_mon + 1900);
			return strdup(str);
		case 'W':
			switch (var[1]) {
				case 'D':
					snprintf(str, sizeof(str), "%02d", nlt.tm_wday);
					return strdup(str);
				case 'O':
					switch (var[3]) {
						case 0:
							strftime(str, sizeof(str), "%U", &nlt);
							return strdup(str);
						case 'M':
							strftime(str, sizeof(str), "%W", &nlt);
							return strdup(str);
					}
					break;
			}
			break;
		case 'A':
			strftime(str, sizeof(str), "%a", &nlt);
			return strdup(str);
	}
	printf("TODO: Unhandled date variable $%s$\n", var);
	return NULL;
}

static char *
rv_time(const char * const var, const void * const data)
{
	time_t    now;
	struct tm nlt;
	char      str[1024];

	now = time(NULL);
	localtime_r(&now, &nlt);
	switch (var[0]) {
		case 'A':
			if (nlt.tm_hour < 12)
				return strdup("AM");
			return strdup("PM");
		case 'H':
			strftime(str, sizeof(str), "%I", &nlt);
			return strdup(str);
		case 'M':
			switch (var[1]) {
				case 'H':
					snprintf(str, sizeof(str), "%02d", nlt.tm_hour);
					return strdup(str);
				case 'I':
					snprintf(str, sizeof(str), "%02d", nlt.tm_min);
					return strdup(str);
			}
			break;
		case 'S':
			snprintf(str, sizeof(str), "%02d", nlt.tm_sec);
			return strdup(str);
		case 'T':
			switch (var[4]) {
				case 0:
					snprintf(str, sizeof(str), "%02d:%02d:%02d", nlt.tm_hour, nlt.tm_min,
					    nlt.tm_sec);
					return strdup(str);
				case 'Z':
					strftime(str, sizeof(str), "%Z", &nlt);
					return strdup(str);
			}
	}
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_sound(const char * const var, const void * const data)
{
	int i;

	switch (var[0]) {
		case 'A':
			for (i = 0 ; i < 3 ; i += 1) {
				xptone(320, 200, WAVE_SHAPE_SINE);
				xptone(160, 425, WAVE_SHAPE_SINE);
			}
			return NULL;
			break;
		case 'B':
			switch (var[1]) {
				case 'E':
					xptone(1000, 75, WAVE_SHAPE_SINE);
					SLEEP(75); // Literally in the spec.
					return NULL;
				case 'L':
					xptone(50, 25, WAVE_SHAPE_SINE);
					SLEEP(10); // Literally in the spec.
					return NULL;
			}
			break;
		case 'M':
			for (i = 0; i < 4; i += 1) {
				xptone(1300, 10, WAVE_SHAPE_SINE);
				xptone(1200, 10, WAVE_SHAPE_SINE);
				xptone(1100, 10, WAVE_SHAPE_SINE);
				xptone(1000, 10, WAVE_SHAPE_SINE);
				xptone(900, 10, WAVE_SHAPE_SINE);
				xptone(800, 10, WAVE_SHAPE_SINE);
				xptone(700, 10, WAVE_SHAPE_SINE);
				xptone(850, 10, WAVE_SHAPE_SINE);
				xptone(950, 10, WAVE_SHAPE_SINE);
			}
			return NULL;
		case 'P':
			for (i = 2500; i >= 50; i -= 20)
				xptone(i, 2, WAVE_SHAPE_SINE);
			return NULL;
		case 'R':
			for (i = 50; i <= 2500; i += 20)
				xptone(i, 2, WAVE_SHAPE_SINE);
			return NULL;
	}
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_mouse(const char * const var, const void * const data)
{
	char str[128];
	int  fwidth = 4;

	switch (rip_mouse_event.type) {
		case RIP_MOUSE_EVENT_NONE:
			mousestate_res(&rip_mouse_event.x, &rip_mouse_event.y, &rip_mouse_event.buttons);
			break;
		case RIP_MOUSE_EVENT_TEXT:
			fwidth = 2;
			break;
	}

	switch (var[0]) {
		case 'X':
			switch (var[1]) {
				case 0:
					snprintf(str, sizeof(str), "%0*d", fwidth, rip_mouse_event.x);
					return strdup(str);
				case 'Y':
					switch (var[2]) {
						case 0:
							snprintf(str,
							    sizeof(str),
							    "%0*x:%0*x",
							    fwidth,
							    rip_mouse_event.x,
							    fwidth,
							    rip_mouse_event.y);
							return strdup(str);
						case 'M':
							snprintf(str,
							    sizeof(str),
							    "%0*x:%0*x:%d%d%d",
							    fwidth,
							    rip_mouse_event.x,
							    fwidth,
							    rip_mouse_event.y,
							    rip_mouse_event.buttons & 1,
							    rip_mouse_event.buttons >> 1 & 1,
							    rip_mouse_event.buttons >> 2 & 1);
							return strdup(str);
					}
					break;
			}
			break;
		case 'Y':
			snprintf(str, sizeof(str), "%0*d", fwidth, rip_mouse_event.y);
			return strdup(str);
		case 'M':
			switch (var[1]) {
				case 0:
					snprintf(str,
					    sizeof(str),
					    "%d%d%d",
					    rip_mouse_event.buttons & 1,
					    rip_mouse_event.buttons >> 1 & 1,
					    rip_mouse_event.buttons >> 2 & 1);
					return strdup(str);
				case 'S':
					return strdup("YES");
			}
			break;
	}
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static uint32_t
map_rip_color(int color)
{
	uint32_t col = 0;

	if (color < 16) {
		col = ega_colours[color];
	}
	else if (color < 256) {
		col = 0x80000000
		    | ((default_mapped[color][0] << 2 | (default_mapped[color][0] & 3)) << 16)
		    | ((default_mapped[color][1] << 2 | (default_mapped[color][1] & 3)) << 8)
		    | ((default_mapped[color][2] << 2 | (default_mapped[color][2] & 3)));
	}
	else {
		fprintf(stderr, "Unable to map %d\n", color);
	}
	return col;
}

static char *
rv_reset(const char * const var, const void * const data)
{
	int oldhold = hold_update;

	hold_update = 0;
	kill_mouse_fields();
	if (rip.clipboard) {
		freepixels(rip.clipboard);
		rip.clipboard = NULL;
	}

        // TODO: Figure out what all gets reset here...
	rip.color = 0;
	assert_rwlock_rdlock(&vstatlock);
	rip.x_max = vstat.scrnwidth;
	rip.y_max = vstat.scrnheight;
	assert_rwlock_unlock(&vstatlock);
	rip.x_dim = 640;
	rip.y_dim = 350;
	if (rip.x_max > rip.x_dim)
		rip.x_max = rip.x_dim;
	if (rip.y_max > rip.y_dim)
		rip.y_max = rip.y_dim;

        // TODO: Hack... we should likely scale both directions...
	FREE_AND_NULL(rip.xmap);
	FREE_AND_NULL(rip.ymap);
	FREE_AND_NULL(rip.xunmap);
	FREE_AND_NULL(rip.yunmap);
	rip.viewport.sx = 0;
	rip.viewport.sy = 0;
	rip.viewport.ex = rip.x_dim - 1;
	rip.viewport.ey = rip.y_dim - 1;
	rip.line_pattern = rip_line_patterns[0];
	rip.line_width = 0;
	rip.curstype = _NORMALCURSOR;
	rip.borders = true;
	rip.text_disabled = false;
	rip.ansi_state = ANSI_STATE_NONE;
	_setcursortype(rip.curstype);
	reinit_screen(rip.default_font, rip.default_font_width, rip.default_font_height);
	memcpy(&curr_ega_palette, &default_ega_palette, sizeof(curr_ega_palette));
	set_ega_palette();
	cterm->left_margin = 1;
	cterm->top_margin = 1;
	cterm->right_margin = cterm->width;
	cterm->bottom_margin = cterm->height;
	cterm->extattr |= CTERM_EXTATTR_ORIGINMODE;
	cterm->extattr |= CTERM_EXTATTR_AUTOWRAP;
	cterm->attr = 15;
	cterm->fg_color = map_rip_color(15);
	cterm->bg_color = map_rip_color(0);
	setwindow(cterm);
	cterm_gotoxy(cterm, 1, 1);
	clrscr();
	rv_erase("EGW", NULL);
	freepixels(getpixels(0, 0, 1, 1, true));
	hold_update = oldhold;
	return NULL;
}

static char *
rv_save(const char * const var, const void * const data)
{
	if (strcmp(var, "SMF") == 0) {
                // Save mouse fields...
		kill_saved_mouse_fields();
		copy_mouse_fields(rip.mfields, &rip.saved_mfields);
		return NULL;
	}
	printf("TODO: Save RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_restore(const char * const var, const void * const data)
{
	if (strcmp(var, "RMF") == 0) {
                // Restore mouse fields...
		kill_mouse_fields();
		copy_mouse_fields(rip.saved_mfields, &rip.mfields);
		return NULL;
	}
	printf("TODO: Restore RIP Variables (%s)\n", var);
	return NULL;
}

static int
unmap_rip_x(int x)
{
	int i;

	if (rip.xunmap == NULL) {
		rip.xunmap = malloc(rip.x_dim * sizeof(int));
		if (rip.xunmap == NULL) {
			double dx = x;

			dx *= rip.x_max;
			dx /= rip.x_dim;
			return roundl(dx);
		}
		for (i = 0; i < rip.x_dim; i++)
			rip.xunmap[i] = roundl(((double)i) * rip.x_dim / rip.x_max);
	}
	if (x >= rip.x_dim)
		x = rip.x_dim - 1;
	return rip.xunmap[x];
}

static int
unmap_rip_y(int y)
{
	int i;

	if (rip.yunmap == NULL) {
		rip.yunmap = malloc(rip.y_dim * sizeof(int));
		if (rip.yunmap == NULL) {
			double dy = y;

			dy *= rip.y_max;
			dy /= rip.y_dim;
			return roundl(dy);
		}
		for (i = 0; i < rip.y_dim; i++)
			rip.yunmap[i] = roundl(((double)i) * rip.y_dim / rip.y_max);
	}
	if (y >= rip.y_dim)
		y = rip.y_dim - 1;
	return rip.yunmap[y];
}

static int
map_rip_x(int x)
{
	int i;

	if ((x < 0) || (x >= rip.x_dim)) {
		double dx = x;

		dx *= rip.x_max;
		dx /= rip.x_dim;
		return roundl(dx);
	}

	if (rip.xmap == NULL) {
		rip.xmap = malloc(rip.x_dim * sizeof(int));
		if (rip.xmap == NULL) {
			double dx = x;

			dx *= rip.x_max;
			dx /= rip.x_dim;
			return roundl(dx);
		}
		for (i = 0; i < rip.x_dim; i++) {
			rip.xmap[i] = roundl(((double)i) * rip.x_max / rip.x_dim);
			if (rip.xmap[i] >= rip.x_max)
				rip.xmap[i] = rip.x_max - 1;
		}
	}
	if (x >= rip.x_dim)
		x = rip.x_dim;
	return rip.xmap[x];
}

static int
map_rip_y(int y)
{
	int i;

	if ((y < 0) || (y >= rip.y_dim)) {
		double dy = y;

		dy *= rip.y_max;
		dy /= rip.y_dim;
		return roundl(dy);
	}

	if (rip.ymap == NULL) {
		rip.ymap = malloc(rip.y_dim * sizeof(int));
		if (rip.ymap == NULL) {
			double dy = y;

			dy *= rip.y_max;
			dy /= rip.y_dim;
			return roundl(dy);
		}
		for (i = 0; i < rip.y_dim; i++) {
			rip.ymap[i] = roundl(((double)i) * rip.y_max / rip.y_dim);
			if (rip.ymap[i] >= rip.y_max)
				rip.ymap[i] = rip.y_max - 1;
		}
	}
	if (y >= rip.y_dim)
		y = rip.y_dim;
	return rip.ymap[y];
}

static void
scale_setpixel(int x, int y, uint32_t color)
{
	setpixel(map_rip_x(x), map_rip_y(y), color);
}

static void
rip_setpixel(int x, int y, int color)
{
	setpixel(map_rip_x(x), map_rip_y(y), map_rip_color(color));
}

static char *
rv_erase(const char * const var, const void * const data)
{
	int x, y;

	switch (var[1]) {
		case 'G':
			if (no_viewport())
				return NULL;
			for (y = rip.viewport.sy; y <= rip.viewport.ey; y++) {
				for (x = rip.viewport.sx; x <= rip.viewport.ex; x++)
					rip_setpixel(x, y, 0);
			}
			return NULL;
		case 'T':
			cterm_clearscreen(cterm, cterm->attr);
			cterm_gotoxy(cterm, 1, 1);
			return NULL;
	}
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_mouse_kill(const char * const var, const void * const data)
{
	kill_mouse_fields();
	return NULL;
}

static char *
rv_disable(const char * const var, const void * const data)
{
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_termstat(const char * const var, const void * const data)
{
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_termset(const char * const var, const void * const data)
{
	struct text_info ti;
	char             str[128];

	switch (var[0]) {
		case 'C':
			switch (var[1]) {
				case 'O':
					switch (var[2]) {
						case 'F':
							rip.curstype = _NOCURSOR;
							_setcursortype(rip.curstype);
							return NULL;
						case 'N':
							rip.curstype = _NORMALCURSOR;
							_setcursortype(rip.curstype);
							return NULL;
						case 'M':
							rip.x_dim = 640;
							rip.y_dim = 350;
							assert_rwlock_rdlock(&vstatlock);
							rip.x_max = vstat.scrnwidth;
							rip.y_max = vstat.scrnheight;
							assert_rwlock_unlock(&vstatlock);
							if (rip.x_max > rip.x_dim)
								rip.x_max = rip.x_dim;
							if (rip.y_max > rip.y_dim)
								rip.y_max = rip.y_dim;

                                                        // TODO: Hack... we should likely scale both directions...
							rip.viewport.sx = 0;
							rip.viewport.sy = 0;
							rip.viewport.ex = rip.x_dim - 1;
							rip.viewport.ey = rip.y_dim - 1;
							FREE_AND_NULL(rip.xmap);
							FREE_AND_NULL(rip.ymap);
							FREE_AND_NULL(rip.xunmap);
							FREE_AND_NULL(rip.yunmap);
							return NULL;
					}
					break;
				case 'U':
					switch (var[3]) {
						case 'S':
							if ((cterm->left_margin == 1) && (cterm->right_margin == 1)
							    && (cterm->top_margin == 1) && (cterm->bottom_margin == 1))
								return strdup("NO");
							if (rip.text_disabled)
								return strdup("NO");
							if (rip.curstype == _NOCURSOR)
								return strdup("NO");
							return strdup("YES");
						case 'X':
							gettextinfo(&ti);
							snprintf(str, sizeof(str), "%d", ti.curx - 1);
							return strdup(str);
						case 'Y':
							gettextinfo(&ti);
							snprintf(str, sizeof(str), "%d", ti.cury - 1);
							return strdup(str);
					}
					break;
			}
			break;
		case 'D':
			switch (var[5]) {
				case 'F':
					cterm->doorway_mode = false;
					return NULL;
				case 'N':
					cterm->doorway_mode = true;
					return NULL;
			}
			break;
		case 'S': {
			void *font;
			int   width;
			int   height;

			assert_rwlock_rdlock(&vstatlock);
			font = vstat.forced_font;
			width = vstat.charwidth;
			height = vstat.charheight;
			assert_rwlock_unlock(&vstatlock);
			switch (var[5]) {
				case 'F':
					gettextinfo(&ti);
					term.nostatus = true;
					reinit_screen(font, width, height);
					return NULL;
				case 'N':
					gettextinfo(&ti);
					term.nostatus = false;
					reinit_screen(font, width, height);
					return NULL;
			}
			break;
		}
		case 'V':
			switch (var[6]) {
				case 'F':
				case 'N':
					break;

                                        // TODO: This is total crap...
			}
			break;
	}
	printf("TODO: rv_termset(%s)\n", var);
	return NULL;
}

static char *
rv_hotkey(const char * const var, const void * const data)
{
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_exploit(const char * const var, const void * const data)
{
	printf("TODO: RIP Variables (%s)\n", var);
	return NULL;
}

static char *
rv_paste(const char * const var, const void * const data)
{
	if (rip.clipboard) {
		setpixels(rip.clipx,
		    rip.clipy,
		    rip.clipx + rip.clipboard->width - 1,
		    rip.clipy + rip.clipboard->height - 1,
		    0,
		    0, 0, 0,
		    rip.clipboard,
		    NULL);
	}
	return NULL;
}

static bool
no_viewport(void)
{
	return rip.viewport.sx == 0 && rip.viewport.sy == 0
	       && rip.viewport.ex == 0 && rip.viewport.ey == 0;
}

static int
parse_mega(const char *buf, int fieldwidth)
{
	int i;
	int ret = 0;

        // TODO: Apparently, the last option can always be shortened...
        // TODO: Do we need to pass this info back?
	for (i = 0; i < fieldwidth; i++) {
		ret *= 36;
		if ((buf[i] >= '0') && (buf[i] <= '9')) {
			ret += (buf[i] - '0');
		}
		else if ((buf[i] >= 'A') && (buf[i] <= 'Z')) {
			ret += (buf[i] - 'A' + 10);
		}
		else if ((buf[i] >= 'a') && (buf[i] <= 'z')) {
			ret += (buf[i] - 'a' + 10);
		}
		else {
			if (i == 0)
				return -1;
			ret /= 36;
			return ret;
		}
	}
	return ret;
}

static char *
parse_string(const char *buf)
{
	size_t inpos = 0;
	char  *p;
	int    ch;
	char  *ret = malloc(strlen(buf) + 1);

	if (ret == NULL)
		return ret;
	for (p = ret; (ch = next_char(buf, &inpos)) > 0; inpos++)
		*(p++) = ch;
	*p = 0;
	return ret;
}

static void
buffer_rip(const BYTE *buf, unsigned len)
{
	size_t new_size;
	char  *p;

	if (pending_len + len + 1 > pending_size) {
		new_size = pending_size ? pending_size * 2 : 1024;
		if (new_size < pending_len + len + 1)
			new_size = pending_len + len + 1;
		p = realloc(pending, new_size);

                // TODO: Can we handle this gracefully?
		if (p == NULL)
			return;
		pending = p;
		pending_size = new_size;
	}
	memcpy(&pending[pending_len], buf, len);
	pending_len += len;
	pending[pending_len] = 0;
}

static void
buffer_data(const BYTE *buf, unsigned len)
{
	size_t new_size;
	BYTE  *p;

	if (moredata_len + len + 1 > moredata_size) {
		new_size = moredata_size ? moredata_size * 2 : 1024;
		if (new_size < moredata_len + len + 1)
			new_size = moredata_len + len + 1;
		p = realloc(moredata, new_size);

                // TODO: Can we handle this gracefully?
		if (p == NULL)
			return;
		moredata = p;
		moredata_size = new_size;
	}
	memcpy(&moredata[moredata_len], buf, len);
	moredata_len += len;
	moredata[moredata_len] = 0;
}

static int
next_char(const char *buf, size_t *pos)
{
	while (buf[*pos] == '\\') {
		(*pos)++;
		if (buf[*pos] == '\r') {
			(*pos)++;
			if (buf[*pos] == '\n')
				(*pos)++;
		}
		else if (buf[*pos] == '\n') {
			(*pos)++;
		}
		else {
			return (uint8_t)buf[*pos];
		}
	}

        /*if (buf[*pos] == '!')
         *       return -1;
         *  else */
	if (buf[*pos] == '|')
		return -1;
	else if (buf[*pos] == '\r')
		return -1;
	else if (buf[*pos] == '\n')
		return -1;
	return (uint8_t)buf[*pos];
}

enum do_states {
	NEED_BANG
	,
	NEED_PIPE
	,
	NEED_LEVEL
	,
	NEED_SUBLEVEL
	,
	NEED_COMMAND
	,
	ARGUMENTS
};

static uint32_t
pixel2color(uint32_t pix)
{
	int i;

	for (i = 0; i < 16; i++) {
		if (ega_colours[i] == pix)
			break;
	}
	if (i == 16) {
		for (i = 0; i < 256; i++) {
			if (map_rip_color(i) == pix)
				break;
		}
		if (i == 256)
			printf("TODO: Unable to convert color %08" PRIx32 " to palette color\n", pix);
		return 0;
	}
	return i;
}

static void
draw_pixel(int x, int y)
{
	struct ciolib_pixels *pix;

	if ((x < 0) || (x > (rip.viewport.ex - rip.viewport.sx)))
		return;
	if ((y < 0) || (y > (rip.viewport.ey - rip.viewport.sy)))
		return;
	if (rip.xor) {
		pix = getpixels(rip.viewport.sx + x, rip.viewport.sy + y, rip.viewport.sx + x, rip.viewport.sy + y, 0);
		if (pix == NULL)
			return;
		if (pix->pixels[0] & 0x40000000) {
			return;
		}
		rip_setpixel(rip.viewport.sx + x, rip.viewport.sy + y, pixel2color(pix->pixels[0]) ^ rip.color);
		freepixels(pix);
		pix = getpixels(rip.viewport.sx + x, rip.viewport.sy + y, rip.viewport.sx + x, rip.viewport.sy + y, 0);
		if (pix) {
			pix->pixels[0] |= 0x40000000;
			setpixels(rip.viewport.sx + x, rip.viewport.sy + y, rip.viewport.sx + x, rip.viewport.sy + y, 0, 0, 0, 0, pix, NULL);
			freepixels(pix);
		}

		pix = getpixels(rip.viewport.sx + x, rip.viewport.sy + y, rip.viewport.sx + x, rip.viewport.sy + y, 0);
		freepixels(pix);
	}
	else {
		rip_setpixel(rip.viewport.sx + x, rip.viewport.sy + y, rip.color);
	}
}

// TODO: Should should only be used by things that use the write mode.
static void
set_pixel(int x, int y, uint32_t fg)
{
	if ((x < 0) || (x > (rip.viewport.ex - rip.viewport.sx)))
		return;
	if ((y < 0) || (y > (rip.viewport.ey - rip.viewport.sy)))
		return;
	scale_setpixel(rip.viewport.sx + x, rip.viewport.sy + y, fg);
}

static void
native_fill_pixel(int x, int y)
{
	if (rip.fill_pattern[y & 0x07] & (0x80 >> (x & 0x07)))
		setpixel(x, y, map_rip_color(rip.fill_color));
	else
		setpixel(x, y, map_rip_color(0));
}

static void
fill_pixel(int x, int y)
{
	x += rip.viewport.sx;
	y += rip.viewport.sy;
	if ((x > rip.viewport.ex) || (y > rip.viewport.ey))
		return;

        // Handle the translation here for nicer fills...
	x = map_rip_x(x);
	y = map_rip_y(y);
	native_fill_pixel(x, y);
}

static int
char_width_raw(char ch)
{
	int           chnum;
	int           fchar;
	int           nchars;
	unsigned char uch = ch;

	if (rip.font.num == 0) {
		return 8;
	}
	else {
		fchar = rip_fonts[rip.font.num - 1][0x84];
		if (uch < fchar)
			return 0;
		chnum = uch - rip_fonts[rip.font.num - 1][0x84];
		nchars = *((uint16_t *)&rip_fonts[rip.font.num - 1][0x81]);
		if (uch - fchar >= nchars)
			return 0;
		return rip_fonts[rip.font.num - 1][0x90 + nchars * 2 + chnum];
	}
}

static int
char_width(char ch)
{
	int mult;
	int div;

	if (rip.font.num == 0) {
		return 8 * rip.font.size;
	}
	else {
		mult = stroke_mults[rip.font.size];
		div = stroke_divs[rip.font.size];
		return char_width_raw(ch) * mult / div;
	}
}

static void
char_top_base(char ch, int *top, int *bottom)
{
	int      fontoffset;
	uint8_t *this_font;
	int      y;

	if (rip.font.num == 0) {
		this_font = (uint8_t *)conio_fontdata[0].eight_by_eight;
		fontoffset = ('A') * 8;
		*top = -1;
		*bottom = -1;
		for (y = 0; y < 8; y++) {
			if (this_font[fontoffset]) {
				if (*top == -1)
					*top = y * rip.font.size;
				*bottom = y * rip.font.size;
			}
			fontoffset++;
		}
	}
	else {
		*top = (int)font_metrics[rip.font.num][rip.font.size - 1].top;
		*bottom = (int)font_metrics[rip.font.num][rip.font.size - 1].base;
	}
}

static void
char_top_bottom(char ch, int *top, int *bottom)
{
	int      fontoffset;
	uint8_t *this_font;
	int      y;

	if (rip.font.num == 0) {
		this_font = (uint8_t *)conio_fontdata[0].eight_by_eight;
		fontoffset = ((uint8_t)ch) * 8;
		*top = -1;
		*bottom = -1;
		for (y = 0; y < 8; y++) {
			if (this_font[fontoffset]) {
				if (*top == -1)
					*top = y * rip.font.size;
				*bottom = y * rip.font.size;
			}
			fontoffset++;
		}
	}
	else {
		if (low_char[(uint8_t)ch]) {
			*top = (int)font_metrics[rip.font.num][rip.font.size - 1].top;
			*bottom = (int)font_metrics[rip.font.num][rip.font.size - 1].drop;
		}
		else {
			*top = (int)font_metrics[rip.font.num][rip.font.size - 1].top;
			*bottom = (int)font_metrics[rip.font.num][rip.font.size - 1].base;
		}
	}
}

static int
font_height()
{
	int mult = stroke_mults[rip.font.size];
	int div = stroke_divs[rip.font.size];

	if (rip.font.num == 0)
		return 8 * rip.font.size;
	return (((char)rip_fonts[rip.font.num - 1][0x88]) - ((char)rip_fonts[rip.font.num - 1][0x8a])) * mult / div;
}

static void
write_char(char ch)
{
	int           x, xs;
	int           y, ys;
	int           fontoffset;
	uint8_t      *this_font;
	int           chnum;
	int           fchar;
	int           nchars;
	char          cx;
	char          cy;
	int           oc;
	int           yh;
	int           mult;
	int           div;
	int           bcx, bcy;
	int           dx, dy;
	int           orig_width = rip.line_width;
	uint16_t      orig_pattern = rip.line_pattern;
	unsigned char uch = ch;

	if (no_viewport())
		return;

	if (rip.font.num == 0) {
                // NOTE: Bitmap fonts don't work vertically for no apparent reason.
		if (rip.font.vertical)
			return;

                // Bitmap 8x8 font
		this_font = (uint8_t *)conio_fontdata[0].eight_by_eight;
		fontoffset = (uch) * 8;

		for (y = 0; y < 8; y++) {
			for (x = 0; x < 8; x++) {
				for (ys = 0; ys < rip.font.size; ys++) {
					for (xs = 0; xs < rip.font.size; xs++) {
						if (this_font[fontoffset] & (0x80 >> x)) {
                                                        // NOTE: Bitmap fonts don't use write mode...
                                                        // draw_pixel(rip.x + (x * rip.font.size) + xs, rip.y + (y *
                                                        // rip.font.size)+ ys);
							set_pixel(rip.x + (x * rip.font.size) + xs,
							    rip.y + (y * rip.font.size) + ys, map_rip_color(rip.color));
						}
					}
				}
			}
			fontoffset++;
		}
		if (rip.font.vertical)
			rip.y += 8 * rip.font.size;
		else
			rip.x += 8 * rip.font.size;
	}
	else {
		xs = rip.x;
		ys = rip.y;
		fchar = rip_fonts[rip.font.num - 1][0x84];
		if (uch < fchar)
			return;
		chnum = uch - fchar;
		nchars = *(uint16_t *)(&rip_fonts[rip.font.num - 1][0x81]);
		if (chnum >= nchars)
			return;
		fontoffset = 0x80 + *((uint16_t *)(&rip_fonts[rip.font.num - 1][0x85]));
		fontoffset += *((uint16_t *)(&rip_fonts[rip.font.num - 1][0x90 + chnum * 2]));
		mult = stroke_mults[rip.font.size];
		div = stroke_divs[rip.font.size];

                // Doing it this way makes it too big on triplex 3
                // yh = rip_fonts[rip.font.num - 1][0x88] - 1;
                // yh *= mult;
                // yh /= div;
                // yh += font_metrics[rip.font.num][rip.font.size - 1].top;

                // Doing it this way is broken on little 7 (bad table entry)
                // yh = font_metrics[rip.font.num][rip.font.size - 1].base;

                // Doing it this way is too high on bold 1
                // yh = font_metrics[rip.font.num][3].base * mult / div;

                // This way seems insane... but seems to work.
		yh = (((signed char)rip_fonts[rip.font.num - 1][0x88]) - ((signed char)rip_fonts[rip.font.num - 1][0x8a])) * mult
		    / div;

// printf("Font: %d @ %d\n", rip.font.num, rip.font.size);
// printf("ott: %hhd, otb: %hhd, otbd: %hhd, mult: %d, div: %d, yh: %d\n", rip_fonts[rip.font.num - 1][0x88],
// rip_fonts[rip.font.num - 1][0x89], rip_fonts[rip.font.num - 1][0x8a], mult, div, yh);
// printf("top: %d, bow: %d, base: %d, drop: %d\n", font_metrics[rip.font.num][rip.font.size - 1].top,
// font_metrics[rip.font.num][rip.font.size - 1].bow, font_metrics[rip.font.num][rip.font.size - 1].base,
// font_metrics[rip.font.num][rip.font.size - 1].drop);
// printf("3top: %d, 3bow: %d, 3base: %d, 3drop: %d\n", font_metrics[rip.font.num][3].top,
// font_metrics[rip.font.num][3].bow, font_metrics[rip.font.num][3].base, font_metrics[rip.font.num][3].drop);

		rip.line_width = 1;
		rip.line_pattern = 0xffff;
		oc = 1;
		while (oc != 0) {
			cx = rip_fonts[rip.font.num - 1][fontoffset++];
			cy = rip_fonts[rip.font.num - 1][fontoffset++];
			oc = (cx >> 6) & 0x02;
			oc |= (cy >> 7) & 0x01;
			cx &= 0x7F;
			cy &= 0x7F;
			if (cx & 0x40)
				cx |= 0x80;
			if (cy & 0x40)
				cy |= 0x80;
			bcx = ((signed char)cx * mult) / div;
			bcy = ((signed char)cy * mult) / div;
			if (rip.font.vertical) {
				dx = yh - bcy;
				dy = -bcx;
			}
			else {
				dx = bcx;
				dy = yh - bcy;
			}
			switch (oc) {
				case 0:
                                        // Done!
					break;
				case 1:
					puts("TODO: \"Do scan\"\n");
					break;
				case 3:
					draw_line(rip.x, rip.y, xs + dx, ys + dy, true);

                                // Fall-through...
				case 2:
					rip.x = xs + dx;
					rip.y = ys + dy;
					break;
			}
		}
		if (rip.font.vertical) {
			rip.y = ys;
			rip.x = xs + yh;
		}
		else {
			rip.y = ys;
			rip.x = xs + char_width(ch);
		}
		rip.line_width = orig_width;
		rip.line_pattern = orig_pattern;
	}
}

static void
write_text(const char *str)
{
	const char *p;

	if (str == NULL)
		return;
	if (rip.font.vertical) {
		int sx = rip.x;
		int sy = rip.y;
		int cy;
		int tw = 0;

                // Yes, this is actually a thing.
		for (p = str; *p; p++)
			tw += char_width_raw(*p);
		tw *= stroke_mults[rip.font.size];
		tw /= stroke_divs[rip.font.size];

		rip.y += tw;
		cy = rip.y;
		for (p = str; *p; p++) {
			rip.x = sx;
			rip.y = cy;
			write_char(*p);
			cy -= char_width(*p);
		}
		rip.y = sy;
		rip.x = sx + tw;
	}
	else {
		for (p = str; *p; p++)
			write_char(*p);
	}
}

static void
draw_line(int x1, int y1, int x2, int y2, bool final)
{
	int *minc, *mins, *mino, *mind;
	int *maxc, *maxs, *maxe, *maxo, *maxd;
	int  x, y;
	int  swap = 0;
	int  dx = abs(x2 - x1);
	int  dy = abs(y2 - y1);

        // Swap endpoints
	if (y2 < y1)
		swap = 1;

	if (swap) {
		x = x2;
		y = y2;
		x2 = x1;
		y2 = y1;
		x1 = x;
		y1 = y;
	}

	int xoff;

	if (x2 < x1)
		xoff = -1;
	else
		xoff = 1;

	int yoff;

	if (y2 < y1)
		yoff = -1;
	else
		yoff = 1;

	if (dx >= dy) {
		minc = &y;
		mins = &y1;
		mino = &yoff;
		mind = &dy;

		maxc = &x;
		maxs = &x1;
		maxe = &x2;
		maxo = &xoff;
		maxd = &dx;
	}
	else {
		minc = &x;
		mins = &x1;
		mino = &xoff;
		mind = &dx;

		maxc = &y;
		maxs = &y1;
		maxe = &y2;
		maxo = &yoff;
		maxd = &dy;
	}

	int de = 2 * *mind - *maxd;
	int ppos = 0;

	if (no_viewport())
		return;

	*minc = *mins;

	for ((*maxc) = *maxs; (((*maxs) < (*maxe)) ? ((*maxc) <= (*maxe)) : ((*maxc) >= (*maxe))); (*maxc) += *maxo) {
		if (rip.line_pattern & (0x8000 >> ppos))
			draw_pixel(x, y);
		if (de >= 0) {
			*minc = (*minc) + *mino;
			de = de - ((2 * *maxd) & INT_MAX);
		}
		de = de + ((2 * *mind) & INT_MAX);
		ppos++;
		if (ppos == 16)
			ppos = 0;
		if (*maxs == *maxe)
			break;
	}
	if (rip.line_width == 3) {
		rip.line_width = 1;

                // Figure out start/end points based on first movement...
		de = 2 * *mind - *maxd;

// if (de >= 0) {
                // L-shape...
// draw_line(x1 + xoff, y1, x2 + xoff, y2);
// draw_line(x1, y1 + yoff, x2, y2 + yoff);
// }
// else {
                // I-shape...
		if (dx >= dy) {
			draw_line(x1, y1 + 1, x2, y2 + 1, false);
			draw_line(x1, y1 - 1, x2, y2 - 1, false);
		}
		else {
			draw_line(x1 + 1, y1, x2 + 1, y2, false);
			draw_line(x1 - 1, y1, x2 - 1, y2, false);
		}

// }
		rip.line_width = 3;
	}

	if (final && rip.xor) {
		struct ciolib_pixels *pix = getpixels(0, 0, rip.x_max - 1, rip.y_max - 1, false);
		if (pix) {
			size_t off = 0;
			for (y = 0; y < pix->height; y++) {
				for (x = 0; x < pix->width; x++)
					pix->pixels[off++] &= ~0x40000000;
			}
			setpixels(0, 0, rip.x_max - 1, rip.y_max - 1, 0, 0, 0, 0, pix, NULL);
			freepixels(pix);
		}
	}
}

/*
 * TODO: This is an egregious copy/paste just for the XOR draw mode
 */
static void
set_line(int x1, int y1, int x2, int y2, uint32_t color, uint16_t pat, int width)
{
	int *minc, *mins, *mino, *mind;
	int *maxc, *maxs, *maxe, *maxo, *maxd;
	int  x, y;
	int  swap = 0;
	int  lx, ly;
	int  dx = abs(x2 - x1);
	int  dy = abs(y2 - y1);

        // Swap endpoints
	if (y2 < y1)
		swap = 1;

	if (swap) {
		x = x2;
		y = y2;
		x2 = x1;
		y2 = y1;
		x1 = x;
		y1 = y;
	}

	int xoff;

	if (x2 < x1)
		xoff = -1;
	else
		xoff = 1;

	int yoff;

	if (y2 < y1)
		yoff = -1;
	else
		yoff = 1;

	if (dx >= dy) {
		minc = &y;
		mins = &y1;
		mino = &yoff;
		mind = &dy;

		maxc = &x;
		maxs = &x1;
		maxe = &x2;
		maxo = &xoff;
		maxd = &dx;
	}
	else {
		minc = &x;
		mins = &x1;
		mino = &xoff;
		mind = &dx;

		maxc = &y;
		maxs = &y1;
		maxe = &y2;
		maxo = &yoff;
		maxd = &dy;
	}

	int de = 2 * *mind - *maxd;
	int ppos = 0;

	if (no_viewport())
		return;

	*minc = *mins;

	for ((*maxc) = *maxs; (((*maxs) < (*maxe)) ? ((*maxc) <= (*maxe)) : ((*maxc) >= (*maxe))); (*maxc) += *maxo) {
		if (pat & (0x8000 >> ppos)) {
			set_pixel(x, y, color);
		}
		else {
                        // Set fill border...
			if (color & 0x40000000) {
				lx = map_rip_x(x);
				ly = map_rip_y(y);

				struct ciolib_pixels *pixels = getpixels(lx, ly, lx, ly, false);

				set_pixel(x, y, pixels->pixels[0] | 0x40000000);
				freepixels(pixels);
			}
		}
		if (de >= 0) {
			*minc = (*minc) + *mino;
			de = de - ((2 * *maxd) & INT_MAX);
		}
		de = de + ((2 * *mind) & INT_MAX);
		ppos++;
		if (ppos == 16)
			ppos = 0;
		if (*maxs == *maxe)
			break;
	}
	if (width == 3) {
                // Figure out start/end points based on first movement...
		de = 2 * *mind - *maxd;

// if (de >= 0) {
                // L-shape...
// set_line(x1 + xoff, y1, x2 + xoff, y2, color, pat, 1);
// set_line(x1, y1 + yoff, x2, y2 + yoff, color, pat, 1);
// }
// else {
                // I-shape...
		if (dx >= dy) {
			set_line(x1, y1 + 1, x2, y2 + 1, color, pat, 1);
			set_line(x1, y1 - 1, x2, y2 - 1, color, pat, 1);
		}
		else {
			set_line(x1 + 1, y1, x2 + 1, y2, color, pat, 1);
			set_line(x1 - 1, y1, x2 - 1, y2, color, pat, 1);
		}

// }
	}
}

void
chisel_inset(int height, int *xinset, int *yinset)
{
	if (height < 12) {
		*xinset = 1;
		*yinset = 1;
		return;
	}
	if (height < 25) {
		*xinset = 3;
		*yinset = 2;
		return;
	}
	if (height < 40) {
		*xinset = 4;
		*yinset = 3;
		return;
	}
	if (height < 75) {
		*xinset = 6;
		*yinset = 5;
		return;
	}
	if (height < 150) {
		*xinset = 7;
		*yinset = 5;
		return;
	}
	if (height < 200) {
		*xinset = 8;
		*yinset = 6;
		return;
	}
	if (height < 250) {
		*xinset = 10;
		*yinset = 7;
		return;
	}
	if (height < 300) {
		*xinset = 11;
		*yinset = 8;
		return;
	}
	*xinset = 13;
	*yinset = 9;
}

static void
invert_rect(int x1, int y1, int x2, int y2)
{
	uint32_t              palette[16];
	struct ciolib_pixels *pix;
	uint32_t              col;
	size_t                pixel;
	int                   x, y, i;
	struct text_info      ti;

	gettextinfo(&ti);
	get_modepalette(palette);
	pix = getpixels(x1, y1, x2, y2, false);
	if (pix == NULL)
		return;

	pixel = 0;
	for (y = 0; y < pix->height; y++) {
		for (x = 0; x < pix->width; x++) {
			col = pix->pixels[pixel];
			for (i = 0; i < 16; i++) {
				if (col == palette[i])
					break;
			}
			if (i < 16) {
				i ^= 0x0f;
				pix->pixels[pixel] = palette[i];
			}

			col = pix->pixelsb[pixel];
			for (i = 0; i < 16; i++) {
				if (col == palette[i])
					break;
			}
			if (i < 16) {
				i ^= 0x0f;
				pix->pixelsb[pixel] = palette[i];
			}

			pixel++;
		}
	}
	setpixels(x1, y1, x2, y2, 0, 0, 0, 0, pix, NULL);
	freepixels(pix);
}

/*
 * TODO: This is slow and still broken.  While it's fine for the
 *       pie slices because of their inherent simplicity, it's
 *       not at all good for the poly bezier.  The root of the
 *       problem is really detecting line crossings given just
 *       the raster data.  With the poly line, it's not as hard
 *       since the extents of the lines are known and are fairly
 *       simple to calculate... which is not true for beziers.
 *
 * How this works is it advances looking for line edges, when it
 * reaches the first non-edge pixel after an edge pixel, it toggles
 * the fill boolean, and marks the pixels with a bit in the high
 * byte of the colour.  It does this in four different directions,
 * and any point that was hit by all four directions is filled.
 * Finally, any non-border pixel that touches a filled pixel
 * horizontally or vertically is also filled.
 *
 * TODO: The various loops could all be combined to run all passes
 *       at the same time.  The X and Y loop variables aren't
 *       actually used in the the loops.
 */
static void
do_fill(bool overwrite)
{
	struct ciolib_pixels *pix;
	int                   x, y;
	int                   pixel;
	bool                  fill = false;
	bool                  in_line = false;

	pix = getpixels(0, 0, rip.x_max - 1, rip.y_max - 1, false);
	if (pix == NULL)
		return;
	FREE_AND_NULL(pix->pixelsb);

        // Horizontal even-odd top-left to bottom-right.
	pixel = 0;
	for (y = 0; y < pix->height; y++) {
		in_line = fill = false;
		for (x = 0; x < pix->width; x++) {
			if (in_line) {
				if (!(pix->pixels[pixel] & 0x40000000)) {
					fill = !fill;
					in_line = false;
				}
			}
			else {
				if (pix->pixels[pixel] & 0x40000000)
					in_line = true;
			}
			if (fill & !in_line)
				pix->pixels[pixel] |= 0x20000000;
			pixel++;
		}
	}

        // Horizontal even-odd bottom-right to top-left
	pixel = pix->height * pix->width - 1;
	for (y = 0; y < pix->height; y++) {
		in_line = fill = false;
		for (x = 0; x < pix->width; x++) {
			if (in_line) {
				if (!(pix->pixels[pixel] & 0x40000000)) {
					fill = !fill;
					in_line = false;
				}
			}
			else {
				if (pix->pixels[pixel] & 0x40000000)
					in_line = true;
			}
			if (fill & !in_line)
				pix->pixels[pixel] |= 0x10000000;
			pixel--;
		}
	}

        // Vertical even-odd top-left to bottom-right.
	for (x = 0; x < pix->width; x++) {
		pixel = x;
		in_line = fill = false;
		for (y = 0; y < pix->height; y++) {
			if (in_line) {
				if (!(pix->pixels[pixel] & 0x40000000)) {
					fill = !fill;
					in_line = false;
				}
			}
			else {
				if (pix->pixels[pixel] & 0x40000000)
					in_line = true;
			}
			if (fill & !in_line)
				pix->pixels[pixel] |= 0x08000000;
			pixel += pix->width;
		}
	}

        // Vertical even-odd bottom-right to top-left
	for (x = 0; x < pix->width; x++) {
		pixel = (pix->height * pix->width) - x - 1;
		in_line = fill = false;
		for (y = 0; y < pix->height; y++) {
			if (in_line) {
				if (!(pix->pixels[pixel] & 0x40000000)) {
					fill = !fill;
					in_line = false;
				}
			}
			else {
				if (pix->pixels[pixel] & 0x40000000)
					in_line = true;
			}
			if (fill & !in_line)
				pix->pixels[pixel] |= 0x04000000;
			pixel -= pix->width;
		}
	}

        // Horizontal gap-fill
	pixel = 0;
	for (y = 0; y < pix->height; y++) {
		pixel++;
		for (x = 1; x < pix->width - 1; x++) {
			int filled = pix->pixels[pixel] & 0x3c000000;

			if (filled && (filled != 0x3c000000)) {
				if (((pix->pixels[pixel - 1] & 0xff000000) == 0x3c000000)
				    || ((pix->pixels[pixel + 1] & 0xff000000) == 0x3c000000))
					pix->pixels[pixel] |= 0x3c000000;
			}
			pixel++;
		}
		pixel++;
	}

        // Vertical gap-fill
	for (x = 0; x < pix->width; x++) {
		pixel = x;
		pixel += pix->width;
		for (y = 1; y < pix->height - 1; y++) {
			int filled = pix->pixels[pixel] & 0x3c000000;

			if (filled && (filled != 0x3c000000)) {
				if (((pix->pixels[pixel - pix->width] & 0xff000000) == 0x3c000000)
				    || ((pix->pixels[pixel + pix->width] & 0xff000000) == 0x3c000000))
					pix->pixels[pixel] |= 0x3c000000;
			}
			pixel += pix->width;
		}
		pixel += pix->width;
	}

        // Update the screen
	pixel = 0;
	for (y = 0; y < pix->height; y++) {
		for (x = 0; x < pix->width; x++) {
			switch ((pix->pixels[pixel] >> 26) & 0x1f) {
				case 0:
					break;
				case 15:
					native_fill_pixel(x, y);
					break;
				case 16:
					setpixel(x, y, pix->pixels[pixel] & 0x80ffffff);
					break;
			}
			pixel++;
		}
	}
	freepixels(pix);
}

/*
 * TODO: Not sure why I need to subtract one from x2/y2 here...
 */
static void
draw_button(struct rip_button_style *but, bool inverted)
{
	int      width, height;
	int      ox, oy;
	int      i, x, y;
	uint32_t bg, ch, cs, su, ul, cc;
	int      xinset, yinset;
	char    *p;
	int      top, bottom;
	int      oc;
	bool     hlit, ulined;

        // TODO: Handle "selected" buttons.
        // TODO: Handle Checkboxes
        // TODO: Handle plain buttons
	if (inverted) {
		bg = ega_colours[0x0f ^ 0];
		ch = ega_colours[0x0f ^ but->chighlight];
		cs = ega_colours[0x0f ^ but->cshadow];
		su = ega_colours[0x0f ^ but->csurface];
		ul = ega_colours[0x0f ^ but->culine];
		cc = ega_colours[0x0f ^ but->ccorner];
	}
	else {
		bg = map_rip_color(0);
		ch = map_rip_color(but->chighlight);
		cs = map_rip_color(but->cshadow);
		su = map_rip_color(but->csurface);
		ul = map_rip_color(but->culine);
		cc = map_rip_color(but->ccorner);
	}

	ox = but->box.x1;
	oy = but->box.y1;
	width = but->box.x2 - but->box.x1 + 1;
	height = but->box.y2 - but->box.y1 + 1;
	if (but->flags.recessed && !inverted) {
		width += 4;
		height += 4;
		ox -= 2;
		oy -= 2;
	}
	if (but->flags.bevel) {
		width += (2 * but->bevel_size);
		height += (2 * but->bevel_size);
		ox -= but->bevel_size;
		oy -= but->bevel_size;
	}
	if (but->flags.recessed && !inverted) {
                // Draw recessed box...
		set_line(ox, oy, ox + width - 1, oy, cs, 0xffff, 1);
		set_line(ox, oy, ox, oy + height - 1, cs, 0xffff, 1);
		set_line(ox + width - 1, oy, ox + width - 1, oy + height - 1, ch, 0xffff, 1);
		set_line(ox, oy + height - 1, ox + width - 1, oy + height - 1, ch, 0xffff, 1);
		set_pixel(ox, oy, cc);
		set_pixel(ox + width - 1, oy, cc);
		set_pixel(ox, oy + height - 1, cc);
		set_pixel(ox + width - 1, oy + height - 1, cc);
		set_line(ox + 1, oy + 1, ox + width - 2, oy + 1, bg, 0xffff, 1);
		set_line(ox + 1, oy + 1, ox + 1, oy + height - 2, bg, 0xffff, 1);
		set_line(ox + width - 2, oy + 1, ox + width - 2, oy + height - 2, bg, 0xffff, 1);
		set_line(ox + 1, oy + height - 2, ox + width - 2, oy + height - 2, bg, 0xffff, 1);
		set_pixel(ox + 1, oy + 1, cc);
		set_pixel(ox + width - 2, oy + 1, cc);
		set_pixel(ox, oy + height - 2, cc);
		set_pixel(ox + width - 2, oy + height - 2, cc);
	}
	if (but->flags.bevel) {
		for (i = 1; i <= but->bevel_size; i++) {
			set_line(but->box.x1 - i, but->box.y1 - i, but->box.x2 - 1 + i, but->box.y1 - i, ch, 0xffff, 1);
			set_line(but->box.x1 - i, but->box.y1 - i, but->box.x1 - i, but->box.y2 - 1 + i, ch, 0xffff, 1);
			set_line(but->box.x2 - 1 + i,
			    but->box.y2 - 1 + i,
			    but->box.x2 - 1 + i,
			    but->box.y1 - i,
			    cs,
			    0xffff,
			    1);
			set_line(but->box.x2 - 1 + i,
			    but->box.y2 - 1 + i,
			    but->box.x1 - i,
			    but->box.y2 - 1 + i,
			    cs,
			    0xffff,
			    1);
			set_pixel(but->box.x1 - i, but->box.y1 - i, cc);
			set_pixel(but->box.x2 - 1 + i, but->box.y1 - i, cc);
			set_pixel(but->box.x1 - i, but->box.y2 - 1 + i, cc);
			set_pixel(but->box.x2 - 1 + i, but->box.y2 - 1 + i, cc);
		}
	}
	for (y = but->box.y1; y < but->box.y2; y++) {
		for (x = but->box.x1; x < but->box.x2; x++)
			set_pixel(x, y, su);
	}
	if (but->flags.sunken) {
		set_line(but->box.x1, but->box.y1, but->box.x2, but->box.y1, cs, 0xffff, 1);
		set_line(but->box.x1, but->box.y1, but->box.x1, but->box.y2, cs, 0xffff, 1);
		set_line(but->box.x2, but->box.y2, but->box.x2, but->box.y1, ch, 0xffff, 1);
		set_line(but->box.x2, but->box.y2, but->box.x1, but->box.y2, ch, 0xffff, 1);
		set_pixel(but->box.x1, but->box.y1, cc);
		set_pixel(but->box.x2, but->box.y1, cc);
		set_pixel(but->box.x2, but->box.y2, cc);
		set_pixel(but->box.x1, but->box.y2, cc);
	}
	if (but->flags.chisel) {
		chisel_inset(but->box.y2 - but->box.y1 + 1, &xinset, &yinset);
		set_line(but->box.x1 + xinset,
		    but->box.y1 + yinset,
		    but->box.x2 - xinset - 1,
		    but->box.y1 + yinset,
		    cs,
		    0xffff,
		    1);
		set_line(but->box.x1 + xinset,
		    but->box.y1 + yinset,
		    but->box.x1 + xinset,
		    but->box.y2 - yinset - 1,
		    cs,
		    0xffff,
		    1);

		set_line(but->box.x1 + xinset + 1,
		    but->box.y1 + yinset + 1,
		    but->box.x2 - xinset - 1,
		    but->box.y1 + yinset + 1,
		    ch,
		    0xffff,
		    1);
		set_line(but->box.x2 - xinset - 1,
		    but->box.y1 + yinset + 1,
		    but->box.x2 - xinset - 1,
		    but->box.y2 - yinset - 1,
		    ch,
		    0xffff,
		    1);
		set_line(but->box.x2 - xinset - 1,
		    but->box.y2 - yinset - 1,
		    but->box.x1 + xinset + 1,
		    but->box.y2 - yinset - 1,
		    ch,
		    0xffff,
		    1);
		set_line(but->box.x1 + xinset + 1,
		    but->box.y2 - yinset - 1,
		    but->box.x1 + xinset + 1,
		    but->box.y1 + yinset + 1,
		    ch,
		    0xffff,
		    1);

		set_line(but->box.x1 + xinset + 2,
		    but->box.y2 - 2 - yinset,
		    but->box.x2 - xinset - 2,
		    but->box.y2 - 2 - yinset,
		    cs,
		    0xffff,
		    1);
		set_line(but->box.x2 - xinset - 2,
		    but->box.y2 - 2 - yinset,
		    but->box.x2 - xinset - 2,
		    but->box.y1 + yinset + 2,
		    cs,
		    0xffff,
		    1);
	}

        // TODO: Handle icons
	if (but->flags.autostamp) {
		if (rip.clipboard)
			freepixels(rip.clipboard);
		rip.clipboard = getpixels(but->box.x1 - but->bevel_size,
		        but->box.y1 - but->bevel_size,
		        but->box.x2 + but->bevel_size,
		        but->box.y2 + but->bevel_size,
		        false);
		rip.bstyle.button = BUTTON_TYPE_CLIPBOARD;
		rip.bstyle.flags.chisel = false;
		rip.bstyle.flags.bevel = false;
		rip.bstyle.flags.autostamp = false;
		rip.bstyle.flags.sunken = false;
	}
	if (but->flags.left_justify)
		puts("TODO: Left Justify flag");
	if (but->flags.right_justify)
		puts("TODO: Right Justify flag");
	if (but->label) {
		switch (but->label_location) {
			case LABEL_LOC_ABOVE:
			case LABEL_LOC_BELOW:
			case LABEL_LOC_LEFT:
			case LABEL_LOC_RIGHT:
                                // TODO: Other locations...
				printf("TODO: Label location %d\n", but->label_location);
				break;
			case LABEL_LOC_CENTER:
                                // TODO: Handle left/right justify?
                                // First, calculate the total text width...
				width = 0;
				top = -1;
				bottom = -1;
				for (p = but->label; *p; p++) {
					width += char_width(*p);
					if (but->flags.vadjust)
						char_top_bottom(*p, &x, &y);
					else
						char_top_base(*p, &x, &y);
					if ((x >= 0) && ((top == -1) || (x < top)))
						top = x;
					if ((y >= 0) && (y > bottom))
						bottom = y;
				}
				if (top == -1)
					break;
				if (but->flags.dropshadow) {
					width++;
					bottom++;
				}
				height = bottom - top + 1;
				x = but->box.x1 + (but->box.x2 - but->box.x1 - width) / 2;
				y = but->box.y1 + (but->box.y2 - but->box.y1 + 1 - height) / 2 - top;

                                // TODO: Does this leave the text position in the button?
				oc = rip.color;
				ox = rip.x;
				oy = rip.y;
				if (but->flags.dropshadow) {
					rip.x = x + 1;
					rip.y = y + 1;
					if (inverted)
						rip.color = 0x0f ^ but->cdshadow;
					else
						rip.color = but->cdshadow;
					for (p = but->label; *p; p++)
						write_char(*p);
				}
				rip.x = x;
				rip.y = y;

                                // TODO: It almost certainly doesn't change the colour...
				hlit = ulined = false;
				for (p = but->label; *p; p++) {
					if ((!hlit) && but->flags.highlighthk
					    && (toupper(*p) == toupper(but->hotkey))) {
						if (inverted)
							rip.color = 0x0f ^ but->chighlight;
						else
							rip.color = but->chighlight;
						hlit = true;
					}
					else {
						if (inverted)
							rip.color = 0x0f ^ but->cfore;
						else
							rip.color = but->cfore;
					}
					if ((!ulined) && but->flags.highlighthk
					    && (toupper(*p) == toupper(but->hotkey))) {
						if (inverted)
							rip.color = 0x0f ^ but->culine;
						else
							rip.color = but->culine;
					}
					write_char(*p);
					if ((!ulined) && but->flags.underlinehk
					    && (toupper(*p) == toupper(but->hotkey))) {
						char_top_bottom(*p, &x, &y);
						x = char_width(*p);
						set_line(rip.x - x,
						    rip.y + y + 2 + but->flags.dropshadow,
						    rip.x - 2,
						    rip.y + y + 2 + but->flags.dropshadow,
						    ul,
						    0xffff,
						    1);
						ulined = true;
					}
				}
				rip.color = oc;
				rip.x = ox;
				rip.y = oy;
		}
	}
}

static void
add_button(int x1, int y1, int x2, int y2, int hotkey, int flags, char *text)
{
	struct rip_button_style *but;
	struct mouse_field      *mf;
	char                    *label;
	char                    *p;

	but = malloc(sizeof(struct rip_button_style));
	memcpy(but, &rip.bstyle, offsetof(struct rip_button_style, box));
	but->box.x1 = x1 + rip.viewport.sx;
	but->box.y1 = y1 + rip.viewport.sy;
	if ((x2 == 0) && (y2 == 0) && rip.bstyle.width && rip.bstyle.height) {
		but->box.x2 = but->box.x1 + rip.bstyle.width - 1;
		but->box.y2 = but->box.y1 + rip.bstyle.height - 1;
	}
	else {
		but->box.x2 = x2 + rip.viewport.sx;
		but->box.y2 = y2 + rip.viewport.sy;
	}
	p = strstr(text, "<>");
	if (p == NULL) {
		if (text[0])
			but->icon = strdup(text);
		else
			but->icon = NULL;
		but->label = NULL;
		but->command = NULL;
	}
	else {
		if (p == text) {
			but->icon = NULL;
		}
		else {
			but->icon = malloc(p - text + 1);
			memcpy(but->icon, text, p - text);
			but->icon[p - text] = 0;
		}
		label = p + 2;
		if (*label == 0) {
			but->label = NULL;
			but->command = NULL;
		}
		else {
			p = strstr(label, "<>");
			if (p == NULL) {
				but->command = NULL;
				but->label = strdup(label);
			}
			else {
				but->label = malloc(p - label + 1);
				memcpy(but->label, label, p - label);
				but->label[p - label] = 0;
				if (p[2] == 0)
					but->command = NULL;
				else
					but->command = strdup(p + 2);
			}
		}
	}
	but->bflags = flags;
	but->hotkey = hotkey;
	if (but->flags.mouse) {
		mf = malloc(sizeof(*mf));
		mf->data.button = but;
		mf->type = MOUSE_FIELD_BUTTON;
		mf->next = rip.mfields;
		rip.mfields = mf;
	}

	draw_button(but, false);
	if (!but->flags.mouse) {
		free(but->command);
		free(but->icon);
		free(but->label);
		free(but);
	}
}

static void
append_str(uint8_t **resp, size_t *size, size_t *pos, const char *str)
{
	size_t   slen;
	size_t   newsize;
	uint8_t *newresp;

	if (str == NULL)
		return;
	slen = strlen(str);
	if (*pos + slen + 1 > *size) {
		if (*size == 0)
			newsize = 16;
		else
			newsize = *size * 2;
		if (*pos + slen + 1 > newsize)
			newsize = *pos + slen + 1;
		newresp = realloc(*resp, newsize);

                // TODO: Handle this better?
		if (newresp == NULL)
			return;
		*resp = newresp;
		*size = newsize;
	}
	memcpy(&(*resp)[*pos], str, slen + 1);
	(*pos) += slen;
}

static char *
do_popup(const char * const str)
{
	struct popup_option  *popt;
	size_t                opts;
	char                 *question;
	char                 *soo; // Start Of Opts
	char                 *p, *p2, *p3, *p4;
	int                   i, j;
	int                   x, y, x1, y1, x2, y2, width, height, maxwidth;
	bool                  must_answer = false;
	uint32_t              black;
	uint32_t              white;
	uint32_t              dark;
	uint32_t              light;
	int                   oc, ox, oy;
	int                   ch;
	struct mouse_event    mevent;
	size_t                curr;
	int                   ret;
	struct ciolib_pixels *pix;

	black = map_rip_color(0);
	white = map_rip_color(15);
	dark = map_rip_color(8);
	light = map_rip_color(7);
	p = (char *)str;
	if (str[0] == '*') {
		must_answer = true;
		p++;
	}
	soo = strstr(p, "::");
	if (soo == NULL)
		return NULL;
	question = strndup(p, soo - p);
	if (question == NULL)
		return NULL;
	soo += 2;
	p = soo;
	opts = 0;
	while ((p2 = strchr(p, ',')) != NULL) {
		opts++;
		p = p2 + 1;
	}
	opts++;
	popt = malloc(sizeof(*popt) * opts);
	p = soo;
	maxwidth = 0;
	for (i = 0; i < opts; i++) {
		p2 = strchr(p, ',');
		if (p2 == NULL)
			p2 = strchr(p, 0);
		p3 = strchr(p, '@');
		if (p3 == NULL)
			p3 = strchr(p, 0);
		if (p3 < p2) {
			popt[i].text = strndup(p3 + 1, p2 - p3 - 1);
			popt[i].resp = strndup(p, p3 - p);
		}
		else {
			popt[i].text = strndup(p, p2 - p);
			popt[i].resp = strndup(p, p2 - p);
		}
		popt[i].width = 0;
		popt[i].hk = 0;
		for (p4 = popt[i].text; *p4; p4++) {
			if ((*p4 != '_') && (*p4 != '~')) {
				popt[i].width++;
			}
			else {
				if (popt[i].hk == 0)
					popt[i].hk = *(p4 + 1);
			}
		}
		if (popt[i].width > maxwidth)
			maxwidth = popt[i].width;
		p = p2 + 1;
	}

        // Now we draw the popup...
        // TODO: Figure out how RIPterm sizes the popup maybe...
	height = 27 + (opts * 13) + 7;
	width = 29 + 29 + (maxwidth * 8);
	if (width < 29 + 29 + (strlen(question) * 8))
		width = 29 + 29 + (strlen(question) * 8);

        // TODO: Scale to actual screen...
	x1 = (rip.x_dim - width) / 2;
	y1 = (rip.y_dim - height) / 2;
	x2 = x1 + width - 1;
	y2 = y1 + height - 1;
	pix = getpixels(x1, y1, x2, y2, false);
	set_line(x1, y1, x2, y1, black, 0xffff, 1);
	set_line(x1, y1, x1, y2, black, 0xffff, 1);
	set_line(x1 + 1, y1 + 1, x1 + 1, y2 - 1, black, 0xffff, 1);
	set_line(x2, y1, x2, y2, black, 0xffff, 1);
	set_line(x2 - 1, y1 + 1, x2 - 1, y2 - 1, black, 0xffff, 1);
	set_line(x1, y2, x2, y2, black, 0xffff, 1);
	set_pixel(x1 + 2, y1 + 1, light);
	set_pixel(x1 + 3, y1 + 2, light);
	set_pixel(x1 + 4, y1 + 2, light);
	set_pixel(x1 + 5, y1 + 3, light);
	set_pixel(x1 + 2, y2 - 1, light);
	set_pixel(x1 + 3, y2 - 2, light);
	set_pixel(x1 + 4, y2 - 2, light);
	set_pixel(x1 + 5, y2 - 3, light);
	set_pixel(x2 - 2, y1 + 1, light);
	set_pixel(x2 - 3, y1 + 2, light);
	set_pixel(x2 - 4, y1 + 2, light);
	set_pixel(x2 - 5, y1 + 3, light);
	set_pixel(x2 - 2, y2 - 1, light);
	set_pixel(x2 - 3, y2 - 2, light);
	set_pixel(x2 - 4, y2 - 2, light);
	set_pixel(x2 - 5, y2 - 3, light);
	set_line(x1 + 3, y1 + 1, x2 - 3, y1 + 1, white, 0xffff, 1);
	set_line(x1 + 5, y1 + 2, x2 - 5, y1 + 2, white, 0xffff, 1);
	set_line(x1 + 6, y1 + 3, x2 - 6, y1 + 3, white, 0xffff, 1);
	set_line(x1 + 3, y2 - 1, x2 - 3, y2 - 1, dark, 0xffff, 1);
	set_line(x1 + 5, y2 - 2, x2 - 5, y2 - 2, dark, 0xffff, 1);
	set_line(x1 + 6, y2 - 3, x2 - 6, y2 - 3, dark, 0xffff, 1);

	set_line(x1 + 2, y1 + 2, x1 + 2, y2 - 2, white, 0xffff, 1);
	set_line(x1 + 3, y1 + 3, x1 + 3, y2 - 3, white, 0xffff, 1);
	set_line(x1 + 4, y1 + 3, x1 + 4, y2 - 3, white, 0xffff, 1);
	set_line(x1 + 5, y1 + 4, x1 + 5, y2 - 4, white, 0xffff, 1);

	set_line(x2 - 2, y1 + 2, x2 - 2, y2 - 2, dark, 0xffff, 1);
	set_line(x2 - 3, y1 + 3, x2 - 3, y2 - 3, dark, 0xffff, 1);
	set_line(x2 - 4, y1 + 3, x2 - 4, y2 - 3, dark, 0xffff, 1);
	set_line(x2 - 5, y1 + 4, x2 - 5, y2 - 4, dark, 0xffff, 1);
	for (y = y1 + 4; y <= y2 - 4; y++) {
		for (x = x1 + 6; x <= x2 - 6; x++)
			set_pixel(x, y, light);
	}
	set_line(x1 + 11, y1 + 26, x1 + 11, y2 - 7, dark, 0xffff, 1);
	set_line(x1 + 12, y1 + 25, x2 - 12, y1 + 25, dark, 0xffff, 1);
	set_line(x2 - 11, y1 + 26, x2 - 11, y2 - 7, white, 0xffff, 1);
	set_line(x1 + 12, y2 - 6, x2 - 12, y2 - 6, white, 0xffff, 1);

	set_line(x1 + 12, y1 + 26, x2 - 12, y1 + 26, black, 0xffff, 1);
	set_line(x2 - 12, y1 + 26, x2 - 12, y2 - 7, black, 0xffff, 1);
	set_line(x2 - 12, y2 - 7, x1 + 12, y2 - 7, black, 0xffff, 1);
	set_line(x1 + 12, y2 - 7, x1 + 12, y1 + 26, black, 0xffff, 1);

	x = (rip.x_dim - strlen(question) * 8) / 2;
	y = y1 + 12;
	oc = rip.color;
	ox = rip.x;
	oy = rip.y;

	rip.color = 0;
	rip.x = x + 1;
	rip.y = y + 1;
	write_text(question);
	rip.color = 14;
	rip.x = x;
	rip.y = y;
	write_text(question);
	free(question);

	for (i = 0; i < opts; i++) {
		set_pixel(x1 + 13, y1 + 27 + (i * 13), light);
		set_pixel(x1 + 13, y1 + 39 + (i * 13), light);
		set_pixel(x2 - 13, y1 + 27 + (i * 13), light);
		set_pixel(x2 - 13, y1 + 39 + (i * 13), light);
		set_line(x1 + 14, y1 + 27 + (i * 13), x2 - 14, y1 + 27 + (i * 13), white, 0xffff, 1);
		set_line(x1 + 13, y1 + 28 + (i * 13), x1 + 13, y1 + 38 + (i * 13), white, 0xffff, 1);
		set_line(x2 - 14, y1 + 28 + (i * 13), x2 - 14, y1 + 38 + (i * 13), dark, 0xffff, 1);
		set_line(x1 + 14, y1 + 38 + (i * 13), x2 - 14, y1 + 38 + (i * 13), dark, 0xffff, 1);
		rip.color = 0;
		rip.x = x1 + 29;
		rip.y = y1 + 30 + (i * 13);
		for (p = popt[i].text; *p; p++) {
			if ((*p == '~') || (*p == '_')) {
				if (rip.color == 0)
					rip.color = 1;
				else
					rip.color = 0;
				continue;
			}
			write_char(*p);
		}
	}
	invert_rect(x1 + 13, y1 + 27, x2 - 13, y1 + 39);

        // TODO: Update time in status bar...
	curr = 0;
	i = curr;
	ret = -1;
	while (ret == -1) {
		ciomouse_addevent(CIOLIB_MOUSE_MOVE);
		ch = getch();
		if ((ch == 0) || (ch == 0xe0)) {
			ch |= getch() << 8;
			if (ch == CIO_KEY_LITERAL_E0)
				ch = 0xe0;
		}
		switch (ch) {
			case CIO_KEY_MOUSE:
				getmouse(&mevent);

                                // HACK...
				mevent.startx_res = unmap_rip_x(mevent.startx_res);
				mevent.starty_res = unmap_rip_y(mevent.starty_res);
				if (mevent.event == CIOLIB_MOUSE_MOVE) {
					if ((mevent.startx_res >= x1 + 14) && (mevent.startx_res <= x2 - 14)
					    && (mevent.starty_res >= y1 + 27) && (mevent.starty_res <= y2 - 8))
						i = (mevent.starty_res - (y1 + 27)) / 13;
				}
				else if (mevent.event == CIOLIB_BUTTON_1_PRESS) {
					if ((mevent.startx_res >= x1 + 14) && (mevent.startx_res <= x2 - 14)
					    && (mevent.starty_res >= y1 + 27) && (mevent.starty_res <= y2 - 8))
						i = (mevent.starty_res - (y1 + 27)) / 13;
					ciomouse_delevent(CIOLIB_MOUSE_MOVE);
				}
				else if (mevent.event == CIOLIB_BUTTON_1_RELEASE) {
					ret = curr;
				}
				break;
			case CIO_KEY_DOWN:
				i++;
				if (i >= opts)
					i = 0;
				break;
			case CIO_KEY_UP:
				if (i == 0)
					i = opts;
				i--;
				break;
			case '\r':
			case '\n':
				ret = curr;
				break;
			case '\x1b':
				if (!must_answer)
					ret = -2;
				break;
			default:
				for (j = 0; j < opts; j++) {
					if (toupper(ch) == popt[j].hk) {
						ret = j;
						i = j;
					}
				}
		}
		if (i != curr) {
			invert_rect(x1 + 13, y1 + 27 + (13 * curr), x2 - 13, y1 + 39 + (13 * curr));
			curr = i;
			invert_rect(x1 + 13, y1 + 27 + (13 * curr), x2 - 13, y1 + 39 + (13 * curr));
		}
	}

	for (i = 0; i < opts; i++) {
		if (i == ret)
			p = popt[i].resp;
		else
			free(popt[i].resp);
		free(popt[i].text);
	}
	free(popt);
	rip.color = oc;
	rip.x = ox;
	rip.y = oy;
	setpixels(x1, y1, x2, y2, 0, 0, 0, 0, pix, NULL);
	freepixels(pix);
	if (ret < 0)
		return NULL;
	return p;
}

static void
handle_command_str(const char *incmd)
{
	const char *p, *p2, *p3, *p4;
	char        str[2];
	char *indup;

	if (incmd == NULL)
		return;
	indup = strdup(incmd);

	for (p = indup; *p; p++) {
                // TODO: No way to send a ^ or a $ or a [
		if ((*p == '^') || (*p == '`')) { // CTRL char
			p++;
			if (*p == '^') {
				append_str(&ripbuf, &ripbuf_size, &ripbuf_pos, "^");
			}
			else if ((*p <= '_') && (*p >= '@')) {
				str[0] = *p - '@';
				str[1] = 0;
				append_str(&ripbuf, &ripbuf_size, &ripbuf_pos, str);
			}
		}
		else if (*p == '$') {
			p2 = strchr(p + 1, '$');
			if (p2 != NULL) {
				p3 = strndup(p + 1, p2 - p - 1);
				p4 = get_text_variable(p3);
				free((void *)p3);
				append_str(&ripbuf, &ripbuf_size, &ripbuf_pos, p4);
				free((void *)p4);
				p = p2;
			}
		}
		else if ((*p == '(') && (*(p + 1) == '(')) { // Popups...
			p2 = strstr(p, "))");
			if (p2) {
				p3 = strndup(p + 2, p2 - p - 2);
				p4 = do_popup(p3);
				free((void *)p3);

                                // Hell yeah we're recursing!  WOOT!
				handle_command_str(p4);
				free((void *)p4);
				p = p2 + 1;
			}
		}
#if 0
                // TODO: Templates!
		else if (*p == '[') { // Templates
			printf("TODO: Templates!\n");
		}
#endif
		else {
			str[0] = *p;
			str[1] = 0;
			append_str(&ripbuf, &ripbuf_size, &ripbuf_pos, str);
		}
	}
	if (ripbuf && (ripbuf[0] == 0)) {
		free(ripbuf);
		ripbuf = NULL;
		ripbuf_size = 0;
		ripbuf_pos = 0;
		ripbufpos = 0;
	}
	free(indup);
}

static void
kill_saved_mouse_fields(void)
{
	struct mouse_field *field;

	while (rip.saved_mfields) {
		field = rip.saved_mfields;
		rip.saved_mfields = field->next;
		switch (field->type) {
			case MOUSE_FIELD_BUTTON:
				free(field->data.button->icon);
				free(field->data.button->label);
				free(field->data.button->command);
				free(field->data.button);
				free(field);
				break;
			case MOUSE_FIELD_HOT:
				free(field->data.hot->command);
				free(field->data.hot);
				free(field);
				break;
		}
	}
}

static void
copy_mouse_fields(struct mouse_field *from, struct mouse_field **to)
{
	struct mouse_field  *new_field;
	struct mouse_field  *src;
	struct mouse_field **dst;

	for (src = from, dst = to; src; src = src->next, dst = &((*dst)->next)) {
		new_field = malloc(sizeof(struct mouse_field));
		if (new_field == NULL) {
			*dst = NULL;
			return;
		}
		memcpy(new_field, src, sizeof(*src));
		switch (new_field->type) {
			case MOUSE_FIELD_BUTTON:
				new_field->data.button = malloc(sizeof(*new_field->data.button));
				memcpy(new_field->data.button, src->data.button, sizeof(*src->data.button));
				if (new_field->data.button->icon)
					new_field->data.button->icon = strdup(new_field->data.button->icon);
				if (new_field->data.button->label)
					new_field->data.button->label = strdup(new_field->data.button->label);
				if (new_field->data.button->command)
					new_field->data.button->command = strdup(new_field->data.button->command);
				break;
			case MOUSE_FIELD_HOT:
				new_field->data.hot = malloc(sizeof(*new_field->data.hot));
				memcpy(new_field->data.hot, src->data.hot, sizeof(*src->data.hot));
				if (new_field->data.hot->command)
					new_field->data.hot->command = strdup(new_field->data.hot->command);
				break;
		}
		*dst = new_field;
	}
}

static void
kill_mouse_fields(void)
{
	struct mouse_field *field;

	while (rip.mfields) {
		field = rip.mfields;
		rip.mfields = field->next;
		if (rip_pressed == field) {
			if (rip_pressed->type == MOUSE_FIELD_BUTTON) {
				if (rip_pressed->data.button->flags.invertable) {
					invert_rect(rip_pressed->data.button->box.x1 - rip_pressed->data.button->bevel_size
					    ,
					    rip_pressed->data.button->box.y1 - rip_pressed->data.button->bevel_size
					    ,
					    rip_pressed->data.button->box.x2 - rip_pressed->data.button->bevel_size
					    ,
					    rip_pressed->data.button->box.y2 - rip_pressed->data.button->bevel_size);
				}
			}
			else if (rip_pressed->type == MOUSE_FIELD_HOT) {
				if (rip_pressed->data.hot->invertable) {
					invert_rect(rip_pressed->data.hot->box.x1, rip_pressed->data.hot->box.y1,
					    rip_pressed->data.hot->box.x2, rip_pressed->data.hot->box.y2);
				}
			}
			rip_pressed = NULL;
		}
		switch (field->type) {
			case MOUSE_FIELD_BUTTON:
				free(field->data.button->icon);
				free(field->data.button->label);
				free(field->data.button->command);
				free(field->data.button);
				free(field);
				break;
			case MOUSE_FIELD_HOT:
				free(field->data.hot->command);
				free(field->data.hot);
				free(field);
				break;
		}
	}
}

// TODO: this currently doesn't seem to work (shocker!)
static void
reinit_screen(uint8_t *font, int fx, int fy)
{
        // TODO: Mystery rows in 8x8 mode...
	struct ciolib_pixels *pix = getpixels(0, 0, rip.x_max - 1, rip.y_max - 1, false);
	struct cterminal      oldcterm = *cterm;
	int                   old_hold = hold_update;
	int                   cols = 80;
	int                   rows = 43;
	void                 *nvmem;
	uint32_t lcf;
	bool fh_change;

	rip_did_reinit = true;
	hold_update = 0;
	cterm->logfile = NULL;
	cterm->log = CTERM_LOG_NONE;
	lcf = cterm->last_column_flag;
	cterm_end(cterm, 0);
	normal_palette();

        // TODO: You know this is insane right?
        // Patch vstat font, font size, and cols
	if (font == ripfnt7x8)
		cols = 91;
	if (font == ripfnt7x14)
		cols = 91;
	if (font == ripfnt16x14)
		cols = 40;
	assert_rwlock_wrlock(&vstatlock);
	fh_change = fy != vstat.charheight;
	rows = vstat.scrnheight / fy;
	if ((font != vstat.forced_font) || (fx != vstat.charwidth) || (fy != vstat.charheight)) {
		vstat.forced_font = font;
		vstat.charwidth = fx;
		vstat.charheight = fy;
		vstat.cols = cols;
		vstat.rows = rows;
		if (fh_change) {
			if (fy > 8)
				vstat.default_curs_start = vstat.charheight - 2;
			else
				vstat.default_curs_start = vstat.charheight - 1;
			vstat.default_curs_end = vstat.charheight - 1;
			vstat.curs_start = vstat.default_curs_start;
			vstat.curs_end = vstat.default_curs_end;
		}

                // We need to update gettextinfo() results as well...
		cio_textinfo.screenwidth = cols;
		cio_textinfo.screenheight = rows;

                // And this crappy thing.
		term.width = cols;
		term.height = rows;

                // Now, make the vmem array large enough for the new bits...
                // TODO: Handle failures!
		nvmem = realloc(vstat.vmem->vmem, vstat.cols * vstat.rows * sizeof(vstat.vmem->vmem[0]));

                // And use it.
		vstat.vmem->top_row = 0;
		vstat.vmem->width = cols;
		vstat.vmem->height = rows;
		vstat.vmem->count = cols * rows;
		vstat.vmem->vmem = nvmem;
		for (size_t off = 0; off < vstat.vmem->count; off++) {
			vstat.vmem->vmem[off].bg = 0x04000000;
			vstat.vmem->vmem[off].fg = 0x04000000;
			vstat.vmem->vmem[off].ch = ' ';
			vstat.vmem->vmem[off].font = 0;
			vstat.vmem->vmem[off].legacy_attr = 7;
		}
	}
	assert_rwlock_unlock(&vstatlock);

        // Initialize it...
	clrscr();
	get_term_win_size(&term.width, &term.height, NULL, NULL, &term.nostatus);
	term.width = cols;
	cterm = cterm_init(rows + (term.nostatus ? 0 : -1),
	        cols,
	        oldcterm.x,
	        oldcterm.y,
	        oldcterm.backlines,
	        oldcterm.backwidth,
	        oldcterm.scrollback,
	        oldcterm.emulation);
	if (lcf & CTERM_LCF_FORCED)
		cterm->last_column_flag = CTERM_LCF_FORCED | CTERM_LCF_SET;
	cterm->apc_handler = oldcterm.apc_handler;
	cterm->apc_handler_data = oldcterm.apc_handler_data;
	cterm->mouse_state_change = oldcterm.mouse_state_change;
	cterm->mouse_state_change_cbdata = oldcterm.mouse_state_change_cbdata;
	cterm->mouse_state_query = oldcterm.mouse_state_query;
	cterm->mouse_state_query_cbdata = oldcterm.mouse_state_query_cbdata;
	cterm->music_enable = oldcterm.music_enable;
	cterm->backpos = oldcterm.backpos;
	cterm->backwidth = oldcterm.backwidth;
	cterm->attr = oldcterm.attr;
	cterm->started = 0;
	cterm->bg_color = oldcterm.bg_color - 16;
	cterm->fg_color = oldcterm.fg_color - 16;
	cterm_start(cterm);
	cterm->logfile = oldcterm.logfile;
	cterm->log = oldcterm.log;
	shadow_palette();
	set_ega_palette();
	attr2palette(cterm->attr, &cterm->fg_color, &cterm->bg_color);
	gotoxy(1, 1);

        // This is to force a vmem flush...
	freepixels(getpixels(0, 0, 1, 1, true));
	setpixels(0, 0, rip.x_max - 1, rip.y_max - 1, 0, 0, 0, 0, pix, NULL);
	setwindow(cterm);
	hold_update = old_hold;
	freepixels(pix);
}

// M. Douglas McIlroy
// There Is No Royal Road to Programs - A Trilogy on Raster Ellipses and Programming Methodology
#define incx() x++, dxt += d2xt, t += dxt
#define incy() y--, dyt += d2yt, t += dyt

static void
full_ellipse(int xc, int yc, int sa, int ea, int a, int b, bool fill, uint32_t colour)
{
	if (b == 0) {
		b = 1;
		a--;
	}
	if (a <= 0)
		a = 1;

	int    x = 0, y = b;
	long   a2 = (long)a * a;
	long   b2 = (long)b * b;
	long   crit1 = -(a2 / 4 + a % 2 + b2);
	long   crit2 = -(b2 / 4 + b % 2 + a2);
	long   crit3 = -(b2 / 4 + b % 2);
	long   t = -(a2 * y); /* t = e(x+1/2,y-1/2) - (a²+b²)/4 */
	long   dxt = 2 * b2 * x, dyt = -2 * a2 * y;
	long   d2xt = 2 * b2, d2yt = 2 * a2;
	int    fy;
	bool   inv = ea < sa;
	bool   skip = false;
	double angle;
	double qangle;

	while (y >= 0 && x <= a) {
		angle = atan((x * M_PI / 180.0) / (y * M_PI / 180.0));
		angle *= 180.0;
		angle /= M_PI;
		angle = lround(90.0 - angle);
		if (!skip) {
			if ((x != 0) || (y != 0)) {
                                // Top-left quadrant.
				qangle = 180 - angle;
				if (fill) {
					if (x == 0) {
						for (fy = yc - y + 1; fy < yc + y; fy++)
							fill_pixel(xc, fy);
					}
				}
				if (rip.borders) {
					if (((sa <= qangle) && (ea >= qangle))
					    || (inv && (ea <= qangle) && (sa >= qangle)))
						set_pixel(xc - x, yc - y, colour);
				}
			}
			if ((x != 0) && (y != 0)) {
				if (fill) {
					for (fy = yc - y + 1; fy < yc + y; fy++) {
						fill_pixel(xc - x, fy);
						fill_pixel(xc + x, fy);
					}
				}
				if (rip.borders) {
                                        // Top-right quadrant.
					if (((sa <= angle) && (ea >= angle))
					    || (inv && (ea <= angle) && (sa >= angle)))
						set_pixel(xc + x, yc - y, colour);

                                        // Bottom-left quadrant.
					qangle = 180 + angle;
					if (((sa <= qangle) && (ea >= qangle))
					    || (inv && (ea <= qangle) && (sa >= qangle)))
						set_pixel(xc - x, yc + y, colour);
				}
			}

                        // Bottom-right quadrant
			qangle = 360 - angle;
			if (rip.borders) {
				if (((sa <= qangle) && (ea >= qangle)) || (inv && (ea <= qangle) && (sa >= qangle)))
					set_pixel(xc + x, yc + y, colour);
			}
		}
		skip = false;
		if ((t + b2 * x <= crit1)       /* e(x+1,y-1/2) <= 0 */
		    || (t + a2 * y <= crit3)) { /* e(x+1/2,y) <= 0 */
			incx();

                        // Angle move, skip next...
			if (!((t + b2 * x <= crit1) || (t + a2 * y <= crit3)) && (t - a2 * y > crit2))
				skip = true;
		}
		else if (t - a2 * y > crit2) { /* e(x+1/2,y-1) > 0 */
			incy();

                        // Angle move, skip next...
			if ((t + b2 * x <= crit1) || (t + a2 * y <= crit3))
				skip = true;
		}
		else {
			incx();
			incy();
		}
	}
	if ((rip.line_width == 3) && rip.borders) {
		rip.line_width = 1;
		full_ellipse(xc, yc, sa, ea, a - 1, b - 1, false, colour & 0xcfffffff);
		full_ellipse(xc, yc, sa, ea, a + 1, b + 1, false, colour & 0xcfffffff);
		rip.line_width = 3;
	}
}

struct saved_point {
	int                 x;
	int                 y;
	int                 oy;
	struct saved_point *next;
};

static void
bff_push(struct saved_point **stack, int x, int y, int oy)
{
	struct saved_point *new = malloc(sizeof(*new));

	if (new) {
		new->x = x;
		new->y = y;
		new->oy = oy;
		new->next = *stack;
		*stack = new;
	}
}

/*
 * The RIPterm flood fill is a raster-based fill with (at least) three bugs...
 * 1) It will not fill through a single pixel hole against the left or
 *    right side of the viewport (see pmid1.rip)
 * 2) When filling with a pattern, pixels are only checked in adjacent lines
 *    if the main line is being set to foreground (see carn.rip) or if the current
 *    fill pattern line is empty (see ghost.rip)
 * 3) When filling with color 0, never fills in (ie: doesn't change direction)
 *    (see fiero.rip)
 */

static void
broken_flood_fill(struct ciolib_pixels *pix,
    int                                 x,
    int                                 y,
    uint32_t                            edge,
    uint32_t                            fillfg,
    uint32_t                            fillbg,
    bool                                iszero,
    int                                 oy,
    struct saved_point                **orig_stack)
{
	bool                 nextline = false;
	bool                 prevline = false;
	int                  foff;
	int                  noff;
	int                  poff;
	int                  vx, vy;
	struct saved_point **stack = orig_stack;
	struct saved_point  *new_stack = NULL;
	struct saved_point  *this = NULL;

	if (stack == NULL)
		stack = &new_stack;
	if ((x < 0) || (y < 0))
		return;
	if (x >= pix->width)
		return;
	if (y >= pix->height)
		return;
	foff = y * pix->width + x;
	if ((pix->pixels[foff] & 0x80ffffff) == edge)
		return;
	if (pix->pixels[foff] & 0x40000000)
		return;

        // For simplicity sake, we just move left to an edge.
	if (x > 0) {
		while (foff > 0 && (pix->pixels[foff - 1] & 0x80ffffff) != edge) {
			foff--;
			if (--x == 0)
				break;
		}
		foff = y * pix->width + x;
	}

	vx = (rip.viewport.sx + x) & 0x07;
	vy = (rip.viewport.sy + y) & 0x07;
	if (y > 0)
		poff = pix->width * (y - 1) + x;
	else
		poff = -1;
	if (iszero && (oy == y - 1))
		poff = -1;

	if (y < (pix->height - 1))
		noff = pix->width * (y + 1) + x;
	else
		noff = -1;
	if (iszero && (oy == y + 1))
		noff = -1;

	for (; x < pix->width; x++) {
		if ((pix->pixels[foff] & 0x80ffffff) == edge)
			break;
		if (pix->pixels[foff] & 0x40000000)
			break;
		if (rip.fill_pattern[vy] & (0x80 >> vx))
			pix->pixels[foff] = fillfg;
		else
			pix->pixels[foff] = fillbg;
		pix->pixels[foff] |= 0x40000000;
		if ((rip.fill_pattern[vy] == 0) || rip.fill_pattern[vy] & (0x80 >> vx)) {
                        // Now, check previous line...
			if (poff >= 0) {
				if (prevline) {
					if ((pix->pixels[poff] & 0x80ffffff) == edge)
						prevline = false;
				}
				else {
					if ((x != 0) && (x != (pix->width - 1))) {
						if ((pix->pixels[poff] & 0x80ffffff) != edge) {
							prevline = true;
							if ((pix->pixels[poff] & 0x40000000) == 0)
								bff_push(stack, x, y - 1, y);
						}
					}
				}
			}

                        // And the next line
			if (noff >= 0) {
				if (nextline) {
					if ((pix->pixels[noff] & 0x80ffffff) == edge)
						nextline = false;
				}
				else {
					if ((x != 0) && (x != (pix->width - 1))) {
						if ((pix->pixels[noff] & 0x80ffffff) != edge) {
							nextline = true;
							if ((pix->pixels[noff] & 0x40000000) == 0)
								bff_push(stack, x, y + 1, y);
						}
					}
				}
			}
		}
		vx++;
		vx &= 0x07;
		foff++;
		if (noff >= 0)
			noff++;
		if (poff >= 0)
			poff++;
	}

	if (orig_stack == NULL) {
		for (this = *stack; this; this = *stack) {
			*stack = (*stack)->next;
			broken_flood_fill(pix, this->x, this->y, edge, fillfg, fillbg, iszero, this->oy, stack);
			free(this);
		}
	}
}

#if 0

static void
flood_fill(struct ciolib_pixels *pix, int x1, int y1, uint32_t edge, uint32_t fillfg, uint32_t fillbg)
{
	if ((x1 < 0) || (y1 < 0))
		return;
	if (x1 >= pix->width)
		return;
	if (y1 >= pix->height)
		return;
	if (pix->pixels[y1 * pix->width + x1] == edge)
		return;
	if (pix->pixels[y1 * pix->width + x1] & 0x40000000)
		return;

	if (rip.fill_pattern[rip.viewport.sy + y1 & 0x07] & (0x80 >> (rip.viewport.sx + x1 & 0x07)))
		pix->pixels[y1 * pix->width + x1] = fillfg;
	else
		pix->pixels[y1 * pix->width + x1] = fillbg;
	pix->pixels[y1 * pix->width + x1] |= 0x40000000;

	if (x1 < (pix->width - 1))
		flood_fill(pix, x1 + 1, y1, edge, fillfg, fillbg);
	if (x1 > 0)
		flood_fill(pix, x1 - 1, y1, edge, fillfg, fillbg);
	if (y1 < (pix->height - 1))
		flood_fill(pix, x1, y1 + 1, edge, fillfg, fillbg);
	if (y1 > 0)
		flood_fill(pix, x1, y1 - 1, edge, fillfg, fillbg);
}

#endif /* if 0 */

struct point {
	int x;
	int y;
};

#define GET_XY() \
	x1 = parse_mega(&args[0], 2); \
	if (x1 == -1) \
	break; \
	y1 = parse_mega(&args[2], 2); \
	if (y1 == -1) \
	break

#define GET_XY2() \
	x1 = parse_mega(&args[0], 2); \
	if (x1 == -1) \
	break; \
	y1 = parse_mega(&args[2], 2); \
	if (y1 == -1) \
	break; \
	x2 = parse_mega(&args[4], 2); \
	if (x2 == -1) \
	break; \
	y2 = parse_mega(&args[6], 2); \
	if (y2 == -1) \
	break;

static void
rip_bezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int cnt, uint32_t fg)
{
	int  x, y;
	int  step;
	int  i, j;
	int *targets = malloc((cnt + 2) * 2 * sizeof(*targets));

	i = 0;
	targets[i++] = x1;
	targets[i++] = y1;
	for (step = 1; step < cnt; step++) {
		double tf = ((double)step) / cnt;
		double tr = ((double)(cnt - step)) / cnt;
		double tfs = pow(tf, 2);
		double tfstr = tfs * tr;
		double tfc = pow(tf, 3);
		double trs = pow(tr, 2);
		double tftrs = tf * trs;
		double trc = pow(tr, 3);

		x = trc * x1 + 3 * tftrs * x2 + 3 * tfstr * x3 + tfc * x4;
		y = trc * y1 + 3 * tftrs * y2 + 3 * tfstr * y3 + tfc * y4;
		targets[i++] = x;
		targets[i++] = y;
	}
	targets[i++] = x4;
	targets[i++] = y4;
	for (j = 2; j < i; j += 2)
		set_line(targets[j - 2],
		    targets[j - 1],
		    targets[j],
		    targets[j + 1],
		    fg,
		    rip.line_pattern,
		    rip.line_width);
	free(targets);
}

static void
rip_poly_bezier(const char *args, bool filled, bool closed)
{
	int      num = parse_mega(&args[0], 2);
	int      count = parse_mega(&args[2], 2);
	int      i;
	int      type;
	int      x1, y1, x2, y2, x3, y3, x4, y4;
	int      sx = parse_mega(&args[5], 2);
	int      sy = parse_mega(&args[7], 2);
	int      lx = sx;
	int      ly = sy;
	uint32_t fg = map_rip_color(rip.color);
	int      ch = 4;
	bool     last_was_bez = false;

	if (filled)
		fg |= 0x40000000;

	for (i = 0; i < num; i++) {
		type = parse_mega(&args[ch], 1);
		ch++;
		switch (type) {
			case -1: // Finished?
				printf("Stopping at %d of %d\n", i, num);
				break;
			case 0:  // Straight
				x1 = parse_mega(&args[ch], 2);
				y1 = parse_mega(&args[ch + 2], 2);
				ch += 4;
				if (!last_was_bez)
					set_line(lx, ly, x1, y1, fg, rip.line_pattern, rip.line_width);
				lx = x1;
				ly = y1;
				last_was_bez = false;
				break;
			case 1: // Bezier
			case 2: // Other bezier.
			case 5: // ??? yet another bezier...
			case 6: // ??? yet another bezier...
				x1 = parse_mega(&args[ch], 2);
				y1 = parse_mega(&args[ch + 2], 2);
				x2 = parse_mega(&args[ch + 4], 2);
				y2 = parse_mega(&args[ch + 6], 2);
				x3 = parse_mega(&args[ch + 8], 2);
				y3 = parse_mega(&args[ch + 10], 2);
				ch += 12;
				if (args[ch] == 0) {
					x4 = sx;
					y4 = sy;
				}
				else {
					x4 = parse_mega(&args[ch + 1], 2);
					y4 = parse_mega(&args[ch + 3], 2);
				}
				rip_bezier(x1, y1, x2, y2, x3, y3, x4, y4, count, fg);
				lx = x4;
				ly = y4;
				last_was_bez = true;
				break;
			default:
				printf("TODO: Unhandled poly_bez type %d\n", type);
				return;
		}
	}
	if (closed && ((lx != sx) || (ly != sy)))
		set_line(lx, ly, sx, sy, fg, rip.line_pattern, rip.line_width);
	if (filled)
		do_fill(false);
}

#define ADJUST_LIMIT(name, var) if (var < min ## name) min ## name = var; if (var > max ## name) max ## name = var;

static void
do_rip_command(int level, int sublevel, int cmd, const char *rawargs)
{
	int      x1, y1, x2, y2;
	int      arg1, arg2, arg3, arg4;
	char    *args;
	bool     handled = false;
	uint32_t fg;
	int      i, j;
	int      x, y;
	char     cache_path[MAX_PATH + 1];
	FILE    *icn;
	int      ex, ey;

	args = parse_string(rawargs);

// SLEEP(100);
// printf("Level: %d, Sublevel: %d, Cmd: '%c', args: '%s'\n", level, sublevel, cmd, args);
	switch (level) {
		case 0:
			switch (sublevel) {
				case 0:
					switch (cmd) {
						case '#': // RIP_NO_MORE !|#
                                                          /*
                                                           * This command indicates that RIPscrip commands are complete.
                                                           *  This
                                                           * allows the terminal program to activate Mouse Regions, or
                                                           * respond to
                                                           * queued up Mouse Clicks without disturbing the natural flow
                                                           * of
                                                           * the
                                                           * script transmission.
                                                           */

                                                        /*
                                                         * TODO: It is strongly implied that the terminal
                                                         * should do nothing from when the first RIP line
                                                         * is received until this one occurs.
                                                         *
                                                         * I don't see why that is though.
                                                         */
							handled = true;
							break;
						case '$': // Undocument RIP_QUERY thing...
						{
							handled = true;

							char *p = strchr(args, '$');

							if (p) {
								*p = 0;
								free(get_text_variable(args));
							}
							break;
						}
						case '*': // RIP_RESET_WINDOWS !|*
                                                        /* This command will set the Text Window to a full 80x43 EGA
                                                         * hi-res text
                                                         * mode, place the cursor in the upper left corner, clear the
                                                         * screen,
                                                         * and zoom the Graphics Window to full 640x350 EGA screen.
                                                         *  Both
                                                         * windows are filled with the current graphics background
                                                         * color.  Also,
                                                         * all Mouse Regions and Mouse Buttons are deleted and the
                                                         * Clipboard is
                                                         * erased.  A system One might use this function before entering
                                                         * a text
                                                         * only mode that does not support RIP commands.  This command
                                                         * will also
                                                         * restore the default 16-color RIP palette (see RIP_SET_PALETTE
                                                         * below).
                                                         */
							handled = true;
							rv_reset("RESET", NULL);
							break;
						case '=': // RIP_LINE_STYLE !|= <style> <user_pat> <thick>
                                                        /*
                                                         * This command establishes the current line pattern and
                                                         * thickness for
                                                         * many subsequent graphics primitive commands.  There are four
                                                         * built-in
                                                         * line styles plus provisions for custom line patterns.
                                                         *
                                                         *      Style   Description           Binary            Hex
                                                         *      ----------------------------------------------------
                                                         *      00      Normal, Solid Line    1111111111111111  FFFF
                                                         *      01      Dotted Line           0011001100110011  3333
                                                         *      02      Centered Line         0001111000111111  1E3F
                                                         *      03      Dashed Line           0001111100011111  1F1F
                                                         *      04      Custom Defined line (see about <user_pat> below)
                                                         *
                                                         *      Thick   Description
                                                         *      -------------------------------
                                                         *      01      Lines are 1 pixel wide
                                                         *      03      Lines are 3 pixels wide
                                                         *
                                                         * If the <style> is set to a value of 4 (custom pattern), then
                                                         * the
                                                         * <user_pat> parameter is used as a 16-bit representation of
                                                         * the pixels
                                                         * in the line pattern.  For example:
                                                         *
                                                         * Repeating Pattern     Binary Coding     Hex     Decimal
                                                         *   MegaNum
                                                         * -------------------------------------------------------------------
                                                         *  - - - - - - - -    1010101010101010    AAAA     43690
                                                         *     0XPM
                                                         *  ----    ----       1111000011110000    F0F0     61680
                                                         *     1BLC
                                                         *
                                                         * So, the most-significant-bit of <user_pat> is toward the
                                                         * starting
                                                         * point of the line or border that uses this fill pattern.  If
                                                         * the
                                                         * <style> parameter is not 4, then the <user_pat> parameter is
                                                         * ignored.
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							if ((arg1 < 0) || (arg1 > 4))
								break;
							arg2 = parse_mega(&args[2], 4);
							if ((arg2 < 0) || (arg2 > 65535))
								break;
							arg3 = parse_mega(&args[6], 2);
							if ((arg3 != 1) && (arg3 != 3))
								break;
							if (arg1 < 4)
								rip.line_pattern = rip_line_patterns[arg1];
							else
								rip.line_pattern = arg2;
							rip.line_width = arg3;
							break;
						case '>': // RIP_ERASE_EOL !|>
                                                        /* This command will erase the current text line in the TTY text
                                                         * window
                                                         * from the current cursor location (inclusive) to the end of
                                                         * the line.
                                                         * The erased region is filled with the current graphics
                                                         * background
                                                         * color.  This differs from the ANSI command ESC[K which clears
                                                         * the
                                                         * area with the current ANSI background color.
                                                         */
							handled = true;

							uint32_t oldbg = cterm->bg_color;

							cterm->bg_color = map_rip_color(0);
							cterm_clreol(cterm);
							cterm->bg_color = oldbg;
							break;
						case '@': // RIP_TEXT_XY !|@ <x> <y> <text-string>
                                                        /* This command is an efficient combination of RIP_MOVE and
                                                         * RIP_TEXT.
                                                         * The text is drawn at the specified location according to the
                                                         * same
                                                         * settings as apply to RIP_TEXT (see above).
                                                         *
                                                         * The current drawing position is set immediately to the right
                                                         * of the
                                                         * drawn text.  Subsequent Line, Circle or other such commands
                                                         * will not
                                                         * affect this position.  This provides a means so that you can
                                                         * quickly
                                                         * do another RIP_TEXT command (presumably in another color) at
                                                         * a later
                                                         * time and have the text show up immediately after the previous
                                                         * text.
                                                         */
							handled = true;
							GET_XY();
							rip.x = x1;
							rip.y = y1;
							write_text(&args[4]);
							break;
						case 'A': // RIP_ARC !|A <x> <y> <start_ang> <end_ang> <radius>
                                                        /* This command draws a circular arc, or a segment of a circle.
                                                         *  Drawing
                                                         * begins at <start_ang> and terminates at <end_ang>.  The
                                                         * angles are
                                                         * represented starting at zero for the 3 o'clock position and
                                                         * increasing counterclockwise through a full circle to 360:
                                                         *
                                                         *                           90
                                                         *                            |
                                                         *                      180---|--- 0
                                                         *                            |
                                                         *                           270
                                                         *
                                                         * The arc drawing begins at the <start_angle> and continues
                                                         * counter-
                                                         * clockwise to the <end_angle>.  A full circle will be
                                                         * displayed if
                                                         * <start_ang>=0 and <end_ang>=360.  This command recognizes
                                                         * aspect
                                                         * ratios like the circle command does.  It does not take
                                                         * advantage of
                                                         * line patterns but does comply with line thickness.
                                                         *
                                                         * If both angles are equal, nothing is drawn.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							GET_XY2();
							arg1 = parse_mega(&args[8], 2);
							assert_rwlock_rdlock(&vstatlock);
							if ((vstat.scrnwidth == 640) && (vstat.scrnheight == 350)) {
                                                                // Detect EGA mode and use the same value as RIPterm
                                                                // did.
								arg3 = (arg1 * 7750 / 10000);
							}
							else {
								arg3 = arg1
								    * ((double)vstat.scrnwidth / vstat.scrnheight)
								    / ((double)vstat.aspect_width
								    / vstat.aspect_height);
							}
							assert_rwlock_unlock(&vstatlock);
							full_ellipse(x1, y1, x2, y2, arg1, arg3, false,
							    map_rip_color(rip.color));
							break;
						case 'B': // RIP_BAR !|B <x0> <y0> <x1> <y1>
                                                        /*
                                                         * This command fills a rectangular region with the current fill
                                                         * color
                                                         * and pattern.  No border is drawn.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							GET_XY2();

                                                        // Yes, it really works this way... TODO: Check if others do
                                                        // too.
							if (x1 > x2) {
								arg1 = x2;
								x2 = x1;
								x1 = arg1;
							}
							if (y1 > y2) {
								arg1 = y2;
								y2 = y1;
								y1 = arg1;
							}
							for (arg1 = y1; arg1 <= y2; arg1++) {
								for (arg2 = x1; arg2 <= x2; arg2++)
									fill_pixel(arg2, arg1);
							}
							break;
						case 'C': // RIP_CIRCLE !|C <x_center> <y_center> <radius>
                                                        /* This command draws a circle in the current drawing color and
                                                         * line
                                                         * thickness.  The <radius> is in pixel units.  This command
                                                         * understands
                                                         * aspect ratios and will draw a truly circular circle instead
                                                         * of an
                                                         * oblong circle (ellipse) like on other graphics systems.  The
                                                         * aspect
                                                         * ratio is currently based on the EGA 640x350 resolution and is
                                                         * understood by both the GUI designer and the Terminal Program.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							GET_XY();
							arg1 = parse_mega(&args[4], 2);
							assert_rwlock_rdlock(&vstatlock);
							if ((vstat.scrnwidth == 640) && (vstat.scrnheight == 350)) {
                                                                // Detect EGA mode and use the same value as RIPterm
                                                                // did.
								arg3 = (arg1 * 7750 / 10000);
							}
							else {
								arg3 = arg1
								    * ((double)vstat.scrnwidth / vstat.scrnheight)
								    / ((double)vstat.aspect_width
								    / vstat.aspect_height);
							}
							assert_rwlock_unlock(&vstatlock);
							if (arg1 == 1)
								arg3 = 1;
							full_ellipse(x1, y1, 0, 360, arg1, arg3, false,
							    map_rip_color(rip.color));
							break;
						case 'E': // RIP_ERASE_VIEW !|E
                                                        /* This command clears the Graphics Viewport to the current
                                                         * graphics
                                                         * background color.  If the graphics viewport is not active (if
                                                         * the
                                                         * boundaries are 0,0,0,0), then this command is ignored.  If
                                                         * the text
                                                         * and graphics windows overlap, then this command will clear
                                                         * the
                                                         * overlapping portion also.
                                                         */
							handled = true;
							rv_erase("EGW", NULL);
							break;
						case 'F': // RIP_FILL !|F <x> <y> <border>
                                                        /* This command performs a "flood fill" emanating from the given
                                                         * <x,y>
                                                         * point.  The fill "oozes" in all directions up to <border>
                                                         * color, but
                                                         * the border itself is not changed.  Whatever is inside the
                                                         * border
                                                         * that's not the border color gets changed to the current fill
                                                         * color
                                                         * and fill pattern.  If the border color does not completely
                                                         * enclose
                                                         * the <x,y> point, the fill will continue to the edges of the
                                                         * viewport.
                                                         *
                                                         * If the point on the screen that is chosen as the "fill point"
                                                         * is the
                                                         * same color as the fill border color, then no Fill Operation
                                                         * will be
                                                         * performed!  This restriction is necessary because of some
                                                         * limitations
                                                         * of Flood Fill abilities in different hardware/software
                                                         * environments
                                                         * like Microsoft Windows, etc).
                                                         */
							handled = true;
							GET_XY();
							if ((x1 > (rip.viewport.ex - rip.viewport.sx))
							    || (y1 > (rip.viewport.ey - rip.viewport.sy)))
								break;
							arg1 = parse_mega(&args[4], 2);
							if ((arg1 < 0) || (arg1 > 255))
								break;
							arg2 = rip.viewport.ey;
							assert_rwlock_rdlock(&vstatlock);
							if (rip.viewport.ey >= vstat.scrnheight)
								arg2 = vstat.scrnheight - 1;
							assert_rwlock_unlock(&vstatlock);

							struct ciolib_pixels *pix = getpixels(rip.viewport.sx,
							        rip.viewport.sy,
							        rip.viewport.ex,
							        arg2,
							        false);

#if 0 // This slow draw is useful for debugging flood fill
                                                        // issues...
							printf("Flooding %d/%d!\n", x1, y1);
							uint32_t xx;
							attr2palette(15, &fg, &xx);

							for (i = 0; i < 50; i++) {
								SLEEP(50);
								scale_setpixel(x1, y1, fg);
								SLEEP(50);
								scale_setpixel(x1, y1, xx);
							}
#endif
							FREE_AND_NULL(pix->pixelsb);

                                                        // Blammo goes the stack!
							fg = map_rip_color(arg1);
							uint32_t ffg, fbg;
							ffg = map_rip_color(rip.fill_color);
							fbg = map_rip_color(0);
							for (i = 0; i < pix->width * pix->height; i++)
								pix->pixels[i] &= 0x80ffffff;
							if ((x1 < pix->width) && (y1 < pix->height)) {
								broken_flood_fill(pix,
								    x1,
								    y1,
								    fg,
								    ffg,
								    fbg,
								    rip.fill_color == 0,
								    y1,
								    NULL);
							}
							else {
								puts("TODO: Flood fill off screen");
							}
							for (i = 0; i < pix->width * pix->height; i++)
								pix->pixels[i] &= 0x80ffffff;
							setpixels(rip.viewport.sx,
							    rip.viewport.sy,
							    rip.viewport.ex,
							    arg2,
							    0,
							    0, 0, 0,
							    pix,
							    NULL);
							freepixels(pix);
							break;
						case 'H': // RIP_HOME !|H
                                                        /* This command positions the text cursor to the upper-left
                                                         * corner in
                                                         * the TTY Text Window, if it is active.
                                                         */
							handled = true;
							cterm_gotoxy(cterm, 1, 1);
							break;
						case 'I': // RIP_PIE_SLICE !|I <x> <y> <start_ang> <end_ang> <radius>
                                                        /* This command draws a "pie slice".  The slice is circular.  It
                                                         * obeys
                                                         * all of the same commands as the Arc command described above.
                                                         *  The
                                                         * ends of the arc are connected to the Center-Point of the Arc
                                                         * with two
                                                         * straight lines.  These two lines converge at the
                                                         * Center-Point.  The
                                                         * interior of the Slice is filled with the current Fill Color
                                                         * and
                                                         * Pattern.  The exterior (outline) of the Slice is drawn using
                                                         * the
                                                         * current drawing color and line thickness.  The Line Pattern
                                                         * feature
                                                         * does not apply to this command.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							GET_XY2();
							arg1 = parse_mega(&args[8], 2);
							assert_rwlock_rdlock(&vstatlock);
							if ((vstat.scrnwidth == 640) && (vstat.scrnheight == 350)) {
                                                                // Detect EGA mode and use the same value as RIPterm
                                                                // did.
								arg3 = (arg1 * 7750 / 10000);
							}
							else {
								arg3 = arg1
								    * ((double)vstat.scrnwidth / vstat.scrnheight)
								    / ((double)vstat.aspect_width
								    / vstat.aspect_height);
							}
							assert_rwlock_unlock(&vstatlock);
							fg = map_rip_color(rip.color) | 0x40000000;
							full_ellipse(x1, y1, x2, y2, arg1, arg3, false, fg);

                                                        // This circle may not actually be circular... can't just use
                                                        // sin/cos
							ex =
							    roundl((x2 * y2)
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg1 * (M_PI / 180.0))), 2))));
							if ((arg1 > 90) && (arg1 < 270))
								ex = 0 - ex;
							ex += x1;
							ey =
							    roundl((x2 * y2 * tan(arg1 * (M_PI / 180.0)))
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg1 * (M_PI / 180.0))), 2))));
							if ((arg1 > 90) && (arg1 < 270))
								ey = 0 - ey;
							ey = y1 - ey;

							set_line(x1, y1, ex, ey, fg, 0xffff, rip.line_width);
							ex =
							    round((x2 * y2)
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg3 * (M_PI / 180.0))), 2))));
							if ((arg3 > 90) && (arg3 < 270))
								ex = 0 - ex;
							ex += x1;
							ey =
							    roundl((x2 * y2 * tan(arg3 * (M_PI / 180.0)))
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg3 * (M_PI / 180.0))), 2))));
							if ((arg3 > 90) && (arg3 < 270))
								ey = 0 - ey;
							ey = y1 - ey;
							set_line(x1,
							    y1,
							    x1 + nearbyint(cos(M_PI / 180.0) * arg3) * x2,
							    y1 + nearbyint(sin(M_PI / 180.0) * arg3) * y2,
							    fg,
							    0xffff,
							    rip.line_width);

                                                        // TODO: Lazy lazy fill...
							do_fill(false);
							break;
						case 'L': // RIP_LINE !|L <x0> <y0> <x1> <y1>
                                                        /* This command will draw a line in the current drawing color,
                                                         * using the
                                                         * current line style, pattern and thickness.  The line is drawn
                                                         * from
                                                         * (x0,y0) to (x1,y1) in the graphics viewport.
                                                         */
							handled = true;
							GET_XY2();
							draw_line(x1, y1, x2, y2, true);
							break;
						case 'K': // RIP_FILLED_RECTANGLE (v2.A2)
							handled = true;
							if (no_viewport())
								break;
							GET_XY2();

                                                        // Yes, it really works this way... TODO: Check if others do
                                                        // too.
							if (x1 > x2) {
								arg1 = x2;
								x2 = x1;
								x1 = arg1;
							}
							if (y1 > y2) {
								arg1 = y2;
								y2 = y1;
								y1 = arg1;
							}
							for (arg1 = y1; arg1 <= y2; arg1++) {
								for (arg2 = x1; arg2 <= x2; arg2++)
									fill_pixel(arg2, arg1);
							}
							if (rip.borders) {
								draw_line(x1, y1, x2, y1, false);
								draw_line(x2, y1, x2, y2, false);
								draw_line(x2, y2, x1, y2, false);
								draw_line(x1, y2, x1, y1, true);
							}
							break;
						case 'N': // RIP_SET_BORDER (v2.A3)
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							if (arg1 == -1)
								break;
							rip.borders = arg1;
							break;
						case 'V': // RIP_OVAL_ARC !|V <x> <y> <st_ang> <e_ang> <radx> <rady>
                                                // (TODO: Are these seriously exactly the same?)
						case 'O': // RIP_OVAL !|O <x> <y> <st_ang> <end_ang> <x_rad> <y_rad>
                                                        /* This command draws an elliptical arc similar to the circular
                                                         * RIP_ARC
                                                         * command.  The center of the ellipse is (x,y) and the arc is
                                                         * drawn
                                                         * starting from <st_ang> and proceeding counterclockwise to
                                                         * <end_ang>
                                                         * (see RIP_ARC above for details).
                                                         *
                                                         * The X radius is half the full width of the ellipse, the Y
                                                         * radius is
                                                         * half the full height.  The ellipse is drawn according to the
                                                         * current
                                                         * line thickness, but the current line pattern has no effect.
                                                         */
							handled = true;
							GET_XY();
							arg1 = parse_mega(&args[4], 2);
							arg2 = parse_mega(&args[6], 2);
							x2 = parse_mega(&args[8], 2);
							y2 = parse_mega(&args[10], 2);
							if ((x2 < 0) || (y2 < 0))
								break;
							full_ellipse(x1, y1, arg1, arg2, x2, y2, false,
							    map_rip_color(rip.color));
							break;
						case 'P': // RIP_POLYGON !|P <npoints> <x1> <y1> ... <xn> <yn>
                                                        /* This command will draw a multi-sided closed polygon.  The
                                                         * polygon is
                                                         * drawn using the current drawing color, line pattern and
                                                         * thickness.
                                                         * The <npoints> parameter is between 2 and 512 and indicates
                                                         * how many
                                                         * (x,y) coordinate pairs will follow, which is also the number
                                                         * of sides
                                                         * of the polygon.  The polygon interior is not filled by
                                                         * RIP_POLYGON.
                                                         *
                                                         * The polygon is enclosed by the last vertex between xn,yn and
                                                         * x1,y1.
                                                         * In other words, you do not have to connect the end to the
                                                         * beginning -
                                                         * it is automatically done for you.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							fg = map_rip_color(rip.color);
							arg1 = parse_mega(&args[0], 2);
							// TODO: Does this draw a point if there's a single point?
							if (arg1 < 1)
								break;
							for (i = 0; i < arg1; i++) {
								if (i == 0) {
									x1 = parse_mega(&args[2], 2);
									if (x1 == -1)
										break;
									y1 = parse_mega(&args[4], 2);
									if (y1 == -1)
										break;
								}
								else {
									x2 = parse_mega(&args[2 + i * 4], 2);
									if (x2 == -1)
										break;
									y2 = parse_mega(&args[4 + i * 4], 2);
									if (y2 == -1)
										break;
									draw_line(x1, y1, x2, y2, false);
									x1 = x2;
									y1 = y2;
								}
							}
							if (i > 0) {
								x2 = parse_mega(&args[2], 2);
								if (x2 == -1)
									break;
								y2 = parse_mega(&args[4], 2);
								if (y2 == -1)
									break;
								draw_line(x1, y1, x2, y2, true);
							}
							break;
						case 'Q': // RIP_SET_PALETTE !|Q <c1> <c2> ... <c16>
                                                        /* This command modifies the 16-color RIP palette by choosing
                                                         * from the
                                                         * 64 colors in the master palette.  This allows you to alter
                                                         * the colors
                                                         * in your RIPscrip graphics scenes.  Once a Set Palette command
                                                         * is
                                                         * processed, any colors on the screen that had their
                                                         * corresponding
                                                         * palette entries changed will instantly switch to the new
                                                         * color set.
                                                         * You may obtain color cycling effects by using this command.
                                                         *  The
                                                         * default 16-color RIP palette is restored by the
                                                         * RIP_RESET_WINDOWS
                                                         * command.
                                                         */
							handled = true;
							for (i = 0; i < 16; i++) {
								arg1 = parse_mega(&args[i * 2], 2);
								if ((arg1 < 0) || (arg1 > 63))
									break;
								curr_ega_palette[i] = arg1;
							}
							set_ega_palette();
							break;
						case 'R': // RIP_RECTANGLE !|R <x0> <y0> <x1> <y1>
                                                        /* This command draws a rectangle in the current drawing color,
                                                         * using
                                                         * the current line style, pattern and thickness.  (x0,y0) and
                                                         * (x1,y1)
                                                         * are any two opposing corners of the rectangle.  If x0=x1 or
                                                         * y0=y1
                                                         * then the command will draw a single vertical or horizontal
                                                         * line.  The
                                                         * rectangle interior is not filled by RIP_RECTANGLE.
                                                         */
							handled = true;
							GET_XY2();
							draw_line(x1, y1, x2, y1, false);
							draw_line(x2, y1, x2, y2, false);
							draw_line(x2, y2, x1, y2, false);
							draw_line(x1, y2, x1, y1, true);
							break;
						case 'S': // RIP_FILL_STYLE !|S <pattern> <color>
                                                        /*
                                                         * This command defines the current fill pattern and fill color
                                                         * for use
                                                         * in subsequent graphics fill operations.  There are twelve
                                                         * (12)
                                                         * predefined fill patterns.  They are:
                                                         *
                                                         *     Pattern  Description                 Example       Misc
                                                         *
                                                         *
                                                         * -----------------------------------------------------------------
                                                         *       00     Fill with background color                (color
                                                         * #0)
                                                         *       01     Solid Fill                                (fill
                                                         * color)
                                                         *       02     Line Fill                   -----------   (thick
                                                         * lines)
                                                         *       03     Light Slash Fill            /  /  /  /    (thin
                                                         * lines)
                                                         *       04     Normal Slash Fill           // // // //   (thick
                                                         * lines)
                                                         *       05     Normal Backslash Fill       \\ \\ \\ \\   (thick
                                                         * lines)
                                                         *       06     Light Backslash Fill        \  \  \  \    (thin
                                                         * lines)
                                                         *       07     Light Hatch Fill            ###########   (thin
                                                         * lines)
                                                         *       08     Heavy Cross Hatch Fill      XXXXXXXXXXX   (thin
                                                         * lines)
                                                         *       09     Interleaving Line Fill      +-+-+-+-+-+   (thin
                                                         * lines)
                                                         *       0A     Widely spaced dot fill      . : . : . :
                                                         *   (pixels only)
                                                         *       0B     Closely spaced dot fill     :::::::::::
                                                         *   (pixels only)
                                                         *
                                                         * The <color> parameter is the fill color for subsequent fill
                                                         * commands.
                                                         * The "active" pixels of the pattern become this color.  The
                                                         * "inactive"
                                                         * pixels become the current background color (color 00,
                                                         * typically
                                                         * black).  Fill pattern 00 will set the entire fill area to the
                                                         * background color.  (In this special case, the fill color
                                                         * doesn't
                                                         * matter.)
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							if ((arg1 < 0) || (arg1 > 0x0b))
								break;
							arg2 = parse_mega(&args[2], 2);
							if (arg2 == -1)
								break;
							if (arg2 > 255)
								break;
							rip.fill_color = arg2;
							memcpy(rip.fill_pattern, rip_fill_patterns[arg1], 8);
							break;
						case 'T': // RIP_TEXT !|T <text-string>
                                                        /* This command displays text at the current location in the
                                                         * graphics
                                                         * window, as set with the RIP_MOVE command.  The text is also
                                                         * affected
                                                         * by the most recent settings of these commands:
                                                         *
                                                         *      Command            Description of Command
                                                         *
                                                         *
                                                         * 
                                                         * ----------------------------------------------------------------
                                                         *      RIP_FONT_STYLE     font style (character set, direction,
                                                         * size)
                                                         *      RIP_WRITE_MODE     drawing mode (normal or XOR)
                                                         *      RIP_COLOR          drawing color (from the 16-color RIP
                                                         * palette)
                                                         *
                                                         * The drawing position is placed at the end of the last
                                                         * character
                                                         * drawn.
                                                         *
                                                         * The current drawing position is set immediately to the right
                                                         * of the
                                                         * drawn text.  Subsequent Line, Circle or other such commands
                                                         * will not
                                                         * affect this position.  This provides a means so that you can
                                                         * quickly
                                                         * do another RIP_TEXT command (presumably in another color) at
                                                         * a later
                                                         * time and have the text show up immediately after the previous
                                                         * text.
                                                         */
							handled = true;
							write_text(&args[0]);
							break;
						case 'W': // RIP_WRITE_MODE !|W <mode>
                                                        /* This command sets the current drawing mode for most of the
                                                         * graphics
                                                         * primitives:
                                                         *
                                                         *      Mode   Description
                                                         *      ------------------------------------------
                                                         *      00     Normal drawing mode (overwrite)
                                                         *      01     XOR (complimentary) mode
                                                         *
                                                         * NOTE: This is documented as using two digits for write mode,
                                                         *       but it only uses one (using two does *not work* in
                                                         * RIPterm)
                                                         */
							handled = true;
							if (rip.version == RIP_VERSION_3)
								arg1 = parse_mega(&args[0], 2);
							else
								arg1 = parse_mega(&args[0], 1);
							if (arg1 == 0)
								rip.xor = false;
							else if (arg1 == 1)
								rip.xor = true;
							break;
						case 'X': // RIP_PIXEL !|X <x> <y>
                                                        /* This command will draw a single pixel in the current drawing
                                                         * color at
                                                         * the given (x,y) graphics position.  This command is included
                                                         * for
                                                         * completeness, but in practice it would be extremely
                                                         * inefficient to
                                                         * make much use of it.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							GET_XY();
							set_pixel(x1, y1, map_rip_color(rip.color));
							break;
						case 'Y': // RIP_FONT_STYLE !|Y <font> <direction> <size> <res>
                                                        /*
                                                         * This command sets the font, direction and size for RIP_TEXT
                                                         * commands.
                                                         *
                                                         *      Font   Description of Font
                                                         *      ---------------------------------------------
                                                         *      00     Default 8x8 font            Bit-Mapped
                                                         *      01     Triplex Font                Scalable
                                                         *      02     Small Font                  Scalable
                                                         *      03     Sans Serif Font             Scalable
                                                         *      04     Gothic [Old English] Font   Scalable
                                                         *      05     Script Font                 Scalable
                                                         *      06     Simplex Font                Scalable
                                                         *      07     Triplex Script Font         Scalable
                                                         *      08     Complex Font                Scalable
                                                         *      09     European Font               Scalable
                                                         *      0A     Bold Font                   Scalable
                                                         *
                                                         * For the Direction parameter, use 00 to indicate horizontal
                                                         * and 01 for
                                                         * vertical.
                                                         *
                                                         * For the Size parameter, use 01 for the normal default size,
                                                         * 02 for x2
                                                         * magnification, 03 for x3 magnification, ... , and 0A for x10
                                                         * magnification.
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							if (arg1 == -1)
								break;
							arg2 = parse_mega(&args[2], 2);
							if (arg2 == -1)
								break;
							arg3 = parse_mega(&args[4], 2);
							if (arg3 == -1)
								break;
							arg4 = parse_mega(&args[6], 2);
							if (arg4 == -1)
								break;
							if ((arg1 >= 0) && (arg1 <= 10))
								rip.font.num = arg1;
							if (arg2 >= 0)
								rip.font.vertical = arg2;
							if ((arg3 > 0) && (arg3 <= 10))
								rip.font.size = arg3;

                                                        // arg4 is reserved... ignore.
							break;
						case 'Z': // RIP_BEZIER !|Z <x1> <y1> <x2> <y2> <x3> <y3> <x4> <y4>
                                                          // <cnt>

                                                        /* This command provides customizable curves.  Four control
                                                         * points are
                                                         * used to create the shape of the curve.  The curves beginning
                                                         * point is
                                                         * at point (x1,y1) and it ends at (x4,y4).  Points (x2,y2) and
                                                         * (x3,y3)
                                                         * are not necessarily on the curve, but are used to pull the
                                                         * curve in
                                                         * their direction.  The diagram below indicates how points 2
                                                         * and 3 can
                                                         * be utilized to form the desired curve.  Note that points 2
                                                         * and 3 are
                                                         * not actually on the curve, but points 1 and 4 are.
                                                         *
                                                         *                           X2
                                                         *
                                                         *                          *****
                                                         *                        **     ****
                                                         *                       *           **            X4
                                                         *                      *              **          *
                                                         *                    X1                 *       **
                                                         *                                        *    **
                                                         *                                         ****
                                                         *
                                                         *                                          X3
                                                         *
                                                         * NOTE: Points 2 and 3 are not actually on the curve - points 1
                                                         * and 4
                                                         *       are.
                                                         *
                                                         * The last parameter of this command is the <cnt> parameter.
                                                         *  This
                                                         * determines how many "segments" the curve should be drawn in.
                                                         *  Each
                                                         * segment is in fact, a straight line.  The more segments you
                                                         * allow,
                                                         * the smoother the curve may be.  If a curve does not have a
                                                         * significant amount of "curviness" then a low "count" can
                                                         * improve
                                                         * performance of the curve drawing.  Bezier Curves use
                                                         * "floating point"
                                                         * math internally for its processing.  All parameters specified
                                                         * for
                                                         * this command are simple integers however.
                                                         *
                                                         * Each segment of the Bezier Curve will be drawn using the
                                                         * current
                                                         * line style pattern and thickness.  You can achieve some
                                                         * unusual
                                                         * effects using patterned lines for Bezier Curves.  If XOR is
                                                         * active
                                                         * when you draw a bezier curve, you will find gaps at the
                                                         * inter-
                                                         * sections of each segment.
                                                         *
                                                         * NOTE: This command is implemented in C using double floating
                                                         * point
                                                         * numbers.  To make sure you do not have round-off or precision
                                                         * errors in another language, you should also use an equivalent
                                                         * floating point type.  In Borland's Turbo Pascal, do not use
                                                         * REAL's, but use DOUBLE's instead!
                                                         */
							handled = true;
							int xp[4], yp[4];
							for (i = 0; i < 4; i++) {
								xp[i] = parse_mega(&args[0 + i * 4], 2);
								yp[i] = parse_mega(&args[2 + i * 4], 2);
							}
							arg1 = parse_mega(&args[16], 2);
							rip_bezier(xp[0],
							    yp[0],
							    xp[1],
							    yp[1],
							    xp[2],
							    yp[2],
							    xp[3],
							    yp[3],
							    arg1,
							    map_rip_color(rip.color));
							break;
						case 'a': // RIP_ONE_PALETTE !|a <color> <value>
                                                        /* This command changes one color in the 16-color palette.  The
                                                         * color
                                                         * number is sent along with the new color value from the Master
                                                         * Color
                                                         * Palette. The color <value> must be in the range of 0-63.
                                                         *  Once a Set
                                                         * One Palette command is processed, any colors on the screen
                                                         * that
                                                         * correspond to the <color> number will be changed instantly to
                                                         * the new
                                                         * color value.  You may obtain color cycling effects by using
                                                         * this
                                                         * command.  The default RIP palette is restored when by
                                                         * RIP_RESET_WINDOWS.
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							arg2 = parse_mega(&args[2], 2);
							if ((arg1 < 0) || (arg1 > 15))
								break;
							if ((arg2 < 0) || (arg2 > 63))
								break;
							curr_ega_palette[arg1] = arg2;
							attr2palette(arg1, &fg, NULL);
							setpalette(fg,
							    ega_palette[arg2][0],
							    ega_palette[arg2][1],
							    ega_palette[arg2][2]);

                                                        // TODO: Extended palette.
							if (arg1 < 16)
								ega_colours[arg1] = fg;
							break;
						case 'b': // RIP_EXTENDED_TEXT_WINDOW (v2.A4)
							handled = true;
							GET_XY2();
							arg1 = parse_mega(&args[8], 2);
							arg2 = parse_mega(&args[10], 2);
							arg3 = parse_mega(&args[12], 1);
							arg4 = parse_mega(&args[13], 4);
							x1 = map_rip_x(x1 + rip.viewport.sx);
							x2 = map_rip_x(x2 + rip.viewport.sy);
							y1 = map_rip_y(y1 + rip.viewport.sx);
							y2 = map_rip_y(y2 + rip.viewport.sy);

                                                        // Step 1, choose the biggest font that fits...
                                                        // we have 8x16, 8x14, 8x8, 7x14, and 7x8 to pick from...
							int maxwidth = 16;
							if (!(arg4 & 0x10) && (arg3 != 4))
								maxwidth = 8;
							else if (x2 - x1 + 1 < maxwidth * arg1)
								maxwidth = 8;
							if (x2 - x1 + 1 < maxwidth * arg1)
								maxwidth = 7;

							int maxheight = 16;
							if (maxwidth == 16)
								maxheight = 14;
							else if (y2 - y1 + 1 < maxheight * arg2)
								maxheight = 14;
							if (y2 - y1 + 1 < maxheight * arg2)
								maxheight = 8;

                                                        // Step 2, shrink text size if needed
							if (x2 - x1 + 1 < maxwidth * arg1)
								arg1 = (x2 - x1 + 1) / maxwidth;
							if (y2 - y1 + 1 < maxheight * arg2)
								arg2 = (y2 - y1 + 1) / maxheight;

                                                        // Now, check the desired font.
							if (!(arg4 & 0x10)) {
								switch (arg3) {
									case 0:
										if (maxheight > 8)
											maxheight = 8;
										break;
									case 1:
										if (maxheight > 8)
											maxheight = 8;
										if (maxwidth > 7)
											maxwidth = 7;
										break;
									case 3:
										if (maxwidth > 7)
											maxwidth = 7;
										break;
								}
							}

                                                        // Step 3, center as best we can
							int xoffset = (((x2 - x1 + 1) - (maxwidth * arg1)) / 2)
							    / maxwidth;
							int yoffset = (((y2 - y1 + 1) - (maxheight * arg2)) / 2)
							    / maxheight;

                                                        // Step 4, set the text window
							void *fnt;
							if ((maxwidth == 16) && (maxheight == 14)) {
								fnt = ripfnt16x14;
							}
							else if ((maxwidth == 8) && (maxheight == 16)) {
								fnt = conio_fontdata[0].eight_by_sixteen;
							}
							else if ((maxwidth == 8) && (maxheight == 14)) {
								fnt = conio_fontdata[0].eight_by_fourteen;
							}
							else if ((maxwidth == 8) && (maxheight == 8)) {
								fnt = conio_fontdata[0].eight_by_eight;
							}
							else if ((maxwidth == 7) && (maxheight == 14)) {
								fnt = ripfnt7x14;
							}
							else if ((maxwidth == 7) && (maxheight == 8)) {
								fnt = ripfnt7x8;
							}
							else {
								printf("Unsupported font size %dx%d\n",
								    maxwidth,
								    maxheight);
								fnt = ripfnt7x8;
								maxwidth = 7;
								maxheight = 8;
							}
							reinit_screen(fnt, maxwidth, maxheight);

							cterm->left_margin = (x1 / maxwidth) + xoffset;
							cterm->top_margin = (y1 / maxheight) + yoffset;
							cterm->right_margin = cterm->left_margin + arg1 - 1;
							cterm->bottom_margin = cterm->top_margin + arg2 - 1;
							setwindow(cterm);
							gotoxy(1, 1);
							cterm->extattr |= CTERM_EXTATTR_ORIGINMODE;

                                                        // Step 5, apply flags
							if (arg4 & 0x01)
								cterm->extattr |= CTERM_EXTATTR_AUTOWRAP;
							else
								cterm->extattr &= ~CTERM_EXTATTR_AUTOWRAP;
							if (arg4 & 0x02)
								_setcursortype(rip.curstype);
							if (arg4 & 0x20) { // Clear area...
								for (i = x1; i <= x2; i++)
									for (j = y1; j <= y2; j++)
										rip_setpixel(i, j, 0);

							}
							break;
						case 'c': // RIP_COLOR !|c <color>
                                                        /* This command sets the color for drawing lines, circles, arcs,
                                                         * rectangles, and other graphics primitives, as well as the
                                                         * color for
                                                         * drawing graphics-text from the RIP_TEXT class of commands
                                                         * (not from
                                                         * ASCII/ANSI text).  This command does not affect Fill colors
                                                         * or Fill
                                                         * Patterns (see below).  It does affect the borders of graphic
                                                         * objects,
                                                         * for example the border of an ellipse drawn with the
                                                         * RIP_FILLED_OVAL
                                                         * command.  (The interior of the ellipse would be drawn
                                                         * according to
                                                         * the most recent RIP_FILL_STYLE command.)
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							if ((arg1 >= 0) && (arg1 <= 255))
								rip.color = arg1;
							break;
						case 'e': // RIP_ERASE_WINDOW !|e
                                                        /* This clears the TTY text window to the current graphics
                                                         * background
                                                         * color and positions the cursor in the upper-left corner of
                                                         * the
                                                         * window.  If the text window is inactive, then this command is
                                                         * ignored.  If the text and graphics windows overlap, then this
                                                         * command
                                                         * will clear the overlapping portion also.
                                                         */
							handled = true;
							rv_erase("ETW", NULL);
							break;
						case 'f': // RIP_SET_WORLD_FRAME (v2.A0)
							handled = true;
							GET_XY();
							rip.x_dim = x1;
							rip.y_dim = y1;
							assert_rwlock_rdlock(&vstatlock);
							rip.x_max = vstat.scrnwidth;
							rip.y_max = vstat.scrnheight;
							assert_rwlock_unlock(&vstatlock);
							if (rip.x_max > rip.x_dim)
								rip.x_max = rip.x_dim;
							if (rip.y_max > rip.y_dim)
								rip.y_max = rip.y_dim;

                                                        // TODO: Hack... we should likely scale both directions...
							rip.viewport.sx = 0;
							rip.viewport.sy = 0;
							rip.viewport.ex = x1 - 1;
							rip.viewport.ey = y1 - 1;
							FREE_AND_NULL(rip.xmap);
							FREE_AND_NULL(rip.ymap);
							FREE_AND_NULL(rip.xunmap);
							FREE_AND_NULL(rip.yunmap);
							break;
						case 'g': // RIP_GOTOXY !|g <x> <y>
                                                        /* This command sets the position of the text cursor in the TTY
                                                         * Text
                                                         * window, if it is active.  If inactive (if the dimensions are
                                                         * 0,0,0,0), then this command is ignored.  This command is
                                                         * equivalent
                                                         * to the ANSI/VT-100 command goto x/y, <Esc>[x;yH, except that
                                                         * the
                                                         * coordinates of that ANSI command are 1-based and the
                                                         * coordinates of
                                                         * this RIPscrip command are 0-based.
                                                         */
							handled = true;
							GET_XY();
							cterm_gotoxy(cterm, x1 + 1, y1 + 1);
							break;
						case 'i': // RIP_OVAL_PIE_SLICE !|i <x> <y> <st_ang> <e_ang> <radx>
                                                          // <rady>

                                                        /* This command draws an  "elliptical pie slice".  It obeys all
                                                         * of the
                                                         * same commands as the Elliptical Arc command described above.
                                                         *  The
                                                         * ends of the arc are connected to the Center-Point of the Arc
                                                         * with two
                                                         * straight lines.  These two lines converge at the
                                                         * Center-Point.  The
                                                         * interior of the Slice is filled with the current Fill Color
                                                         * and
                                                         * Pattern.  The exterior (outline) of the Slice is drawn using
                                                         * the
                                                         * current drawing color and line thickness.  The Line Pattern
                                                         * feature
                                                         * does not apply to this command.
                                                         */
							handled = true;
							GET_XY();
							arg1 = parse_mega(&args[4], 2);
							arg2 = parse_mega(&args[6], 2);
							x2 = parse_mega(&args[8], 2);
							y2 = parse_mega(&args[10], 2);
							if ((arg1 < 0) || (arg2 < 0) || (x2 < 0) || (y2 < 0))
								break;
							if ((x2 == 0) && (y2 == 0))
								break;
							fg = map_rip_color(rip.color) | 0x40000000;

							ex =
							    roundl((x2 * y2)
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg1 * (M_PI / 180.0))), 2))));
							if (((arg1 % 360) > 90) && ((arg1 % 360) < 270))
								ex = 0 - ex;
							ex += x1;
							ey =
							    roundl((x2 * y2 * tan(arg1 * (M_PI / 180.0)))
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg1 * (M_PI / 180.0))), 2))));
							if (((arg1 % 360) > 90) && ((arg1 % 360) < 270))
								ey = 0 - ey;
							ey = y1 - ey;

                                                        // ex = x1 + (x2 * cos(arg1 * (M_PI / 180.0)));
                                                        // ey = y1 - (y2 * sin(arg1 * (M_PI / 180.0)));
							set_line(x1, y1, ex, ey, fg, 0xffff, rip.line_width);
							full_ellipse(x1, y1, arg1, arg2, x2, y2, false, fg);

							ex =
							    round((x2 * y2)
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg2 * (M_PI / 180.0))), 2))));
							if (((arg2 % 360) > 90) && ((arg2 % 360) < 270))
								ex = 0 - ex;
							ex += x1;
							ey =
							    roundl((x2 * y2 * tan(arg2 * (M_PI / 180.0)))
							        / (sqrt(y2 * y2 + x2 * x2
							        * pow((tan(arg2 * (M_PI / 180.0))), 2))));
							if (((arg2 % 360) > 90) && ((arg2 % 360) < 270))
								ey = 0 - ey;
							ey = y1 - ey;

                                                        // ex = x1 + (x2 * cos(arg2 * (M_PI / 180.0)));
                                                        // ey = y1 - (y2 * sin(arg2 * (M_PI / 180.0)));
							set_line(x1, y1, ex, ey, fg, 0xffff, rip.line_width);
							do_fill(false);
							break;
						case 'j': // RIP_POINT (Not in Alpha docs)
                                                        /* This command will draw a single point in the current line
                                                         * style
                                                         */
							handled = true;
							if (no_viewport())
								break;
							GET_XY();
							draw_line(x1, y1, x1, y1, true);
							break;
						case 'l': // RIP_POLYLINE !|l <npoints> <x1> <y1> ... <xn> <yn>
                                                        /* This command will draw a multi-faceted line.  It is identical
                                                         * in
                                                         * nature to the RIP_POLYGON command above, except that the last
                                                         * point
                                                         * is NOT connected to the first point.  Generally speaking, a
                                                         * Poly-
                                                         * Line is not an "enclosed area".  It should not be filled
                                                         * unless
                                                         * you are very careful to close the shape so that it leaves a
                                                         * fillable
                                                         * area.  The segments of the Poly-Line are drawn using the
                                                         * current
                                                         * drawing color, line pattern, thickness and Drawing Write
                                                         * Mode.
                                                         *
                                                         * The <npoints> parameter is between 2 and 512 and indicates
                                                         * how many
                                                         * (x,y) coordinate pairs will follow, which is also the number
                                                         * of sides
                                                         * of the Poly-Line.
                                                         */
							handled = true;
							if (no_viewport())
								break;
							arg1 = parse_mega(&args[0], 2);
							for (i = 0; i < arg1; i++) {
								if (i == 0) {
									x1 = parse_mega(&args[2], 2);
									if (x1 == -1)
										break;
									y1 = parse_mega(&args[4], 2);
									if (y1 == -1)
										break;
								}
								else {
									x2 = parse_mega(&args[2 + i * 4], 2);
									if (x2 == -1)
										break;
									y2 = parse_mega(&args[4 + i * 4], 2);
									if (y2 == -1)
										break;
									draw_line(x1, y1, x2, y2, true);
									x1 = x2;
									y1 = y2;
								}
							}
							break;
						case 'm': // RIP_MOVE !|m <x> <y>
                                                        /* This command moves the current graphics drawing cursor to
                                                         * (x,y).  You
                                                         * could use this to draw text at a certain point, but you'd
                                                         * probably
                                                         * use RIP_TEXT_XY instead.  This command is primarily provided
                                                         * for
                                                         * future development which will make use of its ability to
                                                         * relocate the
                                                         * current drawing position without physically drawing anything.
                                                         */
							handled = true;
							GET_XY();
							if (x1 > rip.viewport.ex - rip.viewport.sx + 1)
								break;
							if (y1 > rip.viewport.ey - rip.viewport.sy + 1)
								break;
							rip.x = x1;
							rip.y = y1;
							break;
						case 'o': // RIP_FILLED_OVAL
							handled = true;
							GET_XY();
							full_ellipse(x1,
							    y1,
							    0,
							    360,
							    parse_mega(&args[4], 2),
							    parse_mega(&args[6], 2),
							    true,
							    map_rip_color(rip.color));
							break;
						case 'p': // RIP_FILL_POLYGON !|p <npoints> <x1> <y1> ... <xn> <yn>
                                                          /* This command is identical to RIP_POLYGON, except that the
                                                           * interior of
                                                           * the polygon is filled with the current fill color and fill
                                                           * pattern.
                                                           * The actual outline of the polygon is drawn using the
                                                           * current
                                                           * drawing
                                                           * color, line pattern and thickness.
                                                           *
                                                           * NOTE:  You will get unusual effects if the lines of the
                                                           * polygon
                                                           *        overlap, creating a polygon with internal "gaps".
                                                           *  (The rule
                                                           *        is this: regions that are "inside" the polygon an
                                                           * even
                                                           * number
                                                           *        of times due to overlap are NOT filled.)  The
                                                           * interior
                                                           * fill
                                                           *        does not utilize Write Mode, but the outline of the
                                                           * polygon
                                                           *        does.
                                                           */
#if 0
							if (rip.version == RIP_VERSION_3) {
								handled = true;
								if (no_viewport())
									break;
								fg = map_rip_color(rip.color) | 0x40000000;
								arg1 = parse_mega(&args[0], 2);
								for (i = 0; i < arg1; i++) {
									if (i == 0) {
										x1 = parse_mega(&args[2], 2);
										if (x1 == -1)
											break;
										y1 = parse_mega(&args[4], 2);
										if (y1 == -1)
											break;
									}
									else {
										x2 = parse_mega(&args[2 + i * 4], 2);
										if (x2 == -1)
											break;
										y2 = parse_mega(&args[4 + i * 4], 2);
										if (y2 == -1)
											break;
										set_line(x1, y1, x2, y2, fg,
										    rip.line_pattern, rip.line_width);
										x1 = x2;
										y1 = y2;
									}
								}
								if (i > 0) {
									x2 = parse_mega(&args[2], 2);
									if (x1 == -1)
										break;
									y2 = parse_mega(&args[4], 2);
									if (y1 == -1)
										break;
									set_line(x1, y1, x2, y2, fg,
									    rip.line_pattern, rip.line_width);
									do_fill(false);
								}
								break;
							}
#endif /* if 0 */

                                                        // DOES NOT DRAW LINES IN COLOR ZERO!!!
                                                        // Not bug-compliant with RIPterm (But getting very close!)
							handled = true;
							if (no_viewport())
								break;
							arg1 = parse_mega(&args[0], 2);
							if(arg1 < 1)
								break;
							struct point *argv = malloc(sizeof(struct point) * arg1);
							x1 = rip.x_dim - 1;
							y1 = rip.x_dim - 1;
							x2 = 0;
							y2 = 0;

                                                        // Read lines and calculate extents
							for (i = 0; i < arg1; i++) {
								argv[i].x = parse_mega(&args[2 + i * 4], 2);
								if (argv[i].x < x1)
									x1 = argv[i].x;
								if (argv[i].x > x2)
									x2 = argv[i].x;
								argv[i].y = parse_mega(&args[4 + i * 4], 2);
								if (argv[i].y < y1)
									y1 = argv[i].y;
								if (argv[i].y > y2)
									y2 = argv[i].y;
							}

                                                        /*
                                                         * Now, count how many lines are crossed in a row and for odd
                                                         * numbers fill the point and for even numbers do not fill.
                                                         *
                                                         * (As described in RIP docs)
                                                         */
							for (y = y1; y <= y2; y++) {
								for (x = x1; x <= x2; x++) {
									arg2 = 0;
									int gt = 0;
									int eq = 0;
									int lt = 0;

                                                                        // Loop through all the polylines...
                                                                        // It appears required that this be in order.
									for (j = 0; j < arg1; j++) {
										i = j + 1;
										if (i == arg1)
											i = 0;

										int sx, sy, ex, ey;

										if (argv[j].y < argv[i].y) {
											sx = argv[j].x;
											sy = argv[j].y;
											ex = argv[i].x;
											ey = argv[i].y;
										}
										else {
											sx = argv[i].x;
											sy = argv[i].y;
											ex = argv[j].x;
											ey = argv[j].y;
										}

                                                                                // Ensure the line crosses the current
                                                                                // row...
										if ((y < argv[j].y)
										    != (y < argv[i].y)) {
											int xintc;

											xintc = (ex - sx) * (y - sy)
											    / (ey - sy) + sx;

											if (x > xintc) {
												gt++;
												arg2 = !arg2;
											}
											else if (x == xintc) {
                                                                                                // Only if this is a
                                                                                                // left edge(?)
												eq++;
											}
											else {
												lt++;
											}
										}
									}
									if (eq && ((lt & 1) > (gt & 1)))
										arg2 = !arg2;
									else if (eq > 1)
										arg2 = 1;
									if (arg2)
										fill_pixel(x, y);
								}
							}
							if (rip.color != 0) {
								for (i = 1; i < arg1; i++)
									draw_line(argv[i - 1].x,
									    argv[i - 1].y,
									    argv[i].x,
									    argv[i].y, false);
								draw_line(argv[arg1 - 1].x,
								    argv[arg1 - 1].y,
								    argv[0].x,
								    argv[0].y, true);
							}
							free(argv);
							break;
						case 's': // RIP_FILL_PATTERN !|s <c1> <c2> <c3> <c4> <c5> <c6> <c7>
                                                          // <c8> <col>

                                                        /* This command allows you to specify a user-defined, custom
                                                         * Fill
                                                         * Pattern.  This pattern supersedes the predefined patterns of
                                                         * RIP_FILL_STYLE.  A custom fill pattern is an 8x8 pixel array
                                                         * defining
                                                         * which pixels should be drawn in the current fill color (as
                                                         * set by the
                                                         * <col> parameter here).  The other pixels in the fill area are
                                                         * set to
                                                         * the current background color (color 00, typically black).
                                                         *
                                                         * Each of the eight parameters of this command, <c1> through
                                                         * <c8>
                                                         * represent bit-patterns for a line of the 8x8 pixel array.
                                                         *  Each line
                                                         * is comprised of 8 pixels.  The value of each parameter is the
                                                         * binary
                                                         * representation of these 8 pixels as follows:
                                                         *
                                                         *      Bit     7     6    5    4   3   2   1   0
                                                         *      ----------------------------------------------
                                                         *      c1     128   64   32   16   8   4   2   1
                                                         *      c2     128   64   32   16   8   4   2   1
                                                         *      c3     128   64   32   16   8   4   2   1
                                                         *      c4     128   64   32   16   8   4   2   1
                                                         *      c5     128   64   32   16   8   4   2   1
                                                         *      c6     128   64   32   16   8   4   2   1
                                                         *      c7     128   64   32   16   8   4   2   1
                                                         *      c8     128   64   32   16   8   4   2   1
                                                         *
                                                         * So, c1 is the top, and the most-significant bit is to the
                                                         * left.
                                                         *
                                                         * NOTE:  The RIP_FILL_STYLE (predefined fill patterns) and this
                                                         *        RIP_FILL_PATTERN (custom fill patterns) completely
                                                         * override
                                                         *        each other's effects.
                                                         */
							handled = true;
							if (parse_mega(&args[0], 2) < 0)
								break;
							if (parse_mega(&args[2], 2) < 0)
								break;
							if (parse_mega(&args[4], 2) < 0)
								break;
							if (parse_mega(&args[6], 2) < 0)
								break;
							if (parse_mega(&args[8], 2) < 0)
								break;
							if (parse_mega(&args[10], 2) < 0)
								break;
							if (parse_mega(&args[12], 2) < 0)
								break;
							if (parse_mega(&args[14], 2) < 0)
								break;
							arg1 = parse_mega(&args[16], 2);
							if ((arg1 < 0) || (arg1 > 255))
								break;
							rip.fill_pattern[0] = parse_mega(&args[0], 2) & 0xff;
							rip.fill_pattern[1] = parse_mega(&args[2], 2) & 0xff;
							rip.fill_pattern[2] = parse_mega(&args[4], 2) & 0xff;
							rip.fill_pattern[3] = parse_mega(&args[6], 2) & 0xff;
							rip.fill_pattern[4] = parse_mega(&args[8], 2) & 0xff;
							rip.fill_pattern[5] = parse_mega(&args[10], 2) & 0xff;
							rip.fill_pattern[6] = parse_mega(&args[12], 2) & 0xff;
							rip.fill_pattern[7] = parse_mega(&args[14], 2) & 0xff;
							rip.fill_color = arg1;
							break;
						case 't': // RIP_POLY_BEZIER_LINE (v2.A2)
							handled = true;
							rip_poly_bezier(args, false, false);
							break;
						case 'v': // RIP_VIEWPORT !|v <x0> <y0> <x1> <y1>
                                                          /* This command defines the (X,Y) pixel boundaries of the
                                                           * RIPscrip
                                                           * graphics window, which will contain all RIPscrip graphics
                                                           * output.
                                                           * ASCII/ANSI text will be displayed in the virtual TTY window
                                                           * defined
                                                           * by the RIP_TEXT_WINDOW command above.  (x0,y0) defines the
                                                           * upper-left
                                                           * corner of the graphics viewport, and (x1,y1) defines the
                                                           * lower-right
                                                           * corner (inclusive).  The viewport may be disabled, so
                                                           * RIPscrip
                                                           * graphics commands are ignored, by setting all parameters to
                                                           * zero (0).
                                                           *
                                                           * Graphics displayed in the viewport are "truncated" at this
                                                           * rectangular
                                                           * border, meaning if a circle would normally extend outside
                                                           * one
                                                           * of the
                                                           * borders, it will be chopped, only displaying the portion of
                                                           * the
                                                           * circle that is contained inside the viewport boundaries.
                                                           *
                                                           * Coordinates are specified based on a 640x350 pixel
                                                           * resolution, meaning
                                                           * X can be anywhere from 0 - 639, and Y can be anywhere from
                                                           * 0
                                                           * - 349.
                                                           * x0 must be less than x1 and y0 must be less than y1 unless
                                                           * all
                                                           * parameters are set to zero, indicating that the graphics
                                                           * window is
                                                           * disabled.
                                                           */

							handled = true;
							GET_XY2();

                                                        // TODO: Range check...
							rip.viewport.sx = x1;
							rip.viewport.sy = y1;
							rip.viewport.ex = x2;
							rip.viewport.ey = y2;
							break;
						case 'w': // RIP_TEXT_WINDOW !|w <x0> <y0> <x1> <y1> <wrap> <size>
                                                        /* This command specifies the dimensions of the virtual TTY
                                                         * window that
                                                         * will display all ASCII/ANSI (non-RIPscrip) data coming across
                                                         * the
                                                         * connection.  (x0,y0) defines the upper-left corner of the
                                                         * window in
                                                         * text-based character- cell coordinates.  (x1,y1) defines the
                                                         * lower-right corner of the window (inclusive).  There may be
                                                         * two
                                                         * simultaneous windows on the screen, one for TTY text, and one
                                                         * for the
                                                         * display of RIPscrip graphics (a viewport), and they may
                                                         * overlap.
                                                         *
                                                         * Bytes received over the modem are first checked for RIPscrip
                                                         * commands.  All bytes that don't conform to the RIPscrip
                                                         * syntax are
                                                         * treated as ANSI/ASCII and displayed in the TTY window (if
                                                         * defined).
                                                         * User keystrokes that are echoed by the BBS would also appear
                                                         * in the
                                                         * text window by this scheme.
                                                         *
                                                         * The text window may be made invisible, ignoring all
                                                         * non-RIPscrip
                                                         * bytes, by setting all RIP_TEXT_WINDOW parameters to zero (0).
                                                         *  The X
                                                         * and Y parameters ranges vary depending on the setting of the
                                                         * <size>
                                                         * parameter which governs the font size used for the output
                                                         * text. Valid
                                                         * settings for the <size> parameter and the ranges for X/Y
                                                         * values are
                                                         * as follows:
                                                         *
                                                         *         Size   Font Size   X Range  Y Range
                                                         *         ------------------------------------------
                                                         *          0     8x8          0-79     0-42
                                                         *          1     7x8          0-90     0-42
                                                         *          2     8x14         0-79     0-24
                                                         *          3     7x14         0-90     0-24
                                                         *          4     16x14        0-39     0-24
                                                         *
                                                         * The <wrap> parameter applies to both the horizontal and
                                                         * vertical
                                                         * dimensions.  If <wrap> is set to 1, then any text that
                                                         * extends beyond
                                                         * the right margin of the window will wrap to the next line of
                                                         * the
                                                         * window, scrolling the window up if necessary.  If <wrap> is
                                                         * 0, then
                                                         * any text going beyond the right margin is truncated and no
                                                         * scrolling
                                                         * is performed; the cursor remains at the right margin.
                                                         *
                                                         * NOTE:  If the text window currently being defined is
                                                         * identical to the
                                                         *        currently defined text window, the cursor will not be
                                                         *        relocated to the upper-left corner of the window. The
                                                         * only
                                                         *        aspect of the text window that can be different and
                                                         * still be
                                                         *        deemed "identical" is the <wrap> parameter.  For the
                                                         * current
                                                         *        and new text windows to be considered identical, the
                                                         *        parameters <x0>, <y0>, <x1>, <y1> and <size> must be
                                                         * the same.
                                                         */
							handled = true;
							GET_XY2();
							if ((x1 == 0) && (x2 == 0) && (y1 == 0) && (y2 == 0)) {
								rip.text_disabled = true;
								rip.ansi_state = ANSI_STATE_NONE;
								break;
							}
							rip.text_disabled = false;

							arg1 = parse_mega(&args[8], 1);
							if ((arg1 < 0) || (arg1 > 1))
								break;
							arg2 = parse_mega(&args[9], 1);
							if (arg2 == -1)
								break;
							struct text_info ti;
							gettextinfo(&ti);
							if (arg1)
								cterm->extattr |= CTERM_EXTATTR_AUTOWRAP;
							else
								cterm->extattr &= ~CTERM_EXTATTR_AUTOWRAP;
							assert_rwlock_rdlock(&vstatlock);
							if ((x1 == cterm->left_margin - 1)
							    && (x2 == cterm->right_margin - 1)
							    && (y1 == cterm->top_margin - 1)
							    && (y2 == cterm->bottom_margin - 1)
							    && (arg2 == vstat.charwidth)) {
								assert_rwlock_unlock(&vstatlock);
								break;
							}
							assert_rwlock_unlock(&vstatlock);
							switch (arg2) {
								case 0:
									reinit_screen(
										(uint8_t *)conio_fontdata[0].eight_by_eight,
										8,
										8);
									break;
								case 1:
									reinit_screen(ripfnt7x8, 7, 8);
									break;
								case 2:
									reinit_screen(
										(uint8_t *)conio_fontdata[0].eight_by_fourteen,
										8,
										14);
									break;
								case 3:
									reinit_screen(ripfnt7x14, 7, 14);
									break;
								case 4:
									reinit_screen(ripfnt16x14, 16, 14);
									break;
							}
							arg3 = 0;
							if (x1 >= cterm->width)
								x1 = cterm->width - 1;
							if (x2 >= cterm->width)
								x2 = cterm->width - 1;
							if (y1 >= cterm->height)
								y1 = cterm->height - 1;
							if (y2 >= cterm->height)
								y2 = cterm->height - 1;

							if ((x1 != cterm->left_margin - 1)
							    || (y1 != cterm->top_margin - 1)
							    || (x2 != cterm->right_margin - 1)
							    || (y2 != cterm->bottom_margin - 1))
								arg3 = 1;
							cterm->left_margin = x1 + 1;
							cterm->top_margin = y1 + 1;
							cterm->right_margin = x2 + 1;
							cterm->bottom_margin = y2 + 1;

							cterm->extattr |= CTERM_EXTATTR_ORIGINMODE;
							if (arg3) {
								setwindow(cterm);
								arg3 = hold_update;
								hold_update = 0;
								gotoxy(1, 1);
								hold_update = arg3;
							}
							break;
						case 'x': // RIP_FILLED_POLY_BEZIER (v2.A2)
							handled = true;
							rip_poly_bezier(args, true, true);
							break;
						case 'z': // RIP_POLY_BEZIER (v2.A1)
							handled = true;
							rip_poly_bezier(args, false, true);
							break;
					}
			}
			break;
		case 1:
			switch (sublevel) {
				case 0:
					switch (cmd) {
						case '\x1b': // RIP_QUERY !|1<escape> <mode> <res> <text>
                                                        /* The Query Text Variable RIPscrip command instructs the
                                                         * terminal to
                                                         * immediately respond with some piece of information, whether
                                                         * statically stored (i.e., in a database), stored internally in
                                                         * RAM
                                                         * (dynamic information), or pre-defined Text Variables.
                                                         *
                                                         * This command is unique in RIPscrip in the fact that the
                                                         * command
                                                         * character that is used is NOT a printable character.  We use
                                                         * the
                                                         * escape character (ASCII 27) to introduce this command as a
                                                         * measure of
                                                         * security.  Since the query command can query the terminal for
                                                         * some
                                                         * critical (potentially private) information, you would not
                                                         * want a user
                                                         * to be able to query another user's terminal for something
                                                         * like his
                                                         * address information, or something that he wouldn't want to
                                                         * otherwise
                                                         * divulge to unauthorized people.  Since most hosts do not
                                                         * allow the
                                                         * user to enter an escape character, this character is ideal
                                                         * for this
                                                         * purpose.  Using escape allows only the Host (under most
                                                         * circumstances) to be in control of any queries.
                                                         *
                                                         * NOTE:  This command is very flexible in that you can specify
                                                         *        control characters, pick-list definitions, Text
                                                         * Variables,
                                                         *        and Host Command template definitions.  See the
                                                         * section
                                                         *        entitled HOST COMMANDS for a more detailed explanation
                                                         *        of these features.
                                                         *
                                                         * Whether the information is transmitted instantly or not is
                                                         * dependent
                                                         * on the <mode> parameter.  The <mode> parameter determines
                                                         * when data
                                                         * queries are processed.  The possible settings for the <mode>
                                                         * parameter are as follows:
                                                         *
                                                         *
                                                         *     Mode     Description
                                                         *
                                                         *
                                                         * ----------------------------------------------------------------
                                                         *      0    Process the query command NOW (upon receipt)
                                                         *      1    Process when mouse clicked in Graphics Window
                                                         *      2    Process when mouse clicked in Text Window (any text
                                                         *           variables that return X or Y mouse coordinates
                                                         * return TEXT
                                                         *           coordinates, not graphics coordinates in this mode.
                                                         *  These
                                                         *           coordinates are two-digit values instead of the
                                                         * graphical
                                                         *           values that are four digits).
                                                         *
                                                         * Note that modes 1-2 do not return the results of the Query
                                                         * instantly.
                                                         * They query commands are processed when the user clicks the
                                                         * mouse
                                                         * either in the text window, or in the graphics window
                                                         * respectively.
                                                         * These "queries after mouse clicks" are only acted upon if the
                                                         * user is
                                                         * clicking on something other than a Button or a Mouse Field.
                                                         * To
                                                         * disable these two special "deferred" query modes, issue the
                                                         * same
                                                         * command with the query string of $OFF$.  This will disable
                                                         * this
                                                         * mode.  Providing a <text> parameter of anything other than
                                                         * $OFF$ will
                                                         * produce a revised query command (active).
                                                         *
                                                         * Basically put, a Query command will be immediately acted upon
                                                         * by the
                                                         * Terminal program when received.  The Query command's <text>
                                                         * parameter
                                                         * can contain any number of Host Command "segments", which can
                                                         * instruct
                                                         * the terminal "how to" send data to the host, and more
                                                         * specifically,
                                                         * what data to send to the host.
                                                         *
                                                         * Some examples of query statements might be any of the
                                                         * following:
                                                         *
                                                         *                         ^m     Send a carriage return to the
                                                         * BBS now!
                                                         *   My name is $FULL_NAME$^m     Send text "My name is
                                                         * <insert-name-
                                                         *                                here>" followed by a  carriage
                                                         * return
                                                         *                                to the BBS.  The
                                                         * <insert-name-here>
                                                         *                                will be replaced with whatever
                                                         * the
                                                         *                                variable $FULL_NAME$ contains.
                                                         *
                                                         * See the section entitled HOST COMMANDS for a detailed
                                                         * explanation of
                                                         * Host Commands, and what you can do with the Query command.
                                                         *
                                                         * NOTE:  The <res> parameter is reserved for future use by
                                                         * TeleGrafix
                                                         *        Communications, Inc..  It should be set to 000 for
                                                         *        compatibility with future releases.
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 1);
							arg2 = parse_mega(&args[1], 3);
							switch (arg1) {
								case 0:
									handle_command_str(&args[4]);
									break;
								case 1:
									FREE_AND_NULL(rip.graphics_click);
									if (strcmp(&args[4], "$OFF$"))
										rip.graphics_click = strdup(&args[4]);
									break;
								case 2:
									FREE_AND_NULL(rip.text_click);
									if (strcmp(&args[4], "$OFF$"))
										rip.text_click = strdup(&args[4]);
									break;
								default:
									printf("Unhandled QUERY type %d\n", arg1);
									break;
							}
							break;
						case 'B': // RIP_BUTTON_STYLE !|1B <wid> <hgt> <orient> <flags>
                                                          // <bevsize> <dfore> <dback> <bright> <dark> <surface>
                                                          // <grp_no> <flags2> <uline_col> <corner_col> <res>

                                                        /* This RIPscrip command is probably one of the most complex in
                                                         * the
                                                         * entire protocol.  It defines how subsequent RIP_BUTTON
                                                         * commands will
                                                         * be interpreted.  The purpose of this command is to define
                                                         * what a
                                                         * Button is and how they operate.  Buttons can have many
                                                         * different
                                                         * configurations, flags, and styles.  With the diversity of
                                                         * modes that
                                                         * the Button can take on, complexity is a necessary evil.
                                                         *
                                                         * This command does not actually do anything visibly on the
                                                         * screen.
                                                         * Simply put, this creates an internal definition for the
                                                         * Button mode
                                                         * which will be used with RIP_BUTTON commands after the
                                                         * definition is
                                                         * created.
                                                         *
                                                         * Every Button can have an optional text label.  It can appear
                                                         * in
                                                         * several different locations compared to the Button itself.
                                                         *  This is
                                                         * specified in the <orient> parameter.  The actual text of the
                                                         * label is
                                                         * not specified with this command, it is specified when you
                                                         * actually
                                                         * create a Button (see RIP_BUTTON below).  The value that
                                                         * <orient> can
                                                         * be is as follows:
                                                         *
                                                         *         Value   Description of Orientation
                                                         *         -------------------------------------------------
                                                         *          00     Display label above button
                                                         *          01     Display label to the left of button
                                                         *          02     Display label in the center of the button
                                                         *          03     Display label to the right of button
                                                         *          04     Display label beneath the button
                                                         *
                                                         * There are three basic "types" of Buttons.  There are Icon
                                                         * buttons,
                                                         * Clipboard buttons and Plain buttons.  Each of these differ in
                                                         * the
                                                         * way that they create the button's image.  A description of
                                                         * each type
                                                         * is as follows:
                                                         *
                                                         *      ICON BUTTON (flag 128) - An Icon Button means that the
                                                         *      actual image of the button will be created by loading a
                                                         *      bitmap icon image from the disk and load it at the given
                                                         *      locatino.  Any special effects (see below) can be
                                                         * applied
                                                         *      to the Icon to further enhance the image.  The filename
                                                         *      for the Icon is supplied with the RIP_BUTTON command, as
                                                         *      is the Icon's upper left X/Y coordinate.  Icon Buttons
                                                         *      are always stamped in COPY mode.
                                                         *
                                                         *      CLIPBOARD BUTTON (flag 1) - A clipboard button uses the
                                                         *      current contents of the clipboard for the base image of
                                                         *      the button.  If no clipboard is defined, then the button
                                                         *      is ignored.  The clipboard is pasted in COPY mode at
                                                         *      the X/Y location specified in the RIP_BUTTON command
                                                         *      that defines the actual button instance.  Any special
                                                         *      effects can be applied to this image to further enhance
                                                         *      the overall button's image.
                                                         *
                                                         *      PLAIN BUTTON (flag 256) - A plain button is exactly
                                                         * that,
                                                         *      plain.  No special graphics are used to create the
                                                         * button.
                                                         *      The entire button region is simply filled-in with a
                                                         * solid
                                                         *      colored rectangle using the <surface> color.  Any
                                                         *      special effects can be further applied to enhance the
                                                         *      button's appearance.
                                                         *
                                                         * The <hgt> and <wid> parameters represent the fixed height and
                                                         * width
                                                         * of the Button (applies only to Plain Buttons).  If both
                                                         * values are
                                                         * greater than zero, then this will represent the actual size
                                                         * of the
                                                         * Button (its dimensions are not specified by the RIP_BUTTON
                                                         * command).
                                                         * If both of these are set to zero, then the actual RIP_BUTTON
                                                         * command
                                                         * will specify the size of the particular Button (dynamic
                                                         * sizing).
                                                         *
                                                         * The <bevsize> parameter is only used if the BEVEL FLAG (flag
                                                         * 512) is
                                                         * specified.  When active, this parameter will determine how
                                                         * many
                                                         * pixels thick the bevel should be.  This may be any value
                                                         * greater or
                                                         * equal to zero.
                                                         *
                                                         * There are a large number of flag values that can be combined
                                                         * to
                                                         * achieve a great many effects.  There are two flag parameters
                                                         * for the
                                                         * RIP_BUTTON_STYLE command, <flags> and <flags2>.  They are
                                                         * detailed in
                                                         * the two tables that follow in this Section.  You may combine
                                                         * any of
                                                         * the flags in the first table together simply by adding the
                                                         * "Value" of
                                                         * each one together and representing that number as a MegaNum.
                                                         *
                                                         * The <dfore> and <dback> parameters are used with the text
                                                         * label.  The
                                                         * <dfore> parameter is the foreground color for the text.  It
                                                         * is always
                                                         * used to determine the color of the text label.  The <dback>
                                                         * color is
                                                         * the color of the dropshadow (if any).  This parameter is only
                                                         * used
                                                         * when you have specified the "Dropshadow" flag in the <flags>
                                                         * parameter (see below).
                                                         *
                                                         * The <bright>, <dark> and <surface> parameters are used with
                                                         * Plain
                                                         * Buttons and with the Special Effects styles (see <flags>
                                                         * below).
                                                         * These colors represent the highlighted color, the shadowed
                                                         * color, and
                                                         * the regular surface color that is used in Special Effects.
                                                         *  Typical
                                                         * color combinations for these colors might be White, Dark-Gray
                                                         * and
                                                         * Light-Gray respectively for a "chiseled steel" appearance.
                                                         *  Each of
                                                         * these values can contain a two-digit value representing any
                                                         * valid
                                                         * color code that may be used in the RIP_COLOR command.
                                                         *
                                                         * In addition to the special effects colors, are two additional
                                                         * colors
                                                         * that can be used, <uline_color> which is used for the color
                                                         * of the
                                                         * underline (in the text label), and <corner_color> which is
                                                         * used to
                                                         * display the colors of corners for things like the Bevel,
                                                         * Recess, etc.
                                                         *
                                                         * The <grp_no> parameter determines which Button Group
                                                         * subsequent
                                                         * RIP_BUTTON commands will be associated with.  Button Groups
                                                         * are used
                                                         * to maintain groups of Buttons for things like Radio Buttons
                                                         * and/or
                                                         * Checkbox Buttons.  See the section on the BUTTON COMMAND for
                                                         * more
                                                         * information on these modes, and what Button Groups can offer.
                                                         *  This
                                                         * value can range anywhere from 0-Z (i.e., 0-35).  You should
                                                         * not mix
                                                         * Checkbox and Radio buttons in the same group. --
                                                         * unpredictable things
                                                         * may happen if you do.
                                                         *
                                                         * Some <flags> are mutually exclusive.  For example, you can
                                                         * only have
                                                         * one of the "Plain", "Icon", or "Clipboard" flags chosen at
                                                         * once.  To
                                                         * better assist you in determining which values can be combined
                                                         * with
                                                         * each other, the right-most five columns in the next two
                                                         * tables
                                                         * explain if the specific flag can be used under a specific
                                                         * condition.
                                                         * For example, you cannot choose the "Hot Icon" flag if you are
                                                         * dealing
                                                         * with a Clipboard Button.  Another example is that you cannot
                                                         * underline the hotkey character in the label if it is not a
                                                         * Mouse
                                                         * Button.
                                                         *
                                                         * The following table contains the possible flag values for the
                                                         * <flags>
                                                         * parameter.  Each of these values may be combined to achieve a
                                                         * "composite" group of flags.  See the preceding paragraphs for
                                                         * a more
                                                         * detailed explanation of this method.
                                                         *
                                                         * Value Description of Flags Field #1   Icon Clip  Plain Mouse
                                                         * No-Mouse
                                                         * ---------------------------------------------------------------------
                                                         *     1 Button is a "Clipboard Button"   N     Y     N     Y
                                                         *     Y
                                                         *     2 Button is "Invertable"           Y     Y     Y     Y
                                                         *     N
                                                         *     4 Reset screen after button click  Y     Y     Y     Y
                                                         *     N
                                                         *     8 Display Chisel special effect    Y     Y     Y     Y
                                                         *     Y
                                                         *    16 Display Recessed special effect  Y     Y     Y     Y
                                                         *     Y
                                                         *    32 Dropshadow the label (if any)    Y     Y     Y     Y
                                                         *     Y
                                                         *    64 Auto-stamp image onto Clipboard  Y     Y     Y     Y
                                                         *     Y
                                                         *   128 Button is an "Icon Button"       Y     N     N     Y
                                                         *     Y
                                                         *   256 Button is a "Plain Button"       N     N     Y     Y
                                                         *     Y
                                                         *   512 Display Bevel special effect     Y     Y     Y     Y
                                                         *     Y
                                                         *  1024 Button is a Mouse Button         Y     Y     Y     Y
                                                         *     N
                                                         *  2048 Underline hot-key in label       Y     Y     Y     Y
                                                         *     N
                                                         *  4096 Make Icon Button use Hot Icons   Y     N     N     Y
                                                         *     N
                                                         *  8192 Adj. vertical centering of label Y     Y     Y     Y
                                                         *     Y
                                                         * 16384 Button belongs to a Radio Group  Y     Y     Y     Y
                                                         *     N
                                                         * 32768 Display Sunken special effect    Y     Y     Y     Y
                                                         *     Y
                                                         *
                                                         * The Icon Button, Clipboard button and Plain flags have
                                                         * already been
                                                         * discussed.  Following, will be more discussion of the various
                                                         * flags
                                                         * used in the preceding table:
                                                         *
                                                         *      BUTTON IS INVERTABLE (flag 2) - This means that the
                                                         * button
                                                         *      will be inverted when clicked.  This flag is only useful
                                                         *      when combined with the "Button is a Mouse Button - flag
                                                         *      1024) flag.  Even if the button has special effects,
                                                         * those
                                                         *      will be inverted as well as they are considered part of
                                                         *      the button - all except for the Recessed effect.  The
                                                         *      recessed effect is NEVER considered part of the actual
                                                         *      button image, and will never be part of the mouse field,
                                                         *      button's image or anything - it is just extra graphics.
                                                         *
                                                         *      RESET SCREEN AFTER BUTTON CLICK (flag 4) - This flag is
                                                         *      used when the button is considered a Mouse Button (flag
                                                         *      1024).  What this means is that when the user clicks on
                                                         *      the button, the screen will be reset exactly the same
                                                         *      as a RIP_RESET_WINDOWS command will do.  The reset is
                                                         *      performed before the host command is processed (if any).
                                                         *
                                                         *      DISPLAY CHISEL SPECIAL EFFECT (flag 8) - This displays
                                                         *      a special effect on-top of the button image that gives
                                                         *      the visual impression of an indented gutter just to the
                                                         *      inside of the button's border.  The amount of
                                                         * indentation
                                                         *      varies depending on the size of the button.  See below
                                                         *      for a table of indentation values for the Chisel effect.
                                                         *
                                                         *      DISPLAY RECESSED SPECIAL EFFECT (flag 16) - This places
                                                         *      a recessed one-pixel bevel around the exterior of the
                                                         *      button.  It is never considered part of the button's
                                                         *      image.  Its purpose is to give the button a more 3D look
                                                         *      by making it appear that the button is "poking through"
                                                         *      a hole in a dialog box.  This effect is accomplished by
                                                         *      placing a black outline (one pixel wide) around the
                                                         *      exterior of the button's image (including bevel, etc),
                                                         *      then placing a one-pixel wide inverted bevel around the
                                                         *      black outline.
                                                         *
                                                         *      DROPSHADOW THE LABEL IF ANY (flag 32) - This flag will
                                                         *      instruct RIPscrip to place a dropshadowed version of the
                                                         *      text label one pixel to the right and one pixel lower
                                                         *      than the original label.  This is accomplished by
                                                         * drawing
                                                         *      the label first in the <dback> color, then drawing the
                                                         *      label offset up-left in the <dfore>.
                                                         *
                                                         *      AUTO-STAMP IMAGE ONTO CLIPBOARD (flag 64) - This option
                                                         *      is also known as "Auto-Clip".  What this means is right
                                                         *      after the first button's image is rendered (including
                                                         * any
                                                         *      special effects), it is automatically copied onto the
                                                         *      clipboard.  The Recessed special effect is not
                                                         * considered
                                                         *      part of the button image for this flag and is not made
                                                         *      part of the clipboard image.  After the image is copied
                                                         *      onto the clipboard, the label is drawn (this is so that
                                                         *      the label is not placed onto the clipboard), then a
                                                         *      number of flags in the current Button Style definition
                                                         *      are altered.  Specifically, the Icon and Plain flags are
                                                         *      disabled, and Clipboard button enabled (thus making any
                                                         *      subsequent buttons use the resultant Clipboard button
                                                         *      image for their button's representation).  In addition,
                                                         *      the chisel, bevel, auto-clip and sunken flags are
                                                         *      disabled.  The final result is a Clipboard button with
                                                         *      no special effects other than the Recessed effect (if
                                                         *      any).  This is most often used with Icon Buttons where
                                                         *      every subsequent button uses the same Icon over and over
                                                         *      again - the net result of this is less "disk thrashing"
                                                         *      whenever a button is created; in addition, buttons will
                                                         *      draw faster too.
                                                         *
                                                         *      BUTTON IS AN ICON BUTTON (flag 128) - See previous
                                                         *      discussions on button types above.
                                                         *
                                                         *      BUTTON IS A PLAIN BUTTON (flag 256) - See previous
                                                         *      discussions on button types above.
                                                         *
                                                         *      DISPLAY BEVEL SPECIAL EFFECT (flag 512) - When this flag
                                                         *      is active, a bevel will be drawn <size> pixels thick on
                                                         *      the outside of the base image of the button.  This makes
                                                         *      the button that many pixels wider and taller in each
                                                         *      direction.  See the RIP_BUTTON for a more detailed
                                                         *      description of the affects of the button's final size.
                                                         *
                                                         *      BUTTON IS A MOUSE BUTTON (flag 1024) - When this flag is
                                                         *      enabled, the button becomes a clickable mouse region.
                                                         *      When this option is in use, the Invert flag and several
                                                         *      others are available (see the preceding chart).  When
                                                         *      a button is a non-mouse button, then it is only used to
                                                         *      draw a dialog box or an elaborate "static graphic" image
                                                         *      of something that "looks" like a button.
                                                         *
                                                         *      UNDERLINE HOT-KEYS IN LABEL (flag 2048) - When this
                                                         *      flag is active, the first occurence of the hot-key
                                                         *      character in the button's label will be underlined using
                                                         *      the <uline_col> color.  Special care must be taken when
                                                         *      underlining the character, taking into consideration if
                                                         *      the character has a segment that goes below the
                                                         * "baseline"
                                                         *      of the font.  Consult the following section to determine
                                                         *      what ASCII characters have these "descenders".
                                                         *  Characters
                                                         *      with descenders have the underline drawn slightly lower
                                                         *      than for characters without them.
                                                         *
                                                         *      MAKE ICON BUTTON USE HOT ICONS (flag 4096) - A Hot Icon
                                                         *      is a button that has an alternative image when the
                                                         * button
                                                         *      is "depressed".  Normally, when a button is an Icon
                                                         *      button, some form of Icon File is used to create the
                                                         * image
                                                         *      of the button (eg, EMAIL.ICN).  When the Hot Icon flag
                                                         * is
                                                         *      in use, whenever that button is depressed, rather than
                                                         *      using the normal Icon File for the button's image, a
                                                         *      different Icon File is used for the button's image.  The
                                                         *      filename would be the same filename as the original
                                                         * Icon,
                                                         *      but with an extension of .HIC instead of .ICN.  When Hot
                                                         *      Icon is in use, the alternative Icon is stamped in COPY
                                                         *      mode.  If the file does not exist, then the original
                                                         *      Icon's image is used, but pasted in NOT mode for the
                                                         *      duration of the depression.
                                                         *
                                                         *      ADJ. VERTICAL CENTERING OF LABEL (flag 8192) - Some
                                                         * Labels
                                                         *      may appear non-centered vertically when drawn using some
                                                         *      fonts that are rather large.  With this in mind, you
                                                         * have
                                                         *      the option to adjust the vertical centering.  What this
                                                         *      does is take into consideration the height of any
                                                         *      descenders of the label and calculate those into the
                                                         *      overall height of the label before centering.  If this
                                                         *      flag is not used, then the descenders are not taken into
                                                         *      consideration when the vertical centering is calculated.
                                                         *      See the Font Metric tables below for more detailed
                                                         *      information on font sizes and their associated metrics.
                                                         *      This command has no effect if the Label orientation is
                                                         *      LEFT or RIGHT of the button.  It only applies to an
                                                         *      orientation of TOP, BOTTOM or CENTER.
                                                         *
                                                         *      BUTTON BELONGS TO A RADIO GROUP (flag 16384) - When this
                                                         *      flag is used, then any buttons defined in this button
                                                         *      <group_no> are considered to be radio buttons where only
                                                         *      one of the buttons can be clicked (selected) at any
                                                         *      particular time.  If a button is not a radio button or
                                                         *      a checkbox button, then the "selected" flag of the
                                                         *      RIP_BUTTON command is ignored.  When a Radio Button is
                                                         *      clicked, any other radio button in that button group
                                                         * that
                                                         *      is selected is automatically de-selected and the current
                                                         *      one selected.  Any host command is processed at the time
                                                         *      of the button click.  If a Radio Button is drawn
                                                         * initally
                                                         *      as selected, then that host command is processed at the
                                                         *      time of its initial drawing.  See the section near the
                                                         *      end of this document discussing TEMPLATES for a more
                                                         *      complete description of Radio Buttons and how they
                                                         *      interact with their Button Group and with each other.
                                                         *
                                                         *      DISPLAY SUNKEN SPECIAL EFFECT (flag 32768) - When this
                                                         *      option is enabled, a one-pixel inverted bevel is drawn
                                                         *      exactly one pixel to the inside of the base image of the
                                                         *      button.  This and the chisel effect are the only two
                                                         *      special effects which physically "overwrite" portions of
                                                         *      the base button image.
                                                         *
                                                         * This array defines which characters have descenders (portions
                                                         * of
                                                         * their font that go below the baseline).  This information is
                                                         * used in
                                                         * the vertical centering of button text labels.
                                                         *
                                                         * char low_char[256] =
                                                         * {
                                                         *
                                                         *
                                                         * 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                                         *
                                                         *
                                                         * 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                                         *
                                                         *
                                                         * 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                                         *
                                                         *
                                                         * 0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
                                                         *
                                                         *
                                                         * 1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,
                                                         *
                                                         *
                                                         * 0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                                         *
                                                         *
                                                         * 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                                         *
                                                         *
                                                         * 0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0
                                                         * };
                                                         *
                                                         * struct METRIC
                                                         * {
                                                         *     unsigned char top;    // Scan lines from TOP OF CELL to
                                                         * char top
                                                         *     unsigned char bow;    // Scan lines from TOC to crest of
                                                         * char
                                                         *     unsigned char base;   // Scan lines from TOC to baseline
                                                         *     unsigned char drop;   // Scan lines from TOC to lowermost
                                                         * pixel
                                                         * };
                                                         *
                                                         * The METRIC structure can be described visually as follows:
                                                         *
                                                         *                       0 --+----------+----------+
                                                         *                           |          |          |
                                                         *                      TOP__|__________|__________|
                                                         *                           | #        |          |
                                                         *                           | #        |          |
                                                         *                           | #        |          |
                                                         *                      BOW__|_#________|___   _ __|
                                                         *                           | # ###    |   ### #  |
                                                         *                           | ##   #   |  #   ##  |
                                                         *                           | #     #  | #     #  |
                                                         *                           | #     #  | #     #  |
                                                         *                           | #     #  | #     #  |
                                                         *                           | #     #  |  #   ##  |
                                                         *                     BASE__|_#_____#__|___###_#__|
                                                         *                           |          |       #  |
                                                         *                           |          |       #  |
                                                         *                           |          |       #  |
                                                         *                           |          |  #   #   |
                                                         *                     DROP__|__________|___###____|
                                                         *                           |          |          |
                                                         *                     END --+----------+----------+
                                                         *
                                                         * Notice that the topmost scan line of a font cell is not
                                                         * necessarily
                                                         * the top of the character.  The top field of the structure
                                                         * contains
                                                         * the vertical offset from the top of the cell for all fonts in
                                                         * that
                                                         * set.
                                                         *
                                                         *
                                                         *     Default Font (Font 0)               Triplex Font (Font 1)
                                                         *
                                                         * Size  Top    Bow   Base   Drop     Size   Top   Bow     Base
                                                         *   Drop
                                                         * ------------------------------
                                                         *     --------------------------------
                                                         *   1    0      2      6      7        1     6     10      18
                                                         *     22
                                                         *   2    0      4     13     15        2     6     11      20
                                                         *     24
                                                         *   3    0      6     20     23        3     8     13      23
                                                         *     28
                                                         *   4    0      8     27     31        4     10    17      31
                                                         *     38
                                                         *   5    0     10     34     39        5     13    23      41
                                                         *     50
                                                         *   6    0     12     41     47        6     16    28      51
                                                         *     62
                                                         *   7    0     14     48     55        7     20    34      62
                                                         *     76
                                                         *   8    0     16     55     63        8     25    42      77
                                                         *     94
                                                         *   9    0     18     62     71        9     30    51      93
                                                         *    114
                                                         *  10    0     20     69     79       10     40    67     124
                                                         *    152
                                                         *
                                                         *
                                                         *     Small Font (Font 2)                 Sans Serif Font (Font
                                                         * 3)
                                                         *
                                                         * Size  Top    Bow   Base   Drop     Size   Top   Bow     Base
                                                         *   Drop
                                                         * ------------------------------
                                                         *     --------------------------------
                                                         *   1    2      3      5      6        1      7    11      19
                                                         *     23
                                                         *   2    2      4      6      7        2      7    12      21
                                                         *     25
                                                         *   3    2      3      6      7        3      9    14      24
                                                         *     29
                                                         *   4    3      5      9     11        4     11    18      32
                                                         *     39
                                                         *   5    4      7     12     14        5     14    24      42
                                                         *     51
                                                         *   6    5      9     15     18        6     18    30      53
                                                         *     64
                                                         *   7    6     10     13     22        7     22    36      64
                                                         *     78
                                                         *   8    7     12     22     27        8     28    45      80
                                                         *     97
                                                         *   9    9     15     27     33        9     33    54      96
                                                         *    117
                                                         *  10   12     20     36     44       10     74   102     158
                                                         *    186
                                                         *
                                                         *
                                                         *
                                                         *      Gothic Font (Font 4)                Script Font (Font 5)
                                                         *
                                                         * Size  Top    Bow   Base   Drop     Size   Top   Bow     Base
                                                         *   Drop
                                                         * ------------------------------
                                                         *     --------------------------------
                                                         *   1    7     11     19     23        1     10    17      22
                                                         *     29
                                                         *   2    7     12     21     25        2     10    18      24
                                                         *     32
                                                         *   3    9     14     24     29        3     12    21      27
                                                         *     36
                                                         *   4   11     18     32     39        4     16    28      37
                                                         *     49
                                                         *   5   14     24     42     51        5     21    37      49
                                                         *     65
                                                         *   6   18     30     53     64        6     26    46      61
                                                         *     80
                                                         *   7   22     36     64     78        7     32    56      74
                                                         *     98
                                                         *   8   28     45     80     97        8     40    70      92
                                                         *    122
                                                         *   9   33     54     96    117        9     48    84     111
                                                         *    147
                                                         *  10   44     72    128    156       10     63   111     147
                                                         *    195
                                                         *
                                                         *
                                                         *
                                                         *     Simplex Font (Font 6)            Triplex Script Font
                                                         * (Font 7)
                                                         *
                                                         * Size  Top    Bow   Base   Drop     Size   Top   Bow     Base
                                                         *   Drop
                                                         * ------------------------------
                                                         *     --------------------------------
                                                         *   1    9     13     21     25        1      5     9      17
                                                         *     21
                                                         *   2    9     14     23     27        2      5    10      19
                                                         *     23
                                                         *   3   11     16     26     31        3      7    12      22
                                                         *     27
                                                         *   4   14     21     35     42        4      9    16      30
                                                         *     37
                                                         *   5   18     28     46     56        5     12    22      40
                                                         *     49
                                                         *   6   23     35     58     69        6     15    27      50
                                                         *     61
                                                         *   7   28     42     70     84        7     19    33      61
                                                         *     75
                                                         *   8   35     52     87    104        8     24    41      77
                                                         *     93
                                                         *   9   42     63    105    126        9     29    50      92
                                                         *    113
                                                         *  10   56     84    140    168       10     39    67     123
                                                         *    151
                                                         *
                                                         *
                                                         *
                                                         *     Complex Font (Font 8)               European Font (Font
                                                         * 9)
                                                         *
                                                         * Size  Top    Bow   Base   Drop     Size   Top   Bow     Base
                                                         *   Drop
                                                         * ------------------------------
                                                         *     --------------------------------
                                                         *   1    8     12     20     24        1      7    14      32
                                                         *     38
                                                         *   2    8     13     22     26        2      7    15      35
                                                         *     41
                                                         *   3   10     15     25     30        3      9    18      40
                                                         *     47
                                                         *   4   13     20     34     41        4     12    24      54
                                                         *     64
                                                         *   5   17     27     45     54        5     16    32      72
                                                         *     85
                                                         *   6   22     34     57     68        6     20    40      96
                                                         *    106
                                                         *   7   27     41     69     83        7     25    49     109
                                                         *    129
                                                         *   8   34     51     86    103        8     31    61     136
                                                         *    161
                                                         *   9   41     62    104    125        9     38    74     164
                                                         *    194
                                                         *  10   54     83    139    167       10     51    99     219
                                                         *    259
                                                         *
                                                         *
                                                         *
                                                         *      Bold Font (Font 10)
                                                         *
                                                         * Size  Top    Bow   Base   Drop
                                                         * ------------------------------
                                                         *   1   11     17     35     39
                                                         *   2   13     19     39     43
                                                         *   3   14     22     44     49
                                                         *   4   19     29     59     66
                                                         *   5   27     39     79     88
                                                         *   6   33     49     99    110
                                                         *   7   39     59    119    133
                                                         *   8   49     74    149    166
                                                         *   9   59     89    179    200
                                                         *  10   79    199    239    267
                                                         *
                                                         * The Chisel effect draws a dropshadowed line around the inside
                                                         * of the
                                                         * button.  How far from the borders of the button are
                                                         * determined by
                                                         * this table:
                                                         *
                                                         *         Height of Button     X inset     Y inset
                                                         *         ----------------------------------------
                                                         *             0 - 11              1          1
                                                         *            12 - 24              3          2
                                                         *            25 - 39              4          3
                                                         *            40 - 74              6          5
                                                         *            75 - 149             7          5
                                                         *           150 - 199             8          6
                                                         *           200 - 249            10          7
                                                         *           250 - 299            11          8
                                                         *           300 -                13          9
                                                         *
                                                         * This table describes the possible flag settings for the
                                                         * <flags2>
                                                         * parameter:
                                                         *
                                                         * Val Description of Flags Field #2    Icon Clip Plain Mouse
                                                         * No-Mouse
                                                         * -------------------------------------------------------------------
                                                         *  1  Button is in a check box group     Y    Y    Y     Y
                                                         *       N
                                                         *  2  Highlight hotkey character         Y    Y    Y     Y
                                                         *       N
                                                         *  4  Explode (zoom out when clicked)    Y    Y    Y     Y
                                                         *       N
                                                         *  8  Left Justify Label (top/ctr/btm)   Y    Y    Y     Y
                                                         *       Y
                                                         * 16  Right Justify Label (top/ctr/btm)  Y    Y    Y     Y
                                                         *       Y
                                                         *
                                                         * Following is a more complete description of the flags
                                                         * described in
                                                         * the <flags2> parameter:
                                                         *
                                                         *      BUTTON IS IN A CHECK BOX GROUP (flag 1) - When this flag
                                                         * is
                                                         *      selected, then the button <group_no> is considered a
                                                         * Check-
                                                         *      box group.  When in this mode, the Radio Group flag is
                                                         * not
                                                         *      accessible - A Button Group can be a Radio Button, a
                                                         * Check-
                                                         *      box button or neither, but not more than one at the same
                                                         *      time.  A Check-box button group is a group of buttons
                                                         * where
                                                         *      each button in the group can be either ON or OFF in any
                                                         *      combination.  In this way, more than one button in the
                                                         *      group can be clicked at the same time.  See the
                                                         * TEMPLATES
                                                         *      section later on in this document for a complete
                                                         * discussion
                                                         *      of how the Host Commands are processed for Check-Box
                                                         * buttons.
                                                         *      If a check-box button is drawn as "pre-selected", then
                                                         * the
                                                         *      Host Command is processed immediately upon inital
                                                         * drawing of
                                                         *      the button (when it is received).
                                                         *
                                                         *      HIGHLIGHT HOTKEY CHARACTER (flag 2) - When this flag is
                                                         *      active, then the first occurence of the hotkey character
                                                         *      in the label will be hilighted using the <uline_col>
                                                         * color.
                                                         *      This gives the user a visual impression of what
                                                         * keystroke
                                                         *      they need to type in order to activate the button
                                                         * without
                                                         *      the mouse.
                                                         *
                                                         *      EXPLODE (ZOOM OUT WHEN CLICKED) (flag 4) - This optional
                                                         *      flag is designed to "zoom out" from the button when the
                                                         *      user clicks on it.  What is generally done is a dotted
                                                         *      rectangle is drawn initially around the button and it is
                                                         *      repeatedly redrawn over itself in XOR mode, constantly
                                                         *      getting larger and larger until it hits the full size of
                                                         *      the screen.  This gives the visual impression that the
                                                         *      button is zooming out to another screen.  Each time
                                                         * another
                                                         *      frame of the zooming rectangle is drawn, the previous
                                                         *      rectangle on the inside of the new one is erased by XOR
                                                         *      drawing the same rectangle over itself again.  This
                                                         * option
                                                         *      does not need to be supported in order to be considered
                                                         *      a RIPscrip terminal, although it would be nice.  In
                                                         *      other words, this is not a "make or break" feature.
                                                         *
                                                         *      LEFT JUSTIFY LABEL (TOP/CTR/BTM) (flag 8) - If this
                                                         * option
                                                         *      is enabled, then any TOP, CENTER or BOTTOM label
                                                         * orientations
                                                         *      will be left justified to the left edge of the button.
                                                         *  The
                                                         *      exact indentation of the label from the interior of the
                                                         *      button's base image depends on whether the chisel effect
                                                         *      is active.  If chisel is OFF, then the indentation is 10
                                                         *      pixel.  If chisel is ON, then the indentation is 20
                                                         * pixels.
                                                         *      This option can be combined with the Adjust Vertical
                                                         * Centering
                                                         *      flag only if the label orientation is CENTER.
                                                         *
                                                         *      RIGHT JUSTIFY LABEL (TOP/CTR/BTM) (flag 16) - If this
                                                         * option
                                                         *      is enabled, then any TOP, CENTER or BOTTOM label
                                                         * orientations
                                                         *      will be right justified to the right edge of the button.
                                                         *  The
                                                         *      exact indentation of the label from the interior of the
                                                         *      button's base image depends on whether the chisel effect
                                                         *      is active.  If chisel is OFF, then the indentation is 10
                                                         *      pixel.  If chisel is ON, then the indentation is 20
                                                         * pixels.
                                                         *      This option can be combined with the Adjust Vertical
                                                         * Centering
                                                         *      flag only if the label orientation is CENTER.
                                                         */
							handled = true;
							int              argv[15];
							static const int argslen[] = {
								2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6
							};
							int              i;
							int              off;
							for (i = 0, off = 0; i < sizeof(argv) / sizeof(argv[0]); i++) {
								argv[i] = parse_mega(&args[off], argslen[i]);
								off += argslen[i];
								if (argv[i] < 0)
									break;
							}
							if (i < sizeof(argv) / sizeof(argv[0]))
								break;
							if ((argv[2] < 0) || (argv[2] > LABEL_LOC_BELOW)) // Orient
								break;
							arg1 = argv[3]
							    & (BUTTON_FLAG1_CLIPBOARD | BUTTON_FLAG1_ICON
							    | BUTTON_FLAG1_PLAIN); // Flags
							if (arg1 & (arg1 - 1))
								break;
							if (argv[5] > 255)         // dfore
								break;
							if (argv[6] > 255)         // back
								break;
							if (argv[7] > 255)         // bright
								break;
							if (argv[8] > 255)         // dark
								break;
							if (argv[9] > 255)         // surface
								break;
							if (argv[10] > 255)        // group_no
								break;
							if (argv[12] > 255)        // uline_col
								break;
							if (argv[13] > 255)        // corner_col
								break;
							rip.bstyle.width = argv[0];
							rip.bstyle.height = argv[1];
							rip.bstyle.label_location = argv[2];
							if (argv[3] & BUTTON_FLAG1_CLIPBOARD)
								rip.bstyle.button = BUTTON_TYPE_CLIPBOARD;
							else if (argv[3] & BUTTON_FLAG1_ICON)
								rip.bstyle.button = BUTTON_TYPE_ICON;
							else if (argv[3] & BUTTON_FLAG1_PLAIN)
								rip.bstyle.button = BUTTON_TYPE_PLAIN;
							rip.bstyle.bevel_size = argv[4];
							rip.bstyle.cfore = argv[5];
							rip.bstyle.cdshadow = argv[6];
							rip.bstyle.chighlight = argv[7];
							rip.bstyle.cshadow = argv[8];
							rip.bstyle.csurface = argv[9];
							rip.bstyle.group = argv[10];
							rip.bstyle.culine = argv[12];
							rip.bstyle.ccorner = argv[13];
							rip.bstyle.flags.invertable =
							    (argv[3] & BUTTON_FLAG1_INVERTABLE);
							rip.bstyle.flags.resetafter =
							    (argv[3] & BUTTON_FLAG1_RESETAFTER);
							rip.bstyle.flags.chisel = (argv[3] & BUTTON_FLAG1_CHISEL);
							rip.bstyle.flags.recessed = (argv[3] & BUTTON_FLAG1_RECESSED);
							rip.bstyle.flags.dropshadow =
							    (argv[3] & BUTTON_FLAG1_DROPSHADOW);
							rip.bstyle.flags.autostamp = (argv[3] & BUTTON_FLAG1_AUTOSTAMP);
							rip.bstyle.flags.bevel = (argv[3] & BUTTON_FLAG1_BEVEL);
							rip.bstyle.flags.mouse = (argv[3] & BUTTON_FLAG1_MOUSE);
							rip.bstyle.flags.underlinehk =
							    (argv[3] & BUTTON_FLAG1_UNDERLINEHK);
							rip.bstyle.flags.hot = (argv[3] & BUTTON_FLAG1_HOT);
							rip.bstyle.flags.vadjust = (argv[3] & BUTTON_FLAG1_VADJUST);
							rip.bstyle.flags.radiogroup =
							    (argv[3] & BUTTON_FLAG1_RADIOGROUP);
							rip.bstyle.flags.sunken = (argv[3] & BUTTON_FLAG1_SUNKEN);
							rip.bstyle.flags.cbgroup = (argv[11] & BUTTON_FLAG2_CBGROUP);
							rip.bstyle.flags.highlighthk =
							    (argv[11] & BUTTON_FLAG2_HIGHLIGHTHK);
							rip.bstyle.flags.explode = (argv[11] & BUTTON_FLAG2_EXPLODE);
							rip.bstyle.flags.left_justify =
							    (argv[11] & BUTTON_FLAG2_LEFT_JUSTIFY);
							rip.bstyle.flags.right_justify =
							    (argv[11] & BUTTON_FLAG2_RIGHT_JUSTIFY);
							break;
						case 'C': // RIP_GET_IMAGE !|1C <x0> <y0> <x1> <y1> <res>
                                                        /* This command instructs the terminal program to copy the
                                                         * rectangular
                                                         * region defined by (x0,y0) to (x1,y1) onto an internal
                                                         * Clipboard for
                                                         * future use.  This combined with the Paste Clipboard command
                                                         * can
                                                         * provide an extremely powerful and efficient mechanism to
                                                         * avoid
                                                         * baud-rate bandwidth limitations.  The (x0,y0) parameter MUST
                                                         * specify
                                                         * the upper-left corner of the region and the (x1,y1) parameter
                                                         * MUST
                                                         * specify the lower-right corner.  If the indicated coordinates
                                                         * are in
                                                         * anyway invalid, the command is ignored.  The Clipboard is
                                                         * completely
                                                         * overwritten by this command (the previous contents are lost).
                                                         *
                                                         * NOTE:  The <res> parameter isRESERVED FOR FUTURE USE and
                                                         *        should be set to zero.
                                                         */
							handled = true;
							struct text_info ti;
							GET_XY2();
							freepixels(rip.clipboard);
							gettextinfo(&ti);
							rip.clipboard = getpixels(x1 + rip.viewport.sx,
							        y1 + rip.viewport.sy,
							        x2 + rip.viewport.sx,
							        y2 + rip.viewport.sy,
							        false);
							rip.clipx = x1 + rip.viewport.sx;
							rip.clipy = y1 + rip.viewport.sy;
							break;
						case 'D': // RIP_DEFINE !|1D <flags> <res> <text>
                                                        /* This command is used to create a text variable on the Client
                                                         * system
                                                         * (i.e., the Terminal system).  A text variable is more fully
                                                         * covered
                                                         * in the HOST COMMANDS section.  Simply put, a text variable is
                                                         * a piece
                                                         * of information assigned to a 1-12 character identifier that
                                                         * can
                                                         * either be saved to a local database file (static variables),
                                                         * or to
                                                         * memory (dynamic variables).  Variable Identifiers can be 1-12
                                                         * characters in length.  You may use any alphanumeric character
                                                         * and
                                                         * underscores (_) in the identifier.  An underscore cannot be
                                                         * the first
                                                         * character, nor can the first character of an identifier be a
                                                         * number.
                                                         *
                                                         * The <flags> parameter of this command combines three separate
                                                         * values
                                                         * into one MegaNum flag that determines how the variable
                                                         * definition
                                                         * will operate.  Here are the possible flag values:
                                                         *
                                                         *         Value     Description of Flag
                                                         *         ---------------------------------------
                                                         *         001     Save Variable to database
                                                         *         002     Cannot specify a blank response
                                                         *         004     Non-interactive query
                                                         *
                                                         * When a variable is flagged as "Save to Database", it becomes
                                                         * a part
                                                         * of the Client system's actual configuration.  The value is
                                                         * saved
                                                         * indefinitely until either changed, or manually erased.  You
                                                         * may
                                                         * choose not to allow the user to enter a blank response.  This
                                                         * basically requires them to enter some piece of information
                                                         * for the
                                                         * variable.
                                                         *
                                                         * The last flag determines whether the definition is
                                                         * interactive or not.
                                                         * An interactive definition will attempt to define the
                                                         * variable.  If it
                                                         * does exist, it pops the value up on the screen asking the
                                                         * user to
                                                         * confirm if the value is correct.  If it does not exist, a
                                                         * similar
                                                         * pop-up box will appear asking the user to enter some data for
                                                         * the
                                                         * given variable.
                                                         *
                                                         * In a non-interactive situation, the Client system will check
                                                         * to see
                                                         * if the variable exists.  If it does, then nothing happens
                                                         * (unless a
                                                         * default response is specified in this command, whereby the
                                                         * Client's
                                                         * variable is updated with the new information).  If the value
                                                         * is not
                                                         * defined, then this definition becomes interactive by default,
                                                         * since
                                                         * the user actually has to enter something anyway.
                                                         *
                                                         * The <text> parameter for this command is also segmented in
                                                         * nature,
                                                         * much like the RIP_BUTTON command is.  An example of a
                                                         * segmented
                                                         * <text> parameter for the RIP_DEFINE command might be as
                                                         * follows:
                                                         *
                                                         *           FULL_NAME,30:?What is your full name?John Doe
                                                         *
                                                         * The actual syntax of the Variable Define text parameter is as
                                                         * follows:
                                                         *
                                                         *
                                                         * 
                                                         * variable-identifier[,field-width]:[?question-text?][default-value]
                                                         *
                                                         * There are several different segments in this parameter as you
                                                         * can
                                                         * see.  The first section is the variable- identifier.
                                                         *  Immediately
                                                         * after it is an optional field-width.  If the field width is
                                                         * omitted,
                                                         * it will default to a value of  60.  You should limit the
                                                         * values of
                                                         * this width from 1-60.
                                                         *
                                                         * Immediately following the identifier field-width parameter is
                                                         * a colon
                                                         * (:).  The colon indicates that the variable identifier field
                                                         * is
                                                         * completed and that the remainder of the text parameter is to
                                                         * contain
                                                         * the question and/or the default response (if any).  If no
                                                         * question or
                                                         * default response is provided, the text parameter would read
                                                         * "TEXT_VAR,width:" with no additional data.
                                                         *
                                                         * The question-text is specified by a question mark (?)
                                                         * followed by the
                                                         * actual text of the question, followed by a trailing question
                                                         * mark.
                                                         * The basic format of the question segment is as follows:
                                                         *
                                                         *                     ?this is a question?
                                                         *
                                                         * The remainder of the text parameter consists of a
                                                         * default-value for
                                                         * the variable's contents.  It may be omitted if you wish, to
                                                         * make it
                                                         * so that the user must enter his/her own value instead of some
                                                         * "canned
                                                         * response".
                                                         *
                                                         * NOTE:  The <res> parameter is reserved for future use by
                                                         * TeleGrafix
                                                         *        Communications, Inc..  It should be set to 00 for
                                                         *        compatibility with future releases.
                                                         */
							break;
						case 'E': // RIP_END_TEXT !|1E
                                                          // TODO: Pointless end text area thing.

                                                        /* This command indicates the end of a formatted text block.
                                                         *  Only one
                                                         * of these "end" commands is necessary for each block.
                                                         */
							break;
						case 'F': // RIP_FILE_QUERY !|1F <mode> <res> <filename>
                                                        /* This command queries the existence of a particular file,
                                                         * regardless
                                                         * of type.  It is intended for host systems to determine if a
                                                         * particular Icon or RIP file exists on the terminal;s hard
                                                         * disk.
                                                         *
                                                         * There are a variety of ways you can query for filenames.  The
                                                         * <mode>
                                                         * parameter determines the command's response.  This command
                                                         * instructs
                                                         * the terminal to send a response to the host immediately upon
                                                         * execution.
                                                         *
                                                         * The following table is a listing of the possible values for
                                                         * <mode>:
                                                         *
                                                         * Mode  Description
                                                         * ----------------------------------------------------------------------
                                                         *  00   Simply query the existence of the file.  If it exists,
                                                         * a "1" is
                                                         *       returned.  Otherwise a "0" is returned to the Host
                                                         * (without a
                                                         *       carriage return).
                                                         *  01   Same as 0, except a carriage return is added after the
                                                         * response.
                                                         *  02   Queries the existence of a file.  If it does not exist,
                                                         * a "0" is
                                                         *       returned to the Host followed by a carriage return.  If
                                                         * it does
                                                         *       exist, the returned text is a "1." followed by the file
                                                         * size (in
                                                         *       decimal).  The return sequence is terminated by a
                                                         * carriage
                                                         *       return.  An example of the returned text could be
                                                         * "1.20345".
                                                         *  03   Queries extended return information.  If the file does
                                                         * not
                                                         *       exist, a "0" is returned followed by a carriage return.
                                                         *  If it
                                                         *       does exist, the text returned to the Host is in the
                                                         * Format:
                                                         *       1.size.date.time <cr>.  An example of a return
                                                         * statement could
                                                         *       be "1.20345.01/02/93.03:04:30<cr>"
                                                         *  04   Queries extended return information.  If the file does
                                                         * not
                                                         *       exist, a "0" is returned followed by a carriage return.
                                                         *  If it
                                                         *       does exist, the text returned to the Host is in the
                                                         * Format:
                                                         *       1.filename.size.date.time <cr>. An example of a return
                                                         * statement
                                                         *       could be "1.MYFILE.RIP.20345.01/02/93.03:04:30 <cr>".
                                                         *  Note that
                                                         *       the file extension adds another period into the return
                                                         * text.
                                                         */
							handled = true;
							arg1 = parse_mega(&args[0], 2);
							if ((arg1 < 0) || (arg1 > 4))
								break;
							if (strstr(&args[6], ".."))
								break;
							if (strchr(&args[6], '/'))
								break;
							if (strchr(&args[6], '\\'))
								break;
							if (!get_cache_fn_subdir(rip.bbs, cache_path,
							    sizeof(cache_path), "RIP"))
								break;
							strcat(cache_path, &args[6]);
							fexistcase(cache_path);
							struct stat st;
							char        str[1024];
							char        dstr[64];
							struct tm   tm;
							switch (arg1) {
								case 0:
									if (access(cache_path, R_OK))
										conn_send("0", 1, 1000);
									else
										conn_send("1", 1, 1000);
									break;
								case 1:
									if (access(cache_path, R_OK))
										conn_send("0\r\n", 2, 1000);
									else
										conn_send("1\r\n", 2, 1000);
									break;
								case 2:
									if (stat(cache_path, &st)) {
										conn_send("0\r\n", 2, 1000);
									}
									else {
										sprintf(str,
										    "1.%" PRIdOFF "\r\n",
										    st.st_size);
										conn_send(str, strlen(str), 1000);
									}
									break;
								case 3:
									if (stat(cache_path, &st)) {
										conn_send("0\r\n", 2, 1000);
									}
									else {
										localtime_r(&st.st_mtime, &tm);
										strftime(dstr,
										    sizeof(dstr),
										    "%m/%d/%y.%H:%M:%S",
										    &tm);
										sprintf(str,
										    "1.%" PRIdOFF ".%s\r\n",
										    st.st_size,
										    dstr);
										conn_send(str, strlen(str), 1000);
									}
									break;
								case 4:
									if (stat(cache_path, &st)) {
										conn_send("0\r\n", 2, 1000);
									}
									else {
										localtime_r(&st.st_mtime, &tm);
										strftime(dstr,
										    sizeof(dstr),
										    "%m/%d/%y.%H:%M:%S",
										    &tm);
										sprintf(str,
										    "1.%s.%" PRIdOFF ".%s\r\n",
										    &args[6],
										    st.st_size,
										    dstr);
										conn_send(str, strlen(str), 1000);
									}
									break;
							}
							break;
						case 'G': // RIP_COPY_REGION !|1G <x0> <y0> <x1> <y1> <res> <dest_line>
                                                        /* This command physically "copies" a rectangular region of the
                                                         * graphics
                                                         * screen up or down.  The <dest_line> parameter is the Y
                                                         * position that
                                                         * is the destination scan line to receive the region.  The
                                                         * Destination
                                                         * of the copy can overlap the original region, but cannot be on
                                                         * the
                                                         * same line.  You cannot move the image area left or right at
                                                         * all.  This
                                                         * command is designated for vertical scrolling of graphical
                                                         * data either
                                                         * up or down.
                                                         *
                                                         * Due to hardware restrictions, the X0 and X1 parameters must
                                                         * be evenly
                                                         * divisible by eight (8) (e.g., 0, 8, 16, etc.).  If the X0 and
                                                         * X1
                                                         * parameters are NOT evenly divisible by eight, then the X0
                                                         * parameter
                                                         * will be reduced to the next most eight-pixel boundary, and
                                                         * the X1
                                                         * parameter will be increased to the next eight-pixel boundary.
                                                         *  For
                                                         * example, if X0=14, and X1=38, then X0 would be adjusted DOWN
                                                         * to 8,
                                                         * and X1 would be adjusted UP to 40.  This is to ensure that
                                                         * the
                                                         * desired graphical region is scrolled.
                                                         *
                                                         * The original image area is left on the screen (is not
                                                         * cleared).  So if
                                                         * you wish to perform some kind of scrolling effect, you will
                                                         * have to
                                                         * clear the original area yourself.
                                                         *
                                                         * If the destination region would place the image partially
                                                         * off-screen,
                                                         * then the entire command is ignored!
                                                         *
                                                         * This is one of the only graphical output commands that DOES
                                                         * NOT       > v1.54
                                                         * adhere to the RIP_VIEWPORT command.  In other words, you can
                                                         * scroll   > v1.54
                                                         * graphical data outside the current graphical viewport (even
                                                         * over the  > v1.54
                                                         * text window!).
                                                         *                                                        >
                                                         * v1.54
                                                         *
                                                         * NOTE:  The <res> parameter is reserved for future development
                                                         * by
                                                         * TeleGrafix.
                                                         */
							break;
						case 'I': // RIP_LOAD_ICON !|1I <x> <y> <mode> <clipboard> <res>
                                                          // <filename>

                                                        /* This command instructs the terminal to read an Icon from disk
                                                         * and
                                                         * display it at the given upper-left (x,y) location.  If the
                                                         * width or
                                                         * height of the Icon would make it go off the right or left
                                                         * edge of the
                                                         * screen, the Icon will not be displayed.  The <mode> parameter
                                                         * defines
                                                         * the modes in which the Icon will be displayed on the screen.
                                                         *  The
                                                         * modes are identical to the RIP_PUT_IMAGE command, and are as
                                                         * follows:
                                                         *
                                                         * The .ICN file extension does not need to be included as part
                                                         * of the
                                                         * filename.  If omitted, it will automatically be appended to
                                                         * the
                                                         * filename.  If an extension is provided, it will be used
                                                         * verbatim.
                                                         *
                                                         *   Mode   Description
                                                         *                                         Logical
                                                         *
                                                         * 
                                                         * ------------------------------------------------------------------
                                                         *    00    Paste the image on-screen normally
                                                         *                   (COPY)
                                                         *    01    Exclusive-OR  image with the one already on screen
                                                         *   (XOR)
                                                         *    02    Logically OR  image with the one already on screen
                                                         *   (OR)
                                                         *    03    Logically AND image with the one already on screen
                                                         *   (AND)
                                                         *    04    Paste the inverse of the image on the screen
                                                         *         (NOT)
                                                         *
                                                         * If the <clipboard> parameter is 1, then the image pasted on
                                                         * screen
                                                         * AND also copied onto the Clipboard.  If 0, it is simply
                                                         * pasted on the
                                                         * screen.
                                                         *
                                                         * The <filename> parameter must not contain any sub-directory
                                                         * or path
                                                         * information and must specify a valid Icon file name.  If the
                                                         * Icon
                                                         * cannot be located or an error occurs on the disk, then a box
                                                         * should
                                                         * be displayed on screen indicating that the given Icon File
                                                         * could not
                                                         * be loaded.  This visual prompt indicates that something is
                                                         * amiss to
                                                         * the end-user.
                                                         *
                                                         * NOTE:  The 2-byte <res> parameter is RESERVED FOR THE FUTURE
                                                         *        and unlike many other previously mentioned reserved
                                                         *        parameters, should be set to "10".
                                                         */
							handled = true;
							if (!get_cache_fn_subdir(rip.bbs, cache_path,
							    sizeof(cache_path), "RIP"))
								break;
							GET_XY();
							arg1 = parse_mega(&args[4], 2);
							arg2 = parse_mega(&args[6], 1);
							if (arg1 != 0) {
								printf("TODO: Support paste mode %d\n", arg1);
								break;
							}
							strcat(cache_path, &args[9]);
							if (strchr(&args[9], '.') == NULL)
								strcat(cache_path, ".ICN");
							fexistcase(cache_path);
							icn = fopen(cache_path, "rb");
							if (icn != NULL) {
								struct ciolib_pixels *pix =
								    malloc(sizeof(struct ciolib_pixels));
								uint16_t              tmp;
								if (fread(&tmp, sizeof(tmp), 1, icn) != 1) {
									free(pix);
									fclose(icn);
									break;
								}
								pix->width = tmp + 1;
								if (pix->width < 1)
									pix->width = 1;
								if (pix->width > 65536)
									pix->width = 65536;
								if (fread(&tmp, sizeof(tmp), 1, icn) != 1) {
									free(pix);
									fclose(icn);
									break;
								}
								pix->height = tmp + 1;
								if (pix->height < 1)
									pix->height = 1;
								if (pix->height > 65536)
									pix->height = 65536;
								if ((x1 + rip.viewport.sx + pix->width - 1
								    > rip.viewport.ex)
								    || (y1 + rip.viewport.sy + pix->height - 1
								    > rip.viewport.ey)) {
									free(pix);
									fclose(icn);
									break;
								}
								pix->pixels =
								    malloc(pix->width * pix->height
								        * sizeof(*pix->pixels));
								pix->pixelsb = NULL;
								if (pix->pixels == NULL) {
									free(pix);
									fclose(icn);
									break;
								}
								size_t   row = pix->width / 8
								    + (pix->width & 7 ? 1 : 0);
								uint8_t *planes = malloc(4 * row);
								if (planes == NULL) {
									free(pix->pixels);
									free(pix);
									fclose(icn);
									break;
								}
								int       i, j, co;
								uint32_t *op = pix->pixels;
								for (i = 0; i < pix->height; i++) {
									if (fread(planes, row, 4, icn) != 4) {
										free(planes);
										free(pix->pixels);
										FREE_AND_NULL(pix);
										fclose(icn);
										break;
									}
									for (j = 0; j < pix->width; j++) {
										co =
										    (((planes[(row * 3) + (j / 8)]
										    >> (7 - (j & 7))) & 1) << 0);
										co |=
										    (((planes[(row * 2) + (j / 8)]
										    >> (7 - (j & 7))) & 1) << 1);
										co |=
										    (((planes[(row * 1) + (j / 8)]
										    >> (7 - (j & 7))) & 1) << 2);
										co |=
										    (((planes[(row * 0) + (j / 8)]
										    >> (7 - (j & 7))) & 1) << 3);
										*(op++) = map_rip_color(co);
									}
								}
								if (pix) {
									fclose(icn);
									free(planes);

									struct text_info ti;
									gettextinfo(&ti);
									setpixels(x1 + rip.viewport.sx,
									    y1 + rip.viewport.sy,
									    x1 + rip.viewport.sx + pix->width - 1,
									    y1 + rip.viewport.sy + pix->height - 1,
									    0,
									    0, 0, 0,
									    pix,
									    NULL);
									if (arg2) {
										freepixels(rip.clipboard);
										rip.clipboard = pix;
									}
									else {
										freepixels(pix);
									}
								}
							}
							break;
						case 'K': // RIP_KILL_MOUSE_FIELDS !|1K
                                                        /*
                                                         * This command will "forget" all Mouse Regions.  Use it at the
                                                         * beginning
                                                         * of each Scene, so that one scene's Mouse Regions don't get
                                                         * used in
                                                         * another.
                                                         */
							handled = true;
							kill_mouse_fields();
							break;
						case 'M': // RIP_MOUSE !|1M <num> <x0><y0><x1><y1> <clk><clr><res><text>
                                                        /* This command ties together three things:
                                                         *
                                                         *      A region on the screen
                                                         *      A mouse-click event
                                                         *      A string of text to be transmitted by the terminal.
                                                         *
                                                         * This command defines a rectangular region on the screen that
                                                         * functions
                                                         * as a "hot" mouse area.  If the user clicks the [left] mouse
                                                         * button
                                                         * while pointing inside the region, then the terminal must
                                                         * transmit the
                                                         * <text> string to the Host.  The (x0,y0) parameter MUST be the
                                                         * upper-left corner, and (x1,y1) MUST be the lower-right corner
                                                         * of the
                                                         * region.
                                                         *
                                                         * The <num> parameter used to be used in the older RIPscrip
                                                         * v1.0
                                                         * specification but is now obsolete.  For upwards
                                                         * compatibility, it
                                                         * should be set to "00".
                                                         *
                                                         * The <clk> parameter, if 1, indicates that the region should
                                                         * be
                                                         * visibly inverted while the mouse button is down.  This offers
                                                         * visual
                                                         * feedback. If <clk> is 0, the region will not be inverted
                                                         * while
                                                         * clicked.
                                                         *
                                                         * The <clr> parameter, if 1, will physically zoom the text
                                                         * window to
                                                         * full screen size and clear the screen.  This is useful if the
                                                         * <text>
                                                         * parameter instructs the host to enter an area of the System
                                                         * that
                                                         * doesn't support RIPscrip graphics.
                                                         *
                                                         * The <text> parameter is a Host command that gets sent when
                                                         * the field
                                                         * is clicked.  You may use a caret (^) to represent control
                                                         * characters,
                                                         * (e.g., ^M for carriage return, ^G, ^C, etc.).
                                                         *
                                                         * When this command is stored in-memory, it is converted to
                                                         * global
                                                         * screen coordinates (for internal storage only).  This makes
                                                         * it so
                                                         * that if you have mouse regions defined in multiple different
                                                         * viewports, that each field will be properly inverted at the
                                                         * right
                                                         * location regardless of the currently defined viewport.
                                                         *
                                                         * NOTE: All Mouse Fields are scanned in "last in, first out"
                                                         * order.
                                                         *       This means that the last-most received Mouse Field will
                                                         * be
                                                         *       the first one scanned for a mouse click.
                                                         *
                                                         * NOTE:  You are limited to a maximum of 128 Mouse Regions or
                                                         *        Mouse Buttons (128 total).
                                                         *
                                                         *        In addition, the 5-byte <res> parameter is RESERVED
                                                         * FOR
                                                         *        FUTURE USE, and should be set to zeros (00000).
                                                         */
							handled = true;
							x1 = parse_mega(&args[2], 2);
							if (x1 < 0)
								break;
							y1 = parse_mega(&args[4], 2);
							if (y1 < 0)
								break;
							x2 = parse_mega(&args[6], 2);
							if (x2 < 0)
								break;
							if (x2 > rip.viewport.ex - rip.viewport.sx)
								break;
							y2 = parse_mega(&args[8], 2);
							if (y2 < 0)
								break;
							if (y2 > rip.viewport.ey - rip.viewport.sy)
								break;
							arg1 = parse_mega(&args[10], 1);
							if ((arg1 < 0) || (arg1 > 1))
								break;
							arg2 = parse_mega(&args[11], 1);
							if ((arg2 < 0) || (arg2 > 1))
								break;
							struct mouse_field *mf = malloc(sizeof(struct mouse_field));
							if (mf) {
								mf->data.hot = malloc(sizeof(struct hot_mouse));
								if (mf->data.hot == NULL) {
									free(mf);
									break;
								}
								mf->type = MOUSE_FIELD_HOT;
								mf->data.hot->box.x1 = x1 + rip.viewport.sx;
								mf->data.hot->box.x2 = x2 + rip.viewport.sx;
								mf->data.hot->box.y1 = y1 + rip.viewport.sy;
								mf->data.hot->box.y2 = y2 + rip.viewport.sx;
								mf->data.hot->invertable = arg1;
								mf->data.hot->resetafter = arg2;
								mf->data.hot->command = strdup(&args[17]);
								mf->next = rip.mfields;
								rip.mfields = mf;
							}
							break;
						case 'P': // RIP_PUT_IMAGE !|1P <x> <y> <mode> <res>
                                                        /* This command takes the contents of the Clipboard (if any) and
                                                         * pastes
                                                         * the image onto the screen starting at the upper-left corner
                                                         * of the
                                                         * image of (x,y).  If the right edge of the image would go
                                                         * off-screen,
                                                         * the paste command is ignored.  The Height and Width of the
                                                         * clipboard
                                                         * image is recorded on the Clipboard, so this command doesn't
                                                         * need to
                                                         * supply it.
                                                         *
                                                         * The <mode> parameter defines "how" the image will be pasted
                                                         * on the
                                                         * screen:
                                                         *
                                                         *   Mode   Description
                                                         *                                          Logical
                                                         *
                                                         * 
                                                         * -------------------------------------------------------------------
                                                         *    00    Paste the image on-screen normally
                                                         *                   (COPY)
                                                         *    01    Exclusive-OR  image with the one already on screen
                                                         *   (XOR)
                                                         *    02    Logically OR  image with the one already on screen
                                                         *   (OR)
                                                         *    03    Logically AND image with the one already on screen
                                                         *   (AND)
                                                         *    04    Paste the inverse of the image on the screen
                                                         *         (NOT)
                                                         *
                                                         * NOTE:  The 1-byte <res> parameter is RESERVED FOR FUTURE USE
                                                         *        and should be set to zero.
                                                         */
							handled = true;
							GET_XY();
							arg1 = parse_mega(&args[4], 2);
							if ((arg1 < 0) || (arg1 > 4)) {
								printf("TODO: Put Image type %d\n", arg1);
								break;
							}
							if (rip.clipboard) {
								struct text_info ti;
								gettextinfo(&ti);

								int              bline = y1 + rip.viewport.sy
								    + rip.clipboard->height - 1;
								assert_rwlock_rdlock(&vstatlock);
								if (bline >= vstat.scrnheight)
									bline = vstat.scrnheight - 1;
								assert_rwlock_unlock(&vstatlock);
								if (x1 + rip.viewport.sx + rip.clipboard->width - 1
								    > rip.viewport.ex)
									break;
								switch (arg1) {
									case 0: // Normal (easy!)
										arg2 = y1 + rip.viewport.sy
										    + rip.clipboard->height - 1;
										setpixels(x1 + rip.viewport.sx,
										    y1 + rip.viewport.sy,
										    x1 + rip.viewport.sx + rip.clipboard->width - 1,
										    bline,
										    0,
										    0, 0, 0,
										    rip.clipboard,
										    NULL);
										break;
									case 1: // XOR
									case 2: // OR
									case 3: // AND
									case 4: // NOT
									{
										struct ciolib_pixels *pix = getpixels(
											x1 + rip.viewport.sx,
											y1 + rip.viewport.sy,
											x1 + rip.viewport.sx + rip.clipboard->width - 1,
											bline,
											false);

										if (pix == NULL)
											break;
										for (y = 0; y < rip.clipboard->height;
										    y++) {
											if (rip.viewport.sy + y1 + y
											    > bline)
												break;
											for (x = 0;
											    x < rip.clipboard->width;
											    x++) {
												arg3 = pixel2color(rip.clipboard->pixels[
														y
														* rip.
														clipboard
														->width
														+ x]);

												switch (arg1) {
													case 1:
														arg2 =
														    pixel2color(pix->pixels[
																y
																*
																pix
																->
																width
																+
																x]);
														arg3 ^=
														    arg2;
														break;
													case 2:
														arg2 =
														    pixel2color(pix->pixels[
																y
																*
																pix
																->
																width
																+
																x]);
														arg3 |=
														    arg2;
														break;
													case 3:
														arg2 =
														    pixel2color(pix->pixels[
																y
																*
																pix
																->
																width
																+
																x]);
														arg3 &=
														    arg2;
														break;
													case 4:
														arg3 =
														    (~
														    arg3);
														arg3 &=
														    0x0F;
														break;
												}
												rip_setpixel(
													rip.viewport.sx + x1 + x,
													rip.viewport.sy + y1 + y,
													arg3);
											}
										}
										freepixels(pix);
										break;
									}
								}
							}
							break;
						case 'R': // RIP_READ_SCENE !|1R <res> <filename>
                                                        /* This command instructs the remote terminal to playback a
                                                         * local .RIP
                                                         * file.  The current execution of RIPscrip commands will be
                                                         * temporarily
                                                         * suspended and the contents of the designated RIP file will
                                                         * begin
                                                         * executing.  Regardless of whether or not the current RIPscrip
                                                         * code
                                                         * coming across the modem is in the middle of a line or not,
                                                         * the RIP
                                                         * playback file will be assumed to start at the beginning of a
                                                         * line.
                                                         * Therefore, if a RIP_READ_SCENE command is located in a .RIP
                                                         * file, it
                                                         * must be the very last command on the line, followed by a
                                                         * carriage
                                                         * return instead of a command delimiter (|).  This ensures that
                                                         * the
                                                         * loaded .RIP file will begin executing properly with the
                                                         * correct
                                                         * delimiters found in the correct places.
                                                         *
                                                         * The RIP playback file can alter colors, fonts, or whatever.
                                                         *  Once the
                                                         * playback of the file is complete, the remaining RIPscrip code
                                                         * that
                                                         * was temporarily suspended will be resume execution.  Any
                                                         * changes that
                                                         * appeared in the loaded playback file will remain in effect
                                                         * when the
                                                         * resumed code is processed.  In other words, if you change a
                                                         * color or
                                                         * a font in the playback file and leave them changed, they will
                                                         * remain
                                                         * in effect during the resumed execution.
                                                         *
                                                         * NOTE:  The <res> parameter is reserved for future development
                                                         * by
                                                         *        TeleGrafix.  It should be set to "00000000" for
                                                         * compatibility
                                                         *        with future releases.
                                                         */
							break;
						case 'T': // RIP_BEGIN_TEXT !|1T <x1> <y1> <x2> <y2> <res>
                                                        /* This command defines a rectangular portion of the graphics
                                                         * viewport
                                                         * that is to display text, usually a long stream of text.
                                                         *  Following
                                                         * this command should be a number of RIP_REGION_TEXT commands
                                                         * with the
                                                         * text to be displayed.  The RIP_END_TEXT terminates this
                                                         * stream of
                                                         * text, something like this:
                                                         *
                                                         * RIP_BEGIN_TEXT
                                                         *      RIP_REGION_TEXT
                                                         *      RIP_REGION_TEXT
                                                         *      RIP_REGION_TEXT
                                                         *      :
                                                         *      RIP_REGION_TEXT
                                                         * RIP_END_TEXT
                                                         *
                                                         * There must be at least one RIP_REGION_TEXT command in between
                                                         * the
                                                         * header and the footer.  There may be as many as needed.
                                                         *
                                                         * These commands ignore the current font "direction"; all text
                                                         * is
                                                         * always displayed horizontally.
                                                         *
                                                         * NOTE:  The "res" parameter is two bytes wide and is RESERVED
                                                         * for
                                                         *        future use.
                                                         */
							handled = true;
							GET_XY2();
							rip.text_region.sx = x1;
							rip.text_region.sy = y1;
							rip.text_region.ex = x2;
							rip.text_region.ey = y2;
							rip.text_region.xpos = 0;
							rip.text_region.ypos = 0;
							break;
						case 't': // RIP_REGION_TEXT !|1t <justify> <text-string>
                                                          /* A number of these commands may come sandwiched between the
                                                           * RIP_BEGIN_TEXT and RIP_END_TEXT commands.  The
                                                           * <text-string>
                                                           * is
                                                           * already word-wrapped in such a way that it will fit inside
                                                           * the
                                                           * rectangular region based on the current font, font size,
                                                           * and
                                                           * drawing
                                                           * color.
                                                           *
                                                           * There are two possible settings for the <justify>
                                                           * parameter:
                                                           *
                                                           *   Justify   Description
                                                           *
                                                           * 
                                                           * ------------------------------------------------------------------
                                                           *     0       Don't right/left justify.  Left-justify only
                                                           *     1       Perform right/left margin justification of this
                                                           * line of
                                                           *             text.
                                                           *
                                                           * If a text line falls off the bottom of the region, it is
                                                           * discarded --
                                                           * the rectangular Text Region does not scroll.
                                                           *
                                                           * This command is intended to import some sort of text file
                                                           * document
                                                           * directly into a RIPscrip scene and format it nicely to fit
                                                           * inside a
                                                           * simple rectangular area.  If the <justify> parameter is set
                                                           * to a
                                                           * value of "1" for a given RIP_REGION_TEXT line, then that
                                                           * line
                                                           * will be
                                                           * justified to both the left and right margins (the
                                                           * RIP_BEGIN_TEXT
                                                           * boundaries).  This is so that the displayed text aligns on
                                                           * both sides
                                                           * with the invisible boundaries.  This "justification" is
                                                           * done
                                                           * by
                                                           * splitting each RIP_REGION_TEXT line up into chunks of
                                                           * word-groups,
                                                           * broken up at their "white-space" locations.  Each spacer is
                                                           * then
                                                           * padded by however many pixels are necessary to keep each
                                                           * spacer
                                                           * uniformly of approximately equal size.  Only enough spare
                                                           * pixels are
                                                           * added to make sure that the right-edge of the text region
                                                           * alignts
                                                           * with the right border of the boundary.  The result is a
                                                           * nicely
                                                           * formatted text block.
                                                           */

                                                   