/* compile with: gcc -lsscript -o example-server example-server.c */

#include <stdio.h>
#include <errno.h>

main(int argc, char *argv[])
{
 int sockfd, client;
 char name[255];
 char temp[1024];
 printf("Listening on port 2700\n");
 sockfd=sscript_server(2700);
 if(sockfd<0)
 {
  printf("Error: %d\n",errno);
  exit(1);
 }
 client=sscript_wait_clients(sockfd, 2700, 1);
 printf("Got a connection from %s! Going to the background... [%d]\n",sscript_get_remote_ip(),client);
 sscript_write(client, "\n\nSocket Script Library (sscript)\n\n");
 sscript_write(client, "Login (enter your name): ");
 strcpy(name,(char *)sscript_read(client, 0));
 sprintf(temp,"Hi %s\n",name);
 sscript_write(client, temp); 
}
