/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/

#ifndef _NS_PROTO_AGENT
#define _NS_PROTO_AGENT

#include "agent.h"
#include "timer-handler.h"

#include "protoSim.h"

// The "NsProtoAgent" is based on the ns UDP agent class.
// This lets us have a send/recv attachment to the NS
// simulation environment

class ProtoExample
{
    public:
        ProtoExample(class NsProtoAgent* agent);
        void Start(SIMADDR dstAddr, unsigned short dstPort);
        void Stop();
        bool OnTxTimeout();
        bool OnSocketRecv(UdpSocket* theSocket);
        void DoTimers() {timer_mgr.DoTimers();}
            
    private:
        ProtocolTimerMgr     timer_mgr;
        ProtocolTimer        tx_timer;
        UdpSocket            socket;
        
        SIMADDR              dst_addr;
        unsigned short       dst_port;
                  
};  // end class ProtoExample

class NsProtoAgent : public Agent, public TimerHandler, public ProtoSimAgent
{
    public:
        NsProtoAgent();
    
        // ns Agent base class overrides
        int command(int argc, const char*const* argv); 
        void recv(Packet* p, Handler* h);
        
        // ns TimerHandler base class overrides  
        void expire(Event* e)
        {
            force_cancel();
            example.DoTimers();
        }
        
        // Simulation socket Mgmt & I/O functions
        virtual bool OpenSocket(UdpSocket* theSocket, unsigned short* thePort);
        virtual void CloseSocket(UdpSocket* theSocket) {udp_socket = NULL;}     
        virtual bool SendTo(UdpSocket* theSocket, 
                            SIMADDR theAddr, 
                            unsigned short thePort,
                            char* buffer, unsigned int len);
        
        virtual bool RecvFrom(UdpSocket* theSocket,
                              char* buffer, unsigned int* buflen,
                              SIMADDR* srcAddr, unsigned short* srcPort);
        
        virtual bool JoinGroup(UdpSocket* theSocket, SIMADDR theGroup);
        virtual void LeaveGroup(UdpSocket* theSocket, SIMADDR theGroup);
        virtual void SetSocketTTL(UdpSocket* theSocket, unsigned char theTTL)
            {mcast_ttl = theTTL;}
        virtual void SetSocketLoopback(UdpSocket* theSocket, bool state)
            {mcast_loopback = state;}     
        
    private:
    // Members
        // (TBD) Support multiple "sockets" per agent.
        // (we'll have to provide port/socket demuxing, etc)
        UdpSocket*      udp_socket;
        unsigned char   mcast_ttl;
        bool            mcast_loopback;
        char*           recv_data;
        unsigned int    recv_len;
        nsaddr_t        recv_addr;
        unsigned short  recv_port;
           
    // Misc. simulator agent routines
        virtual unsigned long GetAgentId() {return here_.addr_;}
               
        // Simulation timer mgmt functions (for our single system timer)
        virtual void InstallTimer(double delay) {resched(delay);}
        virtual void ModifyTimer(double delay) {resched(delay);}
        virtual void RemoveTimer() {force_cancel();}
        
        void OnTimeOut();
        
        // State for example protocol instantiation
        
        ProtoExample    example;
             
};  // end class NsProtoAgent


#endif // _NS_PROTO_AGENT
