/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.borders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JInternalFrame;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.util.ColorRoutines;

public class TinyInternalFrameBorder
extends AbstractBorder
implements UIResource {
    private static final HashMap cache = new HashMap();
    public static Color frameUpperColor;
    public static Color frameLowerColor;
    public static Color disabledUpperColor;
    public static Color disabledLowerColor;
    private JInternalFrame frame;
    private boolean isPalette;
    private int titleHeight;
    private boolean isActive;

    public static void clearCache() {
        cache.clear();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.frame = (JInternalFrame)c;
        this.frame.setOpaque(false);
        this.isActive = this.frame.isSelected();
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        this.titleHeight = this.isPalette ? 21 : 25;
        if (this.isActive) {
            g.setColor(Theme.frameBorderColor.getColor());
        } else {
            g.setColor(Theme.frameBorderDisabledColor.getColor());
        }
        this.drawXpBorder(g, x, y, w, h);
        ColorUIResource col = null;
        col = this.isActive ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        g.setColor(col);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpCaptionNoCache(g, x, y, w, h, col);
        } else {
            this.drawXpCaption(g, x, y, w, h, col);
        }
    }

    private void drawXpBorder(Graphics g, int x, int y, int w, int h) {
        g.drawLine(x, y + 6, x, y + h - 1);
        g.drawLine(x + 2, y + this.titleHeight, x + 2, y + h - 3);
        g.drawLine(x + w - 1, y + 6, x + w - 1, y + h - 1);
        g.drawLine(x + w - 3, y + this.titleHeight, x + w - 3, y + h - 3);
        g.drawLine(x + 2, y + h - 3, x + w - 3, y + h - 3);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        if (this.isActive) {
            g.setColor(Theme.frameCaptionColor.getColor());
        } else {
            g.setColor(Theme.frameCaptionDisabledColor.getColor());
        }
        g.drawLine(x + 1, y + this.titleHeight, x + 1, y + h - 2);
        g.drawLine(x + w - 2, y + this.titleHeight, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        ColorUIResource c = null;
        c = this.isActive ? Theme.frameBorderColor.getColor() : Theme.frameBorderDisabledColor.getColor();
        g.setColor(ColorRoutines.getAlphaColor(c, 82));
        g.drawLine(x, y + 3, x, y + 3);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
        g.setColor(ColorRoutines.getAlphaColor(c, 156));
        g.drawLine(x, y + 4, x, y + 4);
        g.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
        g.setColor(ColorRoutines.getAlphaColor(c, 215));
        g.drawLine(x, y + 5, x, y + 5);
        g.drawLine(x + w - 1, y + 5, x + w - 1, y + 5);
    }

    private void drawXpCaption(Graphics g, int x, int y, int w, int h, Color c) {
        if (this.isPalette) {
            this.drawXpPaletteCaption(g, x, y, w, h, c);
            return;
        }
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        int y2 = y;
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        } else {
            borderColor = Theme.frameBorderDisabledColor.getColor();
        }
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + 6, y2);
        g.drawLine(x + x + w - 7, y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, ++y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        CaptionKey key = new CaptionKey(this.isActive, this.titleHeight);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.frame);
            g.drawImage((Image)value, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.frame);
            if (this.isActive) {
                frameUpperColor = ColorRoutines.darken(c, 4 * spread1);
                frameLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            } else {
                disabledUpperColor = ColorRoutines.darken(c, 4 * spread1);
                disabledLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            }
            return;
        }
        BufferedImage img = new BufferedImage(1, this.titleHeight, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(borderColor);
        imgGraphics.drawLine(0, 0, 1, 0);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 1, 1, 1);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 2, 1, 2);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 3, 1, 3);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 4, 1, 4);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 5, 1, 5);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 6, 1, 6);
        imgGraphics.setColor(ColorRoutines.darken(c, 3 * spread1));
        imgGraphics.drawLine(0, 7, 1, 7);
        imgGraphics.drawLine(0, 8, 1, 8);
        imgGraphics.drawLine(0, 9, 1, 9);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 10, 1, 10);
        imgGraphics.drawLine(0, 11, 1, 11);
        imgGraphics.setColor(ColorRoutines.darken(c, spread1));
        imgGraphics.drawLine(0, 12, 1, 12);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 13, 1, 13);
        imgGraphics.drawLine(0, 14, 1, 14);
        imgGraphics.setColor(ColorRoutines.lighten(c, 2 * spread2));
        imgGraphics.drawLine(0, 15, 1, 15);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 16, 1, 16);
        imgGraphics.setColor(ColorRoutines.lighten(c, 5 * spread2));
        imgGraphics.drawLine(0, 17, 1, 17);
        imgGraphics.setColor(ColorRoutines.lighten(c, 6 * spread2));
        imgGraphics.drawLine(0, 18, 1, 18);
        imgGraphics.setColor(ColorRoutines.lighten(c, 8 * spread2));
        imgGraphics.drawLine(0, 19, 1, 19);
        imgGraphics.setColor(ColorRoutines.lighten(c, 9 * spread2));
        imgGraphics.drawLine(0, 20, 1, 20);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 21, 1, 21);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 22, 1, 22);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 23, 1, 23);
        if (this.isActive) {
            imgGraphics.setColor(Theme.frameLightColor.getColor());
        } else {
            imgGraphics.setColor(Theme.frameLightDisabledColor.getColor());
        }
        imgGraphics.drawLine(0, 24, 1, 24);
        imgGraphics.dispose();
        g.drawImage(img, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.frame);
        g.drawImage(img, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.frame);
        cache.put(key, img);
    }

    private void drawXpCaptionNoCache(Graphics g, int x, int y, int w, int h, Color c) {
        if (this.isPalette) {
            this.drawXpPaletteCaptionNoCache(g, x, y, w, h, c);
            return;
        }
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        } else {
            borderColor = Theme.frameBorderDisabledColor.getColor();
        }
        g.setColor(borderColor);
        g.drawLine(x + 6, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 7, ++y2, x + w - 8, y2);
        g.setColor(c);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        ++y2;
        if (this.isActive) {
            frameUpperColor = ColorRoutines.darken(c, 4 * spread1);
            g.setColor(frameUpperColor);
        } else {
            disabledUpperColor = ColorRoutines.darken(c, 4 * spread1);
            g.setColor(disabledUpperColor);
        }
        g.drawLine(x + 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 3);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, y2 += 3, w - 2, 2);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, y2 += 2, w - 2, 1);
        g.setColor(c);
        g.fillRect(x + 1, ++y2, w - 2, 2);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, y2 += 2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            frameLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            g.setColor(frameLowerColor);
        } else {
            disabledLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            g.setColor(disabledLowerColor);
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor.getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor.getColor());
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
    }

    private void drawXpPaletteCaption(Graphics g, int x, int y, int w, int h, Color c) {
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        } else {
            borderColor = Theme.frameBorderDisabledColor.getColor();
        }
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + 6, y2);
        g.drawLine(x + x + w - 7, y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, ++y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        CaptionKey key = new CaptionKey(this.isActive, this.titleHeight);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.frame);
            g.drawImage((Image)value, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.frame);
            if (this.isActive) {
                frameUpperColor = ColorRoutines.darken(c, 4 * spread1);
                frameLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            } else {
                disabledUpperColor = ColorRoutines.darken(c, 4 * spread1);
                disabledLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            }
            return;
        }
        BufferedImage img = new BufferedImage(1, this.titleHeight, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(borderColor);
        imgGraphics.drawLine(0, 0, 1, 0);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 1, 1, 1);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 2, 1, 2);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 3, 1, 3);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 4, 1, 4);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 5, 1, 5);
        imgGraphics.drawLine(0, 6, 1, 6);
        imgGraphics.setColor(ColorRoutines.darken(c, 3 * spread1));
        imgGraphics.drawLine(0, 7, 1, 7);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 8, 1, 8);
        imgGraphics.setColor(ColorRoutines.darken(c, spread1));
        imgGraphics.drawLine(0, 9, 1, 9);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 10, 1, 10);
        imgGraphics.setColor(ColorRoutines.lighten(c, 2 * spread2));
        imgGraphics.drawLine(0, 11, 1, 11);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 12, 1, 12);
        imgGraphics.setColor(ColorRoutines.lighten(c, 5 * spread2));
        imgGraphics.drawLine(0, 13, 1, 13);
        imgGraphics.setColor(ColorRoutines.lighten(c, 6 * spread2));
        imgGraphics.drawLine(0, 14, 1, 14);
        imgGraphics.setColor(ColorRoutines.lighten(c, 8 * spread2));
        imgGraphics.drawLine(0, 15, 1, 15);
        imgGraphics.setColor(ColorRoutines.lighten(c, 9 * spread2));
        imgGraphics.drawLine(0, 16, 1, 16);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 17, 1, 17);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 18, 1, 18);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 19, 1, 19);
        if (this.isActive) {
            imgGraphics.setColor(Theme.frameLightColor.getColor());
        } else {
            imgGraphics.setColor(Theme.frameLightDisabledColor.getColor());
        }
        imgGraphics.drawLine(0, 20, 1, 20);
        imgGraphics.dispose();
        g.drawImage(img, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.frame);
        g.drawImage(img, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.frame);
        cache.put(key, img);
    }

    private void drawXpPaletteCaptionNoCache(Graphics g, int x, int y, int w, int h, Color c) {
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        } else {
            borderColor = Theme.frameBorderDisabledColor.getColor();
        }
        g.setColor(borderColor);
        g.drawLine(x + 6, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 7, ++y2, x + w - 8, y2);
        g.setColor(c);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        ++y2;
        if (this.isActive) {
            frameUpperColor = ColorRoutines.darken(c, 4 * spread1);
            g.setColor(frameUpperColor);
        } else {
            disabledUpperColor = ColorRoutines.darken(c, 4 * spread1);
            g.setColor(disabledUpperColor);
        }
        g.drawLine(x + 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(c);
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            frameLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            g.setColor(frameLowerColor);
        } else {
            disabledLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            g.setColor(disabledLowerColor);
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor.getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor.getColor());
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
    }

    public Insets getBorderInsets(Component c) {
        JInternalFrame frame = (JInternalFrame)c;
        if (frame.isMaximum()) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(0, 3, 3, 3);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    private static class CaptionKey {
        private boolean isActive;
        private int titleHeight;

        CaptionKey(boolean isActive, int titleHeight) {
            this.isActive = isActive;
            this.titleHeight = titleHeight;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof CaptionKey)) {
                return false;
            }
            CaptionKey other = (CaptionKey)o;
            return this.isActive == other.isActive && this.titleHeight == other.titleHeight;
        }

        public int hashCode() {
            return (this.isActive ? 1 : 2) * this.titleHeight;
        }
    }
}

