/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;

public interface SQLSchema {
    public Table getTable(String var1, String var2, String var3);

    public List<Table> getTables(String var1, String var2, String var3);

    public Table getTableForAlias(String var1);

    public static class Table
    implements Cloneable,
    Comparable<Table> {
        public final String catalog;
        public final String schema;
        public final String name;
        public final String compositeName;
        public transient String alias;
        private SQLDatabaseMetaData dmd;
        private String[] columns;

        public static String createCompositeName(String catalog, String schema, String name) {
            StringBuffer sbuf = new StringBuffer();
            if (catalog != null) {
                sbuf.append(catalog);
                sbuf.append(".");
            }
            if (schema != null) {
                sbuf.append(schema);
                sbuf.append(".");
            }
            sbuf.append(name);
            return sbuf.toString();
        }

        public Table clone(String alias) {
            try {
                Table newTable = (Table)super.clone();
                newTable.alias = alias;
                return newTable;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Table(String catalog, String schema, String name, SQLDatabaseMetaData dmd) {
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
            this.compositeName = Table.createCompositeName(catalog, schema, name);
            this.dmd = dmd;
        }

        public Table(String catalog, String schema, String name) {
            this(catalog, schema, name, null);
        }

        public Table(String schema, String name) {
            this(null, schema, name, null);
        }

        public Table(String name) {
            this(null, null, name, null);
        }

        public void setColumns(String[] columns) {
            this.columns = columns;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns.toArray(new String[columns.size()]);
        }

        public String[] getColumns() {
            if (this.columns == null) {
                this.loadColumns();
            }
            return this.columns;
        }

        public String[] getColumns(String prefix) {
            String[] cols = this.getColumns();
            if (prefix == null) {
                return cols;
            }
            ArrayList<String> list = new ArrayList<String>(cols.length);
            for (int i = 0; i < cols.length; ++i) {
                if (!cols[i].startsWith(prefix)) continue;
                list.add(cols[i]);
            }
            return list.toArray(new String[list.size()]);
        }

        public String getCompositeName() {
            return this.compositeName;
        }

        public boolean hasAlias() {
            return this.alias != null;
        }

        public String toString() {
            return this.alias == null ? this.compositeName : this.compositeName + " " + this.alias;
        }

        public int hashCode() {
            return this.compositeName.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Table) {
                Table o = (Table)other;
                if (o.compositeName.equals(this.compositeName)) {
                    return this.alias == o.alias || this.alias != null && this.alias.equals(o.alias);
                }
                return false;
            }
            return false;
        }

        public boolean equals(String catalog, String schema, String table) {
            return (this.catalog == catalog || this.catalog != null && catalog != null && this.catalog.equals(catalog)) && (this.schema == schema || this.schema != null && schema != null && this.schema.equals(schema)) && this.name.equals(table);
        }

        public boolean matches(String catalog, String schema, String name) {
            return (catalog == null || this.catalog != null && this.catalog.startsWith(catalog)) && (schema == null || this.schema != null && this.schema.startsWith(schema)) && (name == null || this.name.startsWith(name));
        }

        @Override
        public int compareTo(Table other) {
            if (this.alias != null) {
                return other.alias != null ? this.alias.compareTo(other.alias) : -1;
            }
            if (other.alias != null) {
                return 1;
            }
            return this.compositeName.compareTo(other.compositeName);
        }

        protected void loadColumns() {
            try {
                ArrayList<String> cols = new ArrayList<String>();
                TableColumnInfo[] infos = this.dmd.getColumnInfo(this.catalog, this.schema, this.name);
                for (int i = 0; i < infos.length; ++i) {
                    cols.add(infos[i].getColumnName());
                }
                this.setColumns(cols);
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

