/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;

public class BenchmarkDoubleDCT {
    private static int nthread = 2;
    private static int nsize = 6;
    private static int niter = 200;
    private static boolean doWarmup = true;
    private static int initialExponent1D = 17;
    private static int initialExponent2D = 7;
    private static int initialExponent3D = 2;
    private static boolean doScaling = false;

    private BenchmarkDoubleDCT() {
    }

    public static void parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("args[" + i + "]:" + stringArray[i]);
        }
        if (stringArray == null || stringArray.length != 10) {
            System.out.println("Parameters: <number of threads> <THREADS_BEGIN_N_2D> <THREADS_BEGIN_N_3D> <number of iterations> <perform warm-up> <perform scaling> <number of sizes> <initial exponent for 1D transforms> <initial exponent for 2D transforms> <initial exponent for 3D transforms>");
            System.exit(-1);
        }
        nthread = Integer.parseInt(stringArray[0]);
        ConcurrencyUtils.setThreadsBeginN_2D(Integer.parseInt(stringArray[1]));
        ConcurrencyUtils.setThreadsBeginN_3D(Integer.parseInt(stringArray[2]));
        niter = Integer.parseInt(stringArray[3]);
        doWarmup = Boolean.parseBoolean(stringArray[4]);
        doScaling = Boolean.parseBoolean(stringArray[5]);
        nsize = Integer.parseInt(stringArray[6]);
        initialExponent1D = Integer.parseInt(stringArray[7]);
        initialExponent2D = Integer.parseInt(stringArray[8]);
        initialExponent3D = Integer.parseInt(stringArray[9]);
        ConcurrencyUtils.setNumberOfProcessors(nthread);
    }

    public static void benchmarkForward_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 1D of size 2^" + n3);
            DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(n2);
            double[] dArray2 = new double[n2];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(n2, dArray2);
                doubleDCT_1D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_1D(n2, dArray2);
                doubleDCT_1D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(n2, dArray2);
                l = System.nanoTime();
                doubleDCT_1D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_1D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 2D (input 1D) of size 2^" + n3 + " x 2^" + n3);
            DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(n2, n2);
            double[] dArray2 = new double[n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                l = System.nanoTime();
                doubleDCT_2D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_2D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 2D (input 2D) of size 2^" + n3 + " x 2^" + n3);
            DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(n2, n2);
            double[][] dArray2 = new double[n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                l = System.nanoTime();
                doubleDCT_2D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 3D (input 1D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(n2, n2, n2);
            double[] dArray2 = new double[n2 * n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                l = System.nanoTime();
                doubleDCT_3D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_3D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 3D (input 3D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(n2, n2, n2);
            double[][][] dArray2 = new double[n2][n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                l = System.nanoTime();
                doubleDCT_3D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDCT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleDCT.parseArguments(stringArray);
        BenchmarkDoubleDCT.benchmarkForward_1D(initialExponent1D);
        BenchmarkDoubleDCT.benchmarkForward_2D_input_1D(initialExponent2D);
        BenchmarkDoubleDCT.benchmarkForward_2D_input_2D(initialExponent2D);
        BenchmarkDoubleDCT.benchmarkForward_3D_input_1D(initialExponent3D);
        BenchmarkDoubleDCT.benchmarkForward_3D_input_3D(initialExponent3D);
        System.exit(0);
    }
}

