#shellcheck shell=sh

Describe "libexec/kcov-executor.sh"
  Include "$SHELLSPEC_LIB/libexec/kcov-executor.sh"

  Describe 'kcov_fix_index()'
    Data
      #|var data = {files:[
      #|{"link":"shellspec [specfiles].f0c88df62a0bacd/index.html","title":"shellspec [specfiles]","summary_name":"shellspec [specfiles]","covered_class":"lineNoCov","covered":"9.5","covered_lines":"279","uncovered_lines":"2665","total_lines" : "2944"},
      #|], merged_files:[]};
      #|var percent_low = 25;var percent_high = 75;
      #|var header = { "command" : "shellspec spec/bootstrap_spec.sh", "date" : "2020-02-06 23:46:37", "instrumented" : 2944, "covered" : 279,};
    End

    result() {
      %text
      #|var data = {files:[
      #|{"link":"shellspec [specfiles]/index.html","title":"shellspec [specfiles]","summary_name":"shellspec [specfiles]","covered_class":"lineNoCov","covered":"9.5","covered_lines":"279","uncovered_lines":"2665","total_lines" : "2944"},
      #|], merged_files:[]};
      #|var percent_low = 25;var percent_high = 75;
      #|var header = { "command" : "shellspec spec/bootstrap_spec.sh", "date" : "2020-02-06 23:46:37", "instrumented" : 2944, "covered" : 279,};
    }

    It 'fixes index link path'
      When call kcov_fix_index "shellspec [specfiles].f0c88df62a0bacd" "shellspec [specfiles]"
      The stdout should eq "$(result)"
    End
  End

  Describe 'kcov_fix_coverage()'
    Data
      #| {
      #|   "files": [
      #|     {"file": "/mnt/c/Users/koichi/workspace/shellspec/shellspec", "percent_covered": "0.00", "covered_lines": "0", "total_lines": "278"},
      #|     {"file": "/mnt/c/Users/koichi/workspace/shellspec/lib/bootstrap.sh", "percent_covered": "81.48", "covered_lines": "22", "total_lines": "27"}
      #|   ],
      #|   "percent_covered": "9.48",
      #|   "covered_lines": 279,
      #|   "total_lines": 2944,
      #|   "percent_low": 25,
      #|   "percent_high": 75,
      #|   "command": "shellspec spec",
      #|   "date": "2020-02-06 23:46:37"
      #| }
    End

    result() {
      %text
      #| {
      #|   "files": [
      #|     {"file": "/home/koichi/workspace/shellspec/shellspec", "percent_covered": "0.00", "covered_lines": "0", "total_lines": "278"},
      #|     {"file": "/home/koichi/workspace/shellspec/lib/bootstrap.sh", "percent_covered": "81.48", "covered_lines": "22", "total_lines": "27"}
      #|   ],
      #|   "percent_covered": "9.48",
      #|   "covered_lines": 279,
      #|   "total_lines": 2944,
      #|   "percent_low": 25,
      #|   "percent_high": 75,
      #|   "command": "shellspec spec",
      #|   "date": "2020-02-06 23:46:37"
      #| }
    }

    It 'fixes coverage file path'
      When call kcov_fix_coverage "/mnt/c/Users/koichi/workspace/shellspec" "/home/koichi/workspace/shellspec"
      The stdout should eq "$(result)"
    End
  End

  Describe 'kcov_fix_sonarqube()'
    Data
      #|<!-- Generated by kcov (https://simonkagstrom.github.io/kcov/) -->
      #|<coverage version="1">
      #|        <file path="/mnt/c/Users/koichi/workspace/shellspec/shellspec">
      #|                <lineToCover lineNumber="4" covered="false"/>
      #|                <lineToCover lineNumber="6" covered="false"/>
      #|        </file>
      #|        <file path="/mnt/c/Users/koichi/workspace/shellspec/lib/bootstrap.sh">
      #|                <lineToCover lineNumber="4" covered="true"/>
      #|                <lineToCover lineNumber="16" covered="true"/>
      #|        </file>
      #|</coverage>
    End

    result() {
      %text
      #|<!-- Generated by kcov (https://simonkagstrom.github.io/kcov/) -->
      #|<coverage version="1">
      #|        <file path="/home/koichi/workspace/shellspec/shellspec">
      #|                <lineToCover lineNumber="4" covered="false"/>
      #|                <lineToCover lineNumber="6" covered="false"/>
      #|        </file>
      #|        <file path="/home/koichi/workspace/shellspec/lib/bootstrap.sh">
      #|                <lineToCover lineNumber="4" covered="true"/>
      #|                <lineToCover lineNumber="16" covered="true"/>
      #|        </file>
      #|</coverage>
    }

    It 'fixes sonarqube file path'
      When call kcov_fix_sonarqube "/mnt/c/Users/koichi/workspace/shellspec" "/home/koichi/workspace/shellspec"
      The stdout should eq "$(result)"
    End
  End

  Describe 'kcov_fix_cobertura()'
    Data
      #|<?xml version="1.0" ?>
      #|<!DOCTYPE coverage SYSTEM 'http://cobertura.sourceforge.net/xml/coverage-03.dtd'>
      #|<coverage line-rate="0.000" version="1.9" timestamp="1581000397">
      #|        <sources>
      #|                <source>/mnt/c/Users/koichi/workspace/shellspec/</source>
      #|        </sources>
      #|        <packages>
      #|                <package name="shellspec spec/bootstrap_spec_sh" line-rate="0.000" branch-rate="1.0" complexity="1.0">
      #|                        <classes>
      #|                                <class name="shellspec_sh" filename="lib/libexec/shellspec.sh" line-rate="0.000">
      #|                                        <lines>
      #|                                                <line number="4" hits="0"/>
      #|                                                <line number="5" hits="0"/>
      #|                                        </lines>
      #|                                </class>
      #|                                <class name="bootstrap_sh" filename="lib/bootstrap.sh" line-rate="0.815">
      #|                                        <lines>
      #|                                                <line number="4" hits="1"/>
      #|                                                <line number="16" hits="1"/>
      #|                                        </lines>
      #|                                </class>
      #|                        </classes>
      #|                </package>
      #|        </packages>
      #|</coverage>
    End

    result() {
      %text
      #|<?xml version="1.0" ?>
      #|<!DOCTYPE coverage SYSTEM 'http://cobertura.sourceforge.net/xml/coverage-03.dtd'>
      #|<coverage line-rate="0.000" version="1.9" timestamp="1581000397">
      #|        <sources>
      #|                <source>/home/koichi/workspace/shellspec</source>
      #|        </sources>
      #|        <packages>
      #|                <package name="shellspec spec/bootstrap_spec_sh" line-rate="0.000" branch-rate="1.0" complexity="1.0">
      #|                        <classes>
      #|                                <class name="shellspec_sh" filename="lib/libexec/shellspec.sh" line-rate="0.000">
      #|                                        <lines>
      #|                                                <line number="4" hits="0"/>
      #|                                                <line number="5" hits="0"/>
      #|                                        </lines>
      #|                                </class>
      #|                                <class name="bootstrap_sh" filename="lib/bootstrap.sh" line-rate="0.815">
      #|                                        <lines>
      #|                                                <line number="4" hits="1"/>
      #|                                                <line number="16" hits="1"/>
      #|                                        </lines>
      #|                                </class>
      #|                        </classes>
      #|                </package>
      #|        </packages>
      #|</coverage>
    }

    It 'fixes cobertura source path'
      When call kcov_fix_cobertura "/mnt/c/Users/koichi/workspace/shellspec" "/home/koichi/workspace/shellspec"
      The stdout should eq "$(result)"
    End
  End

  Describe 'kcov_add_extra_info()'
    Data
      #|<html>
      #|<body>
      #|</body>
      #|</html>
    End

    result() {
      %text
      #|<html>
      #|<body>
      #|<table width='100%' class='shellspecVersionInfo'>
      #|<tr><td class='versionInfo'>
      #|Tested by: <a href='https://shellspec.info'>ShellSpec</a> 0.0.0 (with shell 0.1.0 and kcov 35)
      #|</td></tr>
      #|</table>
      #|</body>
      #|</html>
    }

    BeforeRun "SHELLSPEC_VERSION='0.0.0'"
    BeforeRun "SHELLSPEC_KCOV_VERSION='kcov 35'"
    BeforeRun "SHELLSPEC_SHELL_TYPE='shell'" "SHELLSPEC_SHELL_VERSION='0.1.0'"
    It 'adds extra info'
      When run kcov_add_extra_info
      The stdout should eq "$(result)"
    End
  End
End
