<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw marketplace`
Marketplace API
  
- [Marketplace category management commands](#marketplace-category-management-commands)
  - [Get a specific category](#get-a-specific-category)
  - [List existing image categories](#list-existing-image-categories)
- [Marketplace images management commands](#marketplace-images-management-commands)
  - [Get a specific marketplace image](#get-a-specific-marketplace-image)
  - [List marketplace images](#list-marketplace-images)
- [Marketplace local images management commands](#marketplace-local-images-management-commands)
  - [Get a specific local image by ID](#get-a-specific-local-image-by-id)
  - [List local images from a specific image or version](#list-local-images-from-a-specific-image-or-version)
- [Marketplace version management commands](#marketplace-version-management-commands)
  - [Get a specific image version](#get-a-specific-image-version)
  - [List versions of an Image](#list-versions-of-an-image)

  
## Marketplace category management commands

Marketplace category management commands.


### Get a specific category

Get information about a specific category of the marketplace catalog, specified by its `category_id` (UUID format).

**Usage:**

```
scw marketplace category get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| category-id | Required |  |



### List existing image categories

Get a list of all existing categories. The output can be paginated.

**Usage:**

```
scw marketplace category list
```



## Marketplace images management commands

Marketplace images management commands.


### Get a specific marketplace image

Get detailed information about a marketplace image, specified by its `image_id` (UUID format).

**Usage:**

```
scw marketplace image get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| label | Required |  |



### List marketplace images

List all available images on the marketplace, their UUID, CPU architecture and description.

**Usage:**

```
scw marketplace image list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` | Ordering to use |
| arch |  | Choose for which machine architecture to return images |
| category |  | Choose the category of images to get |
| include-eol |  | Choose to include end-of-life images |



## Marketplace local images management commands

Marketplace local images management commands.


### Get a specific local image by ID

Get detailed information about a local image, including compatible commercial types, supported architecture, labels and the Availability Zone of the image, specified by its `local_image_id` (UUID format).

**Usage:**

```
scw marketplace local-image get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| local-image-id | Required |  |



### List local images from a specific image or version

List information about local images in a specific Availability Zone, specified by its `image_id` (UUID format), `version_id` (UUID format) or `image_label`. Only one of these three parameters may be set.

**Usage:**

```
scw marketplace local-image list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id |  |  |
| version-id |  |  |
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| image-label |  |  |
| zone |  |  |
| type | One of: `unknown_type`, `instance_local`, `instance_sbs` |  |



## Marketplace version management commands

Marketplace version management commands.


### Get a specific image version

Get information such as the name, creation date, last update and published date for an image version specified by its `version_id` (UUID format).

**Usage:**

```
scw marketplace version get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| version-id | Required |  |



### List versions of an Image

Get a list of all available version of an image, specified by its `image_id` (UUID format).

**Usage:**

```
scw marketplace version list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id |  |  |
| order-by | One of: `created_at_asc`, `created_at_desc` |  |



