<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw block`
This API allows you to use and manage your Block Storage volumes.
  
- [A Block Storage snapshot is a read-only picture of a Block volume, taken at a specific time](#a-block-storage-snapshot-is-a-read-only-picture-of-a-block-volume,-taken-at-a-specific-time)
  - [Create a snapshot of a volume](#create-a-snapshot-of-a-volume)
  - [Delete a snapshot](#delete-a-snapshot)
  - [Get a snapshot](#get-a-snapshot)
  - [List all snapshots](#list-all-snapshots)
  - [Update a snapshot](#update-a-snapshot)
- [A Block Storage volume is a logical storage drive on a network-connected storage system. It is exposed to Instances as if it were a physical disk, and can be attached and detached like a hard drive. Several Block volumes can be attached to one Instance at a time](#a-block-storage-volume-is-a-logical-storage-drive-on-a-network-connected-storage-system.-it-is-exposed-to-instances-as-if-it-were-a-physical-disk,-and-can-be-attached-and-detached-like-a-hard-drive.-several-block-volumes-can-be-attached-to-one-instance-at-a-time)
  - [Create a volume](#create-a-volume)
  - [Delete a detached volume](#delete-a-detached-volume)
  - [Get a volume](#get-a-volume)
  - [List volumes](#list-volumes)
  - [Update a volume](#update-a-volume)
- [Block Storage volume types are determined by their storage class and their IOPS. There are two storage classes available: `bssd` and `sbs`. The IOPS can be chosen for volumes of the `sbs` storage class](#block-storage-volume-types-are-determined-by-their-storage-class-and-their-iops.-there-are-two-storage-classes-available:-`bssd`-and-`sbs`.-the-iops-can-be-chosen-for-volumes-of-the-`sbs`-storage-class)
  - [List volume types](#list-volume-types)

  
## A Block Storage snapshot is a read-only picture of a Block volume, taken at a specific time

You can then revert your data to the previous snapshot. You can also create a new read/write Block volume from a previous snapshot.


### Create a snapshot of a volume

To create a snapshot, the volume must be in the `in_use` or the `available` status.
If your volume is in a transient state, you need to wait until the end of the current operation.

**Usage:**

```
scw block snapshot create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id |  | UUID of the volume to snapshot |
| name |  | Name of the snapshot |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | List of tags assigned to the snapshot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a snapshot

You must specify the `snapshot_id` of the snapshot you want to delete. The snapshot must not be in use.

**Usage:**

```
scw block snapshot delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a snapshot

Retrieve technical information about a specific snapshot. Details such as size, volume type, and status are returned in the response.

**Usage:**

```
scw block snapshot get <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List all snapshots

List all available snapshots in a specified zone. By default, the snapshots listed are ordered by creation date in ascending order. This can be modified via the `order_by` field.

**Usage:**

```
scw block snapshot list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Criteria to use when ordering the list |
| project-id |  | Filter by Project ID |
| volume-id |  | Filter snapshots by the ID of the original volume |
| name |  | Filter snapshots by their names |
| organization-id |  | Filter by Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a snapshot

Update the name or tags of the snapshot.

**Usage:**

```
scw block snapshot update <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot |
| name |  | When defined, is the name of the snapshot |
| tags.{index} |  | List of tags assigned to the snapshot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## A Block Storage volume is a logical storage drive on a network-connected storage system. It is exposed to Instances as if it were a physical disk, and can be attached and detached like a hard drive. Several Block volumes can be attached to one Instance at a time

Block volumes can be snapshotted, mounted or unmounted.


### Create a volume

To create a new volume from scratch, you must specify `from_empty` and the `size`.
To create a volume from an existing snapshot, specify `from_snapshot` and the `snapshot_id` in the request payload instead, size is optional and can be specified if you need to extend the original size. The volume will take on the same volume class and underlying IOPS limitations as the original snapshot.

**Usage:**

```
scw block volume create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Name of the volume |
| perf-iops | Required | The maximum IO/s expected, according to the different options available in stock (`5000 | 15000`) |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| from-empty.size |  | Volume size in bytes, with a granularity of 1 GB (10^9 bytes) |
| from-snapshot.size |  | Volume size in bytes, with a granularity of 1 GB (10^9 bytes) |
| from-snapshot.snapshot-id |  | Source snapshot from which volume will be created |
| tags.{index} |  | List of tags assigned to the volume |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a detached volume

You must specify the `volume_id` of the volume you want to delete. The volume must not be in the `in_use` status.

**Usage:**

```
scw block volume delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a volume

Retrieve technical information about a specific volume. Details such as size, type, and status are returned in the response.

**Usage:**

```
scw block volume get <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List volumes

List all existing volumes in a specified zone. By default, the volumes listed are ordered by creation date in ascending order. This can be modified via the `order_by` field.

**Usage:**

```
scw block volume list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Criteria to use when ordering the list |
| project-id |  | Filter by Project ID |
| name |  | Filter the return volumes by their names |
| product-resource-id |  | Filter by a product resource ID linked to this volume (such as an Instance ID) |
| organization-id |  | Filter by Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a volume

Update the technical details of a volume, such as its name, tags, or its new size and `volume_type` (within the same Block Storage class).
You can only resize a volume to a larger size. It is currently not possible to change your Block Storage Class.

**Usage:**

```
scw block volume update <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume |
| name |  | When defined, is the new name of the volume |
| size |  | Optional field for increasing the size of a volume (size must be equal or larger than the current one) |
| tags.{index} |  | List of tags assigned to the volume |
| perf-iops |  | The maximum IO/s expected, according to the different options available in stock (`5000 | 15000`) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Block Storage volume types are determined by their storage class and their IOPS. There are two storage classes available: `bssd` and `sbs`. The IOPS can be chosen for volumes of the `sbs` storage class

Block Storage volume types are determined by their storage class and their IOPS. There are two storage classes available: `bssd` and `sbs`. The IOPS can be chosen for volumes of the `sbs` storage class.


### List volume types

List all available volume types in a specified zone. The volume types listed are ordered by name in ascending order.

**Usage:**

```
scw block volume-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-3`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



