#include "precomp.h"
#include "ReiserDiskAccess.h"
#include "reiserfs.h"

ReiserDiskAccess::ReiserDiskAccess(DWORD disk, LONGLONG startingOffset, LONGLONG length)
    :   m_PI(disk, startingOffset, length)
{
}

ReiserDiskAccess::~ReiserDiskAccess()
{
}

bool ReiserDiskAccess::IsReiserFS(DWORD disk, LONGLONG startingOffset, LONGLONG length)
{
    bool success = false;

    TRACE(("IsReiserFS(%d,%I64d,%I64d)\n", disk,startingOffset, length)) 
    ReiserDiskAccess* rda = new ReiserDiskAccess(disk, startingOffset, length);
    if( rda )
    {
        ReiserFsPartition partition(rda);
        success = partition.CheckReiserFsPartition();
        delete rda;
    }
    return success;
}

BOOL ReiserDiskAccess::Open(int)
{
    return TRUE;
}

void ReiserDiskAccess::Close()
{
}

BOOL ReiserDiskAccess::GetDriveGeometry( DISK_GEOMETRY* lpDG )
{
    ZeroMemory( lpDG, sizeof(DISK_GEOMETRY));
    lpDG->BytesPerSector = m_PI.GetBytesPerSector();
    return TRUE;
}

BOOL ReiserDiskAccess::GetDriveLayout( LPBYTE lpbMemory, DWORD dwSize )
{
    return FALSE;
}

BOOL ReiserDiskAccess::ReadAbsolute( LPBYTE lpbMemory, DWORD dwSize, INT64 OffsetInBytes )
{
    DWORD dwBytesPerSector = m_PI.GetBytesPerSector();
    DWORD dwSectors =  dwSize / dwBytesPerSector;
    OffsetInBytes /= dwBytesPerSector;
	m_PI.ReadSectors(OffsetInBytes, lpbMemory, dwSectors);
    return TRUE;
}


