import CoreServices
from PyObjCTools.TestSupport import TestCase


class TestComponents(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), f"{name!r} exposed in bindings"
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("kAppleManufacturer")
        self.assert_not_wrapped("kComponentResourceType")
        self.assert_not_wrapped("kComponentAliasResourceType")
        self.assert_not_wrapped("kAnyComponentType")
        self.assert_not_wrapped("kAnyComponentSubType")
        self.assert_not_wrapped("kAnyComponentManufacturer")
        self.assert_not_wrapped("kAnyComponentFlagsMask")
        self.assert_not_wrapped("cmpThreadSafe")
        self.assert_not_wrapped("cmpIsMissing")
        self.assert_not_wrapped("cmpWantsRegisterMessage")
        self.assert_not_wrapped("kComponentOpenSelect")
        self.assert_not_wrapped("kComponentCloseSelect")
        self.assert_not_wrapped("kComponentCanDoSelect")
        self.assert_not_wrapped("kComponentVersionSelect")
        self.assert_not_wrapped("kComponentRegisterSelect")
        self.assert_not_wrapped("kComponentTargetSelect")
        self.assert_not_wrapped("kComponentUnregisterSelect")
        self.assert_not_wrapped("kComponentGetMPWorkFunctionSelect")
        self.assert_not_wrapped("kComponentExecuteWiredActionSelect")
        self.assert_not_wrapped("kComponentGetPublicResourceSelect")
        self.assert_not_wrapped("componentDoAutoVersion")
        self.assert_not_wrapped("componentWantsUnregister")
        self.assert_not_wrapped("componentAutoVersionIncludeFlags")
        self.assert_not_wrapped("componentHasMultiplePlatforms")
        self.assert_not_wrapped("componentLoadResident")
        self.assert_not_wrapped("defaultComponentIdentical")
        self.assert_not_wrapped("defaultComponentAnyFlags")
        self.assert_not_wrapped("defaultComponentAnyManufacturer")
        self.assert_not_wrapped("defaultComponentAnySubType")
        self.assert_not_wrapped("defaultComponentAnyFlagsAnyManufacturer")
        self.assert_not_wrapped("defaultComponentAnyFlagsAnyManufacturerAnySubType")
        self.assert_not_wrapped("registerComponentGlobal")
        self.assert_not_wrapped("registerComponentNoDuplicates")
        self.assert_not_wrapped("registerComponentAfterExisting")
        self.assert_not_wrapped("registerComponentAliasesOnly")
        self.assert_not_wrapped("ComponentDescription")
        self.assert_not_wrapped("ResourceSpec")
        self.assert_not_wrapped("ComponentResource")
        self.assert_not_wrapped("ComponentPlatformInfo")
        self.assert_not_wrapped("ComponentResourceExtension")
        self.assert_not_wrapped("ComponentPlatformInfoArray")
        self.assert_not_wrapped("ExtComponentResource")
        self.assert_not_wrapped("ComponentAliasResource")
        self.assert_not_wrapped("ComponentParameters")
        self.assert_not_wrapped("ComponentRecord")
        self.assert_not_wrapped("ComponentInstanceRecord")
        self.assert_not_wrapped("RegisteredComponentRecord")
        self.assert_not_wrapped("RegisteredComponentInstanceRecord")
        self.assert_not_wrapped("platform68k")
        self.assert_not_wrapped("platformPowerPC")
        self.assert_not_wrapped("platformInterpreted")
        self.assert_not_wrapped("platformWin32")
        self.assert_not_wrapped("platformPowerPCNativeEntryPoint")
        self.assert_not_wrapped("platformIA32NativeEntryPoint")
        self.assert_not_wrapped("platformPowerPC64NativeEntryPoint")
        self.assert_not_wrapped("platformX86_64NativeEntryPoint")
        self.assert_not_wrapped("platformArm64NativeEntryPoint")
        self.assert_not_wrapped("platformIRIXmips")
        self.assert_not_wrapped("platformSunOSsparc")
        self.assert_not_wrapped("platformSunOSintel")
        self.assert_not_wrapped("platformLinuxppc")
        self.assert_not_wrapped("platformLinuxintel")
        self.assert_not_wrapped("platformAIXppc")
        self.assert_not_wrapped("platformNeXTIntel")
        self.assert_not_wrapped("platformNeXTppc")
        self.assert_not_wrapped("platformNeXTsparc")
        self.assert_not_wrapped("platformNeXT68k")
        self.assert_not_wrapped("platformMacOSx86")
        self.assert_not_wrapped("mpWorkFlagDoWork")
        self.assert_not_wrapped("mpWorkFlagDoCompletion")
        self.assert_not_wrapped("mpWorkFlagCopyWorkBlock")
        self.assert_not_wrapped("mpWorkFlagDontBlock")
        self.assert_not_wrapped("mpWorkFlagGetProcessorCount")
        self.assert_not_wrapped("mpWorkFlagGetIsRunning")
        self.assert_not_wrapped("cmpAliasNoFlags")
        self.assert_not_wrapped("cmpAliasOnlyThisFile")
        self.assert_not_wrapped("kCSAcceptAllComponentsMode")
        self.assert_not_wrapped("kCSAcceptThreadSafeComponentsOnlyMode")
        self.assert_not_wrapped("CSSetComponentsThreadMode")
        self.assert_not_wrapped("CSGetComponentsThreadMode")
        self.assert_not_wrapped("ComponentMPWorkFunctionHeaderRecord;")
        self.assert_not_wrapped("NewComponentFunctionUPP")
        self.assert_not_wrapped("DisposeComponentFunctionUPP")
        self.assert_not_wrapped("CallComponentUPP")
        self.assert_not_wrapped("ComponentCallNow")
        self.assert_not_wrapped("RegisterComponent")
        self.assert_not_wrapped("RegisterComponentResource")
        self.assert_not_wrapped("UnregisterComponent")
        self.assert_not_wrapped("FindNextComponent")
        self.assert_not_wrapped("CountComponents")
        self.assert_not_wrapped("GetComponentInfo")
        self.assert_not_wrapped("GetComponentListModSeed")
        self.assert_not_wrapped("GetComponentTypeModSeed")
        self.assert_not_wrapped("OpenAComponent")
        self.assert_not_wrapped("OpenComponent")
        self.assert_not_wrapped("CloseComponent")
        self.assert_not_wrapped("GetComponentInstanceError")
        self.assert_not_wrapped("ResolveComponentAlias")
        self.assert_not_wrapped("GetComponentPublicResource")
        self.assert_not_wrapped("GetComponentPublicResourceList")
        self.assert_not_wrapped("GetComponentPublicIndString")
        self.assert_not_wrapped("SetComponentInstanceError")
        self.assert_not_wrapped("GetComponentRefcon")
        self.assert_not_wrapped("SetComponentRefcon")
        self.assert_not_wrapped("OpenComponentResFile")
        self.assert_not_wrapped("OpenAComponentResFile")
        self.assert_not_wrapped("CloseComponentResFile")
        self.assert_not_wrapped("GetComponentResource")
        self.assert_not_wrapped("GetComponentIndString")
        self.assert_not_wrapped("GetComponentInstanceStorage")
        self.assert_not_wrapped("SetComponentInstanceStorage")
        self.assert_not_wrapped("CountComponentInstances")
        self.assert_not_wrapped("CallComponentFunction")
        self.assert_not_wrapped("CallComponentFunctionWithStorage")
        self.assert_not_wrapped("CallComponentFunctionWithStorageProcInfo")
        self.assert_not_wrapped("DelegateComponentCall")
        self.assert_not_wrapped("SetDefaultComponent")
        self.assert_not_wrapped("OpenDefaultComponent")
        self.assert_not_wrapped("OpenADefaultComponent")
        self.assert_not_wrapped("CaptureComponent")
        self.assert_not_wrapped("UncaptureComponent")
        self.assert_not_wrapped("RegisterComponentResourceFile")
        self.assert_not_wrapped("GetComponentIconSuite")
        self.assert_not_wrapped("RegisterComponentFile")
        self.assert_not_wrapped("RegisterComponentFileEntries")
        self.assert_not_wrapped("RegisterComponentFileRefEntries")
        self.assert_not_wrapped("ComponentFunctionImplemented")
        self.assert_not_wrapped("GetComponentVersion")
        self.assert_not_wrapped("ComponentSetTarget")
        self.assert_not_wrapped("CallComponentOpen")
        self.assert_not_wrapped("CallComponentClose")
        self.assert_not_wrapped("CallComponentCanDo")
        self.assert_not_wrapped("CallComponentVersion")
        self.assert_not_wrapped("CallComponentRegister")
        self.assert_not_wrapped("CallComponentTarget")
        self.assert_not_wrapped("CallComponentUnregister")
        self.assert_not_wrapped("CallComponentGetMPWorkFunction")
        self.assert_not_wrapped("CallComponentGetPublicResource")
        self.assert_not_wrapped("CallComponentDispatch")
        self.assert_not_wrapped("NewComponentMPWorkFunctionUPP")
        self.assert_not_wrapped("NewComponentRoutineUPP")
        self.assert_not_wrapped("NewGetMissingComponentResourceUPP")
        self.assert_not_wrapped("DisposeComponentMPWorkFunctionUPP")
        self.assert_not_wrapped("DisposeComponentRoutineUPP")
        self.assert_not_wrapped("DisposeGetMissingComponentResourceUPP")
        self.assert_not_wrapped("InvokeComponentMPWorkFunctionUPP")
        self.assert_not_wrapped("InvokeComponentRoutineUPP")
        self.assert_not_wrapped("InvokeGetMissingComponentResourceUPP")
        self.assert_not_wrapped("NewComponentMPWorkFunctionUPP")
        self.assert_not_wrapped("NewComponentRoutineUPP")
        self.assert_not_wrapped("NewGetMissingComponentResourceUPP")
        self.assert_not_wrapped("DisposeComponentMPWorkFunctionUPP")
        self.assert_not_wrapped("DisposeComponentRoutineUPP")
        self.assert_not_wrapped("DisposeGetMissingComponentResourceUPP")
        self.assert_not_wrapped("InvokeComponentMPWorkFunctionUPP")
        self.assert_not_wrapped("InvokeComponentRoutineUPP")
        self.assert_not_wrapped("InvokeGetMissingComponentResourceUPP")
        self.assert_not_wrapped("uppComponentFunctionImplementedProcInfo")
        self.assert_not_wrapped("uppGetComponentVersionProcInfo")
        self.assert_not_wrapped("uppComponentSetTargetProcInfo")
        self.assert_not_wrapped("uppCallComponentOpenProcInfo")
        self.assert_not_wrapped("uppCallComponentCloseProcInfo")
        self.assert_not_wrapped("uppCallComponentCanDoProcInfo")
        self.assert_not_wrapped("uppCallComponentVersionProcInfo")
        self.assert_not_wrapped("uppCallComponentRegisterProcInfo")
        self.assert_not_wrapped("uppCallComponentTargetProcInfo")
        self.assert_not_wrapped("uppCallComponentUnregisterProcInfo")
        self.assert_not_wrapped("uppCallComponentGetMPWorkFunctionProcInfo")
        self.assert_not_wrapped("uppCallComponentGetPublicResourceProcInfo")
