/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.assignment.functor;

import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.contour.AbstractContourBucket;
import com.projectlibre1.pm.assignment.contour.ContourBucketIntervalGenerator;
import com.projectlibre1.pm.assignment.functor.AssignmentFieldFunctor;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.time.HasStartAndEnd;

public class PercentAllocFunctor
extends AssignmentFieldFunctor {
    private long work = 0L;
    double maximumUnits = Double.MAX_VALUE;

    private PercentAllocFunctor(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator, boolean bl) {
        super(assignment, workCalendar, contourBucketIntervalGenerator);
        if (bl) {
            this.maximumUnits = assignment.getResource().getMaximumUnits();
        }
    }

    @Override
    public void execute(Object object) {
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        AbstractContourBucket abstractContourBucket = (AbstractContourBucket)this.contourBucketIntervalGenerator.current();
        if (abstractContourBucket != null) {
            long l = this.workCalendar.compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
            this.work += l;
            this.value += abstractContourBucket.getEffectiveUnits(this.assignment.getUnits()) * (double)l;
        }
    }

    @Override
    public double getValue() {
        if (this.work == 0L) {
            return 0.0;
        }
        return Math.min(this.value / (double)this.work, this.maximumUnits);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.work = 0L;
    }

    public static PercentAllocFunctor getInstance(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator, boolean bl) {
        return new PercentAllocFunctor(assignment, workCalendar, contourBucketIntervalGenerator, bl);
    }
}

