import * as linguistLanguages from "linguist-languages";
import createLanguage from "../utilities/create-language.js";

// A list of files that are commonly generated by tools and should not be
// formatted by the default JSON parser to avoid unwanted diffs.
// These files are either formatted by the `json-stringify` parser or ignored.
const ignoredFilenames = new Set([
  // Bazel
  "MODULE.bazel.lock",
  // Swift
  "Package.resolved",
  // Pipenv
  "Pipfile.lock",
  // Bun's text lockfile
  "bun.lock",
  // Composer
  "composer.lock",
  // Deno
  "deno.lock",
  // Nix
  "flake.lock",
  // Minecraft Forge
  "mcmod.info",
]);

const languages = [
  createLanguage(linguistLanguages.JSON, () => ({
    name: "JSON.stringify",
    parsers: ["json-stringify"],
    vscodeLanguageIds: ["json"],
    extensions: [".importmap"], // .json file defaults to json instead of json-stringify
    filenames: ["package.json", "package-lock.json", "composer.json"],
  })),
  createLanguage(linguistLanguages.JSON, (data) => ({
    parsers: ["json"],
    vscodeLanguageIds: ["json"],
    extensions: data.extensions.filter((extension) => extension !== ".jsonl"),
    filenames: [
      ...data.filenames.filter((filename) => !ignoredFilenames.has(filename)),
      ".babelrc",
      ".jscsrc",
      ".jshintrc",
      ".jslintrc",
      ".swcrc",
    ],
  })),
  createLanguage(linguistLanguages["JSON with Comments"], () => ({
    parsers: ["jsonc"],
    vscodeLanguageIds: ["jsonc"],
    filenames: [],
  })),
  createLanguage(linguistLanguages.JSON5, () => ({
    parsers: ["json5"],
    vscodeLanguageIds: ["json5"],
  })),
];

export default languages;
