------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--            POLYORB.SECURITY.TRANSPORT_MECHANISMS.UNPROTECTED             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2005-2012, Free Software Foundation, Inc.          --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.                                               --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

pragma Ada_2012;

package body PolyORB.Security.Transport_Mechanisms.Unprotected is

   -----------------
   -- Is_Supports --
   -----------------

   overriding function Is_Supports
     (Mechanism   : access Unprotected_Transport_Mechanism;
      Credentials :        PolyORB.Security.Credentials.Credentials_Ref)
      return Boolean
   is
      pragma Unreferenced (Mechanism);
      pragma Unreferenced (Credentials);

   begin
      return False;
   end Is_Supports;

   ---------------------
   -- Target_Requires --
   ---------------------

   overriding function Target_Requires
     (Mechanism : access Unprotected_Transport_Mechanism)
      return PolyORB.Security.Types.Association_Options
   is
      pragma Unreferenced (Mechanism);

   begin
      return 0;
   end Target_Requires;

   ---------------------
   -- Target_Supports --
   ---------------------

   overriding function Target_Supports
     (Mechanism : access Unprotected_Transport_Mechanism)
      return PolyORB.Security.Types.Association_Options
   is
      pragma Unreferenced (Mechanism);

   begin
      return 0;
   end Target_Supports;

end PolyORB.Security.Transport_Mechanisms.Unprotected;
