//// VBARS - do a vertical bar graph 

//// set defaults..
// bars1 specific parms..
#setifnotgiven barwidth = ""
#setifnotgiven xnumeric = ""
#setifnotgiven color = orange
#setifnotgiven errcolor = black
#setifnotgiven errwidth = 0.08
#setifnotgiven errthick = 0.5
#setifnotgiven errunder = no
#setifnotgiven erronly = no
#setifnotgiven vals = ""
#setifnotgiven y2 = ""
#setifnotgiven err2 = ""
#setifnotgiven color2 = "powderblue"
#setifnotgiven name = ""
#setifnotgiven name2 = ""
#setifnotgiven errcolor2 = black
#setifnotgiven legend = "min+0.5 max+0.5"
#setifnotgiven sep = 0.15
#setifnotgiven outline = no
#setifnotgiven curve = ""
#setifnotgiven order = 5
#setifnotgiven crossover = ""
// standard parms..
#setifnotgiven title = ""
#setifnotgiven yrange = ""
#setifnotgiven err = ""
#setifnotgiven id = ""
#setifnotgiven xinc = ""
#setifnotgiven yinc = ""
#setifnotgiven xlbl = ""
#setifnotgiven ylbl = ""
#setifnotgiven delim = ""
#setifnotgiven comment = ""
#setifnotgiven ygrid = ""
#setifnotgiven xgrid = ""
#setifnotgiven xlbldet = ""
#setifnotgiven ylbldet = ""
#setifnotgiven titledet = ""
#setifnotgiven ylog = ""
#setifnotgiven xlog = ""
#setifnotgiven select = ""
#setifnotgiven include1 = ""
#setifnotgiven include2 = ""

#musthave data


//// read data file..
#proc getdata
file: @data
#if @data = stdin
  standardinput: yes
#endif
#if @delim != ""
  delim: @delim
#endif
#if @header = yes
  fieldnameheader: yes
#endif
#if @comment != ""
  commentchar: @comment
#endif
select: @select
 
#proc endproc

#musthave x y

#if @NRECORDS = 0
  #exit
#endif

#proc print
label: Got @NRECORDS records, @NFIELDS fields per record.  

//// set default grid
#if @xgrid = yes
  #set xgrid = "color=tan1"
#endif
#if @ygrid = yes
  #set ygrid = "color=tan1"
#endif


//// set up plotting area..
#proc areadef
#if @ylog != ""
  yscaletype: @ylog
#endif
#if @xlog != ""
  xscaletype: @xlog
#endif
rectangle: 1 2 5.5 4
#if @autow = yes
  autowidth: 0.5 4.0 8.0
#endif
#if @xnumeric = yes
  xautorange: datafield=@x incmult=2.0
  xaxis.stubs: inc @xinc
#else
  xscaletype: categories
  xcategories: datafield=@x
  xaxis.stubs: usecategories
  #if @stubvert = yes
    xaxis.stubvert: yes
  #endif
#endif
xaxis.stubcull: yes

#if @yrange = ""
  #if @y2 = ""
    yautorange: datafields=@y,@err combomode=hilo incmult=2.0 
  #else
    yautorange: datafields=@y,@y2 incmult=2.0 
  #endif
#elseif @yrange = 0
  #if @y2 = ""
    yautorange: datafields=@y,@err combomode=hilo incmult=2.0 lowfix=0
  #else
    yautorange: datafields=@y,@y2 incmult=2.0 lowfix=0
  #endif
#else
  yrange: @yrange
#endif
yaxis.stubs: inc @yinc
yaxis.stubcull: yes
xaxis.label: @xlbl
xaxis.labeldetails: @xlbldet
yaxis.label: @ylbl
yaxis.labeldetails: @ylbldet
#if @xgrid != ""
  xaxis.grid: @xgrid
#endif
#if @ygrid != ""
  yaxis.grid: @ygrid
#endif


//// do title..
#if @title != ""
  #proc annotate
  #set XCENTER = $arith(@AREARIGHT-@AREALEFT/2.0)
  #set XCENTER = $arith(@AREALEFT+@XCENTER)
  location: @XCENTER 4.2
  textdetails: @titledet
  text: @title

#endif

#if @include1 != ""
  #include @include1
#endif


// optional curve behind first bar set 
#if @curve != ""
  #proc curvefit
  xfield: @x
  yfield: @y
  order: @order
  #if @curve = yes
   linedetails: color=pink width=0.5
  #else
   linedetails: @curve
  #endif
#endif



//// begin 1st bar set ////

#if @y2 != ""
  #proc catslide
  axis: x
  amount: -@sep
#endif

//// define errbar proc, do it either before or after..
#procdef bars
locfield: @x
lenfield: @y
errbarfield: @err
thinbarline: color=@errcolor width=@errthick
tails: @errwidth
truncate: yes
#if @erronly = yes
  legendlabel: @name
#endif
#saveas: ERRBARS

//// if error bars are to go under bar graph, do them now..
#if @err != "" && @errunder = yes
  #proc bars
  #clone: ERRBARS
#endif

//// do bar graph
#if @erronly != "yes"
  #proc bars
  locfield: @x
  lenfield: @y
  color: @color
  outline: @outline
  #if @barwidth = line
    thinbarline: color=@color
  #endif
  #if @barwidth != ""
    barwidth: @barwidth
  #endif
  #if @vals = "yes"
    showvalues: yes
  #endif
  legendlabel: @name
  #if @crossover != ""
    crossover: @crossover
  #endif
#endif

//// if error bars are to go on top of bar graph, do them now..
#if @err != "" && @errunder != yes
  #proc bars
  #clone: ERRBARS
#endif

//// data points..
#if @erronly = yes
  #proc scatterplot
  xfield: @x
  yfield: @y
  #set TICLEN = $arith(@errwidth*0.5)
  linelen: 0.02
  linedetails: color=@errcolor width=2
#endif
  


//// begin 2nd bar set ////

#if @y2 != ""
  #proc catslide
  axis: x
  amount: @sep

  //// define errbar proc, do it either before or after..
  #procdef bars
  locfield: @x
  lenfield: @y2
  errbarfield: @err2
  thinbarline: color=@errcolor2 width=@errthick
  tails: @errwidth
  truncate: yes
  #if @erronly = yes
    legendlabel: @name2
  #endif
  #saveas: ERRBARS2

  //// err bars under..
  #if @err != "" && @errunder = yes
    #proc bars
    #clone: ERRBARS2
  #endif

  //// bar graph..
  #if @erronly != "yes"
    #proc bars
    locfield: @x
    lenfield: @y2
    color: @color2
    outline: @outline
    #if @barwidth != ""
      barwidth: @barwidth
    #endif
    #if @vals = "yes"
      showvalues: yes
    #endif
    legendlabel: @name2
    #if @crossover != ""
      crossover: @crossover
    #endif
  #endif
  
  //// err bars over..
  #if @err != "" && @errunder != yes
    #proc bars
    #clone: ERRBARS2
  #endif

  //// data points
  #if @erronly = yes
    #proc scatterplot
    xfield: @x
    yfield: @y2
    #set TICLEN = $arith(@errwidth*0.5)
    linelen: 0.02
    linedetails: color=@errcolor2 width=2
  #endif
  
  //// do legend..
  #if @name != ""
    #proc legend
    location: @legend
  #endif
  
#endif

//// crossover line..
#if @crossover != ""
  #proc line
  linedetails: width=0.5
  points: min @crossover(s) max @crossover(s)
#endif

#if @include2 != ""
  #include @include2
#endif
