//// STACK - do a stacked bar graph 


//// set defaults..
// bars2 parms..
#setifnotgiven barwidth = ""
#setifnotgiven xnumeric = ""
#setifnotgiven y2 = ""
#setifnotgiven y3 = ""
#setifnotgiven y4 = ""
#setifnotgiven color = orange
#setifnotgiven color2 = "powderblue"
#setifnotgiven color3 = "dullyellow"
#setifnotgiven color4 = "drabgreen"
#setifnotgiven name = ""
#setifnotgiven name2 = ""
#setifnotgiven name3 = ""
#setifnotgiven name4 = ""
#setifnotgiven outline = no
// standard parms..
#setifnotgiven title = ""
#setifnotgiven yrange = ""
#setifnotgiven err = ""
#setifnotgiven xinc = ""
#setifnotgiven yinc = ""
#setifnotgiven xlbl = ""
#setifnotgiven ylbl = ""
#setifnotgiven delim = ""
#setifnotgiven comment = ""
#setifnotgiven ygrid = ""
#setifnotgiven xgrid = ""
#setifnotgiven xlbldet = ""
#setifnotgiven ylbldet = ""
#setifnotgiven titledet = ""
#setifnotgiven ylog = ""
#setifnotgiven legend = "min+0.5 max+0.5"
#setifnotgiven select = ""
#setifnotgiven include1 = ""
#setifnotgiven include2 = ""

#musthave data



//// read data file..
#proc getdata
file: @data
#if @data = stdin
  standardinput: yes
#endif
#if @delim != ""
  delim: @delim
#endif
#if @header = yes
  fieldnameheader: yes
#endif
#if @comment != ""
  commentchar: @comment
#endif
select: @select

#proc endproc

#musthave x y

#if @NRECORDS = 0
  #exit
#endif

#proc print
label: Got @NRECORDS records, @NFIELDS fields per record.

//// set default grid
#if @xgrid = yes
  #set xgrid = "color=tan1"
#endif
#if @ygrid = yes
  #set ygrid = "color=tan1"
#endif




//// set up plotting area..
#proc areadef
#if @ylog != ""
  yscaletype: @ylog
#endif
#if @xlog != ""
  xscaletype: @xlog
#endif
rectangle: 1 2 5.5 4
#if @autow = yes
  autowidth: 0.5 4.0 8.0
#endif
#if @xnumeric = yes
  xautorange: datafield=@x incmult=2.0
  xaxis.stubs: inc @xinc
#else
  xscaletype: categories
  xcategories: datafield=@x
  xaxis.stubs: usecategories
  #if @stubvert = yes
    xaxis.stubvert: yes
  #endif
#endif
xaxis.stubcull: yes

#if @yrange = ""
  yautorange: datafields=@y,@y2,@y3,@y4 combomode=stack incmult=2.0 
#elseif @yrange = 0
  yautorange: datafields=@y,@y2,@y3,@y4 combomode=stack incmult=2.0 lowfix=0
#else
  yrange: @yrange
#endif
yaxis.stubs: inc @yinc
yaxis.stubcull: yes
xaxis.label: @xlbl
xaxis.labeldetails: @xlbldet
yaxis.label: @ylbl
yaxis.labeldetails: @ylbldet
#if @xgrid != ""
  xaxis.grid: @ygrid
#endif
#if @ygrid != ""
  yaxis.grid: @ygrid
#endif



//// do title..
#if @title != ""
  #proc annotate
  #set XCENTER = $arith(@AREARIGHT-@AREALEFT/2.0)
  #set XCENTER = $arith(@AREALEFT+@XCENTER)
  location: @XCENTER 4.2
  textdetails: @titledet
  text: @title

#endif


#if @include1 != ""
  #include @include1
#endif


//// do 1st level bars..
#proc bars
locfield: @x
lenfield: @y
color: @color
outline: @outline
#if @barwidth != ""
  barwidth: @barwidth
#endif
legendlabel: @name

//// 2nd level bars..
#if @y2 != ""
  #proc bars
  locfield: @x
  lenfield: @y2
  stackfields: *
  color: @color2
  outline: @outline
  #if @barwidth != ""
    barwidth: @barwidth
  #endif
  legendlabel: @name2
#endif

//// 3rd level bars..
#if @y3 != ""
  #proc bars
  locfield: @x
  lenfield: @y3
  stackfields: *
  color: @color3
  outline: @outline
  #if @barwidth != ""
    barwidth: @barwidth
  #endif
  legendlabel: @name3
#endif

//// 4th level bars..
#if @y4 != ""
  #proc bars
  locfield: @x
  lenfield: @y4
  stackfields: *
  color: @color4
  outline: @outline
  #if @barwidth != ""
    barwidth: @barwidth
  #endif
  legendlabel: @name4
#endif

//// legend..
#if @name != ""
#proc legend
location: @legend
#endif

#if @include2 != ""
  #include @include2
#endif
