//// LINES - do line graph 


//// set defaults..
#setifnotgiven title = ""
#setifnotgiven yrange = ""
#setifnotgiven err = ""
#setifnotgiven xinc = ""
#setifnotgiven yinc = ""
#setifnotgiven cats = ""
#setifnotgiven xlbl = ""
#setifnotgiven ylbl = ""
#setifnotgiven delim = ""
#setifnotgiven comment = ""
#setifnotgiven errcolor = black
#setifnotgiven errwidth = 0.08
#setifnotgiven errthick = 0.5
#setifnotgiven ygrid = ""
#setifnotgiven xgrid = ""
#setifnotgiven y2 = ""
#setifnotgiven y3 = ""
#setifnotgiven y4 = ""
#setifnotgiven err2 = ""
#setifnotgiven err3 = ""
#setifnotgiven err4 = ""
#setifnotgiven name = ""
#setifnotgiven name2 = ""
#setifnotgiven name3 = ""
#setifnotgiven name4 = ""
#setifnotgiven legend = "min+0.5 min-0.5"
#setifnotgiven xlbldet = ""
#setifnotgiven ylbldet = ""
#setifnotgiven titledet = ""
#setifnotgiven ylog = ""
#setifnotgiven xlog = ""
#setifnotgiven linedet = "color=red"
#setifnotgiven linedet2 = "color=blue"
#setifnotgiven linedet3 = "color=green"
#setifnotgiven linedet4 = "color=orange"
#setifnotgiven pointsym = "shape=square style=outline fillcolor=white"
#setifnotgiven pointsym2 = "shape=triangle style=outline fillcolor=white"
#setifnotgiven pointsym3 = "shape=diamond style=outline fillcolor=white"
#setifnotgiven pointsym4 = "shape=downtriangle style=outline fillcolor=white"
#setifnotgiven step = ""
#setifnotgiven select = ""
#setifnotgiven include1 = ""
#setifnotgiven include2 = ""
#setifnotgiven fill = ""

#musthave data



//// read data file..
#proc getdata
file: @data
#if @data = stdin
  standardinput: yes
#endif
#if @delim != ""
  delim: @delim
#endif
#if @header = yes
  fieldnameheader: yes
#endif
#if @comment != ""
  commentchar: @comment
#endif
select: @select
  
#proc endproc

#musthave x y

#if @NRECORDS = 0
  #exit
#endif

#proc print
label: Got @NRECORDS records, @NFIELDS fields per record.

//// set default grid
#if @xgrid = yes
  #set xgrid = "color=tan1"
#endif
#if @ygrid = yes
  #set ygrid = "color=tan1"
#endif


//// set up plotting area..
#proc areadef
#if @ylog != ""
  yscaletype: @ylog
#endif
#if @xlog != ""
  xscaletype: @xlog
#endif
rectangle: 1 2 5.5 4
#if @autow = yes
  autowidth: 0.5 4.0 8.0
#endif
#if @cats = ""
  xautorange: datafield=@x incmult=2.0
  xaxis.stubs: inc @xinc
#else
  xscaletype: categories
  xcategories: datafield=@x
  xaxis.stubs: usecategories
  #if @stubvert = yes
    xaxis.stubvert: yes
  #endif
#endif
xaxis.stubcull: yes

#if @yrange = ""
  #if @y2 = ""
    yautorange: datafields=@y,@err combomode=hilo incmult=2.0 
  #else
    yautorange: datafields=@y,@y2 incmult=2.0 
  #endif
#elseif @yrange = 0
  #if @y2 = ""
    yautorange: datafields=@y,@err combomode=hilo incmult=2.0 lowfix=0
  #else
    yautorange: datafields=@y,@y2 incmult=2.0 lowfix=0
  #endif
#else
  yrange: @yrange
#endif
yaxis.stubs: inc @yinc
yaxis.stubcull: yes
xaxis.label: @xlbl
xaxis.labeldetails: @xlbldet
yaxis.label: @ylbl
yaxis.labeldetails: @ylbldet
#if @xgrid != ""
  xaxis.grid: @ygrid
#endif
#if @ygrid != ""
  yaxis.grid: @ygrid
#endif

// do title
#if @title != ""
  #proc annotate
  #set XCENTER = $arith(@AREARIGHT-@AREALEFT/2.0)
  #set XCENTER = $arith(@AREALEFT+@XCENTER)
  location: @XCENTER 4.2
  textdetails: @titledet
  text: @title
#endif

#if @include1 != ""
  #include @include1
#endif

// turn off point symbols if doing stairsteps..
#if @step = yes
  #set pointsym = ""
  #set pointsym2 = ""
  #set pointsym3 = ""
  #set pointsym4 = ""
#endif

//// do error bar for group 1
#if @err != ""
 #proc bars
  locfield: @x
  lenfield: @y
  errbarfield: @err
  thinbarline: color=@errcolor width=@errthick
  tails: @errwidth
  truncate: yes
#endif

//// do line plot for group 1
#proc lineplot
xfield: @x
yfield: @y
#if @step = yes
  stairstep: @step
  lastseglen: 0.2
#endif
#if @fill = yes
  #set FILLCOLOR = $change( "color=", "", @linedet )
  fill: @FILLCOLOR
#else
  linedetails: @linedet
#endif
legendlabel: @name
pointsymbol: @pointsym
#if @pointsym = none
  legendsampletype: line
#else
  legendsampletype: line+symbol
#endif

  
//// do error bars and line for group 2
#if @y2 != ""

  #if @err2 != ""
    #proc bars
    locfield: @x
    lenfield: @y2
    errbarfield: @err2
    thinbarline: color=@errcolor width=@errthick
    tails: @errwidth
    truncate: yes
  #endif

  #proc lineplot
  xfield: @x
  yfield: @y2
  legendlabel: @name2
  #if @fill = yes
    #set FILLCOLOR = $change( "color=", "", @linedet2 )
    fill: @FILLCOLOR
  #else
    linedetails: @linedet2
  #endif
  #if @step = yes
    stairstep: @step
    lastseglen: 0.2
  #endif
  pointsymbol: @pointsym2
  #if @pointsym2 = none
    legendsampletype: line
  #else
    legendsampletype: line+symbol
  #endif
#endif


//// do error bars and line for group 3
#if @y3 != ""

  #if @err3 != ""
    #proc bars
    locfield: @x
    lenfield: @y3
    errbarfield: @err3
    thinbarline: color=@errcolor width=@errthick
    tails: @errwidth
    truncate: yes
  #endif

  #proc lineplot
  xfield: @x
  yfield: @y3
  legendlabel: @name3
  #if @fill = yes
    #set FILLCOLOR = $change( "color=", "", @linedet3 )
    fill: @FILLCOLOR
  #else
    linedetails: @linedet3
  #endif
  #if @step = yes
    stairstep: @step
    lastseglen: 0.2
  #endif
  pointsymbol: @pointsym3
  #if @pointsym3 = none
    legendsampletype: line
  #else
    legendsampletype: line+symbol
  #endif
#endif


//// do error bars and line for group 4
#if @y4 != ""

  #if @err4 != ""
    #proc bars
    locfield: @x
    lenfield: @y4
    errbarfield: @err4
    thinbarline: color=@errcolor width=@errthick
    tails: @errwidth
    truncate: yes
  #endif

  #proc lineplot
  xfield: @x
  yfield: @y4
  legendlabel: @name4
  #if @fill = yes
    #set FILLCOLOR = $change( "color=", "", @linedet4 )
    fill: @FILLCOLOR
  #else
    linedetails: @linedet4
  #endif
  #if @step = yes
    stairstep: @step
    lastseglen: 0.2
  #endif
  pointsymbol: @pointsym4
  #if @pointsym4 = none
    legendsampletype: line
  #else
    legendsampletype: line+symbol
  #endif
  
#endif
  

// do legend
#if @name != ""
  #proc legend
  location: @legend
#endif

#if @include2 != ""
  #include @include2
#endif
