//// DIST - frequency distribution

//// set defaults..
#setifnotgiven binsize = ""
#setifnotgiven color = "pink"
#setifnotgiven barwidth = ""
#setifnotgiven savetbl = ""
#setifnotgiven cats = ""
#setifnotgiven order = "natural"

#setifnotgiven delim = ""
#setifnotgiven comment = ""
#setifnotgiven title = ""
#setifnotgiven xlbl = ""
#setifnotgiven xrange = ""
#setifnotgiven xinc = ""
#setifnotgiven xgrid = ""
#setifnotgiven ylbl = ""
#setifnotgiven yrange = ""
#setifnotgiven yinc = ""
#setifnotgiven ygrid = ""
#setifnotgiven stubvert = ""
#setifnotgiven xlbldet = ""
#setifnotgiven ylbldet = ""
#setifnotgiven titledet = ""
#setifnotgiven xlog = ""
#setifnotgiven ylog = ""
#setifnotgiven select = ""
#setifnotgiven include1 = ""
#setifnotgiven include2 = ""

#musthave data



//// read data file..
#proc getdata
file: @data
#if @data = stdin
  standardinput: yes
#endif
#if @delim != ""
  delim: @delim
#endif
#if @header = yes
  fieldnameheader: yes
#endif
#if @comment != ""
  commentchar: @comment
#endif
select: @select
  
#proc endproc

#musthave fld

#if @NRECORDS = 0
  #exit
#endif

#proc print
label: Got @NRECORDS records, @NFIELDS fields per record.



//// do title..
#if @title != ""
  #proc annotate
  #set XCENTER = $arith(@AREARIGHT-@AREALEFT/2.0)
  #set XCENTER = $arith(@AREALEFT+@XCENTER)
  location: @XCENTER 4.2
  textdetails: @titledet
  text: @title
#endif

#if @include1 != ""
  #include @include1
#endif


//// set default grid
#if @xgrid = yes
  #set xgrid = "color=tan1"
#endif
#if @ygrid = yes
  #set ygrid = "color=tan1"
#endif



//// set up plotting area..
#set RECT = "1 2 4.5 4
#proc areadef
rectangle: @RECT
#if @autow = yes
  autowidth: 0.13 4.0 8.0
#endif
#if @cats = yes
  xscaletype: categories
  xcategories: datafield=@fld
#elseif @xrange = ""
  xautorange: datafield=@fld
#else
  xrange: @xrange
#endif
yrange: 0 100   // to be revised after we run the distribution..

#proc xaxis
// for categories, stubs have to be done after the distribution is run below..
#if @cats != yes
  stubs: inc @xinc
  stubcull: yes
  stubdetails: size=8
#endif
label: @xlbl
labeldetails: @xlbldet
#if @xgrid != ""
  grid: @xgrid
#endif
#proc endproc 

#if @binsize = ""
  #set binsize = $arith( @XINC/2 ) 
#endif

//// tabulate the distribution of values, e.g. how many strains fell into each bin
#proc tabulate
datafield1: @fld
#if @cats != yes
  doranges1: yes
  rangespec1: @XMIN @binsize
  showrange: avg
#else
  order1: @order
#endif
#if @savetbl != ""
  savetable: @savetbl
#endif

//// now that we have the distribution, recompute the plotting area with a auto Y range
#proc areadef
#if @xlog != ""
  xscaletype: @xlog
#endif
#if @ylog != ""
  yscaletype: @ylog
#endif
rectangle: @RECT
#if @autow = yes
  autowidth: 0.13 4.0 8.0
#endif
#if @yrange = ""
  yautorange: datafield=2
#elseif @yrange = 0
  yautorange: datafield=2 lowfix=0
#else
  yrange: @yrange
#endif
#if @cats = yes
  xscaletype: categories
  xcategories: datafield=1
#else
  xrange: @XMIN @XMAX
#endif

#proc yaxis
stubs: inc @yinc
stubcull: yes
stubdetails: size=8
label: @ylbl
labeldetails: @ylbldet
#if @ygrid != ""
  grid: @ygrid
#endif

#if @cats = yes
  #proc xaxis
  stubs: usecategories
  stubdetails: size=8
  #if @stubvert = yes
    stubvert: yes
  #endif
#endif



//// do the background curve..
#if @curve = yes && @NRECORDS > 6
  #proc curvefit
  curvetype: bspline
  xfield: 1
  yfield: 2
  order: 5
  linedetails: color=gray(0.5) width=0.5
#endif


//// do the bars..
#proc bars
locfield: 1
lenfield: 2
color: @color
#if @barwidth != ""
  barwidth: @barwidth
#endif
outline: no
hidezerobars: yes

#if @include2 != ""
  #include @include2
#endif
