/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PLINK_Execute
extends JDialog {
    private static Logger logger = Logger.getLogger(PLINK_Execute.class);
    private JTextField command;
    private JTextField discription;
    private GPLINK frame;

    public PLINK_Execute(GPLINK givenFrame, String cmd) {
        super((Frame)givenFrame, "Execute Command");
        if (!cmd.matches(".*\\-\\-gplink.*")) {
            logger.info("[PLINK_Execute(GPLINK,String)] adding \"--gplink\" to the end");
            cmd = String.valueOf(cmd) + " --gplink";
        }
        this.frame = givenFrame;
        this.command = new JTextField(80);
        this.command.setText(cmd);
        this.discription = new JTextField(30);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        this.getContentPane().add((Component)new JLabel("PLINK command:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)this.command, c);
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        this.getContentPane().add((Component)new JLabel("Command description"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)this.discription, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 0.0;
        JPanel buttons = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PLINK_Execute.this.addOperation()) {
                    new Thread(new RunCommand(PLINK_Execute.this.command.getText(), ((PLINK_Execute)PLINK_Execute.this).frame.data)).start();
                } else {
                    logger.warn("[PLINK_Execute(GPLINK, String)] can not add operation, not executing command.");
                    new PLINK_Execute(PLINK_Execute.this.frame, PLINK_Execute.this.command.getText());
                }
                PLINK_Execute.this.dispose();
            }
        });
        buttons.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLINK_Execute.this.dispose();
            }
        });
        buttons.add(cancel);
        this.getContentPane().add((Component)buttons, c);
        this.pack();
        this.setVisible(true);
    }

    private boolean addOperation() {
        String[] parsedCmd = RunCommand.stripAndSplit(this.command.getText());
        String cline = this.command.getText();
        String opDisc = this.discription.getText();
        Vector<String[]> outfiles = new Vector<String[]>();
        Vector<String[]> infiles = new Vector<String[]>();
        String opName = null;
        boolean flag_bfile = false;
        boolean flag_file = false;
        boolean flag_out = false;
        String[] stringArray = parsedCmd;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String element = stringArray[n];
            if (flag_out) {
                opName = FileInfo.fileName(element);
                flag_out = false;
            } else if (flag_bfile) {
                infiles.add(new String[]{String.valueOf(element) + ".bim", ""});
                infiles.add(new String[]{String.valueOf(element) + ".bed", ""});
                infiles.add(new String[]{String.valueOf(element) + ".fam", ""});
                flag_bfile = false;
            } else if (flag_file) {
                infiles.add(new String[]{String.valueOf(element) + ".map", ""});
                infiles.add(new String[]{String.valueOf(element) + ".ped", ""});
                flag_file = false;
            } else if (!(!element.contains(".") || element.endsWith(".exe") || element.endsWith(".exe\"") || element.endsWith("plink") || element.endsWith("plink\"") || element.matches("^\\d*\\.?\\d+$"))) {
                infiles.add(new String[]{element, ""});
            }
            flag_file = element.equals("--file");
            flag_bfile = element.equals("--bfile");
            flag_out = element.equals("--out");
            ++n;
        }
        if (opName != null && this.frame.data.getOp(opName) == null) {
            logger.info("(addOperation) " + opName);
            this.frame.data.addOperation(opName, opDisc, cline, null, infiles, outfiles);
            return true;
        }
        logger.warn("(addOperation) no operation name found or the operation name is not unique!");
        this.frame.messanger.createError("Command line must specify a unique output root via the --out flag.", "addOperation()@PLINK_Execute.java");
        return false;
    }
}

