/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.general;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextArea;

public class ErrorManager {
    private JFrame rootFrame;
    private static int max_line_length = 40;

    public ErrorManager(JFrame givenFrame) {
        this.rootFrame = givenFrame;
    }

    private static String wrap(String text) {
        if (text.length() > max_line_length) {
            int end = text.length();
            int index = 0;
            int i = 0;
            while (i < end) {
                if (text.charAt(index) == '\n') {
                    index = 0;
                } else if (++index > max_line_length && text.charAt(i) == ' ') {
                    text = String.valueOf(text.substring(0, i)) + " \n" + text.substring(i + 1, text.length());
                    index = 0;
                }
                ++i;
            }
        }
        return text;
    }

    public void createError(String message, String citation) {
        new myDialog(this.rootFrame, "gPLINK error", ErrorManager.wrap(message));
    }

    public void createMessage(String message, String citation) {
        new myDialog(this.rootFrame, "gPLINK message", ErrorManager.wrap(message));
    }

    private class myDialog
    extends JDialog {
        public myDialog(JFrame root, String title, String message) {
            super((Frame)root, title);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            JTextArea text = new JTextArea(message);
            text.setEditable(false);
            this.getContentPane().add((Component)text, c);
            c.gridy = 1;
            JButton ok = new JButton("OK");
            ok.setAlignmentX(0.5f);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    myDialog.this.dispose();
                }
            });
            this.getContentPane().add((Component)ok, c);
            this.pack();
            this.setVisible(true);
            this.setAlwaysOnTop(true);
        }
    }
}

